/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.io;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.io.KryoExternalizerServiceMBean;
import jp.ossc.nimbus.service.io.SerializableExternalizerService;

public class KryoExternalizerService
extends SerializableExternalizerService
implements KryoExternalizerServiceMBean,
Externalizer,
Serializable {
    private static final long serialVersionUID = 4705570169021024055L;
    private Class[] registerClasses;
    private Properties defaultSerializerMapping;
    private Map defaultSerializerMap;
    private transient ThreadLocal kryoThreadLocal;

    public void setRegisterClasses(Class[] classes) {
        this.registerClasses = classes;
    }

    public Class[] getRegisterClasses() {
        return this.registerClasses;
    }

    @Override
    public void setDefaultSerializerMapping(Properties mapping) {
        this.defaultSerializerMapping = mapping;
    }

    @Override
    public Properties getDefaultSerializerMapping() {
        return this.defaultSerializerMapping;
    }

    public void setDefaultSerializer(String typeName, Serializer serializer) throws ClassNotFoundException {
        this.setDefaultSerializer(Utility.convertStringToClass(typeName), serializer);
    }

    public void setDefaultSerializer(Class type, Serializer serializer) throws ClassNotFoundException {
        this.defaultSerializerMap.put(type, serializer);
    }

    @Override
    public void setObjectOutputClass(Class clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObjectInputClass(Class clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createService() throws Exception {
        super.createService();
        this.kryoThreadLocal = new KryoThreadLocal();
        this.defaultSerializerMap = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        super.startService();
        this.initKryo(new Kryo());
    }

    @Override
    public void destroyService() throws Exception {
        this.kryoThreadLocal = null;
        this.defaultSerializerMap = null;
        super.destroyService();
    }

    @Override
    protected ObjectOutput createObjectOutput(OutputStream out) throws IOException {
        return new KryoObjectOutput(this.getKryo(), out);
    }

    @Override
    protected ObjectInput createObjectInput(InputStream in) throws IOException {
        return new KryoObjectInput(this.getKryo(), in);
    }

    private Kryo getKryo() {
        return (Kryo)this.kryoThreadLocal.get();
    }

    private void initKryo(Kryo kryo) throws Exception {
        if (this.registerClasses != null) {
            for (int i = 0; i < this.registerClasses.length; ++i) {
                kryo.register(this.registerClasses[i]);
            }
        }
        if (this.defaultSerializerMapping != null) {
            for (Map.Entry<Object, Object> entry : this.defaultSerializerMapping.entrySet()) {
                kryo.addDefaultSerializer(Utility.convertStringToClass((String)entry.getKey()), Utility.convertStringToClass((String)entry.getValue()));
            }
        }
        if (this.defaultSerializerMap != null && this.defaultSerializerMap.size() != 0) {
            for (Map.Entry entry : this.defaultSerializerMap.entrySet()) {
                kryo.addDefaultSerializer((Class)entry.getKey(), (Serializer)entry.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.getState() >= 1 && this.getState() != 7) {
            this.kryoThreadLocal = new KryoThreadLocal();
        }
    }

    private static class KryoObjectInput
    implements ObjectInput {
        private Kryo kryo;
        private Input input;
        private DataInputStream din;

        public KryoObjectInput(Kryo kryo, InputStream is) {
            this(kryo, new Input(is));
        }

        public KryoObjectInput(Kryo kryo, Input in) {
            this.kryo = kryo;
            this.input = in;
            this.din = new DataInputStream((InputStream)this.input);
        }

        @Override
        public Object readObject() throws ClassNotFoundException, IOException {
            return this.kryo.readClassAndObject(this.input);
        }

        @Override
        public int read() throws IOException {
            return this.input.readByte();
        }

        @Override
        public byte readByte() throws IOException {
            return this.input.readByte();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.input.readByteUnsigned();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.input.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.input.read(b, off, len);
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            int count;
            for (int n = 0; n < len; n += count) {
                count = this.read(b, off + n, len - n);
                if (count >= 0) continue;
                throw new EOFException();
            }
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.input.readBoolean();
        }

        @Override
        public short readShort() throws IOException {
            return this.input.readShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.input.readShortUnsigned();
        }

        @Override
        public char readChar() throws IOException {
            return this.input.readChar();
        }

        @Override
        public int readInt() throws IOException {
            return this.input.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.input.readLong();
        }

        @Override
        public float readFloat() throws IOException {
            return this.input.readFloat();
        }

        @Override
        public double readDouble() throws IOException {
            return this.input.readDouble();
        }

        @Override
        public String readLine() throws IOException {
            return this.din.readLine();
        }

        @Override
        public String readUTF() throws IOException {
            return this.input.readString();
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return (int)this.input.skip((long)n);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.input.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.input.available();
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }

    private static class KryoObjectOutput
    implements ObjectOutput {
        private Kryo kryo;
        private Output output;

        public KryoObjectOutput(Kryo kryo, OutputStream os) {
            this(kryo, new Output(os));
        }

        public KryoObjectOutput(Kryo kryo, Output out) {
            this.kryo = kryo;
            this.output = out;
        }

        @Override
        public void writeObject(Object obj) throws IOException {
            this.kryo.writeClassAndObject(this.output, obj);
        }

        @Override
        public void write(int b) throws IOException {
            this.output.writeByte(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.output.writeBytes(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.output.writeBytes(b, off, len);
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.output.writeBoolean(v);
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.output.writeByte(v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.output.writeShort(v);
        }

        @Override
        public void writeChar(int v) throws IOException {
            this.output.writeChar((char)v);
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.output.writeInt(v);
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.output.writeLong(v);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.output.writeFloat(v);
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.output.writeDouble(v);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            for (int i = 0; i < s.length(); ++i) {
                this.output.writeByte((int)s.charAt(i));
            }
        }

        @Override
        public void writeChars(String s) throws IOException {
            for (int i = 0; i < s.length(); ++i) {
                this.output.writeChar(s.charAt(i));
            }
        }

        @Override
        public void writeUTF(String s) throws IOException {
            this.output.writeString(s);
        }

        @Override
        public void flush() throws IOException {
            this.output.flush();
        }

        @Override
        public void close() throws IOException {
            this.output.close();
        }
    }

    public static class JavaStandardSerializer
    extends Serializer
    implements Serializable {
        private static final long serialVersionUID = 3913136620807469067L;

        public Object read(Kryo kryo, Input input, Class type) {
            try {
                KryoObjectInput in = new KryoObjectInput(kryo, input);
                int length = in.readInt();
                byte[] bytes = new byte[length];
                in.readFully(bytes);
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
                return ois.readObject();
            }
            catch (Exception e) {
                throw new KryoException("Error during Java deserialization.", (Throwable)e);
            }
        }

        public void write(Kryo kryo, Output output, Object object) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
                oos.flush();
                byte[] bytes = baos.toByteArray();
                output.writeInt(bytes.length);
                output.writeBytes(bytes);
            }
            catch (Exception e) {
                throw new KryoException("Error during Java serialization.", (Throwable)e);
            }
        }
    }

    public static class JavaExternalizableSerializer
    extends Serializer
    implements Serializable {
        private static final long serialVersionUID = -6997034498349804925L;

        public Object read(Kryo kryo, Input input, Class type) {
            try {
                Externalizable ext = (Externalizable)type.newInstance();
                ext.readExternal(new KryoObjectInput(kryo, input));
                return ext;
            }
            catch (Exception e) {
                throw new KryoException("Error during Java deserialization.", (Throwable)e);
            }
        }

        public void write(Kryo kryo, Output output, Object object) {
            try {
                Externalizable ext = (Externalizable)object;
                ext.writeExternal(new KryoObjectOutput(kryo, output));
            }
            catch (Exception e) {
                throw new KryoException("Error during Java serialization.", (Throwable)e);
            }
        }
    }

    private class KryoThreadLocal
    extends ThreadLocal {
        private KryoThreadLocal() {
        }

        protected Object initialValue() {
            Kryo kryo = new Kryo();
            try {
                KryoExternalizerService.this.initKryo(kryo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return kryo;
        }
    }
}

