/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jmx.DefaultMBeanServerConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.jmx.MBeanServerConnectionFactory;
import jp.ossc.nimbus.service.jmx.MBeanServerConnectionFactoryException;
import jp.ossc.nimbus.service.jndi.JndiFinder;

public class DefaultMBeanServerConnectionFactoryService
extends ServiceBase
implements DefaultMBeanServerConnectionFactoryServiceMBean,
MBeanServerConnectionFactory {
    protected ServiceName jndiFinderServiceName;
    protected JndiFinder jndiFinder;
    protected String rmiAdaptorName = "jmx/invoker/RMIAdaptor";
    protected String serviceURL;
    protected Map jmxConnectorEnvironment;
    protected JMXConnector connector;
    protected boolean isConnectOnStart;
    protected boolean isConnected;
    protected boolean isNewConnection = true;

    @Override
    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    @Override
    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    @Override
    public void setRMIAdaptorName(String name) {
        this.rmiAdaptorName = name;
    }

    @Override
    public String getRMIAdaptorName() {
        return this.rmiAdaptorName;
    }

    @Override
    public void setServiceURL(String url) {
        this.serviceURL = url;
    }

    @Override
    public String getServiceURL() {
        return this.serviceURL;
    }

    @Override
    public void setJMXConnectorEnvironment(Map env) {
        this.jmxConnectorEnvironment = env;
    }

    @Override
    public Map getJMXConnectorEnvironment() {
        return this.jmxConnectorEnvironment;
    }

    @Override
    public void setConnectOnStart(boolean isConnect) {
        this.isConnectOnStart = isConnect;
    }

    @Override
    public boolean isConnectOnStart() {
        return this.isConnectOnStart;
    }

    @Override
    public void setNewConnection(boolean isNew) {
        this.isNewConnection = isNew;
    }

    @Override
    public boolean isNewConnection() {
        return this.isNewConnection;
    }

    @Override
    public void startService() throws Exception {
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        } else if (this.serviceURL != null) {
            this.connector = JMXConnectorFactory.newJMXConnector(new JMXServiceURL(this.serviceURL), this.jmxConnectorEnvironment);
            if (this.isConnectOnStart) {
                this.connector.connect();
                if (this.isNewConnection) {
                    this.connector.close();
                    this.connector = null;
                } else {
                    this.isConnected = true;
                }
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.connector != null) {
            this.isConnected = false;
            try {
                this.connector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanServerConnection getConnection() throws MBeanServerConnectionFactoryException {
        MBeanServerConnection connection;
        block15: {
            connection = null;
            try {
                if (this.jndiFinder != null) {
                    connection = (MBeanServerConnection)this.jndiFinder.lookup(this.rmiAdaptorName);
                    break block15;
                }
                if (this.serviceURL != null) {
                    if (this.connector == null) {
                        JMXConnector jMXConnector = this.connector;
                        synchronized (jMXConnector) {
                            if (this.connector == null) {
                                this.connector = JMXConnectorFactory.newJMXConnector(new JMXServiceURL(this.serviceURL), this.jmxConnectorEnvironment);
                                this.connector.connect();
                                this.isConnected = true;
                            }
                        }
                    }
                    if (!this.isConnected) {
                        JMXConnector jMXConnector = this.connector;
                        synchronized (jMXConnector) {
                            if (!this.isConnected) {
                                this.connector.connect();
                                this.isConnected = true;
                            }
                        }
                    }
                    connection = this.connector.getMBeanServerConnection();
                    break block15;
                }
                connection = ManagementFactory.getPlatformMBeanServer();
            }
            catch (IOException e) {
                throw new MBeanServerConnectionFactoryException(e);
            }
            catch (NamingException e) {
                throw new MBeanServerConnectionFactoryException(e);
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMXConnector getJMXConnector() throws MBeanServerConnectionFactoryException {
        if (this.serviceURL != null) {
            JMXConnector connector = this.connector;
            try {
                if (this.isNewConnection) {
                    connector = JMXConnectorFactory.newJMXConnector(new JMXServiceURL(this.serviceURL), this.jmxConnectorEnvironment);
                    connector.connect();
                } else if (!this.isConnected) {
                    JMXConnector jMXConnector = connector;
                    synchronized (jMXConnector) {
                        if (!this.isConnected) {
                            connector.connect();
                            this.isConnected = true;
                        }
                    }
                }
                return connector;
            }
            catch (IOException e) {
                throw new MBeanServerConnectionFactoryException(e);
            }
        }
        return new JMXConnectorWrapper(this.getConnection());
    }

    protected static class JMXConnectorWrapper
    implements JMXConnector {
        protected MBeanServerConnection connection;
        protected boolean isConnected;

        public JMXConnectorWrapper(MBeanServerConnection connection) {
            this.connection = connection;
        }

        @Override
        public void connect() throws IOException {
            this.connect((Map)null);
        }

        public void connect(Map env) throws IOException {
            if (this.isConnected) {
                throw new IOException("Alreaby connected.");
            }
            this.isConnected = true;
        }

        @Override
        public MBeanServerConnection getMBeanServerConnection() throws IOException {
            return this.connection;
        }

        @Override
        public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
            return this.connection;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        }

        @Override
        public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        }

        @Override
        public void removeConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        }

        @Override
        public String getConnectionId() throws IOException {
            return this.connection.toString();
        }
    }
}

