/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jmx;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.AttributeList;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.jmx.MBeanWatcherServiceMBean;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.writer.Category;
import jp.ossc.nimbus.service.writer.MessageWriteException;
import jp.ossc.nimbus.util.converter.Converter;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class MBeanWatcherService
extends ServiceBase
implements DaemonRunnable,
MBeanWatcherServiceMBean {
    private static final long serialVersionUID = -1421073056315791503L;
    protected ServiceName jndiFinderServiceName;
    protected JndiFinder jndiFinder;
    protected String rmiAdaptorName = "jmx/invoker/RMIAdaptor";
    private String serviceURL;
    private Map jmxConnectorEnvironment;
    private long interval;
    private ServiceName categoryServiceName;
    private List targetList;
    private boolean isConnectOnStart;
    private String getValueErrorMessageId = "MBW__00001";
    private String connectErrorMessageId = "MBW__00002";
    private String writeErrorMessageId = "MBW__00003";
    private boolean isMBeanSet;
    private ObjectName objectName;
    private QueryExp queryExp;
    private boolean isResetOnStart;
    private JMXConnector connector;
    private Category category;
    private Daemon watcher;
    private Map contextMap;
    private boolean isConnectError;
    private PropertyAccess propertyAccess;

    @Override
    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    @Override
    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    @Override
    public void setRMIAdaptorName(String name) {
        this.rmiAdaptorName = name;
    }

    @Override
    public String getRMIAdaptorName() {
        return this.rmiAdaptorName;
    }

    @Override
    public void setServiceURL(String url) {
        this.serviceURL = url;
    }

    @Override
    public String getServiceURL() {
        return this.serviceURL;
    }

    @Override
    public void setJMXConnectorEnvironment(Map env) {
        this.jmxConnectorEnvironment = env;
    }

    @Override
    public Map getJMXConnectorEnvironment() {
        return this.jmxConnectorEnvironment;
    }

    @Override
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public void setCategoryServiceName(ServiceName name) {
        this.categoryServiceName = name;
    }

    @Override
    public ServiceName getCategoryServiceName() {
        return this.categoryServiceName;
    }

    @Override
    public void setConnectOnStart(boolean isConnect) {
        this.isConnectOnStart = isConnect;
    }

    @Override
    public boolean isConnectOnStart() {
        return this.isConnectOnStart;
    }

    @Override
    public void setGetValueErrorMessageId(String id) {
        this.getValueErrorMessageId = id;
    }

    @Override
    public String getGetValueErrorMessageId() {
        return this.getValueErrorMessageId;
    }

    @Override
    public void setConnectErrorMessageId(String id) {
        this.connectErrorMessageId = id;
    }

    @Override
    public String getConnectErrorMessageId() {
        return this.connectErrorMessageId;
    }

    @Override
    public void setWriteErrorMessageId(String id) {
        this.writeErrorMessageId = id;
    }

    @Override
    public String getWriteErrorMessageId() {
        return this.writeErrorMessageId;
    }

    @Override
    public void setMBeanSet(boolean isSet) {
        this.isMBeanSet = isSet;
    }

    @Override
    public boolean isMBeanSet() {
        return this.isMBeanSet;
    }

    @Override
    public void setObjectName(String name) throws MalformedObjectNameException {
        this.objectName = new ObjectName(name);
    }

    @Override
    public String getObjectName() {
        return this.objectName == null ? null : this.objectName.toString();
    }

    @Override
    public void setQueryExp(QueryExp exp) {
        this.queryExp = exp;
    }

    @Override
    public QueryExp getQueryExp() {
        return this.queryExp;
    }

    @Override
    public boolean isResetOnStart() {
        return this.isResetOnStart;
    }

    @Override
    public void setResetOnStart(boolean isResetOnStart) {
        this.isResetOnStart = isResetOnStart;
    }

    public void addTarget(Target target) {
        if (this.targetList == null) {
            this.targetList = new ArrayList();
        }
        this.targetList.add(target);
    }

    @Override
    public List getTargetList() {
        return this.targetList;
    }

    @Override
    public void reset() {
        int imax = this.targetList.size();
        for (int i = 0; i < imax; ++i) {
            Target target = (Target)this.targetList.get(i);
            target.reset();
        }
    }

    @Override
    public void createService() throws Exception {
        this.contextMap = Collections.synchronizedMap(new HashMap());
        this.propertyAccess = new PropertyAccess();
        this.propertyAccess.setIgnoreNullProperty(true);
    }

    @Override
    public void startService() throws Exception {
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        } else if (this.serviceURL != null && this.isConnectOnStart) {
            this.connector = JMXConnectorFactory.newJMXConnector(new JMXServiceURL(this.serviceURL), this.jmxConnectorEnvironment);
            this.connector.connect();
        }
        if (this.categoryServiceName != null) {
            this.category = (Category)ServiceManagerFactory.getServiceObject(this.categoryServiceName);
        }
        int imax = this.targetList.size();
        for (int i = 0; i < imax; ++i) {
            Target target = (Target)this.targetList.get(i);
            target.setWatcherServiceName(this.getServiceNameObject());
            target.setWatcherService(this);
            target.setLogger(this.getLogger());
            if (this.isResetOnStart) {
                target.reset();
            }
            target.start();
        }
        if (this.interval > 0L) {
            this.watcher = new Daemon(this);
            this.watcher.setName("Nimbus MBeanWatcher " + this.getServiceNameObject());
            this.watcher.setDaemon(true);
            if (this.connector != null) {
                JMXConnectorNotificationListener listener = new JMXConnectorNotificationListener();
                this.connector.addConnectionNotificationListener(listener, listener, this.watcher);
            }
            this.watcher.start();
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.watcher != null) {
            this.watcher.stop();
            this.watcher = null;
        }
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connector = null;
        }
        int imax = this.targetList.size();
        for (int i = 0; i < imax; ++i) {
            Target target = (Target)this.targetList.get(i);
            target.stop();
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.contextMap = null;
        this.propertyAccess = null;
    }

    @Override
    public Map watch() throws Exception {
        return this.watch(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map watch(boolean throwConnectError) throws Exception {
        JMXConnector tmpConnector = null;
        try {
            MBeanServerConnection connection = null;
            try {
                if (this.jndiFinder != null) {
                    connection = (MBeanServerConnection)this.jndiFinder.lookup(this.rmiAdaptorName);
                } else if (this.serviceURL != null) {
                    if (this.connector == null) {
                        tmpConnector = JMXConnectorFactory.newJMXConnector(new JMXServiceURL(this.serviceURL), this.jmxConnectorEnvironment);
                        tmpConnector.connect();
                        connection = tmpConnector.getMBeanServerConnection();
                    } else {
                        connection = this.connector.getMBeanServerConnection();
                    }
                } else {
                    connection = ManagementFactory.getPlatformMBeanServer();
                }
                this.isConnectError = false;
            }
            catch (Exception e) {
                if (!this.isConnectError && this.connectErrorMessageId != null) {
                    this.getLogger().write(this.connectErrorMessageId, new Object[]{this.getServiceNameObject(), this.rmiAdaptorName != null ? this.rmiAdaptorName : (this.serviceURL != null ? this.serviceURL : "PlatformMBeanServer")}, (Throwable)e);
                }
                this.isConnectError = true;
                if (throwConnectError) {
                    throw e;
                }
                Map map = null;
                if (tmpConnector != null) {
                    try {
                        tmpConnector.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return map;
            }
            Map map = this.watch(connection);
            return map;
        }
        finally {
            if (tmpConnector != null) {
                try {
                    tmpConnector.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected Map watch(MBeanServerConnection connection) throws Exception {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        int imax = this.targetList.size();
        for (int i = 0; i < imax; ++i) {
            Target target = (Target)this.targetList.get(i);
            try {
                Object value = target.getValue(connection);
                if (target.getKey() == null) continue;
                out.put(target.getKey(), value);
                continue;
            }
            catch (Exception e) {
                if (this.getValueErrorMessageId == null) continue;
                this.getLogger().write(this.getValueErrorMessageId, new Object[]{this.getServiceNameObject(), target}, (Throwable)e);
            }
        }
        return out;
    }

    @Override
    public void write() throws Exception {
        Map out = this.watch();
        if (out != null) {
            this.write(out);
        }
    }

    protected void write(Object out) throws MessageWriteException {
        if (this.category != null) {
            this.category.write(out);
        }
    }

    @Override
    public boolean onStart() {
        return true;
    }

    @Override
    public boolean onStop() {
        return true;
    }

    @Override
    public boolean onSuspend() {
        return true;
    }

    @Override
    public boolean onResume() {
        return true;
    }

    @Override
    public Object provide(DaemonControl ctrl) throws Throwable {
        ctrl.sleep(this.interval, false);
        if (this.getState() == 3) {
            try {
                return this.watch(false);
            }
            catch (Throwable th) {
                if (this.getState() == 3) {
                    throw th;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
        block3: {
            if (paramObj != null) {
                try {
                    this.write(paramObj);
                }
                catch (Throwable e) {
                    if (this.getState() != 3 || this.writeErrorMessageId == null || !ctrl.isRunning()) break block3;
                    this.getLogger().write(this.writeErrorMessageId, new Object[]{this.getServiceNameObject(), paramObj}, e);
                }
            }
        }
    }

    @Override
    public void garbage() {
    }

    protected void setContextValue(String name, Object value) {
        this.contextMap.put(name, value);
    }

    protected Object getContextValue(String name) throws Exception {
        if (this.contextMap.containsKey(name)) {
            return this.contextMap.get(name);
        }
        return this.propertyAccess.get(this.contextMap, name);
    }

    protected Map getContextMap() {
        return this.contextMap;
    }

    protected static class JMXConnectorNotificationListener
    implements NotificationListener,
    NotificationFilter {
        private static final long serialVersionUID = 5262799493133917779L;

        protected JMXConnectorNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            Daemon daemon = (Daemon)handback;
            if ("jmx.remote.connection.opened".equals(notification.getType())) {
                daemon.resume();
            } else if ("jmx.remote.connection.closed".equals(notification.getType())) {
                daemon.suspend();
            }
        }

        @Override
        public boolean isNotificationEnabled(Notification notification) {
            return notification instanceof JMXConnectionNotification;
        }
    }

    public static class ExceptionHandle
    extends WrapTarget {
        private List exceptionConditions = new ArrayList();

        public void addExceptionCondition(Condition condition) {
            this.exceptionConditions.add(condition);
        }

        public List getExceptionConditionList() {
            return this.exceptionConditions;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            try {
                Object value = this.target.getValue(connection);
                if (value != null && this.target.getContextKey() != null) {
                    this.watcher.setContextValue(this.target.getContextKey(), value);
                }
                return value;
            }
            catch (Exception e) {
                for (int i = 0; i < this.exceptionConditions.size(); ++i) {
                    Condition condition = (Condition)this.exceptionConditions.get(i);
                    Exception targetException = condition.getTargetException();
                    if (targetException == null || !targetException.getClass().isAssignableFrom(e.getClass())) continue;
                    LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
                    Object value = condition.handleException(e, this.watcher);
                    if (this.target.getKey() != null) {
                        out.put(this.target.getKey(), value);
                    }
                    if (value != null && this.target.getContextKey() != null && this.watcher != null) {
                        this.watcher.setContextValue(this.target.getContextKey(), value);
                    }
                    return out;
                }
                throw e;
            }
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append("exceptionConditions=").append(this.exceptionConditions);
            buf.append('}');
            return buf.toString();
        }

        public static class Condition
        implements Serializable {
            public static final String CONTEXT = "context";
            private Exception targetException;
            private boolean isReturnExceptionMessage;
            private boolean isReturnException;
            private boolean isReturnNull;
            private Object returnObject;
            private String expression;
            private ServiceName interpreterServiceName;

            public void setTargetException(Exception exception) {
                this.targetException = exception;
            }

            public Exception getTargetException() {
                return this.targetException;
            }

            public void setReturnExceptionMessage(boolean isReturnExceptionMessage) {
                this.isReturnExceptionMessage = isReturnExceptionMessage;
            }

            public void setReturnException(boolean isReturnException) {
                this.isReturnException = isReturnException;
            }

            public void setReturnNull(boolean isReturnNull) {
                this.isReturnNull = isReturnNull;
            }

            public void setReturnObject(Object returnObject) {
                this.returnObject = returnObject;
            }

            public void setExpression(String expression) {
                this.expression = expression;
            }

            public void setInterpreterServiceName(ServiceName serviceName) {
                this.interpreterServiceName = serviceName;
            }

            protected Object handleException(Exception e, MBeanWatcherService watcher) throws Exception {
                if (this.isReturnException) {
                    return e;
                }
                if (this.isReturnExceptionMessage) {
                    return e.getMessage();
                }
                if (this.isReturnNull) {
                    return null;
                }
                if (this.returnObject != null) {
                    return this.returnObject;
                }
                if (this.expression != null) {
                    jp.ossc.nimbus.service.interpreter.Interpreter itr = null;
                    if (this.interpreterServiceName != null) {
                        itr = (jp.ossc.nimbus.service.interpreter.Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
                        HashMap<String, Map> param = new HashMap<String, Map>();
                        param.put(CONTEXT, watcher.getContextMap());
                        return itr.evaluate(this.expression, param);
                    }
                    JexlContext jexlContext = JexlHelper.createContext();
                    jexlContext.getVars().put(CONTEXT, watcher.getContextMap());
                    Expression ex = ExpressionFactory.createExpression((String)this.expression);
                    return ex.evaluate(jexlContext);
                }
                throw e;
            }

            public String toString() {
                StringBuffer buf = new StringBuffer();
                buf.append("Condition{");
                buf.append(",targetException=").append(this.targetException.getClass().getName());
                buf.append(",isReturnException=").append(this.isReturnException);
                buf.append(",isReturnExceptionMessage=").append(this.isReturnExceptionMessage);
                buf.append(",isReturnNull=").append(this.isReturnNull);
                buf.append(",returnObject=").append(this.returnObject);
                buf.append(",interpreterServiceName=").append(this.interpreterServiceName);
                buf.append(",expression=").append(this.expression);
                buf.append('}');
                return buf.toString();
            }
        }
    }

    public static class Min
    extends SetOperation {
        private static final long serialVersionUID = -8356445551875453616L;

        @Override
        protected BigDecimal calculate(BigDecimal[] numbers) throws Exception {
            BigDecimal result = null;
            for (int i = 0; i < numbers.length; ++i) {
                result = result == null ? numbers[i] : result.min(numbers[i]);
            }
            return result;
        }
    }

    public static class Max
    extends SetOperation {
        private static final long serialVersionUID = 3152818165408079349L;

        @Override
        protected BigDecimal calculate(BigDecimal[] numbers) throws Exception {
            BigDecimal result = null;
            for (int i = 0; i < numbers.length; ++i) {
                result = result == null ? numbers[i] : result.max(numbers[i]);
            }
            return result;
        }
    }

    public static class StandardDeviation
    extends Variance {
        private static final long serialVersionUID = 1484688589485075232L;

        @Override
        protected BigDecimal calculate(BigDecimal[] numbers) throws Exception {
            BigDecimal variance = super.calculate(numbers);
            BigDecimal sd = new BigDecimal(Math.sqrt(variance.doubleValue()), MathContext.DECIMAL64);
            if (this.scale >= 0) {
                if (this.scale < 17) {
                    return sd;
                }
                BigDecimal b2 = new BigDecimal(2);
                for (int tempScale = 16; tempScale < this.scale; tempScale *= 2) {
                    sd = this.scale >= 0 ? sd.subtract(sd.multiply(sd).subtract(variance).divide(sd.multiply(b2), this.scale, this.roundingMode)) : sd.subtract(sd.multiply(sd).subtract(variance).divide(sd.multiply(b2), this.roundingMode));
                }
                return sd;
            }
            return sd;
        }
    }

    public static class Variance
    extends Average {
        private static final long serialVersionUID = -6250730592729577578L;

        @Override
        protected BigDecimal calculate(BigDecimal[] numbers) throws Exception {
            BigDecimal average = super.calculate(numbers);
            BigDecimal sum = BigDecimal.ZERO;
            for (int i = 0; i < numbers.length; ++i) {
                sum = sum.add(numbers[i].subtract(average).pow(2));
            }
            if (this.scale >= 0) {
                return sum.divide(new BigDecimal(numbers.length), this.scale, this.roundingMode);
            }
            return sum.divide(new BigDecimal(numbers.length), this.roundingMode);
        }
    }

    public static class Average
    extends Sum {
        private static final long serialVersionUID = -7262525074283633937L;
        protected int roundingMode = 6;
        protected int scale = -1;

        public void setRoundingMode(int mode) {
            this.roundingMode = mode;
        }

        public int getRoundingMode() {
            return this.roundingMode;
        }

        public void setScale(int scale) {
            this.scale = scale;
        }

        public int getScale() {
            return this.scale;
        }

        @Override
        protected BigDecimal calculate(BigDecimal[] numbers) throws Exception {
            if (this.scale >= 0) {
                return super.calculate(numbers).divide(new BigDecimal((double)numbers.length), this.scale, this.roundingMode);
            }
            return super.calculate(numbers).divide(new BigDecimal((double)numbers.length), this.roundingMode);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",roundingMode=").append(this.roundingMode);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Median
    extends SetOperation {
        private static final long serialVersionUID = 4138874599919750663L;
        private int roundingMode = 6;
        private int scale = -1;

        public void setRoundingMode(int mode) {
            this.roundingMode = mode;
        }

        public int getRoundingMode() {
            return this.roundingMode;
        }

        public void setScale(int scale) {
            this.scale = scale;
        }

        public int getScale() {
            return this.scale;
        }

        @Override
        protected BigDecimal calculate(BigDecimal[] numbers) throws Exception {
            Arrays.sort(numbers);
            if ((numbers.length + 1) % 2 == 0) {
                return numbers[(numbers.length + 1) / 2 - 1];
            }
            BigDecimal result = new BigDecimal(0.0);
            result = result.add(numbers[numbers.length / 2 - 1]);
            result = result.add(numbers[numbers.length / 2]);
            if (this.scale >= 0) {
                result.divide(new BigDecimal(2.0), this.scale, this.roundingMode);
            } else {
                result.divide(new BigDecimal(2.0), this.roundingMode);
            }
            return result;
        }
    }

    public static class Sum
    extends SetOperation {
        private static final long serialVersionUID = 2277773295544965565L;

        @Override
        protected BigDecimal calculate(BigDecimal[] numbers) throws Exception {
            BigDecimal result = new BigDecimal(0.0);
            for (int i = 0; i < numbers.length; ++i) {
                result = result.add(numbers[i]);
            }
            return result;
        }
    }

    public static abstract class SetOperation
    extends EditTarget {
        private static final long serialVersionUID = -7200261696645994257L;

        @Override
        public boolean isElementEdit() {
            return true;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            Object value = this.target.getValue(connection);
            if (value == null) {
                value = new BigDecimal(0.0);
            } else {
                Object[] array = null;
                if (value instanceof Map) {
                    array = ((Map)value).values().toArray();
                } else if (value instanceof Collection) {
                    array = ((Collection)value).toArray();
                } else if (value.getClass().isArray()) {
                    Object[] sourceArray = (Object[])value;
                    array = new Object[sourceArray.length];
                    System.arraycopy(sourceArray, 0, array, 0, sourceArray.length);
                }
                if (array != null) {
                    if (array.length == 0) {
                        value = new BigDecimal(0.0);
                    } else {
                        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                        for (int i = 0; i < array.length; ++i) {
                            if (array[i] == null || !(array[i] instanceof Number)) continue;
                            BigDecimal target = Target.toBigDecimal(array[i], true);
                            list.add(target);
                        }
                        value = list.size() == 0 ? new BigDecimal(0.0) : this.edit(list);
                    }
                }
            }
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        @Override
        protected Object edit(Object value) throws Exception {
            List list = (List)value;
            return this.calculate(list.toArray(new BigDecimal[list.size()]));
        }

        protected abstract BigDecimal calculate(BigDecimal[] var1) throws Exception;

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",isElementEdit=").append(this.isElementEdit());
            buf.append('}');
            return buf.toString();
        }
    }

    public static class MinOperation
    extends BinaryOperation {
        private static final long serialVersionUID = -4042120812950659730L;

        @Override
        protected BigDecimal calculate(BigDecimal first, BigDecimal second) throws Exception {
            return first.min(second);
        }
    }

    public static class MaxOperation
    extends BinaryOperation {
        private static final long serialVersionUID = 7889957820603303173L;

        @Override
        protected BigDecimal calculate(BigDecimal first, BigDecimal second) throws Exception {
            return first.max(second);
        }
    }

    public static class PercentageOperation
    extends DivideOperation {
        private static final long serialVersionUID = -828285523729092762L;

        @Override
        protected BigDecimal calculate(BigDecimal first, BigDecimal second) throws Exception {
            BigDecimal divided = super.calculate(first, second);
            if (divided == null) {
                return null;
            }
            return divided.multiply(new BigDecimal(100.0));
        }
    }

    public static class DivideOperation
    extends BinaryOperation {
        private static final long serialVersionUID = -5331257610256153532L;
        private static final BigDecimal ZERO = new BigDecimal(0.0);
        private int roundingMode = 6;
        private int scale = -1;
        private boolean isReturnNullOnZeroDivide = false;
        private boolean isReturnZeroOnZeroDivide = false;

        public void setRoundingMode(int mode) {
            this.roundingMode = mode;
        }

        public int getRoundingMode() {
            return this.roundingMode;
        }

        public void setScale(int scale) {
            this.scale = scale;
        }

        public int getScale() {
            return this.scale;
        }

        public void setReturnNullOnZeroDivide(boolean isReturnNull) {
            this.isReturnNullOnZeroDivide = isReturnNull;
        }

        public boolean isReturnNullOnZeroDivide() {
            return this.isReturnNullOnZeroDivide;
        }

        public void setReturnZeroOnZeroDivide(boolean isReturnZero) {
            this.isReturnZeroOnZeroDivide = isReturnZero;
        }

        public boolean isReturnZeroOnZeroDivide() {
            return this.isReturnZeroOnZeroDivide;
        }

        @Override
        protected BigDecimal calculate(BigDecimal first, BigDecimal second) throws Exception {
            if (ZERO.equals(second)) {
                if (this.isReturnZeroOnZeroDivide) {
                    return ZERO;
                }
                if (this.isReturnNullOnZeroDivide) {
                    return null;
                }
            }
            return this.scale >= 0 ? first.divide(second, this.scale, this.roundingMode) : first.divide(second, this.roundingMode);
        }
    }

    public static class MultiplyOperation
    extends BinaryOperation {
        private static final long serialVersionUID = -5651446587284471517L;

        @Override
        protected BigDecimal calculate(BigDecimal first, BigDecimal second) throws Exception {
            return first.multiply(second);
        }
    }

    public static class SubtractOperation
    extends BinaryOperation {
        private static final long serialVersionUID = -2343694151274725683L;

        @Override
        protected BigDecimal calculate(BigDecimal first, BigDecimal second) throws Exception {
            return first.subtract(second);
        }
    }

    public static class AddOperation
    extends BinaryOperation {
        private static final long serialVersionUID = -5086486388715849637L;

        @Override
        protected BigDecimal calculate(BigDecimal first, BigDecimal second) throws Exception {
            return first.add(second);
        }
    }

    public static abstract class BinaryOperation
    extends WrapTarget {
        private static final long serialVersionUID = 7253736292096568710L;
        protected Target secondTarget;
        protected boolean isNullToZero;

        @Override
        public void setWatcherServiceName(ServiceName name) {
            super.setWatcherServiceName(name);
            this.secondTarget.setWatcherServiceName(name);
        }

        @Override
        protected void setWatcherService(MBeanWatcherService watcher) {
            super.setWatcherService(watcher);
            this.secondTarget.setWatcherService(watcher);
        }

        @Override
        public void setLogger(Logger logger) {
            super.setLogger(logger);
            this.secondTarget.setLogger(logger);
        }

        public void setSecondTarget(Target target) {
            this.secondTarget = target;
        }

        public Target getSecondTarget() {
            return this.secondTarget;
        }

        public void setNullToZero(boolean isNullToZero) {
            this.isNullToZero = isNullToZero;
        }

        public boolean isNullToZero() {
            return this.isNullToZero;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            BigDecimal first = Target.toBigDecimal(this.target.getValue(connection), this.isNullToZero);
            BigDecimal second = Target.toBigDecimal(this.secondTarget.getValue(connection), this.isNullToZero);
            if (first == null || second == null) {
                return null;
            }
            BigDecimal value = this.calculate(first, second);
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        protected abstract BigDecimal calculate(BigDecimal var1, BigDecimal var2) throws Exception;

        @Override
        public void reset() {
            super.reset();
            this.secondTarget.reset();
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",secondTarget=").append(this.secondTarget);
            buf.append(",isNullToZero=").append(this.isNullToZero);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Period
    extends WrapTarget
    implements DaemonRunnable {
        private static final long serialVersionUID = 6105816116626297923L;
        private long interval = 1000L;
        private int count = 60;
        private List valueList = new ArrayList();
        private Daemon periodicGetter;
        private JMXConnectorNotificationListener listener;

        public void setInterval(long millis) {
            this.interval = millis;
        }

        public long getInterval() {
            return this.interval;
        }

        public void setCount(int cnt) {
            this.count = cnt;
        }

        public int getCount() {
            return this.count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            ArrayList value = null;
            List list = this.valueList;
            synchronized (list) {
                value = new ArrayList(this.valueList);
            }
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        @Override
        public void start() {
            super.start();
            this.periodicGetter = new Daemon(this);
            this.periodicGetter.setName("Nimbus MBeanWatcher periodic value getter " + this.getWatcherServiceName() + this.target);
            this.periodicGetter.setDaemon(true);
            if (this.watcher.connector != null) {
                this.listener = new JMXConnectorNotificationListener();
                this.watcher.connector.addConnectionNotificationListener(this.listener, this.listener, this.periodicGetter);
            }
            this.periodicGetter.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            if (this.listener != null && this.watcher.connector != null) {
                try {
                    this.watcher.connector.removeConnectionNotificationListener(this.listener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            }
            if (this.periodicGetter != null) {
                this.periodicGetter.stopNoWait();
                this.periodicGetter = null;
            }
            List list = this.valueList;
            synchronized (list) {
                this.valueList.clear();
            }
            super.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            super.reset();
            List list = this.valueList;
            synchronized (list) {
                this.valueList.clear();
            }
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            ctrl.sleep(this.interval, false);
            JMXConnector tmpConnector = null;
            try {
                MBeanServerConnection connection = null;
                if (this.watcher.jndiFinder != null) {
                    connection = (MBeanServerConnection)this.watcher.jndiFinder.lookup(this.watcher.rmiAdaptorName);
                } else if (this.watcher.serviceURL != null) {
                    if (this.watcher.connector == null) {
                        tmpConnector = JMXConnectorFactory.newJMXConnector(new JMXServiceURL(this.watcher.serviceURL), this.watcher.jmxConnectorEnvironment);
                        tmpConnector.connect();
                        connection = tmpConnector.getMBeanServerConnection();
                    } else {
                        connection = this.watcher.connector.getMBeanServerConnection();
                    }
                } else {
                    connection = ManagementFactory.getPlatformMBeanServer();
                }
                Object object = this.target.getValue(connection);
                return object;
            }
            catch (Exception e) {
                Object var4_6 = null;
                return var4_6;
            }
            finally {
                if (tmpConnector != null) {
                    try {
                        tmpConnector.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            List list = this.valueList;
            synchronized (list) {
                this.valueList.add(paramObj);
                if (this.valueList.size() > this.count) {
                    int imax = this.count - this.valueList.size();
                    for (int i = 0; i < imax; ++i) {
                        this.valueList.remove(0);
                    }
                }
            }
        }

        @Override
        public void garbage() {
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",interval=").append(this.interval);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class ChangeSet
    extends WrapTarget {
        private static final long serialVersionUID = -7480156060861954682L;
        private Collection lastValue;
        private boolean isChangeAdd = true;

        public void setChangeAdd(boolean isAdd) {
            this.isChangeAdd = isAdd;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            Collection value = (HashSet)this.target.getValue(connection);
            if (this.lastValue == null) {
                this.lastValue = value;
                if (!this.isChangeAdd) {
                    value = new HashSet();
                }
            } else {
                HashSet tmpLastValue = new HashSet(value);
                if (this.isChangeAdd) {
                    value = new HashSet(value);
                    value.removeAll(this.lastValue);
                } else {
                    this.lastValue.removeAll(value);
                    value = this.lastValue;
                }
                this.lastValue = tmpLastValue;
            }
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        @Override
        public void reset() {
            super.reset();
            this.lastValue = null;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",isChangeAdd=").append(this.isChangeAdd);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Change
    extends WrapTarget {
        private static final long serialVersionUID = 315703698395044669L;
        private boolean isNullToZero;
        private Object lastValue;

        public void setNullToZero(boolean isNullToZero) {
            this.isNullToZero = isNullToZero;
        }

        public boolean isNullToZero() {
            return this.isNullToZero;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            Object value = this.target.getValue(connection);
            Serializable changeValue = null;
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                Map lastValueMap = this.lastValue instanceof Map ? (Map)this.lastValue : null;
                HashMap changeMap = new HashMap();
                for (Map.Entry entry : valueMap.entrySet()) {
                    BigDecimal newValue = Target.toBigDecimal(entry.getValue(), this.isNullToZero);
                    if (lastValueMap == null) {
                        changeMap.put(entry.getKey(), this.isNullToZero ? BigDecimal.ZERO : null);
                        continue;
                    }
                    if (lastValueMap.containsKey(entry.getKey())) {
                        BigDecimal oldValue = Target.toBigDecimal(lastValueMap.remove(entry.getKey()), this.isNullToZero);
                        if (this.isNullToZero || newValue != null && oldValue != null) {
                            changeMap.put(entry.getKey(), newValue.subtract(oldValue));
                            continue;
                        }
                        if (newValue == null && oldValue == null) {
                            changeMap.put(entry.getKey(), null);
                            continue;
                        }
                        if (newValue != null && oldValue == null) {
                            changeMap.put(entry.getKey(), newValue);
                            continue;
                        }
                        if (newValue != null || oldValue == null) continue;
                        changeMap.put(entry.getKey(), BigDecimal.ZERO.subtract(oldValue));
                        continue;
                    }
                    changeMap.put(entry.getKey(), newValue);
                }
                if (lastValueMap != null && !lastValueMap.isEmpty()) {
                    for (Map.Entry entry : lastValueMap.entrySet()) {
                        BigDecimal oldValue = Target.toBigDecimal(entry.getValue(), this.isNullToZero);
                        if (this.isNullToZero || oldValue != null) {
                            changeMap.put(entry.getKey(), BigDecimal.ZERO.subtract(oldValue));
                            continue;
                        }
                        changeMap.put(entry.getKey(), null);
                    }
                }
                changeValue = changeMap;
                this.lastValue = new HashMap((Map)value);
            } else {
                value = Target.toBigDecimal(value, this.isNullToZero);
                changeValue = this.lastValue == null ? (this.isNullToZero ? BigDecimal.ZERO : null) : ((BigDecimal)value).subtract((BigDecimal)this.lastValue);
                this.lastValue = value;
            }
            if (this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, changeValue);
            }
            return changeValue;
        }

        @Override
        public void reset() {
            super.reset();
            this.lastValue = null;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",isNullToZero=").append(this.isNullToZero);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Convert
    extends EditTarget {
        private static final long serialVersionUID = 1737702373890781789L;
        private ServiceName converterServiceName;
        private Converter converter;

        public void setConverter(Converter converter) {
            this.converter = converter;
        }

        public Converter getConverter() {
            return this.converter;
        }

        public void setConverterServiceName(ServiceName name) {
            this.converterServiceName = name;
        }

        public ServiceName getConverterServiceName() {
            return this.converterServiceName;
        }

        @Override
        protected Object edit(Object value) throws Exception {
            Converter conv = this.converter;
            if (this.converterServiceName != null) {
                conv = (Converter)ServiceManagerFactory.getServiceObject(this.converterServiceName);
            }
            return conv.convert(value);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",converter=").append(this.converter);
            buf.append(",converterServiceName=").append(this.converterServiceName);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Property
    extends EditTarget {
        private static final long serialVersionUID = 5990303499820230369L;
        private jp.ossc.nimbus.beans.Property property;
        private boolean isIgnoreNullProperty;

        public void setProperty(jp.ossc.nimbus.beans.Property property) {
            property.setIgnoreNullProperty(this.isIgnoreNullProperty);
            this.property = property;
        }

        public jp.ossc.nimbus.beans.Property getProperty() {
            return this.property;
        }

        public void setIgnoreNullProperty(boolean isIgnore) {
            this.isIgnoreNullProperty = isIgnore;
            if (this.property != null) {
                this.property.setIgnoreNullProperty(this.isIgnoreNullProperty);
            }
        }

        public boolean isIgnoreNullProperty() {
            return this.isIgnoreNullProperty;
        }

        @Override
        protected Object edit(Object value) throws Exception {
            return this.property.getProperty(value);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",property=").append(this.property);
            buf.append(",isIgnoreNullProperty=").append(this.isIgnoreNullProperty);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Interpreter
    extends EditTarget {
        private static final long serialVersionUID = 5874469234835823412L;
        public static final String VALUE = "value";
        public static final String CONTEXT = "context";
        private ServiceName interpreterServiceName;
        private jp.ossc.nimbus.service.interpreter.Interpreter interpreter;
        private String expression;

        public void setInterpreterServiceName(ServiceName name) {
            this.interpreterServiceName = name;
        }

        public void setInterpreter(jp.ossc.nimbus.service.interpreter.Interpreter interpreter) {
            this.interpreter = interpreter;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        protected Object edit(Object value) throws Exception {
            jp.ossc.nimbus.service.interpreter.Interpreter itr = this.interpreter;
            if (itr == null && this.interpreterServiceName != null) {
                itr = (jp.ossc.nimbus.service.interpreter.Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put(CONTEXT, this.watcher.getContextMap());
            param.put(VALUE, value);
            return itr.evaluate(this.expression, param);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",expression=").append(this.expression);
            buf.append('}');
            return buf.toString();
        }
    }

    public static abstract class EditTarget
    extends WrapTarget {
        private static final long serialVersionUID = -3292286495172239503L;
        protected boolean isElementEdit;

        public void setElementEdit(boolean isElement) {
            this.isElementEdit = isElement;
        }

        public boolean isElementEdit() {
            return this.isElementEdit;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            ArrayList<Object> value = this.target.getValue(connection);
            if (this.isElementEdit) {
                Object[] array = null;
                if (value instanceof Map) {
                    array = ((Map)((Object)value)).values().toArray();
                } else if (value instanceof Collection) {
                    array = ((Collection)value).toArray();
                } else if (value.getClass().isArray()) {
                    Object[] sourceArray = (Object[])value;
                    array = new Object[sourceArray.length];
                    System.arraycopy(sourceArray, 0, array, 0, sourceArray.length);
                } else {
                    value = this.edit(value);
                }
                if (array != null) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < array.length; ++i) {
                        list.add(this.edit(array[i]));
                    }
                    value = list;
                }
            } else {
                value = this.edit(value);
            }
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        protected abstract Object edit(Object var1) throws Exception;

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",isElementEdit=").append(this.isElementEdit);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Check
    extends WrapTarget {
        private static final long serialVersionUID = -8821714143031466189L;
        private boolean isNullToZero;
        private ServiceName loggerServiceName;
        private List checkConditions = new ArrayList();

        public void setNullToZero(boolean isNullToZero) {
            this.isNullToZero = isNullToZero;
        }

        public boolean isNullToZero() {
            return this.isNullToZero;
        }

        public void setLoggerServiceName(ServiceName name) {
            this.loggerServiceName = name;
        }

        public ServiceName getLoggerServiceName() {
            return this.loggerServiceName;
        }

        @Override
        public Logger getLogger() {
            if (this.loggerServiceName == null) {
                return super.getLogger();
            }
            return (Logger)ServiceManagerFactory.getServiceObject(this.loggerServiceName);
        }

        public void addCheckCondition(Condition condition) {
            this.checkConditions.add(condition);
        }

        public List getCheckConditionList() {
            return this.checkConditions;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            Object value = this.target.getValue(connection);
            if (this.isNullToZero) {
                value = Target.toBigDecimal(value, this.isNullToZero);
            }
            boolean checkError = false;
            int imax = this.checkConditions.size();
            for (int i = 0; i < imax; ++i) {
                Condition condition = (Condition)this.checkConditions.get(i);
                condition.setWatcherService(this.watcher);
                if (checkError) {
                    condition.reset();
                    continue;
                }
                if (condition.check(value, this.getLogger(), this.getWatcherServiceName(), this.getKey())) continue;
                checkError = true;
            }
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        @Override
        public void reset() {
            super.reset();
            int imax = this.checkConditions.size();
            for (int i = 0; i < imax; ++i) {
                Condition condition = (Condition)this.checkConditions.get(i);
                condition.reset();
            }
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append("checkConditions=").append(this.checkConditions);
            buf.append(",isNullToZero=").append(this.isNullToZero);
            buf.append(",loggerServiceName=").append(this.loggerServiceName);
            buf.append('}');
            return buf.toString();
        }

        public static class Condition
        implements Serializable {
            private static final long serialVersionUID = 451166286622455937L;
            public static final String CONTEXT = "context";
            public static final String VALUE = "value";
            private Expression checkExpression;
            private String expression;
            private Map idMap = new TreeMap(new ErrorCountComparator());
            private int errorCount;
            private List checkTimes;
            private List checkTerms;
            private boolean isOnceOutputLog;
            private ServiceName interpreterServiceName;
            private jp.ossc.nimbus.service.interpreter.Interpreter interpreter;
            private MBeanWatcherService watcher;

            protected void setWatcherService(MBeanWatcherService watcher) {
                this.watcher = watcher;
            }

            public void setInterpreterServiceName(ServiceName name) {
                this.interpreterServiceName = name;
            }

            public void setInterpreter(jp.ossc.nimbus.service.interpreter.Interpreter interpreter) {
                this.interpreter = interpreter;
            }

            public void setCheckExpression(String expression) {
                this.expression = expression;
            }

            public String getCheckExpression() {
                return this.expression;
            }

            public void setLogMessageId(String id) {
                this.setLogMessageIdByErrorCount(1, id);
            }

            public void setLogMessageIdByErrorCount(int errorCount, String id) {
                this.idMap.put(new Integer(errorCount), id);
            }

            public void setCheckTimes(String[] times) throws ParseException {
                if (times == null || times.length == 0) {
                    this.checkTimes = null;
                } else {
                    this.checkTimes = new ArrayList();
                    for (int i = 0; i < times.length; ++i) {
                        CheckTime ct = new CheckTime(times[i]);
                        this.checkTimes.add(ct);
                    }
                    Collections.sort(this.checkTimes);
                }
            }

            public String[] getCheckTimes() {
                if (this.checkTimes == null) {
                    return null;
                }
                String[] result = new String[this.checkTimes.size()];
                for (int i = 0; i < this.checkTimes.size(); ++i) {
                    result[i] = this.checkTimes.get(i).toString();
                }
                return result;
            }

            public void setCheckTerms(String[] terms) throws ParseException {
                if (terms == null || terms.length == 0) {
                    this.checkTerms = null;
                } else {
                    this.checkTerms = new ArrayList();
                    for (int i = 0; i < terms.length; ++i) {
                        Term term = new Term(terms[i]);
                        this.checkTerms.add(term);
                    }
                    Collections.sort(this.checkTerms);
                }
            }

            public String[] getCheckTerms() {
                if (this.checkTerms == null) {
                    return null;
                }
                String[] result = new String[this.checkTerms.size()];
                for (int i = 0; i < this.checkTerms.size(); ++i) {
                    result[i] = this.checkTerms.get(i).toString();
                }
                return result;
            }

            public void setOnceOutputLog(boolean isOnce) {
                this.isOnceOutputLog = isOnce;
            }

            public boolean isOnceOutputLog() {
                return this.isOnceOutputLog;
            }

            protected boolean check(Object value, Logger logger, ServiceName watcherServiceName, String key) throws Exception {
                jp.ossc.nimbus.service.interpreter.Interpreter itr;
                int i;
                if (this.errorCount == -1) {
                    return true;
                }
                ArrayList<CheckTime> currentCheckTimes = null;
                Day nowDay = null;
                Time nowTime = null;
                if (this.checkTimes != null) {
                    Calendar now = Calendar.getInstance();
                    nowDay = new Day(now);
                    nowTime = new Time(now);
                    for (i = 0; i < this.checkTimes.size(); ++i) {
                        CheckTime ct = (CheckTime)this.checkTimes.get(i);
                        if (ct.isChecked(nowDay) || nowTime.compareTo(ct) < 0) continue;
                        if (currentCheckTimes == null) {
                            currentCheckTimes = new ArrayList<CheckTime>();
                        }
                        currentCheckTimes.add(ct);
                    }
                    if (currentCheckTimes == null) {
                        return true;
                    }
                }
                if (currentCheckTimes == null && this.checkTerms != null) {
                    if (nowTime == null) {
                        nowTime = new Time(Calendar.getInstance());
                    }
                    boolean check = false;
                    for (i = 0; i < this.checkTerms.size(); ++i) {
                        Term term = (Term)this.checkTerms.get(i);
                        if (!term.contains(nowTime)) continue;
                        check = true;
                    }
                    if (!check) {
                        return true;
                    }
                }
                if ((itr = this.interpreter) == null && this.interpreterServiceName != null) {
                    itr = (jp.ossc.nimbus.service.interpreter.Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
                }
                Boolean error = null;
                if (itr == null) {
                    JexlContext jexlContext = JexlHelper.createContext();
                    jexlContext.getVars().put(CONTEXT, this.watcher.getContextMap());
                    jexlContext.getVars().put(VALUE, value);
                    if (this.checkExpression == null) {
                        this.checkExpression = ExpressionFactory.createExpression((String)this.expression);
                    }
                    error = (Boolean)this.checkExpression.evaluate(jexlContext);
                } else {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put(CONTEXT, this.watcher.getContextMap());
                    param.put(VALUE, value);
                    error = (Boolean)itr.evaluate(this.expression, param);
                }
                if (error.booleanValue()) {
                    ++this.errorCount;
                    boolean isFirst = true;
                    for (Map.Entry entry : this.idMap.entrySet()) {
                        Integer count = (Integer)entry.getKey();
                        if (this.errorCount >= count) {
                            if (isFirst || this.errorCount == count) {
                                logger.write((String)entry.getValue(), new Object[]{watcherServiceName, key, this.expression, value, count});
                            }
                            if (isFirst) {
                                this.errorCount = this.isOnceOutputLog ? -1 : 0;
                                if (currentCheckTimes != null) {
                                    for (int i2 = 0; i2 < currentCheckTimes.size(); ++i2) {
                                        CheckTime ct = (CheckTime)currentCheckTimes.get(i2);
                                        ct.setCheckDay(nowDay);
                                    }
                                }
                            }
                            return false;
                        }
                        isFirst = false;
                    }
                } else {
                    this.errorCount = 0;
                }
                if (currentCheckTimes != null) {
                    for (int i3 = 0; i3 < currentCheckTimes.size(); ++i3) {
                        CheckTime ct = (CheckTime)currentCheckTimes.get(i3);
                        ct.setCheckDay(nowDay);
                    }
                }
                return true;
            }

            protected void reset() {
                this.errorCount = 0;
            }

            public String toString() {
                StringBuffer buf = new StringBuffer();
                buf.append("Condition{");
                buf.append(",expression=").append(this.expression);
                buf.append(",idMap=").append(this.idMap);
                buf.append('}');
                return buf.toString();
            }

            private class CheckTime
            extends Time {
                private static final long serialVersionUID = 5309699914961118492L;
                private Day checkDay;

                public CheckTime(String time) throws ParseException {
                    super(time);
                }

                public boolean isChecked(Day currentDay) {
                    if (this.checkDay == null) {
                        return false;
                    }
                    return currentDay.compareTo(this.checkDay) <= 0;
                }

                public void setCheckDay(Day day) {
                    this.checkDay = day;
                }
            }

            private class Term
            implements Serializable,
            Comparable {
                private static final long serialVersionUID = 4874635307721480812L;
                private Time from;
                private Time to;

                public Term(String term) throws ParseException {
                    if (term.indexOf(45) == -1) {
                        throw new ParseException("Format is 'from-to' : " + term, term.length());
                    }
                    String[] times = term.split("-");
                    if (times.length != 2) {
                        throw new ParseException("Format is 'from-to' : " + term, term.length());
                    }
                    this.from = new Time(times[0]);
                    this.to = new Time(times[1]);
                }

                public boolean contains(Time time) {
                    return time.compareTo(this.from) >= 0 && time.compareTo(this.to) < 0;
                }

                public int hashCode() {
                    return this.from.hashCode() + this.to.hashCode();
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (obj == null || !(obj instanceof Term)) {
                        return false;
                    }
                    Term cmp = (Term)obj;
                    return this.from.equals(cmp.from) && this.to.equals(cmp.to);
                }

                public int compareTo(Object obj) {
                    if (obj == null || !(obj instanceof Term)) {
                        return 1;
                    }
                    Term cmp = (Term)obj;
                    return this.from.compareTo(cmp.from);
                }

                public String toString() {
                    StringBuffer buf = new StringBuffer();
                    return buf.append(this.from).append('-').append(this.to).toString();
                }
            }

            private class Time
            implements Serializable,
            Comparable {
                private static final long serialVersionUID = 5738491787638885636L;
                private static final String TIME_FORMAT1 = "HH:mm:ss";
                private static final String TIME_FORMAT2 = "HH:mm:ss.SSS";
                private int time;

                public Time(Calendar now) {
                    this.time += now.get(11) * 10000000;
                    this.time += now.get(12) * 100000;
                    this.time += now.get(13) * 1000;
                    this.time += now.get(14);
                }

                public Time(String time) throws ParseException {
                    Date date = time.length() == 8 ? new SimpleDateFormat(TIME_FORMAT1).parse(time) : new SimpleDateFormat(TIME_FORMAT2).parse(time);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    this.time += cal.get(11) * 10000000;
                    this.time += cal.get(12) * 100000;
                    this.time += cal.get(13) * 1000;
                    this.time += cal.get(14);
                }

                public int hashCode() {
                    return this.time;
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (obj == null || !(obj instanceof Time)) {
                        return false;
                    }
                    Time cmp = (Time)obj;
                    return this.time == cmp.time;
                }

                public int compareTo(Object obj) {
                    if (obj == null || !(obj instanceof Time)) {
                        return 1;
                    }
                    Time cmp = (Time)obj;
                    if (this.time == cmp.time) {
                        return 0;
                    }
                    return this.time > cmp.time ? 1 : -1;
                }

                public String toString() {
                    StringBuffer buf = new StringBuffer();
                    buf.append(this.time);
                    int length = buf.length();
                    buf.insert(length - 3, '.');
                    buf.insert(length - 5, ':');
                    buf.insert(length - 7, ':');
                    return buf.toString();
                }
            }

            private class Day
            implements Serializable,
            Comparable {
                private static final long serialVersionUID = -3482088973138104434L;
                private int day;

                public Day(Calendar now) {
                    this.day += now.get(1) * 1000;
                    this.day += now.get(6);
                }

                public int hashCode() {
                    return this.day;
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (obj == null || !(obj instanceof Day)) {
                        return false;
                    }
                    Day cmp = (Day)obj;
                    return this.day == cmp.day;
                }

                public int compareTo(Object obj) {
                    if (obj == null || !(obj instanceof Day)) {
                        return 1;
                    }
                    Day cmp = (Day)obj;
                    if (this.day == cmp.day) {
                        return 0;
                    }
                    return this.day > cmp.day ? 1 : -1;
                }

                public String toString() {
                    return Integer.toString(this.day);
                }
            }
        }

        private static class ErrorCountComparator
        implements Comparator,
        Serializable {
            private static final long serialVersionUID = -8997521049688710362L;

            private ErrorCountComparator() {
            }

            public int compare(Object o1, Object o2) {
                return ((Comparable)o2).compareTo(o1);
            }
        }
    }

    public static abstract class WrapTarget
    extends Target {
        private static final long serialVersionUID = 6038448327332359108L;
        protected Target target;

        @Override
        public void setWatcherServiceName(ServiceName name) {
            super.setWatcherServiceName(name);
            this.target.setWatcherServiceName(name);
        }

        @Override
        protected void setWatcherService(MBeanWatcherService watcher) {
            super.setWatcherService(watcher);
            this.target.setWatcherService(watcher);
        }

        @Override
        public void setLogger(Logger logger) {
            super.setLogger(logger);
            this.target.setLogger(logger);
        }

        public void setTarget(Target target) {
            this.target = target;
        }

        public Target getTarget() {
            return this.target;
        }

        @Override
        public void reset() {
            super.reset();
            this.target.reset();
        }

        @Override
        public void start() {
            super.start();
            this.target.start();
        }

        @Override
        public void stop() {
            this.target.stop();
            super.stop();
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",target=").append(this.target);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Operation
    extends MBeanTarget {
        private static final long serialVersionUID = 8874947184358756744L;
        private String name;
        private List params;
        private String[] signiture;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setSigniture(String[] sgn) {
            this.signiture = sgn;
        }

        public String[] getSigniture() {
            return this.signiture;
        }

        public void setParameters(Object[] params) {
            if (this.params == null) {
                this.params = new ArrayList();
            }
            for (int i = 0; i < params.length; ++i) {
                this.params.add(params[i]);
            }
        }

        public void addParameter(Object param) {
            if (this.params == null) {
                this.params = new ArrayList();
            }
            this.params.add(param);
        }

        public List getParameterList() {
            return this.params;
        }

        @Override
        public String getKey() {
            return super.getKey() != null ? super.getKey() : this.getObjectName() + '#' + this.getName() + '(' + (this.params == null ? "" : this.params.toString()) + ')';
        }

        @Override
        public Object getValue(MBeanServerConnection connection, ObjectName objectName) throws Exception {
            return connection.invoke(objectName, this.name, this.params == null ? null : this.params.toArray(), this.signiture);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",name=").append(this.name);
            buf.append(",params=").append(this.params);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Attributes
    extends MBeanTarget {
        private static final long serialVersionUID = -8344987725214428096L;
        private String[] names;

        public void setNames(String[] names) {
            this.names = names;
        }

        public String[] getNames() {
            return this.names;
        }

        @Override
        public Object getValue(MBeanServerConnection connection, ObjectName objectName) throws Exception {
            AttributeList list = connection.getAttributes(objectName, this.names);
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    javax.management.Attribute attribute = (javax.management.Attribute)list.get(i);
                    result.put(attribute.getName(), attribute.getValue());
                }
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",names=");
            if (this.names == null) {
                buf.append(this.names);
            } else {
                buf.append('[');
                for (int i = 0; i < this.names.length; ++i) {
                    if (i != 0) {
                        buf.append(',');
                    }
                    buf.append(this.names[i]);
                }
                buf.append(']');
            }
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Attribute
    extends MBeanTarget {
        private static final long serialVersionUID = 253836219685470254L;
        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getKey() {
            return super.getKey() != null ? super.getKey() : this.getObjectName() + '#' + this.getName();
        }

        @Override
        public Object getValue(MBeanServerConnection connection, ObjectName objectName) throws Exception {
            return connection.getAttribute(objectName, this.name);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",name=").append(this.name);
            buf.append('}');
            return buf.toString();
        }
    }

    public static abstract class MBeanTarget
    extends Target {
        private static final long serialVersionUID = -5180685937237509600L;
        protected boolean isMBeanSet;
        protected ObjectName objectName;
        protected QueryExp queryExp;

        public void setMBeanSet(boolean isSet) {
            this.isMBeanSet = isSet;
        }

        public boolean isMBeanSet() {
            return this.isMBeanSet;
        }

        public void setObjectName(String name) throws MalformedObjectNameException {
            this.objectName = new ObjectName(name);
        }

        public String getObjectName() {
            return this.objectName == null ? null : this.objectName.toString();
        }

        public void setQueryExp(QueryExp exp) {
            this.queryExp = exp;
        }

        public QueryExp getQueryExp() {
            return this.queryExp;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            boolean tmpIsMBeanSet = this.isMBeanSet;
            ObjectName tmpObjectName = this.objectName;
            QueryExp tmpQueryExp = this.queryExp;
            if (tmpObjectName == null) {
                tmpIsMBeanSet = this.watcher.isMBeanSet;
                tmpObjectName = this.watcher.objectName;
                tmpQueryExp = this.watcher.queryExp;
            }
            LinkedHashMap<String, Object> value = null;
            if (!tmpIsMBeanSet) {
                value = this.getValue(connection, tmpObjectName);
            } else {
                Set<ObjectName> objectNameSet = connection.queryNames(tmpObjectName, tmpQueryExp);
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                if (objectNameSet != null && objectNameSet.size() != 0) {
                    for (ObjectName name : objectNameSet) {
                        map.put(name.toString(), this.getValue(connection, name));
                    }
                }
                value = map;
            }
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        protected abstract Object getValue(MBeanServerConnection var1, ObjectName var2) throws Exception;

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            boolean tmpIsMBeanSet = this.isMBeanSet;
            ObjectName tmpObjectName = this.objectName;
            QueryExp tmpQueryExp = this.queryExp;
            if (tmpObjectName == null && this.watcher != null) {
                tmpIsMBeanSet = this.watcher.isMBeanSet;
                tmpObjectName = this.watcher.objectName;
                tmpQueryExp = this.watcher.queryExp;
            }
            buf.append(",objectName=").append(tmpObjectName);
            buf.append(",isMBeanSet=").append(tmpIsMBeanSet);
            buf.append(",queryExp=").append(tmpQueryExp);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class MBeanWatcher
    extends Target {
        private static final long serialVersionUID = 7924202215978774672L;
        private ServiceName mBeanWatcherServiceName;
        private MBeanWatcherService mBeanWatcherService;
        private boolean isSharedConnection;
        private boolean isThrowConnectError;

        public void setMBeanWatcherServiceName(ServiceName name) {
            this.mBeanWatcherServiceName = name;
        }

        public void setMBeanWatcherService(MBeanWatcherService service) {
            this.mBeanWatcherService = service;
        }

        public void setSharedConnection(boolean isShared) {
            this.isSharedConnection = isShared;
        }

        public void setThrowConnectError(boolean isThrow) {
            this.isThrowConnectError = isThrow;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            Map value;
            MBeanWatcherService watcherService = this.mBeanWatcherService;
            if (watcherService == null && this.mBeanWatcherServiceName != null) {
                watcherService = (MBeanWatcherService)ServiceManagerFactory.getServiceObject(this.mBeanWatcherServiceName);
            }
            Map map = value = this.isSharedConnection ? watcherService.watch(connection) : watcherService.watch(this.isThrowConnectError);
            if (value != null) {
                watcherService.write(value);
            }
            return value;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",mBeanWatcherService=").append(this.mBeanWatcherService != null ? this.mBeanWatcherService : this.mBeanWatcherServiceName);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Context
    extends Target {
        private static final long serialVersionUID = 566760345569101974L;

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            return this.watcher.getContextValue(this.contextKey);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",contextKey=").append(this.contextKey);
            buf.append('}');
            return buf.toString();
        }
    }

    public static class Timestamp
    extends Target {
        private static final long serialVersionUID = 3632167440398869434L;
        public static final String DEFAULT_KEY = "Timestamp";
        private String format;

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        @Override
        public String getKey() {
            return super.getKey() != null ? super.getKey() : DEFAULT_KEY;
        }

        @Override
        public Object getValue(MBeanServerConnection connection) throws Exception {
            Date value;
            Date date = value = this.format == null ? new Date() : new SimpleDateFormat(this.format).format(new Date());
            if (value != null && this.contextKey != null) {
                this.watcher.setContextValue(this.contextKey, value);
            }
            return value;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.deleteCharAt(buf.length() - 1);
            buf.append(",format=").append(this.format);
            buf.append('}');
            return buf.toString();
        }
    }

    public static abstract class Target
    implements Serializable {
        private static final long serialVersionUID = 3184726605262675808L;
        protected String key;
        protected transient Logger logger;
        protected transient MBeanWatcherService watcher;
        protected ServiceName watcherServiceName;
        protected String contextKey;

        protected void setWatcherServiceName(ServiceName name) {
            this.watcherServiceName = name;
        }

        protected ServiceName getWatcherServiceName() {
            return this.watcherServiceName;
        }

        protected void setWatcherService(MBeanWatcherService watcher) {
            this.watcher = watcher;
        }

        protected MBeanWatcherService getWatcherService() {
            return this.watcher;
        }

        protected void setLogger(Logger logger) {
            this.logger = logger;
        }

        protected Logger getLogger() {
            return this.logger == null ? ServiceManagerFactory.getLogger() : this.logger;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getContextKey() {
            return this.contextKey;
        }

        public void setContextKey(String key) {
            this.contextKey = key;
        }

        public abstract Object getValue(MBeanServerConnection var1) throws Exception;

        protected static BigDecimal toBigDecimal(Object value, boolean isNullToZero) throws NumberFormatException {
            BigDecimal result = null;
            result = value == null ? (isNullToZero ? new BigDecimal(0.0) : null) : (value instanceof BigDecimal ? (BigDecimal)value : (value instanceof BigInteger ? new BigDecimal((BigInteger)value) : (value instanceof Double || value instanceof Float ? new BigDecimal(((Number)value).doubleValue()) : (value instanceof Number ? BigDecimal.valueOf(((Number)value).longValue()) : new BigDecimal(value.toString())))));
            return result;
        }

        public void reset() {
        }

        public void start() {
        }

        public void stop() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("key=").append(this.getKey());
            buf.append('}');
            return buf.toString();
        }
    }
}

