/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import jp.ossc.nimbus.beans.MethodEditor;
import jp.ossc.nimbus.core.FactoryServiceBase;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.DefaultMethodInvocationContext;
import jp.ossc.nimbus.service.aop.DefaultThreadLocalInterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainFactory;
import jp.ossc.nimbus.service.aop.InterceptorChainList;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.proxy.RemoteClientServiceMBean;

public class RemoteClientService
extends FactoryServiceBase
implements RemoteClientServiceMBean {
    private static final long serialVersionUID = 3941978902210348640L;
    private String remoteInterfaceClassName;
    private Class remoteInterfaceClass;
    private ServiceName remoteServiceName;
    private ServiceName interceptorChainListServiceName;
    private ServiceName invokerServiceName;
    private ServiceName interceptorChainFactoryServiceName;
    private InterceptorChainFactory interceptorChainFactory;
    private Object proxy;
    private boolean isCreateNewProxy;
    private boolean isCreateInterceptorChainByProxy;

    @Override
    public void setRemoteInterfaceClassName(String className) {
        this.remoteInterfaceClassName = className;
    }

    @Override
    public String getRemoteInterfaceClassName() {
        return this.remoteInterfaceClassName;
    }

    @Override
    public void setRemoteServiceName(ServiceName name) {
        this.remoteServiceName = name;
    }

    @Override
    public ServiceName getRemoteServiceName() {
        return this.remoteServiceName;
    }

    @Override
    public void setInterceptorChainListServiceName(ServiceName name) {
        this.interceptorChainListServiceName = name;
    }

    @Override
    public ServiceName getInterceptorChainListServiceName() {
        return this.interceptorChainListServiceName;
    }

    @Override
    public void setInvokerServiceName(ServiceName name) {
        this.invokerServiceName = name;
    }

    @Override
    public ServiceName getInvokerServiceName() {
        return this.invokerServiceName;
    }

    @Override
    public void setInterceptorChainFactoryServiceName(ServiceName name) {
        this.interceptorChainFactoryServiceName = name;
    }

    @Override
    public ServiceName getInterceptorChainFactoryServiceName() {
        return this.interceptorChainFactoryServiceName;
    }

    @Override
    public void setCreateNewProxy(boolean isCreate) {
        this.isCreateNewProxy = isCreate;
    }

    @Override
    public boolean isCreateNewProxy() {
        return this.isCreateNewProxy;
    }

    @Override
    public void setCreateInterceptorChainByProxy(boolean isCreate) {
        this.isCreateInterceptorChainByProxy = isCreate;
    }

    @Override
    public boolean isCreateInterceptorChainByProxy() {
        return this.isCreateInterceptorChainByProxy;
    }

    @Override
    public void startService() throws Exception {
        Object object;
        if (this.interceptorChainFactoryServiceName != null) {
            this.interceptorChainFactory = (InterceptorChainFactory)ServiceManagerFactory.getServiceObject(this.interceptorChainFactoryServiceName);
        }
        if (this.interceptorChainListServiceName != null) {
            object = (InterceptorChainList)ServiceManagerFactory.getServiceObject(this.interceptorChainListServiceName);
        }
        if (this.invokerServiceName != null) {
            object = (Invoker)ServiceManagerFactory.getServiceObject(this.invokerServiceName);
        }
        this.remoteInterfaceClass = Class.forName(this.remoteInterfaceClassName, true, NimbusClassLoader.getInstance());
    }

    @Override
    protected synchronized Object createInstance() throws Exception {
        if (this.isCreateNewProxy) {
            return Proxy.newProxyInstance(NimbusClassLoader.getInstance(), new Class[]{this.remoteInterfaceClass}, (InvocationHandler)(this.interceptorChainFactory == null ? new ClientInvocationHandler(this.remoteServiceName, this.interceptorChainListServiceName, this.invokerServiceName, this.isCreateInterceptorChainByProxy) : new ClientInvocationHandler(this.remoteServiceName, this.interceptorChainFactory)));
        }
        if (this.proxy == null) {
            this.proxy = Proxy.newProxyInstance(NimbusClassLoader.getInstance(), new Class[]{this.remoteInterfaceClass}, (InvocationHandler)(this.interceptorChainFactory == null ? new ClientInvocationHandler(this.remoteServiceName, this.interceptorChainListServiceName, this.invokerServiceName, this.isCreateInterceptorChainByProxy) : new ClientInvocationHandler(this.remoteServiceName, this.interceptorChainFactory)));
        }
        return this.proxy;
    }

    private static class ClientInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 2467674523158858020L;
        private final transient InterceptorChain chain;
        private ServiceName remoteServiceName;
        private transient InterceptorChainFactory interceptorChainFactory;

        public ClientInvocationHandler(ServiceName remoteServiceName, InterceptorChainFactory interceptorChainFactory) {
            this.remoteServiceName = remoteServiceName;
            this.interceptorChainFactory = interceptorChainFactory;
            this.chain = null;
        }

        public ClientInvocationHandler(ServiceName remoteServiceName, ServiceName interceptorChainListServiceName, ServiceName invokerServiceName, boolean isCreateInterceptorChainByProxy) {
            this.remoteServiceName = remoteServiceName;
            this.chain = isCreateInterceptorChainByProxy ? new DefaultThreadLocalInterceptorChain(interceptorChainListServiceName == null ? null : (InterceptorChainList)ServiceManagerFactory.getServiceObject(interceptorChainListServiceName), (Invoker)ServiceManagerFactory.getServiceObject(invokerServiceName)) : new DefaultThreadLocalInterceptorChain(interceptorChainListServiceName, invokerServiceName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            DefaultMethodInvocationContext ctx = new DefaultMethodInvocationContext(proxy, method, args);
            if (this.remoteServiceName != null) {
                ctx.setTargetObject(this.remoteServiceName);
            }
            InterceptorChain chain = this.chain;
            if (this.interceptorChainFactory != null) {
                String key = null;
                if (method != null) {
                    MethodEditor editor = new MethodEditor();
                    editor.setValue(method);
                    key = editor.getAsText();
                }
                chain = this.interceptorChainFactory.getInterceptorChain(key);
            }
            try {
                chain.setCurrentInterceptorIndex(-1);
                Object object = chain.invokeNext(ctx);
                return object;
            }
            finally {
                chain.setCurrentInterceptorIndex(-1);
            }
        }
    }
}

