/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import jp.ossc.nimbus.beans.MethodEditor;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.DefaultInterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainFactory;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.invoker.MethodReflectionCallInvokerService;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.keepalive.KeepAliveChecker;
import jp.ossc.nimbus.service.keepalive.KeepAliveListener;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.performance.ResourceUsage;
import jp.ossc.nimbus.service.proxy.RemoteServerInvoker;
import jp.ossc.nimbus.service.proxy.RemoteServiceCallException;
import jp.ossc.nimbus.service.proxy.RemoteServiceServerServiceMBean;
import jp.ossc.nimbus.service.proxy.invoker.KeepAliveCheckInvoker;
import jp.ossc.nimbus.service.repository.Repository;

public class RemoteServiceServerService
extends ServiceBase
implements RemoteServiceServerServiceMBean {
    private static final long serialVersionUID = -1165545167180777753L;
    private ServiceName remoteServiceName;
    private ServiceName interceptorChainListServiceName;
    private ServiceName invokerServiceName;
    private MethodReflectionCallInvokerService defaultInvoker;
    private ServiceName interceptorChainFactoryServiceName;
    private InterceptorChainFactory interceptorChainFactory;
    private ServiceName jndiRepositoryServiceName;
    private Repository jndiRepository;
    private String jndiName;
    private int rmiPort;
    private ServiceName clusterServiceName;
    private ClusterService cluster;
    private String clusterOptionKey;
    private boolean isClusterJoin = true;
    private ServiceName resourceUsageServiceName;
    private ResourceUsage resourceUsage;
    private ServiceName clientSocketFactoryServiceName;
    private RMIClientSocketFactory clientSocketFactory;
    private ServiceName serverSocketFactoryServiceName;
    private RMIServerSocketFactory serverSocketFactory;
    private RemoteServerInvokerImpl remoteServerInvoker;
    private ServiceName externalizerServiceName;
    private Externalizer externalizer;

    @Override
    public void setRemoteServiceName(ServiceName name) {
        this.remoteServiceName = name;
    }

    @Override
    public ServiceName getRemoteServiceName() {
        return this.remoteServiceName;
    }

    @Override
    public void setInterceptorChainListServiceName(ServiceName name) {
        this.interceptorChainListServiceName = name;
    }

    @Override
    public ServiceName getInterceptorChainListServiceName() {
        return this.interceptorChainListServiceName;
    }

    @Override
    public void setInvokerServiceName(ServiceName name) {
        this.invokerServiceName = name;
    }

    @Override
    public ServiceName getInvokerServiceName() {
        return this.invokerServiceName;
    }

    @Override
    public void setInterceptorChainFactoryServiceName(ServiceName name) {
        this.interceptorChainFactoryServiceName = name;
    }

    @Override
    public ServiceName getInterceptorChainFactoryServiceName() {
        return this.interceptorChainFactoryServiceName;
    }

    @Override
    public void setJndiName(String name) {
        this.jndiName = name;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    @Override
    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    @Override
    public void setRMIPort(int port) {
        this.rmiPort = port;
    }

    @Override
    public int getRMIPort() {
        return this.rmiPort;
    }

    @Override
    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    @Override
    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    @Override
    public void setClusterOptionKey(String key) {
        this.clusterOptionKey = key;
    }

    @Override
    public String getClusterOptionKey() {
        return this.clusterOptionKey;
    }

    @Override
    public void setClusterJoin(boolean isJoin) {
        this.isClusterJoin = isJoin;
    }

    @Override
    public boolean isClusterJoin() {
        return this.isClusterJoin;
    }

    @Override
    public void setResourceUsageServiceName(ServiceName name) {
        this.resourceUsageServiceName = name;
    }

    @Override
    public ServiceName getResourceUsageServiceName() {
        return this.resourceUsageServiceName;
    }

    @Override
    public void setRMIClientSocketFactoryServiceName(ServiceName name) {
        this.clientSocketFactoryServiceName = name;
    }

    @Override
    public ServiceName getRMIClientSocketFactoryServiceName() {
        return this.clientSocketFactoryServiceName;
    }

    @Override
    public void setRMIServerSocketFactoryServiceName(ServiceName name) {
        this.serverSocketFactoryServiceName = name;
    }

    @Override
    public ServiceName getRMIServerSocketFactoryServiceName() {
        return this.serverSocketFactoryServiceName;
    }

    @Override
    public void setExternalizerServiceName(ServiceName name) {
        this.externalizerServiceName = name;
    }

    @Override
    public ServiceName getExternalizerServiceName() {
        return this.externalizerServiceName;
    }

    public void setRMIClientSocketFactory(RMIClientSocketFactory csf) {
        this.clientSocketFactory = csf;
    }

    public void setRMIServerSocketFactory(RMIServerSocketFactory ssf) {
        this.serverSocketFactory = ssf;
    }

    public void setResourceUsage(ResourceUsage usage) {
        this.resourceUsage = usage;
    }

    public void setExternalizer(Externalizer ext) {
        this.externalizer = ext;
    }

    @Override
    public void startService() throws Exception {
        if (this.resourceUsage == null && this.resourceUsageServiceName != null) {
            this.resourceUsage = (ResourceUsage)ServiceManagerFactory.getServiceObject(this.resourceUsageServiceName);
        }
        if (this.interceptorChainFactoryServiceName != null) {
            this.interceptorChainFactory = (InterceptorChainFactory)ServiceManagerFactory.getServiceObject(this.interceptorChainFactoryServiceName);
        } else if (this.getInvokerServiceName() == null) {
            if (this.defaultInvoker == null) {
                this.defaultInvoker = new MethodReflectionCallInvokerService();
                this.defaultInvoker.create();
                this.defaultInvoker.start();
            } else {
                this.defaultInvoker.start();
            }
        } else {
            Invoker invoker = (Invoker)ServiceManagerFactory.getServiceObject(this.getInvokerServiceName());
            this.defaultInvoker = null;
        }
        if (this.jndiRepositoryServiceName == null && this.clusterServiceName == null) {
            throw new IllegalArgumentException("jndiRepositoryServiceName or clusterServiceName must be specified.");
        }
        if (this.externalizerServiceName != null) {
            this.externalizer = (Externalizer)ServiceManagerFactory.getServiceObject(this.externalizerServiceName);
        }
        this.remoteServerInvoker = this.interceptorChainFactory == null ? new RemoteServerInvokerImpl(this.interceptorChainListServiceName, this.invokerServiceName, this.defaultInvoker, this.remoteServiceName, this.resourceUsage, this.rmiPort, this.clientSocketFactory != null ? this.clientSocketFactory : (this.clientSocketFactoryServiceName != null ? (RMIClientSocketFactory)ServiceManagerFactory.getServiceObject(this.clientSocketFactoryServiceName) : null), this.serverSocketFactory != null ? this.serverSocketFactory : (this.serverSocketFactoryServiceName != null ? (RMIServerSocketFactory)ServiceManagerFactory.getServiceObject(this.serverSocketFactoryServiceName) : null), this.getLogger(), this.externalizer) : new RemoteServerInvokerImpl(this.interceptorChainFactory, this.remoteServiceName, this.resourceUsage, this.rmiPort, this.clientSocketFactory != null ? this.clientSocketFactory : (this.clientSocketFactoryServiceName != null ? (RMIClientSocketFactory)ServiceManagerFactory.getServiceObject(this.clientSocketFactoryServiceName) : null), this.serverSocketFactory != null ? this.serverSocketFactory : (this.serverSocketFactoryServiceName != null ? (RMIServerSocketFactory)ServiceManagerFactory.getServiceObject(this.serverSocketFactoryServiceName) : null), this.getLogger(), this.externalizer);
        if (this.jndiRepositoryServiceName != null) {
            if (this.jndiName == null && this.remoteServiceName == null) {
                throw new IllegalArgumentException("jndiName or remoteServiceName must be specified.");
            }
            if (this.jndiName == null) {
                this.jndiName = this.remoteServiceName.getServiceManagerName() + '/' + this.remoteServiceName.getServiceName();
            }
            this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
            if (!this.jndiRepository.register(this.jndiName, this.remoteServerInvoker)) {
                throw new Exception("Could not register in jndiRepository.");
            }
        }
        if (this.clusterServiceName != null) {
            this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
            if (this.cluster.isJoin()) {
                throw new IllegalArgumentException("ClusterService already join.");
            }
            RemoteServiceClientInvoker remoteServiceClientInvoker = new RemoteServiceClientInvoker((RemoteServerInvoker)this.remoteServerInvoker.getStub(), this.externalizer);
            if (this.clusterOptionKey == null) {
                this.cluster.setOption(remoteServiceClientInvoker);
            } else {
                this.cluster.setOption(this.clusterOptionKey, remoteServiceClientInvoker);
            }
            if (this.isClusterJoin) {
                this.cluster.join();
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.defaultInvoker != null) {
            this.defaultInvoker.stop();
        }
        if (this.cluster != null) {
            if (this.isClusterJoin) {
                this.cluster.leave();
            }
            this.cluster = null;
        }
        if (this.jndiRepository != null) {
            this.jndiRepository.unregister(this.jndiName);
        }
        if (this.remoteServerInvoker != null) {
            try {
                UnicastRemoteObject.unexportObject(this.remoteServerInvoker, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            this.remoteServerInvoker = null;
        }
    }

    @Override
    public void destroyService() throws Exception {
        if (this.defaultInvoker != null) {
            this.defaultInvoker.destroy();
            this.defaultInvoker = null;
        }
    }

    public static class RemoteServiceClientInvoker
    implements KeepAliveCheckInvoker,
    Serializable {
        private static final long serialVersionUID = 7098276664964190910L;
        private RemoteServerInvoker serverInvoker;
        private InetAddress serverAddress;
        private transient InetAddress clientAddress;
        private Externalizer externalizer;

        public RemoteServiceClientInvoker() {
        }

        public RemoteServiceClientInvoker(RemoteServerInvoker server, Externalizer externalizer) throws IOException {
            this.serverInvoker = server;
            String hostName = System.getProperty("java.rmi.server.hostname");
            this.serverAddress = hostName == null ? InetAddress.getLocalHost() : InetAddress.getByName(hostName);
            this.externalizer = externalizer;
        }

        @Override
        public Object invoke(InvocationContext context) throws Throwable {
            Object[] params = null;
            try {
                MethodInvocationContext methodContext;
                context.setAttribute("ClientAddress", this.clientAddress);
                if (this.externalizer != null && (params = (methodContext = (MethodInvocationContext)context).getParameters()) != null && params.length != 0) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.externalizer.writeExternal((Object)params, baos);
                    methodContext.setParameters(new Object[]{baos.toByteArray()});
                }
                Object ret = this.serverInvoker.invoke(context);
                if (this.externalizer != null && ret != null) {
                    ret = this.externalizer.readExternal(new ByteArrayInputStream((byte[])ret));
                }
                Object object = ret;
                return object;
            }
            catch (RemoteException e) {
                throw new RemoteServiceCallException(e);
            }
            finally {
                if (this.externalizer != null && params != null && params.length != 0) {
                    MethodInvocationContext methodContext = (MethodInvocationContext)context;
                    methodContext.setParameters(params);
                }
            }
        }

        @Override
        public boolean isAlive() {
            try {
                return this.serverInvoker.isAlive(null);
            }
            catch (RemoteException e) {
                ServiceManagerFactory.getLogger().write("RSS__00002", e);
                return false;
            }
            catch (Throwable e) {
                ServiceManagerFactory.getLogger().write("RSS__00001", e);
                return false;
            }
        }

        @Override
        public void addKeepAliveListener(KeepAliveListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeKeepAliveListener(KeepAliveListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearKeepAliveListener() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getHostInfo() {
            return this.serverAddress;
        }

        @Override
        public Comparable getResourceUsage() {
            try {
                return this.serverInvoker.getResourceUsage();
            }
            catch (RemoteException e) {
                ServiceManagerFactory.getLogger().write("RSS__00002", e);
                return null;
            }
            catch (Throwable e) {
                ServiceManagerFactory.getLogger().write("RSS__00001", e);
                return null;
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.clientAddress = InetAddress.getLocalHost();
        }
    }

    public static class RemoteServerInvokerImpl
    extends RemoteServer
    implements RemoteServerInvoker {
        private static final long serialVersionUID = -2397154705661936441L;
        private final ServiceName interceptorChainListServiceName;
        private final ServiceName invokerServiceName;
        private final Invoker defaultInvoker;
        private final ServiceName remoteServiceName;
        private final InterceptorChainFactory interceptorChainFactory;
        private final Remote stub;
        private ResourceUsage resourceUsage;
        private Logger logger;
        private Externalizer externalizer;

        public RemoteServerInvokerImpl(InterceptorChainFactory interceptorChainFactory, ServiceName remoteServiceName, ResourceUsage usage, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, Logger log, Externalizer ext) throws RemoteException {
            this.stub = UnicastRemoteObject.exportObject(this, port, csf, ssf);
            this.interceptorChainListServiceName = null;
            this.invokerServiceName = null;
            this.defaultInvoker = null;
            this.interceptorChainFactory = interceptorChainFactory;
            this.remoteServiceName = remoteServiceName;
            this.resourceUsage = usage;
            this.logger = log;
            this.externalizer = ext;
        }

        public RemoteServerInvokerImpl(ServiceName interceptorChainListServiceName, ServiceName invokerServiceName, Invoker defaultInvoker, ServiceName remoteServiceName, ResourceUsage usage, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, Logger log, Externalizer ext) throws RemoteException {
            this.stub = UnicastRemoteObject.exportObject(this, port, csf, ssf);
            this.interceptorChainListServiceName = interceptorChainListServiceName;
            this.invokerServiceName = invokerServiceName;
            this.defaultInvoker = defaultInvoker;
            this.remoteServiceName = remoteServiceName;
            this.interceptorChainFactory = null;
            this.resourceUsage = usage;
            this.logger = log;
            this.externalizer = ext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(InvocationContext context) throws Exception {
            InterceptorChain chain = null;
            if (this.interceptorChainFactory == null) {
                chain = new DefaultInterceptorChain(this.interceptorChainListServiceName, this.invokerServiceName);
                if (this.invokerServiceName == null && this.defaultInvoker != null) {
                    ((DefaultInterceptorChain)chain).setInvoker(this.defaultInvoker);
                }
            } else {
                Method method;
                StringBuffer key = new StringBuffer();
                Object target = context.getTargetObject();
                if (target != null) {
                    key.append(target);
                }
                if (context instanceof MethodInvocationContext && (method = ((MethodInvocationContext)context).getTargetMethod()) != null) {
                    MethodEditor editor = new MethodEditor();
                    editor.setValue(method);
                    key.append(':').append(editor.getAsText());
                }
                chain = this.interceptorChainFactory.getInterceptorChain(key.length() == 0 ? null : key.toString());
            }
            ServiceName serviceName = null;
            if (context.getTargetObject() != null && context.getTargetObject() instanceof ServiceName) {
                serviceName = (ServiceName)context.getTargetObject();
                if (this.remoteServiceName != null && !this.remoteServiceName.equals(serviceName)) {
                    throw new IllegalAccessException(serviceName + " don't be allowed access.");
                }
            } else {
                serviceName = this.remoteServiceName;
            }
            if (serviceName != null) {
                Object object;
                MethodInvocationContext methodContext;
                Object[] params;
                context.setTargetObject(ServiceManagerFactory.getServiceObject(serviceName));
                if (this.externalizer != null && (params = (methodContext = (MethodInvocationContext)context).getParameters()) != null && params.length != 0) {
                    params = (Object[])this.externalizer.readExternal(new ByteArrayInputStream((byte[])params[0]));
                    methodContext.setParameters(params);
                }
                try {
                    chain.setCurrentInterceptorIndex(-1);
                    Object ret = chain.invokeNext(context);
                    if (this.externalizer != null && ret != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        this.externalizer.writeExternal(ret, baos);
                        ret = baos.toByteArray();
                    }
                    object = ret;
                    return object;
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (this.logger != null) {
                        this.logger.write("RSS__00001", e);
                    }
                    object = null;
                    return object;
                }
                finally {
                    chain.setCurrentInterceptorIndex(-1);
                }
            }
            throw new ServiceNotFoundException(null);
        }

        @Override
        public boolean isAlive(ServiceName name) {
            ServiceName serviceName = this.remoteServiceName;
            if (name != null) {
                if (this.remoteServiceName != null && !this.remoteServiceName.equals(name)) {
                    return false;
                }
                serviceName = name;
            }
            if (serviceName == null) {
                return true;
            }
            try {
                Service service = ServiceManagerFactory.getService(serviceName);
                Object serviceObject = ServiceManagerFactory.getServiceObject(serviceName);
                if (serviceObject instanceof KeepAliveChecker) {
                    return service != null && service.getState() == 3 && ((KeepAliveChecker)serviceObject).isAlive();
                }
                return service != null && service.getState() == 3;
            }
            catch (Throwable e) {
                if (this.logger != null) {
                    this.logger.write("RSS__00001", e);
                }
                return false;
            }
        }

        @Override
        public Comparable getResourceUsage() {
            return this.resourceUsage == null ? null : this.resourceUsage.getUsage();
        }

        public Remote getStub() {
            return this.stub;
        }
    }
}

