/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ConnectionCreateException;
import jp.ossc.nimbus.service.publish.DistributedClientConnectionFactoryImpl;
import jp.ossc.nimbus.service.publish.DistributedConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.publish.DistributedServerConnectionImpl;
import jp.ossc.nimbus.service.publish.RemoteClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.repository.Repository;

public class DistributedConnectionFactoryService
extends ServiceBase
implements ClientConnectionFactory,
ServerConnectionFactory,
DistributedConnectionFactoryServiceMBean {
    private static final long serialVersionUID = 8772125021331668413L;
    private int distributedSize = 1;
    private ServiceName connectionFactoryFactoryServiceName;
    private ServiceName jndiRepositoryServiceName;
    private String jndiName = "publish/ClientConnectionFactory";
    private int rmiPort;
    private Repository jndiRepository;
    private DistributedServerConnectionImpl serverConnection;
    private DistributedClientConnectionFactoryImpl clientConnectionFactory;
    private RemoteClientConnectionFactory remoteClientConnectionFactory;

    @Override
    public void setDistributedSize(int size) {
        this.distributedSize = size;
    }

    @Override
    public int getDistributedSize() {
        return this.distributedSize;
    }

    @Override
    public void setConnectionFactoryFactoryServiceName(ServiceName name) {
        this.connectionFactoryFactoryServiceName = name;
    }

    @Override
    public ServiceName getConnectionFactoryFactoryServiceName() {
        return this.connectionFactoryFactoryServiceName;
    }

    @Override
    public void setJndiName(String name) {
        this.jndiName = name;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    @Override
    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    @Override
    public void setRMIPort(int port) {
        this.rmiPort = port;
    }

    @Override
    public int getRMIPort() {
        return this.rmiPort;
    }

    public Repository getJndiRepository() {
        return this.jndiRepository;
    }

    public void setJndiRepository(Repository repository) {
        this.jndiRepository = repository;
    }

    @Override
    public void startService() throws Exception {
        this.serverConnection = new DistributedServerConnectionImpl();
        this.clientConnectionFactory = new DistributedClientConnectionFactoryImpl();
        for (int i = 0; i < this.distributedSize; ++i) {
            Object connectionFactory = ServiceManagerFactory.getServiceObject(this.connectionFactoryFactoryServiceName);
            if (!(connectionFactory instanceof ClientConnectionFactory) || !(connectionFactory instanceof ServerConnectionFactory)) {
                throw new IllegalArgumentException("ConnectionFactory is not ClientConnectionFactory and ServerConnectionFactory." + this.connectionFactoryFactoryServiceName + " : " + connectionFactory);
            }
            this.serverConnection.addServerConnection(((ServerConnectionFactory)connectionFactory).getServerConnection());
            this.clientConnectionFactory.addClientConnectionFactory((ClientConnectionFactory)connectionFactory);
        }
        if (this.jndiRepositoryServiceName != null) {
            this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
        }
        if (this.jndiRepository != null && this.jndiName != null) {
            this.remoteClientConnectionFactory = new RemoteClientConnectionFactory(this, this.rmiPort);
            if (!this.jndiRepository.register(this.jndiName, this.remoteClientConnectionFactory)) {
                throw new Exception("Could not register in jndiRepository.");
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.jndiRepository != null) {
            this.jndiRepository.unregister(this.jndiName);
        }
        if (this.remoteClientConnectionFactory != null) {
            try {
                UnicastRemoteObject.unexportObject(this.remoteClientConnectionFactory, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            this.remoteClientConnectionFactory = null;
        }
        this.serverConnection = null;
        this.clientConnectionFactory = null;
    }

    @Override
    public ClientConnection getClientConnection() throws ConnectionCreateException, RemoteException {
        return this.clientConnectionFactory.getClientConnection();
    }

    @Override
    public int getClientCount() throws RemoteException {
        return this.clientConnectionFactory.getClientCount();
    }

    @Override
    public ServerConnection getServerConnection() throws ConnectionCreateException {
        return this.serverConnection;
    }
}

