/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.publish.Client;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageForwardingServiceMBean;
import jp.ossc.nimbus.service.publish.MessageListener;
import jp.ossc.nimbus.service.publish.MessageReceiverService;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.publish.ServerConnectionListener;

public class MessageForwardingService
extends MessageReceiverService
implements MessageForwardingServiceMBean,
ServerConnectionListener {
    private static final long serialVersionUID = 5179315238481930410L;
    private String sendErrorMessageId = "PMFS_00001";
    private String forwardErrorMessageId = "PMFS_00002";
    private ServerConnectionFactory serverConnectionFactory;
    private ServiceName serverConnectionFactoryServiceName;
    private boolean isAsynchSend;
    private Map clientMap;
    private ClientMessageListener myMessageListener;
    private Map subjects;
    private ServerConnection serverConnection;

    @Override
    public String getSendErrorMessageId() {
        return this.sendErrorMessageId;
    }

    @Override
    public void setSendErrorMessageId(String id) {
        this.sendErrorMessageId = id;
    }

    @Override
    public String getForwardErrorMessageId() {
        return this.forwardErrorMessageId;
    }

    @Override
    public void setForwardErrorMessageId(String id) {
        this.forwardErrorMessageId = id;
    }

    @Override
    public ServiceName getServerConnectionFactoryServiceName() {
        return this.serverConnectionFactoryServiceName;
    }

    @Override
    public void setServerConnectionFactoryServiceName(ServiceName serverConnectionFactoryServiceName) {
        this.serverConnectionFactoryServiceName = serverConnectionFactoryServiceName;
    }

    public void setServerConnectionFactory(ServerConnectionFactory serverConnectionFactory) {
        this.serverConnectionFactory = serverConnectionFactory;
    }

    public ServerConnectionFactory getServerConnectionFactory() {
        return this.serverConnectionFactory;
    }

    @Override
    public void setAsynchSend(boolean isAsynch) {
        this.isAsynchSend = isAsynch;
    }

    @Override
    public boolean isAsynchSend() {
        return this.isAsynchSend;
    }

    @Override
    public void addSubject(String subject) {
        this.addSubject(subject, null);
    }

    @Override
    public void addSubject(String subject, String[] keys) {
        Set<Object> keySet;
        if (this.subjects == null) {
            this.subjects = Collections.synchronizedMap(new HashMap());
        }
        if ((keySet = (Set<Object>)this.subjects.get(subject)) == null) {
            keySet = Collections.synchronizedSet(new HashSet());
            this.subjects.put(subject, keySet);
        }
        if (keys == null) {
            keySet.add(null);
        } else {
            for (int i = 0; i < keys.length; ++i) {
                keySet.add(keys[i]);
            }
        }
    }

    @Override
    public void createService() throws Exception {
        super.createService();
        this.clientMap = Collections.synchronizedMap(new LinkedHashMap());
        this.myMessageListener = new ClientMessageListener();
    }

    @Override
    public void startService() throws Exception {
        if (this.serverConnectionFactory != null) {
            this.serverConnection = this.serverConnectionFactory.getServerConnection();
        } else if (this.serverConnectionFactoryServiceName != null) {
            this.serverConnectionFactory = (ServerConnectionFactory)ServiceManagerFactory.getServiceObject(this.serverConnectionFactoryServiceName);
            this.serverConnection = this.serverConnectionFactory.getServerConnection();
        } else {
            throw new IllegalArgumentException("ServerConnectionFactoryServiceName is null.");
        }
        this.serverConnection.addServerConnectionListener(this);
        super.startService();
    }

    @Override
    public void stopService() throws Exception {
        this.serverConnection.removeServerConnectionListener(this);
        super.stopService();
        this.serverConnection = null;
    }

    @Override
    public void destroyService() throws Exception {
        this.clientMap = null;
        this.myMessageListener = null;
        super.destroyService();
    }

    @Override
    protected void handleMessage(Message message) {
        for (String sbj : message.getSubjects()) {
            block7: {
                MessageReceiverService.Subject subject = (MessageReceiverService.Subject)this.subjectMap.get(sbj);
                if (subject == null || !subject.existsMessageListener(message)) continue;
                subject.onMessage(message);
                try {
                    if (this.isAsynchSend) {
                        this.serverConnection.sendAsynch(this.serverConnection.castMessage(message));
                    } else {
                        this.serverConnection.send(this.serverConnection.castMessage(message));
                    }
                }
                catch (MessageException e) {
                    if (this.forwardErrorMessageId != null) {
                        this.getLogger().write(this.forwardErrorMessageId, new Object[]{this.serverConnection, message}, (Throwable)e);
                    }
                }
                catch (MessageSendException e) {
                    if (this.forwardErrorMessageId == null) break block7;
                    this.getLogger().write(this.forwardErrorMessageId, new Object[]{this.serverConnection, message}, (Throwable)e);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnect(Client client) {
        Map map = this.clientMap;
        synchronized (map) {
            block12: {
                block11: {
                    try {
                        if (!this.isConnected()) {
                            this.connect();
                        }
                    }
                    catch (Exception e) {
                        if (this.sendErrorMessageId == null) break block11;
                        this.getLogger().write(this.sendErrorMessageId, new Object[]{client}, (Throwable)e);
                    }
                }
                if (this.clientMap.size() == 0 && this.subjects != null) {
                    try {
                        for (Map.Entry entry : this.subjects.entrySet()) {
                            String subject = (String)entry.getKey();
                            Set keySet = (Set)entry.getValue();
                            this.addSubject(this.myMessageListener, subject, keySet.toArray(new String[keySet.size()]));
                        }
                    }
                    catch (MessageSendException e) {
                        if (this.sendErrorMessageId == null) break block12;
                        this.getLogger().write(this.sendErrorMessageId, new Object[]{client}, (Throwable)e);
                    }
                }
            }
            if (!this.clientMap.containsKey(client.getId())) {
                this.clientMap.put(client.getId(), new ClientMessageListener());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAddSubject(Client client, String subject, String[] keys) {
        Map map = this.clientMap;
        synchronized (map) {
            block6: {
                try {
                    MessageListener listener = (MessageListener)this.clientMap.get(client.getId());
                    if (listener != null) {
                        this.addSubject(listener, subject, keys);
                    }
                }
                catch (MessageSendException e) {
                    if (this.sendErrorMessageId == null) break block6;
                    this.getLogger().write(this.sendErrorMessageId, new Object[]{client}, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRemoveSubject(Client client, String subject, String[] keys) {
        Map map = this.clientMap;
        synchronized (map) {
            block6: {
                try {
                    MessageListener listener = (MessageListener)this.clientMap.get(client.getId());
                    if (listener != null) {
                        this.removeSubject(listener, subject, keys);
                    }
                }
                catch (MessageSendException e) {
                    if (this.sendErrorMessageId == null) break block6;
                    this.getLogger().write(this.sendErrorMessageId, new Object[]{client}, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStartReceive(Client client, long from) {
        Map map = this.clientMap;
        synchronized (map) {
            block6: {
                try {
                    MessageListener listener = (MessageListener)this.clientMap.get(client.getId());
                    if (listener != null) {
                        this.startReceive(from);
                    }
                }
                catch (MessageSendException e) {
                    if (this.sendErrorMessageId == null) break block6;
                    this.getLogger().write(this.sendErrorMessageId, new Object[]{client}, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void onStopReceive(Client client) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClose(Client client) {
        Map map = this.clientMap;
        synchronized (map) {
            block7: {
                try {
                    MessageListener listener = (MessageListener)this.clientMap.get(client.getId());
                    if (listener != null) {
                        this.removeMessageListener(listener);
                    }
                    this.clientMap.remove(client.getId());
                    if (this.clientMap.size() == 0) {
                        this.removeMessageListener(this.myMessageListener);
                        this.stopReceive();
                        this.serverConnection.reset();
                    }
                }
                catch (MessageSendException e) {
                    if (this.sendErrorMessageId == null) break block7;
                    this.getLogger().write(this.sendErrorMessageId, new Object[]{client}, (Throwable)e);
                }
            }
        }
    }

    private class ClientMessageListener
    implements MessageListener {
        private ClientMessageListener() {
        }

        @Override
        public void onMessage(Message message) {
        }
    }
}

