/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.publish.Client;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ConnectionCreateException;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageCreateException;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageListener;
import jp.ossc.nimbus.service.publish.MessageReceiver;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.RequestConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.publish.RequestMessageListener;
import jp.ossc.nimbus.service.publish.RequestServerConnection;
import jp.ossc.nimbus.service.publish.RequestTimeoutException;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.publish.ServerConnectionListener;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class RequestConnectionFactoryService
extends ServiceBase
implements ServerConnectionFactory,
MessageReceiver,
RequestConnectionFactoryServiceMBean {
    private static final long serialVersionUID = -3122390503708261498L;
    private ServiceName serverConnectionFactoryServiceName;
    private RequestServerConnectionImpl serverConnection;
    private ServiceName messageReceiverServiceName;
    private MessageReceiver messageReceiver;
    private Map messageListenerMap;
    private int sequence;
    private boolean isAsynchResponse;
    private int responseRetryCount = 1;
    private long responseRetryInterval = 50L;
    private String responseErrorRetryMessageId = "PRCF_00001";
    private String responseErrorMessageId = "PRCF_00002";
    private String readMessageErrorMessageId = "PRCF_00003";
    private long sendProcessTime;
    private long sendProcessCount;
    private long responseProcessTime;
    private long responseProcessCount;
    private long receiveProcessTime;
    private long receiveProcessCount;
    private long receiveSendProcessTime;
    private long receiveSendProcessCount;
    private Timer timeoutTimer;

    @Override
    public void setServerConnectionFactoryServiceName(ServiceName name) {
        this.serverConnectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getServerConnectionFactoryServiceName() {
        return this.serverConnectionFactoryServiceName;
    }

    @Override
    public void setMessageReceiverServiceName(ServiceName name) {
        this.messageReceiverServiceName = name;
    }

    @Override
    public ServiceName getMessageReceiverServiceName() {
        return this.messageReceiverServiceName;
    }

    @Override
    public void setAsynchResponse(boolean isAsynch) {
        this.isAsynchResponse = isAsynch;
    }

    @Override
    public boolean isAsynchResponse() {
        return this.isAsynchResponse;
    }

    @Override
    public void setResponseRetryCount(int count) {
        this.responseRetryCount = count;
    }

    @Override
    public int getResponseRetryCount() {
        return this.responseRetryCount;
    }

    @Override
    public void setResponseRetryInterval(long interval) {
        this.responseRetryInterval = interval;
    }

    @Override
    public long getResponseRetryInterval() {
        return this.responseRetryInterval;
    }

    @Override
    public void setResponseErrorRetryMessageId(String id) {
        this.responseErrorRetryMessageId = id;
    }

    @Override
    public String getResponseErrorRetryMessageId() {
        return this.responseErrorRetryMessageId;
    }

    @Override
    public void setResponseErrorMessageId(String id) {
        this.responseErrorMessageId = id;
    }

    @Override
    public String getResponseErrorMessageId() {
        return this.responseErrorMessageId;
    }

    @Override
    public void setReadMessageErrorMessageId(String id) {
        this.readMessageErrorMessageId = id;
    }

    @Override
    public String getReadMessageErrorMessageId() {
        return this.readMessageErrorMessageId;
    }

    @Override
    public double getAverageSendProcessTime() {
        return this.sendProcessCount == 0L ? 0.0 : (double)this.sendProcessTime / (double)this.sendProcessCount;
    }

    @Override
    public double getAverageResponseProcessTime() {
        return this.responseProcessCount == 0L ? 0.0 : (double)this.responseProcessTime / (double)this.responseProcessCount;
    }

    @Override
    public double getAverageReceiveProcessTime() {
        return this.receiveProcessCount == 0L ? 0.0 : (double)this.receiveProcessTime / (double)this.receiveProcessCount;
    }

    @Override
    public double getAverageReceiveSendProcessTime() {
        return this.receiveSendProcessCount == 0L ? 0.0 : (double)this.receiveSendProcessTime / (double)this.receiveSendProcessCount;
    }

    @Override
    public void createService() throws Exception {
        this.messageListenerMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void startService() throws Exception {
        this.timeoutTimer = new Timer(true);
        if (this.messageReceiverServiceName == null) {
            throw new IllegalArgumentException("MessageReceiverServiceName must be specified.");
        }
        this.messageReceiver = (MessageReceiver)ServiceManagerFactory.getServiceObject(this.messageReceiverServiceName);
        if (this.serverConnectionFactoryServiceName == null) {
            throw new IllegalArgumentException("ServerConnectionFactoryServiceName must be specified.");
        }
        ServerConnectionFactory serverConnectionFactory = (ServerConnectionFactory)ServiceManagerFactory.getServiceObject(this.serverConnectionFactoryServiceName);
        this.serverConnection = new RequestServerConnectionImpl(serverConnectionFactory.getServerConnection());
    }

    @Override
    public void stopService() throws Exception {
        this.serverConnection.close();
        this.serverConnection = null;
        this.sequence = 0;
        this.timeoutTimer.cancel();
        this.timeoutTimer = null;
    }

    @Override
    public void destroyService() throws Exception {
        this.messageListenerMap = null;
    }

    @Override
    public ServerConnection getServerConnection() throws ConnectionCreateException {
        return this.serverConnection;
    }

    @Override
    public void addSubject(MessageListener listener, String subject) throws MessageSendException {
        this.addSubject(listener, subject, null);
    }

    @Override
    public void addSubject(MessageListener listener, String subject, String[] keys) throws MessageSendException {
        listener = this.getMessageListenerWrapper(listener, true);
        this.messageReceiver.addSubject(listener, subject, keys);
    }

    private MessageListener getMessageListenerWrapper(MessageListener listener, boolean isNew) {
        if (listener instanceof RequestMessageListener) {
            MessageListener wrapper = (MessageListener)this.messageListenerMap.get(listener);
            if (wrapper == null && isNew) {
                wrapper = new MessageListenerWrapper((RequestMessageListener)listener);
                this.messageListenerMap.put(listener, wrapper);
            }
            listener = wrapper;
        }
        return listener;
    }

    @Override
    public void removeSubject(MessageListener listener, String subject) throws MessageSendException {
        this.removeSubject(listener, subject, null);
    }

    @Override
    public void removeSubject(MessageListener listener, String subject, String[] keys) throws MessageSendException {
        MessageListener lst = listener;
        boolean hasWrapper = false;
        if (lst instanceof RequestMessageListener) {
            MessageListener wrapper = (MessageListener)this.messageListenerMap.get(lst);
            if (wrapper == null) {
                return;
            }
            hasWrapper = true;
            lst = wrapper;
        }
        this.messageReceiver.removeSubject(lst, subject, keys);
        Set subjects = this.messageReceiver.getSubjects(lst);
        if (hasWrapper && (subjects == null || subjects.size() == 0)) {
            this.messageListenerMap.remove(listener);
        }
    }

    @Override
    public void removeMessageListener(MessageListener listener) throws MessageSendException {
        if (listener instanceof RequestMessageListener) {
            MessageListener wrapper = (MessageListener)this.messageListenerMap.remove(listener);
            if (wrapper == null) {
                return;
            }
            listener = wrapper;
        }
        this.messageReceiver.removeMessageListener(listener);
    }

    @Override
    public Set getSubjects(MessageListener listener) {
        listener = this.getMessageListenerWrapper(listener, false);
        return this.messageReceiver == null ? null : this.messageReceiver.getSubjects(listener);
    }

    @Override
    public Set getKeys(MessageListener listener, String subject) {
        listener = this.getMessageListenerWrapper(listener, false);
        return this.messageReceiver == null ? null : this.messageReceiver.getKeys(listener, subject);
    }

    @Override
    public ClientConnection getClientConnection() {
        return this.messageReceiver == null ? null : this.messageReceiver.getClientConnection();
    }

    @Override
    public void connect() throws Exception {
        this.messageReceiver.connect();
    }

    @Override
    public void close() {
        this.messageReceiver.close();
    }

    @Override
    public boolean isConnected() {
        return this.messageReceiver == null ? false : this.messageReceiver.isConnected();
    }

    @Override
    public void startReceive() throws MessageSendException {
        this.messageReceiver.startReceive();
    }

    @Override
    public void stopReceive() throws MessageSendException {
        this.messageReceiver.stopReceive();
    }

    @Override
    public boolean isStartReceive() {
        return this.messageReceiver == null ? false : this.messageReceiver.isStartReceive();
    }

    @Override
    public Object getId() {
        return this.messageReceiver == null ? null : this.messageReceiver.getId();
    }

    private synchronized int getSequence() {
        return ++this.sequence;
    }

    private static class ResponseMessage
    extends AbstractMessage {
        public ResponseMessage() {
        }

        public ResponseMessage(Object source, int sequence, Object obj) {
            super(source, sequence, obj);
        }
    }

    private static class RequestMessage
    extends AbstractMessage {
        private String responseSubject;
        private String responseKey;

        public RequestMessage() {
        }

        public RequestMessage(Object source, int sequence, String responseSubject, String responseKey, Object obj) {
            super(source, sequence, obj);
            this.responseSubject = responseSubject;
            this.responseKey = responseKey;
        }

        public String getResponseSubject(Message request) {
            if (this.responseSubject != null) {
                return this.responseSubject;
            }
            return request.getSubject();
        }

        public String getResponseKey(Message request) {
            if (this.responseSubject != null || this.responseKey != null) {
                return this.responseKey;
            }
            return request.getKey();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.responseSubject);
            out.writeObject(this.responseKey);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.responseSubject = (String)in.readObject();
            this.responseKey = (String)in.readObject();
        }
    }

    private static abstract class AbstractMessage
    implements Externalizable {
        private Object sourceId;
        private Object object;
        private int sequence;

        public AbstractMessage() {
        }

        public AbstractMessage(Object source, int sequence, Object obj) {
            this.sourceId = source;
            this.sequence = sequence;
            this.object = obj;
        }

        public Object getSourceId() {
            return this.sourceId;
        }

        public int getSequence() {
            return this.sequence;
        }

        public Object getObject() {
            return this.object;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.sourceId);
            out.writeInt(this.sequence);
            out.writeObject(this.object);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.sourceId = in.readObject();
            this.sequence = in.readInt();
            this.object = in.readObject();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("sourceId=").append(this.sourceId);
            buf.append(", sequence=").append(this.sequence);
            buf.append(", object=").append(this.object);
            buf.append('}');
            return buf.toString();
        }
    }

    private class MessageListenerWrapper
    implements MessageListener {
        private RequestMessageListener requestMessageListener;

        public MessageListenerWrapper(RequestMessageListener listener) {
            this.requestMessageListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(Message message) {
            block50: {
                long receiveStartTime = System.currentTimeMillis();
                long receiveEndTime = -1L;
                long receiveSendStartTime = -1L;
                long receiveSendEndTime = -1L;
                try {
                    Object obj = null;
                    try {
                        obj = message.getObject();
                    }
                    catch (MessageException e) {
                        if (RequestConnectionFactoryService.this.readMessageErrorMessageId != null) {
                            RequestConnectionFactoryService.this.getLogger().write(RequestConnectionFactoryService.this.readMessageErrorMessageId, new Object[]{RequestConnectionFactoryService.this.getServiceNameObject(), message}, (Throwable)e);
                        }
                        if (receiveEndTime >= 0L) {
                            RequestConnectionFactoryService.this.receiveProcessTime = RequestConnectionFactoryService.this.receiveProcessTime + (receiveEndTime - receiveStartTime);
                            RequestConnectionFactoryService.this.receiveProcessCount++;
                        }
                        if (receiveSendEndTime >= 0L) {
                            RequestConnectionFactoryService.this.receiveSendProcessTime = RequestConnectionFactoryService.this.receiveSendProcessTime + (receiveSendEndTime - receiveSendStartTime);
                            RequestConnectionFactoryService.this.receiveSendProcessCount++;
                        }
                        return;
                    }
                    if (obj instanceof RequestMessage) {
                        RequestMessage request = (RequestMessage)obj;
                        Object requestObj = request.getObject();
                        try {
                            message.setObject(requestObj);
                        }
                        catch (MessageException e) {
                            e.printStackTrace();
                            if (receiveEndTime >= 0L) {
                                RequestConnectionFactoryService.this.receiveProcessTime = RequestConnectionFactoryService.this.receiveProcessTime + (receiveEndTime - receiveStartTime);
                                RequestConnectionFactoryService.this.receiveProcessCount++;
                            }
                            if (receiveSendEndTime >= 0L) {
                                RequestConnectionFactoryService.this.receiveSendProcessTime = RequestConnectionFactoryService.this.receiveSendProcessTime + (receiveSendEndTime - receiveSendStartTime);
                                RequestConnectionFactoryService.this.receiveSendProcessCount++;
                            }
                            return;
                        }
                        Message responseMessage = null;
                        try {
                            responseMessage = this.requestMessageListener.onRequestMessage(request.getSourceId(), request.getSequence(), message, request.getResponseSubject(message), request.getResponseKey(message));
                        }
                        finally {
                            receiveEndTime = System.currentTimeMillis();
                        }
                        if (responseMessage == null) {
                            return;
                        }
                        receiveSendStartTime = receiveEndTime;
                        responseMessage.addDestinationId(request.getSourceId());
                        try {
                            Object responseObj = responseMessage.getObject();
                            responseMessage.setObject(new ResponseMessage(RequestConnectionFactoryService.this.messageReceiver.getId(), request.getSequence(), responseObj));
                        }
                        catch (MessageException e) {
                            if (RequestConnectionFactoryService.this.responseErrorMessageId != null) {
                                RequestConnectionFactoryService.this.getLogger().write(RequestConnectionFactoryService.this.responseErrorMessageId, new Object[]{RequestConnectionFactoryService.this.serverConnection, responseMessage}, (Throwable)e);
                            }
                            if (receiveEndTime >= 0L) {
                                RequestConnectionFactoryService.this.receiveProcessTime = RequestConnectionFactoryService.this.receiveProcessTime + (receiveEndTime - receiveStartTime);
                                RequestConnectionFactoryService.this.receiveProcessCount++;
                            }
                            if (receiveSendEndTime >= 0L) {
                                RequestConnectionFactoryService.this.receiveSendProcessTime = RequestConnectionFactoryService.this.receiveSendProcessTime + (receiveSendEndTime - receiveSendStartTime);
                                RequestConnectionFactoryService.this.receiveSendProcessCount++;
                            }
                            return;
                        }
                        int count = 0;
                        try {
                            Set receivers;
                            while ((receivers = RequestConnectionFactoryService.this.serverConnection.getReceiveClientIds(responseMessage)) != null && receivers.contains(request.getSourceId())) {
                                ++count;
                                try {
                                    if (RequestConnectionFactoryService.this.isAsynchResponse) {
                                        RequestConnectionFactoryService.this.serverConnection.sendAsynch(responseMessage);
                                        break block50;
                                    }
                                    RequestConnectionFactoryService.this.serverConnection.send(responseMessage);
                                }
                                catch (MessageSendException e) {
                                    if (count > RequestConnectionFactoryService.this.responseRetryCount) {
                                        if (RequestConnectionFactoryService.this.responseErrorMessageId != null) {
                                            RequestConnectionFactoryService.this.getLogger().write(RequestConnectionFactoryService.this.responseErrorMessageId, new Object[]{RequestConnectionFactoryService.this.serverConnection, responseMessage}, (Throwable)e);
                                        }
                                        break block50;
                                    }
                                    if (RequestConnectionFactoryService.this.responseErrorRetryMessageId != null) {
                                        RequestConnectionFactoryService.this.getLogger().write(RequestConnectionFactoryService.this.responseErrorRetryMessageId, new Object[]{RequestConnectionFactoryService.this.serverConnection, responseMessage}, (Throwable)e);
                                    }
                                    try {
                                        Thread.sleep(RequestConnectionFactoryService.this.responseRetryInterval);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (count <= RequestConnectionFactoryService.this.responseRetryCount) continue;
                                }
                                break block50;
                            }
                            break block50;
                        }
                        finally {
                            receiveSendEndTime = System.currentTimeMillis();
                        }
                    }
                    if (obj instanceof ResponseMessage) {
                        ResponseMessage response = (ResponseMessage)obj;
                        Object responseObj = response.getObject();
                        try {
                            message.setObject(responseObj);
                        }
                        catch (MessageException e) {
                            e.printStackTrace();
                            if (receiveEndTime >= 0L) {
                                RequestConnectionFactoryService.this.receiveProcessTime = RequestConnectionFactoryService.this.receiveProcessTime + (receiveEndTime - receiveStartTime);
                                RequestConnectionFactoryService.this.receiveProcessCount++;
                            }
                            if (receiveSendEndTime >= 0L) {
                                RequestConnectionFactoryService.this.receiveSendProcessTime = RequestConnectionFactoryService.this.receiveSendProcessTime + (receiveSendEndTime - receiveSendStartTime);
                                RequestConnectionFactoryService.this.receiveSendProcessCount++;
                            }
                            return;
                        }
                        RequestConnectionFactoryService.this.serverConnection.reply(message, response);
                        break block50;
                    }
                    try {
                        this.requestMessageListener.onMessage(message);
                    }
                    finally {
                        receiveEndTime = System.currentTimeMillis();
                    }
                }
                finally {
                    if (receiveEndTime >= 0L) {
                        RequestConnectionFactoryService.this.receiveProcessTime = RequestConnectionFactoryService.this.receiveProcessTime + (receiveEndTime - receiveStartTime);
                        RequestConnectionFactoryService.this.receiveProcessCount++;
                    }
                    if (receiveSendEndTime >= 0L) {
                        RequestConnectionFactoryService.this.receiveSendProcessTime = RequestConnectionFactoryService.this.receiveSendProcessTime + (receiveSendEndTime - receiveSendStartTime);
                        RequestConnectionFactoryService.this.receiveSendProcessCount++;
                    }
                }
            }
        }
    }

    private class RequestServerConnectionImpl
    implements RequestServerConnection,
    ServerConnectionListener {
        private ServerConnection serverConnection;
        private Map responseMap = Collections.synchronizedMap(new HashMap());
        private boolean isClosed;
        private SynchronizeMonitor serverConnectWaitMonitor = new WaitSynchronizeMonitor();

        public RequestServerConnectionImpl(ServerConnection serverConnection) {
            this.serverConnection = serverConnection;
            serverConnection.addServerConnectionListener(this);
        }

        @Override
        public void onConnect(Client client) {
        }

        @Override
        public void onAddSubject(Client client, String subject, String[] keys) {
        }

        @Override
        public void onRemoveSubject(Client client, String subject, String[] keys) {
        }

        @Override
        public void onStartReceive(Client client, long from) {
            this.serverConnectWaitMonitor.notifyAllMonitor();
        }

        @Override
        public void onStopReceive(Client client) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClose(Client client) {
            ResponseContainer[] containers = null;
            Map map = this.responseMap;
            synchronized (map) {
                containers = this.responseMap.values().toArray(new ResponseContainer[this.responseMap.size()]);
            }
            for (int i = 0; i < containers.length; ++i) {
                containers[i].onClose(client.getId());
            }
        }

        @Override
        public Message createMessage(String subject, String key) throws MessageCreateException {
            return this.serverConnection.createMessage(subject, key);
        }

        @Override
        public Message castMessage(Message message) throws MessageException {
            return this.serverConnection.castMessage(message);
        }

        @Override
        public void send(Message message) throws MessageSendException {
            this.serverConnection.send(message);
        }

        @Override
        public void sendAsynch(Message message) throws MessageSendException {
            this.serverConnection.sendAsynch(message);
        }

        @Override
        public void addServerConnectionListener(ServerConnectionListener listener) {
            this.serverConnection.addServerConnectionListener(listener);
        }

        @Override
        public void removeServerConnectionListener(ServerConnectionListener listener) {
            this.serverConnection.removeServerConnectionListener(listener);
        }

        @Override
        public int getClientCount() {
            return this.serverConnection.getClientCount();
        }

        @Override
        public Set getClientIds() {
            return this.serverConnection.getClientIds();
        }

        @Override
        public Set getReceiveClientIds(Message message) {
            return this.serverConnection.getReceiveClientIds(message);
        }

        @Override
        public Set getSubjects(Object id) {
            return this.serverConnection.getSubjects(id);
        }

        @Override
        public Set getKeys(Object id, String subject) {
            return this.serverConnection.getKeys(id, subject);
        }

        @Override
        public void reset() {
            this.serverConnection.reset();
        }

        @Override
        public Message[] request(Message message, int replyCount, long timeout) throws MessageSendException, RequestTimeoutException {
            return this.request(message, null, null, replyCount, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message[] request(Message message, String responseSubject, String responseKey, int replyCount, long timeout) throws MessageSendException, RequestTimeoutException {
            long sendStartTime = System.currentTimeMillis();
            long sendEndTime = -1L;
            long responseStartTime = -1L;
            long responseEndTime = -1L;
            try {
                Message[] messageArray;
                if (this.isClosed) {
                    throw new MessageSendException("Closed.");
                }
                long curTimeout = timeout;
                this.serverConnectWaitMonitor.initMonitor();
                Set requestClients = this.serverConnection.getReceiveClientIds(message);
                if (requestClients.size() == 0) {
                    try {
                        if (!this.serverConnectWaitMonitor.waitMonitor(curTimeout)) {
                            throw new RequestTimeoutException("Destination not be found.");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    requestClients = this.serverConnection.getReceiveClientIds(message);
                    if (requestClients.size() == 0) {
                        throw new RequestTimeoutException("Destination not be found.");
                    }
                }
                int sequence = RequestConnectionFactoryService.this.getSequence();
                try {
                    message.setObject(new RequestMessage(RequestConnectionFactoryService.this.messageReceiver.getId(), sequence, responseSubject, responseKey, message.getObject()));
                }
                catch (MessageException e) {
                    throw new MessageSendException(e);
                }
                ResponseContainer container = new ResponseContainer(sequence, requestClients, replyCount);
                Integer sequenceVal = new Integer(sequence);
                this.responseMap.put(sequenceVal, container);
                container.init();
                try {
                    this.serverConnection.send(message);
                }
                finally {
                    sendEndTime = System.currentTimeMillis();
                }
                try {
                    responseStartTime = sendEndTime;
                    messageArray = container.getResponse(curTimeout);
                    this.responseMap.remove(sequenceVal);
                }
                catch (Throwable throwable) {
                    this.responseMap.remove(sequenceVal);
                    responseEndTime = System.currentTimeMillis();
                    throw throwable;
                }
                responseEndTime = System.currentTimeMillis();
                return messageArray;
            }
            finally {
                if (sendEndTime >= 0L) {
                    RequestConnectionFactoryService.this.sendProcessTime = RequestConnectionFactoryService.this.sendProcessTime + (sendEndTime - sendStartTime);
                    RequestConnectionFactoryService.this.sendProcessCount++;
                }
                if (responseStartTime >= 0L) {
                    RequestConnectionFactoryService.this.responseProcessTime = RequestConnectionFactoryService.this.responseProcessTime + (responseEndTime - responseStartTime);
                    RequestConnectionFactoryService.this.responseProcessCount++;
                }
            }
        }

        @Override
        public void request(Message message, int replyCount, long timeout, RequestServerConnection.ResponseCallBack callback) throws MessageSendException {
            this.request(message, null, null, replyCount, timeout, callback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(Message message, String responseSubject, String responseKey, int replyCount, long timeout, RequestServerConnection.ResponseCallBack callback) throws MessageSendException {
            long sendStartTime = System.currentTimeMillis();
            long sendEndTime = -1L;
            try {
                if (this.isClosed) {
                    throw new MessageSendException("Closed.");
                }
                long curTimeout = timeout;
                this.serverConnectWaitMonitor.initMonitor();
                Set requestClients = this.serverConnection.getReceiveClientIds(message);
                if (requestClients.size() == 0) {
                    long startTime = System.currentTimeMillis();
                    try {
                        if (!this.serverConnectWaitMonitor.waitMonitor(curTimeout)) {
                            callback.onResponse(null, null, true);
                            return;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    requestClients = this.serverConnection.getReceiveClientIds(message);
                    if (requestClients.size() == 0) {
                        callback.onResponse(null, null, true);
                        return;
                    }
                    if (timeout > 0L && (curTimeout -= System.currentTimeMillis() - startTime) <= 0L) {
                        callback.onResponse(null, null, true);
                        return;
                    }
                }
                int sequence = RequestConnectionFactoryService.this.getSequence();
                try {
                    message.setObject(new RequestMessage(RequestConnectionFactoryService.this.messageReceiver.getId(), sequence, responseSubject, responseKey, message.getObject()));
                }
                catch (MessageException e) {
                    throw new MessageSendException(e);
                }
                Integer sequenceVal = new Integer(sequence);
                ResponseContainer container = new ResponseContainer(sequence, sequenceVal, requestClients, replyCount, curTimeout, callback);
                this.responseMap.put(sequenceVal, container);
                if (timeout > 0L) {
                    container.startTimer();
                }
                try {
                    container.setResponseStartTime(System.currentTimeMillis());
                    this.serverConnection.send(message);
                }
                catch (MessageSendException e) {
                    if (timeout > 0L) {
                        container.cancel();
                    }
                    this.responseMap.remove(sequenceVal);
                    throw e;
                }
                finally {
                    sendEndTime = System.currentTimeMillis();
                }
            }
            finally {
                if (sendEndTime >= 0L) {
                    RequestConnectionFactoryService.this.sendProcessTime = RequestConnectionFactoryService.this.sendProcessTime + (sendEndTime - sendStartTime);
                    RequestConnectionFactoryService.this.sendProcessCount++;
                }
            }
        }

        @Override
        public int sendRequest(Message message, int replyCount, long timeout) throws MessageSendException, RequestTimeoutException {
            return this.sendRequest(message, null, null, replyCount, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int sendRequest(Message message, String responseSubject, String responseKey, int replyCount, long timeout) throws MessageSendException, RequestTimeoutException {
            long sendStartTime = System.currentTimeMillis();
            long sendEndTime = -1L;
            try {
                if (this.isClosed) {
                    throw new MessageSendException("Closed.");
                }
                this.serverConnectWaitMonitor.initMonitor();
                Set requestClients = this.serverConnection.getReceiveClientIds(message);
                if (requestClients.size() == 0) {
                    try {
                        if (!this.serverConnectWaitMonitor.waitMonitor(timeout)) {
                            throw new RequestTimeoutException("Destination not be found.");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    requestClients = this.serverConnection.getReceiveClientIds(message);
                    if (requestClients.size() == 0) {
                        throw new RequestTimeoutException("Destination not be found.");
                    }
                }
                int sequence = RequestConnectionFactoryService.this.getSequence();
                try {
                    message.setObject(new RequestMessage(RequestConnectionFactoryService.this.messageReceiver.getId(), sequence, responseSubject, responseKey, message.getObject()));
                }
                catch (MessageException e) {
                    throw new MessageSendException(e);
                }
                ResponseContainer container = new ResponseContainer(sequence, requestClients, replyCount, timeout);
                Integer sequenceVal = new Integer(sequence);
                this.responseMap.put(sequenceVal, container);
                if (timeout > 0L) {
                    container.startTimer();
                }
                container.init();
                try {
                    this.serverConnection.send(message);
                }
                finally {
                    sendEndTime = System.currentTimeMillis();
                }
                int n = sequenceVal;
                return n;
            }
            finally {
                if (sendEndTime >= 0L) {
                    RequestConnectionFactoryService.this.sendProcessTime = RequestConnectionFactoryService.this.sendProcessTime + (sendEndTime - sendStartTime);
                    RequestConnectionFactoryService.this.sendProcessCount++;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message[] getReply(int sequence, long timeout) throws MessageSendException, RequestTimeoutException {
            long responseStartTime = System.currentTimeMillis();
            long responseEndTime = -1L;
            try {
                Message[] messageArray;
                if (this.isClosed) {
                    throw new MessageSendException("Closed.");
                }
                Integer sequenceVal = new Integer(sequence);
                ResponseContainer container = (ResponseContainer)this.responseMap.get(sequenceVal);
                if (container == null) {
                    throw new RequestTimeoutException("Response not found. sequence=" + sequence);
                }
                try {
                    messageArray = container.getResponse(timeout);
                    this.responseMap.remove(sequenceVal);
                }
                catch (Throwable throwable) {
                    this.responseMap.remove(sequenceVal);
                    responseEndTime = System.currentTimeMillis();
                    throw throwable;
                }
                responseEndTime = System.currentTimeMillis();
                return messageArray;
            }
            finally {
                if (responseStartTime >= 0L) {
                    RequestConnectionFactoryService.this.responseProcessTime = RequestConnectionFactoryService.this.responseProcessTime + (responseEndTime - responseStartTime);
                    RequestConnectionFactoryService.this.responseProcessCount++;
                }
            }
        }

        @Override
        public void response(Object sourceId, int sequence, Message message) throws MessageSendException {
            message.addDestinationId(sourceId);
            try {
                Object responseObj = message.getObject();
                message.setObject(new ResponseMessage(RequestConnectionFactoryService.this.messageReceiver.getId(), sequence, responseObj));
            }
            catch (MessageException e) {
                throw new MessageSendException(e);
            }
            int count = 0;
            do {
                block10: {
                    Set receivers;
                    if ((receivers = this.serverConnection.getReceiveClientIds(message)) != null && receivers.contains(sourceId)) {
                        try {
                            if (RequestConnectionFactoryService.this.isAsynchResponse) {
                                this.serverConnection.sendAsynch(message);
                                break;
                            }
                            this.serverConnection.send(message);
                            break;
                        }
                        catch (MessageSendException e) {
                            if (count > RequestConnectionFactoryService.this.responseRetryCount) {
                                throw e;
                            }
                            if (RequestConnectionFactoryService.this.responseErrorMessageId == null) break block10;
                            RequestConnectionFactoryService.this.getLogger().write(RequestConnectionFactoryService.this.responseErrorMessageId, new Object[]{this.serverConnection, message}, (Throwable)e);
                        }
                    }
                }
                ++count;
                try {
                    Thread.sleep(RequestConnectionFactoryService.this.responseRetryInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (count <= RequestConnectionFactoryService.this.responseRetryCount);
        }

        protected void reply(Message message, ResponseMessage response) {
            ResponseContainer container = (ResponseContainer)this.responseMap.get(new Integer(response.getSequence()));
            if (container == null) {
                return;
            }
            container.onResponse(message, response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.isClosed = true;
            Map map = this.responseMap;
            synchronized (map) {
                Iterator itr = this.responseMap.values().iterator();
                while (itr.hasNext()) {
                    ResponseContainer container = (ResponseContainer)itr.next();
                    itr.remove();
                    container.interrupt();
                }
            }
        }

        private class ResponseContainer
        extends TimerTask {
            private final int sequence;
            private SynchronizeMonitor monitor = new WaitSynchronizeMonitor();
            private List responseList = new ArrayList();
            private final Set requestClients;
            private final int replyCount;
            private RequestServerConnection.ResponseCallBack callback;
            private long timeout;
            private Object key;
            private long responseStartTime = -1L;

            public ResponseContainer(int seq, Set requestClients, int replyCount) {
                this.sequence = seq;
                this.requestClients = requestClients;
                this.replyCount = replyCount;
            }

            public ResponseContainer(int seq, Set requestClients, int replyCount, long timeout) {
                this.sequence = seq;
                this.requestClients = requestClients;
                this.replyCount = replyCount;
                this.timeout = timeout;
            }

            public ResponseContainer(int seq, Object key, Set requestClients, int replyCount, long timeout, RequestServerConnection.ResponseCallBack callback) {
                this.sequence = seq;
                this.key = key;
                this.requestClients = requestClients;
                this.replyCount = replyCount;
                this.timeout = timeout;
                this.callback = callback;
            }

            public void setResponseStartTime(long time) {
                this.responseStartTime = time;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void onResponse(Message message, ResponseMessage response) {
                this.requestClients.remove(response.getSourceId());
                List list = this.responseList;
                synchronized (list) {
                    this.responseList.add(message);
                }
                if (this.callback == null) {
                    if (this.requestClients.size() == 0 || this.replyCount > 0 && this.responseList.size() >= this.replyCount) {
                        this.monitor.notifyAllMonitor();
                    }
                } else {
                    boolean isLast;
                    boolean bl = isLast = this.requestClients.size() == 0 || this.replyCount > 0 && this.responseList.size() >= this.replyCount;
                    if (isLast) {
                        if (this.timeout > 0L) {
                            this.cancel();
                        }
                        RequestServerConnectionImpl.this.responseMap.remove(this.key);
                        long responseEndTime = System.currentTimeMillis();
                        if (this.responseStartTime >= 0L) {
                            RequestConnectionFactoryService.this.responseProcessTime = RequestConnectionFactoryService.this.responseProcessTime + (responseEndTime - this.responseStartTime);
                            RequestConnectionFactoryService.this.responseProcessCount++;
                        }
                    }
                    this.callback.onResponse(response.getSourceId(), message, isLast);
                }
            }

            public synchronized void onClose(Object id) {
                this.requestClients.remove(id);
                if (this.callback == null) {
                    if (this.requestClients.size() == 0 || this.replyCount > 0 && this.responseList.size() >= this.replyCount) {
                        this.monitor.notifyAllMonitor();
                    }
                } else {
                    boolean isLast;
                    boolean bl = isLast = this.requestClients.size() == 0 || this.replyCount > 0 && this.responseList.size() >= this.replyCount;
                    if (isLast) {
                        if (this.timeout > 0L) {
                            this.cancel();
                        }
                        RequestServerConnectionImpl.this.responseMap.remove(this.key);
                    }
                    this.callback.onResponse(id, null, isLast);
                }
            }

            public void init() {
                this.monitor.initMonitor();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Message[] getResponse(long timeout) throws RequestTimeoutException {
                block18: {
                    try {
                        if (this.monitor.waitMonitor(timeout)) break block18;
                        Message[] responses = null;
                        Object object = this.responseList;
                        synchronized (object) {
                            responses = this.responseList.size() == 0 ? null : this.responseList.toArray(new Message[this.responseList.size()]);
                        }
                        object = this;
                        synchronized (object) {
                            throw new RequestTimeoutException("No responce destinations: sequence=" + this.sequence + ", clients=" + this.requestClients, responses);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RequestTimeoutException(e);
                    }
                    finally {
                        this.monitor.releaseMonitor();
                    }
                }
                List list = this.responseList;
                synchronized (list) {
                    Message[] responses = null;
                    responses = this.responseList.toArray(new Message[this.responseList.size()]);
                    if (this.replyCount > 0 && (responses == null || responses.length < this.replyCount)) {
                        ResponseContainer responseContainer = this;
                        synchronized (responseContainer) {
                            throw new RequestTimeoutException("No responce destinations: sequence=" + this.sequence + ", clients=" + this.requestClients, responses);
                        }
                    }
                    return responses;
                }
            }

            public void interrupt() {
                Thread[] threads = this.monitor.getWaitThreads();
                for (int i = 0; i < threads.length; ++i) {
                    threads[i].interrupt();
                }
            }

            public void startTimer() {
                RequestConnectionFactoryService.this.timeoutTimer.schedule((TimerTask)this, this.timeout);
            }

            @Override
            public void run() {
                RequestServerConnectionImpl.this.responseMap.remove(this.key);
                if (this.callback != null) {
                    this.callback.onResponse(null, null, true);
                }
            }
        }
    }
}

