/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.udp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.publish.Client;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageCreateException;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionListener;
import jp.ossc.nimbus.service.publish.tcp.AddMessage;
import jp.ossc.nimbus.service.publish.tcp.ClientMessage;
import jp.ossc.nimbus.service.publish.tcp.RemoveMessage;
import jp.ossc.nimbus.service.publish.tcp.StartReceiveMessage;
import jp.ossc.nimbus.service.publish.udp.IdMessage;
import jp.ossc.nimbus.service.publish.udp.InterpolateRequestMessage;
import jp.ossc.nimbus.service.publish.udp.InterpolateResponseMessage;
import jp.ossc.nimbus.service.publish.udp.MessageId;
import jp.ossc.nimbus.service.publish.udp.MessageImpl;
import jp.ossc.nimbus.service.publish.udp.MulticastMessageImpl;
import jp.ossc.nimbus.service.publish.udp.ServerCloseRequestMessage;
import jp.ossc.nimbus.service.publish.udp.ServerMessage;
import jp.ossc.nimbus.service.publish.udp.Window;
import jp.ossc.nimbus.service.publish.udp.WindowId;
import jp.ossc.nimbus.service.queue.AbstractDistributedQueueSelectorService;
import jp.ossc.nimbus.service.queue.AsynchContext;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.DistributedQueueHandlerContainerService;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;
import jp.ossc.nimbus.util.net.SocketFactory;

public class ServerConnectionImpl
implements ServerConnection {
    private ServerSocket serverSocket;
    private ServerSocketChannel serverSocketChannel;
    private Selector selector;
    private DatagramSocket sendSocket;
    private InetAddress multicastAddress;
    private InetSocketAddress sendSocketAddress;
    private NetworkInterface[] networkInterfaces;
    private int destPort;
    private Set clients = new LinkedHashSet();
    private Map clientMap = Collections.synchronizedMap(new HashMap());
    private Set newClients = Collections.synchronizedSet(new HashSet());
    private int maxSendRetryCount;
    private Logger logger;
    private String clientConnectMessageId;
    private String clientCloseMessageId;
    private String sendErrorMessageId;
    private String sendErrorRetryOverMessageId;
    private String responseErrorMessageId;
    private String messageLostErrorMessageId;
    private Daemon clientAcceptor;
    private DefaultQueueService sendResponseQueue;
    private QueueHandlerContainerService sendQueueHandlerContainer;
    private ClientDistributedQueueSelector queueSelector;
    private QueueHandlerContainerService asynchAcceptQueueHandlerContainer;
    private QueueHandlerContainer asynchSendQueueHandlerContainer;
    private QueueHandlerContainerService requestHandleQueueHandlerContainer;
    private long sendPacketCount;
    private long sendCount;
    private long sendProcessTime;
    private List serverConnectionListeners;
    private Externalizer externalizer;
    private SocketFactory socketFactory;
    private int windowSize;
    private int maxWindowCount;
    private int currentSequence = 0;
    private List sendMessageCache = Collections.synchronizedList(new ArrayList());
    private Map sendMessageCacheMap = Collections.synchronizedMap(new HashMap());
    private long sendMessageCacheTime;
    private boolean isAcknowledge;
    private int messageRecycleBufferSize = 100;
    private List messageBuffer;
    private long newMessageCount;
    private long recycleMessageCount;
    private int windowRecycleBufferSize = 200;
    protected List windowBuffer;
    protected long newWindowCount;
    protected long recycleWindowCount;
    private List sendRequestBuffer;
    private List asynchContextBuffer;

    public ServerConnectionImpl(ServerSocket serverSocket, Externalizer ext, int sendThreadSize, ServiceName sendQueueServiceName, int asynchSendThreadSize, ServiceName asynchSendQueueServiceName, ServiceName asynchSendQueueFactoryServiceName, InetSocketAddress sendSocketAddress, NetworkInterface[] networkInterfaces, InetAddress multicastAddress, int destPort) throws Exception {
        this.serverSocket = serverSocket;
        this.sendSocketAddress = sendSocketAddress;
        this.networkInterfaces = networkInterfaces;
        this.multicastAddress = multicastAddress;
        this.destPort = destPort;
        this.externalizer = ext;
        this.messageBuffer = new ArrayList();
        this.windowBuffer = new ArrayList();
        this.sendRequestBuffer = new ArrayList();
        this.asynchContextBuffer = new ArrayList();
        this.initSendSocket();
        this.initSend(sendQueueServiceName, sendThreadSize, multicastAddress != null);
        this.initAsynchSend(asynchSendQueueServiceName, asynchSendQueueFactoryServiceName, asynchSendThreadSize, multicastAddress != null);
        this.initClientAcceptor(serverSocket.getLocalSocketAddress());
    }

    public ServerConnectionImpl(ServerSocketChannel ssc, Externalizer ext, int sendThreadSize, ServiceName sendQueueServiceName, int asynchSendThreadSize, ServiceName asynchSendQueueFactoryServiceName, ServiceName asynchSendQueueServiceName, int requestHandleThreadSize, ServiceName requestHandleQueueServiceName, SocketFactory sf, InetSocketAddress sendSocketAddress, NetworkInterface[] networkInterfaces, InetAddress multicastAddress, int destPort) throws Exception {
        this.serverSocketChannel = ssc;
        this.socketFactory = sf;
        this.sendSocketAddress = sendSocketAddress;
        this.networkInterfaces = networkInterfaces;
        this.multicastAddress = multicastAddress;
        this.destPort = destPort;
        this.externalizer = ext;
        this.messageBuffer = new ArrayList();
        this.windowBuffer = new ArrayList();
        this.sendRequestBuffer = new ArrayList();
        this.asynchContextBuffer = new ArrayList();
        this.initSendSocket();
        this.initSend(sendQueueServiceName, sendThreadSize, multicastAddress != null);
        this.initAsynchSend(asynchSendQueueServiceName, asynchSendQueueFactoryServiceName, asynchSendThreadSize, multicastAddress != null);
        this.initRequestHandle(requestHandleQueueServiceName, requestHandleThreadSize);
        this.selector = Selector.open();
        this.serverSocketChannel.register(this.selector, 16, null);
        this.initClientAcceptor(this.serverSocketChannel.socket().getLocalSocketAddress());
    }

    private void initSendSocket() throws IOException {
        this.sendSocket = this.multicastAddress != null ? (this.sendSocketAddress == null ? (this.multicastAddress.isMulticastAddress() ? new MulticastSocket() : new DatagramSocket()) : (this.multicastAddress.isMulticastAddress() ? new MulticastSocket(this.sendSocketAddress) : new DatagramSocket(this.sendSocketAddress))) : (this.sendSocketAddress == null || this.sendSocketAddress.getPort() == 0 ? new DatagramSocket() : new DatagramSocket(this.sendSocketAddress));
    }

    private void initClientAcceptor(SocketAddress localAddress) {
        this.clientAcceptor = new Daemon(new ClientAcceptor());
        this.clientAcceptor.setName("Nimbus Publish(UDP) ServerConnection ClientAcceptor " + localAddress);
        this.clientAcceptor.setDaemon(true);
        this.clientAcceptor.start();
    }

    private void initSend(ServiceName sendQueueServiceName, int sendThreadSize, boolean isMulticast) throws Exception {
        if (!isMulticast && sendThreadSize >= 1) {
            this.sendQueueHandlerContainer = new QueueHandlerContainerService();
            this.sendQueueHandlerContainer.create();
            if (sendQueueServiceName == null) {
                DefaultQueueService sendQueue = new DefaultQueueService();
                sendQueue.create();
                sendQueue.start();
                this.sendQueueHandlerContainer.setQueueService(sendQueue);
            } else {
                this.sendQueueHandlerContainer.setQueueServiceName(sendQueueServiceName);
            }
            this.sendQueueHandlerContainer.setQueueHandlerSize(sendThreadSize);
            this.sendQueueHandlerContainer.setQueueHandler(new SendQueueHandler());
            this.sendQueueHandlerContainer.setIgnoreNullElement(true);
            this.sendQueueHandlerContainer.setWaitTimeout(1000L);
            this.sendQueueHandlerContainer.start();
            this.sendResponseQueue = new DefaultQueueService();
            try {
                this.sendResponseQueue.create();
                this.sendResponseQueue.start();
            }
            catch (Exception e) {
                throw new MessageSendException(e);
            }
            this.sendResponseQueue.accept();
        }
    }

    private void initAsynchSend(ServiceName queueServiceName, ServiceName queueFactoryServiceName, int asynchSendThreadSize, boolean isMulticast) throws Exception {
        if (asynchSendThreadSize <= 0) {
            return;
        }
        this.asynchAcceptQueueHandlerContainer = new QueueHandlerContainerService();
        this.asynchAcceptQueueHandlerContainer.create();
        if (queueServiceName == null) {
            DefaultQueueService acceptQueue = new DefaultQueueService();
            acceptQueue.create();
            acceptQueue.start();
            this.asynchAcceptQueueHandlerContainer.setQueueService(acceptQueue);
        } else {
            this.asynchAcceptQueueHandlerContainer.setQueueServiceName(queueServiceName);
        }
        this.asynchAcceptQueueHandlerContainer.setQueueHandlerSize(1);
        this.asynchAcceptQueueHandlerContainer.setQueueHandler(new AsynchAcceptQueueHandler());
        this.asynchAcceptQueueHandlerContainer.setIgnoreNullElement(true);
        this.asynchAcceptQueueHandlerContainer.setWaitTimeout(1000L);
        this.asynchAcceptQueueHandlerContainer.start();
        if (!isMulticast) {
            this.queueSelector = new ClientDistributedQueueSelector();
            this.queueSelector.create();
            this.queueSelector.setDistributedSize(asynchSendThreadSize);
            if (queueFactoryServiceName != null) {
                this.queueSelector.setQueueFactoryServiceName(queueFactoryServiceName);
            }
            this.queueSelector.start();
            DistributedQueueHandlerContainerService distributedQueueHandlerContainer = new DistributedQueueHandlerContainerService();
            distributedQueueHandlerContainer.create();
            distributedQueueHandlerContainer.setDistributedQueueSelector(this.queueSelector);
            distributedQueueHandlerContainer.setQueueHandler(new SendQueueHandler());
            distributedQueueHandlerContainer.setIgnoreNullElement(true);
            distributedQueueHandlerContainer.setWaitTimeout(1000L);
            distributedQueueHandlerContainer.start();
            this.asynchSendQueueHandlerContainer = distributedQueueHandlerContainer;
        }
    }

    private void initRequestHandle(ServiceName requestHandleQueueServiceName, int requestHandleThreadSize) throws Exception {
        if (requestHandleThreadSize >= 1) {
            this.requestHandleQueueHandlerContainer = new QueueHandlerContainerService();
            this.requestHandleQueueHandlerContainer.create();
            if (requestHandleQueueServiceName == null) {
                DefaultQueueService requestHandleQueue = new DefaultQueueService();
                requestHandleQueue.create();
                requestHandleQueue.start();
                this.requestHandleQueueHandlerContainer.setQueueService(requestHandleQueue);
            } else {
                this.requestHandleQueueHandlerContainer.setQueueServiceName(requestHandleQueueServiceName);
            }
            this.requestHandleQueueHandlerContainer.setQueueHandlerSize(requestHandleThreadSize);
            this.requestHandleQueueHandlerContainer.setQueueHandler(new RequestHandleQueueHandler());
            this.requestHandleQueueHandlerContainer.setIgnoreNullElement(true);
            this.requestHandleQueueHandlerContainer.setWaitTimeout(1000L);
            this.requestHandleQueueHandlerContainer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleMessage(MessageImpl msg) {
        if (msg != null && this.messageBuffer.size() <= this.messageRecycleBufferSize) {
            msg.clear();
            List list = this.messageBuffer;
            synchronized (list) {
                if (this.messageBuffer.size() <= this.messageRecycleBufferSize) {
                    this.messageBuffer.add(msg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleWindow(Window window) {
        if (window != null && this.windowBuffer.size() <= this.windowRecycleBufferSize) {
            window.clear();
            List list = this.windowBuffer;
            synchronized (list) {
                if (this.windowBuffer.size() <= this.windowRecycleBufferSize) {
                    this.windowBuffer.add(window);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleSendRequest(SendRequest req) {
        if (req != null && this.sendRequestBuffer.size() <= this.messageRecycleBufferSize) {
            req.clear();
            List list = this.sendRequestBuffer;
            synchronized (list) {
                if (this.sendRequestBuffer.size() <= this.messageRecycleBufferSize) {
                    this.sendRequestBuffer.add(req);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SendRequest createSendRequest(ClientImpl client, MessageImpl message) {
        SendRequest result = null;
        if (this.sendRequestBuffer.size() != 0) {
            List list = this.sendRequestBuffer;
            synchronized (list) {
                if (this.sendRequestBuffer.size() != 0) {
                    result = (SendRequest)this.sendRequestBuffer.remove(0);
                    result.client = client;
                    result.message = message;
                }
            }
        }
        if (result == null) {
            result = new SendRequest(client, message);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleAsynchContext(AsynchContext context) {
        if (context != null && this.asynchContextBuffer.size() <= this.messageRecycleBufferSize) {
            SendRequest req = (SendRequest)context.getInput();
            if (req != null) {
                this.recycleSendRequest(req);
            }
            context.clear();
            List list = this.asynchContextBuffer;
            synchronized (list) {
                if (this.asynchContextBuffer.size() <= this.messageRecycleBufferSize) {
                    this.asynchContextBuffer.add(context);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AsynchContext createAsynchContext(SendRequest input, Queue queue) {
        AsynchContext result = null;
        if (this.asynchContextBuffer.size() != 0) {
            List list = this.asynchContextBuffer;
            synchronized (list) {
                if (this.asynchContextBuffer.size() != 0) {
                    result = (AsynchContext)this.asynchContextBuffer.remove(0);
                    result.setInput(input);
                    result.setResponseQueue(queue);
                }
            }
        }
        if (result == null) {
            result = new AsynchContext(input, queue);
        }
        return result;
    }

    public void setMessageRecycleBufferSize(int size) {
        this.messageRecycleBufferSize = size;
    }

    public void setWindowRecycleBufferSize(int size) {
        this.windowRecycleBufferSize = size;
    }

    public void setTimeToLive(int ttl) throws IOException {
        if (this.multicastAddress != null && this.multicastAddress.isMulticastAddress() && ttl >= 0 && this.sendSocket != null) {
            ((MulticastSocket)this.sendSocket).setTimeToLive(ttl);
        }
    }

    public void setWindowSize(int bytes) {
        this.windowSize = bytes;
        if (this.sendSocket != null) {
            try {
                int sendBufferSize = this.sendSocket.getSendBufferSize();
                if (sendBufferSize < this.windowSize) {
                    this.sendSocket.setSendBufferSize(this.windowSize);
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public void setSendMessageCacheTime(long time) {
        this.sendMessageCacheTime = time;
    }

    public void setMaxSendRetryCount(int count) {
        this.maxSendRetryCount = count;
        if (this.sendQueueHandlerContainer != null) {
            this.sendQueueHandlerContainer.setMaxRetryCount(this.maxSendRetryCount);
        }
        if (this.asynchAcceptQueueHandlerContainer != null) {
            this.asynchAcceptQueueHandlerContainer.setMaxRetryCount(this.maxSendRetryCount);
        }
        if (this.asynchSendQueueHandlerContainer != null) {
            this.asynchSendQueueHandlerContainer.setMaxRetryCount(this.maxSendRetryCount);
        }
    }

    public void setAcknowledge(boolean isAck) {
        this.isAcknowledge = isAck;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setClientConnectMessageId(String id) {
        this.clientConnectMessageId = id;
    }

    public void setClientCloseMessageId(String id) {
        this.clientCloseMessageId = id;
    }

    public void setSendErrorMessageId(String id) {
        this.sendErrorMessageId = id;
    }

    public void setSendErrorRetryOverMessageId(String id) {
        this.sendErrorRetryOverMessageId = id;
    }

    public void setResponseErrorMessageId(String id) {
        this.responseErrorMessageId = id;
    }

    public void setMessageLostErrorMessageId(String id) {
        this.messageLostErrorMessageId = id;
    }

    public String getMessageLostErrorMessageId() {
        return this.messageLostErrorMessageId;
    }

    public int getMaxWindowCount() {
        return this.maxWindowCount;
    }

    public double getAverageWindowCount() {
        return this.sendCount == 0L ? 0.0 : (double)this.sendPacketCount / (double)this.sendCount;
    }

    public long getAverageAsynchSendProcessTime() {
        return this.asynchAcceptQueueHandlerContainer == null ? 0L : this.asynchAcceptQueueHandlerContainer.getAverageHandleProcessTime();
    }

    public long getAverageRequestHandleProcessTime() {
        return this.requestHandleQueueHandlerContainer == null ? 0L : this.requestHandleQueueHandlerContainer.getAverageHandleProcessTime();
    }

    public double getMessageRecycleRate() {
        return (double)this.recycleMessageCount / ((double)this.newMessageCount + (double)this.recycleMessageCount);
    }

    public double getWindowRecycleRate() {
        return (double)this.recycleWindowCount / ((double)this.newWindowCount + (double)this.recycleWindowCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message createMessage(String subject, String key) throws MessageCreateException {
        MessageImpl message = null;
        if (this.messageBuffer.size() != 0) {
            List list = this.messageBuffer;
            synchronized (list) {
                if (this.messageBuffer.size() != 0) {
                    message = (MessageImpl)this.messageBuffer.remove(0);
                    ++this.recycleMessageCount;
                }
            }
        }
        if (message == null) {
            message = this.multicastAddress == null ? new MessageImpl() : new MulticastMessageImpl();
            ++this.newMessageCount;
        }
        message.setSubject(subject, key);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageImpl copyMessage(MessageImpl msg) {
        MessageImpl message = null;
        if (this.messageBuffer.size() != 0) {
            List list = this.messageBuffer;
            synchronized (list) {
                if (this.messageBuffer.size() != 0) {
                    message = (MessageImpl)this.messageBuffer.remove(0);
                    ++this.recycleMessageCount;
                }
            }
        }
        if (message == null) {
            message = this.multicastAddress == null ? new MessageImpl() : new MulticastMessageImpl();
            ++this.newMessageCount;
        }
        msg.copy(message);
        return message;
    }

    @Override
    public Message castMessage(Message message) throws MessageException {
        if (message instanceof MessageImpl) {
            return message;
        }
        Message msg = this.createMessage(message.getSubject(), message.getKey());
        if (message.getSerializedBytes() != null) {
            msg.setSerializedBytes(message.getSerializedBytes());
        } else {
            msg.setObject(message.getObject());
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(DatagramSocket sendSocket, InetAddress destAddress, MessageImpl message, int destPort, boolean isRetry) throws IOException {
        int i;
        List windows = message.getWindows(this, this.windowSize, this.externalizer);
        this.maxWindowCount = Math.max(this.maxWindowCount, windows.size());
        ArrayList<DatagramPacket> packets = new ArrayList<DatagramPacket>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        int imax = windows.size();
        for (i = 0; i < imax; ++i) {
            Window window = (Window)windows.get(i);
            baos.reset();
            window.write(dos);
            dos.flush();
            byte[] bytes = baos.toByteArray();
            DatagramPacket packet2 = new DatagramPacket(bytes, bytes.length, destAddress, destPort);
            packets.add(packet2);
        }
        imax = packets.size();
        block9: for (i = 0; i < imax; ++i) {
            DatagramPacket packet = (DatagramPacket)packets.get(i);
            if (isRetry) {
                int j = 0;
                while (j <= this.maxSendRetryCount) {
                    try {
                        DatagramSocket packet2 = sendSocket;
                        synchronized (packet2) {
                            if (this.multicastAddress != null && this.multicastAddress.isMulticastAddress() && this.networkInterfaces != null) {
                                for (int k = 0; k < this.networkInterfaces.length; ++k) {
                                    ((MulticastSocket)sendSocket).setNetworkInterface(this.networkInterfaces[k]);
                                    sendSocket.send(packet);
                                }
                            } else {
                                sendSocket.send(packet);
                            }
                            continue block9;
                        }
                    }
                    catch (IOException e) {
                        if (this.logger != null) {
                            if (j >= this.maxSendRetryCount) {
                                if (this.sendErrorRetryOverMessageId != null) {
                                    this.logger.write(this.sendErrorRetryOverMessageId, new Object[]{destAddress + ":" + destPort, message}, (Throwable)e);
                                }
                                throw e;
                            }
                            if (this.sendErrorMessageId != null) {
                                this.logger.write(this.sendErrorMessageId, new Object[]{destAddress + ":" + destPort, message}, (Throwable)e);
                            }
                        }
                        ++i;
                    }
                }
                continue;
            }
            DatagramSocket datagramSocket = sendSocket;
            synchronized (datagramSocket) {
                if (this.multicastAddress != null && this.multicastAddress.isMulticastAddress() && this.networkInterfaces != null) {
                    for (int j = 0; j < this.networkInterfaces.length; ++j) {
                        ((MulticastSocket)sendSocket).setNetworkInterface(this.networkInterfaces[j]);
                        sendSocket.send(packet);
                    }
                } else {
                    sendSocket.send(packet);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void send(Message message) throws MessageSendException {
        block31: {
            if (!(message instanceof MessageImpl)) {
                throw new MessageSendException("Message is illegal class. " + (message == null ? null : message.getClass()));
            }
            long startTime = System.currentTimeMillis();
            try {
                Set firstClients = this.allocateSequence((MessageImpl)message);
                if (this.clients.size() == 0) {
                    return;
                }
                if (this.multicastAddress == null) {
                    if (this.sendQueueHandlerContainer == null) {
                        ArrayList<ClientImpl> currentClients = new ArrayList<ClientImpl>();
                        for (ClientImpl client : this.clients) {
                            if (client == null || !client.isStartReceive() || !client.isTargetMessage(message)) continue;
                            currentClients.add(client);
                        }
                        Iterator itr = currentClients.iterator();
                        while (itr.hasNext()) {
                            ClientImpl client = (ClientImpl)itr.next();
                            try {
                                client.send(message);
                                itr.remove();
                            }
                            catch (MessageSendException messageSendException) {}
                        }
                        ((MessageImpl)message).setSend(true);
                        if (currentClients.size() != 0) {
                            throw new MessageSendException("Send error : clients=" + currentClients + ", message=" + message);
                        }
                    } else {
                        HashMap<ClientImpl, AsynchContext> sendContexts = new HashMap<ClientImpl, AsynchContext>();
                        for (ClientImpl client : this.clients) {
                            if (!client.isStartReceive() || !client.isTargetMessage(message)) continue;
                            SendRequest sendRequest = this.createSendRequest(client, (MessageImpl)message);
                            AsynchContext asynchContext = this.createAsynchContext(sendRequest, this.sendResponseQueue);
                            sendContexts.put(client, asynchContext);
                            this.sendQueueHandlerContainer.push(asynchContext);
                        }
                        Throwable th = null;
                        int imax = sendContexts.size();
                        for (int i = 0; i < imax; ++i) {
                            SendRequest sendRequest;
                            AsynchContext asynchContext = (AsynchContext)this.sendResponseQueue.get();
                            SendRequest sendRequest2 = sendRequest = asynchContext == null ? null : (SendRequest)asynchContext.getInput();
                            if (asynchContext == null) {
                                Iterator itr = sendContexts.values().iterator();
                                while (itr.hasNext()) {
                                    ((AsynchContext)itr.next()).cancel();
                                }
                                throw new MessageSendException("Interrupted the waiting for a response sent : clients=" + sendContexts.keySet() + ", message=" + message, new InterruptedException());
                            }
                            if (asynchContext.isCancel()) {
                                --i;
                                continue;
                            }
                            if (asynchContext.getThrowable() == null) {
                                sendContexts.remove(sendRequest.client);
                                continue;
                            }
                            th = asynchContext.getThrowable();
                        }
                        if (sendContexts.size() != 0) {
                            throw new MessageSendException("Send error : clients=" + sendContexts.keySet() + ", message=" + message, th);
                        }
                        ((MessageImpl)message).setSend(true);
                    }
                    break block31;
                }
                try {
                    if (firstClients != null) {
                        for (ClientImpl client : firstClients) {
                            if (!client.isStartReceive()) continue;
                            client.send(message);
                        }
                    }
                    this.sendMessage(this.sendSocket, this.multicastAddress, (MessageImpl)message, this.destPort, true);
                    ((MessageImpl)message).setSend(true);
                }
                catch (IOException e) {
                    throw new MessageSendException("Send error : dest=" + this.multicastAddress + ':' + this.destPort + ", message=" + message, e);
                }
            }
            finally {
                this.sendProcessTime += System.currentTimeMillis() - startTime;
                try {
                    this.addSendMessageCache((MessageImpl)message);
                }
                catch (IOException e) {
                    throw new MessageSendException("Send error : message=" + message, e);
                }
            }
        }
    }

    @Override
    public void sendAsynch(Message message) throws MessageSendException {
        if (!(message instanceof MessageImpl)) {
            throw new MessageSendException("Message is illegal class. " + (message == null ? null : message.getClass()));
        }
        if (this.asynchAcceptQueueHandlerContainer == null) {
            throw new UnsupportedOperationException();
        }
        this.asynchAcceptQueueHandlerContainer.push(message);
    }

    private synchronized Set allocateSequence(MessageImpl message) {
        ++this.currentSequence;
        message.setSequence(this.currentSequence);
        long currentTime = System.currentTimeMillis();
        message.setSendTime(currentTime);
        HashSet<ClientImpl> result = null;
        if (this.newClients.size() != 0) {
            ClientImpl[] clientArray = this.newClients.toArray(new ClientImpl[this.newClients.size()]);
            for (int i = 0; i < clientArray.length; ++i) {
                if (!clientArray[i].isStartReceive() || !clientArray[i].isFirstMessage() || !clientArray[i].setFirstMessage(message)) continue;
                this.newClients.remove(clientArray[i]);
                if (result == null) {
                    result = new HashSet<ClientImpl>();
                }
                result.add(clientArray[i]);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSendMessageCache(MessageImpl message) throws IOException {
        int windowCount = this.addSendMessageCache(message, this.sendMessageCacheMap, this.sendMessageCache);
        Map map = this.sendMessageCacheMap;
        synchronized (map) {
            ++this.sendCount;
            this.sendPacketCount += (long)windowCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addSendMessageCache(MessageImpl message, Map sendMessageCacheMap, List sendMessageCache) throws IOException {
        long currentTime = System.currentTimeMillis();
        List windows = null;
        Map map = sendMessageCacheMap;
        synchronized (map) {
            Integer seq = new Integer(message.getSequence());
            windows = message.getWindows(this, this.windowSize, this.externalizer);
            if (!sendMessageCacheMap.containsKey(seq)) {
                MessageImpl msg;
                sendMessageCache.add(message);
                sendMessageCacheMap.put(seq, windows);
                int imax = sendMessageCache.size();
                for (int i = 0; i < imax && currentTime - (msg = (MessageImpl)sendMessageCache.get(0)).getSendTime() > this.sendMessageCacheTime; ++i) {
                    MessageImpl trashMsg = (MessageImpl)sendMessageCache.remove(0);
                    if (!trashMsg.isSend()) continue;
                    List trashWindows = (List)sendMessageCacheMap.remove(new Integer(trashMsg.getSequence()));
                    int jmax = trashWindows.size();
                    for (int j = 0; j < jmax; ++j) {
                        this.recycleWindow((Window)trashWindows.get(j));
                    }
                    this.recycleMessage(trashMsg);
                }
            }
        }
        return windows.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSendWindows(MessageId id, Map sendMessageCacheMap) {
        ArrayList<Object> result = null;
        Map map = sendMessageCacheMap;
        synchronized (map) {
            List windows = (List)sendMessageCacheMap.get(new Integer(id.sequence));
            if (windows != null) {
                result = new ArrayList<Object>();
                int imax = windows.size();
                for (int i = 0; i < imax; ++i) {
                    result.add(((Window)windows.get(i)).clone());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSendMessages(long from, Map sendMessageCacheMap, List sendMessageCache) {
        ArrayList<MessageImpl> result = new ArrayList<MessageImpl>();
        Map map = sendMessageCacheMap;
        synchronized (map) {
            MessageImpl msg;
            int i = sendMessageCache.size();
            while (--i >= 0 && (msg = (MessageImpl)sendMessageCache.get(i)).getSendTime() >= from) {
                result.add(0, this.copyMessage(msg));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message getSendMessage(MessageId id, Map sendMessageCacheMap, List sendMessageCache) {
        Map map = sendMessageCacheMap;
        synchronized (map) {
            if (sendMessageCache.size() == 0) {
                return null;
            }
            int index = Collections.binarySearch(sendMessageCache, id);
            if (index < 0) {
                return null;
            }
            return this.copyMessage((MessageImpl)sendMessageCache.get(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSendMessages(MessageId from, MessageId to, Map sendMessageCacheMap, List sendMessageCache) {
        ArrayList<MessageImpl> result = new ArrayList<MessageImpl>();
        Map map = sendMessageCacheMap;
        synchronized (map) {
            int toIndex;
            if (sendMessageCache.size() == 0) {
                return result;
            }
            int n = toIndex = to == null ? sendMessageCache.size() : Collections.binarySearch(sendMessageCache, to);
            if (toIndex < 0) {
                result.add(this.copyMessage((MessageImpl)sendMessageCache.get(0)));
                return result;
            }
            int fromIndex = Collections.binarySearch(sendMessageCache, from);
            if (fromIndex < 0) {
                fromIndex = -fromIndex - 1;
            }
            for (int i = fromIndex; i < toIndex; ++i) {
                MessageImpl msg = (MessageImpl)sendMessageCache.get(i);
                result.add(this.copyMessage(msg));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Window getSendWindow(WindowId id, Map sendMessageCacheMap) {
        List windows = null;
        Map map = sendMessageCacheMap;
        synchronized (map) {
            windows = (List)sendMessageCacheMap.get(new Integer(id.sequence));
            if (windows == null || windows.size() <= id.windowNo) {
                return null;
            }
            Window w = (Window)windows.get(id.windowNo);
            Window window = w == null ? null : (Window)w.clone();
            return window;
        }
    }

    public int getMostOldSendMessageCacheSequence() {
        return this.getMostOldSendMessageCacheSequence(this.sendMessageCacheMap, this.sendMessageCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMostOldSendMessageCacheSequence(Map sendMessageCacheMap, List sendMessageCache) {
        Map map = sendMessageCacheMap;
        synchronized (map) {
            return sendMessageCache.size() == 0 ? 0 : ((MessageImpl)sendMessageCache.get((int)0)).sequence;
        }
    }

    public Date getMostOldSendMessageCacheTime() {
        return this.getMostOldSendMessageCacheTime(this.sendMessageCacheMap, this.sendMessageCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getMostOldSendMessageCacheTime(Map sendMessageCacheMap, List sendMessageCache) {
        Map map = sendMessageCacheMap;
        synchronized (map) {
            return sendMessageCache.size() == 0 ? null : new Date(((MessageImpl)sendMessageCache.get(0)).getSendTime());
        }
    }

    public int getSendMessageCacheSize() {
        return this.sendMessageCache.size();
    }

    public long getSendCount() {
        return this.sendCount;
    }

    public long getSendPacketCount() {
        return this.sendPacketCount;
    }

    public void resetSendCount() {
        this.sendCount = 0L;
        this.sendPacketCount = 0L;
        this.sendProcessTime = 0L;
    }

    public long getAverageSendProcessTime() {
        return this.sendCount == 0L ? 0L : this.sendProcessTime / this.sendCount;
    }

    public Set getClients() {
        return this.clients;
    }

    @Override
    public int getClientCount() {
        return this.clients.size();
    }

    @Override
    public Set getClientIds() {
        return new HashSet(this.clientMap.keySet());
    }

    @Override
    public Set getReceiveClientIds(Message message) {
        HashSet<Object> result = new HashSet<Object>();
        for (ClientImpl client : this.clients) {
            if (!client.isStartReceive() || !client.isTargetMessage(message)) continue;
            result.add(client.getId());
        }
        return result;
    }

    @Override
    public Set getSubjects(Object id) {
        ClientImpl client = (ClientImpl)this.clientMap.get(id);
        if (client == null) {
            return null;
        }
        return client.getSubjects();
    }

    @Override
    public Set getKeys(Object id, String subject) {
        ClientImpl client = (ClientImpl)this.clientMap.get(id);
        if (client == null) {
            return null;
        }
        return client.getKeys(subject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Map map = this.sendMessageCacheMap;
        synchronized (map) {
            this.sendMessageCacheMap.clear();
            this.sendMessageCache.clear();
        }
    }

    public synchronized void close() {
        ServerCloseRequestMessage closeMsg = new ServerCloseRequestMessage();
        for (ClientImpl client : this.clients) {
            if (client == null) continue;
            client.sendServerMessage(closeMsg, null);
            SocketChannel socketChannel = client.getSocketChannel();
            if (socketChannel == null) continue;
            try {
                socketChannel.register(this.selector, 4, client);
                this.selector.wakeup();
            }
            catch (ClosedChannelException closedChannelException) {}
        }
        if (this.clientAcceptor != null) {
            this.clientAcceptor.stop(1000L);
            this.clientAcceptor = null;
        }
        if (this.sendQueueHandlerContainer != null) {
            this.sendQueueHandlerContainer.stop();
            this.sendQueueHandlerContainer.destroy();
            this.sendQueueHandlerContainer = null;
        }
        if (this.asynchAcceptQueueHandlerContainer != null) {
            this.asynchAcceptQueueHandlerContainer.stop();
            this.asynchAcceptQueueHandlerContainer.destroy();
            this.asynchAcceptQueueHandlerContainer = null;
        }
        if (this.asynchSendQueueHandlerContainer != null) {
            ((Service)((Object)this.asynchSendQueueHandlerContainer)).stop();
            ((Service)((Object)this.asynchSendQueueHandlerContainer)).destroy();
            this.asynchSendQueueHandlerContainer = null;
        }
        if (this.queueSelector != null) {
            this.queueSelector.stop();
            this.queueSelector.destroy();
            this.queueSelector = null;
        }
        for (ClientImpl client : this.clients) {
            if (client == null) continue;
            client.close();
        }
        if (this.sendSocket != null) {
            this.sendSocket.close();
            this.sendSocket = null;
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
    }

    @Override
    public void addServerConnectionListener(ServerConnectionListener listener) {
        if (this.serverConnectionListeners == null) {
            this.serverConnectionListeners = new ArrayList();
        }
        if (!this.serverConnectionListeners.contains(listener)) {
            this.serverConnectionListeners.add(listener);
        }
    }

    @Override
    public void removeServerConnectionListener(ServerConnectionListener listener) {
        if (this.serverConnectionListeners == null) {
            return;
        }
        this.serverConnectionListeners.remove(listener);
        if (this.serverConnectionListeners.size() == 0) {
            this.serverConnectionListeners = null;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append("server=").append(this.serverSocket == null ? null : this.serverSocket.getLocalSocketAddress());
        buf.append('}');
        return buf.toString();
    }

    static /* synthetic */ boolean access$3100(ServerConnectionImpl x0) {
        return x0.isAcknowledge;
    }

    static /* synthetic */ String access$3200(ServerConnectionImpl x0) {
        return x0.clientConnectMessageId;
    }

    static /* synthetic */ String access$3300(ServerConnectionImpl x0) {
        return x0.messageLostErrorMessageId;
    }

    private class ClientDistributedQueueSelector
    extends AbstractDistributedQueueSelectorService {
        private static final long serialVersionUID = 8661094319264622631L;

        private ClientDistributedQueueSelector() {
        }

        @Override
        protected Object getKey(Object obj) {
            AsynchContext asynchContext = (AsynchContext)obj;
            SendRequest request = (SendRequest)asynchContext.getInput();
            return request.client;
        }
    }

    private class RequestHandleQueueHandler
    implements QueueHandler {
        private RequestHandleQueueHandler() {
        }

        @Override
        public void handleDequeuedObject(Object obj) throws Throwable {
            if (obj == null) {
                return;
            }
            RequestHandleRequest request = (RequestHandleRequest)obj;
            switch (request.requestType) {
                case 1: {
                    request.client.receive(request.key);
                    request.key.interestOps(request.key.interestOps() | 1);
                    break;
                }
                case 2: {
                    request.client.writeResponse(request.key);
                }
            }
        }

        @Override
        public boolean handleError(Object obj, Throwable th) throws Throwable {
            return true;
        }

        @Override
        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            throw th;
        }
    }

    private static class RequestHandleRequest {
        public static final int REQUEST_TYPE_READ = 1;
        public static final int REQUEST_TYPE_WRITE = 2;
        public ClientImpl client;
        public SelectionKey key;
        public int requestType;

        public RequestHandleRequest(ClientImpl client, SelectionKey key, int type) {
            this.client = client;
            this.key = key;
            this.requestType = type;
        }
    }

    private class SendQueueHandler
    implements QueueHandler {
        private SendQueueHandler() {
        }

        @Override
        public void handleDequeuedObject(Object obj) throws Throwable {
            if (obj == null) {
                return;
            }
            AsynchContext asynchContext = (AsynchContext)obj;
            SendRequest request = (SendRequest)asynchContext.getInput();
            if (request.client.isStartReceive()) {
                request.client.send(request.message);
            }
            if (asynchContext.getResponseQueue() != null) {
                asynchContext.getResponseQueue().push(asynchContext);
            }
        }

        @Override
        public boolean handleError(Object obj, Throwable th) throws Throwable {
            AsynchContext asynchContext = (AsynchContext)obj;
            if (ServerConnectionImpl.this.logger != null && ServerConnectionImpl.this.sendErrorMessageId != null) {
                SendRequest request = (SendRequest)asynchContext.getInput();
                ServerConnectionImpl.this.logger.write(ServerConnectionImpl.this.sendErrorMessageId, new Object[]{request.client == null ? ServerConnectionImpl.this.multicastAddress + ":" + ServerConnectionImpl.this.destPort : request.client.toString(), request.message}, th);
            }
            return true;
        }

        @Override
        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            AsynchContext asynchContext = (AsynchContext)obj;
            if (ServerConnectionImpl.this.logger != null && ServerConnectionImpl.this.sendErrorRetryOverMessageId != null) {
                SendRequest request = (SendRequest)asynchContext.getInput();
                ServerConnectionImpl.this.logger.write(ServerConnectionImpl.this.sendErrorRetryOverMessageId, new Object[]{request.client == null ? ServerConnectionImpl.this.multicastAddress + ":" + ServerConnectionImpl.this.destPort : request.client.toString(), request.message}, th);
            }
            asynchContext.setThrowable(th);
            if (asynchContext.getResponseQueue() != null) {
                asynchContext.getResponseQueue().push(asynchContext);
            }
        }
    }

    private class SendRequest {
        public ClientImpl client;
        public MessageImpl message;

        public SendRequest(ClientImpl client, MessageImpl message) {
            this.client = client;
            this.message = message;
        }

        public void clear() {
            this.client = null;
            this.message = null;
        }
    }

    private class AsynchAcceptQueueHandler
    implements QueueHandler {
        private DefaultQueueService responseQueue = new DefaultQueueService();

        public AsynchAcceptQueueHandler() {
            try {
                this.responseQueue.create();
                this.responseQueue.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.responseQueue.accept();
        }

        @Override
        public void handleDequeuedObject(Object obj) throws Throwable {
            MessageImpl message = (MessageImpl)obj;
            if (message == null) {
                return;
            }
            if (ServerConnectionImpl.this.clients.size() == 0) {
                message.setSend(true);
                return;
            }
            Set firstClients = ServerConnectionImpl.this.allocateSequence(message);
            if (ServerConnectionImpl.this.multicastAddress == null) {
                AsynchContext asynchContext;
                HashMap<ClientImpl, AsynchContext> sendContexts = new HashMap<ClientImpl, AsynchContext>();
                for (ClientImpl client : ServerConnectionImpl.this.clients) {
                    if (client == null || !client.isStartReceive() || !client.isTargetMessage(message)) continue;
                    SendRequest sendRequest = ServerConnectionImpl.this.createSendRequest(client, message);
                    asynchContext = ServerConnectionImpl.this.createAsynchContext(sendRequest, this.responseQueue);
                    sendContexts.put(client, asynchContext);
                    ServerConnectionImpl.this.asynchSendQueueHandlerContainer.push(asynchContext);
                }
                int imax = sendContexts.size();
                for (int i = 0; i < imax; ++i) {
                    asynchContext = (AsynchContext)this.responseQueue.get();
                    if (asynchContext != null) continue;
                    this.responseQueue = new DefaultQueueService();
                    try {
                        this.responseQueue.create();
                        this.responseQueue.start();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.responseQueue.accept();
                    break;
                }
                this.responseQueue.clear();
            } else {
                if (firstClients != null) {
                    for (ClientImpl client : firstClients) {
                        if (!client.isStartReceive()) continue;
                        client.send(message);
                    }
                }
                ServerConnectionImpl.this.sendMessage(ServerConnectionImpl.this.sendSocket, ServerConnectionImpl.this.multicastAddress, message, ServerConnectionImpl.this.destPort, false);
            }
            message.setSend(true);
            try {
                ServerConnectionImpl.this.addSendMessageCache(message);
            }
            catch (IOException e) {
                throw new MessageSendException("Send error : message=" + message, e);
            }
        }

        @Override
        public boolean handleError(Object obj, Throwable th) throws Throwable {
            if (ServerConnectionImpl.this.logger != null && ServerConnectionImpl.this.sendErrorMessageId != null) {
                ServerConnectionImpl.this.logger.write(ServerConnectionImpl.this.sendErrorMessageId, new Object[]{ServerConnectionImpl.this.multicastAddress + ":" + ServerConnectionImpl.this.destPort, obj}, th);
            }
            return true;
        }

        @Override
        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            if (ServerConnectionImpl.this.logger != null && ServerConnectionImpl.this.sendErrorRetryOverMessageId != null) {
                ServerConnectionImpl.this.logger.write(ServerConnectionImpl.this.sendErrorRetryOverMessageId, new Object[]{ServerConnectionImpl.this.multicastAddress + ":" + ServerConnectionImpl.this.destPort, obj}, th);
            }
        }
    }

    public class ClientImpl
    implements DaemonRunnable,
    Client {
        private DatagramSocket sendSocket;
        private SocketChannel socketChannel;
        private Socket socket;
        private Daemon requestDispatcher;
        private Map subjects;
        private long sendCount;
        private long sendProcessTime;
        private long newMessagePollingCount;
        private long interpolateRequestCount;
        private boolean isEnabled = true;
        private Object id;
        private ByteBuffer byteBuffer;
        private int dataLength = -1;
        private InetAddress clientAddress;
        private int destPort;
        private long fromTime = -1L;
        private boolean isStartReceive = false;
        private Message firstMessage;
        private MessageId latestFirstMessageId;
        private Queue responseQueue;
        private long lostCount;
        private int currentSequence = 0;
        private List sendMessageCache;
        private Map sendMessageCacheMap;
        private Object socketLock = new Object();

        public ClientImpl(SocketChannel sc, DatagramSocket ss) {
            this.socketChannel = sc;
            this.sendSocket = ss;
            this.socket = this.socketChannel.socket();
            this.clientAddress = ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress();
            this.subjects = Collections.synchronizedMap(new HashMap());
            this.byteBuffer = ByteBuffer.allocate(ServerConnectionImpl.this.windowSize);
            DefaultQueueService queue = new DefaultQueueService();
            try {
                queue.create();
                queue.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            queue.accept();
            this.responseQueue = queue;
            if (ServerConnectionImpl.this.multicastAddress == null) {
                this.sendMessageCache = Collections.synchronizedList(new ArrayList());
                this.sendMessageCacheMap = Collections.synchronizedMap(new HashMap());
            }
        }

        public ClientImpl(Socket sock, DatagramSocket ss) throws IOException {
            this.socket = sock;
            this.sendSocket = ss;
            this.clientAddress = ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress();
            this.subjects = Collections.synchronizedMap(new HashMap());
            this.requestDispatcher = new Daemon(this);
            this.requestDispatcher.setName("Nimbus Publish(UDP) ServerConnection ClientRequestDisptcher " + this.socket.getRemoteSocketAddress());
            this.requestDispatcher.setDaemon(true);
            this.requestDispatcher.start();
            if (ServerConnectionImpl.this.multicastAddress == null) {
                this.sendMessageCache = Collections.synchronizedList(new ArrayList());
                this.sendMessageCacheMap = Collections.synchronizedMap(new HashMap());
            }
        }

        private synchronized MessageImpl allocateSequence(MessageImpl message, boolean copy) {
            ++this.currentSequence;
            MessageImpl result = copy ? ServerConnectionImpl.this.copyMessage(message) : message;
            result.setSequence(this.currentSequence);
            long currentTime = System.currentTimeMillis();
            result.setSendTime(currentTime);
            return result;
        }

        private void addSendMessageCache(MessageImpl message) throws IOException {
            ServerConnectionImpl.this.addSendMessageCache(message, this.sendMessageCacheMap, this.sendMessageCache);
        }

        private List getSendWindows(MessageId id) {
            return ServerConnectionImpl.this.getSendWindows(id, this.sendMessageCacheMap != null ? this.sendMessageCacheMap : ServerConnectionImpl.this.sendMessageCacheMap);
        }

        private List getSendMessages(long from) {
            return ServerConnectionImpl.this.getSendMessages(from, this.sendMessageCacheMap != null ? this.sendMessageCacheMap : ServerConnectionImpl.this.sendMessageCacheMap, this.sendMessageCache != null ? this.sendMessageCache : ServerConnectionImpl.this.sendMessageCache);
        }

        private Message getSendMessage(MessageId id) {
            return ServerConnectionImpl.this.getSendMessage(id, this.sendMessageCacheMap != null ? this.sendMessageCacheMap : ServerConnectionImpl.this.sendMessageCacheMap, this.sendMessageCache != null ? this.sendMessageCache : ServerConnectionImpl.this.sendMessageCache);
        }

        private List getSendMessages(MessageId from, MessageId to) {
            return ServerConnectionImpl.this.getSendMessages(from, to, this.sendMessageCacheMap != null ? this.sendMessageCacheMap : ServerConnectionImpl.this.sendMessageCacheMap, this.sendMessageCache != null ? this.sendMessageCache : ServerConnectionImpl.this.sendMessageCache);
        }

        private Window getSendWindow(WindowId id) {
            return ServerConnectionImpl.this.getSendWindow(id, this.sendMessageCacheMap != null ? this.sendMessageCacheMap : ServerConnectionImpl.this.sendMessageCacheMap);
        }

        private int getMostOldSendMessageCacheSequence() {
            return ServerConnectionImpl.this.getMostOldSendMessageCacheSequence(this.sendMessageCacheMap != null ? this.sendMessageCacheMap : ServerConnectionImpl.this.sendMessageCacheMap, this.sendMessageCache != null ? this.sendMessageCache : ServerConnectionImpl.this.sendMessageCache);
        }

        private Date getMostOldSendMessageCacheTime() {
            return ServerConnectionImpl.this.getMostOldSendMessageCacheTime(this.sendMessageCacheMap != null ? this.sendMessageCacheMap : ServerConnectionImpl.this.sendMessageCacheMap, this.sendMessageCache != null ? this.sendMessageCache : ServerConnectionImpl.this.sendMessageCache);
        }

        public boolean isStartReceive() {
            return this.isStartReceive;
        }

        public boolean isFirstMessage() {
            return this.firstMessage == null;
        }

        public boolean setFirstMessage(Message msg) {
            if (this.firstMessage == null) {
                this.firstMessage = msg;
                return true;
            }
            return false;
        }

        public SocketChannel getSocketChannel() {
            return this.socketChannel;
        }

        public Socket getSocket() {
            return this.socket;
        }

        public void setDestPort(int port) {
            this.destPort = port;
        }

        public int getDestPort() {
            return this.destPort;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void setEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public boolean isTargetMessage(Message message) {
            if (!message.containsDestinationId(this.getId())) {
                return false;
            }
            if (message.getSubject() != null) {
                for (String subject : message.getSubjects()) {
                    Set keySet = (Set)this.subjects.get(subject);
                    String key = message.getKey(subject);
                    if (keySet == null || !keySet.contains(null) && !keySet.contains(key)) continue;
                    return true;
                }
            }
            return false;
        }

        public synchronized void send(Message message) throws MessageSendException {
            block18: {
                if (!this.isEnabled || this.sendSocket == null && ServerConnectionImpl.this.sendSocket == null) {
                    return;
                }
                MessageImpl copyMsg = null;
                if (this.latestFirstMessageId == null) {
                    if (((MessageImpl)message).isFirst()) {
                        this.firstMessage = null;
                        this.latestFirstMessageId = ((MessageImpl)message).toMessageId();
                    } else if (this.firstMessage != null && this.firstMessage.equals(message)) {
                        this.firstMessage = null;
                        if (copyMsg == null) {
                            copyMsg = ServerConnectionImpl.this.copyMessage((MessageImpl)message);
                            message = copyMsg;
                        }
                        ((MessageImpl)message).setFirst(true);
                        this.latestFirstMessageId = ((MessageImpl)message).toMessageId();
                    }
                } else {
                    this.firstMessage = null;
                }
                if (ServerConnectionImpl.this.multicastAddress == null) {
                    copyMsg = this.allocateSequence((MessageImpl)message, copyMsg == null);
                    message = copyMsg;
                } else {
                    if (copyMsg == null) {
                        copyMsg = ServerConnectionImpl.this.copyMessage((MessageImpl)message);
                        message = copyMsg;
                    }
                    ((MulticastMessageImpl)message).addToId(this.id);
                }
                long startTime = System.currentTimeMillis();
                try {
                    ServerConnectionImpl.this.sendMessage(this.sendSocket == null ? ServerConnectionImpl.this.sendSocket : this.sendSocket, ServerConnectionImpl.this.multicastAddress == null ? this.clientAddress : ServerConnectionImpl.this.multicastAddress, (MessageImpl)message, this.destPort, false);
                    ++this.sendCount;
                    this.sendProcessTime += System.currentTimeMillis() - startTime;
                    if (ServerConnectionImpl.this.multicastAddress == null) {
                        ((MessageImpl)message).setSend(true);
                        try {
                            this.addSendMessageCache((MessageImpl)message);
                            break block18;
                        }
                        catch (IOException e) {
                            throw new MessageSendException("Send error : message=" + message, e);
                        }
                    }
                    if (copyMsg != null) {
                        ServerConnectionImpl.this.recycleMessage(copyMsg);
                    }
                }
                catch (SocketTimeoutException e) {
                    throw new MessageSendException(e);
                }
                catch (SocketException e) {
                    this.close();
                    throw new MessageSendException(e);
                }
                catch (IOException e) {
                    this.close();
                    throw new MessageSendException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(SelectionKey key) {
            try {
                int readLength = 0;
                if (this.socketChannel != null) {
                    Object object = this.socketLock;
                    synchronized (object) {
                        if (this.socketChannel != null) {
                            readLength = this.socketChannel.read(this.byteBuffer);
                        }
                    }
                }
                if (readLength == 0) {
                    return;
                }
                if (readLength == -1) {
                    throw new EOFException("EOF in reading length.");
                }
                do {
                    if (this.dataLength < 0) {
                        if (this.byteBuffer.position() < 4) {
                            return;
                        }
                        this.byteBuffer.flip();
                        this.dataLength = this.byteBuffer.getInt();
                        this.byteBuffer.compact();
                        if (this.dataLength <= 0) {
                            throw new IOException("DataLength is illegal." + this.dataLength);
                        }
                        if (this.dataLength > this.byteBuffer.capacity()) {
                            this.byteBuffer.flip();
                            this.byteBuffer.rewind();
                            ByteBuffer newByteBuffer = ByteBuffer.allocate(this.dataLength);
                            newByteBuffer.put(this.byteBuffer);
                            this.byteBuffer = newByteBuffer;
                        }
                    }
                    if (this.byteBuffer.position() < this.dataLength) {
                        return;
                    }
                    this.byteBuffer.flip();
                    byte[] dataBytes = new byte[this.dataLength];
                    this.byteBuffer.get(dataBytes);
                    this.dataLength = -1;
                    this.byteBuffer.compact();
                    ByteArrayInputStream is = new ByteArrayInputStream(dataBytes);
                    ClientMessage clientMessage = null;
                    if (ServerConnectionImpl.this.externalizer == null) {
                        ObjectInputStream ois = new ObjectInputStream(is);
                        clientMessage = (ClientMessage)ois.readObject();
                    } else {
                        clientMessage = (ClientMessage)ServerConnectionImpl.this.externalizer.readExternal(is);
                    }
                    if (!this.handleMessage(clientMessage, key)) continue;
                    key.cancel();
                    return;
                } while (this.byteBuffer.position() != 0);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SocketTimeoutException e) {
            }
            catch (IOException e) {
                key.cancel();
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeResponse(SelectionKey key) {
            block7: {
                ByteBuffer buf = null;
                try {
                    if (this.socketChannel == null || this.responseQueue == null) break block7;
                    Object object = this.socketLock;
                    synchronized (object) {
                        if (this.socketChannel != null && this.responseQueue != null) {
                            while ((buf = (ByteBuffer)this.responseQueue.get(0L)) != null) {
                                this.socketChannel.write(buf);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    key.cancel();
                    this.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendServerMessage(ServerMessage message, SelectionKey key) {
            block16: {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (ServerConnectionImpl.this.externalizer == null) {
                        ObjectOutputStream oos = new ObjectOutputStream(baos);
                        oos.writeObject(message);
                        oos.flush();
                        oos.close();
                    } else {
                        ServerConnectionImpl.this.externalizer.writeExternal((Object)message, baos);
                    }
                    byte[] bytes = baos.toByteArray();
                    if (this.socketChannel != null) {
                        ByteBuffer buf = ByteBuffer.allocate(bytes.length + 4);
                        buf.putInt(bytes.length);
                        buf.put(bytes);
                        buf.flip();
                        if (this.responseQueue != null) {
                            Object object = this.socketLock;
                            synchronized (object) {
                                if (this.responseQueue != null) {
                                    this.responseQueue.push(buf);
                                }
                            }
                        }
                        if (key != null) {
                            key.interestOps(key.interestOps() | 4);
                            ServerConnectionImpl.this.selector.wakeup();
                        }
                        break block16;
                    }
                    if (this.socket == null) break block16;
                    Object object = this.socketLock;
                    synchronized (object) {
                        if (this.socket != null) {
                            DataOutputStream dos = new DataOutputStream(this.socket.getOutputStream());
                            dos.writeInt(bytes.length);
                            dos.write(bytes);
                            dos.flush();
                        }
                    }
                }
                catch (SocketException baos) {
                }
                catch (IOException e) {
                    if (ServerConnectionImpl.this.responseErrorMessageId == null) break block16;
                    ServerConnectionImpl.this.logger.write(ServerConnectionImpl.this.responseErrorMessageId, new Object[]{this, message}, (Throwable)e);
                }
            }
        }

        public long getSendCount() {
            return this.sendCount;
        }

        public void resetSendCount() {
            this.sendCount = 0L;
            this.sendProcessTime = 0L;
        }

        public long getNewMessagePollingCount() {
            return this.newMessagePollingCount;
        }

        public void resetNewMessagePollingCount() {
            this.newMessagePollingCount = 0L;
        }

        public long getInterpolateRequestCount() {
            return this.interpolateRequestCount;
        }

        public void resetInterpolateRequestCount() {
            this.interpolateRequestCount = 0L;
        }

        public long getLostCount() {
            return this.lostCount;
        }

        public void resetLostCount() {
            this.lostCount = 0L;
        }

        public long getAverageSendProcessTime() {
            return this.sendCount == 0L ? 0L : this.sendProcessTime / this.sendCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() {
            if (ServerConnectionImpl.this.logger != null && ServerConnectionImpl.this.clientCloseMessageId != null) {
                ServerConnectionImpl.this.logger.write(ServerConnectionImpl.this.clientCloseMessageId, new Object[]{this});
            }
            if (this.subjects.size() != 0) {
                for (Map.Entry entry : this.subjects.entrySet()) {
                    String subject = (String)entry.getKey();
                    Set keySet = (Set)entry.getValue();
                    if (ServerConnectionImpl.this.serverConnectionListeners == null || keySet.isEmpty()) continue;
                    String[] removeKeys = keySet.toArray(new String[0]);
                    int imax = ServerConnectionImpl.this.serverConnectionListeners.size();
                    for (int i = 0; i < imax; ++i) {
                        ((ServerConnectionListener)ServerConnectionImpl.this.serverConnectionListeners.get(i)).onRemoveSubject(this, subject, removeKeys);
                    }
                }
            }
            if (this.isStartReceive) {
                this.isStartReceive = false;
                if (ServerConnectionImpl.this.serverConnectionListeners != null) {
                    int imax = ServerConnectionImpl.this.serverConnectionListeners.size();
                    for (int i = 0; i < imax; ++i) {
                        ((ServerConnectionListener)ServerConnectionImpl.this.serverConnectionListeners.get(i)).onStopReceive(this);
                    }
                }
            }
            Object id = this.getId();
            if (this.requestDispatcher != null) {
                this.requestDispatcher.stopNoWait();
                this.requestDispatcher = null;
            }
            Object imax = this.socketLock;
            synchronized (imax) {
                if (this.responseQueue != null) {
                    this.responseQueue.release();
                    this.responseQueue = null;
                }
                if (this.socketChannel != null) {
                    try {
                        this.socketChannel.close();
                    }
                    catch (IOException subject) {
                        // empty catch block
                    }
                    this.socketChannel = null;
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException subject) {
                        // empty catch block
                    }
                    this.socket = null;
                }
            }
            if (this.sendSocket != null) {
                this.sendSocket.close();
                this.sendSocket = null;
            }
            LinkedHashSet tmpClients = new LinkedHashSet();
            tmpClients.addAll(ServerConnectionImpl.this.clients);
            tmpClients.remove(this);
            ServerConnectionImpl.this.clients = tmpClients;
            ServerConnectionImpl.this.clientMap.remove(id);
            ServerConnectionImpl.this.newClients.remove(this);
            if (ServerConnectionImpl.this.serverConnectionListeners != null) {
                int imax2 = ServerConnectionImpl.this.serverConnectionListeners.size();
                for (int i = 0; i < imax2; ++i) {
                    ((ServerConnectionListener)ServerConnectionImpl.this.serverConnectionListeners.get(i)).onClose(this);
                }
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.toString());
            buf.append('{');
            buf.append("client=").append(this.clientAddress).append(':').append(this.destPort);
            buf.append(", subject=").append(this.subjects);
            buf.append(", isEnabled=").append(this.isEnabled);
            buf.append('}');
            return buf.toString();
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            try {
                DataInputStream dis = new DataInputStream(this.socket.getInputStream());
                int length = dis.readInt();
                byte[] bytes = new byte[length];
                dis.readFully(bytes);
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                if (ServerConnectionImpl.this.externalizer == null) {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    return ois.readObject();
                }
                return ServerConnectionImpl.this.externalizer.readExternal(bais);
            }
            catch (ClassNotFoundException e) {
                return this;
            }
            catch (SocketTimeoutException e) {
                return this;
            }
            catch (SocketException e) {
                return null;
            }
            catch (EOFException e) {
                return null;
            }
            catch (IOException e) {
                return this;
            }
        }

        @Override
        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            if (paramObj == null) {
                this.close();
                return;
            }
            if (!(paramObj instanceof ClientMessage)) {
                return;
            }
            ClientMessage message = (ClientMessage)paramObj;
            this.handleMessage(message, null);
        }

        /*
         * Unable to fully structure code
         */
        protected boolean handleMessage(ClientMessage message, SelectionKey key) {
            keySet = null;
            keys = null;
            isClosed = false;
            switch (message.getMessageType()) {
                case 1: {
                    idMessage = (IdMessage)message;
                    ServerConnectionImpl.access$1100(ServerConnectionImpl.this).remove(this.getId());
                    this.id = idMessage.getId();
                    ServerConnectionImpl.access$1100(ServerConnectionImpl.this).put(this.getId(), this);
                    this.destPort = idMessage.getReceivePort();
                    if (ServerConnectionImpl.access$3000(ServerConnectionImpl.this) != null) {
                        imax = ServerConnectionImpl.access$3000(ServerConnectionImpl.this).size();
                        for (i = 0; i < imax; ++i) {
                            ((ServerConnectionListener)ServerConnectionImpl.access$3000(ServerConnectionImpl.this).get(i)).onConnect(this);
                        }
                    }
                    if (ServerConnectionImpl.access$3100(ServerConnectionImpl.this)) {
                        resposne = new ServerMessage(3);
                        resposne.setRequestId(message.getRequestId());
                        this.sendServerMessage(resposne, key);
                    }
                    if (ServerConnectionImpl.access$2800(ServerConnectionImpl.this) == null || ServerConnectionImpl.access$3200(ServerConnectionImpl.this) == null) break;
                    ServerConnectionImpl.access$2800(ServerConnectionImpl.this).write(ServerConnectionImpl.access$3200(ServerConnectionImpl.this), new Object[]{this});
                    break;
                }
                case 2: {
                    addKeysList = Collections.synchronizedList(new ArrayList<E>());
                    addMessage = (AddMessage)message;
                    keySet = (Set<String>)this.subjects.get(addMessage.getSubject());
                    if (keySet == null) {
                        keySet = Collections.synchronizedSet(new HashSet<E>());
                        this.subjects.put(addMessage.getSubject(), keySet);
                    }
                    if ((keys = addMessage.getKeys()) == null) {
                        if (keySet.add(null)) {
                            addKeysList.add(null);
                        }
                    } else {
                        for (i = 0; i < keys.length; ++i) {
                            if (!keySet.add(keys[i])) continue;
                            addKeysList.add(keys[i]);
                        }
                    }
                    if (ServerConnectionImpl.access$3000(ServerConnectionImpl.this) != null && !addKeysList.isEmpty()) {
                        addkeys = addKeysList.toArray(new String[0]);
                        imax = ServerConnectionImpl.access$3000(ServerConnectionImpl.this).size();
                        for (i = 0; i < imax; ++i) {
                            ((ServerConnectionListener)ServerConnectionImpl.access$3000(ServerConnectionImpl.this).get(i)).onAddSubject(this, addMessage.getSubject(), addkeys);
                        }
                    }
                    if (!ServerConnectionImpl.access$3100(ServerConnectionImpl.this)) break;
                    resposne = new ServerMessage(3);
                    resposne.setRequestId(message.getRequestId());
                    this.sendServerMessage(resposne, key);
                    break;
                }
                case 3: {
                    removeKeysList = Collections.synchronizedList(new ArrayList<E>());
                    removeMessage = (RemoveMessage)message;
                    keySet = (Set)this.subjects.get(removeMessage.getSubject());
                    if (keySet != null) {
                        keys = removeMessage.getKeys();
                        if (keys == null) {
                            if (keySet.remove(null)) {
                                removeKeysList.add(null);
                            }
                            if (keySet.size() == 0) {
                                this.subjects.remove(removeMessage.getSubject());
                            }
                        } else {
                            for (i = 0; i < keys.length; ++i) {
                                if (!keySet.remove(keys[i])) continue;
                                removeKeysList.add(keys[i]);
                            }
                            if (keySet.size() == 0) {
                                this.subjects.remove(removeMessage.getSubject());
                            }
                        }
                        if (ServerConnectionImpl.access$3000(ServerConnectionImpl.this) != null && !removeKeysList.isEmpty()) {
                            removeKeys = removeKeysList.toArray(new String[0]);
                            imax = ServerConnectionImpl.access$3000(ServerConnectionImpl.this).size();
                            for (i = 0; i < imax; ++i) {
                                ((ServerConnectionListener)ServerConnectionImpl.access$3000(ServerConnectionImpl.this).get(i)).onRemoveSubject(this, removeMessage.getSubject(), removeKeys);
                            }
                        }
                    }
                    if (!ServerConnectionImpl.access$3100(ServerConnectionImpl.this)) break;
                    resposne = new ServerMessage(3);
                    resposne.setRequestId(message.getRequestId());
                    this.sendServerMessage(resposne, key);
                    break;
                }
                case 7: {
                    interpolateReqMessage = (InterpolateRequestMessage)message;
                    interpolateResMessage = new InterpolateResponseMessage();
                    interpolateResMessage.setRequestId(interpolateReqMessage.getRequestId());
                    latestMessageId = interpolateReqMessage.getLatestMessageId();
                    currentFirstMessageId = interpolateReqMessage.getCurrentFirstMessageId();
                    messageIds = interpolateReqMessage.getMessageIds();
                    windowIds = interpolateReqMessage.getWindowIds();
                    if (currentFirstMessageId != null || messageIds != null || windowIds != null) {
                        ++this.interpolateRequestCount;
                        lostIds = new ArrayList<MessageId>();
                        lostMessageIds = new HashSet<MessageId>();
                        if (currentFirstMessageId != null && this.latestFirstMessageId != null) {
                            messages = null;
                            if (currentFirstMessageId.equals(this.latestFirstMessageId)) {
                                messages = new ArrayList<E>();
                                msg = this.getSendMessage(this.latestFirstMessageId);
                                if (msg != null) {
                                    messages.add(msg);
                                }
                            } else {
                                messages = this.getSendMessages(this.latestFirstMessageId, currentFirstMessageId);
                                msg = this.getSendMessage(currentFirstMessageId);
                                if (msg != null) {
                                    messages.add(msg);
                                }
                            }
                            if (messages.size() == 0) {
                                lostIds.add(this.latestFirstMessageId);
                                lostIds = this.latestFirstMessageId.createMissingIds(currentFirstMessageId, lostIds);
                            } else {
                                for (i = 0; i < messages.size(); ++i) {
                                    msg = (MessageImpl)messages.get(i);
                                    if (i == 0) {
                                        msg.setFirst(true);
                                        if (!msg.equals(this.latestFirstMessageId)) {
                                            lostIds.add(this.latestFirstMessageId);
                                            lostIds = this.latestFirstMessageId.createMissingIds(msg, lostIds);
                                            this.latestFirstMessageId = msg.toMessageId();
                                        }
                                    }
                                    try {
                                        interpolateResMessage.addWindows(msg.getWindows(ServerConnectionImpl.this, ServerConnectionImpl.access$1300(ServerConnectionImpl.this), ServerConnectionImpl.access$2600(ServerConnectionImpl.this)));
                                        ServerConnectionImpl.this.recycleMessage(msg);
                                        continue;
                                    }
                                    catch (IOException var22_54) {
                                        // empty catch block
                                    }
                                }
                            }
                            lostMessageIds.addAll(lostIds);
                        }
                        if (messageIds != null) {
                            for (i = 0; i < messageIds.length; ++i) {
                                windows = this.getSendWindows(messageIds[i]);
                                if (windows != null) {
                                    interpolateResMessage.addWindows(messageIds[i], windows);
                                    continue;
                                }
                                lostIds.add(messageIds[i]);
                                lostMessageIds.add(messageIds[i]);
                            }
                        }
                        if (windowIds != null) {
                            for (i = 0; i < windowIds.length; ++i) {
                                window = this.getSendWindow(windowIds[i]);
                                if (window != null) {
                                    interpolateResMessage.addWindow(windowIds[i], window);
                                    continue;
                                }
                                lostIds.add(windowIds[i]);
                                lostMessageIds.add(windowIds[i].toMessageId());
                            }
                        }
                        if (lostIds.size() != 0 && ServerConnectionImpl.access$2800(ServerConnectionImpl.this) != null && ServerConnectionImpl.access$3300(ServerConnectionImpl.this) != null) {
                            this.lostCount += (long)lostMessageIds.size();
                            ServerConnectionImpl.access$2800(ServerConnectionImpl.this).write(ServerConnectionImpl.access$3300(ServerConnectionImpl.this), new Object[]{this, lostIds.get(0), lostIds.get(lostIds.size() - 1), new Integer(lostIds.size()), new Integer(this.getMostOldSendMessageCacheSequence()), this.getMostOldSendMessageCacheTime()});
                        }
                    } else {
                        ++this.newMessagePollingCount;
                        messages = null;
                        if (latestMessageId != null) {
                            messages = this.getSendMessages(latestMessageId.next(), null);
                        } else if (this.latestFirstMessageId != null) {
                            messages = this.getSendMessages(this.latestFirstMessageId, null);
                        }
                        if (messages != null) {
                            for (i = 0; i < messages.size(); ++i) {
                                msg = (MessageImpl)messages.get(i);
                                try {
                                    interpolateResMessage.addWindows(msg.getWindows(ServerConnectionImpl.this, ServerConnectionImpl.access$1300(ServerConnectionImpl.this), ServerConnectionImpl.access$2600(ServerConnectionImpl.this)));
                                    ServerConnectionImpl.this.recycleMessage(msg);
                                    continue;
                                }
                                catch (IOException window) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    this.sendServerMessage(interpolateResMessage, key);
                    break;
                }
                case 5: {
                    startMessage = (StartReceiveMessage)message;
                    this.fromTime = startMessage.getFrom();
                    if (this.fromTime < 0L) ** GOTO lbl201
                    messages = this.getSendMessages(this.fromTime);
                    isFirstMessage = true;
                    for (i = 0; i < messages.size(); ++i) {
                        msg = (MessageImpl)messages.get(i);
                        if (ServerConnectionImpl.access$1400(ServerConnectionImpl.this) == null && !this.isTargetMessage(msg)) continue;
                        if (isFirstMessage) {
                            msg.setFirst(true);
                            isFirstMessage = false;
                        }
                        try {
                            this.send(msg);
                        }
                        catch (MessageSendException e) {
                            if (ServerConnectionImpl.access$2800(ServerConnectionImpl.this) == null || ServerConnectionImpl.access$3400(ServerConnectionImpl.this) == null) ** GOTO lbl199
                            ServerConnectionImpl.access$2800(ServerConnectionImpl.this).write(ServerConnectionImpl.access$3400(ServerConnectionImpl.this), new Object[]{this, msg}, (Throwable)e);
                        }
lbl199:
                        // 3 sources

                        if (ServerConnectionImpl.access$1400(ServerConnectionImpl.this) != null) break;
                    }
lbl201:
                    // 3 sources

                    this.isStartReceive = true;
                    if (ServerConnectionImpl.access$3000(ServerConnectionImpl.this) != null) {
                        imax = ServerConnectionImpl.access$3000(ServerConnectionImpl.this).size();
                        for (i = 0; i < imax; ++i) {
                            ((ServerConnectionListener)ServerConnectionImpl.access$3000(ServerConnectionImpl.this).get(i)).onStartReceive(this, this.fromTime);
                        }
                    }
                    if (!ServerConnectionImpl.access$3100(ServerConnectionImpl.this)) break;
                    resposne = new ServerMessage(3);
                    resposne.setRequestId(message.getRequestId());
                    this.sendServerMessage(resposne, key);
                    break;
                }
                case 6: {
                    this.isStartReceive = false;
                    this.firstMessage = null;
                    if (ServerConnectionImpl.access$3000(ServerConnectionImpl.this) != null) {
                        imax = ServerConnectionImpl.access$3000(ServerConnectionImpl.this).size();
                        for (i = 0; i < imax; ++i) {
                            ((ServerConnectionListener)ServerConnectionImpl.access$3000(ServerConnectionImpl.this).get(i)).onStopReceive(this);
                        }
                    }
                    if (!ServerConnectionImpl.access$3100(ServerConnectionImpl.this)) break;
                    resposne = new ServerMessage(3);
                    resposne.setRequestId(message.getRequestId());
                    this.sendServerMessage(resposne, key);
                    break;
                }
                case 4: {
                    this.close();
                    isClosed = true;
                    break;
                }
            }
            return isClosed;
        }

        @Override
        public void garbage() {
        }

        @Override
        public Set getSubjects() {
            if (this.subjects == null) {
                return null;
            }
            return new HashSet(this.subjects.keySet());
        }

        @Override
        public Set getKeys(String subject) {
            if (this.subjects == null) {
                return null;
            }
            return (Set)this.subjects.get(subject);
        }

        @Override
        public Object getId() {
            return this.id == null ? (this.socket == null ? null : this.socket.getRemoteSocketAddress()) : this.id;
        }
    }

    private class ClientAcceptor
    implements DaemonRunnable {
        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            if (ServerConnectionImpl.this.selector != null) {
                try {
                    return ServerConnectionImpl.this.selector.select(1000L) > 0 ? ServerConnectionImpl.this.selector.selectedKeys() : this;
                }
                catch (ClosedSelectorException e) {
                    return null;
                }
                catch (IOException e) {
                    return this;
                }
            }
            try {
                return ServerConnectionImpl.this.serverSocket.accept();
            }
            catch (SocketTimeoutException e) {
                return this;
            }
            catch (SocketException e) {
                return null;
            }
            catch (IOException e) {
                return this;
            }
        }

        @Override
        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            if (paramObj == null) {
                ServerConnectionImpl.this.close();
                return;
            }
            if (ServerConnectionImpl.this.selector != null) {
                ClientImpl client = null;
                if (!(paramObj instanceof Set)) {
                    return;
                }
                Set keys = (Set)paramObj;
                Iterator itr = keys.iterator();
                while (itr.hasNext()) {
                    SelectionKey key = (SelectionKey)itr.next();
                    itr.remove();
                    try {
                        if (key.isAcceptable()) {
                            ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
                            SocketChannel channel = ssc.accept();
                            if (channel == null) continue;
                            channel.configureBlocking(false);
                            if (ServerConnectionImpl.this.socketFactory != null) {
                                ServerConnectionImpl.this.socketFactory.applySocketProperties(channel.socket());
                            }
                            client = new ClientImpl(channel, ServerConnectionImpl.this.sendSocket == null ? (ServerConnectionImpl.this.sendSocketAddress == null ? new DatagramSocket() : new DatagramSocket(ServerConnectionImpl.this.sendSocketAddress)) : null);
                            client.setDestPort(ServerConnectionImpl.this.destPort);
                            channel.register(key.selector(), 1, client);
                            LinkedHashSet<ClientImpl> tmpClients = new LinkedHashSet<ClientImpl>();
                            tmpClients.addAll(ServerConnectionImpl.this.clients);
                            tmpClients.add(client);
                            ServerConnectionImpl.this.clients = tmpClients;
                            ServerConnectionImpl.this.newClients.add(client);
                            ServerConnectionImpl.this.clientMap.put(client.getId(), client);
                            continue;
                        }
                        if (key.isReadable()) {
                            client = (ClientImpl)key.attachment();
                            if (ServerConnectionImpl.this.requestHandleQueueHandlerContainer == null) {
                                client.receive(key);
                                continue;
                            }
                            key.interestOps(key.interestOps() & 0xFFFFFFFE);
                            ServerConnectionImpl.this.requestHandleQueueHandlerContainer.push(new RequestHandleRequest(client, key, 1));
                            continue;
                        }
                        if (key.isWritable()) {
                            client = (ClientImpl)key.attachment();
                            key.interestOps(key.interestOps() & 0xFFFFFFFB);
                            if (ServerConnectionImpl.this.requestHandleQueueHandlerContainer == null) {
                                client.writeResponse(key);
                                continue;
                            }
                            ServerConnectionImpl.this.requestHandleQueueHandlerContainer.push(new RequestHandleRequest(client, key, 2));
                            continue;
                        }
                        if (key.isValid()) continue;
                        key.cancel();
                    }
                    catch (CancelledKeyException cancelledKeyException) {}
                }
            } else {
                if (!(paramObj instanceof Socket)) {
                    return;
                }
                Socket socket = (Socket)paramObj;
                if (!socket.isBound() || socket.isClosed()) {
                    return;
                }
                ClientImpl client = new ClientImpl(socket, ServerConnectionImpl.this.sendSocket == null ? (ServerConnectionImpl.this.sendSocketAddress == null ? new DatagramSocket() : new DatagramSocket(ServerConnectionImpl.this.sendSocketAddress)) : null);
                client.setDestPort(ServerConnectionImpl.this.destPort);
                LinkedHashSet<ClientImpl> tmpClients = new LinkedHashSet<ClientImpl>();
                tmpClients.addAll(ServerConnectionImpl.this.clients);
                tmpClients.add(client);
                ServerConnectionImpl.this.clients = tmpClients;
                ServerConnectionImpl.this.newClients.add(client);
                ServerConnectionImpl.this.clientMap.put(client.getId(), client);
            }
        }

        @Override
        public void garbage() {
            if (ServerConnectionImpl.this.selector != null) {
                try {
                    this.consume(ServerConnectionImpl.this.selector.selectedKeys(), null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

