/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.FactoryService;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.queue.AbstractDistributedQueueSelectorServiceMBean;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.DistributedQueueSelector;
import jp.ossc.nimbus.service.queue.Queue;

public abstract class AbstractDistributedQueueSelectorService
extends ServiceBase
implements DistributedQueueSelector,
AbstractDistributedQueueSelectorServiceMBean {
    private static final long serialVersionUID = -7007153954682535513L;
    protected ServiceName[] queueServiceNames;
    protected Queue[] queues;
    protected Map keyMap;
    protected Set[] keySets;
    protected ServiceName queueFactoryServiceName;
    protected int distributedSize = 2;

    @Override
    public void setQueueServiceNames(ServiceName[] names) {
        this.queueServiceNames = names;
    }

    @Override
    public ServiceName[] getQueueServiceNames() {
        return this.queueServiceNames;
    }

    @Override
    public void setQueueFactoryServiceName(ServiceName name) {
        this.queueFactoryServiceName = name;
    }

    @Override
    public ServiceName getQueueFactoryServiceName() {
        return this.queueFactoryServiceName;
    }

    @Override
    public void setDistributedSize(int size) {
        this.distributedSize = size;
    }

    @Override
    public int getDistributedSize() {
        return this.distributedSize;
    }

    @Override
    public void preCreateService() throws Exception {
        super.preCreateService();
        this.keyMap = new HashMap();
    }

    @Override
    public void preStartService() throws Exception {
        int i;
        super.preStartService();
        if (this.queueServiceNames != null && this.queueServiceNames.length != 0) {
            this.queues = new Queue[this.queueServiceNames.length];
            for (i = 0; i < this.queueServiceNames.length; ++i) {
                this.queues[i] = (Queue)ServiceManagerFactory.getServiceObject(this.queueServiceNames[i]);
            }
        } else if (this.distributedSize >= 1) {
            this.queues = new Queue[this.distributedSize];
            for (i = 0; i < this.distributedSize; ++i) {
                if (this.queueFactoryServiceName == null) {
                    DefaultQueueService queueService = new DefaultQueueService();
                    queueService.create();
                    queueService.start();
                    this.queues[i] = queueService;
                    continue;
                }
                this.queues[i] = (Queue)ServiceManagerFactory.getServiceObject(this.queueFactoryServiceName);
            }
        } else {
            throw new IllegalArgumentException("Queues must be specified.");
        }
        this.keySets = new Set[this.queues.length];
        for (i = 0; i < this.queues.length; ++i) {
            this.keySets[i] = new HashSet();
        }
    }

    @Override
    public void postStopService() throws Exception {
        if ((this.queueServiceNames == null || this.queueServiceNames.length == 0) && this.queueFactoryServiceName != null && this.queues != null) {
            FactoryService factory = (FactoryService)((Object)ServiceManagerFactory.getService(this.queueFactoryServiceName));
            for (int i = 0; i < this.queues.length; ++i) {
                factory.release(this.queues[i]);
                this.queues[i].release();
            }
        }
        super.postStopService();
    }

    @Override
    public void postDestroyService() throws Exception {
        this.keyMap = null;
        this.keySets = null;
        super.postDestroyService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue selectQueue(Object obj) {
        Object key = this.getKey(obj);
        Queue queue = null;
        Map map = this.keyMap;
        synchronized (map) {
            queue = (Queue)this.keyMap.get(key);
            if (queue == null) {
                double minOrder = 0.0;
                Set keySet = null;
                int index = 0;
                for (int i = 0; i < this.queues.length; ++i) {
                    double order = this.getQueueOrder(i, key, obj);
                    if (i != 0 && !(minOrder > order)) continue;
                    index = i;
                    minOrder = order;
                    queue = this.queues[i];
                    keySet = this.keySets[i];
                }
                this.onNewKey(index, key, obj);
                this.keyMap.put(key, queue);
            }
        }
        return queue;
    }

    protected void onNewKey(int i, Object key, Object obj) {
        this.keySets[i].add(key);
    }

    protected double getQueueOrder(int i, Object key, Object obj) {
        return ((double)this.keySets[i].size() + 1.0) * (double)this.queues[i].getCount();
    }

    @Override
    public Queue[] getQueues() {
        return this.queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.keyMap != null) {
            Map map = this.keyMap;
            synchronized (map) {
                this.keyMap.clear();
                for (int i = 0; i < this.keySets.length; ++i) {
                    this.keySets[i].clear();
                }
            }
        }
    }

    protected abstract Object getKey(Object var1);
}

