/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.IllegalServiceStateException;
import jp.ossc.nimbus.service.cache.Cache;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.queue.DefaultQueueServiceMBean;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class DefaultQueueService
extends ServiceBase
implements Queue,
CacheRemoveListener,
DefaultQueueServiceMBean,
Serializable {
    private static final long serialVersionUID = 4603365298600666516L;
    protected static final EmptyElement EMPTY = new EmptyElement();
    protected List queueElements;
    protected int initialCapacity = -1;
    protected int capacityIncrement = -1;
    protected ServiceName cacheServiceName;
    protected Cache cache;
    protected long sleepTime = 10000L;
    protected int maxThresholdSize = -1;
    protected SynchronizeMonitor pushMonitor = new WaitSynchronizeMonitor();
    protected SynchronizeMonitor getMonitor = new WaitSynchronizeMonitor();
    protected SynchronizeMonitor peekMonitor = new WaitSynchronizeMonitor();
    protected volatile boolean fourceEndFlg = false;
    protected long count = 0L;
    protected long countDelta = 0L;
    protected long lastPushedTime = 0L;
    protected long lastDepth = 0L;
    protected long maxDepth = 0L;
    protected boolean isSafeGetOrder = true;
    protected Class synchronizeMonitorClass = WaitSynchronizeMonitor.class;

    @Override
    public void setSynchronizeMonitorClass(Class clazz) {
        this.synchronizeMonitorClass = clazz;
    }

    @Override
    public Class getSynchronizeMonitorClass() {
        return this.synchronizeMonitorClass;
    }

    @Override
    public void setInitialCapacity(int initial) {
        this.initialCapacity = initial;
    }

    @Override
    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    @Override
    public void setCapacityIncrement(int increment) {
        this.capacityIncrement = increment;
    }

    @Override
    public int getCapacityIncrement() {
        return this.capacityIncrement;
    }

    @Override
    public void setCacheServiceName(ServiceName name) {
        this.cacheServiceName = name;
    }

    @Override
    public ServiceName getCacheServiceName() {
        return this.cacheServiceName;
    }

    @Override
    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    @Override
    public long getSleepTime() {
        return this.sleepTime;
    }

    @Override
    public void setMaxThresholdSize(int size) {
        this.maxThresholdSize = size;
    }

    @Override
    public int getMaxThresholdSize() {
        return this.maxThresholdSize;
    }

    @Override
    public boolean isSafeGetOrder() {
        return this.isSafeGetOrder;
    }

    @Override
    public void setSafeGetOrder(boolean isSafe) {
        this.isSafeGetOrder = isSafe;
    }

    @Override
    public void startService() throws Exception {
        if (!WaitSynchronizeMonitor.class.equals((Object)this.synchronizeMonitorClass)) {
            this.pushMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
            this.getMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
            this.peekMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
        }
        if (this.queueElements == null) {
            this.queueElements = this.initialCapacity >= 0 ? (this.capacityIncrement >= 0 ? new Vector(this.initialCapacity, this.capacityIncrement) : Collections.synchronizedList(new ArrayList(this.initialCapacity))) : Collections.synchronizedList(new ArrayList());
        }
        if (this.cacheServiceName != null) {
            this.cache = (Cache)ServiceManagerFactory.getServiceObject(this.cacheServiceName);
            if (this.cache.size() != 0) {
                CachedReference[] refs = this.cache.toArray();
                for (int i = 0; i < refs.length; ++i) {
                    refs[i].addCacheRemoveListener(this);
                    this.queueElements.add(refs[i]);
                }
            }
        }
        this.accept();
    }

    @Override
    public void stopService() throws Exception {
        this.release();
    }

    @Override
    public void destroyService() throws Exception {
        this.queueElements = null;
        this.cache = null;
    }

    @Override
    public void push(Object item) {
        this.push(item, -1L);
    }

    @Override
    public boolean push(Object item, long timeout) {
        return this.pushElement(item, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pushElement(Object element, long timeout) {
        if (this.getState() != 3 || this.fourceEndFlg) {
            throw new IllegalServiceStateException(this);
        }
        if (this.maxThresholdSize > 0 && (this.pushMonitor.isWait() || this.size() >= this.maxThresholdSize) && !this.fourceEndFlg) {
            try {
                if (timeout == 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (timeout < 0L) {
                    this.pushMonitor.initAndWaitMonitor();
                } else if (!this.pushMonitor.initAndWaitMonitor(timeout)) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.pushMonitor.releaseMonitor();
            }
        }
        if (this.cache == null) {
            this.queueElements.add(element);
        } else {
            CachedReference ref = this.cache.add(element);
            if (ref != null) {
                ref.addCacheRemoveListener(this);
                this.queueElements.add(ref);
            } else {
                this.queueElements.add(element);
            }
        }
        int size = this.size();
        if ((long)size > this.maxDepth) {
            this.maxDepth = size;
        }
        ++this.count;
        ++this.countDelta;
        this.lastPushedTime = System.currentTimeMillis();
        this.peekMonitor.notifyAllMonitor();
        if (this.isSafeGetOrder) {
            this.getMonitor.notifyMonitor();
        } else {
            this.getMonitor.notifyAllMonitor();
        }
        if (this.pushMonitor.isWait() && this.size() < this.maxThresholdSize) {
            this.pushMonitor.notifyMonitor();
        }
        return true;
    }

    @Override
    public Object get(long timeOutMs) {
        return this.getQueueElement(timeOutMs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getQueueElement(long timeOutMs, boolean isRemove) {
        long processTime = 0L;
        try {
            Object ret;
            if (isRemove) {
                this.getMonitor.initMonitor();
            } else {
                this.peekMonitor.initMonitor();
            }
            while (!this.fourceEndFlg) {
                if (this.size() > 0) {
                    if (!isRemove || !this.isSafeGetOrder || this.getMonitor.isFirst()) {
                        ret = this.getQueueElement(isRemove);
                        if (ret == EMPTY) continue;
                        if (isRemove) {
                            this.getMonitor.releaseMonitor();
                        }
                        if (isRemove && this.size() > 0 && this.getMonitor.isWait()) {
                            if (this.isSafeGetOrder) {
                                this.getMonitor.notifyMonitor();
                            } else {
                                this.getMonitor.notifyAllMonitor();
                            }
                        }
                        if (isRemove && this.pushMonitor.isWait() && this.size() < this.maxThresholdSize) {
                            this.pushMonitor.notifyMonitor();
                        }
                        Object object = ret;
                        return object;
                    }
                    if (this.getMonitor.isWait()) {
                        this.getMonitor.notifyMonitor();
                    }
                }
                if (this.fourceEndFlg || timeOutMs == 0L || timeOutMs > 0L && timeOutMs <= processTime) break;
                long proc = 0L;
                if (timeOutMs >= 0L) {
                    proc = System.currentTimeMillis();
                }
                try {
                    long curSleepTime;
                    long l = curSleepTime = timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime;
                    if (curSleepTime > 0L && (this.size() == 0 || !isRemove || this.isSafeGetOrder && !this.getMonitor.isFirst())) {
                        if (isRemove) {
                            this.getMonitor.initAndWaitMonitor(curSleepTime);
                        } else {
                            this.peekMonitor.initAndWaitMonitor(curSleepTime);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Object var9_11 = null;
                    if (isRemove) {
                        this.getMonitor.releaseMonitor();
                    } else {
                        this.peekMonitor.releaseMonitor();
                    }
                    return var9_11;
                }
                if (timeOutMs < 0L) continue;
                proc = System.currentTimeMillis() - proc;
                processTime += proc;
            }
            if (this.fourceEndFlg) {
                ret = this.getQueueElement(isRemove);
                if (ret == EMPTY) {
                    Object var7_9 = null;
                    return var7_9;
                }
                Object object = ret;
                return object;
            }
            if (isRemove && this.size() > 0 && this.getMonitor.isWait()) {
                if (this.isSafeGetOrder) {
                    this.getMonitor.notifyMonitor();
                } else {
                    this.getMonitor.notifyAllMonitor();
                }
            }
            Object var6_4 = null;
            return var6_4;
        }
        finally {
            if (isRemove) {
                this.getMonitor.releaseMonitor();
            } else {
                this.peekMonitor.releaseMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getQueueElement(boolean isRemove) {
        if (this.queueElements == null) {
            return null;
        }
        List list = this.queueElements;
        synchronized (list) {
            if (this.queueElements == null) {
                return null;
            }
            if (this.size() == 0) {
                return EMPTY;
            }
            Object element = null;
            element = isRemove ? this.queueElements.remove(0) : this.queueElements.get(0);
            if (element == null) {
                return null;
            }
            if (this.cache == null) {
                return element;
            }
            if (element instanceof CachedReference) {
                CachedReference ref = element;
                Object obj = ref.get();
                if (isRemove) {
                    this.cache.remove(ref);
                }
                return obj;
            }
            return element;
        }
    }

    @Override
    public Object get() {
        return this.get(-1L);
    }

    @Override
    public Object peek(long timeOutMs) {
        return this.getQueueElement(timeOutMs, false);
    }

    @Override
    public Object peek() {
        return this.peek(-1L);
    }

    @Override
    public Object remove(Object item) {
        Object removed;
        block3: {
            block2: {
                removed = null;
                if (this.cache != null) break block2;
                if (!this.queueElements.remove(item)) break block3;
                removed = item;
                break block3;
            }
            Object[] elements = this.queueElements.toArray();
            for (int i = 0; i < elements.length; ++i) {
                Object element = elements[i];
                if (element instanceof CachedReference) {
                    CachedReference ref = (CachedReference)element;
                    Object obj = ref.get(this, false);
                    if ((item != null || obj != null) && (item == null || !item.equals(obj))) continue;
                    this.cache.remove(ref);
                    removed = obj;
                    break;
                }
                if ((item != null || element != null) && (item == null || !item.equals(element))) continue;
                if (!this.queueElements.remove(element)) break;
                removed = element;
                break;
            }
        }
        return removed;
    }

    @Override
    public void clear() {
        if (this.cache == null) {
            this.queueElements.clear();
        } else {
            Object[] elements = this.queueElements.toArray();
            for (int i = 0; i < elements.length; ++i) {
                Object element = elements[i];
                if (!(element instanceof CachedReference)) continue;
                CachedReference ref = (CachedReference)element;
                this.cache.remove(ref);
            }
            this.queueElements.clear();
        }
    }

    @Override
    public int size() {
        if (this.queueElements == null) {
            return 0;
        }
        return this.queueElements.size();
    }

    @Override
    public void accept() {
        this.fourceEndFlg = false;
    }

    @Override
    public void release() {
        this.fourceEndFlg = true;
        while (this.getMonitor.isWait()) {
            this.getMonitor.notifyMonitor();
            Thread.yield();
        }
        this.peekMonitor.notifyAllMonitor();
        Thread.yield();
        while (this.pushMonitor.isWait()) {
            this.pushMonitor.notifyMonitor();
            Thread.yield();
        }
    }

    @Override
    public int getWaitCount() {
        return this.getMonitor.getWaitCount();
    }

    @Override
    public List elements() {
        if (this.queueElements == null) {
            return new ArrayList();
        }
        return new ArrayList(this.queueElements);
    }

    @Override
    public void removed(CachedReference ref) {
        if (this.queueElements == null) {
            return;
        }
        this.queueElements.remove(ref);
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public long getCountDelta() {
        long delta = this.countDelta;
        this.countDelta = 0L;
        return delta;
    }

    @Override
    public long getLastPushedTimeMillis() {
        return this.lastPushedTime;
    }

    @Override
    public Date getLastPushedTime() {
        return new Date(this.lastPushedTime);
    }

    @Override
    public long getDepth() {
        return this.size();
    }

    @Override
    public long getDepthDelta() {
        long depth = this.size();
        long delta = depth - this.lastDepth;
        this.lastDepth = depth;
        return delta;
    }

    @Override
    public long getMaxDepth() {
        return this.maxDepth;
    }

    protected static class EmptyElement {
        protected EmptyElement() {
        }
    }
}

