/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConcentrateResponse
implements Serializable {
    private static final long serialVersionUID = 7100038841123910324L;
    private String group;
    private Date date;
    private String key;
    private List files;
    private Map compressed;
    private Map keyMap;
    private Map dateMap;
    private boolean isClean = true;
    private String rootDirectory;
    private Object output;

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public File[] getFiles() {
        return this.files == null ? null : this.files.toArray(new File[this.files.size()]);
    }

    public Date getDate(File file) {
        if (this.dateMap == null) {
            return this.getDate();
        }
        Date date = (Date)this.dateMap.get(file);
        return date == null ? this.getDate() : date;
    }

    public String getKey(File file) {
        if (this.keyMap == null) {
            return this.getKey();
        }
        String key = (String)this.keyMap.get(file);
        return key == null ? this.getKey() : key;
    }

    public boolean getFileCompressed(File file) {
        if (this.compressed == null) {
            return false;
        }
        Boolean flg = (Boolean)this.compressed.get(file);
        return flg == null ? false : flg;
    }

    public void addFile(File file) {
        this.addFile(file, false);
    }

    public void addFiles(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.addFile(files[i]);
        }
    }

    public void addFile(File file, boolean isCompressed) {
        this.addFile(file, null, null, isCompressed);
    }

    public void addFiles(File[] files, boolean[] isCompressed) {
        for (int i = 0; i < files.length; ++i) {
            this.addFile(files[i], isCompressed[i]);
        }
    }

    public void addFile(File file, Date date, String key) {
        this.addFile(file, date, key, false);
    }

    public void addFile(File file, Date date, String key, boolean isCompressed) {
        if (this.files == null) {
            this.files = new ArrayList();
            this.keyMap = new HashMap();
            this.dateMap = new HashMap();
            this.compressed = new HashMap();
        }
        this.files.add(file);
        this.keyMap.put(file, key);
        this.dateMap.put(file, date);
        this.compressed.put(file, isCompressed ? Boolean.TRUE : Boolean.FALSE);
    }

    public void addFiles(File[] files, Date[] dates, String[] keys) {
        for (int i = 0; i < files.length; ++i) {
            this.addFile(files[i], dates[i], keys[i]);
        }
    }

    public void addFiles(File[] files, Date[] dates, String[] keys, boolean[] isCompressed) {
        for (int i = 0; i < files.length; ++i) {
            this.addFile(files[i], dates[i], keys[i], isCompressed[i]);
        }
    }

    public void setRootDirectory(String path) {
        this.rootDirectory = path;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void setClean(boolean isClean) {
        this.isClean = isClean;
    }

    public boolean isClean() {
        return this.isClean;
    }

    public Object getOutput() {
        return this.output;
    }

    public void setOutput(Object out) {
        this.output = out;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append("{group=").append(this.group);
        buf.append(",date=").append(this.date);
        buf.append(",key=").append(this.key);
        buf.append(",files=");
        if (this.files == null || this.files.size() == 0) {
            buf.append("null");
        } else {
            buf.append('[');
            int imax = this.files.size();
            for (int i = 0; i < imax; ++i) {
                File file = (File)this.files.get(i);
                buf.append("{file=" + file);
                buf.append(",date=" + this.dateMap.get(file));
                buf.append(",key=" + this.keyMap.get(file));
                buf.append(",compressed=" + this.compressed.get(file)).append('}');
                if (i == imax - 1) continue;
                buf.append(',');
            }
            buf.append(']');
        }
        buf.append(",isClean=").append(this.isClean);
        buf.append(",rootDirectory=").append(this.rootDirectory);
        buf.append(",output=").append(this.output).append('}');
        return buf.toString();
    }
}

