/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.scheduler2.DatabaseScheduleManagerServiceMBean;
import jp.ossc.nimbus.service.scheduler2.DefaultSchedule;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleDepends;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMakerService;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMaster;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleControlListener;
import jp.ossc.nimbus.service.scheduler2.ScheduleDepends;
import jp.ossc.nimbus.service.scheduler2.ScheduleMakeException;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaker;
import jp.ossc.nimbus.service.scheduler2.ScheduleManageException;
import jp.ossc.nimbus.service.scheduler2.ScheduleManager;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaster;
import jp.ossc.nimbus.service.scheduler2.ScheduleStateControlException;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.system.Time;
import jp.ossc.nimbus.util.converter.BeanJSONConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StringStreamConverter;

public class DatabaseScheduleManagerService
extends ServiceBase
implements ScheduleManager,
DatabaseScheduleManagerServiceMBean {
    private static final long serialVersionUID = -768179222440496616L;
    protected Properties scheduleMakerTypeMapping;
    protected Map addedScheduleMakerMap;
    protected Map scheduleMakerMap;
    protected boolean isScheduleMakerTypeRegexEnabled;
    protected ServiceName defaultScheduleMakerServiceName;
    protected ScheduleMaker defaultScheduleMaker;
    protected ServiceName connectionFactoryServiceName;
    protected ConnectionFactory connectionFactory;
    protected ServiceName timeServiceName;
    protected Time time;
    protected ScheduleMasterTableSchema scheduleMasterTableSchema = new ScheduleMasterTableSchema();
    protected ScheduleGroupMasterTableSchema scheduleGroupMasterTableSchema = new ScheduleGroupMasterTableSchema();
    protected ScheduleDependsMasterTableSchema scheduleDependsMasterTableSchema = new ScheduleDependsMasterTableSchema();
    protected ScheduleGroupDependsMasterTableSchema scheduleGroupDependsMasterTableSchema = new ScheduleGroupDependsMasterTableSchema();
    protected ScheduleTableSchema scheduleTableSchema = new ScheduleTableSchema();
    protected ScheduleGroupTableSchema scheduleGroupTableSchema = new ScheduleGroupTableSchema();
    protected ScheduleDependsTableSchema scheduleDependsTableSchema = new ScheduleDependsTableSchema();
    protected ScheduleGroupDependsTableSchema scheduleGroupDependsTableSchema = new ScheduleGroupDependsTableSchema();
    protected String nextScheduleIdSelectQuery;
    protected String dateFormat = "yyyyMMdd";
    protected String timeFormat = "HHmmssSSS";
    protected String updateUserId;
    protected Set scheduleControlListeners;
    protected boolean isMakeScheduleOnStart = true;
    protected long controlStateCheckInterval = 1000L;
    protected Daemon controlStateChecker;
    protected long timeoverCheckInterval = 1000L;
    protected Daemon timeoverChecker;
    protected boolean isLockForFindExecutable;
    protected ServiceName clusterServiceName;
    protected ClusterService cluster;
    protected ClusterListener clusterListener;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected boolean isUseConcatFunction;
    protected boolean isJsonInput;

    @Override
    public void setDefaultScheduleMakerServiceName(ServiceName name) {
        this.defaultScheduleMakerServiceName = name;
    }

    @Override
    public ServiceName getDefaultScheduleMakerServiceName() {
        return this.defaultScheduleMakerServiceName;
    }

    @Override
    public void setScheduleMakerTypeMapping(Properties mapping) {
        this.scheduleMakerTypeMapping = mapping;
    }

    @Override
    public Properties getScheduleMakerTypeMapping() {
        return this.scheduleMakerTypeMapping;
    }

    @Override
    public void setScheduleMakerTypeRegexEnabled(boolean isEnable) {
        this.isScheduleMakerTypeRegexEnabled = isEnable;
    }

    @Override
    public boolean isScheduleMakerTypeRegexEnabled() {
        return this.isScheduleMakerTypeRegexEnabled;
    }

    @Override
    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    @Override
    public void setTimeServiceName(ServiceName name) {
        this.timeServiceName = name;
    }

    @Override
    public ServiceName getTimeServiceName() {
        return this.timeServiceName;
    }

    @Override
    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setTimeFormat(String format) {
        this.timeFormat = format;
    }

    @Override
    public String getTimeFormat() {
        return this.timeFormat;
    }

    @Override
    public void setUpdateUserId(String id) {
        this.updateUserId = id;
    }

    @Override
    public String getUpdateUserId() {
        return this.updateUserId;
    }

    @Override
    public ScheduleMasterTableSchema getScheduleMasterTableSchema() {
        return this.scheduleMasterTableSchema;
    }

    @Override
    public void setScheduleMasterTableSchema(ScheduleMasterTableSchema schema) {
        this.scheduleMasterTableSchema = schema;
    }

    @Override
    public ScheduleGroupMasterTableSchema getScheduleGroupMasterTableSchema() {
        return this.scheduleGroupMasterTableSchema;
    }

    @Override
    public void setScheduleGroupMasterTableSchema(ScheduleGroupMasterTableSchema schema) {
        this.scheduleGroupMasterTableSchema = schema;
    }

    @Override
    public ScheduleDependsMasterTableSchema getScheduleDependsMasterTableSchema() {
        return this.scheduleDependsMasterTableSchema;
    }

    @Override
    public void setScheduleDependsMasterTableSchema(ScheduleDependsMasterTableSchema schema) {
        this.scheduleDependsMasterTableSchema = schema;
    }

    @Override
    public ScheduleGroupDependsMasterTableSchema getScheduleGroupDependsMasterTableSchema() {
        return this.scheduleGroupDependsMasterTableSchema;
    }

    @Override
    public void setScheduleGroupDependsMasterTableSchema(ScheduleGroupDependsMasterTableSchema schema) {
        this.scheduleGroupDependsMasterTableSchema = schema;
    }

    @Override
    public ScheduleTableSchema getScheduleTableSchema() {
        return this.scheduleTableSchema;
    }

    @Override
    public void setScheduleTableSchema(ScheduleTableSchema schema) {
        this.scheduleTableSchema = schema;
    }

    @Override
    public ScheduleGroupTableSchema getScheduleGroupTableSchema() {
        return this.scheduleGroupTableSchema;
    }

    @Override
    public void setScheduleGroupTableSchema(ScheduleGroupTableSchema schema) {
        this.scheduleGroupTableSchema = schema;
    }

    @Override
    public ScheduleDependsTableSchema getScheduleDependsTableSchema() {
        return this.scheduleDependsTableSchema;
    }

    @Override
    public void setScheduleDependsTableSchema(ScheduleDependsTableSchema schema) {
        this.scheduleDependsTableSchema = schema;
    }

    @Override
    public ScheduleGroupDependsTableSchema getScheduleGroupDependsTableSchema() {
        return this.scheduleGroupDependsTableSchema;
    }

    @Override
    public void setScheduleGroupDependsTableSchema(ScheduleGroupDependsTableSchema schema) {
        this.scheduleGroupDependsTableSchema = schema;
    }

    @Override
    public void setNextScheduleIdSelectQuery(String query) {
        this.nextScheduleIdSelectQuery = query;
    }

    @Override
    public String getNextScheduleIdSelectQuery() {
        return this.nextScheduleIdSelectQuery;
    }

    @Override
    public void setMakeScheduleOnStart(boolean isMake) {
        this.isMakeScheduleOnStart = isMake;
    }

    @Override
    public boolean isMakeScheduleOnStart() {
        return this.isMakeScheduleOnStart;
    }

    @Override
    public void setControlStateCheckInterval(long interval) {
        this.controlStateCheckInterval = interval;
    }

    @Override
    public long getControlStateCheckInterval() {
        return this.controlStateCheckInterval;
    }

    @Override
    public void setTimeoverCheckInterval(long interval) {
        this.timeoverCheckInterval = interval;
    }

    @Override
    public long getTimeoverCheckInterval() {
        return this.timeoverCheckInterval;
    }

    @Override
    public void setLockForFindExecutable(boolean isLock) {
        this.isLockForFindExecutable = isLock;
    }

    @Override
    public boolean isLockForFindExecutable() {
        return this.isLockForFindExecutable;
    }

    @Override
    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    @Override
    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void setUseConcatFunction(boolean isUse) {
        this.isUseConcatFunction = isUse;
    }

    @Override
    public boolean isUseConcatFunction() {
        return this.isUseConcatFunction;
    }

    @Override
    public void setJSONInput(boolean isJson) {
        this.isJsonInput = isJson;
    }

    @Override
    public boolean isJSONInput() {
        return this.isJsonInput;
    }

    @Override
    public void startControlStateCheck() {
        if (this.controlStateChecker != null) {
            this.controlStateChecker.resume();
        }
    }

    @Override
    public boolean isStartControlStateCheck() {
        return this.controlStateChecker == null ? false : this.controlStateChecker.isRunning() && !this.controlStateChecker.isSusupend();
    }

    @Override
    public void stopControlStateCheck() {
        if (this.controlStateChecker != null) {
            this.controlStateChecker.suspend();
        }
    }

    @Override
    public void startTimeoverCheck() {
        if (this.timeoverChecker != null) {
            this.timeoverChecker.resume();
        }
    }

    @Override
    public boolean isStartTimeoverCheck() {
        return this.timeoverChecker == null ? false : this.timeoverChecker.isRunning() && !this.timeoverChecker.isSusupend();
    }

    @Override
    public void stopTimeoverCheck() {
        if (this.timeoverChecker != null) {
            this.timeoverChecker.suspend();
        }
    }

    @Override
    public void createService() throws Exception {
        this.scheduleMakerMap = new HashMap();
        this.addedScheduleMakerMap = null;
        this.scheduleControlListeners = Collections.synchronizedSet(new LinkedHashSet());
    }

    @Override
    public void startService() throws Exception {
        Date now;
        List oldScheduleList;
        if (this.scheduleMakerTypeMapping != null && this.scheduleMakerTypeMapping.size() != 0) {
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(this.getServiceManagerName());
            for (Map.Entry<Object, Object> entry : this.scheduleMakerTypeMapping.entrySet()) {
                editor.setAsText((String)entry.getValue());
                ServiceName scheduleMakerServiceName = (ServiceName)editor.getValue();
                ScheduleMaker scheduleMaker = (ScheduleMaker)ServiceManagerFactory.getServiceObject(scheduleMakerServiceName);
                if (this.scheduleMakerMap.containsKey(entry.getKey())) {
                    throw new IllegalArgumentException("Dupulicate scheduleMakerTypeMapping : " + entry.getKey());
                }
                this.scheduleMakerMap.put(entry.getKey(), scheduleMaker);
            }
        }
        if (this.defaultScheduleMakerServiceName != null) {
            this.defaultScheduleMaker = (ScheduleMaker)ServiceManagerFactory.getServiceObject(this.defaultScheduleMakerServiceName);
        }
        if (this.defaultScheduleMaker == null) {
            DefaultScheduleMakerService defaultScheduleMakerService = new DefaultScheduleMakerService();
            defaultScheduleMakerService.create();
            defaultScheduleMakerService.start();
            this.defaultScheduleMaker = defaultScheduleMakerService;
        }
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        if (this.timeServiceName != null) {
            this.time = (Time)ServiceManagerFactory.getServiceObject(this.timeServiceName);
        }
        if (this.updateUserId == null) {
            this.updateUserId = InetAddress.getLocalHost().getHostName();
        }
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
        format.applyPattern(this.timeFormat);
        if (this.isMakeScheduleOnStart && ((oldScheduleList = this.findSchedules(now = this.time == null ? new Date() : new Date(this.time.currentTimeMillis()))) == null || oldScheduleList.size() == 0)) {
            this.makeSchedule(now);
        }
        if (this.controlStateCheckInterval > 0L && this.scheduleControlListeners != null && this.scheduleControlListeners.size() != 0) {
            this.controlStateChecker = new Daemon(new ControlStateChecker());
            this.controlStateChecker.setName("Nimbus SchedulerManagerControlStateChecker " + this.getServiceNameObject());
            this.controlStateChecker.suspend();
            this.controlStateChecker.start();
        }
        if (this.timeoverCheckInterval > 0L) {
            this.timeoverChecker = new Daemon(new TimeoverChecker());
            this.timeoverChecker.setName("Nimbus SchedulerManagerTimeoverChecker " + this.getServiceNameObject());
            this.timeoverChecker.suspend();
            this.timeoverChecker.start();
        }
        if (this.clusterServiceName != null && (this.controlStateChecker != null || this.timeoverChecker != null)) {
            this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
            this.clusterListener = new ClusterListener();
            this.cluster.addClusterListener(this.clusterListener);
        } else {
            if (this.controlStateChecker != null) {
                this.controlStateChecker.resume();
            }
            if (this.timeoverChecker != null) {
                this.timeoverChecker.resume();
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.controlStateChecker != null) {
            this.controlStateChecker.stop();
            this.controlStateChecker = null;
        }
        if (this.timeoverChecker != null) {
            this.timeoverChecker.stop();
            this.timeoverChecker = null;
        }
        if (this.cluster != null) {
            this.cluster.removeClusterListener(this.clusterListener);
            this.clusterListener = null;
            this.cluster = null;
        }
        if (this.scheduleMakerMap != null) {
            this.scheduleMakerMap.clear();
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.scheduleMakerMap = null;
        this.addedScheduleMakerMap = null;
        this.scheduleControlListeners = null;
    }

    @Override
    public List makeSchedule(Date date) throws ScheduleMakeException {
        ArrayList<DefaultScheduleMaster> masters = new ArrayList<DefaultScheduleMaster>();
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleMakeException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.createStatement();
            rs = st.executeQuery("select * from " + this.scheduleMasterTableSchema.table + " where " + this.scheduleMasterTableSchema.template + "<>'1' and " + this.scheduleMasterTableSchema.enable + "='1'");
            while (rs.next()) {
                DefaultScheduleMaster scheduleMaster = this.createScheduleMaster(rs);
                masters.add(scheduleMaster);
            }
            rs.close();
            rs = null;
            this.setDependsOnScheduleMasters(con, masters);
            this.setGroupIdsOnScheduleMasters(con, masters);
            this.setGroupDependsOnGroupOnScheduleMasters(con, masters);
        }
        catch (ScheduleManageException e) {
            throw new ScheduleMakeException(e);
        }
        catch (ParseException e) {
            throw new ScheduleMakeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleMakeException(e);
        }
        catch (IOException e) {
            throw new ScheduleMakeException(e);
        }
        catch (SQLException e) {
            throw new ScheduleMakeException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return this.makeSchedule(date, masters);
    }

    @Override
    public List makeSchedule(Date date, ScheduleMaster master) throws ScheduleMakeException {
        if (master == null) {
            return new ArrayList();
        }
        ArrayList<ScheduleMaster> masters = new ArrayList<ScheduleMaster>();
        masters.add(master);
        return this.makeSchedule(date, masters);
    }

    @Override
    public List makeSchedule(Date date, List masters) throws ScheduleMakeException {
        if (masters.size() == 0) {
            return new ArrayList();
        }
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleMakeException(e);
        }
        Statement st = null;
        Statement ps1 = null;
        Statement ps2 = null;
        Statement ps3 = null;
        Statement ps4 = null;
        Statement ps5 = null;
        try {
            st = con.createStatement();
            ps1 = con.prepareStatement("insert into " + this.scheduleTableSchema.table + " (" + this.scheduleTableSchema.id + ',' + this.scheduleTableSchema.masterId + ',' + this.scheduleTableSchema.date + ',' + this.scheduleTableSchema.time + ',' + this.scheduleTableSchema.taskName + ',' + this.scheduleTableSchema.input + ',' + this.scheduleTableSchema.output + ',' + this.scheduleTableSchema.initialDate + ',' + this.scheduleTableSchema.initialTime + ',' + this.scheduleTableSchema.retryInterval + ',' + this.scheduleTableSchema.retryEndTime + ',' + this.scheduleTableSchema.maxDelayTime + ',' + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.checkState + ',' + this.scheduleTableSchema.executorKey + ',' + this.scheduleTableSchema.executorType + ',' + this.scheduleTableSchema.executeStartTime + ',' + this.scheduleTableSchema.executeEndTime + ',' + this.scheduleTableSchema.rowVersion + ',' + this.scheduleTableSchema.updateUserId + ',' + this.scheduleTableSchema.updateTime + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'0','" + this.updateUserId + "',?)");
            ps2 = con.prepareStatement("insert into " + this.scheduleDependsTableSchema.table + " (" + this.scheduleDependsTableSchema.id + ',' + this.scheduleDependsTableSchema.dependsId + ',' + this.scheduleDependsTableSchema.dependsGroupId + ',' + this.scheduleDependsTableSchema.groupId + ',' + this.scheduleDependsTableSchema.ignoreError + ',' + this.scheduleDependsTableSchema.rowVersion + ',' + this.scheduleDependsTableSchema.updateUserId + ',' + this.scheduleDependsTableSchema.updateTime + ") values(?,?,?,?,?,'0','" + this.updateUserId + "',?)");
            ps3 = con.prepareStatement("select " + this.scheduleGroupDependsMasterTableSchema.dependsGroupId + ',' + this.scheduleGroupDependsMasterTableSchema.ignoreError + " from " + this.scheduleGroupDependsMasterTableSchema.table + " where " + this.scheduleGroupDependsMasterTableSchema.groupId + "=?");
            ps4 = con.prepareStatement("insert into " + this.scheduleGroupDependsTableSchema.table + " (" + this.scheduleGroupDependsTableSchema.groupId + ',' + this.scheduleGroupDependsTableSchema.dependsGroupId + ',' + this.scheduleGroupDependsTableSchema.ignoreError + ',' + this.scheduleGroupDependsTableSchema.rowVersion + ',' + this.scheduleGroupDependsTableSchema.updateUserId + ',' + this.scheduleGroupDependsTableSchema.updateTime + ") values(?,?,?,'0','" + this.updateUserId + "',?)");
            ps5 = con.prepareStatement("insert into " + this.scheduleGroupTableSchema.table + " (" + this.scheduleGroupTableSchema.id + ',' + this.scheduleGroupTableSchema.groupId + ',' + this.scheduleGroupTableSchema.masterGroupId + ',' + this.scheduleGroupTableSchema.rowVersion + ',' + this.scheduleGroupTableSchema.updateUserId + ',' + this.scheduleGroupTableSchema.updateTime + ") values(?,?,?,'0','" + this.updateUserId + "',?)");
            ArrayList<Schedule> result = new ArrayList<Schedule>();
            HashMap groupMap = new HashMap();
            for (int i = 0; i < masters.size(); ++i) {
                ScheduleMaster scheduleMaster = (ScheduleMaster)masters.get(i);
                ScheduleMaker maker = this.getScheduleMaker(scheduleMaster.getScheduleType());
                Schedule[] schedules = maker.makeSchedule(date, scheduleMaster);
                if (schedules == null || schedules.length == 0) continue;
                for (int j = 0; j < schedules.length; ++j) {
                    this.addSchedule(st, (PreparedStatement)ps1, (PreparedStatement)ps2, (PreparedStatement)ps3, (PreparedStatement)ps4, (PreparedStatement)ps5, schedules[j], groupMap);
                    result.add(schedules[j]);
                }
            }
            ArrayList<Schedule> arrayList = result;
            return arrayList;
        }
        catch (ScheduleManageException e) {
            throw new ScheduleMakeException(e);
        }
        catch (SQLException e) {
            throw new ScheduleMakeException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps1 != null) {
                try {
                    ps1.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps2 != null) {
                try {
                    ps2.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps3 != null) {
                try {
                    ps3.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps4 != null) {
                try {
                    ps4.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps5 != null) {
                try {
                    ps5.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected void addSchedule(Statement nextScheduleIdStatement, PreparedStatement scheduleInsertStatement, PreparedStatement scheduleDependsInsertStatement, PreparedStatement scheduleGroupDependsMasterSelectStatement, PreparedStatement scheduleGroupDependsInsertStatement, PreparedStatement scheduleGroupInsertStatement, Schedule schedule, Map groupMap) throws ScheduleManageException {
        ResultSet rs = null;
        try {
            Map dependsInGroupMap;
            String[] masterGroupIds;
            ScheduleDepends[] dependsOnGroup;
            Date initialTime;
            if (this.nextScheduleIdSelectQuery != null) {
                rs = nextScheduleIdStatement.executeQuery(this.nextScheduleIdSelectQuery);
                rs.next();
                schedule.setId(rs.getObject(1).toString());
                rs.close();
                rs = null;
            } else if (this.sequence != null) {
                schedule.setId(this.sequence.increment());
            }
            int index = 0;
            scheduleInsertStatement.setString(++index, schedule.getId());
            scheduleInsertStatement.setString(++index, schedule.getMasterId());
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
            if (schedule.getTime() == null) {
                scheduleInsertStatement.setNull(++index, 1);
            } else {
                scheduleInsertStatement.setString(++index, format.format(schedule.getTime()));
            }
            format.applyPattern(this.timeFormat);
            if (schedule.getTime() == null) {
                scheduleInsertStatement.setNull(++index, 1);
            } else {
                scheduleInsertStatement.setString(++index, format.format(schedule.getTime()));
            }
            scheduleInsertStatement.setString(++index, schedule.getTaskName());
            if (schedule.getInput() == null) {
                scheduleInsertStatement.setNull(++index, 12);
            } else {
                Object input = schedule.getInput();
                if (this.isJsonInput && !(input instanceof String)) {
                    BeanJSONConverter jsonConverter = new BeanJSONConverter();
                    jsonConverter.setUnicodeEscape(false);
                    StringStreamConverter streamConverter = new StringStreamConverter();
                    input = streamConverter.convertToObject(jsonConverter.convertToStream(input));
                }
                this.scheduleTableSchema.setInputObject(++index, scheduleInsertStatement, input);
            }
            if (schedule.getOutput() == null) {
                scheduleInsertStatement.setNull(++index, 12);
            } else {
                this.scheduleTableSchema.setOutputObject(++index, scheduleInsertStatement, schedule.getOutput());
            }
            format.applyPattern(this.dateFormat);
            Date date = initialTime = schedule.getInitialTime() == null ? schedule.getTime() : schedule.getInitialTime();
            if (initialTime == null) {
                scheduleInsertStatement.setNull(++index, 1);
            } else {
                scheduleInsertStatement.setString(++index, format.format(initialTime));
            }
            format.applyPattern(this.timeFormat);
            if (initialTime == null) {
                scheduleInsertStatement.setNull(++index, 1);
            } else {
                scheduleInsertStatement.setString(++index, format.format(initialTime));
            }
            if (schedule.getRetryInterval() > 0L) {
                scheduleInsertStatement.setLong(++index, schedule.getRetryInterval());
            } else {
                scheduleInsertStatement.setNull(++index, 3);
            }
            format.applyPattern(this.dateFormat + this.timeFormat);
            if (schedule.getRetryEndTime() == null) {
                scheduleInsertStatement.setNull(++index, 1);
            } else {
                scheduleInsertStatement.setString(++index, format.format(schedule.getRetryEndTime()));
            }
            if (schedule.getMaxDelayTime() > 0L) {
                scheduleInsertStatement.setLong(++index, schedule.getMaxDelayTime());
            } else {
                scheduleInsertStatement.setNull(++index, 3);
            }
            scheduleInsertStatement.setString(++index, this.scheduleTableSchema.getStateString(schedule.getState()));
            scheduleInsertStatement.setString(++index, this.scheduleTableSchema.getControlStateString(schedule.getControlState()));
            scheduleInsertStatement.setString(++index, this.scheduleTableSchema.getCheckStateString(schedule.getCheckState()));
            if (schedule.getExecutorKey() == null) {
                scheduleInsertStatement.setNull(++index, 12);
            } else {
                scheduleInsertStatement.setString(++index, schedule.getExecutorKey());
            }
            if (schedule.getExecutorType() == null) {
                scheduleInsertStatement.setNull(++index, 12);
            } else {
                scheduleInsertStatement.setString(++index, schedule.getExecutorType());
            }
            if (schedule.getExecuteStartTime() == null) {
                scheduleInsertStatement.setNull(++index, 1);
            } else {
                scheduleInsertStatement.setString(++index, format.format(schedule.getExecuteStartTime()));
            }
            if (schedule.getExecuteEndTime() == null) {
                scheduleInsertStatement.setNull(++index, 1);
            } else {
                scheduleInsertStatement.setString(++index, format.format(schedule.getExecuteEndTime()));
            }
            Timestamp now = new Timestamp(this.time == null ? System.currentTimeMillis() : this.time.currentTimeMillis());
            scheduleInsertStatement.setTimestamp(++index, now);
            scheduleInsertStatement.executeUpdate();
            ScheduleDepends[] depends = schedule.getDepends();
            if (depends != null && depends.length != 0) {
                for (int i = 0; i < depends.length; ++i) {
                    scheduleDependsInsertStatement.setString(1, schedule.getId());
                    scheduleDependsInsertStatement.setString(2, depends[i].getMasterId());
                    scheduleDependsInsertStatement.setNull(3, 12);
                    scheduleDependsInsertStatement.setNull(4, 12);
                    scheduleDependsInsertStatement.setString(5, depends[i].isIgnoreError() ? "1" : "0");
                    scheduleDependsInsertStatement.setTimestamp(6, now);
                    scheduleDependsInsertStatement.executeUpdate();
                }
            }
            if ((dependsOnGroup = schedule.getDependsOnGroup()) != null && dependsOnGroup.length != 0) {
                for (int i = 0; i < dependsOnGroup.length; ++i) {
                    scheduleDependsInsertStatement.setString(1, schedule.getId());
                    scheduleDependsInsertStatement.setNull(2, 12);
                    scheduleDependsInsertStatement.setString(3, dependsOnGroup[i].getMasterId());
                    scheduleDependsInsertStatement.setNull(4, 12);
                    scheduleDependsInsertStatement.setString(5, dependsOnGroup[i].isIgnoreError() ? "1" : "0");
                    scheduleDependsInsertStatement.setTimestamp(6, now);
                    scheduleDependsInsertStatement.executeUpdate();
                }
            }
            if ((masterGroupIds = schedule.getMasterGroupIds()) != null && masterGroupIds.length != 0) {
                for (int i = 0; i < masterGroupIds.length; ++i) {
                    String groupId;
                    scheduleGroupInsertStatement.setString(1, schedule.getId());
                    String string = groupId = groupMap == null ? null : (String)groupMap.get(masterGroupIds[i]);
                    if (groupId == null) {
                        if (this.nextScheduleIdSelectQuery != null) {
                            rs = nextScheduleIdStatement.executeQuery(this.nextScheduleIdSelectQuery);
                            rs.next();
                            groupId = rs.getObject(1).toString();
                            rs.close();
                            rs = null;
                        } else if (this.sequence != null) {
                            groupId = this.sequence.increment();
                        }
                        if (groupMap != null) {
                            groupMap.put(masterGroupIds[i], groupId);
                        }
                        scheduleGroupDependsMasterSelectStatement.setString(1, masterGroupIds[i]);
                        rs = scheduleGroupDependsMasterSelectStatement.executeQuery();
                        while (rs.next()) {
                            scheduleGroupDependsInsertStatement.setString(1, groupId);
                            scheduleGroupDependsInsertStatement.setString(2, rs.getString(1));
                            scheduleGroupDependsInsertStatement.setString(3, rs.getString(2));
                            scheduleGroupDependsInsertStatement.setTimestamp(4, now);
                            scheduleGroupDependsInsertStatement.executeUpdate();
                        }
                        rs.close();
                        rs = null;
                    }
                    schedule.setGroupId(masterGroupIds[i], groupId);
                    scheduleGroupInsertStatement.setString(2, groupId);
                    scheduleGroupInsertStatement.setString(3, masterGroupIds[i]);
                    scheduleGroupInsertStatement.setTimestamp(4, now);
                    scheduleGroupInsertStatement.executeUpdate();
                }
            }
            if ((dependsInGroupMap = schedule.getDependsInGroupMasterMap()) != null && dependsInGroupMap.size() != 0) {
                for (Map.Entry entry : dependsInGroupMap.entrySet()) {
                    ScheduleDepends[] deps = (ScheduleDepends[])entry.getValue();
                    for (int i = 0; i < deps.length; ++i) {
                        scheduleDependsInsertStatement.setString(1, schedule.getId());
                        scheduleDependsInsertStatement.setString(2, deps[i].getMasterId());
                        scheduleDependsInsertStatement.setNull(3, 12);
                        scheduleDependsInsertStatement.setString(4, schedule.getGroupId((String)entry.getKey()));
                        scheduleDependsInsertStatement.setString(5, deps[i].isIgnoreError() ? "1" : "0");
                        scheduleDependsInsertStatement.setTimestamp(6, now);
                        scheduleDependsInsertStatement.executeUpdate();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void setScheduleMaker(String scheduleType, ScheduleMaker maker) throws IllegalArgumentException {
        if (this.addedScheduleMakerMap == null) {
            this.addedScheduleMakerMap = new HashMap();
        }
        if (this.addedScheduleMakerMap.containsKey(scheduleType)) {
            throw new IllegalArgumentException("Dupulicate scheduleType : " + scheduleType);
        }
        this.addedScheduleMakerMap.put(scheduleType, maker);
    }

    @Override
    public ScheduleMaker getScheduleMaker(String scheduleType) {
        ScheduleMaker maker = (ScheduleMaker)this.scheduleMakerMap.get(scheduleType);
        if (this.isScheduleMakerTypeRegexEnabled && maker == null) {
            for (Map.Entry entry : this.scheduleMakerMap.entrySet()) {
                String key = (String)entry.getKey();
                try {
                    if (!Pattern.matches(key, scheduleType)) continue;
                    maker = (ScheduleMaker)entry.getValue();
                    break;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                }
            }
        }
        if (maker == null) {
            maker = this.defaultScheduleMaker;
        }
        return maker;
    }

    @Override
    public Map getScheduleMakerMap() {
        return this.scheduleMakerMap;
    }

    @Override
    public void setDefaultScheduleMaker(ScheduleMaker maker) {
        this.defaultScheduleMaker = maker;
    }

    @Override
    public ScheduleMaker getDefaultScheduleMaker() {
        return this.defaultScheduleMaker;
    }

    @Override
    public List findScheduleMasters(String groupId) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        ArrayList<DefaultScheduleMaster> result = new ArrayList<DefaultScheduleMaster>();
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("select ").append("A.").append(this.scheduleMasterTableSchema.id).append(" as ").append(this.scheduleMasterTableSchema.id).append(',').append("A.").append(this.scheduleMasterTableSchema.taskName).append(" as ").append(this.scheduleMasterTableSchema.taskName).append(',').append("A.").append(this.scheduleMasterTableSchema.scheduleType).append(" as ").append(this.scheduleMasterTableSchema.scheduleType).append(',').append("A.").append(this.scheduleMasterTableSchema.input).append(" as ").append(this.scheduleMasterTableSchema.input).append(',').append("A.").append(this.scheduleMasterTableSchema.startTime).append(" as ").append(this.scheduleMasterTableSchema.startTime).append(',').append("A.").append(this.scheduleMasterTableSchema.endTime).append(" as ").append(this.scheduleMasterTableSchema.endTime).append(',').append("A.").append(this.scheduleMasterTableSchema.repeatInterval).append(" as ").append(this.scheduleMasterTableSchema.repeatInterval).append(',').append("A.").append(this.scheduleMasterTableSchema.retryInterval).append(" as ").append(this.scheduleMasterTableSchema.retryInterval).append(',').append("A.").append(this.scheduleMasterTableSchema.retryEndTime).append(" as ").append(this.scheduleMasterTableSchema.retryEndTime).append(',').append("A.").append(this.scheduleMasterTableSchema.maxDelayTime).append(" as ").append(this.scheduleMasterTableSchema.maxDelayTime).append(',').append("A.").append(this.scheduleMasterTableSchema.enable).append(" as ").append(this.scheduleMasterTableSchema.enable).append(',').append("A.").append(this.scheduleMasterTableSchema.executorKey).append(" as ").append(this.scheduleMasterTableSchema.executorKey).append(',').append("A.").append(this.scheduleMasterTableSchema.executorType).append(" as ").append(this.scheduleMasterTableSchema.executorType).append(',').append("A.").append(this.scheduleMasterTableSchema.template).append(" as ").append(this.scheduleMasterTableSchema.template).append(" from ").append(this.scheduleMasterTableSchema.table).append(" A");
            if (groupId == null) {
                buf.append(" where not exists (select 1 from ").append(this.scheduleGroupMasterTableSchema.table).append(" where ").append("A.").append(this.scheduleMasterTableSchema.id).append("=B.").append(this.scheduleGroupMasterTableSchema.id).append(')');
                st = con.createStatement();
                rs = st.executeQuery(buf.toString());
            } else {
                buf.append(",(select ").append(this.scheduleGroupMasterTableSchema.id).append(" from ").append(this.scheduleGroupMasterTableSchema.table).append(" where ").append(this.scheduleGroupMasterTableSchema.groupId).append("=?) B").append(" where ").append("A.").append(this.scheduleMasterTableSchema.id).append("=B.").append(this.scheduleGroupMasterTableSchema.id);
                st = con.prepareStatement(buf.toString());
                if (groupId != null) {
                    ((PreparedStatement)st).setString(1, groupId);
                }
                rs = ((PreparedStatement)st).executeQuery();
            }
            while (rs.next()) {
                DefaultScheduleMaster scheduleMaster = this.createScheduleMaster(rs);
                result.add(scheduleMaster);
            }
            rs.close();
            rs = null;
            st.close();
            st = null;
            this.setDependsOnScheduleMasters(con, result);
            this.setGroupIdsOnScheduleMasters(con, result);
            this.setGroupDependsOnGroupOnScheduleMasters(con, result);
        }
        catch (ScheduleManageException e) {
            throw new ScheduleMakeException(e);
        }
        catch (ParseException e) {
            throw new ScheduleMakeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleMakeException(e);
        }
        catch (IOException e) {
            throw new ScheduleMakeException(e);
        }
        catch (SQLException e) {
            throw new ScheduleMakeException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return result;
    }

    @Override
    public List findAllScheduleMasters() throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        ArrayList<DefaultScheduleMaster> result = new ArrayList<DefaultScheduleMaster>();
        try {
            st = con.createStatement();
            rs = st.executeQuery("select * from " + this.scheduleMasterTableSchema.table);
            while (rs.next()) {
                DefaultScheduleMaster scheduleMaster = this.createScheduleMaster(rs);
                result.add(scheduleMaster);
            }
            rs.close();
            rs = null;
            this.setDependsOnScheduleMasters(con, result);
            this.setGroupIdsOnScheduleMasters(con, result);
            this.setGroupDependsOnGroupOnScheduleMasters(con, result);
        }
        catch (ScheduleManageException e) {
            throw new ScheduleMakeException(e);
        }
        catch (ParseException e) {
            throw new ScheduleMakeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleMakeException(e);
        }
        catch (IOException e) {
            throw new ScheduleMakeException(e);
        }
        catch (SQLException e) {
            throw new ScheduleMakeException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return result;
    }

    @Override
    public ScheduleMaster findScheduleMaster(String id) throws ScheduleManageException {
        DefaultScheduleMaster defaultScheduleMaster;
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select * from " + this.scheduleMasterTableSchema.table + " where " + this.scheduleMasterTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                ScheduleMaster scheduleMaster = null;
                return scheduleMaster;
            }
            DefaultScheduleMaster scheduleMaster = this.createScheduleMaster(rs);
            this.setDependsOnScheduleMaster(con, scheduleMaster);
            this.setGroupIdsOnScheduleMaster(con, scheduleMaster);
            this.setGroupDependsOnGroupOnScheduleMaster(con, scheduleMaster);
            defaultScheduleMaster = scheduleMaster;
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return defaultScheduleMaster;
    }

    protected DefaultScheduleMaster createScheduleMaster(ResultSet rs) throws SQLException, ParseException, IOException, ClassNotFoundException {
        SimpleDateFormat timeFormatter = new SimpleDateFormat(this.timeFormat);
        DefaultScheduleMaster scheduleMaster = new DefaultScheduleMaster();
        scheduleMaster.setId(rs.getString(this.scheduleMasterTableSchema.id));
        scheduleMaster.setTaskName(rs.getString(this.scheduleMasterTableSchema.taskName));
        scheduleMaster.setScheduleType(rs.getString(this.scheduleMasterTableSchema.scheduleType));
        scheduleMaster.setInput(this.scheduleMasterTableSchema.getInputObject(rs));
        String str = rs.getString(this.scheduleMasterTableSchema.startTime);
        if (str != null && str.length() != 0) {
            scheduleMaster.setStartTime(timeFormatter.parse(str));
        }
        if ((str = rs.getString(this.scheduleMasterTableSchema.endTime)) != null && str.length() != 0) {
            scheduleMaster.setEndTime(timeFormatter.parse(str));
        }
        long longVal = rs.getLong(this.scheduleMasterTableSchema.repeatInterval);
        if (!rs.wasNull()) {
            scheduleMaster.setRepeatInterval(longVal);
        }
        longVal = rs.getLong(this.scheduleMasterTableSchema.retryInterval);
        if (!rs.wasNull()) {
            scheduleMaster.setRetryInterval(longVal);
        }
        if ((str = rs.getString(this.scheduleMasterTableSchema.retryEndTime)) != null && str.length() != 0) {
            scheduleMaster.setRetryEndTime(timeFormatter.parse(str));
        }
        longVal = rs.getLong(this.scheduleMasterTableSchema.maxDelayTime);
        if (!rs.wasNull()) {
            scheduleMaster.setMaxDelayTime(longVal);
        }
        scheduleMaster.setExecutorKey(rs.getString(this.scheduleMasterTableSchema.executorKey));
        scheduleMaster.setExecutorType(rs.getString(this.scheduleMasterTableSchema.executorType));
        String enableStr = rs.getString(this.scheduleMasterTableSchema.enable);
        boolean isEnabled = enableStr != null && !"0".equals(enableStr);
        scheduleMaster.setEnabled(isEnabled);
        String templateStr = rs.getString(this.scheduleMasterTableSchema.template);
        boolean isTemplate = templateStr != null && !"0".equals(templateStr);
        scheduleMaster.setTemplate(isTemplate);
        return scheduleMaster;
    }

    protected ScheduleMaster setDependsOnScheduleMaster(Connection con, ScheduleMaster schedule) throws SQLException {
        ArrayList<ScheduleMaster> tmp = new ArrayList<ScheduleMaster>();
        tmp.add(schedule);
        this.setDependsOnScheduleMasters(con, tmp);
        return (ScheduleMaster)tmp.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List setDependsOnScheduleMasters(Connection con, List schedules) throws SQLException {
        if (schedules.size() == 0) {
            return schedules;
        }
        StringBuffer buf = new StringBuffer();
        Statement st = con.createStatement();
        ResultSet rs = null;
        try {
            HashMap<String, ScheduleMaster> scheduleMap = new HashMap<String, ScheduleMaster>();
            HashMap<String, ArrayList<DefaultScheduleDepends>> scheduleDependsMap = new HashMap<String, ArrayList<DefaultScheduleDepends>>();
            HashMap<String, ArrayList<DefaultScheduleDepends>> scheduleDependsOnGroupMap = new HashMap<String, ArrayList<DefaultScheduleDepends>>();
            HashMap scheduleDependsInGroupMap = new HashMap();
            int to = schedules.size() % 1000 == 0 ? schedules.size() / 1000 : schedules.size() / 1000 + 1;
            for (int i = 0; i < to; ++i) {
                List depends;
                List depends2;
                ScheduleMaster schedule;
                int startIndex;
                scheduleMap.clear();
                scheduleDependsMap.clear();
                buf.setLength(0);
                buf.append("select ").append(this.scheduleDependsMasterTableSchema.id).append(',').append(this.scheduleDependsMasterTableSchema.dependsId).append(',').append(this.scheduleDependsMasterTableSchema.dependsGroupId).append(',').append(this.scheduleDependsMasterTableSchema.groupId).append(',').append(this.scheduleDependsMasterTableSchema.ignoreError).append(" from ").append(this.scheduleDependsMasterTableSchema.table).append(" where ").append(this.scheduleDependsMasterTableSchema.id).append(" in (");
                int jmax = Math.min(startIndex + 1000, schedules.size());
                for (int j = startIndex = i * 1000; j < jmax; ++j) {
                    schedule = (ScheduleMaster)schedules.get(j);
                    buf.append('\'').append(schedule.getId()).append('\'');
                    if (j != jmax - 1) {
                        buf.append(',');
                    }
                    scheduleMap.put(schedule.getId(), schedule);
                }
                buf.append(')');
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    ArrayList<DefaultScheduleDepends> depends3;
                    boolean isIgnoreError;
                    String id = rs.getString(1);
                    String masterId = rs.getString(2);
                    String masterGroupId = rs.getString(3);
                    String groupId = rs.getString(4);
                    String ignoreErrorStr = rs.getString(5);
                    boolean bl = isIgnoreError = ignoreErrorStr != null && !"0".equals(ignoreErrorStr);
                    if (masterId == null) {
                        depends2 = (ArrayList<DefaultScheduleDepends>)scheduleDependsOnGroupMap.get(id);
                        if (depends2 == null) {
                            depends2 = new ArrayList<DefaultScheduleDepends>();
                            scheduleDependsOnGroupMap.put(id, (ArrayList<DefaultScheduleDepends>)depends2);
                        }
                        depends2.add(new DefaultScheduleDepends(masterGroupId, isIgnoreError));
                        continue;
                    }
                    if (groupId == null) {
                        depends2 = (List)scheduleDependsMap.get(id);
                        if (depends2 == null) {
                            depends2 = new ArrayList();
                            scheduleDependsMap.put(id, (ArrayList<DefaultScheduleDepends>)depends2);
                        }
                        depends2.add(new DefaultScheduleDepends(masterId, isIgnoreError));
                        continue;
                    }
                    HashMap<String, ArrayList<DefaultScheduleDepends>> dependsMap = (HashMap<String, ArrayList<DefaultScheduleDepends>>)scheduleDependsInGroupMap.get(id);
                    if (dependsMap == null) {
                        dependsMap = new HashMap<String, ArrayList<DefaultScheduleDepends>>();
                        scheduleDependsInGroupMap.put(id, dependsMap);
                    }
                    if ((depends3 = (ArrayList<DefaultScheduleDepends>)dependsMap.get(groupId)) == null) {
                        depends3 = new ArrayList<DefaultScheduleDepends>();
                        dependsMap.put(groupId, depends3);
                    }
                    depends3.add(new DefaultScheduleDepends(masterId, isIgnoreError));
                }
                for (Map.Entry entry : scheduleDependsMap.entrySet()) {
                    schedule = (DefaultScheduleMaster)scheduleMap.get(entry.getKey());
                    depends = (List)entry.getValue();
                    if (depends.size() == 0) continue;
                    ((DefaultScheduleMaster)schedule).setDepends(depends.toArray(new ScheduleDepends[depends.size()]));
                }
                for (Map.Entry entry : scheduleDependsOnGroupMap.entrySet()) {
                    schedule = (DefaultScheduleMaster)scheduleMap.get(entry.getKey());
                    depends = (List)entry.getValue();
                    if (depends.size() == 0) continue;
                    ((DefaultScheduleMaster)schedule).setDependsOnGroup(depends.toArray(new ScheduleDepends[depends.size()]));
                }
                for (Map.Entry entry : scheduleDependsInGroupMap.entrySet()) {
                    schedule = (DefaultScheduleMaster)scheduleMap.get(entry.getKey());
                    Map dependsMap = (Map)entry.getValue();
                    for (Map.Entry entry2 : dependsMap.entrySet()) {
                        depends2 = (List)entry2.getValue();
                        if (depends2.size() == 0) continue;
                        ((DefaultScheduleMaster)schedule).setDependsInGroup((String)entry2.getKey(), depends2.toArray(new ScheduleDepends[depends2.size()]));
                    }
                }
                rs.close();
                rs = null;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
                st = null;
            }
        }
        return schedules;
    }

    protected ScheduleMaster setGroupIdsOnScheduleMaster(Connection con, ScheduleMaster schedule) throws SQLException {
        ArrayList<ScheduleMaster> tmp = new ArrayList<ScheduleMaster>();
        tmp.add(schedule);
        this.setGroupIdsOnScheduleMasters(con, tmp);
        return (ScheduleMaster)tmp.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List setGroupIdsOnScheduleMasters(Connection con, List schedules) throws SQLException {
        if (schedules.size() == 0) {
            return schedules;
        }
        StringBuffer buf = new StringBuffer();
        Statement st = con.createStatement();
        ResultSet rs = null;
        try {
            HashMap<String, ScheduleMaster> scheduleMap = new HashMap<String, ScheduleMaster>();
            HashMap<String, ArrayList<String>> scheduleGroupIdsMap = new HashMap<String, ArrayList<String>>();
            int to = schedules.size() % 1000 == 0 ? schedules.size() / 1000 : schedules.size() / 1000 + 1;
            for (int i = 0; i < to; ++i) {
                ScheduleMaster schedule;
                int startIndex;
                scheduleMap.clear();
                scheduleGroupIdsMap.clear();
                buf.setLength(0);
                buf.append("select * from ");
                buf.append(this.scheduleGroupMasterTableSchema.table);
                buf.append(" where ");
                buf.append(this.scheduleGroupMasterTableSchema.id);
                buf.append(" in (");
                int jmax = Math.min(startIndex + 1000, schedules.size());
                for (int j = startIndex = i * 1000; j < jmax; ++j) {
                    schedule = (ScheduleMaster)schedules.get(j);
                    buf.append('\'').append(schedule.getId()).append('\'');
                    if (j != jmax - 1) {
                        buf.append(',');
                    }
                    scheduleMap.put(schedule.getId(), schedule);
                }
                buf.append(')');
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    String id = rs.getString(this.scheduleGroupMasterTableSchema.id);
                    ArrayList<String> groupIds = (ArrayList<String>)scheduleGroupIdsMap.get(id);
                    if (groupIds == null) {
                        groupIds = new ArrayList<String>();
                        scheduleGroupIdsMap.put(id, groupIds);
                    }
                    groupIds.add(rs.getString(this.scheduleGroupMasterTableSchema.groupId));
                }
                for (Map.Entry entry : scheduleGroupIdsMap.entrySet()) {
                    schedule = (DefaultScheduleMaster)scheduleMap.get(entry.getKey());
                    List groupIds = (List)entry.getValue();
                    if (groupIds.size() == 0) continue;
                    ((DefaultScheduleMaster)schedule).setGroupIds(groupIds.toArray(new String[groupIds.size()]));
                }
                rs.close();
                rs = null;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
                st = null;
            }
        }
        return schedules;
    }

    protected ScheduleMaster setGroupDependsOnGroupOnScheduleMaster(Connection con, ScheduleMaster schedule) throws SQLException {
        ArrayList<ScheduleMaster> tmp = new ArrayList<ScheduleMaster>();
        tmp.add(schedule);
        this.setGroupDependsOnGroupOnScheduleMasters(con, tmp);
        return (ScheduleMaster)tmp.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List setGroupDependsOnGroupOnScheduleMasters(Connection con, List schedules) throws SQLException {
        if (schedules.size() == 0) {
            return schedules;
        }
        StringBuffer buf = new StringBuffer();
        Statement st = con.createStatement();
        ResultSet rs = null;
        try {
            HashMap<String, HashSet<ScheduleMaster>> groupScheduleMap = new HashMap<String, HashSet<ScheduleMaster>>();
            int imax = schedules.size();
            for (int i = 0; i < imax; ++i) {
                ScheduleMaster schedule = (ScheduleMaster)schedules.get(i);
                String[] groupIds = schedule.getGroupIds();
                if (groupIds == null) continue;
                for (int j = 0; j < groupIds.length; ++j) {
                    HashSet<ScheduleMaster> scheduleSet = (HashSet<ScheduleMaster>)groupScheduleMap.get(groupIds[j]);
                    if (scheduleSet == null) {
                        scheduleSet = new HashSet<ScheduleMaster>();
                        groupScheduleMap.put(groupIds[j], scheduleSet);
                    }
                    scheduleSet.add(schedule);
                }
            }
            HashMap<String, ArrayList<DefaultScheduleDepends>> groupDependsMap = new HashMap<String, ArrayList<DefaultScheduleDepends>>();
            String[] groupIds = groupScheduleMap.keySet().toArray(new String[groupScheduleMap.size()]);
            int to = groupIds.length % 1000 == 0 ? groupIds.length / 1000 : groupIds.length / 1000 + 1;
            for (int i = 0; i < to; ++i) {
                ArrayList<DefaultScheduleDepends> dependsList;
                int startIndex;
                buf.setLength(0);
                buf.append("select * from ").append(this.scheduleGroupDependsMasterTableSchema.table);
                buf.append(" where ");
                buf.append(this.scheduleGroupDependsMasterTableSchema.groupId);
                buf.append(" in (");
                int jmax = Math.min(startIndex + 1000, groupIds.length);
                for (int j = startIndex = i * 1000; j < jmax; ++j) {
                    buf.append('\'').append(groupIds[j]).append('\'');
                    if (j == jmax - 1) continue;
                    buf.append(',');
                }
                buf.append(')');
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    String groupId = rs.getString(this.scheduleGroupDependsMasterTableSchema.groupId);
                    String dependsGroupId = rs.getString(this.scheduleGroupDependsMasterTableSchema.dependsGroupId);
                    String ignoreErrorStr = rs.getString(this.scheduleGroupDependsMasterTableSchema.ignoreError);
                    boolean isIgnoreError = ignoreErrorStr != null && !"0".equals(ignoreErrorStr);
                    dependsList = (ArrayList<DefaultScheduleDepends>)groupDependsMap.get(groupId);
                    if (dependsList == null) {
                        dependsList = new ArrayList<DefaultScheduleDepends>();
                        groupDependsMap.put(groupId, dependsList);
                    }
                    dependsList.add(new DefaultScheduleDepends(dependsGroupId, isIgnoreError));
                }
                rs.close();
                rs = null;
                for (Map.Entry entry : groupDependsMap.entrySet()) {
                    String groupId = (String)entry.getKey();
                    Set scheduleSet = (Set)groupScheduleMap.get(groupId);
                    dependsList = (List)entry.getValue();
                    ScheduleDepends[] depends = dependsList.toArray(new ScheduleDepends[dependsList.size()]);
                    for (DefaultScheduleMaster schedule : scheduleSet) {
                        schedule.setGroupDependsOnGroup(groupId, depends);
                    }
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
                st = null;
            }
        }
        return schedules;
    }

    @Override
    public List findAllSchedules() throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.createStatement();
            rs = st.executeQuery("select * from " + this.scheduleTableSchema.table);
            ArrayList<Schedule> result = new ArrayList<Schedule>();
            while (rs.next()) {
                result.add(this.createSchedule(rs));
            }
            this.setDependsOnSchedules(con, result);
            ArrayList<Schedule> arrayList = result;
            return arrayList;
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        catch (ConvertException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected Schedule createSchedule(ResultSet rs) throws SQLException, ParseException, IOException, ClassNotFoundException {
        String executeEndTimeStr;
        String retryEndTimeStr;
        DefaultSchedule schedule = new DefaultSchedule();
        schedule.setId(rs.getString(this.scheduleTableSchema.id));
        schedule.setMasterId(rs.getString(this.scheduleTableSchema.masterId));
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
        String str = rs.getString(this.scheduleTableSchema.date) + rs.getString(this.scheduleTableSchema.time);
        schedule.setTime(format.parse(str));
        schedule.setTaskName(rs.getString(this.scheduleTableSchema.taskName));
        Object input = this.scheduleTableSchema.getInputObject(rs);
        if (this.isJsonInput && input instanceof String) {
            BeanJSONConverter jsonConverter = new BeanJSONConverter();
            jsonConverter.setUnicodeEscape(false);
            StringStreamConverter streamConverter = new StringStreamConverter();
            input = jsonConverter.convertToObject(streamConverter.convertToStream(input));
        }
        schedule.setInput(input);
        schedule.setOutput(this.scheduleTableSchema.getOutputObject(rs));
        str = rs.getString(this.scheduleTableSchema.initialDate) + rs.getString(this.scheduleTableSchema.initialTime);
        schedule.setInitialTime(format.parse(str));
        long longVal = rs.getLong(this.scheduleTableSchema.retryInterval);
        if (!rs.wasNull()) {
            schedule.setRetryInterval(longVal);
        }
        if ((retryEndTimeStr = rs.getString(this.scheduleTableSchema.retryEndTime)) != null) {
            schedule.setRetryEndTime(format.parse(retryEndTimeStr));
        }
        longVal = rs.getLong(this.scheduleTableSchema.maxDelayTime);
        if (!rs.wasNull()) {
            schedule.setMaxDelayTime(longVal);
        }
        schedule.setState(this.scheduleTableSchema.getState(rs.getString(this.scheduleTableSchema.state)));
        schedule.setControlState(this.scheduleTableSchema.getControlState(rs.getString(this.scheduleTableSchema.controlState)));
        schedule.setCheckState(this.scheduleTableSchema.getCheckState(rs.getString(this.scheduleTableSchema.checkState)));
        schedule.setExecutorKey(rs.getString(this.scheduleTableSchema.executorKey));
        schedule.setExecutorType(rs.getString(this.scheduleTableSchema.executorType));
        String executeStartTimeStr = rs.getString(this.scheduleTableSchema.executeStartTime);
        if (executeStartTimeStr != null) {
            schedule.setExecuteStartTime(format.parse(executeStartTimeStr));
        }
        if ((executeEndTimeStr = rs.getString(this.scheduleTableSchema.executeEndTime)) != null) {
            schedule.setExecuteEndTime(format.parse(executeEndTimeStr));
        }
        return schedule;
    }

    protected Schedule setDependsOnSchedule(Connection con, Schedule schedule) throws SQLException {
        ArrayList<Schedule> tmp = new ArrayList<Schedule>();
        tmp.add(schedule);
        this.setDependsOnSchedules(con, tmp);
        return (Schedule)tmp.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List setDependsOnSchedules(Connection con, List schedules) throws SQLException {
        if (schedules.size() == 0) {
            return schedules;
        }
        StringBuffer buf = new StringBuffer();
        Statement st = con.createStatement();
        ResultSet rs = null;
        try {
            HashMap<String, Schedule> scheduleMap = new HashMap<String, Schedule>();
            HashMap<String, ArrayList<DefaultScheduleDepends>> scheduleDependsMap = new HashMap<String, ArrayList<DefaultScheduleDepends>>();
            HashMap<String, ArrayList<DefaultScheduleDepends>> scheduleDependsOnGroupMap = new HashMap<String, ArrayList<DefaultScheduleDepends>>();
            HashMap scheduleDependsInGroupMap = new HashMap();
            int to = schedules.size() % 1000 == 0 ? schedules.size() / 1000 : schedules.size() / 1000 + 1;
            for (int i = 0; i < to; ++i) {
                List depends;
                List depends2;
                Schedule schedule;
                int startIndex;
                scheduleMap.clear();
                scheduleDependsMap.clear();
                buf.setLength(0);
                buf.append("select ").append(this.scheduleDependsTableSchema.id).append(',').append(this.scheduleDependsTableSchema.dependsId).append(',').append(this.scheduleDependsTableSchema.dependsGroupId).append(',').append(this.scheduleDependsTableSchema.groupId).append(',').append(this.scheduleDependsTableSchema.ignoreError).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append(" in (");
                int jmax = Math.min(startIndex + 1000, schedules.size());
                for (int j = startIndex = i * 1000; j < jmax; ++j) {
                    schedule = (Schedule)schedules.get(j);
                    buf.append('\'').append(schedule.getId()).append('\'');
                    if (j != jmax - 1) {
                        buf.append(',');
                    }
                    scheduleMap.put(schedule.getId(), schedule);
                }
                buf.append(')');
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    ArrayList<DefaultScheduleDepends> depends3;
                    boolean isIgnoreError;
                    String id = rs.getString(1);
                    String masterId = rs.getString(2);
                    String masterGroupId = rs.getString(3);
                    String groupId = rs.getString(4);
                    String ignoreErrorStr = rs.getString(5);
                    boolean bl = isIgnoreError = ignoreErrorStr != null && !"0".equals(ignoreErrorStr);
                    if (masterId == null) {
                        depends2 = (ArrayList<DefaultScheduleDepends>)scheduleDependsOnGroupMap.get(id);
                        if (depends2 == null) {
                            depends2 = new ArrayList<DefaultScheduleDepends>();
                            scheduleDependsOnGroupMap.put(id, (ArrayList<DefaultScheduleDepends>)depends2);
                        }
                        depends2.add(new DefaultScheduleDepends(masterGroupId, isIgnoreError));
                        continue;
                    }
                    if (groupId == null) {
                        depends2 = (List)scheduleDependsMap.get(id);
                        if (depends2 == null) {
                            depends2 = new ArrayList();
                            scheduleDependsMap.put(id, (ArrayList<DefaultScheduleDepends>)depends2);
                        }
                        depends2.add(new DefaultScheduleDepends(masterId, isIgnoreError));
                        continue;
                    }
                    HashMap<String, ArrayList<DefaultScheduleDepends>> dependsMap = (HashMap<String, ArrayList<DefaultScheduleDepends>>)scheduleDependsInGroupMap.get(id);
                    if (dependsMap == null) {
                        dependsMap = new HashMap<String, ArrayList<DefaultScheduleDepends>>();
                        scheduleDependsInGroupMap.put(id, dependsMap);
                    }
                    if ((depends3 = (ArrayList<DefaultScheduleDepends>)dependsMap.get(groupId)) == null) {
                        depends3 = new ArrayList<DefaultScheduleDepends>();
                        dependsMap.put(groupId, depends3);
                    }
                    depends3.add(new DefaultScheduleDepends(masterId, isIgnoreError));
                }
                for (Map.Entry entry : scheduleDependsMap.entrySet()) {
                    schedule = (DefaultSchedule)scheduleMap.get(entry.getKey());
                    depends = (List)entry.getValue();
                    if (depends.size() == 0) continue;
                    ((DefaultSchedule)schedule).setDepends(depends.toArray(new ScheduleDepends[depends.size()]));
                }
                for (Map.Entry entry : scheduleDependsOnGroupMap.entrySet()) {
                    schedule = (DefaultSchedule)scheduleMap.get(entry.getKey());
                    depends = (List)entry.getValue();
                    if (depends.size() == 0) continue;
                    ((DefaultSchedule)schedule).setDependsOnGroup(depends.toArray(new ScheduleDepends[depends.size()]));
                }
                for (Map.Entry entry : scheduleDependsInGroupMap.entrySet()) {
                    schedule = (DefaultSchedule)scheduleMap.get(entry.getKey());
                    Map dependsMap = (Map)entry.getValue();
                    for (Map.Entry entry2 : dependsMap.entrySet()) {
                        depends2 = (List)entry2.getValue();
                        if (depends2.size() == 0) continue;
                        ((DefaultSchedule)schedule).setDependsInGroup((String)entry2.getKey(), depends2.toArray(new ScheduleDepends[depends2.size()]));
                    }
                }
                rs.close();
                rs = null;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
                st = null;
            }
        }
        return schedules;
    }

    protected Schedule setGroupIdsOnSchedule(Connection con, Schedule schedule) throws SQLException {
        ArrayList<Schedule> tmp = new ArrayList<Schedule>();
        tmp.add(schedule);
        this.setGroupIdsOnSchedules(con, tmp);
        return (Schedule)tmp.get(0);
    }

    protected List setGroupIdsOnSchedules(Connection con, List schedules) throws SQLException {
        if (schedules.size() == 0) {
            return schedules;
        }
        StringBuffer buf = new StringBuffer();
        Statement st = con.createStatement();
        ResultSet rs = null;
        HashMap<String, Schedule> scheduleMap = new HashMap<String, Schedule>();
        HashMap<String, ArrayList<String>> scheduleGroupIdsMap = new HashMap<String, ArrayList<String>>();
        int to = schedules.size() % 1000 == 0 ? schedules.size() / 1000 : schedules.size() / 1000 + 1;
        for (int i = 0; i < to; ++i) {
            ArrayList<String> groupIds;
            Schedule schedule;
            int startIndex;
            scheduleMap.clear();
            scheduleGroupIdsMap.clear();
            buf.setLength(0);
            buf.append("select * from ");
            buf.append(this.scheduleGroupTableSchema.table);
            buf.append(" where ");
            buf.append(this.scheduleGroupTableSchema.id);
            buf.append(" in (");
            int jmax = Math.min(startIndex + 1000, schedules.size());
            for (int j = startIndex = i * 1000; j < jmax; ++j) {
                Schedule schedule2 = (Schedule)schedules.get(j);
                buf.append('\'').append(schedule2.getId()).append('\'');
                if (j != jmax - 1) {
                    buf.append(',');
                }
                scheduleMap.put(schedule2.getId(), schedule2);
            }
            buf.append(')');
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                String id = rs.getString(this.scheduleGroupTableSchema.id);
                String groupId = rs.getString(this.scheduleGroupTableSchema.groupId);
                String masterGroupId = rs.getString(this.scheduleGroupTableSchema.masterGroupId);
                schedule = (Schedule)scheduleMap.get(id);
                if (schedule != null) {
                    ((DefaultSchedule)schedule).setGroupId(masterGroupId, groupId);
                }
                if ((groupIds = (List)scheduleGroupIdsMap.get(id)) == null) {
                    groupIds = new ArrayList<String>();
                    scheduleGroupIdsMap.put(id, groupIds);
                }
                groupIds.add(groupId);
            }
            for (Map.Entry entry : scheduleGroupIdsMap.entrySet()) {
                String id = (String)entry.getKey();
                schedule = (Schedule)scheduleMap.get(id);
                if (schedule == null) continue;
                groupIds = (ArrayList<String>)entry.getValue();
                String[] ids = groupIds.toArray(new String[groupIds.size()]);
                ((DefaultSchedule)schedule).setMasterGroupIds(ids);
            }
            rs.close();
        }
        return schedules;
    }

    protected Schedule setGroupDependsOnGroupOnSchedule(Connection con, Schedule schedule) throws SQLException {
        ArrayList<Schedule> tmp = new ArrayList<Schedule>();
        tmp.add(schedule);
        this.setGroupDependsOnGroupOnSchedules(con, tmp);
        return (Schedule)tmp.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List setGroupDependsOnGroupOnSchedules(Connection con, List schedules) throws SQLException {
        if (schedules.size() == 0) {
            return schedules;
        }
        StringBuffer buf = new StringBuffer();
        Statement st = con.createStatement();
        ResultSet rs = null;
        try {
            HashMap<String, HashSet<Schedule>> groupScheduleMap = new HashMap<String, HashSet<Schedule>>();
            int imax = schedules.size();
            for (int i = 0; i < imax; ++i) {
                Schedule schedule = (Schedule)schedules.get(i);
                Map groupIdMap = schedule.getGroupIdMap();
                if (groupIdMap == null || groupIdMap.size() == 0) continue;
                String[] groupIds = groupIdMap.values().toArray(new String[groupIdMap.size()]);
                for (int j = 0; j < groupIds.length; ++j) {
                    HashSet<Schedule> scheduleSet = (HashSet<Schedule>)groupScheduleMap.get(groupIds[j]);
                    if (scheduleSet == null) {
                        scheduleSet = new HashSet<Schedule>();
                        groupScheduleMap.put(groupIds[j], scheduleSet);
                    }
                    scheduleSet.add(schedule);
                }
            }
            HashMap<String, ArrayList<DefaultScheduleDepends>> groupDependsMap = new HashMap<String, ArrayList<DefaultScheduleDepends>>();
            String[] groupIds = groupScheduleMap.keySet().toArray(new String[groupScheduleMap.size()]);
            int to = groupIds.length % 1000 == 0 ? groupIds.length / 1000 : groupIds.length / 1000 + 1;
            for (int i = 0; i < to; ++i) {
                ArrayList<DefaultScheduleDepends> dependsList;
                int startIndex;
                buf.setLength(0);
                buf.append("select * from ").append(this.scheduleGroupDependsTableSchema.table);
                buf.append(" where ");
                buf.append(this.scheduleGroupDependsTableSchema.groupId);
                buf.append(" in (");
                int jmax = Math.min(startIndex + 1000, groupIds.length);
                for (int j = startIndex = i * 1000; j < jmax; ++j) {
                    buf.append('\'').append(groupIds[j]).append('\'');
                    if (j == jmax - 1) continue;
                    buf.append(',');
                }
                buf.append(')');
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    String groupId = rs.getString(this.scheduleGroupDependsTableSchema.groupId);
                    String dependsGroupId = rs.getString(this.scheduleGroupDependsTableSchema.dependsGroupId);
                    String ignoreErrorStr = rs.getString(this.scheduleGroupDependsTableSchema.ignoreError);
                    boolean isIgnoreError = ignoreErrorStr != null && !"0".equals(ignoreErrorStr);
                    dependsList = (ArrayList<DefaultScheduleDepends>)groupDependsMap.get(groupId);
                    if (dependsList == null) {
                        dependsList = new ArrayList<DefaultScheduleDepends>();
                        groupDependsMap.put(groupId, dependsList);
                    }
                    dependsList.add(new DefaultScheduleDepends(dependsGroupId, isIgnoreError));
                }
                rs.close();
                rs = null;
                for (Map.Entry entry : groupDependsMap.entrySet()) {
                    String groupId = (String)entry.getKey();
                    Set scheduleSet = (Set)groupScheduleMap.get(groupId);
                    dependsList = (List)entry.getValue();
                    ScheduleDepends[] depends = dependsList.toArray(new ScheduleDepends[dependsList.size()]);
                    for (DefaultSchedule schedule : scheduleSet) {
                        schedule.setGroupDependsOnGroup(groupId, depends);
                    }
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
                st = null;
            }
        }
        return schedules;
    }

    @Override
    public Schedule findSchedule(String id) throws ScheduleManageException {
        Schedule schedule;
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select * from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                Schedule schedule2 = null;
                return schedule2;
            }
            schedule = this.setGroupDependsOnGroupOnSchedule(con, this.setGroupIdsOnSchedule(con, this.setDependsOnSchedule(con, this.createSchedule(rs))));
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        catch (ConvertException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return schedule;
    }

    @Override
    public List findSchedules(String groupId) throws ScheduleManageException {
        ArrayList<Schedule> result = new ArrayList<Schedule>();
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("select ").append("A.").append(this.scheduleTableSchema.id).append(" as ").append(this.scheduleTableSchema.id).append(',').append("A.").append(this.scheduleTableSchema.masterId).append(" as ").append(this.scheduleTableSchema.masterId).append(',').append("A.").append(this.scheduleTableSchema.date).append(" as ").append(this.scheduleTableSchema.date).append(',').append("A.").append(this.scheduleTableSchema.time).append(" as ").append(this.scheduleTableSchema.time).append(',').append("A.").append(this.scheduleTableSchema.taskName).append(" as ").append(this.scheduleTableSchema.taskName).append(',').append("A.").append(this.scheduleTableSchema.input).append(" as ").append(this.scheduleTableSchema.input).append(',').append("A.").append(this.scheduleTableSchema.output).append(" as ").append(this.scheduleTableSchema.output).append(',').append("A.").append(this.scheduleTableSchema.initialDate).append(" as ").append(this.scheduleTableSchema.initialDate).append(',').append("A.").append(this.scheduleTableSchema.initialTime).append(" as ").append(this.scheduleTableSchema.initialTime).append(',').append("A.").append(this.scheduleTableSchema.retryInterval).append(" as ").append(this.scheduleTableSchema.retryInterval).append(',').append("A.").append(this.scheduleTableSchema.retryEndTime).append(" as ").append(this.scheduleTableSchema.retryEndTime).append(',').append("A.").append(this.scheduleTableSchema.maxDelayTime).append(" as ").append(this.scheduleTableSchema.maxDelayTime).append(',').append("A.").append(this.scheduleTableSchema.state).append(" as ").append(this.scheduleTableSchema.state).append(',').append("A.").append(this.scheduleTableSchema.controlState).append(" as ").append(this.scheduleTableSchema.controlState).append(',').append("A.").append(this.scheduleTableSchema.checkState).append(" as ").append(this.scheduleTableSchema.checkState).append(',').append("A.").append(this.scheduleTableSchema.executorKey).append(" as ").append(this.scheduleTableSchema.executorKey).append(',').append("A.").append(this.scheduleTableSchema.executorType).append(" as ").append(this.scheduleTableSchema.executorType).append(',').append("A.").append(this.scheduleTableSchema.executeStartTime).append(" as ").append(this.scheduleTableSchema.executeStartTime).append(',').append("A.").append(this.scheduleTableSchema.executeEndTime).append(" as ").append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" A,").append("(select ").append(this.scheduleGroupTableSchema.id).append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.groupId).append("=?)").append(" where A.").append(this.scheduleTableSchema.id).append("=B.").append(this.scheduleGroupTableSchema.id);
            st = con.prepareStatement(buf.toString());
            st.setString(1, groupId);
            rs = st.executeQuery();
            while (rs.next()) {
                result.add(this.createSchedule(rs));
            }
            this.setDependsOnSchedules(con, result);
            this.setGroupIdsOnSchedules(con, result);
            this.setGroupDependsOnGroupOnSchedules(con, result);
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        catch (ConvertException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List findSchedules(String masterId, String masterGroupId) throws ScheduleManageException {
        ArrayList<Schedule> result = new ArrayList<Schedule>();
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            if (masterId != null) {
                st = con.prepareStatement("select * from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.masterId + "=?");
                st.setString(1, masterId);
            } else {
                StringBuffer buf = new StringBuffer();
                buf.append("select ").append("A.").append(this.scheduleTableSchema.id).append(" as ").append(this.scheduleTableSchema.id).append(',').append("A.").append(this.scheduleTableSchema.masterId).append(" as ").append(this.scheduleTableSchema.masterId).append(',').append("A.").append(this.scheduleTableSchema.date).append(" as ").append(this.scheduleTableSchema.date).append(',').append("A.").append(this.scheduleTableSchema.time).append(" as ").append(this.scheduleTableSchema.time).append(',').append("A.").append(this.scheduleTableSchema.taskName).append(" as ").append(this.scheduleTableSchema.taskName).append(',').append("A.").append(this.scheduleTableSchema.input).append(" as ").append(this.scheduleTableSchema.input).append(',').append("A.").append(this.scheduleTableSchema.output).append(" as ").append(this.scheduleTableSchema.output).append(',').append("A.").append(this.scheduleTableSchema.initialDate).append(" as ").append(this.scheduleTableSchema.initialDate).append(',').append("A.").append(this.scheduleTableSchema.initialTime).append(" as ").append(this.scheduleTableSchema.initialTime).append(',').append("A.").append(this.scheduleTableSchema.retryInterval).append(" as ").append(this.scheduleTableSchema.retryInterval).append(',').append("A.").append(this.scheduleTableSchema.retryEndTime).append(" as ").append(this.scheduleTableSchema.retryEndTime).append(',').append("A.").append(this.scheduleTableSchema.maxDelayTime).append(" as ").append(this.scheduleTableSchema.maxDelayTime).append(',').append("A.").append(this.scheduleTableSchema.state).append(" as ").append(this.scheduleTableSchema.state).append(',').append("A.").append(this.scheduleTableSchema.controlState).append(" as ").append(this.scheduleTableSchema.controlState).append(',').append("A.").append(this.scheduleTableSchema.checkState).append(" as ").append(this.scheduleTableSchema.checkState).append(',').append("A.").append(this.scheduleTableSchema.executorKey).append(" as ").append(this.scheduleTableSchema.executorKey).append(',').append("A.").append(this.scheduleTableSchema.executorType).append(" as ").append(this.scheduleTableSchema.executorType).append(',').append("A.").append(this.scheduleTableSchema.executeStartTime).append(" as ").append(this.scheduleTableSchema.executeStartTime).append(',').append("A.").append(this.scheduleTableSchema.executeEndTime).append(" as ").append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" A, ").append("(select ").append(this.scheduleGroupMasterTableSchema.id).append(" from ").append(this.scheduleGroupMasterTableSchema.table).append(" where ").append(this.scheduleGroupMasterTableSchema.groupId).append("=?) B ").append(" where A.").append(this.scheduleTableSchema.masterId).append("=B.").append(this.scheduleGroupMasterTableSchema.id);
                st = con.prepareStatement(buf.toString());
                st.setString(1, masterGroupId);
            }
            rs = st.executeQuery();
            while (rs.next()) {
                result.add(this.createSchedule(rs));
            }
            this.setDependsOnSchedules(con, result);
            this.setGroupIdsOnSchedules(con, result);
            this.setGroupDependsOnGroupOnSchedules(con, result);
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        catch (ConvertException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List findSchedules(Date date) throws ScheduleManageException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date from = cal.getTime();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        Date to = cal.getTime();
        return this.findSchedules(from, to);
    }

    @Override
    public List findSchedules(Date from, Date to) throws ScheduleManageException {
        return this.findSchedules(from, to, null);
    }

    @Override
    public List findSchedules(int[] states) throws ScheduleManageException {
        return this.findSchedules(null, null, states);
    }

    @Override
    public List findSchedules(Date from, Date to, int[] states) throws ScheduleManageException {
        return this.findSchedules(from, to, states, null, null, null, null, null, false);
    }

    @Override
    public List findSchedules(Date from, Date to, int[] states, String masterId, String masterGroupId, String groupId) throws ScheduleManageException {
        return this.findSchedules(from, to, states, masterId, masterGroupId, groupId, null, null, false);
    }

    protected StringBuffer concatQuery(StringBuffer buf, String s1, String s2) {
        if (this.isUseConcatFunction) {
            buf.append("concat(").append(s1).append(',').append(s2).append(')');
        } else {
            buf.append(s1).append("||").append(s2);
        }
        return buf;
    }

    protected List findSchedules(Date from, Date to, int[] states, String masterId, String masterGroupId, String groupId, String[] executorTypes, String executorKey, boolean isLock) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            int i;
            int i2;
            StringBuffer buf = new StringBuffer();
            buf.append("select ").append("A.").append(this.scheduleTableSchema.id).append(" as ").append(this.scheduleTableSchema.id).append(',').append("A.").append(this.scheduleTableSchema.masterId).append(" as ").append(this.scheduleTableSchema.masterId).append(',').append("A.").append(this.scheduleTableSchema.date).append(" as ").append(this.scheduleTableSchema.date).append(',').append("A.").append(this.scheduleTableSchema.time).append(" as ").append(this.scheduleTableSchema.time).append(',').append("A.").append(this.scheduleTableSchema.taskName).append(" as ").append(this.scheduleTableSchema.taskName).append(',').append("A.").append(this.scheduleTableSchema.input).append(" as ").append(this.scheduleTableSchema.input).append(',').append("A.").append(this.scheduleTableSchema.output).append(" as ").append(this.scheduleTableSchema.output).append(',').append("A.").append(this.scheduleTableSchema.initialDate).append(" as ").append(this.scheduleTableSchema.initialDate).append(',').append("A.").append(this.scheduleTableSchema.initialTime).append(" as ").append(this.scheduleTableSchema.initialTime).append(',').append("A.").append(this.scheduleTableSchema.retryInterval).append(" as ").append(this.scheduleTableSchema.retryInterval).append(',').append("A.").append(this.scheduleTableSchema.retryEndTime).append(" as ").append(this.scheduleTableSchema.retryEndTime).append(',').append("A.").append(this.scheduleTableSchema.maxDelayTime).append(" as ").append(this.scheduleTableSchema.maxDelayTime).append(',').append("A.").append(this.scheduleTableSchema.state).append(" as ").append(this.scheduleTableSchema.state).append(',').append("A.").append(this.scheduleTableSchema.controlState).append(" as ").append(this.scheduleTableSchema.controlState).append(',').append("A.").append(this.scheduleTableSchema.checkState).append(" as ").append(this.scheduleTableSchema.checkState).append(',').append("A.").append(this.scheduleTableSchema.executorKey).append(" as ").append(this.scheduleTableSchema.executorKey).append(',').append("A.").append(this.scheduleTableSchema.executorType).append(" as ").append(this.scheduleTableSchema.executorType).append(',').append("A.").append(this.scheduleTableSchema.executeStartTime).append(" as ").append(this.scheduleTableSchema.executeStartTime).append(',').append("A.").append(this.scheduleTableSchema.executeEndTime).append(" as ").append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" A");
            boolean isAppendWhere = false;
            if (masterGroupId != null || groupId != null) {
                buf.append(", (select ").append(this.scheduleGroupTableSchema.id).append(" from ").append(this.scheduleGroupTableSchema.table);
                if (masterGroupId != null && groupId != null) {
                    buf.append(" where ").append(this.scheduleGroupTableSchema.masterGroupId).append("=?").append(" and ").append(this.scheduleGroupTableSchema.groupId).append("=?) B");
                } else if (masterGroupId != null) {
                    buf.append(" where ").append(this.scheduleGroupTableSchema.masterGroupId).append("=?) B ");
                } else {
                    buf.append(" where ").append(this.scheduleGroupTableSchema.groupId).append("=?) B ");
                }
                buf.append(" where A.").append(this.scheduleTableSchema.id).append("=B.").append(this.scheduleGroupTableSchema.id);
                isAppendWhere = true;
            }
            if (masterId != null) {
                if (!isAppendWhere) {
                    buf.append(" where (");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                buf.append("A.").append(this.scheduleTableSchema.masterId).append("=?)");
            }
            if (executorTypes != null && executorTypes.length != 0) {
                if (!isAppendWhere) {
                    buf.append(" where (");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                buf.append("A.").append(this.scheduleTableSchema.executorType).append(" is null or ");
                for (i2 = 0; i2 < executorTypes.length; ++i2) {
                    buf.append(this.scheduleTableSchema.executorType);
                    buf.append("=?");
                    if (i2 == executorTypes.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(')');
            }
            if (executorKey != null) {
                if (!isAppendWhere) {
                    buf.append(" where (");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                buf.append("A.").append(this.scheduleTableSchema.executorKey).append(" is null or ").append(this.scheduleTableSchema.executorKey).append(" =?)");
            }
            if (states != null && states.length != 0) {
                if (!isAppendWhere) {
                    buf.append(" where (");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                for (i2 = 0; i2 < states.length; ++i2) {
                    buf.append("A.").append(this.scheduleTableSchema.state).append("=?");
                    if (i2 == states.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(')');
            }
            if (from != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                } else {
                    buf.append(" and ");
                }
                this.concatQuery(buf, "A." + this.scheduleTableSchema.date, "A." + this.scheduleTableSchema.time);
                buf.append(">=?");
            }
            if (to != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                } else {
                    buf.append(" and ");
                }
                this.concatQuery(buf, "A." + this.scheduleTableSchema.date, "A." + this.scheduleTableSchema.time);
                buf.append("<=?");
            }
            if (isLock) {
                buf.append(" for update");
            }
            st = con.prepareStatement(buf.toString());
            buf = null;
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            int index = 0;
            if (masterGroupId != null) {
                st.setString(++index, masterGroupId);
            }
            if (groupId != null) {
                st.setString(++index, groupId);
            }
            if (masterId != null) {
                st.setString(++index, masterId);
            }
            if (executorTypes != null && executorTypes.length != 0) {
                for (i = 0; i < executorTypes.length; ++i) {
                    st.setString(++index, executorTypes[i]);
                }
            }
            if (executorKey != null) {
                st.setString(++index, executorKey);
            }
            if (states != null && states.length != 0) {
                for (i = 0; i < states.length; ++i) {
                    st.setString(++index, this.scheduleTableSchema.getStateString(states[i]));
                }
            }
            if (from != null) {
                st.setString(++index, format.format(from));
            }
            if (to != null) {
                st.setString(++index, format.format(to));
            }
            rs = st.executeQuery();
            ArrayList<Schedule> result = new ArrayList<Schedule>();
            while (rs.next()) {
                result.add(this.createSchedule(rs));
            }
            this.setDependsOnSchedules(con, result);
            this.setGroupIdsOnSchedules(con, result);
            this.setGroupDependsOnGroupOnSchedules(con, result);
            Collections.sort(result);
            ArrayList<Schedule> arrayList = result;
            return arrayList;
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        catch (ConvertException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public List findExecutableSchedules(Date date, String[] executorTypes) throws ScheduleManageException {
        return this.findExecutableSchedules(date, executorTypes, null);
    }

    @Override
    public List findExecutableSchedules(Date date, String[] executorTypes, String executorKey) throws ScheduleManageException {
        List result = this.findSchedules(null, date, new int[]{1, 8}, null, null, null, executorTypes, executorKey, this.isLockForFindExecutable);
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st1 = null;
        Statement st1Group = null;
        Statement st1InGroup = null;
        Statement st1GroupOnGroup = null;
        Statement st2 = null;
        Statement st2Group = null;
        Statement st2InGroup = null;
        Statement st2GroupOnGroup = null;
        Statement st3 = null;
        Statement st3Group = null;
        Statement st3InGroup = null;
        Statement st3GroupOnGroup = null;
        ResultSet rs = null;
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("select count(1) from ").append(this.scheduleTableSchema.table).append(" A,").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(',').append(this.scheduleDependsTableSchema.ignoreError).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("=?").append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is null) B").append(" where A.").append(this.scheduleTableSchema.masterId).append("=B.").append(this.scheduleDependsTableSchema.dependsId).append(" and ");
            this.concatQuery(buf, "A." + this.scheduleTableSchema.initialDate, "A." + this.scheduleTableSchema.initialTime).append("<?").append(" and (((B.").append(this.scheduleDependsTableSchema.ignoreError).append("<>'1'").append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (B.").append(this.scheduleDependsTableSchema.ignoreError).append("='1'").append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_FAILED).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_ABORT).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("'))").append(" or (A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_ENTRY).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_RUN).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_PAUSE).append("'))");
            st1 = con.prepareStatement(buf.toString());
            buf.setLength(0);
            buf.append("select count(1) from ").append("(select ").append("C.").append(this.scheduleTableSchema.masterId).append(" as MASTER_ID,").append("C.").append(this.scheduleTableSchema.state).append(" as STATE,").append("C.").append(this.scheduleTableSchema.initialDate).append(" as INITIAL_DATE,").append("C.").append(this.scheduleTableSchema.initialTime).append(" as INITIAL_TIME").append(" from ").append(this.scheduleTableSchema.table).append(" C,").append("(select ").append("A.").append(this.scheduleGroupTableSchema.id).append(" as ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" A,").append("(select ").append(this.scheduleGroupTableSchema.groupId).append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("=?) B").append(" where ").append("A.").append(this.scheduleGroupTableSchema.groupId).append("=B.").append(this.scheduleGroupTableSchema.groupId).append(" and ").append("A.").append(this.scheduleGroupTableSchema.id).append("<>?) D").append(" where ").append("C.").append(this.scheduleTableSchema.id).append("=D.ID) E,").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(" as DEPENDS_ID,").append(this.scheduleDependsTableSchema.ignoreError).append(" as IGNORE_ERROR").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("=?").append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is not null) F").append(" where E.MASTER_ID=F.DEPENDS_ID").append(" and ");
            this.concatQuery(buf, "E.INITIAL_DATE", "E.INITIAL_TIME").append("<?").append(" and (((F.IGNORE_ERROR<>'1'").append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (F.IGNORE_ERROR='1'").append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_FAILED).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_ABORT).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("'))").append(" or (E.STATE='").append(this.scheduleTableSchema.stateString_ENTRY).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_RUN).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_PAUSE).append("'))");
            st1InGroup = con.prepareStatement(buf.toString());
            buf.setLength(0);
            buf.append("select count(1) from ").append("(select distinct E.GROUP_ID from ").append("(select A.GROUP_ID, A.MASTER_GROUP_ID from ").append("(select ").append("AA.").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID,").append("AA.").append(this.scheduleGroupTableSchema.masterGroupId).append(" as MASTER_GROUP_ID,").append("AB.").append(this.scheduleTableSchema.state).append(" as STATE").append(" from ").append(this.scheduleGroupTableSchema.table).append(" AA,").append(this.scheduleTableSchema.table).append(" AB").append(" where AA.").append(this.scheduleGroupTableSchema.id).append("=AB.").append(this.scheduleTableSchema.id).append(") A,").append("(select ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" as MASTER_GROUP_ID,").append(this.scheduleDependsTableSchema.ignoreError).append(" as IGNORE_ERROR").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("=?").append(" and ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" is not null) B").append(" where A.MASTER_GROUP_ID=B.MASTER_GROUP_ID").append(" and ((B.IGNORE_ERROR<>'1'").append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (B.IGNORE_ERROR='1'").append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append('\'').append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_FAILED).append("'))").append(" group by A.GROUP_ID, A.MASTER_GROUP_ID) E,").append("(select ").append("C.").append(this.scheduleGroupTableSchema.id).append(" as ID,").append("C.").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID,").append("C.").append(this.scheduleGroupTableSchema.masterGroupId).append(" as MASTER_GROUP_ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" C,").append("(select ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" as MASTER_GROUP_ID").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("=?").append(" and ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" is not null) D").append(" where C.MASTER_GROUP_ID=D.MASTER_GROUP_ID").append(" and C.ID in (select ").append(this.scheduleTableSchema.id).append(" from ").append(this.scheduleTableSchema.table).append(" where ");
            this.concatQuery(buf, this.scheduleTableSchema.initialDate, this.scheduleTableSchema.initialTime).append("<?)) F").append(" where E.GROUP_ID=F.GROUP_ID").append(" and E.MASTER_GROUP_ID=F.MASTER_GROUP_ID)");
            st1Group = con.prepareStatement(buf.toString());
            buf.setLength(0);
            buf.append("select count(1) from ").append("(select GROUP_ID, IGNORE_ERROR from ").append("(select AB.GROUP_ID as GROUP_ID,").append("AB.IGNORE_ERROR as IGNORE_ERROR").append(" from ").append(this.scheduleTableSchema.table).append(" AA,").append("(select ABA.").append(this.scheduleGroupTableSchema.id).append(" as ID,").append("ABA.").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID,").append("ABB.MASTER_GROUP_ID as MASTER_GROUP_ID,").append("ABB.IGNORE_ERROR as IGNORE_ERROR").append(" from ").append(this.scheduleGroupTableSchema.table).append(" ABA,").append("(select ").append(this.scheduleGroupDependsTableSchema.dependsGroupId).append(" as MASTER_GROUP_ID,").append(this.scheduleGroupDependsTableSchema.ignoreError).append(" as IGNORE_ERROR").append(" from ").append(this.scheduleGroupDependsTableSchema.table).append(" where ").append(this.scheduleGroupDependsTableSchema.groupId).append(" in (select ").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("=?)) ABB").append(" where ABA.MASTER_GROUP_ID=ABB.MASTER_GROUP_ID) AB,").append("(select MAX(INITIAL_DATETIME) as INITIAL_DATETIME from ").append("(select GROUP_ID, MIN(INITIAL_DATETIME) as INITIAL_DATETIME from ").append("(select (");
            this.concatQuery(buf, "ACA." + this.scheduleTableSchema.initialDate, "ACA." + this.scheduleTableSchema.initialTime).append(") as INITIAL_DATETIME,").append("ACB.GROUP_ID as GROUP_ID").append(" from ").append(this.scheduleTableSchema.table).append(" ACA,").append("(select ").append(this.scheduleGroupTableSchema.id).append(" as ID,").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.groupId).append(" in (select ").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("=?)) ACB").append(" where ACA.").append(this.scheduleTableSchema.id).append("=ACB.ID)").append(" group by GROUP_ID)) AC").append(" where (");
            this.concatQuery(buf, "AA." + this.scheduleTableSchema.initialDate, "AA." + this.scheduleTableSchema.initialTime).append(") < AC.INITIAL_DATETIME").append(" and AA.").append(this.scheduleTableSchema.id).append("=AB.ID)").append(" group by GROUP_ID, IGNORE_ERROR) A,").append(this.scheduleTableSchema.table).append(" B,").append(this.scheduleGroupTableSchema.table).append(" C").append(" where A.GROUP_ID=C.").append(this.scheduleGroupTableSchema.groupId).append(" and A.GROUP_ID<>").append("(select ").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("=?)").append(" and B.").append(this.scheduleTableSchema.id).append("=C.").append(this.scheduleGroupTableSchema.id).append(" and ((A.IGNORE_ERROR<>'1'").append(" and B.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and B.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (A.IGNORE_ERROR='1'").append(" and B.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_FAILED).append('\'').append(" and B.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_ABORT).append('\'').append(" and B.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and B.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("'))");
            st1GroupOnGroup = con.prepareStatement(buf.toString());
            buf.setLength(0);
            buf.append("select ID from ((").append("select A.").append(this.scheduleTableSchema.id).append(" as ID from ").append(this.scheduleTableSchema.table).append(" A,").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(',').append(this.scheduleDependsTableSchema.ignoreError).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("=?").append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is null) B").append(" where A.").append(this.scheduleTableSchema.masterId).append("=B.").append(this.scheduleDependsTableSchema.dependsId).append(" and A.").append(this.scheduleTableSchema.id).append("<>?").append(" and ");
            this.concatQuery(buf, "A." + this.scheduleTableSchema.initialDate, "A." + this.scheduleTableSchema.initialTime).append("=?").append(" and (((B.").append(this.scheduleDependsTableSchema.ignoreError).append("<>'1'").append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (B.").append(this.scheduleDependsTableSchema.ignoreError).append("='1'").append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_FAILED).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_ABORT).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("'))").append(" or (A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_ENTRY).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_RUN).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_PAUSE).append("')))").append(" union (select ").append(this.scheduleTableSchema.id).append(" as ID from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append("=?)) C order by ID");
            st2 = con.prepareStatement(buf.toString());
            buf.setLength(0);
            buf.append("select ID from (").append("(select E.ID as ID from ").append("(select ").append("C.").append(this.scheduleTableSchema.id).append(" as ID,").append("C.").append(this.scheduleTableSchema.masterId).append(" as MASTER_ID,").append("C.").append(this.scheduleTableSchema.state).append(" as STATE,").append("C.").append(this.scheduleTableSchema.initialDate).append(" as INITIAL_DATE,").append("C.").append(this.scheduleTableSchema.initialTime).append(" as INITIAL_TIME").append(" from ").append(this.scheduleTableSchema.table).append(" C,").append("(select ").append("A.").append(this.scheduleGroupTableSchema.id).append(" as ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" A,").append("(select ").append(this.scheduleGroupTableSchema.groupId).append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("=?) B").append(" where ").append("A.").append(this.scheduleGroupTableSchema.groupId).append("=B.").append(this.scheduleGroupTableSchema.groupId).append(" and ").append("A.").append(this.scheduleGroupTableSchema.id).append("<>?) D").append(" where ").append("C.").append(this.scheduleTableSchema.id).append("=D.ID) E,").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(" as DEPENDS_ID,").append(this.scheduleDependsTableSchema.ignoreError).append(" as IGNORE_ERROR").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("=?").append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is not null) F").append(" where E.MASTER_ID=F.DEPENDS_ID").append(" and ");
            this.concatQuery(buf, "E.INITIAL_DATE", "E.INITIAL_TIME").append("=?").append(" and (((F.IGNORE_ERROR<>'1'").append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (F.IGNORE_ERROR='1'").append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_FAILED).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_ABORT).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("'))").append(" or (E.STATE='").append(this.scheduleTableSchema.stateString_ENTRY).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_RUN).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_PAUSE).append("')))").append(" union (select ").append(this.scheduleTableSchema.id).append(" as ID from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append("=?))").append(" order by ID");
            st2InGroup = con.prepareStatement(buf.toString());
            buf.setLength(0);
            buf.append("select ID from ").append("(select F.ID from ").append("(select A.GROUP_ID, A.MASTER_GROUP_ID from ").append("(select ").append("AA.").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID,").append("AA.").append(this.scheduleGroupTableSchema.masterGroupId).append(" as MASTER_GROUP_ID,").append("AB.").append(this.scheduleTableSchema.state).append(" as STATE").append(" from ").append(this.scheduleGroupTableSchema.table).append(" AA,").append(this.scheduleTableSchema.table).append(" AB").append(" where AA.").append(this.scheduleGroupTableSchema.id).append("=AB.").append(this.scheduleTableSchema.id).append(") A,").append("(select ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" as MASTER_GROUP_ID,").append(this.scheduleDependsTableSchema.ignoreError).append(" as IGNORE_ERROR").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("=?").append(" and ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" is not null) B").append(" where A.MASTER_GROUP_ID=B.MASTER_GROUP_ID").append(" and ((B.IGNORE_ERROR<>'1'").append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (B.IGNORE_ERROR='1'").append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append('\'').append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_FAILED).append("'))").append(" group by A.GROUP_ID, A.MASTER_GROUP_ID) E,").append("(select ").append("C.").append(this.scheduleGroupTableSchema.id).append(" as ID,").append("C.").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID,").append("C.").append(this.scheduleGroupTableSchema.masterGroupId).append(" as MASTER_GROUP_ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" C,").append("(select ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" as MASTER_GROUP_ID").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("=?").append(" and ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" is not null) D").append(" where C.MASTER_GROUP_ID=D.MASTER_GROUP_ID").append(" and C.ID in (select ").append(this.scheduleTableSchema.id).append(" from ").append(this.scheduleTableSchema.table).append(" where ");
            this.concatQuery(buf, this.scheduleTableSchema.initialDate, this.scheduleTableSchema.initialTime).append("=?)) F").append(" where E.GROUP_ID=F.GROUP_ID").append(" and E.MASTER_GROUP_ID=F.MASTER_GROUP_ID) union (select ").append(this.scheduleTableSchema.id).append(" as ID from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append("=?) order by ID");
            st2Group = con.prepareStatement(buf.toString());
            buf.setLength(0);
            buf.append("select OWN_GROUP_ID,OWN_GROUP_MASTER_ID,DEPENDS_GROUP_ID ").append("from (").append("select A.OWN_GROUP_ID as OWN_GROUP_ID,").append("A.OWN_GROUP_MASTER_ID as OWN_GROUP_MASTER_ID,").append("A.DEPENDS_GROUP_ID as DEPENDS_GROUP_ID ").append("from (").append("select AA.ID as ID, ").append("AB.OWN_GROUP_ID as OWN_GROUP_ID,").append("AB.DEPENDS_GROUP_ID as DEPENDS_GROUP_ID, ").append("AC.GROUP_MASTER_ID as OWN_GROUP_MASTER_ID,").append("AB.GROUP_MASTER_ID as GROUP_MASTER_ID,").append("AB.IGNORE_ERROR as IGNORE_ERROR ").append("from ").append(this.scheduleGroupTableSchema.table).append(" AA,").append("(").append("select OWN_GROUP_ID as OWN_GROUP_ID,").append("DEPENDS_GROUP_ID as DEPENDS_GROUP_ID, ").append("GROUP_MASTER_ID as GROUP_MASTER_ID,").append("IGNORE_ERROR as IGNORE_ERROR, ").append("MIN(INITIAL_DATETIME) as INITIAL_DATETIME ").append("from ").append("(").append("select ABA.").append(this.scheduleGroupTableSchema.id).append(" as ID, ").append("ABB.GROUP_ID as OWN_GROUP_ID, ").append("ABA.").append(this.scheduleGroupTableSchema.groupId).append(" as DEPENDS_GROUP_ID, ").append("ABB.GROUP_MASTER_ID as GROUP_MASTER_ID, ").append("ABB.IGNORE_ERROR as IGNORE_ERROR,").append("(");
            this.concatQuery(buf, "ABC.INITIAL_DATE", "ABC.INITIAL_TIME").append(") as INITIAL_DATETIME ").append("from ").append(this.scheduleGroupTableSchema.table).append(" ABA,").append("(").append("select ").append(this.scheduleGroupDependsTableSchema.groupId).append(" as GROUP_ID, ").append(this.scheduleGroupDependsTableSchema.dependsGroupId).append(" as GROUP_MASTER_ID,").append(this.scheduleGroupDependsTableSchema.ignoreError).append(" as IGNORE_ERROR ").append("from ").append(this.scheduleGroupDependsTableSchema.table).append(' ').append("where ").append(this.scheduleGroupDependsTableSchema.groupId).append(" in ").append("(").append("select ").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID ").append("from ").append(this.scheduleGroupTableSchema.table).append(' ').append("where ").append(this.scheduleGroupTableSchema.id).append("=?").append(")").append(") ABB,").append(this.scheduleTableSchema.table).append(" ABC ").append("where ABA.").append(this.scheduleGroupTableSchema.masterGroupId).append("=ABB.GROUP_MASTER_ID ").append("and ABA.ID=ABC.ID and ABB.GROUP_ID<>ABA.").append(this.scheduleGroupTableSchema.groupId).append(")").append("group by OWN_GROUP_ID, DEPENDS_GROUP_ID, GROUP_MASTER_ID, IGNORE_ERROR").append(") AB,").append("(").append("select GROUP_ID, GROUP_MASTER_ID, MIN(INITIAL_DATETIME) as INITIAL_DATETIME ").append("from (").append("select (");
            this.concatQuery(buf, "ACA.INITIAL_DATE", "ACA.INITIAL_TIME").append(") as INITIAL_DATETIME, ").append("ACB.GROUP_ID as GROUP_ID, ACB.GROUP_MASTER_ID as GROUP_MASTER_ID ").append("from ").append(this.scheduleTableSchema.table).append(" ACA, ").append("(").append("select ").append(this.scheduleGroupTableSchema.id).append(" as ID,").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID,").append(this.scheduleGroupTableSchema.masterGroupId).append(" as GROUP_MASTER_ID ").append("from ").append(this.scheduleGroupTableSchema.table).append(' ').append("where ").append(this.scheduleGroupTableSchema.groupId).append(" in (").append("select ").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID ").append("from ").append(this.scheduleGroupTableSchema.table).append(' ').append("where ").append(this.scheduleGroupTableSchema.id).append("=?").append(")").append(") ACB ").append("where ACA.ID=ACB.ID ").append(")").append("group by GROUP_ID, GROUP_MASTER_ID").append(") AC ").append("where AB.INITIAL_DATETIME=AC.INITIAL_DATETIME ").append("and AA.").append(this.scheduleGroupTableSchema.groupId).append("=AB.DEPENDS_GROUP_ID").append(") A,").append(this.scheduleTableSchema.table).append(" B ").append("where A.ID=B.ID ").append("and ").append("(").append("(").append("A.IGNORE_ERROR<>'1' ").append("and B.STATE<>'").append(this.scheduleTableSchema.stateString_END).append("' ").append("and B.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("') ").append("or (A.IGNORE_ERROR='1' ").append("and B.STATE<>'").append(this.scheduleTableSchema.stateString_END).append("' ").append("and B.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("' ").append("and B.STATE<>'").append(this.scheduleTableSchema.stateString_ABORT).append("' ").append("and B.STATE<>'").append(this.scheduleTableSchema.stateString_FAILED).append("') ").append(") ").append("group by A.OWN_GROUP_ID,A.OWN_GROUP_MASTER_ID,A.DEPENDS_GROUP_ID ").append("union ").append("select ").append(this.scheduleGroupTableSchema.groupId).append(" as OWN_GROUP_ID,").append(this.scheduleGroupTableSchema.masterGroupId).append(" as GROUP_MASTER_ID,").append(this.scheduleGroupTableSchema.groupId).append(" as DEPENDS_GROUP_ID ").append("from ").append(this.scheduleGroupTableSchema.table).append(' ').append("where ").append(this.scheduleGroupTableSchema.id).append("=? ").append(")").append("order by OWN_GROUP_ID, DEPENDS_GROUP_ID");
            st2GroupOnGroup = con.prepareStatement(buf.toString());
            buf.setLength(0);
            buf.append("select count(1) from ").append("(select A.").append(this.scheduleTableSchema.id).append(" from ").append(this.scheduleTableSchema.table).append(" A,").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(',').append(this.scheduleDependsTableSchema.ignoreError).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("=?").append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is null) B").append(" where A.").append(this.scheduleTableSchema.masterId).append("=B.").append(this.scheduleDependsTableSchema.dependsId).append(" and A.").append(this.scheduleTableSchema.id).append("<>?").append(" and ");
            this.concatQuery(buf, "A." + this.scheduleTableSchema.initialDate, "A." + this.scheduleTableSchema.initialTime).append("=?").append(" and (((B.").append(this.scheduleDependsTableSchema.ignoreError).append("<>'1'").append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (B.").append(this.scheduleDependsTableSchema.ignoreError).append("='1'").append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_FAILED).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_ABORT).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("'))").append(" or (A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_ENTRY).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_RUN).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_PAUSE).append("'))) C,").append("(select ").append(this.scheduleDependsTableSchema.id).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.dependsId).append("=?) D").append(" where C.").append(this.scheduleTableSchema.id).append("=D.").append(this.scheduleDependsTableSchema.id);
            st3 = con.prepareStatement(buf.toString());
            buf.setLength(0);
            buf.append("select count(1) from ").append("(select E.ID as ID from ").append("(select ").append("C.").append(this.scheduleTableSchema.id).append(" as ID,").append("C.").append(this.scheduleTableSchema.masterId).append(" as MASTER_ID,").append("C.").append(this.scheduleTableSchema.state).append(" as STATE,").append("C.").append(this.scheduleTableSchema.initialDate).append(" as INITIAL_DATE,").append("C.").append(this.scheduleTableSchema.initialTime).append(" as INITIAL_TIME").append(" from ").append(this.scheduleTableSchema.table).append(" C,").append("(select ").append("A.").append(this.scheduleGroupTableSchema.id).append(" as ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" A,").append("(select ").append(this.scheduleGroupTableSchema.groupId).append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("=?) B").append(" where ").append("A.").append(this.scheduleGroupTableSchema.groupId).append("=B.").append(this.scheduleGroupTableSchema.groupId).append(" and ").append("A.").append(this.scheduleGroupTableSchema.id).append("<>?) D").append(" where ").append("C.").append(this.scheduleTableSchema.id).append("=D.ID) E,").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(" as DEPENDS_ID,").append(this.scheduleDependsTableSchema.ignoreError).append(" as IGNORE_ERROR").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("=?").append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is not null) F").append(" where E.MASTER_ID=F.DEPENDS_ID").append(" and E.ID<>?").append(" and ((((F.IGNORE_ERROR<>'1'").append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (F.IGNORE_ERROR='1'").append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_FAILED).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_ABORT).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("'))").append(" and ");
            this.concatQuery(buf, "E.INITIAL_DATE", "E.INITIAL_TIME").append("=?)").append(" or (E.STATE='").append(this.scheduleTableSchema.stateString_ENTRY).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_RUN).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_PAUSE).append("'))) G,").append("(select ").append(this.scheduleDependsTableSchema.id).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.dependsId).append("=?) H").append(" where G.ID=H.").append(this.scheduleDependsTableSchema.id);
            st3InGroup = con.prepareStatement(buf.toString());
            buf.setLength(0);
            buf.append("select count(1) from ").append("(select A.ID from ").append(this.scheduleTableSchema.table).append(" A,").append("(select ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" as MASTER_GROUP_ID").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("=?").append(" and ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" is not null)B,").append(this.scheduleGroupTableSchema.table).append(" C").append(" where B.MASTER_GROUP_ID=C.").append(this.scheduleGroupTableSchema.masterGroupId).append(" and A.ID=C.").append(this.scheduleGroupTableSchema.id).append(" and A.ID<>? ").append(" and ");
            this.concatQuery(buf, "A." + this.scheduleTableSchema.initialDate, "A." + this.scheduleTableSchema.initialTime).append("=?").append(" and A.STATE='").append(this.scheduleTableSchema.stateString_INITIAL).append("')");
            st3Group = con.prepareStatement(buf.toString());
            st3GroupOnGroup = con.createStatement();
            buf = null;
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            Iterator itr = result.iterator();
            String initialTime = null;
            HashMap<String, Boolean> isTopGroupMasterIDMap = null;
            HashMap dependsGroupMap = null;
            while (itr.hasNext()) {
                Map dependsGroupIdMap;
                int num;
                boolean isTop;
                int paramIndex = 1;
                Schedule schedule = (Schedule)itr.next();
                if (schedule.getDepends() == null && schedule.getDependsInGroupMap().size() == 0 && schedule.getDependsOnGroup() == null && schedule.getGroupDependsOnGroupMap().size() == 0) continue;
                initialTime = format.format(schedule.getInitialTime() == null ? schedule.getTime() : schedule.getInitialTime());
                if (schedule.getDepends() != null) {
                    st1.setString(paramIndex++, schedule.getId());
                    st1.setString(paramIndex++, initialTime);
                    rs = st1.executeQuery();
                    rs.next();
                    if (rs.getInt(1) != 0) {
                        itr.remove();
                        rs.close();
                        continue;
                    }
                    rs.close();
                    paramIndex = 1;
                    st2.setString(paramIndex++, schedule.getId());
                    st2.setString(paramIndex++, schedule.getId());
                    st2.setString(paramIndex++, initialTime);
                    st2.setString(paramIndex++, schedule.getId());
                    rs = st2.executeQuery();
                    rs.next();
                    isTop = schedule.getId().equals(rs.getString(1));
                    num = 0;
                    while (rs.next()) {
                        ++num;
                    }
                    rs.close();
                    if (num != 0) {
                        if (!isTop) {
                            itr.remove();
                            rs.close();
                            continue;
                        }
                        paramIndex = 1;
                        st3.setString(paramIndex++, schedule.getId());
                        st3.setString(paramIndex++, schedule.getId());
                        st3.setString(paramIndex++, initialTime);
                        st3.setString(paramIndex++, schedule.getMasterId());
                        rs = st3.executeQuery();
                        rs.next();
                        if (rs.getInt(1) < num) {
                            itr.remove();
                            rs.close();
                            continue;
                        }
                        rs.close();
                    }
                }
                if (schedule.getDependsInGroupMap().size() != 0) {
                    paramIndex = 1;
                    st1InGroup.setString(paramIndex++, schedule.getId());
                    st1InGroup.setString(paramIndex++, initialTime);
                    st1InGroup.setString(paramIndex++, schedule.getId());
                    st1InGroup.setString(paramIndex++, initialTime);
                    rs = st1InGroup.executeQuery();
                    rs.next();
                    if (rs.getInt(1) != 0) {
                        itr.remove();
                        rs.close();
                        continue;
                    }
                    rs.close();
                    paramIndex = 1;
                    st2InGroup.setString(paramIndex++, schedule.getId());
                    st2InGroup.setString(paramIndex++, schedule.getId());
                    st2InGroup.setString(paramIndex++, schedule.getId());
                    st2InGroup.setString(paramIndex++, initialTime);
                    st2InGroup.setString(paramIndex++, schedule.getId());
                    rs = st2InGroup.executeQuery();
                    rs.next();
                    isTop = schedule.getId().equals(rs.getString(1));
                    num = 0;
                    while (rs.next()) {
                        ++num;
                    }
                    rs.close();
                    if (num != 0) {
                        if (!isTop) {
                            itr.remove();
                            rs.close();
                            continue;
                        }
                        paramIndex = 1;
                        st3InGroup.setString(paramIndex++, schedule.getId());
                        st3InGroup.setString(paramIndex++, schedule.getId());
                        st3InGroup.setString(paramIndex++, schedule.getId());
                        st3InGroup.setString(paramIndex++, schedule.getId());
                        st3InGroup.setString(paramIndex++, initialTime);
                        st3InGroup.setString(paramIndex++, schedule.getMasterId());
                        rs = st3InGroup.executeQuery();
                        rs.next();
                        if (rs.getInt(1) < num) {
                            itr.remove();
                            rs.close();
                            continue;
                        }
                        rs.close();
                    }
                }
                if (schedule.getDependsOnGroup() != null) {
                    paramIndex = 1;
                    st1Group.setString(paramIndex++, schedule.getId());
                    st1Group.setString(paramIndex++, schedule.getId());
                    st1Group.setString(paramIndex++, initialTime);
                    rs = st1Group.executeQuery();
                    rs.next();
                    if (rs.getInt(1) != 0) {
                        itr.remove();
                        rs.close();
                        continue;
                    }
                    rs.close();
                    paramIndex = 1;
                    st2Group.setString(paramIndex++, schedule.getId());
                    st2Group.setString(paramIndex++, schedule.getId());
                    st2Group.setString(paramIndex++, initialTime);
                    st2Group.setString(paramIndex++, schedule.getId());
                    rs = st2Group.executeQuery();
                    rs.next();
                    isTop = schedule.getId().equals(rs.getString(1));
                    num = 0;
                    while (rs.next()) {
                        ++num;
                    }
                    rs.close();
                    if (num != 0) {
                        if (!isTop) {
                            itr.remove();
                            rs.close();
                            continue;
                        }
                        paramIndex = 1;
                        st3Group.setString(paramIndex++, schedule.getId());
                        st3Group.setString(paramIndex++, schedule.getId());
                        st3Group.setString(paramIndex++, initialTime);
                        rs = st3Group.executeQuery();
                        rs.next();
                        if (rs.getInt(1) < num) {
                            itr.remove();
                            rs.close();
                            continue;
                        }
                        rs.close();
                    }
                }
                if (schedule.getGroupDependsOnGroupMap().size() == 0) continue;
                paramIndex = 1;
                st1GroupOnGroup.setString(paramIndex++, schedule.getId());
                st1GroupOnGroup.setString(paramIndex++, schedule.getId());
                st1GroupOnGroup.setString(paramIndex++, schedule.getId());
                rs = st1GroupOnGroup.executeQuery();
                rs.next();
                if (rs.getInt(1) != 0) {
                    itr.remove();
                    rs.close();
                    continue;
                }
                rs.close();
                paramIndex = 1;
                st2GroupOnGroup.setString(paramIndex++, schedule.getId());
                st2GroupOnGroup.setString(paramIndex++, schedule.getId());
                st2GroupOnGroup.setString(paramIndex++, schedule.getId());
                rs = st2GroupOnGroup.executeQuery();
                String ownGroupId = null;
                if (isTopGroupMasterIDMap == null) {
                    isTopGroupMasterIDMap = new HashMap<String, Boolean>();
                } else {
                    isTopGroupMasterIDMap.clear();
                }
                if (dependsGroupMap == null) {
                    dependsGroupMap = new HashMap();
                } else {
                    dependsGroupMap.clear();
                }
                boolean isIncludeFirst = false;
                while (rs.next()) {
                    String ownGroupIdTmp = rs.getString(1);
                    String dependsGroupId = rs.getString(3);
                    String ownGroupMasterId = rs.getString(2);
                    if (ownGroupId == null || !ownGroupId.equals(ownGroupIdTmp)) {
                        ownGroupId = ownGroupIdTmp;
                        if (ownGroupId.equals(dependsGroupId)) {
                            isTopGroupMasterIDMap.put(ownGroupMasterId, Boolean.TRUE);
                            isIncludeFirst = true;
                        } else {
                            isTopGroupMasterIDMap.put(ownGroupMasterId, Boolean.FALSE);
                        }
                    }
                    if (ownGroupId.equals(dependsGroupId)) continue;
                    dependsGroupIdMap = (LinkedHashMap<String, Boolean>)dependsGroupMap.get(ownGroupMasterId);
                    if (dependsGroupIdMap == null) {
                        dependsGroupIdMap = new LinkedHashMap<String, Boolean>();
                    }
                    dependsGroupIdMap.put(dependsGroupId, Boolean.FALSE);
                    dependsGroupMap.put(ownGroupMasterId, dependsGroupIdMap);
                }
                rs.close();
                rs = null;
                if (!isIncludeFirst) {
                    itr.remove();
                    continue;
                }
                buf = new StringBuffer();
                isTopGroupMasterIDMap.keySet().retainAll(dependsGroupMap.keySet());
                Iterator itrGroupMasterIdSet = isTopGroupMasterIDMap.keySet().iterator();
                boolean isRemove = false;
                while (itrGroupMasterIdSet.hasNext()) {
                    if (isRemove) continue;
                    String groupMasterId = (String)itrGroupMasterIdSet.next();
                    dependsGroupIdMap = (Map)dependsGroupMap.get(groupMasterId);
                    Iterator itrDependsGroupID = dependsGroupIdMap.keySet().iterator();
                    buf.setLength(0);
                    buf.append("select ").append(this.scheduleGroupDependsTableSchema.groupId).append(" from ").append(this.scheduleGroupDependsTableSchema.table).append(" where ").append(this.scheduleGroupDependsTableSchema.dependsGroupId).append("='").append(groupMasterId).append('\'').append(" and ").append(this.scheduleGroupDependsTableSchema.groupId).append(" in (");
                    while (itrDependsGroupID.hasNext()) {
                        buf.append('\'').append((String)itrDependsGroupID.next()).append('\'');
                        if (!itrDependsGroupID.hasNext()) continue;
                        buf.append(",");
                    }
                    buf.append(")");
                    rs = st3GroupOnGroup.executeQuery(buf.toString());
                    int bothDependsCount = 0;
                    while (rs.next()) {
                        String dependsGroupID = rs.getString(1);
                        ((Map)dependsGroupMap.get(groupMasterId)).put(dependsGroupID, Boolean.TRUE);
                        ++bothDependsCount;
                    }
                    rs.close();
                    rs = null;
                    if (((Boolean)isTopGroupMasterIDMap.get(groupMasterId)).booleanValue()) {
                        if (bothDependsCount == dependsGroupIdMap.size()) continue;
                        isRemove = true;
                        itr.remove();
                        continue;
                    }
                    Map dependsMap = (Map)dependsGroupMap.get(groupMasterId);
                    Iterator itrDependsID = dependsMap.keySet().iterator();
                    while (itrDependsID.hasNext()) {
                        if (((Boolean)dependsMap.get(itrDependsID.next())).booleanValue()) continue;
                    }
                }
                buf = null;
            }
            Collections.sort(result);
            List list = result;
            return list;
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st1 != null) {
                try {
                    st1.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st2 != null) {
                try {
                    st2.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st3 != null) {
                try {
                    st3.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st1InGroup != null) {
                try {
                    st1InGroup.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st2InGroup != null) {
                try {
                    st2InGroup.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st2Group != null) {
                try {
                    st2Group.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st3InGroup != null) {
                try {
                    st3InGroup.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st1Group != null) {
                try {
                    st1Group.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st2Group != null) {
                try {
                    st2Group.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st3Group != null) {
                try {
                    st3Group.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st1GroupOnGroup != null) {
                try {
                    st1GroupOnGroup.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st2GroupOnGroup != null) {
                try {
                    st2GroupOnGroup.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st3GroupOnGroup != null) {
                try {
                    st3GroupOnGroup.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List findDependsSchedules(String id) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            boolean findMe;
            HashMap<String, Schedule> doubtSchedules;
            StringBuffer buf = new StringBuffer();
            buf.append("select * from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append("='").append(id).append('\'');
            st = con.createStatement();
            rs = st.executeQuery(buf.toString());
            ArrayList<Schedule> result = new ArrayList<Schedule>();
            if (!rs.next()) {
                ArrayList<Schedule> arrayList = result;
                return arrayList;
            }
            Schedule schedule = this.createSchedule(rs);
            rs.close();
            rs = null;
            if (schedule.getDepends() == null && schedule.getDependsInGroupMap().size() == 0 && schedule.getDependsOnGroup() == null && schedule.getGroupDependsOnGroupMap().size() == 0) {
                ArrayList<Schedule> arrayList = result;
                return arrayList;
            }
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            String initialTime = format.format(schedule.getInitialTime() == null ? schedule.getTime() : schedule.getInitialTime());
            if (schedule.getDepends() != null) {
                buf.setLength(0);
                buf.append("select ").append("A.").append(this.scheduleTableSchema.id).append(" as ").append(this.scheduleTableSchema.id).append(',').append("A.").append(this.scheduleTableSchema.masterId).append(" as ").append(this.scheduleTableSchema.masterId).append(',').append("A.").append(this.scheduleTableSchema.date).append(" as ").append(this.scheduleTableSchema.date).append(',').append("A.").append(this.scheduleTableSchema.time).append(" as ").append(this.scheduleTableSchema.time).append(',').append("A.").append(this.scheduleTableSchema.taskName).append(" as ").append(this.scheduleTableSchema.taskName).append(',').append("A.").append(this.scheduleTableSchema.input).append(" as ").append(this.scheduleTableSchema.input).append(',').append("A.").append(this.scheduleTableSchema.output).append(" as ").append(this.scheduleTableSchema.output).append(',').append("A.").append(this.scheduleTableSchema.initialDate).append(" as ").append(this.scheduleTableSchema.initialDate).append(',').append("A.").append(this.scheduleTableSchema.initialTime).append(" as ").append(this.scheduleTableSchema.initialTime).append(',').append("A.").append(this.scheduleTableSchema.retryInterval).append(" as ").append(this.scheduleTableSchema.retryInterval).append(',').append("A.").append(this.scheduleTableSchema.retryEndTime).append(" as ").append(this.scheduleTableSchema.retryEndTime).append(',').append("A.").append(this.scheduleTableSchema.maxDelayTime).append(" as ").append(this.scheduleTableSchema.maxDelayTime).append(',').append("A.").append(this.scheduleTableSchema.state).append(" as ").append(this.scheduleTableSchema.state).append(',').append("A.").append(this.scheduleTableSchema.controlState).append(" as ").append(this.scheduleTableSchema.controlState).append(',').append("A.").append(this.scheduleTableSchema.checkState).append(" as ").append(this.scheduleTableSchema.checkState).append(',').append("A.").append(this.scheduleTableSchema.executorKey).append(" as ").append(this.scheduleTableSchema.executorKey).append(',').append("A.").append(this.scheduleTableSchema.executorType).append(" as ").append(this.scheduleTableSchema.executorType).append(',').append("A.").append(this.scheduleTableSchema.executeStartTime).append(" as ").append(this.scheduleTableSchema.executeStartTime).append(',').append("A.").append(this.scheduleTableSchema.executeEndTime).append(" as ").append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" A, ").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(',').append(this.scheduleDependsTableSchema.ignoreError).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("='").append(id).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is null) B").append(" where A.").append(this.scheduleTableSchema.masterId).append("=B.").append(this.scheduleDependsTableSchema.dependsId).append(" and A.").append(this.scheduleTableSchema.id).append("<>'").append(id).append('\'').append(" and ((((B.").append(this.scheduleDependsTableSchema.ignoreError).append("<>'1'").append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (B." + this.scheduleDependsTableSchema.ignoreError).append("='1'").append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_FAILED).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_ABORT).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("'))").append(" and ");
                this.concatQuery(buf, "A." + this.scheduleTableSchema.initialDate, "A." + this.scheduleTableSchema.initialTime).append("<'").append(initialTime).append("')").append(" or (A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_ENTRY).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_RUN).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_PAUSE).append("'))");
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    result.add(this.createSchedule(rs));
                }
                rs.close();
                rs = null;
                buf.setLength(0);
                buf.append("select * from (").append("(select ").append("A.").append(this.scheduleTableSchema.id).append(" as ").append(this.scheduleTableSchema.id).append(',').append("A.").append(this.scheduleTableSchema.masterId).append(" as ").append(this.scheduleTableSchema.masterId).append(',').append("A.").append(this.scheduleTableSchema.date).append(" as ").append(this.scheduleTableSchema.date).append(',').append("A.").append(this.scheduleTableSchema.time).append(" as ").append(this.scheduleTableSchema.time).append(',').append("A.").append(this.scheduleTableSchema.taskName).append(" as ").append(this.scheduleTableSchema.taskName).append(',').append("A.").append(this.scheduleTableSchema.input).append(" as ").append(this.scheduleTableSchema.input).append(',').append("A.").append(this.scheduleTableSchema.output).append(" as ").append(this.scheduleTableSchema.output).append(',').append("A.").append(this.scheduleTableSchema.initialDate).append(" as ").append(this.scheduleTableSchema.initialDate).append(',').append("A.").append(this.scheduleTableSchema.initialTime).append(" as ").append(this.scheduleTableSchema.initialTime).append(',').append("A.").append(this.scheduleTableSchema.retryInterval).append(" as ").append(this.scheduleTableSchema.retryInterval).append(',').append("A.").append(this.scheduleTableSchema.retryEndTime).append(" as ").append(this.scheduleTableSchema.retryEndTime).append(',').append("A.").append(this.scheduleTableSchema.maxDelayTime).append(" as ").append(this.scheduleTableSchema.maxDelayTime).append(',').append("A.").append(this.scheduleTableSchema.state).append(" as ").append(this.scheduleTableSchema.state).append(',').append("A.").append(this.scheduleTableSchema.controlState).append(" as ").append(this.scheduleTableSchema.controlState).append(',').append("A.").append(this.scheduleTableSchema.checkState).append(" as ").append(this.scheduleTableSchema.checkState).append(',').append("A.").append(this.scheduleTableSchema.executorKey).append(" as ").append(this.scheduleTableSchema.executorKey).append(',').append("A.").append(this.scheduleTableSchema.executorType).append(" as ").append(this.scheduleTableSchema.executorType).append(',').append("A.").append(this.scheduleTableSchema.executeStartTime).append(" as ").append(this.scheduleTableSchema.executeStartTime).append(',').append("A.").append(this.scheduleTableSchema.executeEndTime).append(" as ").append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" A,").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(',').append(this.scheduleDependsTableSchema.ignoreError).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("='").append(id).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is null) B").append(" where A.").append(this.scheduleTableSchema.masterId).append("=B.").append(this.scheduleDependsTableSchema.dependsId).append(" and ((((B.").append(this.scheduleDependsTableSchema.ignoreError).append("<>'1'").append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (B." + this.scheduleDependsTableSchema.ignoreError).append("='1'").append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_FAILED).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_ABORT).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("'))").append(" and ");
                this.concatQuery(buf, "A." + this.scheduleTableSchema.initialDate, "A." + this.scheduleTableSchema.initialTime).append("='").append(initialTime).append("')").append(" or (A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_ENTRY).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_RUN).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_PAUSE).append("')))").append(" union (select ").append(this.scheduleTableSchema.id).append(',').append(this.scheduleTableSchema.masterId).append(',').append(this.scheduleTableSchema.date).append(',').append(this.scheduleTableSchema.time).append(',').append(this.scheduleTableSchema.taskName).append(',').append(this.scheduleTableSchema.input).append(',').append(this.scheduleTableSchema.output).append(',').append(this.scheduleTableSchema.initialDate).append(',').append(this.scheduleTableSchema.initialTime).append(',').append(this.scheduleTableSchema.retryInterval).append(',').append(this.scheduleTableSchema.retryEndTime).append(',').append(this.scheduleTableSchema.maxDelayTime).append(',').append(this.scheduleTableSchema.state).append(',').append(this.scheduleTableSchema.controlState).append(',').append(this.scheduleTableSchema.checkState).append(',').append(this.scheduleTableSchema.executorKey).append(',').append(this.scheduleTableSchema.executorType).append(',').append(this.scheduleTableSchema.executeStartTime).append(',').append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append("='").append(id).append("'))").append(" order by ").append(this.scheduleTableSchema.id);
                rs = st.executeQuery(buf.toString());
                doubtSchedules = new HashMap<String, Schedule>();
                findMe = false;
                while (rs.next()) {
                    if (!findMe) {
                        findMe = id.equals(rs.getString(1));
                        if (findMe) continue;
                        result.add(this.createSchedule(rs));
                        continue;
                    }
                    doubtSchedules.put(rs.getString(1), this.createSchedule(rs));
                }
                rs.close();
                rs = null;
                buf.setLength(0);
                buf.append("select C.").append(this.scheduleTableSchema.id).append(" from ").append("(select A.").append(this.scheduleTableSchema.id).append(" from ").append(this.scheduleTableSchema.table).append(" A,").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(',').append(this.scheduleDependsTableSchema.ignoreError).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("='").append(id).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is null) B").append(" where A.").append(this.scheduleTableSchema.masterId).append("=B.").append(this.scheduleDependsTableSchema.dependsId).append(" and A.").append(this.scheduleTableSchema.id).append("<>'").append(id).append('\'').append(" and ((((B.").append(this.scheduleDependsTableSchema.ignoreError).append("<>'1'").append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (B." + this.scheduleDependsTableSchema.ignoreError).append("='1'").append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_FAILED).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_ABORT).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("'))").append(" and ");
                this.concatQuery(buf, "A." + this.scheduleTableSchema.initialDate, "A." + this.scheduleTableSchema.initialTime).append("='").append(initialTime).append("')").append(" or (A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_ENTRY).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_RUN).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_PAUSE).append("'))) C,").append(" (select ").append(this.scheduleTableSchema.id).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.dependsId).append("='").append(schedule.getMasterId()).append("') D").append(" where C.").append(this.scheduleTableSchema.id).append("=D.").append(this.scheduleDependsTableSchema.id);
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    doubtSchedules.remove(rs.getString(1));
                }
                rs.close();
                rs = null;
                if (doubtSchedules.size() != 0) {
                    result.addAll(doubtSchedules.values());
                }
            }
            if (schedule.getDependsInGroupMap().size() != 0) {
                buf.setLength(0);
                buf.append("select ").append("E.ID as ").append(this.scheduleTableSchema.id).append(',').append("E.MASTER_ID as ").append(this.scheduleTableSchema.masterId).append(',').append("E.S_DATE as ").append(this.scheduleTableSchema.date).append(',').append("E.S_TIME as ").append(this.scheduleTableSchema.time).append(',').append("E.TASK_NAME as ").append(this.scheduleTableSchema.taskName).append(',').append("E.INPUT as ").append(this.scheduleTableSchema.input).append(',').append("E.OUTPUT as ").append(this.scheduleTableSchema.output).append(',').append("E.INITIAL_DATE as ").append(this.scheduleTableSchema.initialDate).append(',').append("E.INITIAL_TIME as ").append(this.scheduleTableSchema.initialTime).append(',').append("E.RETRY_INTERVAL as ").append(this.scheduleTableSchema.retryInterval).append(',').append("E.RETRY_END_TIME as ").append(this.scheduleTableSchema.retryEndTime).append(',').append("E.MAX_DELAY_TIME as ").append(this.scheduleTableSchema.maxDelayTime).append(',').append("E.STATE as ").append(this.scheduleTableSchema.state).append(',').append("E.CONTROL_STATE as ").append(this.scheduleTableSchema.controlState).append(',').append("E.CHECK_STATE as ").append(this.scheduleTableSchema.checkState).append(',').append("E.EXECUTOR_KEY as ").append(this.scheduleTableSchema.executorKey).append(',').append("E.EXECUTOR_TYPE as ").append(this.scheduleTableSchema.executorType).append(',').append("E.EXEC_S_TIME as ").append(this.scheduleTableSchema.executeStartTime).append(',').append("E.EXEC_E_TIME as ").append(this.scheduleTableSchema.executeEndTime).append(" from ").append("(select ").append("C.").append(this.scheduleTableSchema.id).append(" as ID,").append("C.").append(this.scheduleTableSchema.masterId).append(" as MASTER_ID,").append("C.").append(this.scheduleTableSchema.date).append(" as S_DATE,").append("C.").append(this.scheduleTableSchema.time).append(" as S_TIME,").append("C.").append(this.scheduleTableSchema.taskName).append(" as TASK_NAME,").append("C.").append(this.scheduleTableSchema.input).append(" as INPUT,").append("C.").append(this.scheduleTableSchema.output).append(" as OUTPUT,").append("C.").append(this.scheduleTableSchema.initialDate).append(" as INITIAL_DATE,").append("C.").append(this.scheduleTableSchema.initialTime).append(" as INITIAL_TIME,").append("C.").append(this.scheduleTableSchema.retryInterval).append(" as RETRY_INTERVAL,").append("C.").append(this.scheduleTableSchema.retryEndTime).append(" as RETRY_END_TIME,").append("C.").append(this.scheduleTableSchema.maxDelayTime).append(" as MAX_DELAY_TIME,").append("C.").append(this.scheduleTableSchema.state).append(" as STATE,").append("C.").append(this.scheduleTableSchema.controlState).append(" as CONTROL_STATE,").append("C.").append(this.scheduleTableSchema.checkState).append(" as CHECK_STATE,").append("C.").append(this.scheduleTableSchema.executorKey).append(" as EXECUTOR_KEY,").append("C.").append(this.scheduleTableSchema.executorType).append(" as EXECUTOR_TYPE,").append("C.").append(this.scheduleTableSchema.executeStartTime).append(" as EXEC_S_TIME,").append("C.").append(this.scheduleTableSchema.executeEndTime).append(" as EXEC_E_TIME").append(" from ").append(this.scheduleTableSchema.table).append(" C,").append("(select ").append("A.").append(this.scheduleGroupTableSchema.id).append(" as ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" A,").append("(select ").append(this.scheduleGroupTableSchema.groupId).append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("='").append(id).append("') B").append(" where ").append("A.").append(this.scheduleGroupTableSchema.groupId).append("=B.").append(this.scheduleGroupTableSchema.groupId).append(" and ").append("A.").append(this.scheduleGroupTableSchema.id).append("<>'").append(id).append("') D").append(" where ").append("C.").append(this.scheduleTableSchema.id).append("=D.ID) E,").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(" as DEPENDS_ID,").append(this.scheduleDependsTableSchema.ignoreError).append(" as IGNORE_ERROR").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("='").append(id).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is not null) F").append(" where E.MASTER_ID=F.DEPENDS_ID").append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and ((((F.IGNORE_ERROR<>'1'").append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (F.IGNORE_ERROR='1'").append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_FAILED).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_ABORT).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("'))").append(" and ");
                this.concatQuery(buf, "E.INITIAL_DATE", "E.INITIAL_TIME").append("<'").append(initialTime).append("')").append(" or (E.STATE='").append(this.scheduleTableSchema.stateString_ENTRY).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_RUN).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_PAUSE).append("'))");
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    result.add(this.createSchedule(rs));
                }
                rs.close();
                rs = null;
                buf.setLength(0);
                buf.append("select * from (").append("(select ").append("E.ID as ").append(this.scheduleTableSchema.id).append(',').append("E.MASTER_ID as ").append(this.scheduleTableSchema.masterId).append(',').append("E.S_DATE as ").append(this.scheduleTableSchema.date).append(',').append("E.S_TIME as ").append(this.scheduleTableSchema.time).append(',').append("E.TASK_NAME as ").append(this.scheduleTableSchema.taskName).append(',').append("E.INPUT as ").append(this.scheduleTableSchema.input).append(',').append("E.OUTPUT as ").append(this.scheduleTableSchema.output).append(',').append("E.INITIAL_DATE as ").append(this.scheduleTableSchema.initialDate).append(',').append("E.INITIAL_TIME as ").append(this.scheduleTableSchema.initialTime).append(',').append("E.RETRY_INTERVAL as ").append(this.scheduleTableSchema.retryInterval).append(',').append("E.RETRY_END_TIME as ").append(this.scheduleTableSchema.retryEndTime).append(',').append("E.MAX_DELAY_TIME as ").append(this.scheduleTableSchema.maxDelayTime).append(',').append("E.STATE as ").append(this.scheduleTableSchema.state).append(',').append("E.CONTROL_STATE as ").append(this.scheduleTableSchema.controlState).append(',').append("E.CHECK_STATE as ").append(this.scheduleTableSchema.checkState).append(',').append("E.EXECUTOR_KEY as ").append(this.scheduleTableSchema.executorKey).append(',').append("E.EXECUTOR_TYPE as ").append(this.scheduleTableSchema.executorType).append(',').append("E.EXEC_S_TIME as ").append(this.scheduleTableSchema.executeStartTime).append(',').append("E.EXEC_E_TIME as ").append(this.scheduleTableSchema.executeEndTime).append(" from ").append("(select ").append("C.").append(this.scheduleTableSchema.id).append(" as ID,").append("C.").append(this.scheduleTableSchema.masterId).append(" as MASTER_ID,").append("C.").append(this.scheduleTableSchema.date).append(" as S_DATE,").append("C.").append(this.scheduleTableSchema.time).append(" as S_TIME,").append("C.").append(this.scheduleTableSchema.taskName).append(" as TASK_NAME,").append("C.").append(this.scheduleTableSchema.input).append(" as INPUT,").append("C.").append(this.scheduleTableSchema.output).append(" as OUTPUT,").append("C.").append(this.scheduleTableSchema.initialDate).append(" as INITIAL_DATE,").append("C.").append(this.scheduleTableSchema.initialTime).append(" as INITIAL_TIME,").append("C.").append(this.scheduleTableSchema.retryInterval).append(" as RETRY_INTERVAL,").append("C.").append(this.scheduleTableSchema.retryEndTime).append(" as RETRY_END_TIME,").append("C.").append(this.scheduleTableSchema.maxDelayTime).append(" as MAX_DELAY_TIME,").append("C.").append(this.scheduleTableSchema.state).append(" as STATE,").append("C.").append(this.scheduleTableSchema.controlState).append(" as CONTROL_STATE,").append("C.").append(this.scheduleTableSchema.checkState).append(" as CHECK_STATE,").append("C.").append(this.scheduleTableSchema.executorKey).append(" as EXECUTOR_KEY,").append("C.").append(this.scheduleTableSchema.executorType).append(" as EXECUTOR_TYPE,").append("C.").append(this.scheduleTableSchema.executeStartTime).append(" as EXEC_S_TIME,").append("C.").append(this.scheduleTableSchema.executeEndTime).append(" as EXEC_E_TIME").append(" from ").append(this.scheduleTableSchema.table).append(" C,").append("(select ").append("A.").append(this.scheduleGroupTableSchema.id).append(" as ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" A,").append("(select ").append(this.scheduleGroupTableSchema.groupId).append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("='").append(id).append("') B").append(" where ").append("A.").append(this.scheduleGroupTableSchema.groupId).append("=B.").append(this.scheduleGroupTableSchema.groupId).append(" and ").append("A.").append(this.scheduleGroupTableSchema.id).append("<>'").append(id).append("') D").append(" where ").append("C.").append(this.scheduleTableSchema.id).append("=D.ID) E,").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(" as DEPENDS_ID,").append(this.scheduleDependsTableSchema.ignoreError).append(" as IGNORE_ERROR").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("='").append(id).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is not null) F").append(" where E.MASTER_ID=F.DEPENDS_ID").append(" and ((((F.IGNORE_ERROR<>'1'").append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (F.IGNORE_ERROR='1'").append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_FAILED).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_ABORT).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("'))").append(" and ");
                this.concatQuery(buf, "E.INITIAL_DATE", "E.INITIAL_TIME").append("='").append(initialTime).append("')").append(" or (E.STATE='").append(this.scheduleTableSchema.stateString_ENTRY).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_RUN).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_PAUSE).append("')))").append(" union (select ").append(this.scheduleTableSchema.id).append(',').append(this.scheduleTableSchema.masterId).append(',').append(this.scheduleTableSchema.date).append(',').append(this.scheduleTableSchema.time).append(',').append(this.scheduleTableSchema.taskName).append(',').append(this.scheduleTableSchema.input).append(',').append(this.scheduleTableSchema.output).append(',').append(this.scheduleTableSchema.initialDate).append(',').append(this.scheduleTableSchema.initialTime).append(',').append(this.scheduleTableSchema.retryInterval).append(',').append(this.scheduleTableSchema.retryEndTime).append(',').append(this.scheduleTableSchema.maxDelayTime).append(',').append(this.scheduleTableSchema.state).append(',').append(this.scheduleTableSchema.controlState).append(',').append(this.scheduleTableSchema.checkState).append(',').append(this.scheduleTableSchema.executorKey).append(',').append(this.scheduleTableSchema.executorType).append(',').append(this.scheduleTableSchema.executeStartTime).append(',').append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append("='").append(id).append("'))").append(" order by ").append(this.scheduleTableSchema.id);
                rs = st.executeQuery(buf.toString());
                doubtSchedules = new HashMap();
                findMe = false;
                while (rs.next()) {
                    if (!findMe) {
                        findMe = id.equals(rs.getString(1));
                        if (findMe) continue;
                        result.add(this.createSchedule(rs));
                        continue;
                    }
                    doubtSchedules.put(rs.getString(1), this.createSchedule(rs));
                }
                rs.close();
                rs = null;
                buf.setLength(0);
                buf.append("select G.ID from ").append("(select E.ID as ID from ").append("(select ").append("C.").append(this.scheduleTableSchema.id).append(" as ID,").append("C.").append(this.scheduleTableSchema.masterId).append(" as MASTER_ID,").append("C.").append(this.scheduleTableSchema.state).append(" as STATE,").append("C.").append(this.scheduleTableSchema.initialDate).append(" as INITIAL_DATE,").append("C.").append(this.scheduleTableSchema.initialTime).append(" as INITIAL_TIME").append(" from ").append(this.scheduleTableSchema.table).append(" C,").append("(select ").append("A.").append(this.scheduleGroupTableSchema.id).append(" as ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" A,").append("(select ").append(this.scheduleGroupTableSchema.groupId).append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("='").append(id).append("') B").append(" where ").append("A.").append(this.scheduleGroupTableSchema.groupId).append("=B.").append(this.scheduleGroupTableSchema.groupId).append(" and ").append("A.").append(this.scheduleGroupTableSchema.id).append("<>'").append(id).append("') D").append(" where ").append("C.").append(this.scheduleTableSchema.id).append("=D.ID) E,").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(" as DEPENDS_ID,").append(this.scheduleDependsTableSchema.ignoreError).append(" as IGNORE_ERROR").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("='").append(id).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is not null) F").append(" where E.MASTER_ID=F.DEPENDS_ID").append(" and E.ID<>'").append(id).append('\'').append(" and ((((F.IGNORE_ERROR<>'1'").append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (F.IGNORE_ERROR='1'").append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_FAILED).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_ABORT).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and E.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("'))").append(" and ");
                this.concatQuery(buf, "E.INITIAL_DATE", "E.INITIAL_TIME").append("='").append(initialTime).append("')").append(" or (E.STATE='").append(this.scheduleTableSchema.stateString_ENTRY).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_RUN).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_PAUSE).append("'))) G,").append("(select ").append(this.scheduleDependsTableSchema.id).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.dependsId).append("='").append(schedule.getMasterId()).append("') H").append(" where G.ID=H.").append(this.scheduleDependsTableSchema.id);
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    doubtSchedules.remove(rs.getString(1));
                }
                rs.close();
                rs = null;
                if (doubtSchedules.size() != 0) {
                    result.addAll(doubtSchedules.values());
                }
            }
            if (schedule.getDependsOnGroup() != null) {
                buf.setLength(0);
                buf.append("select ").append("E.ID as ").append(this.scheduleTableSchema.id).append(',').append("E.MASTER_ID as ").append(this.scheduleTableSchema.masterId).append(',').append("E.S_DATE as ").append(this.scheduleTableSchema.date).append(',').append("E.S_TIME as ").append(this.scheduleTableSchema.time).append(',').append("E.TASK_NAME as ").append(this.scheduleTableSchema.taskName).append(',').append("E.INPUT as ").append(this.scheduleTableSchema.input).append(',').append("E.OUTPUT as ").append(this.scheduleTableSchema.output).append(',').append("E.INITIAL_DATE as ").append(this.scheduleTableSchema.initialDate).append(',').append("E.INITIAL_TIME as ").append(this.scheduleTableSchema.initialTime).append(',').append("E.RETRY_INTERVAL as ").append(this.scheduleTableSchema.retryInterval).append(',').append("E.RETRY_END_TIME as ").append(this.scheduleTableSchema.retryEndTime).append(',').append("E.MAX_DELAY_TIME as ").append(this.scheduleTableSchema.maxDelayTime).append(',').append("E.STATE as ").append(this.scheduleTableSchema.state).append(',').append("E.CONTROL_STATE as ").append(this.scheduleTableSchema.controlState).append(',').append("E.CHECK_STATE as ").append(this.scheduleTableSchema.checkState).append(',').append("E.EXECUTOR_KEY as ").append(this.scheduleTableSchema.executorKey).append(',').append("E.EXECUTOR_TYPE as ").append(this.scheduleTableSchema.executorType).append(',').append("E.EXEC_S_TIME as ").append(this.scheduleTableSchema.executeStartTime).append(',').append("E.EXEC_E_TIME as ").append(this.scheduleTableSchema.executeEndTime).append(" from ").append("(select A.GROUP_ID,A.MASTER_GROUP_ID,A.ID,A.MASTER_ID,A.S_DATE,A.S_TIME,").append("A.TASK_NAME,A.INPUT,A.OUTPUT,A.INITIAL_DATE,A.INITIAL_TIME,").append("A.RETRY_INTERVAL,A.RETRY_END_TIME,A.MAX_DELAY_TIME,A.STATE,").append("A.CONTROL_STATE,A.CHECK_STATE,A.EXECUTOR_KEY,").append("A.EXECUTOR_TYPE,A.EXEC_S_TIME,A.EXEC_E_TIME").append(" from ").append("(select ").append("AA.").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID,").append("AA.").append(this.scheduleGroupTableSchema.masterGroupId).append(" as MASTER_GROUP_ID,").append("AB.").append(this.scheduleTableSchema.id).append(" as ID,").append("AB.").append(this.scheduleTableSchema.masterId).append(" as MASTER_ID,").append("AB.").append(this.scheduleTableSchema.date).append(" as S_DATE,").append("AB.").append(this.scheduleTableSchema.time).append(" as S_TIME,").append("AB.").append(this.scheduleTableSchema.taskName).append(" as TASK_NAME,").append("AB.").append(this.scheduleTableSchema.input).append(" as INPUT,").append("AB.").append(this.scheduleTableSchema.output).append(" as OUTPUT,").append("AB.").append(this.scheduleTableSchema.initialDate).append(" as INITIAL_DATE,").append("AB.").append(this.scheduleTableSchema.initialTime).append(" as INITIAL_TIME,").append("AB.").append(this.scheduleTableSchema.retryInterval).append(" as RETRY_INTERVAL,").append("AB.").append(this.scheduleTableSchema.retryEndTime).append(" as RETRY_END_TIME,").append("AB.").append(this.scheduleTableSchema.maxDelayTime).append(" as MAX_DELAY_TIME,").append("AB.").append(this.scheduleTableSchema.state).append(" as STATE,").append("AB.").append(this.scheduleTableSchema.controlState).append(" as CONTROL_STATE,").append("AB.").append(this.scheduleTableSchema.checkState).append(" as CHECK_STATE,").append("AB.").append(this.scheduleTableSchema.executorKey).append(" as EXECUTOR_KEY,").append("AB.").append(this.scheduleTableSchema.executorType).append(" as EXECUTOR_TYPE,").append("AB.").append(this.scheduleTableSchema.executeStartTime).append(" as EXEC_S_TIME,").append("AB.").append(this.scheduleTableSchema.executeEndTime).append(" as EXEC_E_TIME").append(" from ").append(this.scheduleGroupTableSchema.table).append(" AA,").append(this.scheduleTableSchema.table).append(" AB").append(" where AA.").append(this.scheduleGroupTableSchema.id).append("=AB.").append(this.scheduleTableSchema.id).append(") A,").append("(select ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" as MASTER_GROUP_ID,").append(this.scheduleDependsTableSchema.ignoreError).append(" as IGNORE_ERROR").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("='").append(id).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" is not null) B").append(" where A.MASTER_GROUP_ID=B.MASTER_GROUP_ID").append(" and ((B.IGNORE_ERROR<>'1'").append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append("')").append(" or (B.IGNORE_ERROR='1'").append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_DISABLE).append('\'').append(" and A.STATE<>'").append(this.scheduleTableSchema.stateString_FAILED).append("'))").append(" group by A.GROUP_ID, A.MASTER_GROUP_ID) E,").append("(select ").append("C.").append(this.scheduleGroupTableSchema.id).append(" as ID,").append("C.").append(this.scheduleGroupTableSchema.groupId).append(" as GROUP_ID,").append("C.").append(this.scheduleGroupTableSchema.masterGroupId).append(" as MASTER_GROUP_ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" C,").append("(select ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" as MASTER_GROUP_ID").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("='").append(id).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsGroupId).append(" is not null) D").append(" where C.MASTER_GROUP_ID=D.MASTER_GROUP_ID").append(" and C.ID in (select ").append(this.scheduleTableSchema.id).append(" from ").append(this.scheduleTableSchema.table).append(" where ");
                this.concatQuery(buf, this.scheduleTableSchema.initialDate, this.scheduleTableSchema.initialTime).append("<='").append(initialTime).append("')) F").append(" where E.GROUP_ID=F.GROUP_ID").append(" and E.MASTER_GROUP_ID=F.MASTER_GROUP_ID");
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    result.add(this.createSchedule(rs));
                }
                rs.close();
                rs = null;
            }
            if (schedule.getGroupDependsOnGroupMap().size() != 0) {
                // empty if block
            }
            st.close();
            st = null;
            this.setDependsOnSchedules(con, result);
            this.setGroupIdsOnSchedules(con, result);
            this.setGroupDependsOnGroupOnSchedules(con, result);
            Collections.sort(result);
            ArrayList<Schedule> arrayList = result;
            return arrayList;
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        catch (ConvertException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public List findDependedSchedules(String id) throws ScheduleManageException {
        ArrayList<Schedule> arrayList;
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("select *  from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append("='").append(id).append('\'').append(" and ").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_END).append('\'').append(" and ").append(this.scheduleTableSchema.state).append("<>'").append(this.scheduleTableSchema.stateString_DISABLE).append('\'');
            st = con.createStatement();
            rs = st.executeQuery(buf.toString());
            ArrayList<Schedule> result = new ArrayList<Schedule>();
            if (!rs.next()) {
                ArrayList<Schedule> arrayList2 = result;
                return arrayList2;
            }
            Schedule schedule = this.createSchedule(rs);
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            String initialTime = format.format(schedule.getInitialTime() == null ? schedule.getTime() : schedule.getInitialTime());
            rs.close();
            rs = null;
            buf.setLength(0);
            buf.append("select ").append("A.").append(this.scheduleTableSchema.id).append(" as ").append(this.scheduleTableSchema.id).append(',').append("A.").append(this.scheduleTableSchema.masterId).append(" as ").append(this.scheduleTableSchema.masterId).append(',').append("A.").append(this.scheduleTableSchema.date).append(" as ").append(this.scheduleTableSchema.date).append(',').append("A.").append(this.scheduleTableSchema.time).append(" as ").append(this.scheduleTableSchema.time).append(',').append("A.").append(this.scheduleTableSchema.taskName).append(" as ").append(this.scheduleTableSchema.taskName).append(',').append("A.").append(this.scheduleTableSchema.input).append(" as ").append(this.scheduleTableSchema.input).append(',').append("A.").append(this.scheduleTableSchema.output).append(" as ").append(this.scheduleTableSchema.output).append(',').append("A.").append(this.scheduleTableSchema.initialDate).append(" as ").append(this.scheduleTableSchema.initialDate).append(',').append("A.").append(this.scheduleTableSchema.initialTime).append(" as ").append(this.scheduleTableSchema.initialTime).append(',').append("A.").append(this.scheduleTableSchema.retryInterval).append(" as ").append(this.scheduleTableSchema.retryInterval).append(',').append("A.").append(this.scheduleTableSchema.retryEndTime).append(" as ").append(this.scheduleTableSchema.retryEndTime).append(',').append("A.").append(this.scheduleTableSchema.maxDelayTime).append(" as ").append(this.scheduleTableSchema.maxDelayTime).append(',').append("A.").append(this.scheduleTableSchema.state).append(" as ").append(this.scheduleTableSchema.state).append(',').append("A.").append(this.scheduleTableSchema.controlState).append(" as ").append(this.scheduleTableSchema.controlState).append(',').append("A.").append(this.scheduleTableSchema.checkState).append(" as ").append(this.scheduleTableSchema.checkState).append(',').append("A.").append(this.scheduleTableSchema.executorKey).append(" as ").append(this.scheduleTableSchema.executorKey).append(',').append("A.").append(this.scheduleTableSchema.executorType).append(" as ").append(this.scheduleTableSchema.executorType).append(',').append("A.").append(this.scheduleTableSchema.executeStartTime).append(" as ").append(this.scheduleTableSchema.executeStartTime).append(',').append("A.").append(this.scheduleTableSchema.executeEndTime).append(" as ").append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" A,").append("(select ").append(this.scheduleDependsTableSchema.id).append(',').append(this.scheduleDependsTableSchema.ignoreError).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.dependsId).append("='").append(schedule.getMasterId()).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is null").append(" and ").append(this.scheduleDependsTableSchema.id).append("<>'").append(id).append("') B").append(" where A.").append(this.scheduleTableSchema.id).append("=B.").append(this.scheduleDependsTableSchema.id).append(" and (A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_INITIAL).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_RETRY).append("')");
            if (schedule.getState() == 5 || schedule.getState() == 7) {
                buf.append(" and B.").append(this.scheduleDependsTableSchema.ignoreError).append("<>'1'");
            }
            buf.append(" and ");
            this.concatQuery(buf, this.scheduleTableSchema.initialDate, this.scheduleTableSchema.initialTime).append(">'").append(initialTime).append('\'');
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                result.add(this.createSchedule(rs));
            }
            rs.close();
            rs = null;
            buf.setLength(0);
            buf.append("select * from (").append("(select ").append("A.").append(this.scheduleTableSchema.id).append(" as ").append(this.scheduleTableSchema.id).append(',').append("A.").append(this.scheduleTableSchema.masterId).append(" as ").append(this.scheduleTableSchema.masterId).append(',').append("A.").append(this.scheduleTableSchema.date).append(" as ").append(this.scheduleTableSchema.date).append(',').append("A.").append(this.scheduleTableSchema.time).append(" as ").append(this.scheduleTableSchema.time).append(',').append("A.").append(this.scheduleTableSchema.taskName).append(" as ").append(this.scheduleTableSchema.taskName).append(',').append("A.").append(this.scheduleTableSchema.input).append(" as ").append(this.scheduleTableSchema.input).append(',').append("A.").append(this.scheduleTableSchema.output).append(" as ").append(this.scheduleTableSchema.output).append(',').append("A.").append(this.scheduleTableSchema.initialDate).append(" as ").append(this.scheduleTableSchema.initialDate).append(',').append("A.").append(this.scheduleTableSchema.initialTime).append(" as ").append(this.scheduleTableSchema.initialTime).append(',').append("A.").append(this.scheduleTableSchema.retryInterval).append(" as ").append(this.scheduleTableSchema.retryInterval).append(',').append("A.").append(this.scheduleTableSchema.retryEndTime).append(" as ").append(this.scheduleTableSchema.retryEndTime).append(',').append("A.").append(this.scheduleTableSchema.maxDelayTime).append(" as ").append(this.scheduleTableSchema.maxDelayTime).append(',').append("A.").append(this.scheduleTableSchema.state).append(" as ").append(this.scheduleTableSchema.state).append(',').append("A.").append(this.scheduleTableSchema.controlState).append(" as ").append(this.scheduleTableSchema.controlState).append(',').append("A.").append(this.scheduleTableSchema.checkState).append(" as ").append(this.scheduleTableSchema.checkState).append(',').append("A.").append(this.scheduleTableSchema.executorKey).append(" as ").append(this.scheduleTableSchema.executorKey).append(',').append("A.").append(this.scheduleTableSchema.executorType).append(" as ").append(this.scheduleTableSchema.executorType).append(',').append("A.").append(this.scheduleTableSchema.executeStartTime).append(" as ").append(this.scheduleTableSchema.executeStartTime).append(',').append("A.").append(this.scheduleTableSchema.executeEndTime).append(" as ").append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" A,").append("(select ").append(this.scheduleDependsTableSchema.id).append(',').append(this.scheduleDependsTableSchema.ignoreError).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.dependsId).append("='").append(schedule.getMasterId()).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is null").append(" and ").append(this.scheduleDependsTableSchema.id).append("<>'").append(id).append("') B").append(" where A.").append(this.scheduleTableSchema.id).append("=B.").append(this.scheduleDependsTableSchema.id).append(" and (A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_INITIAL).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_RETRY).append("')");
            if (schedule.getState() == 5 || schedule.getState() == 7) {
                buf.append(" and B.").append(this.scheduleDependsTableSchema.ignoreError).append("<>'1'");
            }
            buf.append(" and ");
            this.concatQuery(buf, this.scheduleTableSchema.initialDate, this.scheduleTableSchema.initialTime).append("='").append(initialTime).append("')").append(" union (select ").append(this.scheduleTableSchema.id).append(',').append(this.scheduleTableSchema.masterId).append(',').append(this.scheduleTableSchema.date).append(',').append(this.scheduleTableSchema.time).append(',').append(this.scheduleTableSchema.taskName).append(',').append(this.scheduleTableSchema.input).append(',').append(this.scheduleTableSchema.output).append(',').append(this.scheduleTableSchema.initialDate).append(',').append(this.scheduleTableSchema.initialTime).append(',').append(this.scheduleTableSchema.retryInterval).append(',').append(this.scheduleTableSchema.retryEndTime).append(',').append(this.scheduleTableSchema.maxDelayTime).append(',').append(this.scheduleTableSchema.state).append(',').append(this.scheduleTableSchema.controlState).append(',').append(this.scheduleTableSchema.checkState).append(',').append(this.scheduleTableSchema.executorKey).append(',').append(this.scheduleTableSchema.executorType).append(',').append(this.scheduleTableSchema.executeStartTime).append(',').append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append("='").append(id).append("'))").append(" order by ").append(this.scheduleTableSchema.id);
            rs = st.executeQuery(buf.toString());
            HashMap<String, Schedule> doubtSchedules = new HashMap<String, Schedule>();
            boolean findMe = false;
            while (rs.next()) {
                if (!findMe) {
                    findMe = id.equals(rs.getString(1));
                    if (findMe) continue;
                    doubtSchedules.put(rs.getString(1), this.createSchedule(rs));
                    continue;
                }
                result.add(this.createSchedule(rs));
            }
            rs.close();
            rs = null;
            buf.setLength(0);
            buf.append("select C.").append(this.scheduleTableSchema.id).append(" from ").append("(select A.").append(this.scheduleTableSchema.id).append(" from ").append(this.scheduleTableSchema.table).append(" A,").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(',').append(this.scheduleDependsTableSchema.ignoreError).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("='").append(id).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is null) B").append(" where A.").append(this.scheduleTableSchema.masterId).append("=B.").append(this.scheduleDependsTableSchema.dependsId).append(" and A.").append(this.scheduleTableSchema.id).append("<>'").append(id).append('\'').append(" and (A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_INITIAL).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_RETRY).append("')");
            if (schedule.getState() == 5 || schedule.getState() == 7) {
                buf.append(" and B.").append(this.scheduleDependsTableSchema.ignoreError).append("<>'1'");
            }
            buf.append(" and ");
            this.concatQuery(buf, "A." + this.scheduleTableSchema.initialDate, "A." + this.scheduleTableSchema.initialTime).append("='").append(initialTime).append("') C,").append(" (select ").append(this.scheduleTableSchema.id).append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.dependsId).append("='").append(schedule.getMasterId()).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is null) D").append(" where C.").append(this.scheduleTableSchema.id).append("=D.").append(this.scheduleDependsTableSchema.id);
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                doubtSchedules.remove(rs.getString(1));
            }
            rs.close();
            rs = null;
            if (doubtSchedules.size() != 0) {
                result.addAll(doubtSchedules.values());
            }
            if (schedule.getGroupIdMap().size() != 0) {
                buf.setLength(0);
                buf.append("select ").append("E.ID as ").append(this.scheduleTableSchema.id).append(',').append("E.MASTER_ID as ").append(this.scheduleTableSchema.masterId).append(',').append("E.S_DATE as ").append(this.scheduleTableSchema.date).append(',').append("E.S_TIME as ").append(this.scheduleTableSchema.time).append(',').append("E.TASK_NAME as ").append(this.scheduleTableSchema.taskName).append(',').append("E.INPUT as ").append(this.scheduleTableSchema.input).append(',').append("E.OUTPUT as ").append(this.scheduleTableSchema.output).append(',').append("E.INITIAL_DATE as ").append(this.scheduleTableSchema.initialDate).append(',').append("E.INITIAL_TIME as ").append(this.scheduleTableSchema.initialTime).append(',').append("E.RETRY_INTERVAL as ").append(this.scheduleTableSchema.retryInterval).append(',').append("E.RETRY_END_TIME as ").append(this.scheduleTableSchema.retryEndTime).append(',').append("E.MAX_DELAY_TIME as ").append(this.scheduleTableSchema.maxDelayTime).append(',').append("E.STATE as ").append(this.scheduleTableSchema.state).append(',').append("E.CONTROL_STATE as ").append(this.scheduleTableSchema.controlState).append(',').append("E.CHECK_STATE as ").append(this.scheduleTableSchema.checkState).append(',').append("E.EXECUTOR_KEY as ").append(this.scheduleTableSchema.executorKey).append(',').append("E.EXECUTOR_TYPE as ").append(this.scheduleTableSchema.executorType).append(',').append("E.EXEC_S_TIME as ").append(this.scheduleTableSchema.executeStartTime).append(',').append("E.EXEC_E_TIME as ").append(this.scheduleTableSchema.executeEndTime).append(" from ").append("(select ").append("C.").append(this.scheduleTableSchema.id).append(" as ID,").append("C.").append(this.scheduleTableSchema.masterId).append(" as MASTER_ID,").append("C.").append(this.scheduleTableSchema.date).append(" as S_DATE,").append("C.").append(this.scheduleTableSchema.time).append(" as S_TIME,").append("C.").append(this.scheduleTableSchema.taskName).append(" as TASK_NAME,").append("C.").append(this.scheduleTableSchema.input).append(" as INPUT,").append("C.").append(this.scheduleTableSchema.output).append(" as OUTPUT,").append("C.").append(this.scheduleTableSchema.initialDate).append(" as INITIAL_DATE,").append("C.").append(this.scheduleTableSchema.initialTime).append(" as INITIAL_TIME,").append("C.").append(this.scheduleTableSchema.retryInterval).append(" as RETRY_INTERVAL,").append("C.").append(this.scheduleTableSchema.retryEndTime).append(" as RETRY_END_TIME,").append("C.").append(this.scheduleTableSchema.maxDelayTime).append(" as MAX_DELAY_TIME,").append("C.").append(this.scheduleTableSchema.state).append(" as STATE,").append("C.").append(this.scheduleTableSchema.controlState).append(" as CONTROL_STATE,").append("C.").append(this.scheduleTableSchema.checkState).append(" as CHECK_STATE,").append("C.").append(this.scheduleTableSchema.executorKey).append(" as EXECUTOR_KEY,").append("C.").append(this.scheduleTableSchema.executorType).append(" as EXECUTOR_TYPE,").append("C.").append(this.scheduleTableSchema.executeStartTime).append(" as EXEC_S_TIME,").append("C.").append(this.scheduleTableSchema.executeEndTime).append(" as EXEC_E_TIME").append(" from ").append(this.scheduleTableSchema.table).append(" C,").append("(select ").append("A.").append(this.scheduleGroupTableSchema.id).append(" as ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" A,").append("(select ").append(this.scheduleGroupTableSchema.groupId).append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("='").append(id).append("') B").append(" where ").append("A.").append(this.scheduleGroupTableSchema.groupId).append("=B.").append(this.scheduleGroupTableSchema.groupId).append(" and ").append("A.").append(this.scheduleGroupTableSchema.id).append("<>'").append(id).append("') D").append(" where ").append("C.").append(this.scheduleTableSchema.id).append("=D.ID) E,").append("(select ").append(this.scheduleDependsTableSchema.id).append(" as ID,").append(this.scheduleDependsTableSchema.ignoreError).append(" as IGNORE_ERROR").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.dependsId).append("='").append(schedule.getMasterId()).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.id).append("<>'").append(id).append("') F").append(" where E.ID=F.ID").append(" and (E.STATE='").append(this.scheduleTableSchema.stateString_INITIAL).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_RETRY).append("')");
                if (schedule.getState() == 5 || schedule.getState() == 7) {
                    buf.append(" and F.IGNORE_ERROR<>'1'");
                }
                buf.append(" and ");
                this.concatQuery(buf, "E.INITIAL_DATE", "E.INITIAL_TIME").append(">'").append(initialTime).append('\'');
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    result.add(this.createSchedule(rs));
                }
                rs.close();
                rs = null;
                buf.setLength(0);
                buf.append("select * from (").append("(select ").append("E.ID as ").append(this.scheduleTableSchema.id).append(',').append("E.MASTER_ID as ").append(this.scheduleTableSchema.masterId).append(',').append("E.S_DATE as ").append(this.scheduleTableSchema.date).append(',').append("E.S_TIME as ").append(this.scheduleTableSchema.time).append(',').append("E.TASK_NAME as ").append(this.scheduleTableSchema.taskName).append(',').append("E.INPUT as ").append(this.scheduleTableSchema.input).append(',').append("E.OUTPUT as ").append(this.scheduleTableSchema.output).append(',').append("E.INITIAL_DATE as ").append(this.scheduleTableSchema.initialDate).append(',').append("E.INITIAL_TIME as ").append(this.scheduleTableSchema.initialTime).append(',').append("E.RETRY_INTERVAL as ").append(this.scheduleTableSchema.retryInterval).append(',').append("E.RETRY_END_TIME as ").append(this.scheduleTableSchema.retryEndTime).append(',').append("E.MAX_DELAY_TIME as ").append(this.scheduleTableSchema.maxDelayTime).append(',').append("E.STATE as ").append(this.scheduleTableSchema.state).append(',').append("E.CONTROL_STATE as ").append(this.scheduleTableSchema.controlState).append(',').append("E.CHECK_STATE as ").append(this.scheduleTableSchema.checkState).append(',').append("E.EXECUTOR_KEY as ").append(this.scheduleTableSchema.executorKey).append(',').append("E.EXECUTOR_TYPE as ").append(this.scheduleTableSchema.executorType).append(',').append("E.EXEC_S_TIME as ").append(this.scheduleTableSchema.executeStartTime).append(',').append("E.EXEC_E_TIME as ").append(this.scheduleTableSchema.executeEndTime).append(" from ").append("(select ").append("C.").append(this.scheduleTableSchema.id).append(" as ID,").append("C.").append(this.scheduleTableSchema.masterId).append(" as MASTER_ID,").append("C.").append(this.scheduleTableSchema.date).append(" as S_DATE,").append("C.").append(this.scheduleTableSchema.time).append(" as S_TIME,").append("C.").append(this.scheduleTableSchema.taskName).append(" as TASK_NAME,").append("C.").append(this.scheduleTableSchema.input).append(" as INPUT,").append("C.").append(this.scheduleTableSchema.output).append(" as OUTPUT,").append("C.").append(this.scheduleTableSchema.initialDate).append(" as INITIAL_DATE,").append("C.").append(this.scheduleTableSchema.initialTime).append(" as INITIAL_TIME,").append("C.").append(this.scheduleTableSchema.retryInterval).append(" as RETRY_INTERVAL,").append("C.").append(this.scheduleTableSchema.retryEndTime).append(" as RETRY_END_TIME,").append("C.").append(this.scheduleTableSchema.maxDelayTime).append(" as MAX_DELAY_TIME,").append("C.").append(this.scheduleTableSchema.state).append(" as STATE,").append("C.").append(this.scheduleTableSchema.controlState).append(" as CONTROL_STATE,").append("C.").append(this.scheduleTableSchema.checkState).append(" as CHECK_STATE,").append("C.").append(this.scheduleTableSchema.executorKey).append(" as EXECUTOR_KEY,").append("C.").append(this.scheduleTableSchema.executorType).append(" as EXECUTOR_TYPE,").append("C.").append(this.scheduleTableSchema.executeStartTime).append(" as EXEC_S_TIME,").append("C.").append(this.scheduleTableSchema.executeEndTime).append(" as EXEC_E_TIME").append(" from ").append(this.scheduleTableSchema.table).append(" C,").append("(select ").append("A.").append(this.scheduleGroupTableSchema.id).append(" as ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" A,").append("(select ").append(this.scheduleGroupTableSchema.groupId).append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("='").append(id).append("') B").append(" where ").append("A.").append(this.scheduleGroupTableSchema.groupId).append("=B.").append(this.scheduleGroupTableSchema.groupId).append(" and ").append("A.").append(this.scheduleGroupTableSchema.id).append("<>'").append(id).append("') D").append(" where ").append("C.").append(this.scheduleTableSchema.id).append("=D.ID) E,").append("(select ").append(this.scheduleDependsTableSchema.id).append(" as ID,").append(this.scheduleDependsTableSchema.ignoreError).append(" as IGNORE_ERROR").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.dependsId).append("='").append(schedule.getMasterId()).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.id).append("<>'").append(id).append("') F").append(" where E.ID=F.ID").append(" and (E.STATE='").append(this.scheduleTableSchema.stateString_INITIAL).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_RETRY).append("')");
                if (schedule.getState() == 5 || schedule.getState() == 7) {
                    buf.append(" and F.IGNORE_ERROR<>'1'");
                }
                buf.append(" and ");
                this.concatQuery(buf, "E.INITIAL_DATE", "E.INITIAL_TIME").append("='").append(initialTime).append("')").append(" union (select ").append(this.scheduleTableSchema.id).append(',').append(this.scheduleTableSchema.masterId).append(',').append(this.scheduleTableSchema.date).append(',').append(this.scheduleTableSchema.time).append(',').append(this.scheduleTableSchema.taskName).append(',').append(this.scheduleTableSchema.input).append(',').append(this.scheduleTableSchema.output).append(',').append(this.scheduleTableSchema.initialDate).append(',').append(this.scheduleTableSchema.initialTime).append(',').append(this.scheduleTableSchema.retryInterval).append(',').append(this.scheduleTableSchema.retryEndTime).append(',').append(this.scheduleTableSchema.maxDelayTime).append(',').append(this.scheduleTableSchema.state).append(',').append(this.scheduleTableSchema.controlState).append(',').append(this.scheduleTableSchema.checkState).append(',').append(this.scheduleTableSchema.executorKey).append(',').append(this.scheduleTableSchema.executorType).append(',').append(this.scheduleTableSchema.executeStartTime).append(',').append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append("='").append(id).append("'))").append(" order by ").append(this.scheduleTableSchema.id);
                rs = st.executeQuery(buf.toString());
                doubtSchedules.clear();
                findMe = false;
                while (rs.next()) {
                    if (!findMe) {
                        findMe = id.equals(rs.getString(1));
                        if (findMe) continue;
                        doubtSchedules.put(rs.getString(1), this.createSchedule(rs));
                        continue;
                    }
                    result.add(this.createSchedule(rs));
                }
                rs.close();
                rs = null;
                buf.setLength(0);
                buf.append("select G.ID from ").append("(select E.ID from ").append("(select ").append("C.").append(this.scheduleTableSchema.id).append(" as ID,").append("C.").append(this.scheduleTableSchema.masterId).append(" as MASTER_ID,").append("C.").append(this.scheduleTableSchema.date).append(" as S_DATE,").append("C.").append(this.scheduleTableSchema.time).append(" as S_TIME,").append("C.").append(this.scheduleTableSchema.taskName).append(" as TASK_NAME,").append("C.").append(this.scheduleTableSchema.input).append(" as INPUT,").append("C.").append(this.scheduleTableSchema.output).append(" as OUTPUT,").append("C.").append(this.scheduleTableSchema.initialDate).append(" as INITIAL_DATE,").append("C.").append(this.scheduleTableSchema.initialTime).append(" as INITIAL_TIME,").append("C.").append(this.scheduleTableSchema.retryInterval).append(" as RETRY_INTERVAL,").append("C.").append(this.scheduleTableSchema.retryEndTime).append(" as RETRY_END_TIME,").append("C.").append(this.scheduleTableSchema.maxDelayTime).append(" as MAX_DELAY_TIME,").append("C.").append(this.scheduleTableSchema.state).append(" as STATE,").append("C.").append(this.scheduleTableSchema.controlState).append(" as CONTROL_STATE,").append("C.").append(this.scheduleTableSchema.checkState).append(" as CHECK_STATE,").append("C.").append(this.scheduleTableSchema.executorKey).append(" as EXECUTOR_KEY,").append("C.").append(this.scheduleTableSchema.executorType).append(" as EXECUTOR_TYPE,").append("C.").append(this.scheduleTableSchema.executeStartTime).append(" as EXEC_S_TIME,").append("C.").append(this.scheduleTableSchema.executeEndTime).append(" as EXEC_E_TIME").append(" from ").append(this.scheduleTableSchema.table).append(" C,").append("(select ").append("A.").append(this.scheduleGroupTableSchema.id).append(" as ID").append(" from ").append(this.scheduleGroupTableSchema.table).append(" A,").append("(select ").append(this.scheduleGroupTableSchema.groupId).append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("='").append(id).append("') B").append(" where ").append("A.").append(this.scheduleGroupTableSchema.groupId).append("=B.").append(this.scheduleGroupTableSchema.groupId).append(" and ").append("A.").append(this.scheduleGroupTableSchema.id).append("<>'").append(id).append("') D").append(" where ").append("C.").append(this.scheduleTableSchema.id).append("=D.ID) E,").append("(select ").append(this.scheduleDependsTableSchema.dependsId).append(" as DEPENDS_ID,").append(this.scheduleDependsTableSchema.ignoreError).append(" as IGNORE_ERROR").append(" from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.id).append("='").append(id).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is not null) F").append(" where E.MASTER_ID=F.DEPENDS_ID").append(" and E.ID<>'").append(id).append('\'').append(" and (E.STATE='").append(this.scheduleTableSchema.stateString_INITIAL).append('\'').append(" or E.STATE='").append(this.scheduleTableSchema.stateString_RETRY).append("')");
                if (schedule.getState() == 5 || schedule.getState() == 7) {
                    buf.append(" and F.IGNORE_ERROR<>'1'");
                }
                buf.append(" and ");
                this.concatQuery(buf, "E.INITIAL_DATE", "E.INITIAL_TIME").append("='").append(initialTime).append("') G,").append(" (select ").append(this.scheduleTableSchema.id).append(" as ID from ").append(this.scheduleDependsTableSchema.table).append(" where ").append(this.scheduleDependsTableSchema.dependsId).append("='").append(schedule.getMasterId()).append('\'').append(" and ").append(this.scheduleDependsTableSchema.dependsId).append(" is not null").append(" and ").append(this.scheduleDependsTableSchema.groupId).append(" is not null) H").append(" where G.ID=H.ID");
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    doubtSchedules.remove(rs.getString(1));
                }
                rs.close();
                rs = null;
                if (doubtSchedules.size() != 0) {
                    result.addAll(doubtSchedules.values());
                }
                buf.setLength(0);
                buf.append("select ").append("A.").append(this.scheduleTableSchema.id).append(" as ").append(this.scheduleTableSchema.id).append(',').append("A.").append(this.scheduleTableSchema.masterId).append(" as ").append(this.scheduleTableSchema.masterId).append(',').append("A.").append(this.scheduleTableSchema.date).append(" as ").append(this.scheduleTableSchema.date).append(',').append("A.").append(this.scheduleTableSchema.time).append(" as ").append(this.scheduleTableSchema.time).append(',').append("A.").append(this.scheduleTableSchema.taskName).append(" as ").append(this.scheduleTableSchema.taskName).append(',').append("A.").append(this.scheduleTableSchema.input).append(" as ").append(this.scheduleTableSchema.input).append(',').append("A.").append(this.scheduleTableSchema.output).append(" as ").append(this.scheduleTableSchema.output).append(',').append("A.").append(this.scheduleTableSchema.initialDate).append(" as ").append(this.scheduleTableSchema.initialDate).append(',').append("A.").append(this.scheduleTableSchema.initialTime).append(" as ").append(this.scheduleTableSchema.initialTime).append(',').append("A.").append(this.scheduleTableSchema.retryInterval).append(" as ").append(this.scheduleTableSchema.retryInterval).append(',').append("A.").append(this.scheduleTableSchema.retryEndTime).append(" as ").append(this.scheduleTableSchema.retryEndTime).append(',').append("A.").append(this.scheduleTableSchema.maxDelayTime).append(" as ").append(this.scheduleTableSchema.maxDelayTime).append(',').append("A.").append(this.scheduleTableSchema.state).append(" as ").append(this.scheduleTableSchema.state).append(',').append("A.").append(this.scheduleTableSchema.controlState).append(" as ").append(this.scheduleTableSchema.controlState).append(',').append("A.").append(this.scheduleTableSchema.checkState).append(" as ").append(this.scheduleTableSchema.checkState).append(',').append("A.").append(this.scheduleTableSchema.executorKey).append(" as ").append(this.scheduleTableSchema.executorKey).append(',').append("A.").append(this.scheduleTableSchema.executorType).append(" as ").append(this.scheduleTableSchema.executorType).append(',').append("A.").append(this.scheduleTableSchema.executeStartTime).append(" as ").append(this.scheduleTableSchema.executeStartTime).append(',').append("A.").append(this.scheduleTableSchema.executeEndTime).append(" as ").append(this.scheduleTableSchema.executeEndTime).append(" from ").append(this.scheduleTableSchema.table).append(" A,").append("(select B.").append(this.scheduleDependsTableSchema.id).append(" as ID").append(" from ").append(this.scheduleDependsTableSchema.table).append(" B,").append("(select ").append(this.scheduleGroupTableSchema.groupId).append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("='").append(id).append("') C").append(" where B.").append(this.scheduleDependsTableSchema.dependsGroupId).append("=C.").append(this.scheduleGroupTableSchema.groupId);
                if (schedule.getState() == 5 || schedule.getState() == 7) {
                    buf.append(" and B.").append(this.scheduleDependsTableSchema.ignoreError).append("<>'1'");
                }
                buf.append(") D,").append("(select MIN(INITIAL_DATETIME) as INITIAL_DATETIME").append(" from (select (");
                this.concatQuery(buf, this.scheduleTableSchema.initialDate, this.scheduleTableSchema.initialTime).append(") as INITIAL_DATETIME").append(" from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.id).append(" in (").append("select E.").append(this.scheduleGroupTableSchema.id).append(" from ").append(this.scheduleGroupTableSchema.table).append(" E,").append("(select ").append(this.scheduleGroupTableSchema.groupId).append(" from ").append(this.scheduleGroupTableSchema.table).append(" where ").append(this.scheduleGroupTableSchema.id).append("='").append(id).append("') F").append(" where ").append("E.").append(this.scheduleGroupTableSchema.groupId).append("=F.").append(this.scheduleGroupTableSchema.groupId).append("))) G").append(" where A.").append(this.scheduleTableSchema.id).append("<>'").append(id).append('\'').append(" and A.").append(this.scheduleTableSchema.id).append("=D.ID").append(" and (A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_INITIAL).append('\'').append(" or A.").append(this.scheduleTableSchema.state).append("='").append(this.scheduleTableSchema.stateString_RETRY).append("')").append(" and ");
                this.concatQuery(buf, "A." + this.scheduleTableSchema.initialDate, "A." + this.scheduleTableSchema.initialTime).append(">=G.INITIAL_DATETIME");
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    result.add(this.createSchedule(rs));
                }
                rs.close();
                rs = null;
            }
            st.close();
            st = null;
            this.setDependsOnSchedules(con, result);
            this.setGroupIdsOnSchedules(con, result);
            this.setGroupDependsOnGroupOnSchedules(con, result);
            Collections.sort(result);
            arrayList = result;
        }
        catch (ParseException e) {
            throw new ScheduleManageException(e);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ScheduleManageException(e);
        }
        catch (ConvertException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return arrayList;
    }

    @Override
    public void addSchedule(Schedule schedule) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        Statement ps1 = null;
        Statement ps2 = null;
        Statement ps3 = null;
        Statement ps4 = null;
        Statement ps5 = null;
        try {
            st = con.createStatement();
            ps1 = con.prepareStatement("insert into " + this.scheduleTableSchema.table + " (" + this.scheduleTableSchema.id + ',' + this.scheduleTableSchema.masterId + ',' + this.scheduleTableSchema.date + ',' + this.scheduleTableSchema.time + ',' + this.scheduleTableSchema.taskName + ',' + this.scheduleTableSchema.input + ',' + this.scheduleTableSchema.output + ',' + this.scheduleTableSchema.initialDate + ',' + this.scheduleTableSchema.initialTime + ',' + this.scheduleTableSchema.retryInterval + ',' + this.scheduleTableSchema.retryEndTime + ',' + this.scheduleTableSchema.maxDelayTime + ',' + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.checkState + ',' + this.scheduleTableSchema.executorKey + ',' + this.scheduleTableSchema.executorType + ',' + this.scheduleTableSchema.executeStartTime + ',' + this.scheduleTableSchema.executeEndTime + ',' + this.scheduleTableSchema.rowVersion + ',' + this.scheduleTableSchema.updateUserId + ',' + this.scheduleTableSchema.updateTime + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'0','" + this.updateUserId + "',?)");
            ps2 = con.prepareStatement("insert into " + this.scheduleDependsTableSchema.table + " (" + this.scheduleDependsTableSchema.id + ',' + this.scheduleDependsTableSchema.dependsId + ',' + this.scheduleDependsTableSchema.dependsGroupId + ',' + this.scheduleDependsTableSchema.groupId + ',' + this.scheduleDependsTableSchema.ignoreError + ',' + this.scheduleDependsTableSchema.rowVersion + ',' + this.scheduleDependsTableSchema.updateUserId + ',' + this.scheduleDependsTableSchema.updateTime + ") values(?,?,?,?,?,'0','" + this.updateUserId + "',?)");
            ps3 = con.prepareStatement("select " + this.scheduleGroupDependsMasterTableSchema.dependsGroupId + " from " + this.scheduleGroupDependsMasterTableSchema.table + " where " + this.scheduleGroupDependsMasterTableSchema.groupId + "=?");
            ps4 = con.prepareStatement("insert into " + this.scheduleGroupDependsTableSchema.table + " (" + this.scheduleGroupDependsTableSchema.groupId + ',' + this.scheduleGroupDependsTableSchema.dependsGroupId + ',' + this.scheduleGroupDependsTableSchema.ignoreError + ',' + this.scheduleGroupDependsTableSchema.rowVersion + ',' + this.scheduleGroupDependsTableSchema.updateUserId + ',' + this.scheduleGroupDependsTableSchema.updateTime + ") values(?,?,?,'0','" + this.updateUserId + "',?)");
            ps5 = con.prepareStatement("insert into " + this.scheduleGroupTableSchema.table + " (" + this.scheduleGroupTableSchema.id + ',' + this.scheduleGroupTableSchema.groupId + ',' + this.scheduleGroupTableSchema.masterGroupId + ',' + this.scheduleGroupTableSchema.rowVersion + ',' + this.scheduleGroupTableSchema.updateUserId + ',' + this.scheduleGroupTableSchema.updateTime + ") values(?,?,?,'0','" + this.updateUserId + "',?)");
            this.addSchedule(st, (PreparedStatement)ps1, (PreparedStatement)ps2, (PreparedStatement)ps3, (PreparedStatement)ps4, (PreparedStatement)ps5, schedule, null);
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps1 != null) {
                try {
                    ps1.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps2 != null) {
                try {
                    ps2.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps3 != null) {
                try {
                    ps3.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps4 != null) {
                try {
                    ps4.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps5 != null) {
                try {
                    ps5.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void addSchedule(String masterId, Date time, String taskName, Object input, String[] depends, String executorKey, String executorType, long retryInterval, Date retryEndTime, long maxDelayTime) throws ScheduleManageException {
        ScheduleDepends[] dependsArray = null;
        if (depends != null) {
            dependsArray = new ScheduleDepends[depends.length];
            for (int i = 0; i < dependsArray.length; ++i) {
                dependsArray[i] = new DefaultScheduleDepends(depends[i], false);
            }
        }
        this.addSchedule(new DefaultSchedule(masterId, null, time, taskName, input, dependsArray, null, null, null, executorKey, executorType, retryInterval, retryEndTime, maxDelayTime));
    }

    @Override
    public boolean reschedule(String id, Date time, Object output) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            int rowVersion = rs.getInt(1);
            st.close();
            st = null;
            rs.close();
            rs = null;
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.date + "=?, " + this.scheduleTableSchema.time + "=?," + this.scheduleTableSchema.checkState + "='" + this.scheduleTableSchema.getCheckStateString(1) + "'," + this.scheduleTableSchema.output + "=?," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=? where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            int index = 0;
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
            st.setString(++index, format.format(time));
            format.applyPattern(this.timeFormat);
            st.setString(++index, format.format(time));
            this.scheduleTableSchema.setOutputObject(++index, (PreparedStatement)st, output);
            st.setTimestamp(++index, new Timestamp(this.time == null ? System.currentTimeMillis() : this.time.currentTimeMillis()));
            st.setString(++index, id);
            boolean bl = st.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        catch (IOException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean removeSchedule(String id) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        try {
            st = con.prepareStatement("delete from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            boolean bl = st.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean removeScheduleByMasterId(String masterId, String masterGroupId) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        try {
            if (masterId != null) {
                st = con.prepareStatement("delete from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.masterId + "=?");
                st.setString(1, masterId);
            } else {
                StringBuffer buf = new StringBuffer();
                buf.append("delete from ").append(this.scheduleTableSchema.table).append(" where ").append(this.scheduleTableSchema.masterId).append(" in (").append("select ").append(this.scheduleGroupMasterTableSchema.id).append(" from ").append(this.scheduleGroupMasterTableSchema.table).append(" where ").append(this.scheduleGroupMasterTableSchema.groupId).append("=?)");
                st = con.prepareStatement(buf.toString());
                st.setString(1, masterGroupId);
            }
            boolean buf = st.executeUpdate() != 0;
            return buf;
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean removeSchedule(Date date) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        try {
            st = con.prepareStatement("delete from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.date + "=?");
            st.setString(1, new SimpleDateFormat(this.dateFormat).format(date));
            boolean bl = st.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean removeSchedule(Date from, Date to, int[] states, String masterId, String masterGroupId, String groupId) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("delete from A.");
            buf.append(this.scheduleTableSchema.table);
            boolean isAppendWhere = false;
            if (masterGroupId != null || groupId != null) {
                buf.append(", (select ").append(this.scheduleGroupTableSchema.id).append(" from ").append(this.scheduleGroupTableSchema.table);
                if (masterGroupId != null && groupId != null) {
                    buf.append(" where ").append(this.scheduleGroupTableSchema.masterGroupId).append("=?").append(" and ").append(this.scheduleGroupTableSchema.groupId).append("=?) B");
                } else if (masterGroupId != null) {
                    buf.append(" where ").append(this.scheduleGroupTableSchema.masterGroupId).append("=?) B ");
                } else {
                    buf.append(" where ").append(this.scheduleGroupTableSchema.groupId).append("=?) B ");
                }
                buf.append(" where A.").append(this.scheduleTableSchema.id).append("=B.").append(this.scheduleGroupTableSchema.id);
                isAppendWhere = true;
            }
            if (masterId != null) {
                if (!isAppendWhere) {
                    buf.append(" where (");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                buf.append("A.").append(this.scheduleTableSchema.masterId).append("=?)");
            }
            if (states != null && states.length != 0) {
                if (!isAppendWhere) {
                    buf.append(" where (");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                for (int i = 0; i < states.length; ++i) {
                    buf.append("A.").append(this.scheduleTableSchema.state);
                    buf.append("=?");
                    if (i == states.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(')');
            }
            if (from != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                } else {
                    buf.append(" and (");
                }
                this.concatQuery(buf, "A." + this.scheduleTableSchema.date, "A." + this.scheduleTableSchema.time);
                buf.append(">=?");
            }
            if (to != null) {
                if (!isAppendWhere) {
                    buf.append(" where ");
                    isAppendWhere = true;
                } else {
                    buf.append(" and ");
                }
                this.concatQuery(buf, "A." + this.scheduleTableSchema.date, "A." + this.scheduleTableSchema.time);
                buf.append("<=?");
            }
            st = con.prepareStatement(buf.toString());
            buf = null;
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            int index = 0;
            if (masterGroupId != null) {
                st.setString(++index, masterGroupId);
            }
            if (groupId != null) {
                st.setString(++index, groupId);
            }
            if (masterId != null) {
                st.setString(++index, masterId);
            }
            if (states != null && states.length != 0) {
                for (int i = 0; i < states.length; ++i) {
                    st.setString(++index, this.scheduleTableSchema.getStateString(states[i]));
                }
            }
            if (from != null) {
                st.setString(++index, format.format(from));
            }
            if (to != null) {
                st.setString(++index, format.format(to));
            }
            boolean bl = st.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void setExecutorKey(String id, String key) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.executorKey + "=?," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=? where " + this.scheduleTableSchema.id + "=?");
            if (key == null) {
                st.setNull(1, 12);
            } else {
                st.setString(1, key);
            }
            st.setTimestamp(2, new Timestamp(this.time == null ? System.currentTimeMillis() : this.time.currentTimeMillis()));
            st.setString(3, id);
            st.executeUpdate();
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void setRetryEndTime(String id, Date time) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
        try {
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.retryEndTime + "=?," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=? where " + this.scheduleTableSchema.id + "=?");
            if (time == null) {
                st.setNull(1, 1);
            } else {
                st.setString(1, format.format(time));
            }
            st.setTimestamp(2, new Timestamp(this.time == null ? System.currentTimeMillis() : this.time.currentTimeMillis()));
            st.setString(3, id);
            st.executeUpdate();
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void setMaxDelayTime(String id, long time) throws ScheduleManageException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleManageException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.maxDelayTime + "=?," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=? where " + this.scheduleTableSchema.id + "=?");
            if (time <= 0L) {
                st.setNull(1, 3);
            } else {
                st.setLong(1, time);
            }
            st.setTimestamp(2, new Timestamp(this.time == null ? System.currentTimeMillis() : this.time.currentTimeMillis()));
            st.setString(3, id);
            st.executeUpdate();
        }
        catch (SQLException e) {
            throw new ScheduleManageException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public int getState(String id) throws ScheduleStateControlException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.state + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            int n = this.scheduleTableSchema.getState(rs.getString(1));
            return n;
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public int getControlState(String id) throws ScheduleStateControlException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.controlState + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            int n = this.scheduleTableSchema.getControlState(rs.getString(1));
            return n;
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean changeState(String id, int state) throws ScheduleStateControlException {
        boolean bl;
        boolean isUpdateExecuteStartTime = false;
        boolean isUpdateExecuteEndTime = false;
        Date executeStartTime = null;
        Date executeEndTime = null;
        switch (state) {
            case 3: {
                executeStartTime = this.time == null ? new Date() : new Date(this.time.currentTimeMillis());
                isUpdateExecuteStartTime = true;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                executeEndTime = this.time == null ? new Date() : new Date(this.time.currentTimeMillis());
                isUpdateExecuteEndTime = true;
                break;
            }
            case 1: 
            case 2: {
                isUpdateExecuteStartTime = true;
                isUpdateExecuteEndTime = true;
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new ScheduleStateControlException("Unknown state : " + state);
            }
        }
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            String oldStateStr = rs.getString(1);
            int rowVersion = rs.getInt(2);
            st.close();
            st = null;
            rs.close();
            rs = null;
            String newStateStr = this.scheduleTableSchema.getStateString(state);
            if (oldStateStr.equals(newStateStr)) {
                boolean bl2 = false;
                return bl2;
            }
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + (isUpdateExecuteStartTime ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=? where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            int i = 0;
            st.setString(++i, newStateStr);
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            if (isUpdateExecuteStartTime) {
                st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
            }
            if (isUpdateExecuteEndTime) {
                st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
            }
            st.setTimestamp(++i, new Timestamp(this.time == null ? System.currentTimeMillis() : this.time.currentTimeMillis()));
            st.setString(++i, id);
            bl = st.executeUpdate() != 0;
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return bl;
    }

    @Override
    public boolean changeState(String id, int oldState, int newState) throws ScheduleStateControlException {
        boolean bl;
        boolean isUpdateExecuteStartTime = false;
        boolean isUpdateExecuteEndTime = false;
        Date executeStartTime = null;
        Date executeEndTime = null;
        switch (newState) {
            case 3: {
                executeStartTime = this.time == null ? new Date() : new Date(this.time.currentTimeMillis());
                isUpdateExecuteStartTime = true;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                executeEndTime = this.time == null ? new Date() : new Date(this.time.currentTimeMillis());
                isUpdateExecuteEndTime = true;
                break;
            }
            case 1: 
            case 2: {
                isUpdateExecuteStartTime = true;
                isUpdateExecuteEndTime = true;
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new ScheduleStateControlException("Unknown state : " + newState);
            }
        }
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            String oldStateStr = rs.getString(1);
            int rowVersion = rs.getInt(2);
            st.close();
            st = null;
            rs.close();
            rs = null;
            String newStateStr = this.scheduleTableSchema.getStateString(newState);
            if (oldStateStr.equals(newStateStr)) {
                boolean bl2 = false;
                return bl2;
            }
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + (isUpdateExecuteStartTime ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=? where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.state + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            int i = 0;
            st.setString(++i, newStateStr);
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            if (isUpdateExecuteStartTime) {
                st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
            }
            if (isUpdateExecuteEndTime) {
                st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
            }
            st.setTimestamp(++i, new Timestamp(this.time == null ? System.currentTimeMillis() : this.time.currentTimeMillis()));
            st.setString(++i, id);
            st.setString(++i, this.scheduleTableSchema.getStateString(oldState));
            bl = st.executeUpdate() != 0;
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return bl;
    }

    @Override
    public boolean changeState(String id, int oldState, int newState, Object output) throws ScheduleStateControlException {
        boolean bl;
        boolean isUpdateExecuteStartTime = false;
        boolean isUpdateExecuteEndTime = false;
        Date executeStartTime = null;
        Date executeEndTime = null;
        switch (newState) {
            case 3: {
                executeStartTime = this.time == null ? new Date() : new Date(this.time.currentTimeMillis());
                isUpdateExecuteStartTime = true;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                executeEndTime = this.time == null ? new Date() : new Date(this.time.currentTimeMillis());
                isUpdateExecuteEndTime = true;
                break;
            }
            case 1: 
            case 2: {
                isUpdateExecuteStartTime = true;
                isUpdateExecuteEndTime = true;
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new ScheduleStateControlException("Unknown state : " + newState);
            }
        }
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            String oldStateStr = rs.getString(1);
            int rowVersion = rs.getInt(2);
            st.close();
            st = null;
            rs.close();
            rs = null;
            String newStateStr = this.scheduleTableSchema.getStateString(newState);
            if (oldStateStr.equals(newStateStr)) {
                boolean bl2 = false;
                return bl2;
            }
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + (isUpdateExecuteStartTime ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.output + "=?," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=? where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.state + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            int i = 0;
            st.setString(++i, newStateStr);
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            if (isUpdateExecuteStartTime) {
                st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
            }
            if (isUpdateExecuteEndTime) {
                st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
            }
            this.scheduleTableSchema.setOutputObject(++i, (PreparedStatement)st, output);
            st.setTimestamp(++i, new Timestamp(this.time == null ? System.currentTimeMillis() : this.time.currentTimeMillis()));
            st.setString(++i, id);
            st.setString(++i, this.scheduleTableSchema.getStateString(oldState));
            bl = st.executeUpdate() != 0;
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        catch (IOException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return bl;
    }

    @Override
    public boolean changeState(String id, int state, Object output) throws ScheduleStateControlException {
        boolean bl;
        boolean isUpdateExecuteStartTime = false;
        boolean isUpdateExecuteEndTime = false;
        Date executeStartTime = null;
        Date executeEndTime = null;
        switch (state) {
            case 3: {
                executeStartTime = this.time == null ? new Date() : new Date(this.time.currentTimeMillis());
                isUpdateExecuteStartTime = true;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                executeEndTime = this.time == null ? new Date() : new Date(this.time.currentTimeMillis());
                isUpdateExecuteEndTime = true;
                break;
            }
            case 1: 
            case 2: {
                isUpdateExecuteStartTime = true;
                isUpdateExecuteEndTime = true;
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new ScheduleStateControlException("Unknown state : " + state);
            }
        }
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            String oldStateStr = rs.getString(1);
            int rowVersion = rs.getInt(2);
            st.close();
            st = null;
            rs.close();
            rs = null;
            String newStateStr = this.scheduleTableSchema.getStateString(state);
            if (oldStateStr.equals(newStateStr)) {
                boolean bl2 = false;
                return bl2;
            }
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + this.scheduleTableSchema.output + "=?," + (isUpdateExecuteStartTime ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=? where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            int i = 0;
            st.setString(++i, newStateStr);
            this.scheduleTableSchema.setOutputObject(++i, (PreparedStatement)st, output);
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            if (isUpdateExecuteStartTime) {
                st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
            }
            if (isUpdateExecuteEndTime) {
                st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
            }
            st.setTimestamp(++i, new Timestamp(this.time == null ? System.currentTimeMillis() : this.time.currentTimeMillis()));
            st.setString(++i, id);
            bl = st.executeUpdate() != 0 && !newStateStr.equals(oldStateStr);
        }
        catch (IOException e) {
            throw new ScheduleStateControlException(e);
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean changeControlState(String id, int state) throws ScheduleStateControlException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        boolean result = false;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            String oldStateStr = rs.getString(1);
            int nowOldState = this.scheduleTableSchema.getControlState(oldStateStr);
            int rowVersion = rs.getInt(2);
            st.close();
            st = null;
            rs.close();
            rs = null;
            if (nowOldState == state) {
                boolean bl = false;
                return bl;
            }
            switch (state) {
                case 2: {
                    if (nowOldState == 3) break;
                    boolean bl = false;
                    return bl;
                }
                case 3: {
                    if (nowOldState == 6) break;
                    boolean bl = false;
                    return bl;
                }
                case 4: {
                    if (nowOldState == 3) break;
                    boolean bl = false;
                    return bl;
                }
                default: {
                    throw new ScheduleStateControlException("Unknown state : " + state);
                }
            }
            String newStateStr = this.scheduleTableSchema.getControlStateString(state);
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.controlState + "=?," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=? where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, newStateStr);
            st.setTimestamp(2, new Timestamp(this.time == null ? System.currentTimeMillis() : this.time.currentTimeMillis()));
            st.setString(3, id);
            result = st.executeUpdate() != 0;
            if (!result) return result;
            try {
                if (this.scheduleControlListeners == null) return result;
                if (this.scheduleControlListeners.size() == 0) return result;
                Set set = this.scheduleControlListeners;
                synchronized (set) {
                    Iterator itr = this.scheduleControlListeners.iterator();
                    while (itr.hasNext()) {
                        ScheduleControlListener listener = (ScheduleControlListener)itr.next();
                        listener.changedControlState(id, state);
                    }
                    return result;
                }
            }
            catch (ScheduleStateControlException e) {
                st.setString(1, this.scheduleTableSchema.getControlStateString(5));
                st.executeUpdate();
                throw e;
            }
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean changeControlState(String id, int oldState, int newState) throws ScheduleStateControlException {
        Connection con = null;
        try {
            con = this.connectionFactory.getConnection();
        }
        catch (ConnectionFactoryException e) {
            throw new ScheduleStateControlException(e);
        }
        boolean result = false;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.prepareStatement("select " + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            String oldStateStr = rs.getString(1);
            int nowOldState = this.scheduleTableSchema.getControlState(oldStateStr);
            int rowVersion = rs.getInt(2);
            st.close();
            st = null;
            rs.close();
            rs = null;
            if (nowOldState == newState) {
                boolean bl = false;
                return bl;
            }
            switch (newState) {
                case 2: {
                    if (nowOldState == 3) break;
                    boolean bl = false;
                    return bl;
                }
                case 3: {
                    if (nowOldState == 6) break;
                    boolean bl = false;
                    return bl;
                }
                case 4: {
                    if (nowOldState == 3) break;
                    boolean bl = false;
                    return bl;
                }
                default: {
                    throw new ScheduleStateControlException("Unknown state : " + newState);
                }
            }
            String newStateStr = this.scheduleTableSchema.getControlStateString(newState);
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.controlState + "=?," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=? where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.controlState + "=?");
            st.setString(1, newStateStr);
            st.setTimestamp(2, new Timestamp(this.time == null ? System.currentTimeMillis() : this.time.currentTimeMillis()));
            st.setString(3, id);
            st.setString(4, this.scheduleTableSchema.getControlStateString(oldState));
            result = st.executeUpdate() != 0;
            if (!result) return result;
            try {
                if (this.scheduleControlListeners == null) return result;
                if (this.scheduleControlListeners.size() == 0) return result;
                Set set = this.scheduleControlListeners;
                synchronized (set) {
                    Iterator itr = this.scheduleControlListeners.iterator();
                    while (itr.hasNext()) {
                        ScheduleControlListener listener = (ScheduleControlListener)itr.next();
                        listener.changedControlState(id, newState);
                    }
                    return result;
                }
            }
            catch (ScheduleStateControlException e) {
                st.setString(1, this.scheduleTableSchema.getControlStateString(5));
                st.executeUpdate();
                throw e;
            }
        }
        catch (SQLException e) {
            throw new ScheduleStateControlException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void addScheduleControlListener(ScheduleControlListener listener) {
        if ((this.scheduleControlListeners == null || this.scheduleControlListeners.size() == 0) && this.controlStateChecker == null && this.getState() == 3 && this.controlStateCheckInterval > 0L) {
            this.controlStateChecker = new Daemon(new ControlStateChecker());
            this.controlStateChecker.setName("Nimbus ControlStateChecker " + this.getServiceNameObject());
            this.controlStateChecker.start();
        }
        this.scheduleControlListeners.add(listener);
    }

    @Override
    public void removeScheduleControlListener(ScheduleControlListener listener) {
        this.scheduleControlListeners.remove(listener);
    }

    private static final Object getInOutObject(int type, String name, ResultSet rs) throws IOException, ClassNotFoundException, SQLException {
        int length = 0;
        switch (type) {
            case 2005: {
                Reader reader = rs.getCharacterStream(name);
                StringWriter writer = new StringWriter();
                char[] chars = new char[1024];
                while ((length = reader.read(chars)) > 0) {
                    writer.write(chars, 0, length);
                }
                return writer.toString();
            }
            case 2004: {
                InputStream is = rs.getBinaryStream(name);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                while ((length = is.read(bytes)) > 0) {
                    baos.write(bytes, 0, length);
                }
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
                return ois.readObject();
            }
        }
        return rs.getObject(name);
    }

    private static final void setInOutObject(int type, int index, PreparedStatement ps, Object value) throws IOException, SQLException {
        if (value == null) {
            ps.setNull(index, type);
            return;
        }
        switch (type) {
            case 2005: {
                char[] chars = value.toString().toCharArray();
                ps.setCharacterStream(index, (Reader)new CharArrayReader(chars), chars.length);
                break;
            }
            case 2004: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(value);
                oos.flush();
                byte[] bytes = baos.toByteArray();
                ps.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                break;
            }
            default: {
                ps.setString(index, value.toString());
            }
        }
    }

    protected class ClusterListener
    implements jp.ossc.nimbus.service.keepalive.ClusterListener {
        protected ClusterListener() {
        }

        @Override
        public void memberInit(Object myId, List members) {
        }

        @Override
        public void memberChange(List oldMembers, List newMembers) {
        }

        @Override
        public void changeMain() throws Exception {
            if (DatabaseScheduleManagerService.this.controlStateChecker != null) {
                DatabaseScheduleManagerService.this.controlStateChecker.resume();
            }
            if (DatabaseScheduleManagerService.this.timeoverChecker != null) {
                DatabaseScheduleManagerService.this.timeoverChecker.resume();
            }
        }

        @Override
        public void changeSub() {
            if (DatabaseScheduleManagerService.this.controlStateChecker != null) {
                DatabaseScheduleManagerService.this.controlStateChecker.suspend();
            }
            if (DatabaseScheduleManagerService.this.timeoverChecker != null) {
                DatabaseScheduleManagerService.this.timeoverChecker.suspend();
            }
        }
    }

    protected class TimeoverChecker
    implements DaemonRunnable {
        protected TimeoverChecker() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            ctrl.sleep(DatabaseScheduleManagerService.this.getTimeoverCheckInterval(), true);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(Object dequeued, DaemonControl ctrl) throws Throwable {
            Connection con = null;
            try {
                con = DatabaseScheduleManagerService.this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e) {
                DatabaseScheduleManagerService.this.getLogger().write("DSM__00002", DatabaseScheduleManagerService.this.getServiceNameObject(), (Throwable)e);
                return;
            }
            Statement st = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                st = con.createStatement();
                SimpleDateFormat format = new SimpleDateFormat(DatabaseScheduleManagerService.this.dateFormat + DatabaseScheduleManagerService.this.timeFormat);
                Calendar nowCal = Calendar.getInstance();
                rs = st.executeQuery("select " + DatabaseScheduleManagerService.this.scheduleTableSchema.id + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.date + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.time + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.maxDelayTime + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.state + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.masterId + " from " + DatabaseScheduleManagerService.this.scheduleTableSchema.table + " where " + DatabaseScheduleManagerService.this.scheduleTableSchema.checkState + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getCheckStateString(2) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.maxDelayTime + " is not null and " + DatabaseScheduleManagerService.this.scheduleTableSchema.maxDelayTime + ">0 and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(4) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(9) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(5) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(7) + "' and " + DatabaseScheduleManagerService.this.concatQuery(new StringBuffer(), DatabaseScheduleManagerService.this.scheduleTableSchema.date, DatabaseScheduleManagerService.this.scheduleTableSchema.time) + "<'" + format.format(nowCal.getTime()) + '\'');
                Calendar tmpCal = Calendar.getInstance();
                while (rs.next()) {
                    Date time = format.parse(rs.getString(2) + rs.getString(3));
                    tmpCal.clear();
                    long maxDelayTime = rs.getLong(4);
                    tmpCal.setTimeInMillis(time.getTime() + maxDelayTime);
                    if (tmpCal.after(nowCal) || tmpCal.equals(nowCal)) continue;
                    String id = rs.getString(1);
                    if (ps == null) {
                        String checkStateStr = DatabaseScheduleManagerService.this.scheduleTableSchema.getCheckStateString(2);
                        ps = con.prepareStatement("update " + DatabaseScheduleManagerService.this.scheduleTableSchema.table + " set " + DatabaseScheduleManagerService.this.scheduleTableSchema.checkState + "='" + checkStateStr + "'," + DatabaseScheduleManagerService.this.scheduleTableSchema.updateUserId + "='" + DatabaseScheduleManagerService.this.updateUserId + "'," + DatabaseScheduleManagerService.this.scheduleTableSchema.updateTime + "=? where " + DatabaseScheduleManagerService.this.scheduleTableSchema.id + "=? and " + DatabaseScheduleManagerService.this.scheduleTableSchema.checkState + "<>'" + checkStateStr + '\'');
                    }
                    ps.setTimestamp(1, new Timestamp(DatabaseScheduleManagerService.this.time == null ? System.currentTimeMillis() : DatabaseScheduleManagerService.this.time.currentTimeMillis()));
                    ps.setString(2, id);
                    if (ps.executeUpdate() == 0) continue;
                    String state = rs.getString(5);
                    String masterId = rs.getString(6);
                    DatabaseScheduleManagerService.this.getLogger().write("DSM__00003", new Object[]{DatabaseScheduleManagerService.this.getServiceNameObject(), id, masterId, state});
                }
            }
            catch (SQLException e) {
                DatabaseScheduleManagerService.this.getLogger().write("DSM__00002", DatabaseScheduleManagerService.this.getServiceNameObject(), (Throwable)e);
                return;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }

        @Override
        public void garbage() {
        }
    }

    protected class ControlStateChecker
    implements DaemonRunnable {
        protected ControlStateChecker() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            ctrl.sleep(DatabaseScheduleManagerService.this.getControlStateCheckInterval(), true);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(Object input, DaemonControl ctrl) throws Throwable {
            if (DatabaseScheduleManagerService.this.scheduleControlListeners == null || DatabaseScheduleManagerService.this.scheduleControlListeners.size() == 0) {
                return;
            }
            Connection con = null;
            try {
                con = DatabaseScheduleManagerService.this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e) {
                DatabaseScheduleManagerService.this.getLogger().write("DSM__00001", DatabaseScheduleManagerService.this.getServiceNameObject(), (Throwable)e);
                return;
            }
            Statement st = null;
            ResultSet rs = null;
            try {
                st = con.createStatement();
                rs = st.executeQuery("select " + DatabaseScheduleManagerService.this.scheduleTableSchema.id + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + " from " + DatabaseScheduleManagerService.this.scheduleTableSchema.table + " where (" + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(3) + "' or " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(6) + "') and (" + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getControlStateString(2) + "' or " + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getControlStateString(3) + "' or " + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getControlStateString(4) + "')");
                while (rs.next()) {
                    String id = rs.getString(1);
                    String controlStateStr = rs.getString(2);
                    int controlState = DatabaseScheduleManagerService.this.scheduleTableSchema.getControlState(controlStateStr);
                    try {
                        if (DatabaseScheduleManagerService.this.scheduleControlListeners == null || DatabaseScheduleManagerService.this.scheduleControlListeners.size() == 0) continue;
                        Set set = DatabaseScheduleManagerService.this.scheduleControlListeners;
                        synchronized (set) {
                            for (ScheduleControlListener listener : DatabaseScheduleManagerService.this.scheduleControlListeners) {
                                listener.changedControlState(id, controlState);
                            }
                        }
                    }
                    catch (ScheduleStateControlException e) {
                        try {
                            DatabaseScheduleManagerService.this.changeControlState(id, 5);
                        }
                        catch (ScheduleStateControlException scheduleStateControlException) {
                            // empty catch block
                        }
                        DatabaseScheduleManagerService.this.getLogger().write("DSM__00001", DatabaseScheduleManagerService.this.getServiceNameObject(), (Throwable)e);
                    }
                }
            }
            catch (SQLException e) {
                DatabaseScheduleManagerService.this.getLogger().write("DSM__00001", DatabaseScheduleManagerService.this.getServiceNameObject(), (Throwable)e);
                return;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }

        @Override
        public void garbage() {
        }
    }

    public static class ScheduleGroupDependsTableSchema
    extends ScheduleGroupDependsMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_GROUP_DEPENDS";
        public static final String DEFAULT_ROWVERSION = "ROWVERSION";
        public static final String DEFAULT_UPDATEUSERID = "UPDATEUSERID";
        public static final String DEFAULT_UPDATETIME = "UPDATETIME";
        public String table = "SCHEDULE_GROUP_DEPENDS";
        public String rowVersion = "ROWVERSION";
        public String updateUserId = "UPDATEUSERID";
        public String updateTime = "UPDATETIME";
    }

    public static class ScheduleDependsTableSchema
    extends ScheduleDependsMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_DEPENDS";
        public static final String DEFAULT_ROWVERSION = "ROWVERSION";
        public static final String DEFAULT_UPDATEUSERID = "UPDATEUSERID";
        public static final String DEFAULT_UPDATETIME = "UPDATETIME";
        public String table = "SCHEDULE_DEPENDS";
        public String rowVersion = "ROWVERSION";
        public String updateUserId = "UPDATEUSERID";
        public String updateTime = "UPDATETIME";
    }

    public static class ScheduleGroupTableSchema
    extends ScheduleGroupMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_GROUP";
        public static final String DEFAULT_MASTER_GROUP_ID = "MASTER_GROUP_ID";
        public static final String DEFAULT_ROWVERSION = "ROWVERSION";
        public static final String DEFAULT_UPDATEUSERID = "UPDATEUSERID";
        public static final String DEFAULT_UPDATETIME = "UPDATETIME";
        public String table = "SCHEDULE_GROUP";
        public String masterGroupId = "MASTER_GROUP_ID";
        public String rowVersion = "ROWVERSION";
        public String updateUserId = "UPDATEUSERID";
        public String updateTime = "UPDATETIME";
    }

    public static class ScheduleTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_MASTER_ID = "MASTER_ID";
        public static final String DEFAULT_DATE = "S_DATE";
        public static final String DEFAULT_TIME = "S_TIME";
        public static final String DEFAULT_TASK_NAME = "TASK_NAME";
        public static final String DEFAULT_INPUT = "INPUT";
        public static final String DEFAULT_OUTPUT = "OUTPUT";
        public static final String DEFAULT_INITIAL_DATE = "INITIAL_DATE";
        public static final String DEFAULT_INITIAL_TIME = "INITIAL_TIME";
        public static final String DEFAULT_RETRY_INTERVAL = "RETRY_INTERVAL";
        public static final String DEFAULT_RETRY_END_TIME = "RETRY_END_TIME";
        public static final String DEFAULT_MAX_DELAY_TIME = "MAX_DELAY_TIME";
        public static final String DEFAULT_STATE = "STATE";
        public static final String DEFAULT_CONTROL_STATE = "CONTROL_STATE";
        public static final String DEFAULT_CHECK_STATE = "CHECK_STATE";
        public static final String DEFAULT_EXECUTOR_KEY = "EXECUTOR_KEY";
        public static final String DEFAULT_EXECUTOR_TYPE = "EXECUTOR_TYPE";
        public static final String DEFAULT_EXECUTE_START_TIME = "EXEC_S_TIME";
        public static final String DEFAULT_EXECUTE_END_TIME = "EXEC_E_TIME";
        public static final String DEFAULT_ROWVERSION = "ROWVERSION";
        public static final String DEFAULT_UPDATEUSERID = "UPDATEUSERID";
        public static final String DEFAULT_UPDATETIME = "UPDATETIME";
        public static final String DEFAULT_STATE_STRING_INITIAL = "I";
        public static final String DEFAULT_STATE_STRING_ENTRY = "E";
        public static final String DEFAULT_STATE_STRING_RUN = "R";
        public static final String DEFAULT_STATE_STRING_END = "N";
        public static final String DEFAULT_STATE_STRING_FAILED = "F";
        public static final String DEFAULT_STATE_STRING_PAUSE = "P";
        public static final String DEFAULT_STATE_STRING_ABORT = "A";
        public static final String DEFAULT_STATE_STRING_RETRY = "T";
        public static final String DEFAULT_STATE_STRING_DISABLE = "D";
        public static final String DEFAULT_STATE_STRING_UNKNOWN = "U";
        public static final String DEFAULT_CONTROL_STATE_STRING_INITIAL = "I";
        public static final String DEFAULT_CONTROL_STATE_STRING_PAUSE = "P";
        public static final String DEFAULT_CONTROL_STATE_STRING_RESUME = "R";
        public static final String DEFAULT_CONTROL_STATE_STRING_ABORT = "A";
        public static final String DEFAULT_CONTROL_STATE_STRING_FAILED = "F";
        public static final String DEFAULT_CONTROL_STATE_STRING_UNKNOWN = "U";
        public static final String DEFAULT_CHECK_STATE_STRING_INITIAL = "I";
        public static final String DEFAULT_CHECK_STATE_STRING_TIMEOVER = "O";
        public static final String DEFAULT_CHECK_STATE_STRING_UNKNOWN = "U";
        public String table = "SCHEDULE";
        public String id = "ID";
        public String masterId = "MASTER_ID";
        public String date = "S_DATE";
        public String time = "S_TIME";
        public String taskName = "TASK_NAME";
        public String input = "INPUT";
        public String output = "OUTPUT";
        public String initialDate = "INITIAL_DATE";
        public String initialTime = "INITIAL_TIME";
        public String retryInterval = "RETRY_INTERVAL";
        public String retryEndTime = "RETRY_END_TIME";
        public String maxDelayTime = "MAX_DELAY_TIME";
        public String state = "STATE";
        public String controlState = "CONTROL_STATE";
        public String checkState = "CHECK_STATE";
        public String executorKey = "EXECUTOR_KEY";
        public String executorType = "EXECUTOR_TYPE";
        public String executeStartTime = "EXEC_S_TIME";
        public String executeEndTime = "EXEC_E_TIME";
        public String rowVersion = "ROWVERSION";
        public String updateUserId = "UPDATEUSERID";
        public String updateTime = "UPDATETIME";
        public String stateString_INITIAL = "I";
        public String stateString_ENTRY = "E";
        public String stateString_RUN = "R";
        public String stateString_END = "N";
        public String stateString_FAILED = "F";
        public String stateString_PAUSE = "P";
        public String stateString_ABORT = "A";
        public String stateString_RETRY = "T";
        public String stateString_DISABLE = "D";
        public String stateString_UNKNOWN = "U";
        public String controlStateString_INITIAL = "I";
        public String controlStateString_PAUSE = "P";
        public String controlStateString_RESUME = "R";
        public String controlStateString_ABORT = "A";
        public String controlStateString_FAILED = "F";
        public String controlStateString_UNKNOWN = "U";
        public String checkStateString_INITIAL = "I";
        public String checkStateString_TIMEOVER = "O";
        public String checkStateString_UNKNOWN = "U";
        public int inputColumnType = 12;
        public int outputColumnType = 12;

        protected Object getInputObject(ResultSet rs) throws IOException, ClassNotFoundException, SQLException {
            return DatabaseScheduleManagerService.getInOutObject(this.inputColumnType, this.input, rs);
        }

        protected void setInputObject(int index, PreparedStatement ps, Object value) throws IOException, SQLException {
            DatabaseScheduleManagerService.setInOutObject(this.inputColumnType, index, ps, value);
        }

        protected Object getOutputObject(ResultSet rs) throws IOException, ClassNotFoundException, SQLException {
            return DatabaseScheduleManagerService.getInOutObject(this.outputColumnType, this.output, rs);
        }

        protected void setOutputObject(int index, PreparedStatement ps, Object value) throws IOException, SQLException {
            DatabaseScheduleManagerService.setInOutObject(this.outputColumnType, index, ps, value);
        }

        public String getStateString(int state) {
            switch (state) {
                case 1: {
                    return this.stateString_INITIAL;
                }
                case 2: {
                    return this.stateString_ENTRY;
                }
                case 3: {
                    return this.stateString_RUN;
                }
                case 4: {
                    return this.stateString_END;
                }
                case 5: {
                    return this.stateString_FAILED;
                }
                case 6: {
                    return this.stateString_PAUSE;
                }
                case 7: {
                    return this.stateString_ABORT;
                }
                case 8: {
                    return this.stateString_RETRY;
                }
                case 9: {
                    return this.stateString_DISABLE;
                }
            }
            return this.stateString_UNKNOWN;
        }

        public int getState(String state) {
            if (this.stateString_INITIAL.equals(state)) {
                return 1;
            }
            if (this.stateString_ENTRY.equals(state)) {
                return 2;
            }
            if (this.stateString_RUN.equals(state)) {
                return 3;
            }
            if (this.stateString_END.equals(state)) {
                return 4;
            }
            if (this.stateString_FAILED.equals(state)) {
                return 5;
            }
            if (this.stateString_PAUSE.equals(state)) {
                return 6;
            }
            if (this.stateString_ABORT.equals(state)) {
                return 7;
            }
            if (this.stateString_RETRY.equals(state)) {
                return 8;
            }
            if (this.stateString_DISABLE.equals(state)) {
                return 9;
            }
            return -1;
        }

        public String getControlStateString(int state) {
            switch (state) {
                case 1: {
                    return this.controlStateString_INITIAL;
                }
                case 2: {
                    return this.controlStateString_PAUSE;
                }
                case 3: {
                    return this.controlStateString_RESUME;
                }
                case 4: {
                    return this.controlStateString_ABORT;
                }
                case 5: {
                    return this.controlStateString_FAILED;
                }
            }
            return this.controlStateString_UNKNOWN;
        }

        public int getControlState(String state) {
            if (this.controlStateString_INITIAL.equals(state)) {
                return 1;
            }
            if (this.controlStateString_PAUSE.equals(state)) {
                return 2;
            }
            if (this.controlStateString_ABORT.equals(state)) {
                return 4;
            }
            if (this.controlStateString_FAILED.equals(state)) {
                return 5;
            }
            if (this.controlStateString_RESUME.equals(state)) {
                return 3;
            }
            return -1;
        }

        public String getCheckStateString(int state) {
            switch (state) {
                case 1: {
                    return this.checkStateString_INITIAL;
                }
                case 2: {
                    return this.checkStateString_TIMEOVER;
                }
            }
            return this.checkStateString_UNKNOWN;
        }

        public int getCheckState(String state) {
            if (this.checkStateString_INITIAL.equals(state)) {
                return 1;
            }
            if (this.checkStateString_TIMEOVER.equals(state)) {
                return 2;
            }
            return -1;
        }
    }

    public static class ScheduleGroupDependsMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_GROUP_DEPENDS_MST";
        public static final String DEFAULT_GROUP_ID = "GROUP_ID";
        public static final String DEFAULT_DEPENDS_GROUP_ID = "DEPENDS_GROUP_ID";
        public static final String DEFAULT_IGNORE_ERROR = "IGNORE_ERROR";
        public String table = "SCHEDULE_GROUP_DEPENDS_MST";
        public String groupId = "GROUP_ID";
        public String dependsGroupId = "DEPENDS_GROUP_ID";
        public String ignoreError = "IGNORE_ERROR";
    }

    public static class ScheduleGroupMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_GROUP_MST";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_GROUP_ID = "GROUP_ID";
        public String table = "SCHEDULE_GROUP_MST";
        public String id = "ID";
        public String groupId = "GROUP_ID";
    }

    public static class ScheduleDependsMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_DEPENDS_MST";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_DEPENDS_ID = "DEPENDS_ID";
        public static final String DEFAULT_DEPENDS_GROUP_ID = "DEPENDS_GROUP_ID";
        public static final String DEFAULT_GROUP_ID = "GROUP_ID";
        public static final String DEFAULT_IGNORE_ERROR = "IGNORE_ERROR";
        public String table = "SCHEDULE_DEPENDS_MST";
        public String id = "ID";
        public String dependsId = "DEPENDS_ID";
        public String dependsGroupId = "DEPENDS_GROUP_ID";
        public String groupId = "GROUP_ID";
        public String ignoreError = "IGNORE_ERROR";
    }

    public static class ScheduleMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_MST";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_TASK_NAME = "TASK_NAME";
        public static final String DEFAULT_SCHEDULE_TYPE = "SCHEDULE_TYPE";
        public static final String DEFAULT_INPUT = "INPUT";
        public static final String DEFAULT_START_TIME = "START_TIME";
        public static final String DEFAULT_END_TIME = "END_TIME";
        public static final String DEFAULT_REPEAT_INTERVAL = "REPEAT_INTERVAL";
        public static final String DEFAULT_RETRY_INTERVAL = "RETRY_INTERVAL";
        public static final String DEFAULT_RETRY_END_TIME = "RETRY_END_TIME";
        public static final String DEFAULT_MAX_DELAY_TIME = "MAX_DELAY_TIME";
        public static final String DEFAULT_ENABLE = "ENABLE";
        public static final String DEFAULT_EXECUTOR_KEY = "EXECUTOR_KEY";
        public static final String DEFAULT_EXECUTOR_TYPE = "EXECUTOR_TYPE";
        public static final String DEFAULT_TEMPLATE = "TEMPLATE";
        public String table = "SCHEDULE_MST";
        public String id = "ID";
        public String taskName = "TASK_NAME";
        public String scheduleType = "SCHEDULE_TYPE";
        public String input = "INPUT";
        public String startTime = "START_TIME";
        public String endTime = "END_TIME";
        public String repeatInterval = "REPEAT_INTERVAL";
        public String retryInterval = "RETRY_INTERVAL";
        public String retryEndTime = "RETRY_END_TIME";
        public String maxDelayTime = "MAX_DELAY_TIME";
        public String enable = "ENABLE";
        public String executorKey = "EXECUTOR_KEY";
        public String executorType = "EXECUTOR_TYPE";
        public String template = "TEMPLATE";
        public int inputColumnType = 12;

        protected Object getInputObject(ResultSet rs) throws IOException, ClassNotFoundException, SQLException {
            return DatabaseScheduleManagerService.getInOutObject(this.inputColumnType, this.input, rs);
        }
    }
}

