/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.sequence;

import java.io.Serializable;
import jp.ossc.nimbus.service.sequence.SequenceVariable;
import jp.ossc.nimbus.util.CsvArrayList;

public class SimpleSequenceVariable
implements SequenceVariable,
Serializable {
    private static final long serialVersionUID = -2852302890121212311L;
    public static final String DELIMITER = ",";
    private String mStartVal;
    private String mEndVal;
    private String mCurrentVal;

    public SimpleSequenceVariable(String format) {
        this(format, null);
    }

    public SimpleSequenceVariable(String format, String current) {
        CsvArrayList parser = new CsvArrayList();
        parser.split(format, DELIMITER);
        this.mStartVal = parser.getStr(0);
        this.mEndVal = parser.getStr(1);
        this.mCurrentVal = current == null ? this.mStartVal : current;
    }

    @Override
    public boolean increment() {
        char[] cValtmp = this.mCurrentVal.toCharArray();
        cValtmp[0] = (char)(cValtmp[0] + '\u0001');
        String incVal = new String(cValtmp);
        if (incVal.compareTo(this.mEndVal) > 0) {
            this.mCurrentVal = this.mStartVal;
            return true;
        }
        this.mCurrentVal = incVal;
        return false;
    }

    @Override
    public void clear() {
        this.mCurrentVal = this.mStartVal;
    }

    @Override
    public String getCurrent() {
        return this.mCurrentVal;
    }
}

