/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.soap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.handler.Handler;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.soap.PortException;
import jp.ossc.nimbus.service.soap.PortFactory;
import jp.ossc.nimbus.service.soap.WsPortFactoryServiceMBean;
import jp.ossc.nimbus.service.soap.WsServiceFactory;

public class WsPortFactoryService
extends ServiceBase
implements PortFactory,
WsPortFactoryServiceMBean {
    private static final long serialVersionUID = 7074638390846720787L;
    private static final String SEPARATOR = ",";
    private static final int PORT_NAME = 0;
    private static final int ENDPOINT_INTERFACE_NAME = 1;
    private ServiceName wsServiceFactoryName;
    private ServiceName[] handlerServiceNames;
    private String nameSpace;
    private Service wsService;
    private List handlerList;
    private Map requestContext;
    private Properties portAliasProp;

    public void setHandlerList(List list) {
        this.handlerList = list;
    }

    public List getHandlerList() {
        return this.handlerList;
    }

    @Override
    public void setHandlerServiceNames(ServiceName[] serviceNames) {
        this.handlerServiceNames = serviceNames;
    }

    @Override
    public ServiceName[] getHandlerServiceNames() {
        return this.handlerServiceNames;
    }

    @Override
    public Properties getPortAliasProp() {
        return this.portAliasProp;
    }

    @Override
    public void setPortAliasProp(Properties prop) {
        this.portAliasProp = prop;
    }

    @Override
    public ServiceName getWsServiceFactoryName() {
        return this.wsServiceFactoryName;
    }

    @Override
    public void setWsServiceFactoryName(ServiceName serviceName) {
        this.wsServiceFactoryName = serviceName;
    }

    @Override
    public void setRequestContext(String key, Object obj) {
        this.requestContext.put(key, obj);
    }

    @Override
    public Map getRequestContextMap() {
        return this.requestContext;
    }

    @Override
    public void createService() throws Exception {
        this.handlerList = new ArrayList();
        this.requestContext = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        if (this.wsServiceFactoryName == null) {
            throw new IllegalArgumentException("WsServiceFactoryName must be specified.");
        }
        if (this.portAliasProp == null) {
            throw new IllegalArgumentException("portAliasProp must be specified.");
        }
        if (this.handlerServiceNames != null) {
            for (int i = 0; i < this.handlerServiceNames.length; ++i) {
                try {
                    Handler handler = (Handler)ServiceManagerFactory.getServiceObject(this.handlerServiceNames[i]);
                    this.handlerList.add(handler);
                    continue;
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException(this.handlerServiceNames[i] + " is not instanceof Handler." + e);
                }
            }
        }
        WsServiceFactory wsServiceFactory = (WsServiceFactory)ServiceManagerFactory.getServiceObject(this.wsServiceFactoryName);
        this.nameSpace = wsServiceFactory.getNameSpace();
        this.wsService = wsServiceFactory.getService();
    }

    @Override
    public Object getPort(String portAlias) throws PortException {
        String portNameClassName = this.portAliasProp.getProperty(portAlias);
        String[] names = portNameClassName.split(SEPARATOR);
        if (names.length < 2) {
            return new PortException("port name or endpoint interface name is illegal : " + portNameClassName);
        }
        try {
            Class<?> endpointInterface = Class.forName(names[1]);
            QName portQN = new QName(this.nameSpace, names[0]);
            Object port = this.wsService.getPort(portQN, endpointInterface);
            if (this.handlerList != null && this.handlerList.size() > 0 && port instanceof BindingProvider) {
                BindingProvider bindingProvider = (BindingProvider)port;
                bindingProvider.getRequestContext().putAll(this.requestContext);
                Binding binding = bindingProvider.getBinding();
                List list = binding.getHandlerChain();
                for (int i = 0; i < this.handlerList.size(); ++i) {
                    Handler handler = (Handler)this.handlerList.get(i);
                    list.add(handler);
                }
                binding.setHandlerChain(list);
            }
            return endpointInterface.cast(port);
        }
        catch (Exception e) {
            throw new PortException(e);
        }
    }
}

