/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.system;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.system.DefaultHostResolverServiceMBean;
import jp.ossc.nimbus.service.system.HostResolver;

public class DefaultHostResolverService
extends ServiceBase
implements HostResolver,
DefaultHostResolverServiceMBean {
    private static final long serialVersionUID = 1871829402028214126L;
    protected Map hostMap;

    @Override
    public void setHostMap(String hostName, String address) {
        try {
            InetAddress inetAddress = InetAddress.getByName(address);
            this.hostMap.put(hostName, inetAddress);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Map getHostMap() {
        return this.hostMap;
    }

    @Override
    public void createService() throws Exception {
        this.hostMap = new HashMap();
    }

    @Override
    public InetAddress getLocalHost() {
        InetAddress result;
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
        InetAddress inetAddress = result = this.getHost(localhost.getHostName()) != null ? this.getHost(localhost.getHostName()) : this.getHost(localhost.getHostAddress());
        if (result == null) {
            result = localhost;
        }
        return result;
    }

    @Override
    public InetAddress getHost(String hostName) {
        return (InetAddress)this.hostMap.get(hostName);
    }
}

