/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.system;

import java.text.SimpleDateFormat;
import java.util.Date;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.system.DefaultTimeServiceMBean;
import jp.ossc.nimbus.service.system.Time;

public class DefaultTimeService
extends ServiceBase
implements Time,
DefaultTimeServiceMBean {
    private static final long serialVersionUID = -55472246209930175L;
    private Date time;
    private Date fixedTime;
    private int offsetDays;
    private int offsetHours;
    private int offsetMinutes;
    private int offsetSeconds;
    private long offsetTimeMillis;
    private long currentOffsetTimeMillis;

    @Override
    public void setOffsetDays(int days) {
        this.offsetDays = days;
    }

    @Override
    public int getOffsetDays() {
        return this.offsetDays;
    }

    @Override
    public void setOffsetHours(int hours) {
        this.offsetHours = hours;
    }

    @Override
    public int getOffsetHours() {
        return this.offsetHours;
    }

    @Override
    public void setOffsetMinutes(int minutes) {
        this.offsetMinutes = minutes;
    }

    @Override
    public int getOffsetMinutes() {
        return this.offsetMinutes;
    }

    @Override
    public void setOffsetSeconds(int seconds) {
        this.offsetSeconds = seconds;
    }

    @Override
    public int getOffsetSeconds() {
        return this.offsetSeconds;
    }

    @Override
    public void setOffsetTimeMillis(long offset) {
        this.offsetTimeMillis = offset;
    }

    @Override
    public long getOffsetTimeMillis() {
        return this.offsetTimeMillis;
    }

    @Override
    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    public Date getTime() {
        return this.time;
    }

    @Override
    public void setFixedTime(Date time) {
        this.fixedTime = time;
    }

    @Override
    public Date getFixedTime() {
        return this.fixedTime;
    }

    @Override
    public void startService() throws Exception {
        long tmpOffsetTimeMillis = 0L;
        if (this.time != null) {
            tmpOffsetTimeMillis = this.time.getTime() - System.currentTimeMillis();
        }
        tmpOffsetTimeMillis += (long)(this.offsetDays * 24 * 60 * 60 * 1000);
        tmpOffsetTimeMillis += (long)(this.offsetHours * 60 * 60 * 1000);
        tmpOffsetTimeMillis += (long)(this.offsetMinutes * 60 * 1000);
        tmpOffsetTimeMillis += (long)(this.offsetSeconds * 1000);
        this.currentOffsetTimeMillis = tmpOffsetTimeMillis += this.offsetTimeMillis;
    }

    @Override
    public long currentTimeMillis() {
        if (this.fixedTime == null) {
            return System.currentTimeMillis() + this.currentOffsetTimeMillis;
        }
        return this.fixedTime.getTime();
    }

    @Override
    public String getCurrentTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        return format.format(new Date(this.currentTimeMillis()));
    }
}

