/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.template;

import java.io.File;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.template.TemplateEngine;
import jp.ossc.nimbus.service.template.TemplateTransformException;
import jp.ossc.nimbus.service.template.VelocityTemplateEngineServiceMBean;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;

public class VelocityTemplateEngineService
extends ServiceBase
implements TemplateEngine,
VelocityTemplateEngineServiceMBean {
    private static final long serialVersionUID = 857696261805500113L;
    private File templateFileRootDirectory;
    private Properties properties;
    private Map templateMap;
    private String characterEncoding;
    private VelocityEngine engine;
    private String stringRespositoryName;

    @Override
    public void setTemplateFileRootDirectory(File dir) {
        this.templateFileRootDirectory = dir;
    }

    @Override
    public File getTemplateFileRootDirectory() {
        return this.templateFileRootDirectory;
    }

    @Override
    public void setProperties(Properties props) {
        this.properties = props;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public void setTemplate(String name, String template) {
        this.setTemplate(name, template, null);
    }

    @Override
    public void setTemplate(String name, String template, String encoding) {
        if (encoding == null) {
            encoding = this.characterEncoding;
        }
        TemplateResource resource = new TemplateResource();
        resource.template = template;
        resource.encoding = encoding;
        this.templateMap.put(name, resource);
        if (this.engine != null) {
            StringResourceRepository repository = (StringResourceRepository)this.engine.getApplicationAttribute((Object)this.stringRespositoryName);
            if (encoding == null) {
                repository.putStringResource(name, template);
            } else {
                repository.putStringResource(name, template, encoding);
            }
        }
    }

    @Override
    public void setTemplateFile(String name, File templateFile) {
        this.setTemplateFile(name, templateFile, null);
    }

    @Override
    public void setTemplateFile(String name, File templateFile, String encoding) {
        TemplateResource resource = new TemplateResource();
        resource.templateFile = templateFile;
        resource.encoding = encoding == null ? this.characterEncoding : encoding;
        this.templateMap.put(name, resource);
    }

    @Override
    public void createService() throws Exception {
        this.templateMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void startService() throws Exception {
        this.engine = new VelocityEngine();
        Properties props = this.properties == null ? new Properties() : this.properties;
        props.setProperty("resource.loader", "string, file");
        if (this.templateFileRootDirectory != null) {
            props.setProperty("file.resource.loader.path", this.templateFileRootDirectory.getCanonicalPath());
        }
        props.setProperty("string.resource.loader.repository.static", "false");
        this.stringRespositoryName = props.getProperty("repository.name");
        if (this.stringRespositoryName == null) {
            this.stringRespositoryName = StringResourceLoader.REPOSITORY_NAME_DEFAULT;
        }
        this.engine.init(props);
        if (this.templateMap.size() != 0) {
            StringResourceRepository repository = (StringResourceRepository)this.engine.getApplicationAttribute((Object)this.stringRespositoryName);
            for (Map.Entry entry : this.templateMap.entrySet()) {
                String name = (String)entry.getKey();
                TemplateResource resource = (TemplateResource)entry.getValue();
                if (resource.template == null) continue;
                if (resource.encoding == null) {
                    repository.putStringResource(name, resource.template);
                    continue;
                }
                repository.putStringResource(name, resource.template, resource.encoding);
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        this.engine = null;
    }

    @Override
    public void destroyService() throws Exception {
        this.templateMap = null;
    }

    @Override
    public String transform(String name, Map dataMap) throws TemplateTransformException {
        TemplateResource resource = (TemplateResource)this.templateMap.get(name);
        String templateName = name;
        if (resource != null && resource.templateFile != null) {
            templateName = resource.templateFile.getPath();
        }
        Template template = null;
        if (resource == null) {
            template = this.characterEncoding == null ? this.engine.getTemplate(templateName) : this.engine.getTemplate(templateName, this.characterEncoding);
        } else {
            Template template2 = template = resource.encoding == null ? this.engine.getTemplate(templateName) : this.engine.getTemplate(templateName, resource.encoding);
        }
        if (template == null) {
            throw new TemplateTransformException("Template not found. name=" + name);
        }
        StringWriter sw = new StringWriter();
        try {
            template.merge((Context)new VelocityContext(dataMap), (Writer)sw);
        }
        catch (Exception e) {
            throw new TemplateTransformException("Transform failed. name=" + name, e);
        }
        return sw.toString();
    }

    private static class TemplateResource
    implements Serializable {
        private static final long serialVersionUID = 3495957954376521011L;
        public String template;
        public File templateFile;
        public String encoding;

        private TemplateResource() {
        }
    }
}

