/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.test.ChainEvaluateTestAction;
import jp.ossc.nimbus.service.test.ChainEvaluateTestActionServiceMBean;
import jp.ossc.nimbus.service.test.ChainTestAction;
import jp.ossc.nimbus.service.test.EvaluateTestAction;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;

public class ChainEvaluateTestActionService
extends ServiceBase
implements ChainEvaluateTestActionServiceMBean,
ChainEvaluateTestAction,
TestActionEstimation {
    private static final long serialVersionUID = 2163058114046456244L;
    protected ServiceName[] actionServiceNames;
    protected ServiceName endEvaluateTestActionName;
    protected List actionList;
    protected EvaluateTestAction endEvaluateTestAction;
    protected ChainEvaluateTestAction.EvaluateTestActionProcess endEvaluateTestActionProcess;

    @Override
    public ServiceName[] getActionServiceNames() {
        return this.actionServiceNames;
    }

    @Override
    public void setActionServiceNames(ServiceName[] serviceNames) {
        this.actionServiceNames = serviceNames;
    }

    @Override
    public ServiceName getEndEvaluateTestActionServiceName() {
        return this.endEvaluateTestActionName;
    }

    @Override
    public void setEndEvaluateTestActionServiceName(ServiceName name) {
        this.endEvaluateTestActionName = name;
    }

    public void setEndEvaluateTestAction(EvaluateTestAction action) {
        this.endEvaluateTestAction = action;
    }

    public void setEndEvaluateTestActionProcess(ChainEvaluateTestAction.EvaluateTestActionProcess action) {
        this.endEvaluateTestActionProcess = action;
    }

    @Override
    public void createService() throws Exception {
        this.actionList = new ArrayList();
    }

    @Override
    public void startService() throws Exception {
        if (this.endEvaluateTestActionName != null) {
            Object action = ServiceManagerFactory.getServiceObject(this.endEvaluateTestActionName);
            if (action instanceof EvaluateTestAction) {
                this.endEvaluateTestAction = (EvaluateTestAction)action;
            } else if (action instanceof ChainEvaluateTestAction.EvaluateTestActionProcess) {
                this.endEvaluateTestActionProcess = (ChainEvaluateTestAction.EvaluateTestActionProcess)action;
            } else {
                throw new IllegalArgumentException("EndEvaluateTestAction is illegal. action=" + action.getClass());
            }
        }
        if (this.endEvaluateTestAction == null && this.endEvaluateTestActionProcess == null) {
            throw new IllegalArgumentException("EndEvaluateTestAction is null.");
        }
        if (this.actionServiceNames != null) {
            this.actionList.clear();
            for (int i = 0; i < this.actionServiceNames.length; ++i) {
                Object action = ServiceManagerFactory.getServiceObject(this.actionServiceNames[i]);
                if (!(action instanceof TestAction || action instanceof EvaluateTestAction || action instanceof ChainTestAction.TestActionProcess || action instanceof ChainEvaluateTestAction.EvaluateTestActionProcess)) {
                    throw new IllegalArgumentException("ActionServiceNames[" + i + "] is not TestAction. ServiceName=" + this.actionServiceNames[i]);
                }
                this.actionList.add(action);
            }
        }
        if (this.endEvaluateTestAction != null) {
            this.actionList.add(this.endEvaluateTestAction);
        } else {
            this.actionList.add(this.endEvaluateTestActionProcess);
        }
    }

    @Override
    public boolean execute(TestContext context, String actionId, Reader[] resources) throws Exception {
        if (resources.length != this.actionList.size()) {
            throw new IllegalArgumentException("ResourceFile count is illegal. Actions count=" + this.actionList.size() + " ResourceFiles count=" + resources.length);
        }
        boolean actionResult = true;
        Object preResult = null;
        boolean isPreEvaluateAction = false;
        int iMax = this.actionList.size();
        for (int i = 0; i < iMax; ++i) {
            Object action = this.actionList.get(i);
            String childActionId = actionId + '_' + (i + 1);
            resources[i].reset();
            if (i == 0) {
                if (action instanceof TestAction) {
                    preResult = ((TestAction)action).execute(context, childActionId, resources[i]);
                    isPreEvaluateAction = false;
                } else if (action instanceof EvaluateTestAction) {
                    actionResult = ((EvaluateTestAction)action).execute(context, childActionId, resources[i]);
                    preResult = null;
                    isPreEvaluateAction = true;
                } else if (action instanceof ChainTestAction.TestActionProcess) {
                    preResult = ((ChainTestAction.TestActionProcess)action).execute(context, childActionId, preResult, resources[i]);
                    isPreEvaluateAction = false;
                } else if (action instanceof ChainEvaluateTestAction.EvaluateTestActionProcess) {
                    actionResult = ((ChainEvaluateTestAction.EvaluateTestActionProcess)action).execute(context, childActionId, preResult, resources[i]);
                    preResult = null;
                    isPreEvaluateAction = true;
                }
            } else if (i == iMax - 1) {
                if (action instanceof ChainEvaluateTestAction.EvaluateTestActionProcess) {
                    actionResult = action instanceof EvaluateTestAction && isPreEvaluateAction ? ((EvaluateTestAction)action).execute(context, childActionId, resources[i]) : ((ChainEvaluateTestAction.EvaluateTestActionProcess)action).execute(context, childActionId, preResult, resources[i]);
                } else if (action instanceof EvaluateTestAction) {
                    actionResult = ((EvaluateTestAction)action).execute(context, childActionId, resources[i]);
                }
            } else if (isPreEvaluateAction) {
                if (action instanceof TestAction) {
                    preResult = ((TestAction)action).execute(context, childActionId, resources[i]);
                    isPreEvaluateAction = false;
                } else if (action instanceof EvaluateTestAction) {
                    actionResult = ((EvaluateTestAction)action).execute(context, childActionId, resources[i]);
                    preResult = null;
                    isPreEvaluateAction = true;
                } else if (action instanceof ChainTestAction.TestActionProcess) {
                    preResult = ((ChainTestAction.TestActionProcess)action).execute(context, childActionId, preResult, resources[i]);
                    isPreEvaluateAction = false;
                } else if (action instanceof ChainEvaluateTestAction.EvaluateTestActionProcess) {
                    actionResult = ((ChainEvaluateTestAction.EvaluateTestActionProcess)action).execute(context, childActionId, preResult, resources[i]);
                    preResult = null;
                    isPreEvaluateAction = true;
                }
            } else if (action instanceof ChainTestAction.TestActionProcess) {
                preResult = ((ChainTestAction.TestActionProcess)action).execute(context, childActionId, preResult, resources[i]);
                isPreEvaluateAction = false;
            } else if (action instanceof ChainEvaluateTestAction.EvaluateTestActionProcess) {
                actionResult = ((ChainEvaluateTestAction.EvaluateTestActionProcess)action).execute(context, childActionId, preResult, resources[i]);
                preResult = null;
                isPreEvaluateAction = true;
            } else if (action instanceof TestAction) {
                preResult = ((TestAction)action).execute(context, childActionId, resources[i]);
                isPreEvaluateAction = false;
            } else if (action instanceof EvaluateTestAction) {
                actionResult = ((EvaluateTestAction)action).execute(context, childActionId, resources[i]);
                preResult = null;
                isPreEvaluateAction = true;
            }
            if (!isPreEvaluateAction) {
                context.setTestActionResult(childActionId, preResult);
            }
            if (actionResult) continue;
            return false;
        }
        return actionResult;
    }

    @Override
    public double getExpectedCost() {
        if (this.actionList == null || this.actionList.size() == 0) {
            return 0.0;
        }
        double result = 0.0;
        for (int i = 0; i < this.actionList.size(); ++i) {
            Object action = this.actionList.get(i);
            if (!(action instanceof TestActionEstimation)) continue;
            result += ((TestActionEstimation)action).getExpectedCost();
        }
        return result;
    }
}

