/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test;

import java.io.Reader;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.test.ChainTestAction;
import jp.ossc.nimbus.service.test.ChainTestActionServiceMBean;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;

public class ChainTestActionService
extends ServiceBase
implements ChainTestActionServiceMBean,
ChainTestAction,
TestActionEstimation {
    private static final long serialVersionUID = -6007344125808912954L;
    protected ServiceName[] actionServiceNames;
    protected Object[] actions;

    @Override
    public ServiceName[] getActionServiceNames() {
        return this.actionServiceNames;
    }

    @Override
    public void setActionServiceNames(ServiceName[] serviceNames) {
        this.actionServiceNames = serviceNames;
    }

    public Object[] getActions() {
        return this.actions;
    }

    public void setActions(Service[] actions) {
        this.actions = actions;
    }

    @Override
    public void startService() throws Exception {
        if (this.actionServiceNames != null) {
            this.actions = new Object[this.actionServiceNames.length];
            for (int i = 0; i < this.actionServiceNames.length; ++i) {
                Object action = ServiceManagerFactory.getServiceObject(this.actionServiceNames[i]);
                if (!(action instanceof TestAction) && !(action instanceof ChainTestAction.TestActionProcess)) {
                    throw new IllegalArgumentException("ActionServiceNames[" + i + "] is not TestAction or TestActionProcess. ServiceName=" + this.actionServiceNames[i]);
                }
                this.actions[i] = action;
            }
        }
        if (this.actions == null || this.actions.length == 0) {
            throw new IllegalArgumentException("Actions is null.");
        }
    }

    @Override
    public Object execute(TestContext context, String actionId, Reader[] resources) throws Exception {
        if (resources.length != this.actions.length) {
            throw new IllegalArgumentException("ResourceFile count is illegal. Actions count=" + this.actions.length + " ResourceFiles count=" + resources.length);
        }
        Object result = null;
        for (int i = 0; i < this.actions.length; ++i) {
            String childActionId = actionId + '_' + (i + 1);
            resources[i].reset();
            result = this.actions[i] instanceof ChainTestAction.TestActionProcess ? ((ChainTestAction.TestActionProcess)this.actions[i]).execute(context, childActionId, result, resources[i]) : ((TestAction)this.actions[i]).execute(context, childActionId, resources[i]);
            context.setTestActionResult(childActionId, result);
        }
        return result;
    }

    @Override
    public double getExpectedCost() {
        if (this.actions == null || this.actions.length == 0) {
            return 0.0;
        }
        double result = 0.0;
        for (int i = 0; i < this.actions.length; ++i) {
            if (!(this.actions[i] instanceof TestActionEstimation)) continue;
            result += ((TestActionEstimation)this.actions[i]).getExpectedCost();
        }
        return result;
    }
}

