/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.ossc.nimbus.service.test.ScheduledTestResourceImpl;
import jp.ossc.nimbus.service.test.StatusActionMnagerImpl;
import jp.ossc.nimbus.service.test.TestCase;
import jp.ossc.nimbus.service.test.TestController;

public class TestCaseImpl
implements TestCase,
Serializable {
    private static final long serialVersionUID = -6162505630673773840L;
    private transient TestController controller;
    private String scenarioGroupId;
    private String scenarioId;
    private String testCaseId;
    private TestCase.TestCaseResource resource;

    public TestCaseImpl(String scenarioGroupId, String scenarioId, String testCaseId) {
        this.scenarioGroupId = scenarioGroupId;
        this.scenarioId = scenarioId;
        this.testCaseId = testCaseId;
    }

    public TestController getController() {
        return this.controller;
    }

    public void setController(TestController controller) {
        this.controller = controller;
    }

    @Override
    public String getScenarioGroupId() {
        return this.scenarioGroupId;
    }

    public void setScenarioGroupId(String scenarioGroupId) {
        this.scenarioGroupId = scenarioGroupId;
    }

    @Override
    public String getScenarioId() {
        return this.scenarioId;
    }

    public void setScenarioId(String scenarioId) {
        this.scenarioId = scenarioId;
    }

    @Override
    public String getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(String testCaseId) {
        this.testCaseId = testCaseId;
    }

    @Override
    public TestCase.TestCaseResource getTestCaseResource() throws Exception {
        if (this.controller == null) {
            return null;
        }
        if (this.resource == null) {
            this.resource = this.controller.getTestCaseResource(this.scenarioGroupId, this.scenarioId, this.testCaseId);
        }
        return this.resource;
    }

    public void clearResource() {
        this.resource = null;
    }

    @Override
    public TestCase.Status getStatus() {
        if (this.controller == null) {
            return null;
        }
        return this.controller.getTestCaseStatus(this.scenarioGroupId, this.scenarioId, this.testCaseId);
    }

    public static class StatusImpl
    extends StatusActionMnagerImpl
    implements TestCase.Status,
    Serializable {
        private static final long serialVersionUID = -7143853279718341505L;
        private int state = 0;
        private Date endTime;

        public StatusImpl(String userId) {
            super(userId);
        }

        public void setState(int state) {
            this.state = state;
        }

        @Override
        public int getState() {
            return this.state;
        }

        @Override
        public String getStateString() {
            String stateStr = null;
            switch (this.state) {
                case 0: {
                    stateStr = "INITIAL";
                    break;
                }
                case 1: {
                    stateStr = "STARTED";
                    break;
                }
                case 4: {
                    stateStr = "ERROR";
                    break;
                }
                case 2: {
                    stateStr = "END";
                    break;
                }
                default: {
                    stateStr = "INITIAL";
                }
            }
            return stateStr;
        }

        public void setEndTime(Date time) {
            this.endTime = time;
        }

        @Override
        public Date getEndTime() {
            return this.endTime;
        }

        public String toString() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            StringBuffer buf = new StringBuffer();
            buf.append("UserId=" + this.getUserId());
            if (this.getStartTime() != null) {
                buf.append(", StartTime=" + sdf.format(this.getStartTime()));
            } else {
                buf.append(", StartTime=null");
            }
            if (this.endTime != null) {
                buf.append(", EndTime=" + sdf.format(this.endTime));
            } else {
                buf.append(", EndTime=null");
            }
            buf.append(", State=" + this.getStateString());
            buf.append(", CurrentActionId=" + this.getCurrentActionId());
            buf.append(", Result=" + this.getResult());
            if (this.getThrowable() != null) {
                buf.append(", Throwable=" + this.getThrowable().getClass().getName() + "[" + this.getThrowable().getMessage() + "]");
            } else {
                buf.append(", Throwable=null");
            }
            buf.append(", actionResultMap=" + this.getActionResultMap());
            return buf.toString();
        }
    }

    public static class TestCaseResourceImpl
    extends ScheduledTestResourceImpl
    implements TestCase.TestCaseResource,
    Serializable {
        private static final long serialVersionUID = 8324797929502673706L;
        private String[] beforeActionIds;
        private String[] actionIds;
        private String[] afterActionIds;
        private String[] finallyActionIds;

        @Override
        public String[] getBeforeActionIds() {
            return this.beforeActionIds;
        }

        public void setBeforeActionIds(String[] actionIds) {
            this.beforeActionIds = actionIds;
        }

        @Override
        public String[] getActionIds() {
            return this.actionIds;
        }

        public void setActionIds(String[] actionIds) {
            this.actionIds = actionIds;
        }

        @Override
        public String[] getAfterActionIds() {
            return this.afterActionIds;
        }

        public void setAfterActionIds(String[] actionIds) {
            this.afterActionIds = actionIds;
        }

        @Override
        public String[] getFinallyActionIds() {
            return this.finallyActionIds;
        }

        public void setFinallyActionIds(String[] actionIds) {
            this.finallyActionIds = actionIds;
        }
    }
}

