/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.StringArrayEditor;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.NimbusEntityResolver;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.service.test.ChainEvaluateTestAction;
import jp.ossc.nimbus.service.test.ChainTestAction;
import jp.ossc.nimbus.service.test.EvaluateTestAction;
import jp.ossc.nimbus.service.test.RetryEvaluateTestAction;
import jp.ossc.nimbus.service.test.ScheduledTestResourceImpl;
import jp.ossc.nimbus.service.test.StatusActionMnagerImpl;
import jp.ossc.nimbus.service.test.StubResourceManager;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionContext;
import jp.ossc.nimbus.service.test.TestActionContextImpl;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestCase;
import jp.ossc.nimbus.service.test.TestCaseImpl;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.TestContextImpl;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestControllerServiceMBean;
import jp.ossc.nimbus.service.test.TestEventListener;
import jp.ossc.nimbus.service.test.TestException;
import jp.ossc.nimbus.service.test.TestPhaseExecutableImpl;
import jp.ossc.nimbus.service.test.TestResourceBaseImpl;
import jp.ossc.nimbus.service.test.TestResourceManager;
import jp.ossc.nimbus.service.test.TestScenario;
import jp.ossc.nimbus.service.test.TestScenarioGroup;
import jp.ossc.nimbus.service.test.TestScenarioGroupImpl;
import jp.ossc.nimbus.service.test.TestScenarioImpl;
import jp.ossc.nimbus.service.test.TestStub;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestControllerService
extends ServiceBase
implements TestControllerServiceMBean,
TestController {
    private static final long serialVersionUID = -3863242200184576264L;
    protected ServiceName testResourceManagerServiceName;
    protected TestResourceManager testResourceManager;
    protected ServiceName stubResourceManagerServiceName;
    protected StubResourceManager stubResourceManager;
    protected ServiceName[] testStubServiceNames;
    protected TestStub[] testStubs;
    protected ServiceName[] testEventListenerServiceNames;
    protected TestEventListener[] testEventListeners;
    protected File testResourceFileBaseDirectory;
    protected File testResourceFileTempDirectory;
    protected File internalTestResourceFileTempDirectory;
    protected String testPhase;
    protected String scenarioGroupResourceFileName = "scenarioGroup.xml";
    protected String scenarioResourceFileName = "scenario.xml";
    protected String testCaseResourceFileName = "testcase.xml";
    protected String userIdPropertyKeyName = "test.executer";
    protected Map contextMap;
    protected TestScenarioGroup currentTestScenarioGroup;
    protected TestScenario currentTestScenario;
    protected TestCase currentTestCase;

    @Override
    public ServiceName getTestResourceManagerServiceName() {
        return this.testResourceManagerServiceName;
    }

    @Override
    public void setTestResourceManagerServiceName(ServiceName serviceName) {
        this.testResourceManagerServiceName = serviceName;
    }

    @Override
    public TestResourceManager getTestResourceManager() {
        return this.testResourceManager;
    }

    @Override
    public void setTestResourceManager(TestResourceManager manager) {
        this.testResourceManager = manager;
    }

    @Override
    public ServiceName getStubResourceManagerServiceName() {
        return this.stubResourceManagerServiceName;
    }

    @Override
    public void setStubResourceManagerServiceName(ServiceName serviceName) {
        this.stubResourceManagerServiceName = serviceName;
    }

    @Override
    public StubResourceManager getStubResourceManager() {
        return this.stubResourceManager;
    }

    @Override
    public void setStubResourceManager(StubResourceManager manager) {
        this.stubResourceManager = manager;
    }

    @Override
    public ServiceName[] getTestStubServiceNames() {
        return this.testStubServiceNames;
    }

    @Override
    public void setTestStubServiceNames(ServiceName[] serviceNames) {
        this.testStubServiceNames = serviceNames;
    }

    @Override
    public TestStub[] getTestStubs() {
        return this.testStubs;
    }

    @Override
    public void setTestStubs(TestStub[] stubs) {
        this.testStubs = stubs;
    }

    @Override
    public ServiceName[] getTestEventListenerServiceNames() {
        return this.testEventListenerServiceNames;
    }

    @Override
    public void setTestEventListenerServiceNames(ServiceName[] serviceNames) {
        this.testEventListenerServiceNames = serviceNames;
    }

    @Override
    public TestEventListener[] getTestEventListeners() {
        return this.testEventListeners;
    }

    @Override
    public void setTestEventListeners(TestEventListener[] listeners) {
        this.testEventListeners = listeners;
    }

    @Override
    public File getTestResourceFileBaseDirectory() {
        return this.testResourceFileBaseDirectory;
    }

    @Override
    public void setTestResourceFileBaseDirectory(File dir) {
        this.testResourceFileBaseDirectory = dir;
    }

    @Override
    public File getTestResourceFileTempDirectory() {
        return this.testResourceFileTempDirectory;
    }

    @Override
    public void setTestResourceFileTempDirectory(File dir) {
        this.testResourceFileTempDirectory = dir;
    }

    @Override
    public String getScenarioGroupResourceFileName() {
        return this.scenarioGroupResourceFileName;
    }

    @Override
    public void setScenarioGroupResourceFileName(String fileName) {
        this.scenarioGroupResourceFileName = fileName;
    }

    @Override
    public String getScenarioResourceFileName() {
        return this.scenarioResourceFileName;
    }

    @Override
    public void setTestCaseResourceFileName(String fileName) {
        this.testCaseResourceFileName = fileName;
    }

    @Override
    public String getTestCaseResourceFileName() {
        return this.testCaseResourceFileName;
    }

    @Override
    public void setScenarioResourceFileName(String fileName) {
        this.scenarioResourceFileName = fileName;
    }

    @Override
    public void setTestPhase(String phase) {
        this.testPhase = phase;
    }

    @Override
    public String getTestPhase() {
        return this.testPhase;
    }

    public String getUserIdPropertyKeyName() {
        return this.userIdPropertyKeyName;
    }

    public void setUserIdPropertyKeyName(String name) {
        this.userIdPropertyKeyName = name;
    }

    @Override
    public void createService() throws Exception {
        this.contextMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void startService() throws Exception {
        int i;
        if (this.testResourceManagerServiceName != null) {
            this.testResourceManager = (TestResourceManager)ServiceManagerFactory.getServiceObject(this.testResourceManagerServiceName);
        }
        if (this.testResourceManager == null) {
            throw new IllegalArgumentException("TestResourceManager is null.");
        }
        if (this.testEventListenerServiceNames != null) {
            this.testEventListeners = new TestEventListener[this.testEventListenerServiceNames.length];
            for (i = 0; i < this.testEventListenerServiceNames.length; ++i) {
                this.testEventListeners[i] = (TestEventListener)ServiceManagerFactory.getServiceObject(this.testEventListenerServiceNames[i]);
            }
        }
        if (this.testStubServiceNames != null) {
            this.testStubs = new TestStub[this.testStubServiceNames.length];
            for (i = 0; i < this.testStubServiceNames.length; ++i) {
                this.testStubs[i] = (TestStub)ServiceManagerFactory.getServiceObject(this.testStubServiceNames[i]);
            }
        }
        if (this.testStubs != null && this.testStubs.length > 0) {
            if (this.stubResourceManagerServiceName != null) {
                this.stubResourceManager = (StubResourceManager)ServiceManagerFactory.getServiceObject(this.stubResourceManagerServiceName);
            }
            if (this.stubResourceManager == null) {
                throw new IllegalArgumentException("StubResourceManager is null.");
            }
        }
        if (this.testResourceFileBaseDirectory == null) {
            throw new IllegalArgumentException("TestResourceFileBaseDir is null.");
        }
        this.setupDir(this.testResourceFileBaseDirectory, false);
        if (this.testResourceFileTempDirectory == null) {
            this.testResourceFileTempDirectory = new File(System.getProperty("java.io.tmpdir"));
        }
        this.internalTestResourceFileTempDirectory = new File(this.testResourceFileTempDirectory, this.getClass().getName());
        if (!this.internalTestResourceFileTempDirectory.exists() && !this.internalTestResourceFileTempDirectory.mkdirs()) {
            throw new IOException("Directory can not make. path=" + this.internalTestResourceFileTempDirectory);
        }
        String tmpDirName = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        long count = 0L;
        File tmpDir = null;
        while ((tmpDir = new File(this.internalTestResourceFileTempDirectory, tmpDirName = tmpDirName + count++)).exists()) {
        }
        if (!tmpDir.mkdir()) {
            throw new IOException("TemporaryDirectory can not make. path=" + tmpDir);
        }
        this.internalTestResourceFileTempDirectory = tmpDir;
        this.testResourceManager.checkOut();
    }

    @Override
    public void stopService() throws Exception {
        if (this.internalTestResourceFileTempDirectory != null && this.internalTestResourceFileTempDirectory.exists()) {
            RecurciveSearchFile.deleteAllTree(this.internalTestResourceFileTempDirectory);
        }
    }

    @Override
    public synchronized void startScenarioGroup(String userId, String scenarioGroupId) throws Exception {
        this.getLogger().write("TC___00005", new Object[]{scenarioGroupId, userId});
        try {
            this.setUserId(userId);
            if (this.currentTestScenarioGroup != null) {
                throw new TestException("ScenarioGroup is already started. ScenarioGroupId=" + this.currentTestScenarioGroup.getScenarioGroupId() + " UserId=" + this.currentTestScenarioGroup.getStatus().getUserId());
            }
            String[] scenarioGroupIds = this.testResourceManager.getScenarioGroupIds();
            if (!Arrays.asList(scenarioGroupIds).contains(scenarioGroupId)) {
                throw new TestException("This ScenarioGroupId does not exist. ScenarioGroupId=" + scenarioGroupId);
            }
            File resourceDir = new File(this.testResourceFileBaseDirectory, scenarioGroupId);
            this.downloadTestScenarioGroupResource(resourceDir, scenarioGroupId);
            if (this.testEventListeners != null) {
                for (int i = 0; i < this.testEventListeners.length; ++i) {
                    this.testEventListeners[i].startScenarioGroup(userId, scenarioGroupId);
                }
            }
            TestScenarioGroupImpl testScenarioGroup = new TestScenarioGroupImpl(scenarioGroupId);
            testScenarioGroup.setController(this);
            TestScenarioGroupContext context = new TestScenarioGroupContext();
            this.contextMap.put(scenarioGroupId, context);
            context.setTestScenarioGroup(testScenarioGroup);
            TestScenarioGroupImpl.StatusImpl status = new TestScenarioGroupImpl.StatusImpl(userId);
            context.setStatus(status);
            TestContextImpl testContext = new TestContextImpl();
            testContext.setCurrentDirectory(resourceDir);
            context.setTestContext(testContext);
            testContext.setTestScenarioGroup(testScenarioGroup);
            TestScenarioGroup.TestScenarioGroupResource testScenarioGroupResource = testScenarioGroup.getTestScenarioGroupResource();
            if (this.testPhase == null || testScenarioGroupResource.isExecutable(this.testPhase)) {
                String[] beforeActionIds = testScenarioGroupResource.getBeforeActionIds();
                try {
                    this.executeAction(context, testContext, status, beforeActionIds, true, true, true);
                }
                catch (NotSupportActionException e) {
                    throw new TestException("This action is not support at BeforeAction of ScenarioGroup. action=" + e.getAction().getClass().getName());
                }
                boolean result = context.isAllActionSuccess();
                status.setResult(result);
                status.setStartTime(new Date());
                if (result) {
                    status.setState(1);
                } else {
                    status.setState(4);
                }
            }
            this.currentTestScenarioGroup = testScenarioGroup;
        }
        catch (Exception e) {
            this.getLogger().write("TC___00006", (Object)scenarioGroupId, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void endScenarioGroup() throws Exception {
        if (this.currentTestScenarioGroup == null) {
            return;
        }
        this.getLogger().write("TC___00007", (Object)this.currentTestScenarioGroup.getScenarioGroupId());
        try {
            TestScenarioContext[] testScenarioContexts;
            this.setUserId(null);
            TestScenarioGroupContext context = (TestScenarioGroupContext)this.contextMap.get(this.currentTestScenarioGroup.getScenarioGroupId());
            if (context == null) {
                throw new TestException("ScenarioGroup is not started. scenarioGroupId=" + this.currentTestScenarioGroup.getScenarioGroupId());
            }
            if (context != null && (testScenarioContexts = context.getTestScenarioContexts()) != null) {
                for (int i = 0; i < testScenarioContexts.length; ++i) {
                    TestScenario.Status scenarioStatus = testScenarioContexts[i].getStatus();
                    if (scenarioStatus == null || scenarioStatus.getState() != 1) continue;
                    this.endScenario(testScenarioContexts[i].getTestScenario().getScenarioId());
                }
            }
            if (this.testEventListeners != null) {
                for (int i = 0; i < this.testEventListeners.length; ++i) {
                    this.testEventListeners[i].endScenarioGroup();
                }
            }
            TestContextImpl scenarioGroupTestContext = (TestContextImpl)context.getTestContext();
            TestScenarioGroup testScenarioGroup = context.getTestScenarioGroup();
            TestScenarioGroup.TestScenarioGroupResource testScenarioGroupResource = testScenarioGroup.getTestScenarioGroupResource();
            if (this.testPhase == null || testScenarioGroupResource.isExecutable(this.testPhase)) {
                TestScenarioGroupImpl.StatusImpl status = (TestScenarioGroupImpl.StatusImpl)context.getStatus();
                String[] finallyActionIds = testScenarioGroupResource.getFinallyActionIds();
                try {
                    this.executeAction(context, scenarioGroupTestContext, status, finallyActionIds, true, false, false);
                }
                catch (NotSupportActionException e) {
                    throw new TestException("This action is not support at FinallyAction of ScenarioGroup. action=" + e.getAction().getClass().getName());
                }
                status.setState(2);
                status.setEndTime(new Date());
            }
            this.currentTestScenarioGroup = null;
            this.currentTestScenario = null;
            this.currentTestCase = null;
        }
        catch (Exception e) {
            this.getLogger().write("TC___00008", (Object)this.currentTestScenarioGroup.getScenarioGroupId(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startScenario(String userId, String scenarioId) throws Exception {
        this.getLogger().write("TC___00009", new Object[]{this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId, userId});
        try {
            int i;
            this.setUserId(userId);
            if (this.currentTestScenarioGroup == null) {
                throw new TestException("ScenarioGroup is not start.");
            }
            if (this.currentTestScenario != null) {
                throw new TestException("Scenario is already started. ScenarioGroupId=" + this.currentTestScenario.getScenarioGroupId() + " ScenarioId=" + this.currentTestScenario.getScenarioId() + " UserId=" + this.currentTestScenario.getStatus().getUserId());
            }
            String[] scenarioIds = this.testResourceManager.getScenarioIds(this.currentTestScenarioGroup.getScenarioGroupId());
            if (!Arrays.asList(scenarioIds).contains(scenarioId)) {
                throw new TestException("This ScenarioId does not exist. ScenarioGroupId=" + this.currentTestScenarioGroup.getScenarioGroupId() + " ScenarioId=" + scenarioId);
            }
            TestScenarioGroupContext groupContext = (TestScenarioGroupContext)this.contextMap.get(this.currentTestScenarioGroup.getScenarioGroupId());
            TestScenarioContext context = groupContext.getTestScenarioContext(scenarioId);
            if (context != null) {
                ((TestScenarioImpl)context.getTestScenario()).clearResource();
                TestScenario.Status scenarioStatus = context.getStatus();
                if (scenarioStatus.getState() == 1) {
                    if (scenarioStatus.getUserId() != null && !scenarioStatus.getUserId().equals(userId)) {
                        throw new TestException("TestScenario is Stated by another user. testScenarioId=" + scenarioId + " userId=" + scenarioStatus.getUserId());
                    }
                    this.cancelScenario(scenarioId);
                }
            }
            context = new TestScenarioContext();
            RecurciveSearchFile resourceDir = new RecurciveSearchFile(this.testResourceFileBaseDirectory, this.currentTestScenarioGroup.getScenarioGroupId() + File.separator + scenarioId);
            this.downloadTestScenarioResource(resourceDir, this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId);
            if (this.testStubs != null) {
                for (i = 0; i < this.testStubs.length; ++i) {
                    String stubId = this.testStubs[i].getId();
                    File tempDir = null;
                    try {
                        tempDir = new File(this.internalTestResourceFileTempDirectory, new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
                        if (!tempDir.mkdirs()) {
                            throw new IOException("Directory can not make. path=" + tempDir);
                        }
                        File[] caseDirs = resourceDir.listFiles();
                        if (caseDirs != null && caseDirs.length > 0) {
                            for (int j = 0; j < caseDirs.length; ++j) {
                                RecurciveSearchFile caseDir = new RecurciveSearchFile(caseDirs[j]);
                                File[] files = caseDir.listAllTreeFiles("**/" + stubId, 1);
                                if (files == null || files.length <= 0) continue;
                                for (int k = 0; k < files.length; ++k) {
                                    File testcaseDir = new File(tempDir, files[k].getParentFile().getName());
                                    if (!testcaseDir.exists() && !testcaseDir.mkdirs()) {
                                        throw new IOException("Directory can not make. path=" + testcaseDir);
                                    }
                                    if (RecurciveSearchFile.copyAllTree(files[k], testcaseDir)) continue;
                                    throw new IOException("Directory can not copy. From=" + files[k] + " To=" + testcaseDir);
                                }
                            }
                        }
                        this.stubResourceManager.uploadScenarioResource(tempDir, this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId, stubId);
                        this.testStubs[i].startScenario(userId, this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId);
                        continue;
                    }
                    finally {
                        if (tempDir != null && tempDir.exists() && !RecurciveSearchFile.deleteAllTree(tempDir)) {
                            RecurciveSearchFile.deleteOnExitAllTree(tempDir);
                        }
                    }
                }
            }
            if (this.testEventListeners != null) {
                for (i = 0; i < this.testEventListeners.length; ++i) {
                    this.testEventListeners[i].startScenario(userId, scenarioId);
                }
            }
            TestScenarioImpl testScenario = new TestScenarioImpl(this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId);
            testScenario.setController(this);
            context.setTestScenario(testScenario);
            groupContext.putTestScenarioContext(context);
            TestScenarioImpl.StatusImpl status = new TestScenarioImpl.StatusImpl(userId);
            context.setStatus(status);
            TestContextImpl scenarioTestContext = new TestContextImpl();
            scenarioTestContext.setCurrentDirectory(resourceDir);
            context.setScenarioTestContext(scenarioTestContext);
            TestContextImpl testCaseTestContext = new TestContextImpl();
            context.setTestCaseTestContext(testCaseTestContext);
            scenarioTestContext.setTestScenario(testScenario);
            TestScenario.TestScenarioResource testScenarioResource = testScenario.getTestScenarioResource();
            if (this.testPhase == null || testScenarioResource.isExecutable(this.testPhase)) {
                String[] beforeActionIds = testScenario.getTestScenarioResource().getBeforeActionIds();
                try {
                    this.executeAction(context, scenarioTestContext, status, beforeActionIds, true, true, true);
                }
                catch (NotSupportActionException e) {
                    throw new TestException("This action is not support at BeforeAction of Scenario. action=" + e.getAction().getClass().getName());
                }
                boolean result = context.isAllActionSuccess();
                status.setResult(result);
                status.setStartTime(new Date());
                if (result) {
                    status.setState(1);
                } else {
                    status.setState(4);
                }
            }
            this.currentTestScenario = testScenario;
        }
        catch (Exception e) {
            if (this.testStubs != null) {
                for (int i = 0; i < this.testStubs.length; ++i) {
                    this.testStubs[i].cancelScenario();
                }
            }
            this.currentTestScenario = null;
            this.currentTestCase = null;
            this.getLogger().write("TC___00010", new Object[]{this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId}, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void cancelScenario(String scenarioId) throws Exception {
        block23: {
            if (this.currentTestScenarioGroup == null || this.currentTestScenario == null) {
                return;
            }
            this.getLogger().write("TC___00011", new Object[]{this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId});
            try {
                TestScenarioGroupContext groupContext;
                TestScenarioContext context;
                int i;
                if (this.testStubs != null) {
                    for (i = 0; i < this.testStubs.length; ++i) {
                        this.testStubs[i].cancelScenario();
                    }
                }
                if (this.testEventListeners != null) {
                    for (i = 0; i < this.testEventListeners.length; ++i) {
                        this.testEventListeners[i].cancelScenario(scenarioId);
                    }
                }
                if ((context = (groupContext = (TestScenarioGroupContext)this.contextMap.get(this.currentTestScenarioGroup.getScenarioGroupId())).getTestScenarioContext(scenarioId)) != null) {
                    TestCaseContext[] testCaseContexts = context.getTestCaseContexts();
                    if (testCaseContexts != null) {
                        for (int i2 = 0; i2 < testCaseContexts.length; ++i2) {
                            TestCase.Status caseStatus = testCaseContexts[i2].getStatus();
                            if (caseStatus == null || caseStatus.getState() != 1) continue;
                            this.cancelTestCase(testCaseContexts[i2].getTestCase().getScenarioId(), testCaseContexts[i2].getTestCase().getTestCaseId());
                        }
                    }
                } else {
                    this.currentTestScenario = null;
                    return;
                }
                TestScenario.TestScenarioResource testScenarioResource = context.getTestScenario().getTestScenarioResource();
                if (this.testPhase != null && !testScenarioResource.isExecutable(this.testPhase)) break block23;
                String[] finallyActionIds = context.getTestScenario().getTestScenarioResource().getFinallyActionIds();
                TestContextImpl scenarioTestContext = (TestContextImpl)context.getScenarioTestContext();
                TestScenarioImpl.StatusImpl status = (TestScenarioImpl.StatusImpl)context.getTestScenario().getStatus();
                context.setStatus(status);
                try {
                    this.executeAction(context, scenarioTestContext, status, finallyActionIds, true, false, false);
                }
                catch (NotSupportActionException e) {
                    throw new TestException("This action is not support at FinallyAction of Scenario. action=" + e.getAction().getClass().getName());
                }
                TestCaseContext[] testCaseContexts = context.getTestCaseContexts();
                boolean result = context.isAllActionSuccess();
                if (result) {
                    for (int i3 = 0; i3 < testCaseContexts.length; ++i3) {
                        if (!testCaseContexts[i3].isAllActionSuccess()) {
                            result = false;
                        }
                        List actionContextList = testCaseContexts[i3].getActionContextList();
                        for (int j = 0; j < actionContextList.size(); ++j) {
                            TestActionContext actionContext = (TestActionContext)actionContextList.get(j);
                            Reader[] readers = actionContext.getResources();
                            if (readers == null) continue;
                            for (int k = 0; k < readers.length; ++k) {
                                if (readers[k] instanceof RetryReader) {
                                    ((RetryReader)readers[k]).closeInner();
                                    continue;
                                }
                                readers[k].close();
                            }
                        }
                    }
                }
                status.setResult(result);
                status.setState(3);
            }
            catch (Exception e) {
                this.getLogger().write("TC___00012", new Object[]{this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId}, (Throwable)e);
                throw e;
            }
            finally {
                this.currentTestScenario = null;
                this.currentTestCase = null;
            }
        }
    }

    @Override
    public synchronized void endScenario(String scenarioId) throws Exception {
        block30: {
            if (this.currentTestScenarioGroup == null || this.currentTestScenario == null) {
                return;
            }
            this.getLogger().write("TC___00013", new Object[]{this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId});
            try {
                TestScenarioGroupContext groupContext;
                TestScenarioContext context;
                int i;
                if (this.testStubs != null) {
                    for (i = 0; i < this.testStubs.length; ++i) {
                        this.testStubs[i].endScenario();
                    }
                }
                if (this.testEventListeners != null) {
                    for (i = 0; i < this.testEventListeners.length; ++i) {
                        this.testEventListeners[i].endScenario(scenarioId);
                    }
                }
                if ((context = (groupContext = (TestScenarioGroupContext)this.contextMap.get(this.currentTestScenarioGroup.getScenarioGroupId())).getTestScenarioContext(scenarioId)) != null) {
                    TestCaseContext[] testCaseContexts = context.getTestCaseContexts();
                    if (testCaseContexts != null) {
                        for (int i2 = 0; i2 < testCaseContexts.length; ++i2) {
                            TestCase.Status caseStatus = testCaseContexts[i2].getStatus();
                            if (caseStatus == null || caseStatus.getState() != 1) continue;
                            this.endTestCase(testCaseContexts[i2].getTestCase().getScenarioId(), testCaseContexts[i2].getTestCase().getTestCaseId());
                        }
                    }
                } else {
                    this.currentTestScenario = null;
                    this.currentTestCase = null;
                    return;
                }
                TestScenario.TestScenarioResource testScenarioResource = context.getTestScenario().getTestScenarioResource();
                if (this.testPhase != null && !testScenarioResource.isExecutable(this.testPhase)) break block30;
                TestContextImpl scenarioTestContext = (TestContextImpl)context.getScenarioTestContext();
                String[] afterActionIds = testScenarioResource.getAfterActionIds();
                TestScenarioImpl.StatusImpl status = (TestScenarioImpl.StatusImpl)context.getStatus();
                try {
                    this.executeAction(context, scenarioTestContext, status, afterActionIds, true, true, false);
                }
                catch (NotSupportActionException e) {
                    throw new TestException("This action is not support at AfterAction of Scenario. action=" + e.getAction().getClass().getName());
                }
                finally {
                    String[] finallyActionIds = testScenarioResource.getFinallyActionIds();
                    try {
                        this.executeAction(context, scenarioTestContext, status, finallyActionIds, true, false, false);
                    }
                    catch (NotSupportActionException e) {
                        throw new TestException("This action is not support at FinallyAction of Scenario. action=" + e.getAction().getClass().getName());
                    }
                }
                TestCaseContext[] testCaseContexts = context.getTestCaseContexts();
                boolean result = context.isAllActionSuccess();
                if (result) {
                    for (int i3 = 0; i3 < testCaseContexts.length; ++i3) {
                        if (!testCaseContexts[i3].isAllActionSuccess()) {
                            result = false;
                        }
                        List actionContextList = testCaseContexts[i3].getActionContextList();
                        for (int j = 0; j < actionContextList.size(); ++j) {
                            TestActionContext actionContext = (TestActionContext)actionContextList.get(j);
                            Reader[] readers = actionContext.getResources();
                            if (readers == null) continue;
                            for (int k = 0; k < readers.length; ++k) {
                                if (readers[k] instanceof RetryReader) {
                                    ((RetryReader)readers[k]).closeInner();
                                    continue;
                                }
                                readers[k].close();
                            }
                        }
                    }
                }
                status.setResult(result);
                status.setState(2);
                status.setEndTime(new Date());
            }
            catch (Exception e) {
                this.getLogger().write("TC___00014", new Object[]{this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId}, (Throwable)e);
                throw e;
            }
            finally {
                this.currentTestScenario = null;
                this.currentTestCase = null;
            }
        }
    }

    @Override
    public synchronized void startTestCase(String userId, String scenarioId, String testcaseId) throws Exception {
        this.getLogger().write("TC___00015", new Object[]{this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId, testcaseId, userId});
        try {
            int i;
            TestCaseImpl testCase;
            if (this.currentTestScenarioGroup == null) {
                throw new TestException("ScenarioGroup is not start.");
            }
            this.setUserId(userId);
            TestScenarioGroupContext groupContext = (TestScenarioGroupContext)this.contextMap.get(this.currentTestScenarioGroup.getScenarioGroupId());
            TestScenarioContext scenarioContext = groupContext.getTestScenarioContext(scenarioId);
            if (scenarioContext == null || scenarioContext.getStatus().getState() != 1) {
                throw new TestException("Scenario is not start. scenarioId=" + scenarioId);
            }
            String[] testCaseIds = this.testResourceManager.getTestCaseIds(this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId);
            if (!Arrays.asList(testCaseIds).contains(testcaseId)) {
                throw new TestException("This testcaseId does not exist. ScenarioGroupId=" + this.currentTestScenarioGroup.getScenarioGroupId() + " ScenarioId=" + scenarioId + " TestcaseId=" + testcaseId);
            }
            TestCaseContext context = scenarioContext.getTestCaseContext(testcaseId);
            if (context == null) {
                context = new TestCaseContext();
            }
            if ((testCase = (TestCaseImpl)context.getTestCase()) == null) {
                testCase = new TestCaseImpl(this.currentTestScenarioGroup.getScenarioGroupId(), scenarioContext.getTestScenario().getScenarioId(), testcaseId);
                testCase.setController(this);
                context.setTestCase(testCase);
            }
            scenarioContext.putTestCaseContext(context);
            TestCaseImpl.StatusImpl status = new TestCaseImpl.StatusImpl(userId);
            context.setStatus(status);
            TestContextImpl testCaseTestContext = (TestContextImpl)scenarioContext.getTestCaseTestContext();
            scenarioContext.setTestCaseTestContext(testCaseTestContext);
            testCaseTestContext.setCurrentDirectory(new File(this.testResourceFileBaseDirectory, this.currentTestScenarioGroup.getScenarioGroupId() + File.separator + scenarioId + File.separator + testcaseId));
            testCaseTestContext.setTestCase(testCase);
            if (this.testStubs != null) {
                for (i = 0; i < this.testStubs.length; ++i) {
                    File stubDir = new File(this.testResourceFileBaseDirectory, this.currentTestScenarioGroup.getScenarioGroupId() + File.separator + scenarioId + File.separator + testcaseId + File.separator + this.testStubs[i].getId());
                    if (!stubDir.exists()) continue;
                    this.testStubs[i].startTestCase(testcaseId);
                }
            }
            if (this.testEventListeners != null) {
                for (i = 0; i < this.testEventListeners.length; ++i) {
                    this.testEventListeners[i].startTestCase(userId, scenarioId, testcaseId);
                }
            }
            TestCase.TestCaseResource testCaseResource = testCase.getTestCaseResource();
            if (this.testPhase == null || testCaseResource.isExecutable(this.testPhase)) {
                String[] beforeActionIds = testCaseResource.getBeforeActionIds();
                try {
                    this.executeAction(context, testCaseTestContext, status, beforeActionIds, true, true, true);
                }
                catch (NotSupportActionException e) {
                    throw new TestException("This action is not support at BeforeAction of TestCase. action=" + e.getAction().getClass().getName());
                }
                String[] actionIds = testCaseResource.getActionIds();
                try {
                    this.executeAction(context, testCaseTestContext, status, actionIds, true, true, true);
                }
                catch (NotSupportActionException e) {
                    throw new TestException("This action is not support at Action of TestCase. action=" + e.getAction().getClass().getName());
                }
                boolean result = context.isAllActionSuccess();
                status.setResult(result);
                status.setStartTime(new Date());
                if (result) {
                    status.setState(1);
                } else {
                    status.setState(4);
                }
            }
            this.currentTestCase = testCase;
        }
        catch (Exception e) {
            this.currentTestCase = null;
            this.getLogger().write("TC___00016", new Object[]{this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId, testcaseId}, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void cancelTestCase(String scenarioId, String testcaseId) throws Exception {
        block14: {
            if (this.currentTestScenarioGroup == null || this.currentTestScenario == null || this.currentTestCase == null) {
                return;
            }
            this.getLogger().write("TC___00017", new Object[]{this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId, testcaseId});
            try {
                TestScenarioGroupContext groupContext;
                TestScenarioContext scenarioContext;
                int i;
                if (this.testStubs != null) {
                    for (i = 0; i < this.testStubs.length; ++i) {
                        File stubDir = new File(this.testResourceFileBaseDirectory, this.currentTestScenarioGroup.getScenarioGroupId() + File.separator + scenarioId + File.separator + testcaseId + File.separator + this.testStubs[i].getId());
                        if (!stubDir.exists()) continue;
                        this.testStubs[i].endTestCase();
                        this.stubResourceManager.downloadTestCaseResource(stubDir, this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId, testcaseId, this.testStubs[i].getId());
                    }
                }
                if (this.testEventListeners != null) {
                    for (i = 0; i < this.testEventListeners.length; ++i) {
                        this.testEventListeners[i].cancelTestCase(scenarioId, testcaseId);
                    }
                }
                if ((scenarioContext = (groupContext = (TestScenarioGroupContext)this.contextMap.get(this.currentTestScenarioGroup.getScenarioGroupId())).getTestScenarioContext(scenarioId)) == null || scenarioContext.getStatus().getState() != 1) {
                    return;
                }
                TestCaseContext context = scenarioContext.getTestCaseContext(testcaseId);
                TestCase.TestCaseResource testCaseResource = context.getTestCase().getTestCaseResource();
                if (this.testPhase != null && !testCaseResource.isExecutable(this.testPhase)) break block14;
                TestContextImpl testCaseTestContext = (TestContextImpl)scenarioContext.getTestCaseTestContext();
                TestCaseImpl.StatusImpl status = (TestCaseImpl.StatusImpl)context.getStatus();
                String[] finallyActionIds = testCaseResource.getFinallyActionIds();
                try {
                    this.executeAction(context, testCaseTestContext, status, finallyActionIds, true, false, false);
                }
                catch (NotSupportActionException e) {
                    throw new TestException("This action is not support at FinallyAction of TestCase. action=" + e.getAction().getClass().getName());
                }
                status.setResult(context.isAllActionSuccess());
                status.setState(3);
            }
            catch (Exception e) {
                this.getLogger().write("TC___00018", new Object[]{this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId, testcaseId}, (Throwable)e);
                throw e;
            }
            finally {
                this.currentTestCase = null;
            }
        }
    }

    @Override
    public synchronized void endTestCase(String scenarioId, String testcaseId) throws Exception {
        block21: {
            if (this.currentTestScenarioGroup == null || this.currentTestScenario == null || this.currentTestCase == null) {
                return;
            }
            this.getLogger().write("TC___00019", new Object[]{this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId, testcaseId});
            try {
                int i;
                TestScenarioGroupContext groupContext = (TestScenarioGroupContext)this.contextMap.get(this.currentTestScenarioGroup.getScenarioGroupId());
                TestScenarioContext scenarioContext = groupContext.getTestScenarioContext(scenarioId);
                if (scenarioContext == null || scenarioContext.getStatus().getState() != 1) {
                    throw new TestException("Scenario is not started.");
                }
                TestCaseContext context = scenarioContext.getTestCaseContext(testcaseId);
                if (context == null || context.getStatus().getState() != 1) {
                    throw new TestException("TestCase is not started.");
                }
                if (this.testStubs != null) {
                    for (i = 0; i < this.testStubs.length; ++i) {
                        File stubDir = new File(this.testResourceFileBaseDirectory, this.currentTestScenarioGroup.getScenarioGroupId() + File.separator + scenarioId + File.separator + testcaseId + File.separator + this.testStubs[i].getId());
                        if (!stubDir.exists()) continue;
                        this.testStubs[i].endTestCase();
                        this.stubResourceManager.downloadTestCaseResource(stubDir, this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId, testcaseId, this.testStubs[i].getId());
                    }
                }
                if (this.testEventListeners != null) {
                    for (i = 0; i < this.testEventListeners.length; ++i) {
                        this.testEventListeners[i].endTestCase(scenarioId, testcaseId);
                    }
                }
                TestCase.TestCaseResource testCaseResource = context.getTestCase().getTestCaseResource();
                if (this.testPhase != null && !testCaseResource.isExecutable(this.testPhase)) break block21;
                TestContextImpl testCaseTestContext = (TestContextImpl)scenarioContext.getTestCaseTestContext();
                String[] afterActionIds = testCaseResource.getAfterActionIds();
                TestCaseImpl.StatusImpl status = (TestCaseImpl.StatusImpl)context.getStatus();
                try {
                    this.executeAction(context, testCaseTestContext, status, afterActionIds, true, true, false);
                }
                catch (NotSupportActionException e) {
                    throw new TestException("This action is not support at AfterAction of TestCase. action=" + e.getAction().getClass().getName());
                }
                finally {
                    String[] finallyActionIds = testCaseResource.getFinallyActionIds();
                    try {
                        this.executeAction(context, testCaseTestContext, status, finallyActionIds, true, false, false);
                    }
                    catch (NotSupportActionException e) {
                        throw new TestException("This action is not support at FinallyAction of TestCase. action=" + e.getAction().getClass().getName());
                    }
                }
                status.setResult(context.isAllActionSuccess());
                status.setState(2);
                status.setEndTime(new Date());
            }
            catch (Exception e) {
                this.getLogger().write("TC___00020", new Object[]{this.currentTestScenarioGroup.getScenarioGroupId(), scenarioId, testcaseId}, (Throwable)e);
                throw e;
            }
            finally {
                this.currentTestCase = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAction(TestActionContextManager context, TestContextImpl testContext, StatusActionMnagerImpl status, String[] actionIds, boolean executeEvaluate, boolean isExceptionBreak, boolean isEvaluateBreak) throws Exception {
        for (int i = 0; i < actionIds.length; ++i) {
            TestActionContext testActionContext = context.getActionContext(actionIds[i]);
            if (this.testPhase != null && !testActionContext.isExecutable(this.testPhase)) continue;
            status.addTestActionContext(testActionContext);
            Object action = testActionContext.getAction();
            status.setCurrentActionId(testActionContext.getId());
            this.getLogger().write("TC___00021", new Object[]{testActionContext.getId()});
            try {
                Reader[] resources;
                Object obj;
                Reader resource;
                if (action instanceof TestAction) {
                    resource = null;
                    if (testActionContext.getResources() != null && testActionContext.getResources().length != 0) {
                        resource = testActionContext.getResources()[0];
                    }
                    try {
                        resource.reset();
                        obj = ((TestAction)action).execute(testContext, testActionContext.getId(), resource);
                        testContext.setTestActionResult(actionIds[i], obj);
                        continue;
                    }
                    finally {
                        if (resource != null) {
                            resource.close();
                        }
                    }
                }
                if (action instanceof ChainTestAction) {
                    resources = testActionContext.getResources();
                    try {
                        obj = ((ChainTestAction)action).execute(testContext, testActionContext.getId(), resources);
                        testContext.setTestActionResult(actionIds[i], obj);
                    }
                    finally {
                        if (resources == null) continue;
                        for (int j = 0; j < resources.length; ++j) {
                            resources[j].close();
                        }
                        continue;
                    }
                }
                if (executeEvaluate && action instanceof EvaluateTestAction) {
                    resource = null;
                    if (testActionContext.getResources() != null && testActionContext.getResources().length != 0) {
                        resource = testActionContext.getResources()[0];
                    }
                    try {
                        resource.reset();
                        boolean result = ((EvaluateTestAction)action).execute(testContext, testActionContext.getId(), resource);
                        if (!result) {
                            this.getLogger().write("TC___00023", new Object[]{testActionContext.getId()});
                        }
                        ((TestActionContextImpl)testActionContext).setSuccess(result);
                        if (result || !isEvaluateBreak) continue;
                        break;
                    }
                    finally {
                        if (resource != null) {
                            resource.close();
                        }
                    }
                }
                if (executeEvaluate && action instanceof ChainEvaluateTestAction) {
                    resources = testActionContext.getResources();
                    try {
                        boolean result = ((ChainEvaluateTestAction)action).execute(testContext, testActionContext.getId(), resources);
                        if (!result) {
                            this.getLogger().write("TC___00023", new Object[]{testActionContext.getId()});
                        }
                        ((TestActionContextImpl)testActionContext).setSuccess(result);
                        if (!result) {
                            if (isEvaluateBreak) {
                            }
                        }
                    }
                    finally {
                        if (resources == null) break;
                        for (int j = 0; j < resources.length; ++j) {
                            resources[j].close();
                        }
                        break;
                    }
                }
                if (executeEvaluate && action instanceof RetryEvaluateTestAction) {
                    resources = testActionContext.getResources();
                    try {
                        boolean result = ((RetryEvaluateTestAction)action).execute(testContext, testActionContext.getId(), testActionContext.getResources(), testActionContext.getRetryInterval(), testActionContext.getRetryCount());
                        if (!result) {
                            this.getLogger().write("TC___00023", new Object[]{testActionContext.getId()});
                        }
                        ((TestActionContextImpl)testActionContext).setSuccess(result);
                        if (!result) {
                            if (isEvaluateBreak) {
                            }
                        }
                    }
                    finally {
                        if (resources == null) break;
                        for (int j = 0; j < resources.length; ++j) {
                            resources[j].close();
                        }
                        break;
                    }
                }
                throw new NotSupportActionException(action);
            }
            catch (Exception e) {
                this.getLogger().write("TC___00022", (Object)testActionContext.getId(), (Throwable)e);
                ((TestActionContextImpl)testActionContext).setSuccess(false);
                ((TestActionContextImpl)testActionContext).setThrowable(e);
                status.setThrowable(e);
                if (!isExceptionBreak) continue;
                throw e;
            }
        }
    }

    @Override
    public TestScenarioGroup[] getScenarioGroups() throws Exception {
        String[] scenarioGroupIds = this.testResourceManager.getScenarioGroupIds();
        if (scenarioGroupIds == null) {
            return new TestScenarioGroup[0];
        }
        TestScenarioGroup[] testScenarioGroups = new TestScenarioGroup[scenarioGroupIds.length];
        for (int i = 0; i < scenarioGroupIds.length; ++i) {
            if (this.contextMap.containsKey(scenarioGroupIds[i])) {
                testScenarioGroups[i] = ((TestScenarioGroupContext)this.contextMap.get(scenarioGroupIds[i])).getTestScenarioGroup();
                continue;
            }
            testScenarioGroups[i] = new TestScenarioGroupImpl(scenarioGroupIds[i]);
            ((TestScenarioGroupImpl)testScenarioGroups[i]).setController(this);
        }
        return testScenarioGroups;
    }

    @Override
    public String[] getScenarioGroupIds() throws Exception {
        TestScenarioGroup[] scenarioGroups = this.getScenarioGroups();
        String[] scenarioGroupIds = null;
        if (scenarioGroups != null && scenarioGroups.length > 0) {
            scenarioGroupIds = new String[scenarioGroups.length];
            for (int i = 0; i < scenarioGroups.length; ++i) {
                scenarioGroupIds[i] = scenarioGroups[i].getScenarioGroupId();
            }
        }
        return scenarioGroupIds;
    }

    @Override
    public TestScenarioGroup getScenarioGroup(String scenarioGroupId) throws Exception {
        TestScenarioGroup[] testScenarioGroups = this.getScenarioGroups();
        for (int i = 0; i < testScenarioGroups.length; ++i) {
            if (!testScenarioGroups[i].getScenarioGroupId().equals(scenarioGroupId)) continue;
            return testScenarioGroups[i];
        }
        return null;
    }

    @Override
    public TestScenarioGroup getCurrentScenarioGroup() throws Exception {
        return this.currentTestScenarioGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestScenarioGroup.TestScenarioGroupResource getTestScenarioGroupResource(String scenarioGroupId) throws Exception {
        TestScenarioGroupContext groupContext = (TestScenarioGroupContext)this.contextMap.get(scenarioGroupId);
        if (groupContext == null) {
            return null;
        }
        File resourceFile = new File(this.testResourceFileBaseDirectory, scenarioGroupId + File.separator + this.scenarioGroupResourceFileName);
        TestScenarioGroupImpl.TestScenarioGroupResourceImpl resource = new TestScenarioGroupImpl.TestScenarioGroupResourceImpl();
        InputStream is = null;
        try {
            is = new FileInputStream(resourceFile);
            Element root = this.getRootElement(resourceFile, is);
            this.loadResourceElement(root, resource);
            TestActionContext[] testActionResources = this.loadTestActionResources(root, resourceFile.getParentFile());
            ArrayList<String> beforeList = new ArrayList<String>();
            ArrayList<String> finallyList = new ArrayList<String>();
            for (int i = 0; i < testActionResources.length; ++i) {
                if (testActionResources[i].getType() == 1) {
                    beforeList.add(testActionResources[i].getId());
                }
                if (testActionResources[i].getType() == 4) {
                    finallyList.add(testActionResources[i].getId());
                }
                resource.setActionDescription(testActionResources[i].getId(), testActionResources[i].getDescription());
                resource.setActionTitle(testActionResources[i].getId(), testActionResources[i].getTitle());
                resource.setActionExpectedCost(testActionResources[i].getId(), testActionResources[i].getExpectedCost());
                groupContext.putActionContext(testActionResources[i]);
            }
            resource.setBeforeActionIds(beforeList.toArray(new String[0]));
            resource.setFinallyActionIds(finallyList.toArray(new String[0]));
        }
        finally {
            is.close();
            is = null;
        }
        return resource;
    }

    @Override
    public TestScenarioGroup.Status getTestScenarioGroupStatus(String scenarioGroupId) {
        if (this.contextMap.containsKey(scenarioGroupId)) {
            TestScenarioGroupContext context = (TestScenarioGroupContext)this.contextMap.get(scenarioGroupId);
            return (TestScenarioGroupImpl.StatusImpl)context.getStatus();
        }
        return null;
    }

    @Override
    public TestScenario[] getScenarios(String scenarioGroupId) throws Exception {
        String[] scenarioIds = this.testResourceManager.getScenarioIds(scenarioGroupId);
        if (scenarioIds == null) {
            return new TestScenario[0];
        }
        TestScenario[] testScenarios = new TestScenario[scenarioIds.length];
        if (!this.contextMap.containsKey(scenarioGroupId)) {
            for (int i = 0; i < scenarioIds.length; ++i) {
                testScenarios[i] = new TestScenarioImpl(scenarioGroupId, scenarioIds[i]);
            }
        } else {
            TestScenarioGroupContext context = (TestScenarioGroupContext)this.contextMap.get(scenarioGroupId);
            for (int i = 0; i < scenarioIds.length; ++i) {
                testScenarios[i] = context.getTestScenario(scenarioIds[i]);
                if (testScenarios[i] != null) continue;
                testScenarios[i] = new TestScenarioImpl(scenarioGroupId, scenarioIds[i]);
                ((TestScenarioImpl)testScenarios[i]).setController(this);
            }
        }
        return testScenarios;
    }

    @Override
    public String[] getScenarioIds(String scenarioGroupId) throws Exception {
        TestScenario[] testScenarios = this.getScenarios(scenarioGroupId);
        String[] testScenarioIds = null;
        if (testScenarios != null && testScenarios.length > 0) {
            testScenarioIds = new String[testScenarios.length];
            for (int i = 0; i < testScenarios.length; ++i) {
                testScenarioIds[i] = testScenarios[i].getScenarioId();
            }
        }
        return testScenarioIds;
    }

    @Override
    public TestScenario getScenario(String scenarioGroupId, String scenarioId) throws Exception {
        TestScenario[] testScenarios = this.getScenarios(scenarioGroupId);
        for (int i = 0; i < testScenarios.length; ++i) {
            if (!testScenarios[i].getScenarioId().equals(scenarioId)) continue;
            return testScenarios[i];
        }
        return null;
    }

    @Override
    public TestScenario getCurrentScenario() throws Exception {
        return this.currentTestScenario;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestScenario.TestScenarioResource getTestScenarioResource(String scenarioGroupId, String scenarioId) throws Exception {
        TestScenarioGroupContext groupContext = (TestScenarioGroupContext)this.contextMap.get(scenarioGroupId);
        if (groupContext == null) {
            return null;
        }
        TestScenarioContext scenarioContext = null;
        scenarioContext = groupContext.getTestScenarioContext(scenarioId);
        if (scenarioContext == null) {
            return null;
        }
        File resourceFile = new File(this.testResourceFileBaseDirectory, scenarioGroupId + File.separator + scenarioId + File.separator + this.scenarioResourceFileName);
        if (!resourceFile.exists()) {
            return null;
        }
        TestScenarioImpl.TestScenarioResourceImpl resource = new TestScenarioImpl.TestScenarioResourceImpl();
        FileInputStream is = null;
        TestActionContext[] testActionResources = null;
        Element root = null;
        try {
            is = new FileInputStream(resourceFile);
            root = this.getRootElement(resourceFile, is);
            this.loadResourceElement(root, resource);
            String scheduledExcutor = MetaData.getOptionalAttribute(root, "scheduledExcutor");
            resource.setScheduledExcutor(scheduledExcutor);
            String scheduledExcuteDate = MetaData.getOptionalAttribute(root, "scheduledExcuteDate");
            if (scheduledExcuteDate != null && !"".equals(scheduledExcuteDate)) {
                SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy/MM/dd");
                resource.setScheduledExcuteDate(dateFormat2.parse(scheduledExcuteDate));
            }
            testActionResources = this.loadTestActionResources(root, resourceFile.getParentFile());
            ArrayList<String> beforeList = new ArrayList<String>();
            ArrayList<String> afterList = new ArrayList<String>();
            ArrayList<String> finallyList = new ArrayList<String>();
            for (int i = 0; i < testActionResources.length; ++i) {
                switch (testActionResources[i].getType()) {
                    case 1: {
                        beforeList.add(testActionResources[i].getId());
                        break;
                    }
                    case 3: {
                        afterList.add(testActionResources[i].getId());
                        break;
                    }
                    case 4: {
                        finallyList.add(testActionResources[i].getId());
                        break;
                    }
                    default: {
                        throw new TestException("This type is not support at TestScenario. action=" + testActionResources[i].getAction().getClass().getName() + " id=" + testActionResources[i].getId());
                    }
                }
                resource.setActionDescription(testActionResources[i].getId(), testActionResources[i].getDescription());
                resource.setActionTitle(testActionResources[i].getId(), testActionResources[i].getTitle());
                resource.setActionExpectedCost(testActionResources[i].getId(), testActionResources[i].getExpectedCost());
                scenarioContext.putActionContext(testActionResources[i]);
            }
            resource.setBeforeActionIds(beforeList.toArray(new String[0]));
            resource.setAfterActionIds(afterList.toArray(new String[0]));
            resource.setFinallyActionIds(finallyList.toArray(new String[0]));
            String[] testCaseIds = this.testResourceManager.getTestCaseIds(scenarioGroupId, scenarioId);
            if (testCaseIds != null) {
                for (int i = 0; i < testCaseIds.length; ++i) {
                    File testCaseResourceDir = new File(this.testResourceFileBaseDirectory, scenarioGroupId + File.separator + scenarioId + File.separator + testCaseIds[i]);
                    File testCaseResourceFile = new File(testCaseResourceDir, this.testCaseResourceFileName);
                    if (!testCaseResourceFile.exists()) continue;
                    InputStream tcis = null;
                    try {
                        tcis = new FileInputStream(testCaseResourceFile);
                        Element testCaseRoot = this.getRootElement(testCaseResourceFile, tcis);
                        this.loadTestCaseResource(scenarioGroupId, scenarioId, testCaseIds[i], testCaseRoot, scenarioContext);
                        continue;
                    }
                    finally {
                        tcis.close();
                        tcis = null;
                    }
                }
            }
            Iterator testResourceElements = MetaData.getChildrenByTagName(root, "testcase");
            while (testResourceElements.hasNext()) {
                Element testCaseElement = (Element)testResourceElements.next();
                String testCaseId = MetaData.getUniqueAttribute(testCaseElement, "id");
                TestCaseContext[] testCaseContexts = scenarioContext.getTestCaseContexts();
                boolean isExists = false;
                if (testCaseContexts != null) {
                    for (int i = 0; i < testCaseContexts.length; ++i) {
                        if (!testCaseId.equals(testCaseContexts[i].getTestCase().getTestCaseId())) continue;
                        isExists = true;
                    }
                }
                if (isExists) continue;
                this.loadTestCaseResource(scenarioGroupId, scenarioId, testCaseId, testCaseElement, scenarioContext);
            }
            TestCaseContext[] testCaseContexts = scenarioContext.getTestCaseContexts();
            if (testCaseContexts != null) {
                for (int i = 0; i < testCaseContexts.length; ++i) {
                    TestCase.TestCaseResource testCaseResource = testCaseContexts[i].getTestCase().getTestCaseResource();
                    if (!Double.isNaN(testCaseResource.getExpectedCost())) {
                        resource.addTestCaseExpectedCost(testCaseResource.getExpectedCost());
                    }
                    if (Double.isNaN(testCaseResource.getCost())) continue;
                    resource.addTestCaseCost(testCaseResource.getCost());
                }
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
                is = null;
            }
        }
        return resource;
    }

    private void setUserId(String id) {
        if (id != null) {
            System.setProperty(this.userIdPropertyKeyName, id);
        } else {
            System.setProperty(this.userIdPropertyKeyName, "");
        }
    }

    private void loadTestCaseResource(String scenarioGroupId, String scenarioId, String testCaseId, Element testCaseElement, TestScenarioContext scenarioContext) throws Exception {
        TestCaseImpl testCase;
        TestCaseImpl.TestCaseResourceImpl testCaseResource = new TestCaseImpl.TestCaseResourceImpl();
        this.loadResourceElement(testCaseElement, testCaseResource);
        File testCaseResourceDir = new File(this.testResourceFileBaseDirectory, scenarioGroupId + File.separator + scenarioId + File.separator + testCaseId);
        TestActionContext[] testCaseTestActionResources = this.loadTestActionResources(testCaseElement, testCaseResourceDir);
        TestCaseContext testCaseContext = scenarioContext.getTestCaseContext(testCaseId);
        if (testCaseContext == null) {
            testCaseContext = new TestCaseContext();
        }
        if ((testCase = (TestCaseImpl)testCaseContext.getTestCase()) == null) {
            testCase = new TestCaseImpl(scenarioGroupId, scenarioId, testCaseId);
            testCase.setController(this);
            testCaseContext.setTestCase(testCase);
        }
        scenarioContext.putTestCaseContext(testCaseContext);
        ArrayList<String> testCaseBeforeList = new ArrayList<String>();
        ArrayList<String> testCaseActionList = new ArrayList<String>();
        ArrayList<String> testCaseAfterList = new ArrayList<String>();
        ArrayList<String> testCaseFinallyList = new ArrayList<String>();
        for (int i = 0; i < testCaseTestActionResources.length; ++i) {
            switch (testCaseTestActionResources[i].getType()) {
                case 1: {
                    testCaseBeforeList.add(testCaseTestActionResources[i].getId());
                    break;
                }
                case 2: {
                    testCaseActionList.add(testCaseTestActionResources[i].getId());
                    break;
                }
                case 3: {
                    testCaseAfterList.add(testCaseTestActionResources[i].getId());
                    break;
                }
                case 4: {
                    testCaseFinallyList.add(testCaseTestActionResources[i].getId());
                    break;
                }
                default: {
                    throw new TestException("This type is not support at TestCase. action=" + testCaseTestActionResources[i].getAction().getClass().getName() + " id=" + testCaseTestActionResources[i].getId());
                }
            }
            testCaseResource.setActionDescription(testCaseTestActionResources[i].getId(), testCaseTestActionResources[i].getDescription());
            testCaseResource.setActionTitle(testCaseTestActionResources[i].getId(), testCaseTestActionResources[i].getTitle());
            testCaseResource.setActionExpectedCost(testCaseTestActionResources[i].getId(), testCaseTestActionResources[i].getExpectedCost());
            testCaseResource.setActionCost(testCaseTestActionResources[i].getId(), testCaseTestActionResources[i].getCost());
            testCaseContext.putActionContext(testCaseTestActionResources[i]);
        }
        testCaseResource.setBeforeActionIds(testCaseBeforeList.toArray(new String[0]));
        testCaseResource.setActionIds(testCaseActionList.toArray(new String[0]));
        testCaseResource.setAfterActionIds(testCaseAfterList.toArray(new String[0]));
        testCaseResource.setFinallyActionIds(testCaseFinallyList.toArray(new String[0]));
        testCaseContext.setResource(testCaseResource);
    }

    @Override
    public TestScenario.Status getTestScenarioStatus(String scenarioGroupId, String scenarioId) {
        TestScenarioImpl.StatusImpl status;
        TestScenarioGroupContext context;
        if (this.contextMap.containsKey(scenarioGroupId) && (context = (TestScenarioGroupContext)this.contextMap.get(scenarioGroupId)).getScenarioMap().containsKey(scenarioId) && (status = (TestScenarioImpl.StatusImpl)context.getTestScenarioContext(scenarioId).getStatus()) != null) {
            TestScenarioContext scenarioContext = context.getTestScenarioContext(scenarioId);
            TestCaseContext[] testCaseContexts = scenarioContext.getTestCaseContexts();
            for (int i = 0; i < testCaseContexts.length; ++i) {
                if (testCaseContexts[i].getStatus() == null || testCaseContexts[i].getStatus().getResult()) continue;
                status.setResult(false);
            }
            return status;
        }
        return null;
    }

    @Override
    public TestCase[] getTestCases(String scenarioGroupId, String scenarioId) throws Exception {
        ArrayList<TestCase> resultList;
        block5: {
            String[] testCaseIds;
            block4: {
                testCaseIds = this.testResourceManager.getTestCaseIds(scenarioGroupId, scenarioId);
                if (testCaseIds == null) {
                    return new TestCase[0];
                }
                TestScenarioGroupContext groupContext = (TestScenarioGroupContext)this.contextMap.get(scenarioGroupId);
                TestScenarioContext scenarioContext = null;
                if (groupContext != null && (scenarioContext = groupContext.getTestScenarioContext(scenarioId)) != null) {
                    scenarioContext = groupContext.getTestScenarioContext(scenarioId);
                }
                resultList = new ArrayList<TestCase>();
                if (scenarioContext == null) break block4;
                TestCaseContext[] testCaseContexts = scenarioContext.getTestCaseContexts();
                List<String> testCaseIdList = Arrays.asList(testCaseIds);
                if (testCaseContexts == null) break block5;
                for (int i = 0; i < testCaseContexts.length; ++i) {
                    if (!testCaseIdList.contains(testCaseContexts[i].getTestCase().getTestCaseId())) continue;
                    resultList.add(testCaseContexts[i].getTestCase());
                }
                break block5;
            }
            for (int i = 0; i < testCaseIds.length; ++i) {
                TestCaseImpl testCase = new TestCaseImpl(scenarioGroupId, scenarioId, testCaseIds[i]);
                resultList.add(testCase);
            }
        }
        return resultList.toArray(new TestCase[0]);
    }

    @Override
    public String[] getTestCaseIds(String scenarioGroupId, String scenarioId) throws Exception {
        TestCase[] testCases = this.getTestCases(scenarioGroupId, scenarioId);
        String[] testCaseIds = null;
        if (testCases != null && testCases.length > 0) {
            testCaseIds = new String[testCases.length];
            for (int i = 0; i < testCases.length; ++i) {
                testCaseIds[i] = testCases[i].getTestCaseId();
            }
        }
        return testCaseIds;
    }

    @Override
    public TestCase getTestCase(String scenarioGroupId, String scenarioId, String testcaseId) throws Exception {
        TestCase[] testCases = this.getTestCases(scenarioGroupId, scenarioId);
        for (int i = 0; i < testCases.length; ++i) {
            if (!testCases[i].getTestCaseId().equals(testcaseId)) continue;
            return testCases[i];
        }
        return null;
    }

    @Override
    public TestCase getCurrentTestCase() throws Exception {
        return this.currentTestCase;
    }

    @Override
    public TestCase.TestCaseResource getTestCaseResource(String scenarioGroupId, String scenarioId, String testcaseId) throws Exception {
        TestScenarioGroupContext groupContext = (TestScenarioGroupContext)this.contextMap.get(scenarioGroupId);
        TestScenarioContext scenarioContext = null;
        TestCaseContext testCaseContext = null;
        if (groupContext != null) {
            scenarioContext = groupContext.getTestScenarioContext(scenarioId);
        }
        if (scenarioContext != null) {
            testCaseContext = scenarioContext.getTestCaseContext(testcaseId);
        }
        if (scenarioContext == null) {
            return null;
        }
        return testCaseContext.getResource();
    }

    @Override
    public TestCase.Status getTestCaseStatus(String scenarioGroupId, String scenarioId, String testcaseId) {
        TestScenarioContext scenarioContext;
        TestScenarioGroupContext groupContext;
        if (this.contextMap.containsKey(scenarioGroupId) && (groupContext = (TestScenarioGroupContext)this.contextMap.get(scenarioGroupId)).getScenarioMap().containsKey(scenarioId) && (scenarioContext = groupContext.getTestScenarioContext(scenarioId)).getTestCaseMap().containsKey(testcaseId)) {
            TestCaseContext testCaseContext = scenarioContext.getTestCaseContext(testcaseId);
            return testCaseContext.getStatus();
        }
        return null;
    }

    @Override
    public File downloadScenarioResult(File dir, String scenarioGroupId, String scenarioId, int respnseFileType) throws Exception {
        File resultDir = new File(this.testResourceFileBaseDirectory, scenarioGroupId + File.separator + scenarioId);
        if (!resultDir.exists()) {
            resultDir.mkdirs();
        }
        return this.downloadResult(dir, resultDir, scenarioGroupId + "_" + scenarioId, respnseFileType);
    }

    @Override
    public File downloadTestCaseResult(File dir, String scenarioGroupId, String scenarioId, String testcaseId, int respnseFileType) throws Exception {
        File resultDir = new File(this.testResourceFileBaseDirectory, scenarioGroupId + File.separator + scenarioId + File.separator + testcaseId);
        if (!resultDir.exists()) {
            resultDir.mkdirs();
        }
        return this.downloadResult(dir, resultDir, scenarioGroupId + "_" + scenarioId + "_" + testcaseId, respnseFileType);
    }

    @Override
    public void downloadTestScenarioGroupResource(String scenarioGroupId) throws Exception {
        File resourceDir = new File(this.testResourceFileBaseDirectory, scenarioGroupId);
        this.downloadTestScenarioGroupResource(resourceDir, scenarioGroupId);
        TestScenarioGroupImpl testScenarioGroup = new TestScenarioGroupImpl(scenarioGroupId);
        testScenarioGroup.setController(this);
        TestScenarioGroupContext context = new TestScenarioGroupContext();
        context.setTestScenarioGroup(testScenarioGroup);
        this.contextMap.put(scenarioGroupId, context);
    }

    private void downloadTestScenarioGroupResource(File resourceDir, String scenarioGroupId) throws Exception {
        if (this.contextMap.containsKey(scenarioGroupId)) {
            this.contextMap.remove(scenarioGroupId);
        }
        this.setupDir(resourceDir, false);
        this.testResourceManager.downloadScenarioGroupResource(resourceDir, scenarioGroupId);
    }

    @Override
    public void downloadTestScenarioResource(String scenarioGroupId, String scenarioId) throws Exception {
        File resourceDir = new File(this.testResourceFileBaseDirectory, scenarioGroupId + File.separator + scenarioId);
        this.downloadTestScenarioResource(resourceDir, scenarioGroupId, scenarioId);
        TestScenarioGroupContext groupContext = (TestScenarioGroupContext)this.contextMap.get(scenarioGroupId);
        if (groupContext == null) {
            throw new TestException("TestScenarioGroup is not download. scenarioGroupId=" + scenarioGroupId);
        }
        TestScenarioContext context = new TestScenarioContext();
        TestScenarioImpl testScenario = new TestScenarioImpl(scenarioGroupId, scenarioId);
        testScenario.setController(this);
        context.setTestScenario(testScenario);
        groupContext.putTestScenarioContext(context);
    }

    @Override
    public void reset() throws Exception {
        this.testResourceManager.checkOut();
    }

    private void downloadTestScenarioResource(File resourceDir, String scenarioGroupId, String scenarioId) throws Exception {
        TestScenarioGroupContext groupContext;
        if (this.contextMap.containsKey(scenarioGroupId) && (groupContext = (TestScenarioGroupContext)this.contextMap.get(scenarioGroupId)).getScenarioMap().containsKey(scenarioId)) {
            groupContext.getScenarioMap().remove(scenarioId);
        }
        this.setupDir(resourceDir, false);
        this.testResourceManager.downloadScenarioResource(resourceDir, scenarioGroupId, scenarioId);
    }

    private void setupDir(File dir, boolean isContains) throws IOException {
        if (dir.exists()) {
            RecurciveSearchFile.deleteAllTree(dir, isContains);
        } else if (!dir.mkdirs()) {
            throw new IOException("Directory can not make. path=" + dir);
        }
    }

    private TestActionContext[] loadTestActionResources(Element element, File targetDir) throws Exception {
        ArrayList<TestActionContextImpl> resourceList = new ArrayList<TestActionContextImpl>();
        ServiceNameEditor editor = new ServiceNameEditor();
        Iterator actionElements = MetaData.getChildrenByTagName(element, "action");
        while (actionElements.hasNext()) {
            String retryCount;
            Element titleElement;
            String title;
            Iterator titleElements;
            Element descriptionElement;
            String description;
            Iterator descriptionElements;
            String cost;
            String expectedCost;
            double cost2;
            Element testResourceElement = (Element)actionElements.next();
            TestActionContextImpl testActionResource = new TestActionContextImpl();
            String id = MetaData.getUniqueAttribute(testResourceElement, "id");
            testActionResource.setId(id);
            String type = MetaData.getOptionalAttribute(testResourceElement, "type");
            if ("before".equals(type)) {
                testActionResource.setType(1);
            } else if ("action".equals(type)) {
                testActionResource.setType(2);
            } else if ("after".equals(type)) {
                testActionResource.setType(3);
            } else if ("finally".equals(type)) {
                testActionResource.setType(4);
            } else {
                throw new TestException("This type is not support at Action. type=" + type);
            }
            String serviceName = MetaData.getUniqueAttribute(testResourceElement, "serviceName");
            editor.setAsText(serviceName);
            Object testAction = ServiceManagerFactory.getServiceObject((ServiceName)editor.getValue());
            testActionResource.setAction(testAction);
            if (testAction instanceof TestActionEstimation && !Double.isNaN(cost2 = ((TestActionEstimation)testAction).getExpectedCost())) {
                testActionResource.setExpectedCost(cost2);
            }
            if ((expectedCost = MetaData.getOptionalAttribute(testResourceElement, "expectedCost")) != null && !"".equals(expectedCost)) {
                testActionResource.setExpectedCost(Double.parseDouble(expectedCost));
            }
            if ((cost = MetaData.getOptionalAttribute(testResourceElement, "cost")) != null && !"".equals(cost)) {
                testActionResource.setCost(Double.parseDouble(cost));
            }
            if ((descriptionElements = MetaData.getChildrenByTagName(testResourceElement, "description")).hasNext() && (description = MetaData.getElementContent(descriptionElement = (Element)descriptionElements.next())) != null && !"".equals(description)) {
                testActionResource.setDescription(description.trim());
            }
            if ((titleElements = MetaData.getChildrenByTagName(testResourceElement, "title")).hasNext() && (title = MetaData.getElementContent(titleElement = (Element)titleElements.next())) != null && !"".equals(title)) {
                testActionResource.setTitle(title.trim());
            }
            Element resourcesElement = MetaData.getUniqueChild(testResourceElement, "resources");
            Iterator resourceElements = MetaData.getChildrenByTagName(resourcesElement, "resource");
            ArrayList<RetryReader> resources = new ArrayList<RetryReader>();
            while (resourceElements.hasNext()) {
                Element resourceElement = (Element)resourceElements.next();
                String name = MetaData.getOptionalAttribute(resourceElement, "name");
                Reader resource = null;
                if (name == null) {
                    String resourceStr = MetaData.getElementContent(resourceElement, "");
                    resource = new RetryReader(new StringReader(resourceStr));
                } else {
                    File resourceFile = new File(targetDir, name);
                    String encoding = MetaData.getOptionalAttribute(resourceElement, "encoding");
                    resource = this.getReader(resourceFile, encoding);
                }
                resources.add((RetryReader)resource);
            }
            testActionResource.setResources(resources.toArray(new Reader[resources.size()]));
            String retryInterval = MetaData.getOptionalAttribute(testResourceElement, "retryInterval");
            if (retryInterval != null && !"".equals(retryInterval)) {
                testActionResource.setRetryInterval(Long.parseLong(retryInterval));
            }
            if ((retryCount = MetaData.getOptionalAttribute(testResourceElement, "retryCount")) != null && !"".equals(retryCount)) {
                testActionResource.setRetryCount(Integer.parseInt(retryCount));
            }
            resourceList.add(testActionResource);
        }
        return resourceList.toArray(new TestActionContextImpl[0]);
    }

    private Element getRootElement(File file, InputStream is) throws Exception {
        InputSource inputSource = new InputSource(is);
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setValidating(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        NimbusEntityResolver resolver = new NimbusEntityResolver();
        builder.setEntityResolver(resolver);
        ParseErrorHandler handler = new ParseErrorHandler(file);
        builder.setErrorHandler(handler);
        Document doc = builder.parse(inputSource);
        if (handler.isError()) {
            this.getLogger().write("TC___00004", handler.getException());
            throw handler.getException();
        }
        return doc.getDocumentElement();
    }

    private void loadResourceElement(Element element, Object target) throws Exception {
        if (target != null) {
            Iterator phaseElements;
            if (target instanceof ScheduledTestResourceImpl) {
                String cost;
                String progress;
                String createEndDate;
                String createStartDate;
                String scheduledCreateEndDate;
                String expectedCost;
                String creator = MetaData.getOptionalAttribute(element, "creator");
                if (creator != null && !"".equals(creator)) {
                    ((ScheduledTestResourceImpl)target).setCreator(creator);
                }
                if ((expectedCost = MetaData.getOptionalAttribute(element, "expectedCost")) != null && !"".equals(expectedCost)) {
                    ((ScheduledTestResourceImpl)target).setExpectedCost(Double.parseDouble(expectedCost));
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                String scheduledCreateStartDate = MetaData.getOptionalAttribute(element, "scheduledCreateStartDate");
                if (scheduledCreateStartDate != null && !"".equals(scheduledCreateStartDate)) {
                    ((ScheduledTestResourceImpl)target).setScheduledCreateStartDate(dateFormat.parse(scheduledCreateStartDate));
                }
                if ((scheduledCreateEndDate = MetaData.getOptionalAttribute(element, "scheduledCreateEndDate")) != null && !"".equals(scheduledCreateEndDate)) {
                    ((ScheduledTestResourceImpl)target).setScheduledCreateEndDate(dateFormat.parse(scheduledCreateEndDate));
                }
                if ((createStartDate = MetaData.getOptionalAttribute(element, "createStartDate")) != null && !"".equals(createStartDate)) {
                    ((ScheduledTestResourceImpl)target).setCreateStartDate(dateFormat.parse(createStartDate));
                }
                if ((createEndDate = MetaData.getOptionalAttribute(element, "createEndDate")) != null && !"".equals(createEndDate)) {
                    ((ScheduledTestResourceImpl)target).setCreateEndDate(dateFormat.parse(createEndDate));
                }
                if ((progress = MetaData.getOptionalAttribute(element, "progress")) != null && !"".equals(progress)) {
                    ((ScheduledTestResourceImpl)target).setProgress(Double.parseDouble(progress));
                }
                if ((cost = MetaData.getOptionalAttribute(element, "cost")) != null && !"".equals(cost)) {
                    ((ScheduledTestResourceImpl)target).setCost(Double.parseDouble(cost));
                }
            }
            if (target instanceof TestResourceBaseImpl) {
                String defaultTestCaseErrorContinue;
                Element titleElement;
                String title;
                Iterator titleElements;
                Element descriptionElement;
                String description;
                Iterator descriptionElements = MetaData.getChildrenByTagName(element, "description");
                if (descriptionElements.hasNext() && (description = MetaData.getElementContent(descriptionElement = (Element)descriptionElements.next())) != null && !"".equals(description)) {
                    ((TestResourceBaseImpl)target).setDescription(description.trim());
                }
                if ((titleElements = MetaData.getChildrenByTagName(element, "title")).hasNext() && (title = MetaData.getElementContent(titleElement = (Element)titleElements.next())) != null && !"".equals(title)) {
                    ((TestResourceBaseImpl)target).setTitle(title.trim());
                }
                Iterator categoryElements = MetaData.getChildrenByTagName(element, "category");
                while (categoryElements.hasNext()) {
                    Element categoryElement = (Element)categoryElements.next();
                    String name = MetaData.getUniqueAttribute(categoryElement, "name");
                    String value = MetaData.getUniqueAttribute(categoryElement, "value");
                    ((TestResourceBaseImpl)target).setCategory(name, value);
                }
                String errorContinue = MetaData.getOptionalAttribute(element, "errorContinue");
                if (errorContinue != null) {
                    ((TestResourceBaseImpl)target).setErrorContinue(MetaData.getOptionalBooleanAttribute(element, "errorContinue"));
                }
                if ((defaultTestCaseErrorContinue = MetaData.getOptionalAttribute(element, "defaultTestCaseErrorContinue")) != null) {
                    ((TestResourceBaseImpl)target).setErrorContinue(MetaData.getOptionalBooleanAttribute(element, "defaultTestCaseErrorContinue"));
                }
            }
            if (target instanceof TestPhaseExecutableImpl && (phaseElements = MetaData.getChildrenByTagName(element, "phase")).hasNext()) {
                Iterator excludeElements;
                Element phaseElement = (Element)phaseElements.next();
                Iterator includeElements = MetaData.getChildrenByTagName(phaseElement, "include");
                if (includeElements.hasNext()) {
                    Element includeElement = (Element)includeElements.next();
                    String include = MetaData.getElementContent(includeElement);
                    StringArrayEditor editor = new StringArrayEditor();
                    editor.setAsText(include);
                    String[] includes = (String[])editor.getValue();
                    if (includes != null) {
                        ((TestPhaseExecutableImpl)target).addIncludePhase(includes);
                    }
                }
                if ((excludeElements = MetaData.getChildrenByTagName(phaseElement, "exclude")).hasNext()) {
                    Element excludeElement = (Element)excludeElements.next();
                    String exclude = MetaData.getElementContent(excludeElement);
                    StringArrayEditor editor = new StringArrayEditor();
                    editor.setAsText(exclude);
                    String[] excludes = (String[])editor.getValue();
                    if (excludes != null) {
                        ((TestPhaseExecutableImpl)target).addExcludePhase(excludes);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadResult(File downloadDir, File resultDir, String id, int respnseFileType) throws Exception {
        File result = null;
        switch (respnseFileType) {
            case 1: {
                File file = new File(downloadDir, id + ".zip");
                File[] files = new File[]{resultDir};
                ZipOutputStream zos = null;
                try {
                    zos = new ZipOutputStream(new FileOutputStream(file));
                    this.doZip(zos, files, resultDir.getParent());
                }
                finally {
                    if (zos != null) {
                        try {
                            zos.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                result = file;
                break;
            }
            default: {
                if (!RecurciveSearchFile.copyAllTree(resultDir, downloadDir)) {
                    throw new IOException("Directory can not copy. From=" + resultDir + " To=" + downloadDir);
                }
                result = resultDir;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doZip(ZipOutputStream zos, File[] files, String baseDir) throws Exception {
        byte[] buf = new byte[1024];
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                this.doZip(zos, f.listFiles(), baseDir);
                continue;
            }
            String path = f.getPath().substring(f.getPath().indexOf(baseDir) + baseDir.length() + 1);
            ZipEntry entry = new ZipEntry(path.replace('\\', '/'));
            zos.putNextEntry(entry);
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(f));
                int len = 0;
                while ((len = is.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                continue;
            }
            finally {
                is.close();
            }
        }
    }

    private Reader getReader(File file, String encoding) throws Exception {
        InputStreamReader reader = encoding == null ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        return new RetryReader(reader);
    }

    private String replaceProperty(String textValue) {
        textValue = Utility.replaceSystemProperty(textValue);
        if (this.getServiceLoader() != null) {
            textValue = Utility.replaceServiceLoderConfig(textValue, this.getServiceLoader().getConfig());
        }
        if (this.getServiceManager() != null) {
            textValue = Utility.replaceManagerProperty(this.getServiceManager(), textValue);
        }
        textValue = Utility.replaceServerProperty(textValue);
        textValue = this.replaceActionContextProperty(textValue);
        return textValue;
    }

    private String replaceActionContextProperty(String str) {
        String result = str;
        if (result == null) {
            return null;
        }
        int startIndex = result.indexOf("${");
        if (startIndex == -1) {
            return result;
        }
        int endIndex = result.indexOf("}", startIndex);
        if (endIndex == -1) {
            return result;
        }
        String propStr = result.substring(startIndex + "${".length(), endIndex);
        String prop = null;
        Object propObj = null;
        if (propStr != null && propStr.length() != 0) {
            TestScenarioGroupContext groupContext = (TestScenarioGroupContext)this.contextMap.get(this.currentTestScenarioGroup.getScenarioGroupId());
            TestContext contextForGroup = groupContext.getTestContext();
            TestContext contextForScenario = null;
            TestContext contextForTestcase = null;
            if (this.currentTestScenario != null) {
                TestScenarioContext scenarioContext = groupContext.getTestScenarioContext(this.currentTestScenario.getScenarioId());
                contextForScenario = scenarioContext.getScenarioTestContext();
                contextForTestcase = scenarioContext.getTestCaseTestContext();
            }
            if (contextForTestcase != null) {
                int index = propStr.indexOf(44);
                propObj = index == -1 ? contextForTestcase.getTestActionResult(propStr) : contextForTestcase.getTestActionResult(propStr.substring(0, index), propStr.substring(index + 1));
            }
            if (propObj == null && contextForScenario != null) {
                propObj = contextForScenario.getTestActionResult(propStr);
            }
            if (propObj == null) {
                propObj = contextForGroup.getTestActionResult(propStr);
            }
            if (propObj != null) {
                prop = propObj.toString();
            }
        }
        if (prop == null) {
            return result.substring(0, endIndex + "}".length()) + this.replaceActionContextProperty(result.substring(endIndex + "}".length()));
        }
        if ((result = result.substring(0, startIndex) + prop + result.substring(endIndex + "}".length())).indexOf("${") != -1) {
            return this.replaceActionContextProperty(result);
        }
        return result;
    }

    static {
        NimbusEntityResolver.registerDTD("-//Nimbus//DTD Nimbus ScenarioGroup Resource 1.0//JA", "jp/ossc/nimbus/service/test/scenariogroup_1_0.dtd");
        NimbusEntityResolver.registerDTD("-//Nimbus//DTD Nimbus Scenario Resource 1.0//JA", "jp/ossc/nimbus/service/test/scenario_1_0.dtd");
        NimbusEntityResolver.registerDTD("-//Nimbus//DTD Nimbus TestCase Resource 1.0//JA", "jp/ossc/nimbus/service/test/testcase_1_0.dtd");
    }

    public class RetryReader
    extends Reader {
        private StringReader sr;
        private final String sourceStr;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RetryReader(Reader reader) throws IOException {
            StringWriter sw = new StringWriter();
            char[] buf = new char[1024];
            int len = 0;
            try {
                while ((len = reader.read(buf, 0, buf.length)) > 0) {
                    sw.write(buf, 0, len);
                }
                this.sourceStr = sw.toString();
            }
            finally {
                sw.close();
                reader.close();
            }
        }

        @Override
        public void reset() throws IOException {
            this.sr = new StringReader(TestControllerService.this.replaceProperty(this.sourceStr));
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.sr.read(cbuf, off, len);
        }

        @Override
        public void close() throws IOException {
        }

        protected void closeInner() {
            if (this.sr != null) {
                this.sr.close();
            }
        }
    }

    private class NotSupportActionException
    extends Exception {
        private static final long serialVersionUID = -2389841770320925686L;
        private Object action;

        public NotSupportActionException(Object target) {
            this.action = target;
        }

        private Object getAction() {
            return this.action;
        }
    }

    private class ParseErrorHandler
    implements ErrorHandler {
        private boolean isError;
        private Exception ex;
        private File file;

        public ParseErrorHandler(File file) {
            this.file = file;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            TestControllerService.this.getLogger().write("TC___00001", new Object[]{e.getMessage(), this.file, Integer.toString(e.getLineNumber()), Integer.toString(e.getColumnNumber())});
            this.ex = e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.isError = true;
            TestControllerService.this.getLogger().write("TC___00002", new Object[]{e.getMessage(), this.file, Integer.toString(e.getLineNumber()), Integer.toString(e.getColumnNumber())});
            this.ex = e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.isError = true;
            TestControllerService.this.getLogger().write("TC___00003", new Object[]{e.getMessage(), this.file, Integer.toString(e.getLineNumber()), Integer.toString(e.getColumnNumber())});
            this.ex = e;
        }

        public Exception getException() {
            return this.ex;
        }

        public boolean isError() {
            return this.isError;
        }
    }

    protected class TestCaseContext
    extends TestActionContextManager {
        private TestCase testCase;
        private TestCase.Status status;
        private TestCase.TestCaseResource resource;

        public TestCase getTestCase() {
            return this.testCase;
        }

        public void setTestCase(TestCase testCase) {
            this.testCase = testCase;
        }

        public TestCase.Status getStatus() {
            return this.status;
        }

        public void setStatus(TestCase.Status status) {
            this.status = status;
        }

        public TestCase.TestCaseResource getResource() {
            return this.resource;
        }

        public void setResource(TestCase.TestCaseResource resource) {
            this.resource = resource;
        }
    }

    protected class TestScenarioContext
    extends TestActionContextManager {
        private TestScenario testScenario;
        private TestScenario.Status status;
        private Map testCaseMap;
        private TestContext scenarioTestContext;
        private TestContext testCaseTestContext;

        public TestScenarioContext() {
            this.testCaseMap = new LinkedHashMap();
        }

        public TestScenario getTestScenario() {
            return this.testScenario;
        }

        public void setTestScenario(TestScenario scenario) {
            this.testScenario = scenario;
        }

        public TestScenario.Status getStatus() {
            return this.status;
        }

        public void setStatus(TestScenario.Status status) {
            this.status = status;
        }

        public void putTestCaseContext(TestCaseContext context) {
            this.testCaseMap.put(context.getTestCase().getTestCaseId(), context);
        }

        public TestCaseContext getTestCaseContext(String testCaseId) {
            return (TestCaseContext)this.testCaseMap.get(testCaseId);
        }

        public TestCaseContext[] getTestCaseContexts() {
            return this.testCaseMap.values().toArray(new TestCaseContext[0]);
        }

        public TestCase getTestCase(String testCaseId) {
            if (!this.testCaseMap.containsKey(testCaseId)) {
                return null;
            }
            return ((TestCaseContext)this.testCaseMap.get(testCaseId)).getTestCase();
        }

        public Map getTestCaseMap() {
            return this.testCaseMap;
        }

        public TestContext getScenarioTestContext() {
            return this.scenarioTestContext;
        }

        public void setScenarioTestContext(TestContext context) {
            this.scenarioTestContext = context;
        }

        public TestContext getTestCaseTestContext() {
            return this.testCaseTestContext;
        }

        public void setTestCaseTestContext(TestContext context) {
            this.testCaseTestContext = context;
        }
    }

    protected class TestScenarioGroupContext
    extends TestActionContextManager {
        private TestScenarioGroup testScenarioGroup;
        private TestScenarioGroup.Status status;
        private Map scenarioMap;
        private TestContext testContext;

        public TestScenarioGroupContext() {
            this.scenarioMap = new LinkedHashMap();
        }

        public TestScenarioGroup getTestScenarioGroup() {
            return this.testScenarioGroup;
        }

        public void setTestScenarioGroup(TestScenarioGroup scenarioGroup) {
            this.testScenarioGroup = scenarioGroup;
        }

        public TestScenarioGroup.Status getStatus() {
            return this.status;
        }

        public void setStatus(TestScenarioGroup.Status status) {
            this.status = status;
        }

        public Map getScenarioMap() {
            return this.scenarioMap;
        }

        public void putTestScenarioContext(TestScenarioContext context) {
            this.scenarioMap.put(context.getTestScenario().getScenarioId(), context);
        }

        public TestScenarioContext getTestScenarioContext(String testScenarioId) {
            return (TestScenarioContext)this.scenarioMap.get(testScenarioId);
        }

        public TestScenarioContext[] getTestScenarioContexts() {
            return this.scenarioMap.values().toArray(new TestScenarioContext[0]);
        }

        public TestScenario getTestScenario(String testScenarioId) {
            if (!this.scenarioMap.containsKey(testScenarioId)) {
                return null;
            }
            return ((TestScenarioContext)this.scenarioMap.get(testScenarioId)).getTestScenario();
        }

        public TestContext getTestContext() {
            return this.testContext;
        }

        public void setTestContext(TestContext testContext) {
            this.testContext = testContext;
        }
    }

    protected class TestActionContextManager {
        private List actionContexts = new ArrayList();

        public void putActionContext(TestActionContext testActionContext) {
            this.actionContexts.add(testActionContext);
        }

        public List getActionContextList() {
            return this.actionContexts;
        }

        public TestActionContext getActionContext(String id) {
            for (int i = 0; i < this.actionContexts.size(); ++i) {
                TestActionContext testActionContext = (TestActionContext)this.actionContexts.get(i);
                if (!testActionContext.getId().equals(id)) continue;
                return testActionContext;
            }
            return null;
        }

        public boolean isAllActionSuccess() {
            for (int i = 0; i < this.actionContexts.size(); ++i) {
                TestActionContext testActionContext = (TestActionContext)this.actionContexts.get(i);
                if (testActionContext.isSuccess()) continue;
                return false;
            }
            return true;
        }
    }
}

