/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.Reader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.PersistentManager;
import jp.ossc.nimbus.service.test.ChainTestAction;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.DatabaseUpdateActionServiceMBean;

public class DatabaseUpdateActionService
extends ServiceBase
implements TestAction,
ChainTestAction.TestActionProcess,
TestActionEstimation,
DatabaseUpdateActionServiceMBean {
    private static final long serialVersionUID = -685726604591449818L;
    protected ServiceName connectionFactoryServiceName;
    protected ConnectionFactory connectionFactory;
    protected ServiceName persistentManagerServiceName;
    protected PersistentManager persistentManager;
    protected boolean isBatchExecute;
    protected int batchExecuteCount;
    protected double expectedCost = 0.0;

    @Override
    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    @Override
    public void setPersistentManagerServiceName(ServiceName name) {
        this.persistentManagerServiceName = name;
    }

    @Override
    public ServiceName getPersistentManagerServiceName() {
        return this.persistentManagerServiceName;
    }

    @Override
    public void setBatchExecute(boolean isBatch) {
        this.isBatchExecute = isBatch;
    }

    @Override
    public boolean isBatchExecute() {
        return this.isBatchExecute;
    }

    @Override
    public void setBatchExecuteCount(int count) {
        this.batchExecuteCount = count;
    }

    @Override
    public int getBatchExecuteCount() {
        return this.batchExecuteCount;
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public void setPersistentManager(PersistentManager manager) {
        this.persistentManager = manager;
    }

    @Override
    public void startService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.persistentManagerServiceName != null) {
            this.persistentManager = (PersistentManager)ServiceManagerFactory.getServiceObject(this.persistentManagerServiceName);
        }
        if (this.persistentManager == null) {
            throw new IllegalArgumentException("PersistentManager is null.");
        }
    }

    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        return this.execute(context, actionId, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Object preResult, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        String[] updateQueries = null;
        try {
            String query;
            String line;
            String inputId = br.readLine();
            if (inputId == null) {
                throw new Exception("Unexpected EOF on inputId");
            }
            if (inputId.length() != 0) {
                Object actionResult = null;
                if (inputId.indexOf(",") == -1) {
                    actionResult = context.getTestActionResult(inputId);
                } else {
                    String[] ids = inputId.split(",");
                    if (ids.length != 2) {
                        throw new Exception("Illegal inputId format. id=" + inputId);
                    }
                    actionResult = context.getTestActionResult(ids[0], ids[1]);
                }
                if (actionResult == null) {
                    throw new Exception("TestActionResult not found. id=" + inputId);
                }
                preResult = actionResult;
            }
            if ((line = br.readLine()) == null) {
                throw new Exception("Unexpected EOF on updateQueries");
            }
            ArrayList<String> queries = new ArrayList<String>();
            StringBuffer buf = new StringBuffer();
            do {
                if ("/".equals(line)) {
                    query = buf.toString();
                    buf.setLength(0);
                    query = query.trim();
                    if (query.length() == 0) continue;
                    queries.add(query);
                    continue;
                }
                if ((line = line.trim()).length() == 0) continue;
                if (buf.length() != 0) {
                    buf.append(' ');
                }
                buf.append(line);
            } while ((line = br.readLine()) != null);
            if (buf.length() != 0) {
                query = buf.toString();
                buf.setLength(0);
                query = query.trim();
                if (query.length() != 0) {
                    queries.add(query);
                }
            }
            if (queries.size() == 0) {
                throw new Exception("Unexpected EOF on updateQueries");
            }
            updateQueries = queries.toArray(new String[queries.size()]);
        }
        finally {
            br.close();
            br = null;
        }
        Connection con = this.connectionFactory.getConnection();
        int updateCount = 0;
        try {
            for (int i = 0; i < updateQueries.length; ++i) {
                boolean isArray;
                String updateQuery = updateQueries[i];
                if (preResult == null) {
                    updateCount += this.persistentManager.persistQuery(con, updateQuery, null);
                    continue;
                }
                boolean bl = isArray = preResult instanceof Collection || preResult.getClass().isArray();
                if (this.isBatchExecute && isArray) {
                    Object[] array = null;
                    array = preResult instanceof Collection ? ((Collection)preResult).toArray() : (Object[])preResult;
                    PersistentManager.BatchExecutor be = this.persistentManager.createQueryBatchExecutor(con, updateQuery);
                    if (this.batchExecuteCount > 0) {
                        be.setAutoBatchPersistCount(this.batchExecuteCount);
                    }
                    for (int j = 0; j < array.length; ++j) {
                        updateCount += be.addBatch(array[j]);
                    }
                    updateCount += be.persist();
                    continue;
                }
                updateCount += this.persistentManager.persistQuery(con, updateQuery, preResult);
            }
        }
        finally {
            con.close();
        }
        return new Integer(updateCount);
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

