/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.ftp.FTPClient;
import jp.ossc.nimbus.service.ftp.FTPClientFactory;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.FTPActionServiceMBean;

public class FTPActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
FTPActionServiceMBean {
    private static final long serialVersionUID = -782714823351233622L;
    protected double expectedCost = 0.0;
    protected ServiceName ftpClientFactoryServiceName;
    protected FTPClientFactory ftpClientFactory;

    @Override
    public void setFTPClientFactoryServiceName(ServiceName name) {
        this.ftpClientFactoryServiceName = name;
    }

    @Override
    public ServiceName getFTPClientFactoryServiceName() {
        return this.ftpClientFactoryServiceName;
    }

    @Override
    public void startService() throws Exception {
        if (this.ftpClientFactoryServiceName != null) {
            this.ftpClientFactory = (FTPClientFactory)ServiceManagerFactory.getServiceObject(this.ftpClientFactoryServiceName);
        }
        if (this.ftpClientFactory == null) {
            throw new IllegalArgumentException("FTPClientFactory is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        String actionType = null;
        ArrayList<Object> pathList = new ArrayList<Object>();
        try {
            actionType = br.readLine();
            if (actionType == null) {
                throw new Exception("Unexpected EOF on actionType");
            }
            if (!("GET".equals(actionType) || "MGET".equals(actionType) || "PUT".equals(actionType) || "DELETE".equals(actionType) || "MDELETE".equals(actionType) || "LS".equals(actionType))) {
                throw new Exception("Illegal actionType : " + actionType);
            }
            String filePath = null;
            while ((filePath = br.readLine()) != null) {
                if (filePath.length() == 0) continue;
                if ("PUT".equals(actionType)) {
                    String[] paths = filePath.split(",");
                    if (paths.length != 2) {
                        throw new Exception("Illegal filePath : " + filePath);
                    }
                    pathList.add(paths);
                    continue;
                }
                pathList.add(filePath);
            }
            if (pathList.size() == 0) {
                throw new Exception("Unexpected EOF on filePath");
            }
        }
        finally {
            br.close();
            br = null;
        }
        ArrayList<Object> result = null;
        FTPClient client = this.ftpClientFactory.createFTPClient();
        try {
            client.lcd(context.getCurrentDirectory().getCanonicalPath());
            if ("GET".equals(actionType)) {
                result = new ArrayList<Object>();
                for (int i = 0; i < pathList.size(); ++i) {
                    result.add(client.get((String)pathList.get(i)));
                }
            } else if ("MGET".equals(actionType)) {
                result = new ArrayList();
                for (int i = 0; i < pathList.size(); ++i) {
                    File[] files = client.mget((String)pathList.get(i));
                    if (files == null) continue;
                    for (int j = 0; j < files.length; ++j) {
                        result.add(files[j]);
                    }
                }
            } else if ("DELETE".equals(actionType)) {
                for (int i = 0; i < pathList.size(); ++i) {
                    String[] files = client.ls((String)pathList.get(i));
                    if (files == null || files.length == 0) continue;
                    client.delete((String)pathList.get(i));
                }
            } else if ("MDELETE".equals(actionType)) {
                for (int i = 0; i < pathList.size(); ++i) {
                    client.mdelete((String)pathList.get(i));
                }
            } else if ("LS".equals(actionType)) {
                result = new ArrayList();
                for (int i = 0; i < pathList.size(); ++i) {
                    String[] paths = client.ls((String)pathList.get(i));
                    if (paths == null) continue;
                    for (int j = 0; j < paths.length; ++j) {
                        result.add(paths[j]);
                    }
                }
            } else {
                for (int i = 0; i < pathList.size(); ++i) {
                    String[] paths = (String[])pathList.get(i);
                    client.put(paths[0], paths[1]);
                }
            }
        }
        finally {
            client.close();
        }
        return result;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

