/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.JMSMessageReceiverGetActionServiceMBean;
import jp.ossc.nimbus.service.test.action.JMSMessageReceiverListenActionService;

public class JMSMessageReceiverGetActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
JMSMessageReceiverGetActionServiceMBean {
    private static final long serialVersionUID = 6779163909892607718L;
    protected double expectedCost = 0.0;
    protected String defaultGetType = "message";
    protected long defaultTimeout = 10000L;
    protected int defaultCount = 1;
    protected boolean defaultIsClose = true;

    public void setDefaultGetType(String defaultGetType) {
        this.defaultGetType = defaultGetType;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public void setDefaultCount(int defaultCount) {
        this.defaultCount = defaultCount;
    }

    public void setDefaultIsClose(boolean defaultClose) {
        this.defaultIsClose = defaultClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        JMSMessageReceiverListenActionService.MessageListener listener = null;
        String getType = null;
        long timeout = 0L;
        int count = 1;
        boolean isClose = true;
        try {
            String listenerId = br.readLine();
            if (listenerId == null || listenerId.length() == 0) {
                throw new Exception("Unexpected EOF on listenerId");
            }
            Object actionResult = null;
            if (listenerId.indexOf(",") == -1) {
                actionResult = context.getTestActionResult(listenerId);
            } else {
                String[] ids = listenerId.split(",");
                if (ids.length != 2) {
                    throw new Exception("Illegal listenerId format. id=" + listenerId);
                }
                actionResult = context.getTestActionResult(ids[0], ids[1]);
            }
            if (actionResult == null) {
                throw new Exception("TestActionResult not found. id=" + listenerId);
            }
            if (!(actionResult instanceof JMSMessageReceiverListenActionService.MessageListener)) {
                throw new Exception("TestActionResult is not JMSMessageReceiverListenActionService.MessageListener. type=" + actionResult.getClass());
            }
            listener = (JMSMessageReceiverListenActionService.MessageListener)actionResult;
            getType = br.readLine();
            if (getType == null || getType.length() == 0) {
                getType = this.defaultGetType;
            }
            if (!("message".equals(getType) || "text".equals(getType) || "map".equals(getType) || "object".equals(getType))) {
                throw new UnsupportedOperationException("Illegal getType : " + getType);
            }
            String timeoutStr = br.readLine();
            if (timeoutStr == null || timeoutStr.length() == 0) {
                timeout = this.defaultTimeout;
            } else {
                try {
                    timeout = Long.parseLong(timeoutStr);
                }
                catch (NumberFormatException e) {
                    throw new Exception("Illegal timeout format. timeout=" + timeoutStr);
                }
            }
            String countStr = br.readLine();
            if (countStr == null || countStr.length() == 0) {
                count = this.defaultCount;
            } else {
                try {
                    count = Integer.parseInt(countStr);
                }
                catch (NumberFormatException e) {
                    throw new Exception("Illegal timeout format. count=" + countStr);
                }
            }
            String close = br.readLine();
            isClose = close == null || close.length() == 0 ? this.defaultIsClose : Boolean.valueOf(close);
        }
        finally {
            br.close();
            br = null;
        }
        ArrayList<Object> result = null;
        List msgList = null;
        try {
            if (listener.waitMessage(count, timeout)) {
                msgList = listener.getReceiveMessageList();
            }
            if (msgList != null && msgList.size() != 0) {
                result = new ArrayList<Object>();
                for (int i = 0; i < msgList.size(); ++i) {
                    Message message = (Message)msgList.get(i);
                    if ("text".equals(getType)) {
                        result.add(JMSMessageReceiverGetActionService.parseTextMessageToString(message));
                        continue;
                    }
                    if ("map".equals(getType)) {
                        result.add(JMSMessageReceiverGetActionService.parseMapMessageToMap(message));
                        continue;
                    }
                    if ("object".equals(getType)) {
                        result.add(JMSMessageReceiverGetActionService.parseObjectMessageToObject(message));
                        continue;
                    }
                    result.add(message);
                }
            }
        }
        finally {
            if (isClose) {
                listener.close();
            }
        }
        return result;
    }

    private static String parseTextMessageToString(Message message) throws JMSException {
        TextMessage textMessage = (TextMessage)message;
        return textMessage.getText();
    }

    private static Object parseObjectMessageToObject(Message message) throws JMSException {
        ObjectMessage objectMessage = (ObjectMessage)message;
        return objectMessage.getObject();
    }

    private static Map parseMapMessageToMap(Message message) throws JMSException {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        MapMessage mapMessage = (MapMessage)message;
        Enumeration keys = mapMessage.getMapNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            Object value = mapMessage.getObject(key);
            ret.put(key, value);
        }
        return ret;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

