/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.test.ChainTestAction;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.ObjectToFileConvertActionServiceMBean;
import jp.ossc.nimbus.util.converter.FormatConverter;
import jp.ossc.nimbus.util.converter.StreamConverter;
import jp.ossc.nimbus.util.converter.StreamStringConverter;

public class ObjectToFileConvertActionService
extends ServiceBase
implements TestAction,
ChainTestAction.TestActionProcess,
TestActionEstimation,
ObjectToFileConvertActionServiceMBean {
    private static final long serialVersionUID = 3220754313008589978L;
    protected double expectedCost = 0.0;
    protected String fileEncoding;
    protected ServiceName streamConverterServiceName;
    protected StreamConverter streamConverter;
    protected ServiceName formatConverterServiceName;
    protected FormatConverter formatConverter;

    @Override
    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    @Override
    public String getFileEncoding() {
        return this.fileEncoding;
    }

    @Override
    public void setStreamConverterServiceName(ServiceName name) {
        this.streamConverterServiceName = name;
    }

    @Override
    public ServiceName getStreamConverterServiceName() {
        return this.streamConverterServiceName;
    }

    @Override
    public void setFormatConverterServiceName(ServiceName name) {
        this.formatConverterServiceName = name;
    }

    @Override
    public ServiceName getFormatConverterServiceName() {
        return this.formatConverterServiceName;
    }

    public void setStreamConverter(StreamConverter converter) {
        this.streamConverter = converter;
    }

    public void setFormatConverter(FormatConverter converter) {
        this.formatConverter = converter;
    }

    @Override
    public void startService() throws Exception {
        if (this.streamConverterServiceName != null) {
            this.streamConverter = (StreamConverter)ServiceManagerFactory.getServiceObject(this.streamConverterServiceName);
        }
        if (this.formatConverterServiceName != null) {
            this.formatConverter = (FormatConverter)ServiceManagerFactory.getServiceObject(this.formatConverterServiceName);
        }
    }

    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        return this.execute(context, actionId, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Object preResult, Reader resource) throws Exception {
        File outputFile;
        block41: {
            BufferedReader br = new BufferedReader(resource);
            outputFile = null;
            Object targetObject = preResult;
            String format = null;
            try {
                String outputFilePath;
                String targetObjectId = br.readLine();
                if (targetObjectId != null && targetObjectId.length() != 0) {
                    Object actionResult = null;
                    if (targetObjectId.indexOf(",") == -1) {
                        actionResult = context.getTestActionResult(targetObjectId);
                    } else {
                        String[] ids = targetObjectId.split(",");
                        if (ids.length != 2) {
                            throw new Exception("Illegal targetObjectId format. id=" + targetObjectId);
                        }
                        actionResult = context.getTestActionResult(ids[0], ids[1]);
                    }
                    if (actionResult == null) {
                        throw new Exception("TestActionResult not found. id=" + targetObjectId);
                    }
                    targetObject = actionResult;
                }
                if ((outputFilePath = br.readLine()) == null || outputFilePath.length() == 0) {
                    outputFile = new File(context.getCurrentDirectory(), actionId + ".obj");
                } else {
                    outputFile = new File(outputFilePath);
                    if (!outputFile.isAbsolute()) {
                        outputFile = new File(context.getCurrentDirectory(), outputFilePath);
                    }
                    if (outputFile.getParentFile() != null && !outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                }
                format = br.readLine();
                if (format != null && format.length() == 0) {
                    format = null;
                }
            }
            finally {
                br.close();
                br = null;
            }
            if (this.streamConverter != null) {
                FileOutputStream fos = new FileOutputStream(outputFile);
                InputStream is = null;
                try {
                    StreamConverter sc = this.streamConverter;
                    if (this.fileEncoding != null && sc instanceof StreamStringConverter && !this.fileEncoding.equals(((StreamStringConverter)sc).getCharacterEncodingToStream())) {
                        sc = ((StreamStringConverter)sc).cloneCharacterEncodingToStream(this.fileEncoding);
                    }
                    is = sc.convertToStream(targetObject);
                    int len = 0;
                    byte[] buf = new byte[1024];
                    while ((len = is.read(buf, 0, buf.length)) > 0) {
                        fos.write(buf, 0, len);
                    }
                }
                catch (Exception e) {
                    if (targetObject == null) {
                        byte[] buf = "null".getBytes();
                        fos.write(buf, 0, buf.length);
                    }
                    throw e;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    fos.close();
                }
            } else if (this.formatConverter != null) {
                FormatConverter fc = this.formatConverter;
                if (this.formatConverterServiceName != null) {
                    fc = (FormatConverter)ServiceManagerFactory.getServiceObject(this.formatConverterServiceName);
                }
                if (format != null) {
                    fc.setFormat(format);
                }
                OutputStreamWriter osw = this.fileEncoding == null ? new OutputStreamWriter(new FileOutputStream(outputFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.fileEncoding);
                try {
                    Object ret = fc.convert(targetObject);
                    char[] chars = ret == null ? "null".toCharArray() : ret.toString().toCharArray();
                    osw.write(chars, 0, chars.length);
                }
                catch (Exception e) {
                    if (targetObject == null) {
                        char[] chars = "null".toCharArray();
                        osw.write(chars, 0, chars.length);
                    }
                    throw e;
                }
                finally {
                    osw.close();
                }
            } else {
                OutputStreamWriter osw = this.fileEncoding == null ? new OutputStreamWriter(new FileOutputStream(outputFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.fileEncoding);
                try {
                    char[] chars = targetObject == null ? "null".toCharArray() : targetObject.toString().toCharArray();
                    osw.write(chars, 0, chars.length);
                }
                catch (Exception e) {
                    if (targetObject == null) {
                        char[] chars = "null".toCharArray();
                        osw.write(chars, 0, chars.length);
                        break block41;
                    }
                    throw e;
                }
                finally {
                    osw.close();
                }
            }
        }
        return outputFile;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

