/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.test.ChainTestAction;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.ServerConnectionSendActionServiceMBean;

public class ServerConnectionSendActionService
extends ServiceBase
implements TestAction,
ChainTestAction.TestActionProcess,
TestActionEstimation,
ServerConnectionSendActionServiceMBean {
    private static final long serialVersionUID = -5342444233381889876L;
    protected double expectedCost = 0.0;
    protected ServiceName serverConnectionFactoryServiceName;
    protected ServerConnectionFactory serverConnectionFactory;
    protected ServiceName interpreterServiceName;
    protected Interpreter interpreter;
    protected String fileEncoding;

    @Override
    public void setServerConnectionFactoryServiceName(ServiceName name) {
        this.serverConnectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getServerConnectionFactoryServiceName() {
        return this.serverConnectionFactoryServiceName;
    }

    @Override
    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    @Override
    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setServerConnectionFactory(ServerConnectionFactory factory) {
        this.serverConnectionFactory = factory;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public void startService() throws Exception {
        if (this.serverConnectionFactory == null && this.serverConnectionFactoryServiceName == null) {
            throw new IllegalArgumentException("ServerConnectionFactory is null.");
        }
        if (this.interpreterServiceName != null) {
            this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
        }
    }

    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        return this.execute(context, actionId, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Object preResult, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        Message message = null;
        Object object = preResult;
        ServerConnectionFactory scf = this.serverConnectionFactory;
        if (this.serverConnectionFactory == null && this.serverConnectionFactoryServiceName != null) {
            scf = (ServerConnectionFactory)ServiceManagerFactory.getServiceObject(this.serverConnectionFactoryServiceName);
        }
        ServerConnection con = scf.getServerConnection();
        try {
            String subjectAndKey = br.readLine();
            if (subjectAndKey == null || subjectAndKey.length() == 0) {
                throw new Exception("Unexpected EOF on subject and key");
            }
            do {
                String[] subjectAndKeyArray;
                if ((subjectAndKeyArray = CSVReader.toArray(subjectAndKey, ',', '\\', null, null, true, false, true, true)) == null || subjectAndKeyArray.length == 0 || subjectAndKeyArray.length > 2) {
                    throw new Exception("Illegal subject and key format. subjectAndKey=" + subjectAndKey);
                }
                if (message == null) {
                    message = con.createMessage(subjectAndKeyArray[0], subjectAndKeyArray.length == 2 ? subjectAndKeyArray[1] : null);
                    continue;
                }
                message.setSubject(subjectAndKeyArray[0], subjectAndKeyArray.length == 2 ? subjectAndKeyArray[1] : null);
            } while ((subjectAndKey = br.readLine()) != null && subjectAndKey.length() != 0);
            String objectId = br.readLine();
            if (objectId != null && objectId.length() != 0) {
                Object actionResult = null;
                if (objectId.indexOf(",") == -1) {
                    actionResult = context.getTestActionResult(objectId);
                } else {
                    String[] ids = objectId.split(",");
                    if (ids.length != 2) {
                        throw new Exception("Illegal objectId format. id=" + objectId);
                    }
                    actionResult = context.getTestActionResult(ids[0], ids[1]);
                }
                if (actionResult == null) {
                    throw new Exception("TestActionResult not found. id=" + objectId);
                }
                object = actionResult;
            }
            String objectScript = null;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            try {
                String line = null;
                while ((line = br.readLine()) != null) {
                    pw.println(line);
                }
                pw.flush();
                objectScript = sw.toString();
                if (objectScript.length() == 0) {
                    objectScript = null;
                }
            }
            finally {
                sw.close();
                pw.close();
            }
            if (objectScript != null) {
                if (this.interpreter == null) {
                    throw new UnsupportedOperationException("Interpreter is null.");
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("context", context);
                params.put("preResult", preResult);
                object = this.interpreter.evaluate(objectScript, params);
            }
            if (object != null) {
                message.setObject(object);
            }
            con.send(message);
        }
        finally {
            br.close();
            br = null;
        }
        return message;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

