/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.evaluate;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.io.CSVWriter;
import jp.ossc.nimbus.service.test.EvaluateTestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.evaluate.CSVCompareEvaluateActionServiceMBean;

public class CSVCompareEvaluateActionService
extends ServiceBase
implements EvaluateTestAction,
TestActionEstimation,
CSVCompareEvaluateActionServiceMBean {
    private static final long serialVersionUID = -7771606827015084764L;
    protected String fileEncoding;
    protected boolean isOutputFileAfterEdit;
    protected String fileAfterEditExtention = ".edt";
    protected CSVReader csvReader;
    protected CSVWriter csvWriter;
    protected double expectedCost = 0.0;
    protected boolean isResultNGOnNotFoundDestFile;

    @Override
    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    @Override
    public String getFileEncoding() {
        return this.fileEncoding;
    }

    @Override
    public boolean isOutputFileAfterEdit() {
        return this.isOutputFileAfterEdit;
    }

    @Override
    public void setOutputFileAfterEdit(boolean isOutput) {
        this.isOutputFileAfterEdit = isOutput;
    }

    @Override
    public void setFileAfterEditExtention(String extention) {
        if (extention.charAt(0) != '.') {
            extention = '.' + extention;
        }
        this.fileAfterEditExtention = extention;
    }

    @Override
    public String getFileAfterEditExtention() {
        return this.fileAfterEditExtention;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }

    public void setCSVReader(CSVReader reader) {
        this.csvReader = reader;
    }

    public void setCSVWriter(CSVWriter writer) {
        this.csvWriter = writer;
    }

    @Override
    public boolean isResultNGOnNotFoundDestFile() {
        return this.isResultNGOnNotFoundDestFile;
    }

    @Override
    public void setResultNGOnNotFoundDestFile(boolean isResultNG) {
        this.isResultNGOnNotFoundDestFile = isResultNG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(TestContext context, String actionId, Reader resource) throws Exception {
        String[] ignoreNames;
        int[] ignoreIndexes;
        File dstFile;
        File srcFile;
        block111: {
            BufferedReader br = new BufferedReader(resource);
            srcFile = null;
            dstFile = null;
            ignoreIndexes = null;
            ignoreNames = null;
            try {
                String[] ignoreCSVElements;
                String srcFilePath = br.readLine();
                if (srcFilePath == null) {
                    throw new Exception("Unexpected EOF on srcFilePath");
                }
                String dstFilePath = br.readLine();
                if (dstFilePath == null) {
                    throw new Exception("Unexpected EOF on dstFilePath");
                }
                srcFile = new File(srcFilePath);
                if (!srcFile.exists()) {
                    srcFile = new File(context.getCurrentDirectory(), srcFilePath);
                }
                if (!srcFile.exists()) {
                    throw new Exception("File not found. srcFilePath=" + srcFilePath);
                }
                dstFile = new File(dstFilePath);
                if (!dstFile.exists()) {
                    dstFile = new File(context.getCurrentDirectory(), dstFilePath);
                }
                if (!dstFile.exists()) {
                    boolean bl = !this.isResultNGOnNotFoundDestFile;
                    return bl;
                }
                String ignoreCSVElementsStr = br.readLine();
                if (ignoreCSVElementsStr == null || (ignoreCSVElements = CSVReader.toArray(ignoreCSVElementsStr, ',', '\\', '\"', "null", "#", false, false, true, false)) == null || ignoreCSVElements.length == 0) break block111;
                try {
                    ignoreIndexes = new int[ignoreCSVElements.length];
                    for (int i = 0; i < ignoreCSVElements.length; ++i) {
                        ignoreIndexes[i] = Integer.parseInt(ignoreCSVElements[i]);
                    }
                }
                catch (NumberFormatException e) {
                    ignoreNames = ignoreCSVElements;
                    ignoreIndexes = null;
                }
            }
            finally {
                br.close();
                br = null;
            }
        }
        InputStreamReader srcisr = null;
        InputStreamReader dstisr = null;
        BufferedReader srccsvr = null;
        BufferedReader dstcsvr = null;
        OutputStreamWriter srcosw = null;
        OutputStreamWriter dstosw = null;
        BufferedWriter srccsvw = null;
        BufferedWriter dstcsvw = null;
        boolean result = true;
        try {
            srcisr = this.fileEncoding == null ? new InputStreamReader(new FileInputStream(srcFile)) : new InputStreamReader((InputStream)new FileInputStream(srcFile), this.fileEncoding);
            dstisr = this.fileEncoding == null ? new InputStreamReader(new FileInputStream(dstFile)) : new InputStreamReader((InputStream)new FileInputStream(dstFile), this.fileEncoding);
            srccsvr = this.csvReader == null ? new CSVReader() : this.csvReader.cloneReader();
            dstcsvr = this.csvReader == null ? new CSVReader() : this.csvReader.cloneReader();
            ((CSVReader)srccsvr).setReader(srcisr);
            ((CSVReader)dstcsvr).setReader(dstisr);
            if (this.isOutputFileAfterEdit) {
                File editSrcFile = new File(srcFile.getPath() + this.fileAfterEditExtention);
                File editDstFile = new File(dstFile.getPath() + this.fileAfterEditExtention);
                srcosw = this.fileEncoding == null ? new OutputStreamWriter(new FileOutputStream(editSrcFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(editSrcFile), this.fileEncoding);
                dstosw = this.fileEncoding == null ? new OutputStreamWriter(new FileOutputStream(editDstFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(editDstFile), this.fileEncoding);
                srccsvw = this.csvWriter == null ? new CSVWriter() : this.csvWriter.cloneWriter();
                dstcsvw = this.csvWriter == null ? new CSVWriter() : this.csvWriter.cloneWriter();
                ((CSVWriter)srccsvw).setWriter(srcosw);
                ((CSVWriter)dstcsvw).setWriter(dstosw);
            }
            List srccsv = new ArrayList();
            List dstcsv = new ArrayList();
            boolean[] ignores = null;
            if (ignoreNames != null && ignoreNames.length != 0) {
                int i;
                HashSet<String> ignoreNameSet = new HashSet<String>();
                for (i = 0; i < ignoreNames.length; i += 1) {
                    ignoreNameSet.add(ignoreNames[i]);
                }
                if ((srccsv = ((CSVReader)srccsvr).readCSVLineList(srccsv)) != null && srccsv.size() != 0) {
                    ignores = new boolean[srccsv.size()];
                    for (i = 0; i < srccsv.size(); i += 1) {
                        ignores[i] = ignoreNameSet.contains(srccsv.get(i));
                    }
                }
                if (this.isOutputFileAfterEdit) {
                    this.writeCSV((CSVWriter)srccsvw, srccsv, ignores);
                }
                dstcsv = ((CSVReader)dstcsvr).readCSVLineList(dstcsv);
                if (this.isOutputFileAfterEdit) {
                    this.writeCSV((CSVWriter)dstcsvw, dstcsv, ignores);
                }
                if (!this.compareCSVList(srccsv, dstcsv, ignores)) {
                    i = 0;
                    return i != 0;
                }
            } else if (ignoreIndexes != null && ignoreIndexes.length != 0) {
                if ((srccsv = ((CSVReader)srccsvr).readCSVLineList(srccsv)) != null && srccsv.size() != 0) {
                    ignores = new boolean[srccsv.size()];
                    int imax = ignoreIndexes.length;
                    for (int i = 0; i < imax; ++i) {
                        if (ignores.length <= ignoreIndexes[i]) continue;
                        ignores[ignoreIndexes[i]] = true;
                    }
                }
                if (this.isOutputFileAfterEdit) {
                    this.writeCSV((CSVWriter)srccsvw, srccsv, ignores);
                }
                dstcsv = ((CSVReader)dstcsvr).readCSVLineList(dstcsv);
                if (this.isOutputFileAfterEdit) {
                    this.writeCSV((CSVWriter)dstcsvw, dstcsv, ignores);
                }
                if (!this.compareCSVList(srccsv, dstcsv, ignores)) {
                    boolean bl = false;
                    return bl;
                }
            }
            while (true) {
                if (srccsv != null) {
                    srccsv = ((CSVReader)srccsvr).readCSVLineList(srccsv);
                }
                if (dstcsv != null) {
                    dstcsv = ((CSVReader)dstcsvr).readCSVLineList(dstcsv);
                }
                if (this.isOutputFileAfterEdit) {
                    this.writeCSV((CSVWriter)srccsvw, srccsv, ignores);
                    this.writeCSV((CSVWriter)dstcsvw, dstcsv, ignores);
                }
                result &= this.compareCSVList(srccsv, dstcsv, ignores);
                if (this.isOutputFileAfterEdit) {
                    if (srccsv != null) continue;
                    if (dstcsv == null) return result;
                    continue;
                }
                if (!result) break;
            }
            return result;
        }
        finally {
            if (srcisr != null) {
                try {
                    srcisr.close();
                }
                catch (IOException iOException) {}
            }
            if (dstisr != null) {
                try {
                    dstisr.close();
                }
                catch (IOException iOException) {}
            }
            if (srccsvr != null) {
                try {
                    srccsvr.close();
                }
                catch (IOException iOException) {}
            }
            if (dstcsvr != null) {
                try {
                    dstcsvr.close();
                }
                catch (IOException iOException) {}
            }
            if (this.isOutputFileAfterEdit) {
                srccsvw.flush();
                dstcsvw.flush();
            }
            if (srcosw != null) {
                try {
                    srcosw.close();
                }
                catch (IOException iOException) {}
            }
            if (dstosw != null) {
                try {
                    dstosw.close();
                }
                catch (IOException iOException) {}
            }
            if (srccsvw != null) {
                try {
                    srccsvw.close();
                }
                catch (IOException iOException) {}
            }
            if (dstcsvw != null) {
                try {
                    dstcsvw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected boolean compareCSVList(List src, List dst, boolean[] ignores) {
        if (src == null) {
            return dst == null;
        }
        if (src.size() != dst.size()) {
            return false;
        }
        for (int i = 0; i < src.size(); ++i) {
            if (ignores != null && i < ignores.length && ignores[i] || src.get(i).equals(dst.get(i))) continue;
            return false;
        }
        return true;
    }

    protected void writeCSV(CSVWriter writer, List csv, boolean[] ignores) throws IOException {
        if (csv == null) {
            return;
        }
        for (int i = 0; i < csv.size(); ++i) {
            if (ignores != null && i < ignores.length && ignores[i]) continue;
            writer.writeElement(csv.get(i));
        }
        writer.newLine();
    }
}

