/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.evaluate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.test.EvaluateTestAction;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.evaluate.TextCompareEvaluateActionServiceMBean;

public class TextCompareEvaluateActionService
extends ServiceBase
implements EvaluateTestAction,
TextCompareEvaluateActionServiceMBean {
    private static final long serialVersionUID = -6946310231201742494L;
    protected String fileEncoding;
    protected int[] matchFlags;
    protected int matchFlag;
    protected boolean isOutputFileAfterEdit;
    protected String fileAfterEditExtention = ".edt";
    protected double expectedCost = 0.0;
    protected boolean isResultNGOnNotFoundDestFile;

    @Override
    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    @Override
    public String getFileEncoding() {
        return this.fileEncoding;
    }

    @Override
    public void setMatchFlags(int[] flags) {
        this.matchFlags = flags;
        this.matchFlag = 0;
        if (this.matchFlags != null) {
            for (int i = 0; i < this.matchFlags.length; ++i) {
                this.matchFlag |= this.matchFlags[i];
            }
        }
    }

    @Override
    public int[] getMatchFlags() {
        return this.matchFlags;
    }

    @Override
    public boolean isOutputFileAfterEdit() {
        return this.isOutputFileAfterEdit;
    }

    @Override
    public void setOutputFileAfterEdit(boolean isOutput) {
        this.isOutputFileAfterEdit = isOutput;
    }

    @Override
    public void setFileAfterEditExtention(String extention) {
        if (extention.charAt(0) != '.') {
            extention = '.' + extention;
        }
        this.fileAfterEditExtention = extention;
    }

    @Override
    public String getFileAfterEditExtention() {
        return this.fileAfterEditExtention;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }

    @Override
    public boolean isResultNGOnNotFoundDestFile() {
        return this.isResultNGOnNotFoundDestFile;
    }

    @Override
    public void setResultNGOnNotFoundDestFile(boolean isResultNG) {
        this.isResultNGOnNotFoundDestFile = isResultNG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        File srcFile = null;
        File dstFile = null;
        ArrayList<Pattern> ignorePatternList = null;
        try {
            String srcFilePath = br.readLine();
            if (srcFilePath == null) {
                throw new Exception("Unexpected EOF on srcFilePath");
            }
            String dstFilePath = br.readLine();
            if (dstFilePath == null) {
                throw new Exception("Unexpected EOF on dstFilePath");
            }
            srcFile = new File(srcFilePath);
            if (!srcFile.exists()) {
                srcFile = new File(context.getCurrentDirectory(), srcFilePath);
            }
            if (!srcFile.exists()) {
                throw new Exception("File not found. srcFilePath=" + srcFilePath);
            }
            dstFile = new File(dstFilePath);
            if (!dstFile.exists()) {
                dstFile = new File(context.getCurrentDirectory(), dstFilePath);
            }
            if (!dstFile.exists()) {
                boolean bl = !this.isResultNGOnNotFoundDestFile;
                return bl;
            }
            String line = null;
            while ((line = br.readLine()) != null) {
                Pattern pattern;
                Pattern pattern2 = pattern = this.matchFlag == 0 ? Pattern.compile(line) : Pattern.compile(line, this.matchFlag);
                if (ignorePatternList == null) {
                    ignorePatternList = new ArrayList<Pattern>();
                }
                ignorePatternList.add(pattern);
            }
        }
        finally {
            br.close();
            br = null;
        }
        String srcStr = null;
        StringWriter sw = new StringWriter();
        InputStreamReader isr = this.fileEncoding == null ? new InputStreamReader(new FileInputStream(srcFile)) : new InputStreamReader((InputStream)new FileInputStream(srcFile), this.fileEncoding);
        char[] buf = new char[1024];
        int len = 0;
        try {
            while ((len = isr.read(buf, 0, buf.length)) > 0) {
                sw.write(buf, 0, len);
            }
            srcStr = sw.toString();
            sw.close();
            sw = null;
        }
        finally {
            isr.close();
            isr = null;
        }
        String dstStr = null;
        sw = new StringWriter();
        isr = this.fileEncoding == null ? new InputStreamReader(new FileInputStream(dstFile)) : new InputStreamReader((InputStream)new FileInputStream(dstFile), this.fileEncoding);
        try {
            while ((len = isr.read(buf, 0, buf.length)) > 0) {
                sw.write(buf, 0, len);
            }
            dstStr = sw.toString();
            sw.close();
            sw = null;
        }
        finally {
            isr.close();
            isr = null;
        }
        if (ignorePatternList != null) {
            for (int i = 0; i < ignorePatternList.size(); ++i) {
                Pattern pattern = (Pattern)ignorePatternList.get(i);
                Matcher matcher = pattern.matcher(srcStr);
                srcStr = matcher.replaceAll("");
                matcher = pattern.matcher(dstStr);
                dstStr = matcher.replaceAll("");
            }
        }
        if (this.isOutputFileAfterEdit) {
            File editSrcFile = new File(srcFile.getPath() + this.fileAfterEditExtention);
            OutputStreamWriter osw = this.fileEncoding == null ? new OutputStreamWriter(new FileOutputStream(editSrcFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(editSrcFile), this.fileEncoding);
            try {
                char[] chars = srcStr.toCharArray();
                osw.write(chars, 0, chars.length);
                osw.flush();
            }
            finally {
                osw.close();
            }
            File editDstFile = new File(dstFile.getPath() + this.fileAfterEditExtention);
            osw = this.fileEncoding == null ? new OutputStreamWriter(new FileOutputStream(editDstFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(editDstFile), this.fileEncoding);
            try {
                char[] chars = dstStr.toCharArray();
                osw.write(chars, 0, chars.length);
                osw.flush();
            }
            finally {
                osw.close();
            }
        }
        return srcStr.equals(dstStr);
    }
}

