/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.evaluate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.service.test.ChainEvaluateTestAction;
import jp.ossc.nimbus.service.test.EvaluateTestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.evaluate.TextEvaluateActionServiceMBean;

public class TextEvaluateActionService
extends ServiceBase
implements EvaluateTestAction,
TestActionEstimation,
ChainEvaluateTestAction.EvaluateTestActionProcess,
TextEvaluateActionServiceMBean {
    private static final long serialVersionUID = -6010305153757182392L;
    protected String fileEncoding;
    protected int[] matchFlags;
    protected int matchFlag;
    protected double expectedCost = 0.0;

    @Override
    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    @Override
    public String getFileEncoding() {
        return this.fileEncoding;
    }

    @Override
    public void setMatchFlags(int[] flags) {
        this.matchFlags = flags;
        this.matchFlag = 0;
        if (this.matchFlags != null) {
            for (int i = 0; i < this.matchFlags.length; ++i) {
                this.matchFlag |= this.matchFlags[i];
            }
        }
    }

    @Override
    public int[] getMatchFlags() {
        return this.matchFlags;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }

    @Override
    public boolean execute(TestContext context, String actionId, Reader resource) throws Exception {
        return this.execute(context, actionId, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(TestContext context, String actionId, Object preResult, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        List files = null;
        Pattern pattern = null;
        String matchType = null;
        boolean resultFlag = true;
        try {
            String filePath = br.readLine();
            if (filePath == null) {
                throw new Exception("Unexpected EOF on filePath");
            }
            if (filePath.length() != 0 && ((files = this.toFiles(context, filePath)) == null || files.size() == 0)) {
                throw new Exception("File not found. filePath=" + filePath);
            }
            String matchRegexPattern = br.readLine();
            if (matchRegexPattern == null) {
                throw new Exception("Unexpected EOF on matchRegexPattern");
            }
            pattern = Pattern.compile(matchRegexPattern);
            matchType = br.readLine();
            if (matchType == null) {
                throw new Exception("Unexpected EOF on matchType");
            }
            if (!"all".equals(matchType) && !"part".equals(matchType)) {
                throw new Exception("Unknown matchType : " + matchType);
            }
            String resultFlagStr = br.readLine();
            if (resultFlagStr == null) {
                throw new Exception("Unexpected EOF on resultFlag");
            }
            resultFlag = Boolean.valueOf(resultFlagStr.trim());
        }
        finally {
            br.close();
            br = null;
        }
        String srcStr = null;
        if (files == null) {
            srcStr = preResult == null ? "null" : preResult.toString();
            Matcher matcher = pattern.matcher(srcStr);
            if ("all".equals(matchType)) {
                return matcher.matches() ? resultFlag : !resultFlag;
            }
            return matcher.find() ? resultFlag : !resultFlag;
        }
        char[] buf = new char[1024];
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            StringWriter sw = new StringWriter();
            InputStreamReader isr = this.fileEncoding == null ? new InputStreamReader(new FileInputStream(file)) : new InputStreamReader((InputStream)new FileInputStream(file), this.fileEncoding);
            int len = 0;
            try {
                while ((len = isr.read(buf, 0, buf.length)) > 0) {
                    sw.write(buf, 0, len);
                }
                srcStr = sw.toString();
                sw.close();
                sw = null;
            }
            finally {
                isr.close();
                isr = null;
            }
            Matcher matcher = pattern.matcher(srcStr);
            if (!("all".equals(matchType) ? !(!matcher.matches() ? !resultFlag : resultFlag) : !(!matcher.find() ? !resultFlag : resultFlag))) continue;
            return false;
        }
        return true;
    }

    protected List toFiles(TestContext context, String path) throws IOException {
        ArrayList<File> result = null;
        if ((path = this.replaceProperty(path)).equals(".")) {
            path = context.getCurrentDirectory().getPath();
        } else if (path.startsWith("./")) {
            path = context.getCurrentDirectory().getPath() + path.substring(1);
        }
        File file = new File(path);
        if (file.exists()) {
            result = new ArrayList<File>();
            result.add(file);
        } else {
            File parentFile = file;
            while ((parentFile = parentFile.getParentFile()) != null && !parentFile.exists()) {
            }
            if (parentFile == null) {
                parentFile = context.getCurrentDirectory();
            } else {
                path = path.substring(parentFile.getPath().length() + 1);
            }
            try {
                RecurciveSearchFile rsf = new RecurciveSearchFile(parentFile);
                File[] files = rsf.listAllTreeFiles(path, 0);
                if (files != null && files.length != 0) {
                    result = new ArrayList();
                    for (int i = 0; i < files.length; ++i) {
                        result.add(files[i]);
                    }
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return result;
    }

    protected String replaceProperty(String textValue) {
        textValue = Utility.replaceSystemProperty(textValue);
        if (this.getServiceLoader() != null) {
            textValue = Utility.replaceServiceLoderConfig(textValue, this.getServiceLoader().getConfig());
        }
        if (this.getServiceManager() != null) {
            textValue = Utility.replaceManagerProperty(this.getServiceManager(), textValue);
        }
        textValue = Utility.replaceServerProperty(textValue);
        return textValue;
    }
}

