/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.math.BigDecimal;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestReporter;
import jp.ossc.nimbus.service.test.TestScenario;
import jp.ossc.nimbus.service.test.TestScenarioGroup;
import jp.ossc.nimbus.service.test.report.CSVTestEstimateReporterServiceMBean;

public class CSVTestEstimateReporterService
extends ServiceBase
implements CSVTestEstimateReporterServiceMBean,
TestReporter {
    private static final long serialVersionUID = 1L;
    private double rate = 1.0;
    private File outputFile;

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    @Override
    public File getOutputFile() {
        return this.outputFile;
    }

    @Override
    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public void startService() throws Exception {
        if (this.rate <= 0.0) {
            throw new IllegalArgumentException("Please specify a number greater than 0.");
        }
        if (this.outputFile.getParentFile() != null && !this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("Output dir can not make. path=" + this.outputFile.getParentFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(TestController controller) {
        PrintWriter pw = null;
        try {
            TestScenarioGroup[] groups = controller.getScenarioGroups();
            pw = new PrintWriter(new BufferedWriter(new FileWriter(this.outputFile)));
            pw.println("scenrioGroup,scenario,cost");
            for (int index = 0; index < groups.length; ++index) {
                String scenarioGroupId = groups[index].getScenarioGroupId();
                TestScenarioGroup testScenarioGroup = controller.getScenarioGroup(scenarioGroupId);
                TestScenarioGroup.TestScenarioGroupResource testScenarioGroupResource = testScenarioGroup.getTestScenarioGroupResource();
                if (testScenarioGroupResource == null) continue;
                TestScenario[] testScenarios = controller.getScenarios(scenarioGroupId);
                pw.println(scenarioGroupId + ",," + new BigDecimal(testScenarioGroupResource.getExpectedCost() / this.rate).setScale(2, 4).doubleValue());
                for (int index2 = 0; index2 < testScenarios.length; ++index2) {
                    TestScenario testScenario = testScenarios[index2];
                    TestScenario.TestScenarioResource testScenarioResource = testScenario.getTestScenarioResource();
                    if (testScenarioResource == null) continue;
                    pw.println("," + testScenario.getScenarioId() + "," + new BigDecimal(testScenarioResource.getExpectedCost() / this.rate).setScale(2, 4).doubleValue());
                }
            }
            pw.flush();
        }
        catch (Exception e) {
            ServiceManagerFactory.getLogger().write("CTR__00001", e);
            return;
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }
}

