/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.report;

import java.math.BigDecimal;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestReporter;
import jp.ossc.nimbus.service.test.TestScenario;
import jp.ossc.nimbus.service.test.TestScenarioGroup;
import jp.ossc.nimbus.service.test.report.ConsoleTestEstimateReporterServiceMBean;

public class ConsoleTestEstimateReporterService
extends ServiceBase
implements ConsoleTestEstimateReporterServiceMBean,
TestReporter {
    private static final long serialVersionUID = 1L;
    private double rate = 1.0;

    @Override
    public double getRate() {
        return this.rate;
    }

    @Override
    public void setRate(double rate) {
        this.rate = rate;
    }

    @Override
    public void startService() throws Exception {
        if (this.rate <= 0.0) {
            throw new IllegalArgumentException("Please specify a number greater than 0.");
        }
    }

    @Override
    public void report(TestController controller) {
        try {
            TestScenarioGroup[] groups = controller.getScenarioGroups();
            for (int index = 0; index < groups.length; ++index) {
                String scenarioGroupId = groups[index].getScenarioGroupId();
                TestScenarioGroup testScenarioGroup = controller.getScenarioGroup(scenarioGroupId);
                TestScenario[] testScenarios = controller.getScenarios(scenarioGroupId);
                TestScenarioGroup.TestScenarioGroupResource testScenarioGroupResource = testScenarioGroup.getTestScenarioGroupResource();
                if (testScenarioGroupResource == null) continue;
                System.out.println(scenarioGroupId + ":" + new BigDecimal(testScenarioGroupResource.getExpectedCost() / this.rate).setScale(2, 4).doubleValue());
                for (int index2 = 0; index2 < testScenarios.length; ++index2) {
                    TestScenario testScenario = testScenarios[index2];
                    TestScenario.TestScenarioResource testScenarioResource = testScenario.getTestScenarioResource();
                    if (testScenarioResource == null) continue;
                    System.out.println("  " + testScenario.getScenarioId() + ":" + new BigDecimal(testScenarioResource.getExpectedCost() / this.rate).setScale(2, 4).doubleValue());
                }
            }
        }
        catch (Exception e) {
            ServiceManagerFactory.getLogger().write("CTR__00001", e);
            return;
        }
    }
}

