/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.test.TestCase;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestReporter;
import jp.ossc.nimbus.service.test.TestScenario;
import jp.ossc.nimbus.service.test.TestScenarioGroup;
import jp.ossc.nimbus.service.test.report.HtmlTestReporterServiceMBean;

public class HtmlTestReporterService
extends ServiceBase
implements HtmlTestReporterServiceMBean,
TestReporter {
    private static final long serialVersionUID = -4424650003483721058L;
    private File outputPath;
    private File downloadDir;
    private boolean isDownloadErrorOnly = true;

    @Override
    public File getOutputPath() {
        return this.outputPath;
    }

    @Override
    public void setOutputPath(File outputPath) throws IOException {
        this.outputPath = outputPath == null ? null : outputPath.getCanonicalFile();
    }

    @Override
    public boolean isDownloadErrorOnly() {
        return this.isDownloadErrorOnly;
    }

    @Override
    public void setDownloadErrorOnly(boolean errorOnly) {
        this.isDownloadErrorOnly = errorOnly;
    }

    @Override
    public void startService() throws Exception {
        if (this.outputPath == null) {
            throw new IllegalArgumentException("OutputPath is null.");
        }
        if (!this.outputPath.exists() && !this.outputPath.mkdirs()) {
            throw new IllegalArgumentException("Output dir can not make. path=" + this.outputPath);
        }
        this.downloadDir = new File(this.outputPath, "download");
        if (!this.downloadDir.exists() && !this.downloadDir.mkdirs()) {
            throw new IllegalArgumentException("Download dir can not make. path=" + this.downloadDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(TestController controller) {
        PrintWriter pw = null;
        try {
            TestScenarioGroup[] groups = controller.getScenarioGroups();
            pw = new PrintWriter(new BufferedWriter(new FileWriter(new File(this.outputPath, "index.html"))));
            pw.println("<html>");
            pw.println("<head><title>Test Result</title></head>");
            pw.println("<body>");
            pw.println("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"70%\">");
            pw.println("<tr bgcolor=\"#cccccc\">");
            pw.println("<th colspan=\"4\" scope=\"colgroup\">ScenarioGroup</th>");
            pw.println("<th colspan=\"6\" scope=\"colgroup\">Scenario</th>");
            pw.println("<th colspan=\"6\" scope=\"colgroup\">TestCase</th>");
            pw.println("</tr>");
            pw.println("<tr bgcolor=\"#cccccc\">");
            pw.println("<th scope=\"col\">ID</th>");
            pw.println("<th scope=\"col\">\u5b9f\u884c\u8005</th>");
            pw.println("<th scope=\"col\">\u958b\u59cb\u6642\u9593</th>");
            pw.println("<th scope=\"col\">\u7d50\u679c</th>");
            pw.println("<th scope=\"col\">ID</th>");
            pw.println("<th scope=\"col\">\u5b9f\u884c\u8005</th>");
            pw.println("<th scope=\"col\">\u958b\u59cb\u6642\u9593</th>");
            pw.println("<th scope=\"col\">\u7d42\u4e86\u6642\u9593</th>");
            pw.println("<th scope=\"col\">\u30b9\u30c6\u30fc\u30bf\u30b9</th>");
            pw.println("<th scope=\"col\">\u7d50\u679c</th>");
            pw.println("<th scope=\"col\">ID</th>");
            pw.println("<th scope=\"col\">\u5b9f\u884c\u8005</th>");
            pw.println("<th scope=\"col\">\u958b\u59cb\u6642\u9593</th>");
            pw.println("<th scope=\"col\">\u7d42\u4e86\u6642\u9593</th>");
            pw.println("<th scope=\"col\">\u30b9\u30c6\u30fc\u30bf\u30b9</th>");
            pw.println("<th scope=\"col\">\u7d50\u679c</th>");
            pw.println("</tr>");
            for (int index = 0; index < groups.length; ++index) {
                TestScenarioGroup.TestScenarioGroupResource resource;
                if (groups[index].getStatus() == null || (resource = groups[index].getTestScenarioGroupResource()) == null) continue;
                this.reportScenarioGroup(pw, controller, groups[index]);
            }
            pw.println("</body>");
            pw.println("</html>");
            pw.flush();
        }
        catch (Exception e) {
            ServiceManagerFactory.getLogger().write("CTR__00001", e);
            return;
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private void reportScenarioGroup(PrintWriter pw, TestController controller, TestScenarioGroup group) throws Exception {
        TestScenario[] scenarios = controller.getScenarios(group.getScenarioGroupId());
        TreeMap<String, TestCase[]> scenarioTestcaseMap = new TreeMap<String, TestCase[]>();
        int testCaseCount = 0;
        for (int index = 0; index < scenarios.length; ++index) {
            TestCase[] cases = controller.getTestCases(group.getScenarioGroupId(), scenarios[index].getScenarioId());
            testCaseCount = cases.length == 0 ? ++testCaseCount : (testCaseCount += cases.length);
            scenarioTestcaseMap.put(scenarios[index].getScenarioId(), cases);
        }
        pw.println("<tr>");
        pw.println("<td rowspan=\"" + testCaseCount + "\" scope=\"rowgroup\">" + group.getScenarioGroupId() + "</td>");
        pw.println("<td rowspan=\"" + testCaseCount + "\" scope=\"rowgroup\">" + group.getStatus().getUserId() + "</td>");
        pw.println("<td rowspan=\"" + testCaseCount + "\" scope=\"rowgroup\">" + this.formatDate(group.getStatus().getStartTime()) + "</td>");
        this.reportResult(pw, group.getStatus().getResult(), group.getStatus().getThrowable(), testCaseCount, "rowgroup");
        Iterator ite = scenarioTestcaseMap.keySet().iterator();
        boolean isFirst = true;
        while (ite.hasNext()) {
            String scenarioId = (String)ite.next();
            TestScenario scenario = null;
            for (int i = 0; i < scenarios.length; ++i) {
                if (!scenarioId.equals(scenarios[i].getScenarioId())) continue;
                scenario = scenarios[i];
            }
            if (scenario.getStatus() == null) continue;
            TestCase[] cases = (TestCase[])scenarioTestcaseMap.get(scenarioId);
            int caseCount = 0;
            caseCount = cases.length == 0 ? 1 : cases.length;
            if (!isFirst) {
                pw.println("<tr>");
            }
            isFirst = false;
            if (this.isDownloadErrorOnly && !scenario.getStatus().getResult()) {
                String downloadFilepath = this.downloadResult(controller, scenario.getScenarioGroupId(), scenario.getScenarioId(), null);
                pw.println("<td rowspan=\"" + caseCount + "\"scope=\"rowgroup\"><a href=\"" + downloadFilepath + "\">" + scenarioId + "</a></td>");
            } else {
                pw.println("<td rowspan=\"" + caseCount + "\"scope=\"rowgroup\">" + scenarioId + "</td>");
            }
            pw.println("<td rowspan=\"" + caseCount + "\"scope=\"rowgroup\">" + scenario.getStatus().getUserId() + "</td>");
            pw.println("<td rowspan=\"" + caseCount + "\"scope=\"rowgroup\">" + this.formatDate(scenario.getStatus().getStartTime()) + "</td>");
            pw.println("<td rowspan=\"" + caseCount + "\"scope=\"rowgroup\">" + this.formatDate(scenario.getStatus().getEndTime()) + "</td>");
            pw.println("<td rowspan=\"" + caseCount + "\"scope=\"rowgroup\">" + scenario.getStatus().getStateString() + "</td>");
            this.reportResult(pw, scenario.getStatus().getResult(), scenario.getStatus().getThrowable(), caseCount, "rowgroup");
            if (cases.length > 0 && cases[0].getStatus() != null) {
                this.reportTestCase(pw, controller, cases[0]);
                pw.println("</tr>");
                for (int index = 1; index < cases.length; ++index) {
                    pw.println("<tr>");
                    this.reportTestCase(pw, controller, cases[index]);
                    pw.println("</tr>");
                }
                continue;
            }
            pw.println("</tr>");
        }
    }

    private void reportTestCase(PrintWriter pw, TestController controller, TestCase testCase) throws Exception {
        if (this.isDownloadErrorOnly && testCase.getStatus() != null && !testCase.getStatus().getResult()) {
            String downloadFilepath = this.downloadResult(controller, testCase.getScenarioGroupId(), testCase.getScenarioId(), testCase.getTestCaseId());
            pw.println("<td scope=\"row\"><a href=\"" + downloadFilepath + "\">" + testCase.getTestCaseId() + "</a></td>");
        } else {
            pw.println("<td scope=\"row\">" + testCase.getTestCaseId() + "</td>");
        }
        if (testCase.getStatus() != null) {
            pw.println("<td scope=\"row\">" + testCase.getStatus().getUserId() + "</td>");
            pw.println("<td scope=\"row\">" + this.formatDate(testCase.getStatus().getStartTime()) + "</td>");
            pw.println("<td scope=\"row\">" + this.formatDate(testCase.getStatus().getEndTime()) + "</td>");
            pw.println("<td scope=\"row\">" + testCase.getStatus().getStateString() + "</td>");
            this.reportResult(pw, testCase.getStatus().getResult(), testCase.getStatus().getThrowable(), 0, "row");
        } else {
            pw.println("<td scope=\"row\"></td>");
            pw.println("<td scope=\"row\"></td>");
            pw.println("<td scope=\"row\"></td>");
            pw.println("<td scope=\"row\"></td>");
            pw.println("<td scope=\"row\"></td>");
        }
    }

    private void reportResult(PrintWriter pw, boolean result, Throwable throwable, int rowspan, String scope) {
        pw.print("<td ");
        if (rowspan > 0) {
            pw.print("rowspan=\"" + rowspan + "\" ");
        }
        pw.print("scope=\"" + scope + "\" ");
        if (throwable != null) {
            pw.print("bgcolor=\"#ff4500\">" + throwable.getMessage());
        } else if (result) {
            pw.print("bgcolor=\"#98fb98\" align=\"center\">OK");
        } else {
            pw.print("bgcolor=\"#ff4500\" align=\"center\">NG");
        }
        pw.println("</td>");
    }

    private String formatDate(Date date) {
        return date != null ? new SimpleDateFormat("yyyy/MM/dd HH:mm").format(date) : "";
    }

    private String downloadResult(TestController controller, String scenarioGroupId, String scenarioId, String testcaseId) throws Exception {
        File result = null;
        result = testcaseId != null ? controller.downloadTestCaseResult(this.downloadDir, scenarioGroupId, scenarioId, testcaseId, 1) : controller.downloadScenarioResult(this.downloadDir, scenarioGroupId, scenarioId, 1);
        return result.getAbsolutePath();
    }
}

