/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.io.ExtentionFileFilter;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.service.test.TemplateEngine;
import jp.ossc.nimbus.service.test.TestResourceManager;
import jp.ossc.nimbus.service.test.resource.LocalTestResourceManagerServiceMBean;

public class LocalTestResourceManagerService
extends ServiceBase
implements TestResourceManager,
LocalTestResourceManagerServiceMBean {
    private static final long serialVersionUID = 2415695763380446884L;
    protected File testResourceDirectory;
    protected String[] excludeFilterRegexs;
    protected ServiceName templateEngineServiceName;
    protected TemplateEngine templateEngine;
    protected String templateLinkFileExtention = ".tln";
    protected String templateLinkFileEncoding;

    @Override
    public File getTestResourceDirectory() {
        return this.testResourceDirectory;
    }

    @Override
    public void setTestResourceDirectory(File path) {
        this.testResourceDirectory = path;
    }

    public String[] getExcludeFilterRegexs() {
        return this.excludeFilterRegexs;
    }

    public void setExcludeFilterRegexs(String[] excludeFilterRegexs) {
        this.excludeFilterRegexs = excludeFilterRegexs;
    }

    @Override
    public void setTemplateEngineServiceName(ServiceName name) {
        this.templateEngineServiceName = name;
    }

    @Override
    public ServiceName getTemplateEngineServiceName() {
        return this.templateEngineServiceName;
    }

    @Override
    public void setTemplateLinkFileExtention(String ext) {
        if (ext.charAt(0) != '.') {
            ext = '.' + ext;
        }
        this.templateLinkFileExtention = ext;
    }

    @Override
    public String getTemplateLinkFileExtention() {
        return this.templateLinkFileExtention;
    }

    @Override
    public void setTemplateLinkFileEncoding(String encoding) {
        this.templateLinkFileEncoding = encoding;
    }

    @Override
    public String getTemplateLinkFileEncoding() {
        return this.templateLinkFileEncoding;
    }

    public void setTemplateEngine(TemplateEngine engine) {
        this.templateEngine = engine;
    }

    @Override
    public void startService() throws Exception {
        String filePath;
        ServiceLoader loader;
        ServiceMetaData metaData;
        File serviceDefDir = null;
        if (this.getServiceNameObject() != null && (metaData = ServiceManagerFactory.getServiceMetaData(this.getServiceNameObject())) != null && (loader = metaData.getServiceLoader()) != null && (filePath = loader.getServiceURL().getFile()) != null) {
            serviceDefDir = new File(filePath).getParentFile();
        }
        if (this.testResourceDirectory == null) {
            this.testResourceDirectory = serviceDefDir == null ? new File(".") : serviceDefDir;
        } else if (!this.testResourceDirectory.isAbsolute() && !this.testResourceDirectory.exists() && serviceDefDir != null) {
            this.testResourceDirectory = new File(serviceDefDir, this.testResourceDirectory.getPath());
        }
        if (!this.testResourceDirectory.exists()) {
            this.testResourceDirectory.mkdirs();
        }
        if (this.templateEngineServiceName != null) {
            this.templateEngine = (TemplateEngine)ServiceManagerFactory.getServiceObject(this.templateEngineServiceName);
        }
    }

    @Override
    public void checkOut() throws Exception {
    }

    @Override
    public String[] getScenarioGroupIds() throws Exception {
        File[] files = this.testResourceDirectory.listFiles(new FileFilter());
        ArrayList<String> scenarioGroupList = new ArrayList<String>();
        for (int index = 0; index < files.length; ++index) {
            File file = files[index];
            if (!file.isDirectory()) continue;
            scenarioGroupList.add(file.getName());
        }
        Object[] scenarioGroups = new String[scenarioGroupList.size()];
        for (int index = 0; index < scenarioGroupList.size(); ++index) {
            scenarioGroups[index] = (String)scenarioGroupList.get(index);
        }
        if (scenarioGroups != null) {
            Arrays.sort(scenarioGroups);
        }
        return scenarioGroups;
    }

    @Override
    public String[] getScenarioIds(String scenarioGroupId) throws Exception {
        File testResourceFiles = new File(this.testResourceDirectory, scenarioGroupId);
        File[] files = testResourceFiles.listFiles(new FileFilter());
        if (files == null) {
            return null;
        }
        ArrayList<String> scenarioList = new ArrayList<String>();
        for (int index = 0; index < files.length; ++index) {
            File file = files[index];
            if (!file.isDirectory()) continue;
            scenarioList.add(file.getName());
        }
        Object[] scenarios = new String[scenarioList.size()];
        for (int index = 0; index < scenarioList.size(); ++index) {
            scenarios[index] = (String)scenarioList.get(index);
        }
        if (scenarios != null) {
            Arrays.sort(scenarios);
        }
        return scenarios;
    }

    @Override
    public String[] getTestCaseIds(String scenarioGroupId, String scenarioId) throws Exception {
        File testResourceFiles = new File(this.testResourceDirectory, scenarioGroupId + "/" + scenarioId);
        File[] files = testResourceFiles.listFiles(new FileFilter());
        if (files == null) {
            return null;
        }
        ArrayList<String> testCaseList = new ArrayList<String>();
        for (int index = 0; index < files.length; ++index) {
            File file = files[index];
            if (!file.isDirectory()) continue;
            testCaseList.add(file.getName());
        }
        Object[] testCases = new String[testCaseList.size()];
        for (int index = 0; index < testCaseList.size(); ++index) {
            testCases[index] = (String)testCaseList.get(index);
        }
        if (testCases != null) {
            Arrays.sort(testCases);
        }
        return testCases;
    }

    @Override
    public String[] getStubIds(String scenarioGroupId, String scenarioId, String testcaseId) throws Exception {
        File testResourceFiles = new File(this.testResourceDirectory, "/" + scenarioGroupId + "/" + scenarioId + "/" + testcaseId);
        File[] files = testResourceFiles.listFiles(new FileFilter());
        if (files == null) {
            return null;
        }
        ArrayList<String> stubList = new ArrayList<String>();
        for (int index = 0; index < files.length; ++index) {
            File file = files[index];
            if (!file.isDirectory()) continue;
            stubList.add(file.getName());
        }
        Object[] stubIds = (String[])stubList.toArray();
        if (stubIds != null) {
            Arrays.sort(stubIds);
        }
        return stubIds;
    }

    @Override
    public void downloadScenarioGroupResource(File dir, String scenarioGroupId) throws Exception {
        File resourceFiles = new File(this.testResourceDirectory, "/" + scenarioGroupId);
        File[] files = resourceFiles.listFiles(new FileFilter());
        if (files == null) {
            return;
        }
        for (int index = 0; index < files.length; ++index) {
            File file = files[index];
            if (!file.isFile()) continue;
            File copyFile = new File(dir, file.getName());
            FileInputStream fis = new FileInputStream(file);
            FileOutputStream fos = new FileOutputStream(copyFile);
            try {
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = fis.read(buf)) != -1) {
                    fos.write(buf, 0, i);
                }
                continue;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
        this.linkTemplate(dir, false);
    }

    protected void linkTemplate(File dir, boolean isRecurcive) throws Exception {
        File[] linkFiles = null;
        if (isRecurcive) {
            RecurciveSearchFile targetDir = new RecurciveSearchFile(dir);
            linkFiles = targetDir.listAllTreeFiles(new ExtentionFileFilter(this.templateLinkFileExtention));
        } else {
            linkFiles = dir.listFiles(new ExtentionFileFilter(this.templateLinkFileExtention));
        }
        if (linkFiles != null) {
            HashSet deleteDataFiles = new HashSet();
            for (int i = 0; i < linkFiles.length; ++i) {
                if (linkFiles[i].isDirectory()) continue;
                this.createTemplateFile(linkFiles[i], deleteDataFiles);
            }
            Iterator dataFiles = deleteDataFiles.iterator();
            while (dataFiles.hasNext()) {
                ((File)dataFiles.next()).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTemplateFile(File linkFile, Set deleteDataFiles) throws Exception {
        if (!linkFile.exists()) {
            return;
        }
        String outputFilePath = linkFile.getPath();
        File outputFile = new File(outputFilePath.substring(0, outputFilePath.length() - this.templateLinkFileExtention.length()));
        BufferedReader br = new BufferedReader(this.templateLinkFileEncoding == null ? new FileReader(linkFile) : new InputStreamReader((InputStream)new FileInputStream(linkFile), this.templateLinkFileEncoding));
        File tmplateFile = null;
        File dataFile = null;
        try {
            String tmplateFilePath = br.readLine();
            if (tmplateFilePath == null) {
                throw new Exception("Unexpected EOF on tmplateFilePath");
            }
            tmplateFile = new File(tmplateFilePath);
            String dataFilePath = br.readLine();
            if (dataFilePath != null && dataFilePath.length() != 0) {
                File linkDataFile;
                dataFile = new File(dataFilePath);
                if (!dataFile.exists() && linkFile.getParentFile() != null) {
                    dataFile = new File(linkFile.getParentFile(), dataFilePath);
                }
                if (!dataFile.exists() && (linkDataFile = new File(dataFilePath + this.templateLinkFileExtention)).exists()) {
                    this.createTemplateFile(linkDataFile, deleteDataFiles);
                }
                if (!dataFile.exists() && linkFile.getParentFile() != null && (linkDataFile = new File(linkFile.getParentFile(), dataFilePath + this.templateLinkFileExtention)).exists()) {
                    this.createTemplateFile(linkDataFile, deleteDataFiles);
                }
                if (!dataFile.exists()) {
                    return;
                }
            }
        }
        finally {
            br.close();
            br = null;
        }
        if (this.templateEngine == null) {
            throw new UnsupportedOperationException("TmplateEngine is null.");
        }
        try {
            this.templateEngine.transform(tmplateFile, dataFile, outputFile, this.templateLinkFileEncoding);
        }
        catch (Exception e) {
            throw new Exception("Template trasform error. tmplateFile=" + tmplateFile + ", dataFile=" + dataFile, e);
        }
        linkFile.delete();
        if (dataFile != null) {
            deleteDataFiles.add(dataFile);
        }
    }

    @Override
    public void downloadScenarioResource(File dir, String scenarioGroupId, String scenarioId) throws Exception {
        RecurciveSearchFile testResourceFiles = new RecurciveSearchFile(this.testResourceDirectory, scenarioGroupId + "/" + scenarioId);
        testResourceFiles.copyAllTree(dir, new FileFilter());
        this.linkTemplate(dir, true);
    }

    protected class FileFilter
    implements FilenameFilter {
        protected FileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (LocalTestResourceManagerService.this.excludeFilterRegexs == null) {
                return true;
            }
            for (int index = 0; index < LocalTestResourceManagerService.this.excludeFilterRegexs.length; ++index) {
                if (!name.matches(LocalTestResourceManagerService.this.excludeFilterRegexs[index])) continue;
                return false;
            }
            return true;
        }
    }
}

