/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.service.test.TemplateEngine;
import jp.ossc.nimbus.service.test.resource.VelocityTemplateEngineServiceMBean;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityTemplateEngineService
extends ServiceBase
implements TemplateEngine,
VelocityTemplateEngineServiceMBean {
    private static final long serialVersionUID = 710504283828129889L;
    private File templateResourceDirectory;
    private Properties properties;
    private VelocityEngine engine;
    private CSVReader csvReader;

    @Override
    public void setTemplateResourceDirectory(File dir) {
        this.templateResourceDirectory = dir;
    }

    @Override
    public File getTemplateResourceDirectory() {
        return this.templateResourceDirectory;
    }

    @Override
    public void setProperties(Properties props) {
        this.properties = props;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setCSVReader(CSVReader reader) {
        this.csvReader = reader;
    }

    @Override
    public void startService() throws Exception {
        Properties props;
        this.engine = new VelocityEngine();
        Properties properties = props = this.properties == null ? new Properties() : this.properties;
        if (this.templateResourceDirectory != null) {
            props.setProperty("file.resource.loader.path", this.templateResourceDirectory.getCanonicalPath());
        }
        props.setProperty("file.resource.loader.cache", Boolean.FALSE.toString());
        this.engine.init(props);
    }

    @Override
    public void stopService() throws Exception {
        this.engine = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(File tmplateFile, File dataFile, File outputFile, String encoding) throws Exception {
        if (dataFile == null) {
            FileInputStream fis = new FileInputStream(this.templateResourceDirectory == null ? tmplateFile : new File(this.templateResourceDirectory, tmplateFile.getPath()));
            FileOutputStream fos = new FileOutputStream(outputFile);
            try {
                byte[] buf = new byte[1024];
                int len = 0;
                while ((len = fis.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
            }
            finally {
                fis.close();
                fos.close();
            }
        }
        Template template = encoding == null ? this.engine.getTemplate(tmplateFile.getPath()) : this.engine.getTemplate(tmplateFile.getPath(), encoding);
        VelocityContext context = new VelocityContext();
        CSVReader reader = this.csvReader == null ? new CSVReader() : this.csvReader.cloneReader();
        reader.setReader(encoding == null ? new FileReader(dataFile) : new InputStreamReader((InputStream)new FileInputStream(dataFile), encoding));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0) continue;
                int index = line.indexOf("=");
                if (index == -1) {
                    String name = line;
                    String[] propNames = reader.readCSVLine();
                    List propValues = null;
                    ArrayList records = new ArrayList();
                    while ((propValues = reader.readCSVLineList(propValues)) != null && propValues.size() != 0) {
                        HashMap<String, String> record = new HashMap<String, String>();
                        for (int i = 0; i < propNames.length; ++i) {
                            String value = this.replaceProperty((String)propValues.get(i));
                            record.put(propNames[i], value);
                        }
                        records.add(record);
                    }
                    context.put(name, records);
                    continue;
                }
                String value = this.replaceProperty(line.substring(index + 1));
                context.put(line.substring(0, index), (Object)value);
            }
        }
        finally {
            reader.close();
            reader = null;
        }
        OutputStreamWriter writer = encoding == null ? new FileWriter(outputFile) : new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding);
        try {
            template.merge((Context)context, (Writer)writer);
        }
        finally {
            ((Writer)writer).close();
            writer = null;
        }
    }

    private String replaceProperty(String textValue) {
        textValue = Utility.replaceSystemProperty(textValue);
        if (this.getServiceLoader() != null) {
            textValue = Utility.replaceServiceLoderConfig(textValue, this.getServiceLoader().getConfig());
        }
        if (this.getServiceManager() != null) {
            textValue = Utility.replaceManagerProperty(this.getServiceManager(), textValue);
        }
        textValue = Utility.replaceServerProperty(textValue);
        return textValue;
    }
}

