/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.servlet;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import javax.management.remote.JMXConnector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.beans.NimbusPropertyEditorManager;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.StringArrayEditor;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.jmx.MBeanServerConnectionFactory;
import jp.ossc.nimbus.service.jmx.MBeanServerConnectionFactoryException;
import jp.ossc.nimbus.util.converter.BeanJSONConverter;
import jp.ossc.nimbus.util.converter.StringStreamConverter;

public class JMXConsoleServlet
extends HttpServlet {
    protected static final String INIT_PARAM_NAME_MBEAN_SERVER_CONNECTION_FACTORY_MANAGER_NAMES = "MBeanServerConnectionFactoryManagerNames";
    protected static final String INIT_PARAM_NAME_MBEAN_SERVER_CONNECTION_FACTORY_SERVICE_NAMES = "MBeanServerConnectionFactoryServiceNames";
    protected static final String INIT_PARAM_NAME_ATTR_SET_ENABLED = "AttributeSetEnabled";
    protected static final String INIT_PARAM_NAME_ATTR_MAX_LENGTH = "AttributeMaxLength";
    protected static final String INIT_PARAM_NAME_OPERATION_ENABLED = "OperationEnabled";
    protected static final String INIT_PARAM_NAME_JSON_CONVERTER_SERVICE_NAME = "JSONConverterServiceName";
    protected static final String INIT_PARAM_NAME_UNICODE_ESCAPE = "UnicodeEscape";
    private static final String ATTRIBUTE_READ_ONLY = "r";
    private static final String ATTRIBUTE_WRITE_ONLY = "w";
    private static final String ATTRIBUTE_READ_AND_WRITE = "rw";
    private Map mbeanServerConnectionFactories;
    private BeanJSONConverter jsonConverter;
    private StringStreamConverter toStringConverter;

    public synchronized void init() throws ServletException {
        ServiceName jsonConverterServiceName = this.getJSONConverterServiceName();
        this.jsonConverter = jsonConverterServiceName == null ? new BeanJSONConverter() : (BeanJSONConverter)ServiceManagerFactory.getServiceObject(jsonConverterServiceName);
        this.jsonConverter.setCharacterEncodingToStream("UTF-8");
        this.jsonConverter.setUnicodeEscape(this.isUnicodeEscape());
        this.toStringConverter = new StringStreamConverter(2);
        this.toStringConverter.setCharacterEncodingToObject("UTF-8");
        this.mbeanServerConnectionFactories = this.getMBeanServerConnectionFactories();
    }

    private Map getMBeanServerConnectionFactories() {
        String serviceNamesStr;
        LinkedHashMap<ServiceName, Object> factories = new LinkedHashMap<ServiceName, Object>();
        ServletConfig config = this.getServletConfig();
        StringArrayEditor editor = new StringArrayEditor();
        ServiceNameEditor nameEditor = new ServiceNameEditor();
        String managerNamesStr = config.getInitParameter(INIT_PARAM_NAME_MBEAN_SERVER_CONNECTION_FACTORY_MANAGER_NAMES);
        if (managerNamesStr != null) {
            editor.setAsText(managerNamesStr);
            String[] managerNames = (String[])editor.getValue();
            if (managerNames != null && managerNames.length != 0) {
                for (int i = 0; i < managerNames.length; ++i) {
                    ServiceManager manager = ServiceManagerFactory.findManager(managerNames[i]);
                    if (manager == null) continue;
                    for (String serviceName : manager.serviceNameSet()) {
                        Service service = manager.getService(serviceName);
                        if (!(service instanceof MBeanServerConnectionFactory)) continue;
                        factories.put(service.getServiceNameObject(), service);
                    }
                }
            }
        }
        if ((serviceNamesStr = config.getInitParameter(INIT_PARAM_NAME_MBEAN_SERVER_CONNECTION_FACTORY_SERVICE_NAMES)) != null) {
            editor.setAsText(serviceNamesStr);
            String[] serviceNames = (String[])editor.getValue();
            if (serviceNames != null && serviceNames.length != 0) {
                for (int i = 0; i < serviceNames.length; ++i) {
                    nameEditor.setAsText(serviceNames[i]);
                    ServiceName name = (ServiceName)nameEditor.getValue();
                    factories.put(name, (MBeanServerConnectionFactory)ServiceManagerFactory.getServiceObject(name));
                }
            }
        }
        return factories;
    }

    private boolean isAttributeSetEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_ATTR_SET_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private int getAttributeMaxLength() {
        ServletConfig config = this.getServletConfig();
        String maxLengthStr = config.getInitParameter(INIT_PARAM_NAME_ATTR_MAX_LENGTH);
        int maxLength = -1;
        if (maxLengthStr != null && maxLengthStr.length() != 0) {
            try {
                maxLength = Integer.parseInt(maxLengthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return maxLength;
    }

    private boolean isOperationEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_OPERATION_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private ServiceName getJSONConverterServiceName() {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_JSON_CONVERTER_SERVICE_NAME);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    private boolean isUnicodeEscape() {
        ServletConfig config = this.getServletConfig();
        String isEscape = config.getInitParameter(INIT_PARAM_NAME_UNICODE_ESCAPE);
        return isEscape == null ? true : Boolean.valueOf(isEscape);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        String action = req.getParameter("action");
        String responseType = req.getParameter("responseType");
        if (action == null) {
            this.processIndexResponse(req, resp, responseType);
        } else if (action.equals("server")) {
            this.processServerResponse(req, resp, responseType);
        } else if (action.equals("domain")) {
            this.processDomainResponse(req, resp, responseType);
        } else if (action.equals("mbean")) {
            this.processMBeanResponse(req, resp, responseType);
        } else if (action.equals("set")) {
            if (!this.isAttributeSetEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processSetAttributeResponse(req, resp, responseType);
        } else if (action.equals("get")) {
            this.processGetAttributeResponse(req, resp, responseType);
        } else if (action.equals("operation")) {
            if (!this.isOperationEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processOperationResponse(req, resp, responseType);
        } else {
            resp.sendError(404);
        }
    }

    private String getCurrentPath(HttpServletRequest req) {
        return req.getContextPath() + req.getServletPath();
    }

    protected void processIndexResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            Object[] serverNames = new String[this.mbeanServerConnectionFactories.size() + 1];
            serverNames[0] = "localhost";
            Iterator serviceNames = this.mbeanServerConnectionFactories.keySet().iterator();
            int i = 1;
            while (serviceNames.hasNext()) {
                serverNames[i++] = serviceNames.next().toString();
            }
            Arrays.sort(serverNames);
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(serverNames)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>JMX Server List</title></head>");
            buf.append("<body>");
            buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
            buf.append("<tr bgcolor=\"#cccccc\"><th>group</th><th>server</th></tr>");
            StringBuffer url = new StringBuffer();
            buf.append("<tr>");
            buf.append("<td>localhost</td>");
            url.append(this.getCurrentPath(req)).append("?action=server&name=localhost");
            buf.append("<td><a href=\"").append(resp.encodeURL(url.toString())).append("\">localhost</a></td>");
            buf.append("</tr>");
            Iterator<Object> serviceNames = this.mbeanServerConnectionFactories.keySet().iterator();
            TreeMap<String, TreeSet<ServiceName>> groupList = new TreeMap<String, TreeSet<ServiceName>>();
            while (serviceNames.hasNext()) {
                ServiceName serviceName = (ServiceName)serviceNames.next();
                TreeSet<ServiceName> serverList = (TreeSet<ServiceName>)groupList.get(serviceName.getServiceManagerName());
                if (serverList == null) {
                    serverList = new TreeSet<ServiceName>();
                    groupList.put(serviceName.getServiceManagerName(), serverList);
                }
                serverList.add(serviceName);
            }
            for (Map.Entry entry : groupList.entrySet()) {
                String group = (String)entry.getKey();
                Set serverList = (Set)entry.getValue();
                serviceNames = serverList.iterator();
                boolean isFirst = true;
                while (serviceNames.hasNext()) {
                    ServiceName serviceName = (ServiceName)serviceNames.next();
                    buf.append("<tr>");
                    if (isFirst) {
                        if (serverList.size() > 1) {
                            buf.append("<td rowspan=\"").append(serverList.size()).append("\">");
                        } else {
                            buf.append("<td>");
                        }
                        buf.append(group).append("</td>");
                        isFirst = false;
                    }
                    url.setLength(0);
                    url.append(this.getCurrentPath(req)).append("?action=server&name=").append(URLEncoder.encode(serviceName.toString(), "UTF-8"));
                    buf.append("<td><a href=\"").append(resp.encodeURL(url.toString())).append("\">");
                    buf.append(serviceName.getServiceName()).append("</a></td>");
                    buf.append("</tr>");
                }
            }
            buf.append("</table>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processServerResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serverName = req.getParameter("name");
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            ArrayList<Object> domainNameList = new ArrayList<Object>();
            if (serverName == null || "localhost".equals(serverName)) {
                ArrayList<MBeanServer> mbeanServers;
                if (serverName == null) {
                    serverName = "localhost";
                }
                if ((mbeanServers = MBeanServerFactory.findMBeanServer(null)) == null || mbeanServers.size() == 0) {
                    resp.sendError(404);
                    return;
                }
                for (int i = 0; i < mbeanServers.size(); ++i) {
                    MBeanServer mbeanServer = (MBeanServer)mbeanServers.get(i);
                    String[] domains = mbeanServer.getDomains();
                    if (domains == null || domains.length == 0) continue;
                    ArrayList<String> domainNameSubList = new ArrayList<String>();
                    for (int j = 0; j < domains.length; ++j) {
                        domainNameSubList.add(domains[j]);
                    }
                    Collections.sort(domainNameSubList);
                    domainNameList.add(domainNameSubList);
                }
            } else {
                ServiceNameEditor editor = new ServiceNameEditor();
                editor.setAsText(serverName);
                ServiceName serviceName = (ServiceName)editor.getValue();
                MBeanServerConnectionFactory factory = (MBeanServerConnectionFactory)this.mbeanServerConnectionFactories.get(serviceName);
                if (factory == null) {
                    resp.sendError(404);
                    return;
                }
                JMXConnector connector = null;
                try {
                    connector = factory.getJMXConnector();
                    connector.connect();
                    MBeanServerConnection mbeanServer = connector.getMBeanServerConnection();
                    String[] domains = mbeanServer.getDomains();
                    if (domains != null && domains.length != 0) {
                        ArrayList domainNameSubList = new ArrayList();
                        for (int i = 0; i < domains.length; ++i) {
                            domainNameList.add(domains[i]);
                        }
                    }
                    Collections.sort(domainNameList);
                }
                catch (MBeanServerConnectionFactoryException e) {
                    throw new ServletException((Throwable)e);
                }
                finally {
                    if (connector != null) {
                        connector.close();
                    }
                }
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(domainNameList)));
        } else {
            if (serverName == null || "localhost".equals(serverName)) {
                ArrayList<MBeanServer> mbeanServers;
                if (serverName == null) {
                    serverName = "localhost";
                }
                if ((mbeanServers = MBeanServerFactory.findMBeanServer(null)) == null || mbeanServers.size() == 0) {
                    resp.sendError(404);
                    return;
                }
                resp.setContentType("text/html;charset=UTF-8");
                buf.append("<html>");
                buf.append("<head><title>JMX Server localhost</title></head>");
                buf.append("<body>");
                buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">JMX Server List</a>");
                buf.append("<hr>");
                buf.append("<b>JMX Server name : </b>localhost<p>");
                buf.append("<b>Domains</b><br>");
                buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
                buf.append("<tr bgcolor=\"#cccccc\"><th>index</th><th>domain</th></tr>");
                for (int i = 0; i < mbeanServers.size(); ++i) {
                    MBeanServer mbeanServer = (MBeanServer)mbeanServers.get(i);
                    Object[] domains = mbeanServer.getDomains();
                    if (domains == null || domains.length == 0) continue;
                    Arrays.sort(domains);
                    StringBuffer url = new StringBuffer();
                    for (int j = 0; j < domains.length; ++j) {
                        buf.append("<tr>");
                        if (j == 0) {
                            if (domains.length > 1) {
                                buf.append("<td rowspan=\"").append(domains.length).append("\">");
                            } else {
                                buf.append("<td>");
                            }
                            buf.append(i + 1).append("</td>");
                        }
                        url.setLength(0);
                        url.append(this.getCurrentPath(req)).append("?action=domain&index=").append(i + 1).append("&serverName=localhost").append("&name=").append(URLEncoder.encode((String)domains[j], "UTF-8"));
                        buf.append("<td><a href=\"").append(resp.encodeURL(url.toString())).append("\">");
                        buf.append((String)domains[j]).append("</a></td>");
                        buf.append("</tr>");
                    }
                }
                buf.append("</table>");
            } else {
                ServiceNameEditor editor = new ServiceNameEditor();
                editor.setAsText(serverName);
                ServiceName serviceName = (ServiceName)editor.getValue();
                MBeanServerConnectionFactory factory = (MBeanServerConnectionFactory)this.mbeanServerConnectionFactories.get(serviceName);
                if (factory == null) {
                    resp.sendError(404);
                    return;
                }
                resp.setContentType("text/html;charset=UTF-8");
                buf.append("<html>");
                buf.append("<head><title>JMX Server ").append(serverName).append("</title></head>");
                buf.append("<body>");
                buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">JMX Server List</a>");
                buf.append("<hr>");
                buf.append("<b>JMX Server name : </b>").append(serverName).append("<p>");
                buf.append("<b>Domains</b><br>");
                buf.append("<ul>");
                JMXConnector connector = null;
                try {
                    connector = factory.getJMXConnector();
                    connector.connect();
                    MBeanServerConnection mbeanServer = connector.getMBeanServerConnection();
                    Object[] domains = mbeanServer.getDomains();
                    if (domains != null && domains.length != 0) {
                        Arrays.sort(domains);
                        StringBuffer url = new StringBuffer();
                        for (int i = 0; i < domains.length; ++i) {
                            url.setLength(0);
                            url.append(this.getCurrentPath(req)).append("?action=domain&serverName=").append(URLEncoder.encode(serverName, "UTF-8")).append("&name=").append(URLEncoder.encode((String)domains[i], "UTF-8"));
                            buf.append("<li>");
                            buf.append("<a href=\"").append(resp.encodeURL(url.toString())).append("\">");
                            buf.append((String)domains[i]).append("</a>");
                            buf.append("</li>");
                        }
                    }
                }
                catch (MBeanServerConnectionFactoryException e) {
                    throw new ServletException((Throwable)e);
                }
                finally {
                    if (connector != null) {
                        connector.close();
                    }
                }
                buf.append("</ul>");
            }
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">JMX Server List</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    /*
     * Unable to fully structure code
     */
    protected void processDomainResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        serverName = req.getParameter("serverName");
        indexStr = req.getParameter("index");
        index = 1;
        if (indexStr != null) {
            index = Integer.parseInt(indexStr);
        }
        domainName = req.getParameter("name");
        objectNameList = new ArrayList<String>();
        if (serverName == null || "localhost".equals(serverName)) {
            if (serverName == null) {
                serverName = "localhost";
            }
            if ((mbeanServers = MBeanServerFactory.findMBeanServer(null)) == null || mbeanServers.size() < index) {
                resp.sendError(404);
                return;
            }
            mbeanServer = (MBeanServer)mbeanServers.get(index - 1);
            objectName = null;
            try {
                objectName = new ObjectName(domainName + ":*");
            }
            catch (MalformedObjectNameException e) {
                throw new ServletException((Throwable)e);
            }
            objectNameSet = mbeanServer.queryNames(objectName, null);
            if (objectNameSet != null && objectNameSet.size() != 0) {
                objectNames = objectNameSet.toArray();
                Arrays.sort(objectNames);
                for (j = 0; j < objectNames.length; ++j) {
                    objectNameList.add(objectNames[j].toString());
                }
            }
        } else {
            editor = new ServiceNameEditor();
            editor.setAsText(serverName);
            serviceName = (ServiceName)editor.getValue();
            factory = (MBeanServerConnectionFactory)this.mbeanServerConnectionFactories.get(serviceName);
            if (factory == null) {
                resp.sendError(404);
                return;
            }
            connector = null;
            try {
                connector = factory.getJMXConnector();
                connector.connect();
                mbeanServer = connector.getMBeanServerConnection();
                objectNameSet = mbeanServer.queryNames(new ObjectName(domainName + ":*"), null);
                if (objectNameSet == null || objectNameSet.size() == 0) ** GOTO lbl60
                objectNames = objectNameSet.toArray();
                Arrays.sort(objectNames);
                for (j = 0; j < objectNames.length; ++j) {
                    objectNameList.add(objectNames[j].toString());
                }
            }
            catch (MBeanServerConnectionFactoryException e) {
                throw new ServletException((Throwable)e);
            }
            catch (MalformedObjectNameException e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                if (connector != null) {
                    connector.close();
                }
            }
        }
lbl60:
        // 3 sources

        buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(objectNameList)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>JMX Domain ").append(domainName).append("</title></head>");
            buf.append("<body>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=server&name=").append(URLEncoder.encode(serverName, "UTF-8")).append("&index=").append(index).append("\">JMX Server ").append(serverName).append("</a>");
            buf.append("<hr>");
            buf.append("<b>JMX Domain name : </b>").append(domainName).append("<p>");
            buf.append("<b>MBean List</b><br>");
            buf.append("<ul>");
            if (objectNameList.size() != 0) {
                url = new StringBuffer();
                for (i = 0; i < objectNameList.size(); ++i) {
                    url.setLength(0);
                    url.append(this.getCurrentPath(req)).append("?action=mbean&serverName=").append(URLEncoder.encode(serverName, "UTF-8")).append("&index=").append(index).append("&name=").append(URLEncoder.encode((String)objectNameList.get(i), "UTF-8"));
                    buf.append("<li>");
                    buf.append("<a href=\"").append(resp.encodeURL(url.toString())).append("\">");
                    buf.append(objectNameList.get(i)).append("</a>");
                    buf.append("</li>");
                }
            }
            buf.append("</ul>");
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=server&name=").append(URLEncoder.encode(serverName, "UTF-8")).append("&index=").append(index).append("\">JMX Server ").append(serverName).append("</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    /*
     * Exception decompiling
     */
    protected void processMBeanResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object getAttributeValue(MBeanServer server, ObjectName name, MBeanAttributeInfo attribute, boolean isHtml) {
        Object val = null;
        try {
            val = server.getAttribute(name, attribute.getName());
        }
        catch (MBeanException e) {
            e.printStackTrace();
            return "Can not get!!";
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
            return "Can not get!!";
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            return "Can not get!!";
        }
        catch (ReflectionException e) {
            e.printStackTrace();
            return "Can not get!!";
        }
        return this.getAttributeValue(attribute, val, isHtml);
    }

    private Object getAttributeValue(MBeanAttributeInfo attribute, Object val, boolean isHtml) {
        Class type = null;
        try {
            type = Utility.convertStringToClass(attribute.getType());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Object result = this.toAttributeValue(attribute, type, val, isHtml);
        if (result == null) {
            return null;
        }
        return result;
    }

    private Object toAttributeValue(MBeanAttributeInfo attribute, Class type, Object val, boolean isHtml) {
        return this.formatValue(attribute.isWritable(), type, val, isHtml);
    }

    private Object formatValue(boolean isWritable, Class type, Object val, boolean isHtml) {
        PropertyEditor editor;
        if (val == null) {
            if (isHtml) {
                return new StringBuffer().append("<textarea name=\"value\" cols=\"40\" rows=\"2\"").append(!isWritable ? "readonly>" : ">").append(val).append("</textarea>").toString();
            }
            return null;
        }
        if (val instanceof String) {
            if (isHtml) {
                String resultStr = val.toString();
                int maxLength = this.getAttributeMaxLength();
                if (maxLength > 0 && resultStr.length() > maxLength) {
                    resultStr = resultStr.substring(0, maxLength);
                }
                val = resultStr;
                return new StringBuffer().append("<textarea name=\"value\" cols=\"40\" rows=\"2\"").append(!isWritable ? "readonly>" : ">").append(val).append("</textarea>").toString();
            }
            return val.toString();
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (CompositeData.class.isAssignableFrom(componentType) || TabularData.class.isAssignableFrom(componentType)) {
                if (isHtml) {
                    StringBuffer buf = new StringBuffer();
                    int imax = Array.getLength(val);
                    for (int i = 0; i < imax; ++i) {
                        Object element = Array.get(val, i);
                        buf.append(this.formatValue(isWritable, type.getComponentType(), element, isHtml));
                    }
                    return buf.toString();
                }
                ArrayList<Object> list = new ArrayList<Object>();
                int imax = Array.getLength(val);
                for (int i = 0; i < imax; ++i) {
                    Object element = Array.get(val, i);
                    list.add(this.formatValue(isWritable, type.getComponentType(), element, isHtml));
                }
                return list;
            }
            if (isHtml) {
                PropertyEditor editor2;
                PropertyEditor propertyEditor = editor2 = type == null ? null : NimbusPropertyEditorManager.findEditor(type);
                if (editor2 != null) {
                    editor2.setValue(val);
                    String resultStr = editor2.getAsText();
                    int maxLength = this.getAttributeMaxLength();
                    if (maxLength > 0 && resultStr.length() > maxLength) {
                        resultStr = resultStr.substring(0, maxLength);
                    }
                    val = resultStr;
                }
                return new StringBuffer().append("<textarea name=\"value\" cols=\"40\" rows=\"2\"").append(!isWritable ? "readonly>" : ">").append(val).append("</textarea>").toString();
            }
            ArrayList<Object> list = new ArrayList<Object>();
            int imax = Array.getLength(val);
            for (int i = 0; i < imax; ++i) {
                Object element = Array.get(val, i);
                list.add(this.formatValue(isWritable, type.getComponentType(), element, isHtml));
            }
            return list;
        }
        if (val instanceof CompositeData) {
            CompositeData compositeData = (CompositeData)val;
            CompositeType compositeType = compositeData.getCompositeType();
            if (isHtml) {
                StringBuffer buf = new StringBuffer();
                buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
                for (String key : compositeType.keySet()) {
                    Object element = compositeData.get(key);
                    buf.append("<tr><th bgcolor=\"#cccccc\">").append(key).append("</th>");
                    Class<?> elementType = element == null ? null : element.getClass();
                    buf.append("<td>").append(this.formatValue(isWritable, elementType, element, isHtml)).append("</td></tr>");
                }
                buf.append("</table>");
                return buf.toString();
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String key : compositeType.keySet()) {
                Object element = compositeData.get(key);
                Class<?> elementType = element == null ? null : element.getClass();
                map.put(key, this.formatValue(isWritable, elementType, element, isHtml));
            }
            return map;
        }
        if (val instanceof TabularData) {
            TabularData tabularData = (TabularData)val;
            TabularType tabularType = tabularData.getTabularType();
            if (isHtml) {
                StringBuffer buf = new StringBuffer();
                buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
                buf.append("<tr>");
                List<String> colNames = tabularType.getIndexNames();
                for (int i = 0; i < colNames.size(); ++i) {
                    buf.append("<th bgcolor=\"#cccccc\">").append((Object)colNames.get(i)).append("</th>");
                }
                buf.append("</tr>");
                CompositeType rowType = tabularType.getRowType();
                for (CompositeData compositeData : tabularData.values()) {
                    buf.append("<tr>");
                    for (int i = 0; i < colNames.size(); ++i) {
                        Object element = compositeData.get(colNames.get(i));
                        Class<?> elementType = element == null ? null : element.getClass();
                        buf.append("<td>").append(this.formatValue(isWritable, elementType, element, isHtml)).append("</td>");
                    }
                    buf.append("</tr>");
                }
                buf.append("</table>");
                return buf.toString();
            }
            ArrayList records = new ArrayList();
            List<String> colNames = tabularType.getIndexNames();
            CompositeType rowType = tabularType.getRowType();
            for (CompositeData compositeData : tabularData.values()) {
                LinkedHashMap<String, Object> record = new LinkedHashMap<String, Object>();
                for (int i = 0; i < colNames.size(); ++i) {
                    Object element = compositeData.get(colNames.get(i));
                    Class<?> elementType = element == null ? null : element.getClass();
                    record.put(colNames.get(i), this.formatValue(isWritable, elementType, element, isHtml));
                }
                records.add(record);
            }
            return records;
        }
        PropertyEditor propertyEditor = editor = type == null ? null : NimbusPropertyEditorManager.findEditor(type);
        if (editor != null) {
            editor.setValue(val);
            val = editor.getAsText();
        }
        if (isHtml) {
            String resultStr = val.toString();
            int maxLength = this.getAttributeMaxLength();
            if (maxLength > 0 && resultStr.length() > maxLength) {
                resultStr = resultStr.substring(0, maxLength);
            }
            val = resultStr;
            return new StringBuffer().append("<textarea name=\"value\" cols=\"40\" rows=\"2\"").append(!isWritable ? "readonly>" : ">").append(val).append("</textarea>").toString();
        }
        return val.toString();
    }

    private String getAttributeType(MBeanAttributeInfo attribute) {
        if (attribute.isWritable() && attribute.isReadable()) {
            return ATTRIBUTE_READ_AND_WRITE;
        }
        if (attribute.isWritable()) {
            return ATTRIBUTE_WRITE_ONLY;
        }
        return ATTRIBUTE_READ_ONLY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSetAttributeResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serverName = req.getParameter("serverName");
        String indexStr = req.getParameter("index");
        int index = 1;
        if (indexStr != null) {
            index = Integer.parseInt(indexStr);
        }
        String objectNameStr = req.getParameter("name");
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(objectNameStr);
        }
        catch (MalformedObjectNameException e) {
            throw new ServletException((Throwable)e);
        }
        String attributeName = req.getParameter("attribute");
        if (attributeName == null) {
            resp.sendError(400);
            return;
        }
        String attributeType = req.getParameter("attributeType");
        if (attributeType == null) {
            resp.sendError(400);
            return;
        }
        String attributeValue = req.getParameter("value");
        StringBuffer buf = new StringBuffer();
        JMXConnector connector = null;
        try {
            MBeanServerConnection mbeanServer = null;
            if (serverName == null || "localhost".equals(serverName)) {
                ArrayList<MBeanServer> mbeanServers;
                if (serverName == null) {
                    serverName = "localhost";
                }
                if ((mbeanServers = MBeanServerFactory.findMBeanServer(null)) == null || mbeanServers.size() < index) {
                    resp.sendError(404);
                    return;
                }
                mbeanServer = (MBeanServer)mbeanServers.get(index - 1);
            } else {
                ServiceNameEditor editor = new ServiceNameEditor();
                editor.setAsText(serverName);
                ServiceName serviceName = (ServiceName)editor.getValue();
                MBeanServerConnectionFactory factory = (MBeanServerConnectionFactory)this.mbeanServerConnectionFactories.get(serviceName);
                if (factory == null) {
                    resp.sendError(404);
                    return;
                }
                try {
                    connector = factory.getJMXConnector();
                    connector.connect();
                    mbeanServer = connector.getMBeanServerConnection();
                }
                catch (MBeanServerConnectionFactoryException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            String result = this.setAttributeValue(mbeanServer, objectName, attributeName, attributeType, attributeValue);
            if ("json".equals(responseType)) {
                resp.setContentType("application/json;charset=UTF-8");
                HashMap<String, String> json = new HashMap<String, String>();
                json.put("result", result);
                buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(json)));
            } else {
                resp.setContentType("text/html;charset=UTF-8");
                buf.append("<html>");
                buf.append("<head><title>JMX Set Attribute</title></head>");
                buf.append("<body>");
                buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=mbean&serverName=").append(URLEncoder.encode(serverName, "UTF-8")).append("&index=").append(index).append("&name=").append(URLEncoder.encode(objectNameStr, "UTF-8")).append("\">MBean ").append(objectNameStr).append("</a>");
                buf.append("<hr>");
                buf.append("<pre>").append(result).append("</pre>");
                buf.append("<hr>");
                buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=mbean&serverName=").append(URLEncoder.encode(serverName, "UTF-8")).append("&index=").append(index).append("&name=").append(URLEncoder.encode(objectNameStr, "UTF-8")).append("\">MBean ").append(objectNameStr).append("</a>");
                buf.append("</body>");
                buf.append("</html>");
            }
        }
        finally {
            if (connector != null) {
                connector.close();
            }
        }
        resp.getWriter().println(buf.toString());
    }

    private String setAttributeValue(MBeanServerConnection mbeanServer, ObjectName objectName, String attributeName, String attributeType, String value) {
        try {
            Class type = Utility.convertStringToClass(attributeType);
            PropertyEditor editor = NimbusPropertyEditorManager.findEditor(type);
            Object attributeValue = null;
            if (editor == null) {
                return "Failed!! PropertyEditor " + type + " not found.";
            }
            if (value == null || value.equals("null")) {
                attributeValue = null;
            } else {
                editor.setAsText(value);
                attributeValue = editor.getValue();
            }
            mbeanServer.setAttribute(objectName, new Attribute(attributeName, attributeValue));
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            e.printStackTrace(writer);
            return sw.toString();
        }
        return "Success!!";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processGetAttributeResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        block23: {
            String serverName = req.getParameter("serverName");
            String indexStr = req.getParameter("index");
            int index = 1;
            if (indexStr != null) {
                index = Integer.parseInt(indexStr);
            }
            String objectNameStr = req.getParameter("name");
            ObjectName objectName = null;
            try {
                objectName = new ObjectName(objectNameStr);
            }
            catch (MalformedObjectNameException e) {
                throw new ServletException((Throwable)e);
            }
            String attributeName = req.getParameter("attribute");
            if (attributeName == null) {
                resp.sendError(400);
                return;
            }
            JMXConnector connector = null;
            try {
                MBeanServerConnection mbeanServer = null;
                if (serverName == null || "localhost".equals(serverName)) {
                    ArrayList<MBeanServer> mbeanServers;
                    if (serverName == null) {
                        serverName = "localhost";
                    }
                    if ((mbeanServers = MBeanServerFactory.findMBeanServer(null)) == null || mbeanServers.size() < index) {
                        resp.sendError(404);
                        return;
                    }
                    mbeanServer = (MBeanServer)mbeanServers.get(index - 1);
                } else {
                    ServiceNameEditor editor = new ServiceNameEditor();
                    editor.setAsText(serverName);
                    ServiceName serviceName = (ServiceName)editor.getValue();
                    MBeanServerConnectionFactory factory = (MBeanServerConnectionFactory)this.mbeanServerConnectionFactories.get(serviceName);
                    if (factory == null) {
                        resp.sendError(404);
                        return;
                    }
                    try {
                        connector = factory.getJMXConnector();
                        connector.connect();
                        mbeanServer = connector.getMBeanServerConnection();
                    }
                    catch (MBeanServerConnectionFactoryException e) {
                        throw new ServletException((Throwable)e);
                    }
                }
                Object attribute = null;
                try {
                    attribute = mbeanServer.getAttribute(objectName, attributeName);
                }
                catch (MBeanException e) {
                    throw new ServletException((Throwable)e);
                }
                catch (AttributeNotFoundException e) {
                    throw new ServletException((Throwable)e);
                }
                catch (InstanceNotFoundException e) {
                    throw new ServletException((Throwable)e);
                }
                catch (ReflectionException e) {
                    throw new ServletException((Throwable)e);
                }
                StringBuffer buf = new StringBuffer();
                if ("json".equals(responseType)) {
                    resp.setContentType("application/json;charset=UTF-8");
                    HashMap<String, Object> json = new HashMap<String, Object>();
                    json.put("value", attribute);
                    buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(json)));
                    resp.getWriter().println(buf.toString());
                    break block23;
                }
                resp.sendError(404);
                return;
            }
            finally {
                if (connector != null) {
                    connector.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processOperationResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        Object[] params;
        String serverName = req.getParameter("serverName");
        String indexStr = req.getParameter("index");
        int index = 1;
        if (indexStr != null) {
            index = Integer.parseInt(indexStr);
        }
        String objectNameStr = req.getParameter("name");
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(objectNameStr);
        }
        catch (MalformedObjectNameException e) {
            throw new ServletException((Throwable)e);
        }
        String operation = req.getParameter("operation");
        if (operation == null) {
            resp.sendError(400);
            return;
        }
        int startIndex = operation.indexOf(40);
        String operationName = null;
        String[] signature = null;
        if (startIndex == -1) {
            operationName = operation;
        } else {
            operationName = operation.substring(0, startIndex);
            if (operation.charAt(operation.length() - 1) != ')') {
                resp.sendError(400);
                return;
            }
            String params2 = operation.substring(startIndex + 1, operation.length() - 1).trim();
            if (params2.length() != 0) {
                signature = params2.split(",");
                for (int i = 0; i < signature.length; ++i) {
                    signature[i] = signature[i].trim();
                }
            }
        }
        String[] argsStr = req.getParameterValues("args");
        String[] argTypesStr = req.getParameterValues("argTypes");
        if (signature != null && (argsStr == null || argsStr.length != signature.length || argTypesStr != null && argTypesStr.length != signature.length)) {
            resp.sendError(400);
            return;
        }
        Object[] objectArray = params = signature == null ? null : new Object[signature.length];
        if (params != null) {
            for (int i = 0; i < signature.length; ++i) {
                Class editType = null;
                try {
                    editType = Utility.convertStringToClass(signature[i]);
                }
                catch (ClassNotFoundException e) {
                    throw new ServletException((Throwable)e);
                }
                if (argTypesStr != null && argTypesStr[i] != null && argTypesStr[i].length() != 0) {
                    try {
                        editType = Utility.convertStringToClass(argTypesStr[i]);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (argsStr[i] == null || argsStr[i].equals("null")) {
                    params[i] = null;
                    continue;
                }
                PropertyEditor propEditor = NimbusPropertyEditorManager.findEditor(editType);
                if (propEditor == null) {
                    if (editType.equals(Object.class)) {
                        params[i] = argsStr[i];
                        continue;
                    }
                    throw new IllegalArgumentException("PropertyEditor for " + editType + " not found.");
                }
                propEditor.setAsText(argsStr[i]);
                params[i] = propEditor.getValue();
            }
        }
        StringBuffer buf = new StringBuffer();
        JMXConnector connector = null;
        try {
            MBeanServerConnection mbeanServer = null;
            if (serverName == null || "localhost".equals(serverName)) {
                ArrayList<MBeanServer> mbeanServers;
                if (serverName == null) {
                    serverName = "localhost";
                }
                if ((mbeanServers = MBeanServerFactory.findMBeanServer(null)) == null || mbeanServers.size() < index) {
                    resp.sendError(404);
                    return;
                }
                mbeanServer = (MBeanServer)mbeanServers.get(index - 1);
            } else {
                ServiceNameEditor editor = new ServiceNameEditor();
                editor.setAsText(serverName);
                ServiceName serviceName = (ServiceName)editor.getValue();
                MBeanServerConnectionFactory factory = (MBeanServerConnectionFactory)this.mbeanServerConnectionFactories.get(serviceName);
                if (factory == null) {
                    resp.sendError(404);
                    return;
                }
                try {
                    connector = factory.getJMXConnector();
                    connector.connect();
                    mbeanServer = connector.getMBeanServerConnection();
                }
                catch (MBeanServerConnectionFactoryException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            Object result = null;
            Class returnType = Object.class;
            try {
                result = mbeanServer.invoke(objectName, operationName, params, signature);
                if (result != null) {
                    returnType = result.getClass();
                }
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter writer = new PrintWriter(sw);
                e.printStackTrace(writer);
                result = sw.toString();
            }
            if ("json".equals(responseType)) {
                resp.setContentType("application/json;charset=UTF-8");
                HashMap<String, Object> json = new HashMap<String, Object>();
                json.put("result", result);
                buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(json)));
            } else {
                resp.setContentType("text/html;charset=UTF-8");
                buf.append("<html>");
                buf.append("<head><title>JMX Operation Result</title></head>");
                buf.append("<body>");
                buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=mbean&serverName=").append(URLEncoder.encode(serverName, "UTF-8")).append("&index=").append(index).append("&name=").append(URLEncoder.encode(objectNameStr, "UTF-8")).append("\">MBean ").append(objectNameStr).append("</a>");
                buf.append("<hr>");
                buf.append(this.formatValue(false, returnType, result, true));
                buf.append("<hr>");
                buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=mbean&serverName=").append(URLEncoder.encode(serverName, "UTF-8")).append("&index=").append(index).append("&name=").append(URLEncoder.encode(objectNameStr, "UTF-8")).append("\">MBean ").append(objectNameStr).append("</a>");
                buf.append("</body>");
                buf.append("</html>");
            }
        }
        finally {
            if (connector != null) {
                connector.close();
            }
        }
        resp.getWriter().println(buf.toString());
    }
}

