/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.beans.dataset.DataSetException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.io.CSVWriter;
import jp.ossc.nimbus.util.converter.BindingStreamConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StreamStringConverter;

public class RecordCSVConverter
implements BindingStreamConverter,
StreamStringConverter,
Cloneable {
    public static final int RECORD_TO_CSV = 1;
    public static final int CSV_TO_RECORD = 2;
    protected int convertType;
    protected String characterEncodingToStream;
    protected String characterEncodingToObject;
    protected boolean isExistsSchema;
    protected boolean isExistsHeader;
    protected boolean isIgnoreUnknownProperty;
    protected char separator = (char)44;
    protected char separatorEscape = (char)92;
    protected char enclosure = (char)34;
    protected boolean isEnclose;
    protected String lineSeparator = CSVWriter.DEFAULT_LINE_SEPARATOR;
    protected String nullValue;
    protected boolean isIgnoreEmptyLine;
    protected boolean isIgnoreLineEndSeparator;
    protected CSVReader csvReader;
    protected CSVWriter csvWriter;

    public RecordCSVConverter() {
        this(1);
    }

    public RecordCSVConverter(int type) {
        this.convertType = type;
    }

    @Override
    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    @Override
    public void setCharacterEncodingToStream(String encoding) {
        this.characterEncodingToStream = encoding;
    }

    @Override
    public String getCharacterEncodingToStream() {
        return this.characterEncodingToStream;
    }

    @Override
    public void setCharacterEncodingToObject(String encoding) {
        this.characterEncodingToObject = encoding;
    }

    @Override
    public String getCharacterEncodingToObject() {
        return this.characterEncodingToObject;
    }

    @Override
    public StreamStringConverter cloneCharacterEncodingToStream(String encoding) {
        if (encoding == null && this.characterEncodingToStream == null || encoding != null && encoding.equals(this.characterEncodingToStream)) {
            return this;
        }
        try {
            StreamStringConverter clone = (StreamStringConverter)super.clone();
            clone.setCharacterEncodingToStream(encoding);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public StreamStringConverter cloneCharacterEncodingToObject(String encoding) {
        if (encoding == null && this.characterEncodingToObject == null || encoding != null && encoding.equals(this.characterEncodingToObject)) {
            return this;
        }
        try {
            StreamStringConverter clone = (StreamStringConverter)super.clone();
            clone.setCharacterEncodingToObject(encoding);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setExistsSchema(boolean isExists) {
        this.isExistsSchema = isExists;
    }

    public boolean isExistsSchema() {
        return this.isExistsSchema;
    }

    public void setExistsHeader(boolean isExists) {
        this.isExistsHeader = isExists;
    }

    public boolean isExistsHeader() {
        return this.isExistsHeader;
    }

    public void setIgnoreUnknownProperty(boolean isIgnore) {
        this.isIgnoreUnknownProperty = isIgnore;
    }

    public boolean isIgnoreUnknownProperty() {
        return this.isIgnoreUnknownProperty;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparatorEscape(char escape) {
        this.separatorEscape = escape;
    }

    public char getSeparatorEscape() {
        return this.separatorEscape;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setEnclosure(char enclosure) {
        this.enclosure = enclosure;
    }

    public char getEnclosure() {
        return this.enclosure;
    }

    public void setEnclose(boolean isEnclose) {
        this.isEnclose = isEnclose;
    }

    public boolean isEnclose() {
        return this.isEnclose;
    }

    public void setNullValue(String value) {
        this.nullValue = value;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public void setIgnoreEmptyLine(boolean isIgnore) {
        this.isIgnoreEmptyLine = isIgnore;
    }

    public boolean isIgnoreEmptyLine() {
        return this.isIgnoreEmptyLine;
    }

    public void setIgnoreLineEndSeparator(boolean isIgnore) {
        this.isIgnoreLineEndSeparator = isIgnore;
    }

    public boolean isIgnoreLineEndSeparator() {
        return this.isIgnoreLineEndSeparator;
    }

    public void setCSVReader(CSVReader reader) {
        this.csvReader = reader;
    }

    public void setCSVWriter(CSVWriter writer) {
        this.csvWriter = writer;
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: {
                return this.convertToStream(obj);
            }
            case 2: {
                if (obj instanceof File) {
                    return this.toRecord((File)obj);
                }
                if (obj instanceof InputStream) {
                    return this.toRecord((InputStream)obj);
                }
                throw new ConvertException("Invalid input type : " + obj.getClass());
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    @Override
    public InputStream convertToStream(Object obj) throws ConvertException {
        if (!(obj instanceof Record)) {
            throw new ConvertException("Input is not Record." + obj);
        }
        Record record = (Record)obj;
        RecordSchema schema = record.getRecordSchema();
        if (schema == null) {
            throw new ConvertException("Schema is null." + record);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int i;
            int imax;
            OutputStreamWriter osw = null;
            osw = this.characterEncodingToStream == null ? new OutputStreamWriter(baos) : new OutputStreamWriter((OutputStream)baos, this.characterEncodingToStream);
            CSVWriter writer = this.csvWriter == null ? new CSVWriter() : this.csvWriter.cloneWriter();
            writer.setWriter(osw);
            if (this.csvWriter == null) {
                writer.setSeparator(this.separator);
                writer.setSeparatorEscape(this.separatorEscape);
                writer.setEnclosure(this.enclosure);
                writer.setEnclose(this.isEnclose);
                writer.setLineSeparator(this.lineSeparator);
                writer.setNullValue(this.nullValue);
            }
            if (this.isExistsSchema) {
                writer.writeElement(schema.getSchema());
                writer.newLine();
            } else if (this.isExistsHeader) {
                imax = schema.getPropertySize();
                for (i = 0; i < imax; ++i) {
                    writer.writeElement(schema.getPropertyName(i));
                }
                writer.newLine();
            }
            imax = schema.getPropertySize();
            for (i = 0; i < imax; ++i) {
                writer.writeElement(record.getFormatProperty(i));
            }
            writer.close();
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        catch (DataSetException e) {
            throw new ConvertException(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    @Override
    public Object convertToObject(InputStream is) throws ConvertException {
        return this.toRecord(is);
    }

    protected Record toRecord(File file) throws ConvertException {
        try {
            return this.toRecord(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    protected Record toRecord(InputStream is) throws ConvertException {
        return this.toRecord(is, null);
    }

    protected Record toRecord(InputStream is, Record record) throws ConvertException {
        try {
            InputStreamReader isr = null;
            isr = this.characterEncodingToObject == null ? new InputStreamReader(is) : new InputStreamReader(is, this.characterEncodingToObject);
            CSVReader reader = this.csvReader == null ? new CSVReader() : this.csvReader.cloneReader();
            reader.setReader(isr);
            if (this.csvReader == null) {
                reader.setSeparator(this.separator);
                reader.setSeparatorEscape(this.separatorEscape);
                reader.setEnclosure(this.enclosure);
                reader.setIgnoreEmptyLine(this.isIgnoreEmptyLine);
                reader.setIgnoreLineEndSeparator(this.isIgnoreLineEndSeparator);
                reader.setEnclosed(this.isEnclose);
                reader.setNullValue(this.nullValue);
            }
            if (record == null) {
                record = new Record();
            }
            RecordSchema schema = record.getRecordSchema();
            List csv = new ArrayList();
            ArrayList<String> propertyNames = new ArrayList<String>();
            if (this.isExistsSchema) {
                if ((csv = reader.readCSVLineList(csv)) == null) {
                    return record;
                }
                if (csv.size() != 0) {
                    if (schema == null) {
                        record.setSchema((String)csv.get(0));
                        schema = record.getRecordSchema();
                    } else {
                        schema = RecordSchema.getInstance((String)csv.get(0));
                    }
                }
            } else if (schema == null || this.isExistsHeader) {
                int i;
                if ((csv = reader.readCSVLineList(csv)) == null) {
                    return record;
                }
                StringBuffer schemaBuf = new StringBuffer();
                int imax = csv.size();
                for (i = 0; i < imax; ++i) {
                    schemaBuf.append(':');
                    if (this.isExistsHeader) {
                        schemaBuf.append(csv.get(i));
                    } else {
                        schemaBuf.append(i);
                    }
                    schemaBuf.append(',');
                    schemaBuf.append(String.class.getName());
                    if (i == imax - 1) continue;
                    schemaBuf.append('\n');
                }
                if (schema == null) {
                    record.setSchema(schemaBuf.toString());
                    schema = record.getRecordSchema();
                } else if (this.isExistsHeader) {
                    schema = RecordSchema.getInstance(schemaBuf.toString());
                }
                if (!this.isExistsHeader) {
                    imax = csv.size();
                    for (i = 0; i < imax; ++i) {
                        record.setProperty(i, csv.get(i));
                    }
                    return record;
                }
            }
            int imax = schema.getPropertySize();
            for (int i = 0; i < imax; ++i) {
                propertyNames.add(schema.getPropertyName(i));
            }
            RecordSchema targetSchema = record.getRecordSchema();
            if ((csv = reader.readCSVLineList(csv)) != null) {
                int size = csv.size();
                int imax2 = propertyNames.size();
                for (int i = 0; i < imax2; ++i) {
                    String name;
                    if (i >= size || targetSchema.getPropertyIndex(name = (String)propertyNames.get(i)) == -1 && this.isIgnoreUnknownProperty) continue;
                    record.setParseProperty(name, csv.get(i));
                }
            }
            reader.close();
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        catch (DataSetException e) {
            throw new ConvertException(e);
        }
        return record;
    }

    @Override
    public Object convertToObject(InputStream is, Object returnType) throws ConvertException {
        if (returnType != null && !(returnType instanceof Record)) {
            throw new ConvertException("ReturnType is not Record." + returnType);
        }
        return this.toRecord(is, (Record)returnType);
    }
}

