/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.Serializable;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.ReversibleConverter;

public class SQLDateConverter
implements ReversibleConverter,
Serializable {
    private static final long serialVersionUID = -3345638749436216905L;
    public static final int DATE_TO_SQL_DATE = 1;
    public static final int DATE_TO_SQL_TIME = 2;
    public static final int DATE_TO_SQL_TIMESTAMP = 3;
    public static final int SQL_DATE_TO_DATE = -1;
    public static final int SQL_TIME_TO_DATE = -2;
    public static final int SQL_TIMESTAMP_TO_DATE = -3;
    protected int convertType;

    @Override
    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        Date fromDate = null;
        switch (this.convertType) {
            case 1: {
                fromDate = (Date)obj;
                return new java.sql.Date(fromDate.getTime());
            }
            case 2: {
                fromDate = (Date)obj;
                return new Time(fromDate.getTime());
            }
            case 3: {
                fromDate = (Date)obj;
                return new Timestamp(fromDate.getTime());
            }
            case -1: {
                java.sql.Date fromSQLDate = (java.sql.Date)obj;
                return new Date(fromSQLDate.getTime());
            }
            case -2: {
                Time fromSQLTime = (Time)obj;
                return new Date(fromSQLTime.getTime());
            }
            case -3: {
                Timestamp fromSQLTimestamp = (Timestamp)obj;
                return new Date(fromSQLTimestamp.getTime());
            }
        }
        throw new ConvertException("Unknown convert type : " + this.convertType);
    }
}

