/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.net;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.rmi.server.RMIServerSocketFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.util.net.ServerSocket;

public class ServerSocketFactory
extends javax.net.ServerSocketFactory
implements RMIServerSocketFactory {
    protected Map serverSocketProperties;
    protected Map socketProperties;

    public static javax.net.ServerSocketFactory getDefault() {
        return new ServerSocketFactory();
    }

    @Override
    public java.net.ServerSocket createServerSocket() throws IOException {
        return this.applyServerSocketProperties(new ServerSocket());
    }

    @Override
    public java.net.ServerSocket createServerSocket(int port) throws IOException {
        return this.applyServerSocketProperties(new ServerSocket(port));
    }

    @Override
    public java.net.ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.applyServerSocketProperties(new ServerSocket(port, backlog));
    }

    @Override
    public java.net.ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        return this.applyServerSocketProperties(new ServerSocket(port, backlog, bindAddr));
    }

    public void setServerSocketProperties(Map props) {
        if (props == null || props.size() == 0) {
            if (this.serverSocketProperties != null) {
                this.serverSocketProperties = null;
            }
            return;
        }
        for (String name : props.keySet()) {
            this.setServerSocketProperty(name, props.get(name));
        }
    }

    public void setServerSocketProperty(String name, Object value) {
        if (this.serverSocketProperties == null) {
            this.serverSocketProperties = new LinkedHashMap();
        }
        Property prop = PropertyFactory.createProperty(name);
        this.serverSocketProperties.put(prop, value);
    }

    public Object getServerSocketProperty(String name) {
        if (this.serverSocketProperties == null) {
            return null;
        }
        for (Property prop : this.serverSocketProperties.keySet()) {
            if (!prop.getPropertyName().equals(name)) continue;
            return this.serverSocketProperties.get(prop);
        }
        return null;
    }

    public void setSocketProperties(Map props) {
        if (props == null || props.size() == 0) {
            if (this.socketProperties != null) {
                this.socketProperties = null;
            }
            return;
        }
        for (String name : props.keySet()) {
            this.setSocketProperty(name, props.get(name));
        }
    }

    public void setSocketProperty(String name, Object value) {
        if (this.socketProperties == null) {
            this.socketProperties = new LinkedHashMap();
        }
        this.socketProperties.put(name, value);
    }

    public Object getSocketProperty(String name) {
        if (this.socketProperties == null) {
            return null;
        }
        return this.socketProperties.get(name);
    }

    public java.net.ServerSocket applyServerSocketProperties(java.net.ServerSocket serverSocket) throws IOException {
        try {
            if (serverSocket instanceof ServerSocket && this.socketProperties != null && this.socketProperties.size() != 0) {
                for (String name : this.socketProperties.keySet()) {
                    ((ServerSocket)serverSocket).setSocketProperty(name, this.socketProperties.get(name));
                }
            }
            if (this.serverSocketProperties != null && this.serverSocketProperties.size() != 0) {
                for (Property prop : this.serverSocketProperties.keySet()) {
                    prop.setProperty(serverSocket, this.serverSocketProperties.get(prop));
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new UndeclaredThrowableException(target);
        }
        catch (NoSuchPropertyException e) {
            throw new UndeclaredThrowableException(e);
        }
        return serverSocket;
    }
}

