/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.net;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;

public class SocketFactory
extends javax.net.SocketFactory
implements Externalizable,
RMIClientSocketFactory {
    public static final String DEFAULT_HOST_PROPERTY_NAME = SocketFactory.class.getName() + ".host";
    public static final String DEFAULT_LOCAL_HOST_PROPERTY_NAME = SocketFactory.class.getName() + ".localHost";
    protected javax.net.SocketFactory socketFactory;
    protected Map socketProperties;
    protected String hostPropertyName = DEFAULT_HOST_PROPERTY_NAME;
    protected String localHostPropertyName = DEFAULT_LOCAL_HOST_PROPERTY_NAME;
    protected int connectionTimeout;

    public static javax.net.SocketFactory getDefault() {
        return new SocketFactory();
    }

    protected String getHost(String host) {
        String replaceHost = System.getProperty(this.hostPropertyName + "." + host);
        return replaceHost == null ? host : replaceHost;
    }

    protected InetAddress getHostAddress(InetAddress host) {
        String replaceHost = System.getProperty(this.hostPropertyName + "." + host.getHostAddress());
        if (replaceHost == null) {
            replaceHost = System.getProperty(this.hostPropertyName + "." + host.getHostName());
        }
        try {
            return replaceHost == null ? host : InetAddress.getByName(replaceHost);
        }
        catch (UnknownHostException e) {
            return host;
        }
    }

    protected String getLocalHost(String host) {
        String replaceHost = System.getProperty(this.localHostPropertyName);
        return replaceHost == null ? host : replaceHost;
    }

    protected InetAddress getLocalHostAddress(InetAddress host) {
        String replaceHost = System.getProperty(this.localHostPropertyName);
        try {
            return replaceHost == null ? host : InetAddress.getByName(replaceHost);
        }
        catch (UnknownHostException e) {
            return host;
        }
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = null;
        socket = this.socketFactory == null ? new Socket() : this.socketFactory.createSocket();
        return this.applySocketProperties(socket);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        InetAddress localHost = this.getLocalHostAddress(null);
        if (localHost != null) {
            socket.bind(new InetSocketAddress(localHost, 0));
        }
        if (this.connectionTimeout > 0) {
            socket.connect(new InetSocketAddress(this.getHost(host), port), this.connectionTimeout);
        } else {
            socket.connect(new InetSocketAddress(this.getHost(host), port));
        }
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        InetAddress localHost = this.getLocalHostAddress(localAddress);
        if (localHost != null) {
            socket.bind(new InetSocketAddress(localHost, localPort));
        }
        if (this.connectionTimeout > 0) {
            socket.connect(new InetSocketAddress(this.getHost(host), port), this.connectionTimeout);
        } else {
            socket.connect(new InetSocketAddress(this.getHost(host), port));
        }
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.createSocket();
        InetAddress localHost = this.getLocalHostAddress(null);
        if (localHost != null) {
            socket.bind(new InetSocketAddress(localHost, 0));
        }
        if (this.connectionTimeout > 0) {
            socket.connect(new InetSocketAddress(this.getHostAddress(host), port), this.connectionTimeout);
        } else {
            socket.connect(new InetSocketAddress(this.getHostAddress(host), port));
        }
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.createSocket();
        InetAddress localHost = this.getLocalHostAddress(localAddress);
        if (localHost != null) {
            socket.bind(new InetSocketAddress(localHost, localPort));
        }
        if (this.connectionTimeout > 0) {
            socket.connect(new InetSocketAddress(address, port), this.connectionTimeout);
        } else {
            socket.connect(new InetSocketAddress(address, port));
        }
        return socket;
    }

    public void setHostPropertyName(String name) {
        this.hostPropertyName = name;
    }

    public String getHostPropertyName() {
        return this.hostPropertyName;
    }

    public void setLocalHostPropertyName(String name) {
        this.localHostPropertyName = name;
    }

    public String getLocalHostPropertyName() {
        return this.localHostPropertyName;
    }

    public void setSocketFactory(javax.net.SocketFactory factory) {
        this.socketFactory = factory;
    }

    public void setSocketProperties(Map props) {
        if (props == null || props.size() == 0) {
            if (this.socketProperties != null) {
                this.socketProperties = null;
            }
            return;
        }
        for (String name : props.keySet()) {
            this.setSocketProperty(name, props.get(name));
        }
    }

    public void setSocketProperty(String name, Object value) {
        if (this.socketProperties == null) {
            this.socketProperties = new LinkedHashMap();
        }
        Property prop = PropertyFactory.createProperty(name);
        this.socketProperties.put(prop, value);
    }

    public Object getSocketProperty(String name) {
        if (this.socketProperties == null) {
            return null;
        }
        for (Property prop : this.socketProperties.keySet()) {
            if (!prop.getPropertyName().equals(name)) continue;
            return this.socketProperties.get(prop);
        }
        return null;
    }

    public void setConnectionTimeout(int millisecond) {
        this.connectionTimeout = millisecond;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Socket applySocketProperties(Socket socket) throws IOException {
        try {
            if (this.socketProperties != null && this.socketProperties.size() != 0) {
                for (Property prop : this.socketProperties.keySet()) {
                    prop.setProperty(socket, this.socketProperties.get(prop));
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new UndeclaredThrowableException(target);
        }
        catch (NoSuchPropertyException e) {
            throw new UndeclaredThrowableException(e);
        }
        return socket;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.socketProperties);
        out.writeObject(this.socketFactory);
        out.writeObject(DEFAULT_HOST_PROPERTY_NAME.equals(this.hostPropertyName) ? null : this.hostPropertyName);
        out.writeObject(DEFAULT_LOCAL_HOST_PROPERTY_NAME.equals(this.localHostPropertyName) ? null : this.localHostPropertyName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.socketProperties = (Map)in.readObject();
        this.socketFactory = (javax.net.SocketFactory)in.readObject();
        this.hostPropertyName = (String)in.readObject();
        if (this.hostPropertyName == null) {
            this.hostPropertyName = DEFAULT_HOST_PROPERTY_NAME;
        }
        this.localHostPropertyName = (String)in.readObject();
        if (this.localHostPropertyName == null) {
            this.localHostPropertyName = DEFAULT_LOCAL_HOST_PROPERTY_NAME;
        }
    }
}

