
import jp.ossc.nimbus.util.converter.Converters;
import jp.ossc.nimbus.util.converter.Converter;
import jp.ossc.nimbus.util.converter.ReversibleConverter;

/**
 * TvPsNXB
 */
public class Main{
    
    public static final void main(String[] args){
        final Object input = "aA`1PA+{";
        Object output = null;
        Converter converter = null;
        
        // ppSppRo[^擾
        System.out.println("ppSppϊ");
        converter = Converters.getAlphabetHankakuFromZenkakuStringConverter();
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // SppppRo[^擾
        System.out.println("Spppp");
        converter = Converters.getAlphabetZenkakuFromHankakuStringConverter();
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // pJ^JiSpJ^JiRo[^擾
        System.out.println("pJ^JiSpJ^Ji");
        converter = Converters.getKatakanaHankakuFromZenkakuStringConverter();
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // SpJ^JipJ^JiRo[^擾
        System.out.println("SpJ^JipJ^Ji");
        converter = Converters.getKatakanaZenkakuFromHankakuStringConverter();
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // pSpRo[^擾
        System.out.println("pSp");
        converter = Converters.getNumberHankakuFromZenkakuStringConverter();
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // SppRo[^擾
        System.out.println("Spp");
        converter = Converters.getNumberZenkakuFromHankakuStringConverter();
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // pLSpLRo[^擾
        System.out.println("pLSpL");
        converter = Converters.getSymbolHankakuFromZenkakuStringConverter();
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // SpLpLRo[^擾
        System.out.println("SpLpL");
        converter = Converters.getSymbolZenkakuFromHankakuStringConverter();
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // SpJ^JiSpЂ炪ȃRo[^擾
        System.out.println("SpJ^JiSpЂ炪");
        converter = Converters.getKatakanaFromHiraganaStringConverter();
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // SpЂ炪ȁSpJ^JiRo[^擾
        System.out.println("SpЂ炪ȁSpJ^Ji");
        converter = Converters.getHiraganaFromKatakanaStringConverter();
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // pSpRo[^擾
        System.out.println("pSp");
        converter = Converters.getHankakuFromZenkakuStringConverter();
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // SppRo[^擾
        System.out.println("Spp");
        converter = Converters.getZenkakuFromHankakuStringConverter();
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // ƎRo[^擾
        System.out.println("Ђ炪ȁ[}");
        converter = Converters.newCustomStringConverter(
            ReversibleConverter.POSITIVE_CONVERT,
            new String[]{"", "", "", "", ""},
            new String[]{"a", "i", "u", "e", "o"}
        );
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // ARo[^擾
        System.out.println("Spppp");
        converter = Converters.newCustomConverter(
            new Converter[]{
                Converters.getNumberZenkakuFromHankakuStringConverter(),
                Converters.getAlphabetZenkakuFromHankakuStringConverter()
            }
        );
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
        
        // K\Ro[^擾
        System.out.println("K\\"a.*\"B");
        converter = Converters.patternStringConverter(
            0,
            new String[]{"a.*",},
            new String[]{"B"}
        );
        output = converter.convert(input);
        System.out.println(" =" + input);
        System.out.println(" o=" + output);
        System.out.println();
    }
}