/*!
 *   a2BCbbsTableTrim
 * 
 *   F
 *       a2Bgbbstable.htmlɁua2BCvJeSAURLǉ
 * 
 *      a2BCJeSɒǉURĹA45őƂA𒴂ꍇɂ́A
 *       (a2BC-XXAXXCNg)̃JeSɒǉB
 *       (̋EĺAmaxBbsDatasInCategoryŐݒ肷B)
 * 
 *      {NXŉHs̖ɂ́A"<!--a2BC-->" ƂǉB
 * 
 */
#include <QFile>
#include <QTextStream>
#include <QTextCodec>
#include <QTextCodecPlugin>
#include <QMessageBox>
#include "a2BCbbsTableTrim.h"
#include "a2BcConstants.h"

/*!
 *  RXgN^
 * 
 */
a2BCbbsTableTrim::a2BCbbsTableTrim(QWidget *parent) : QWidget(parent)
{
    // ɉȂ
}

/*!
 *  fXgN^
 * 
 */
a2BCbbsTableTrim::~a2BCbbsTableTrim()
{
    // ɉȂ
}

/*!
 *  f[^̃Zbg
 * 
 */
void a2BCbbsTableTrim::reset()
{
    // ǉf[^
    mBbsTableAppend.clear();
}

/*!
 *  ꗗf[^̉H
 *    (true : OKA false : s)
 */
bool a2BCbbsTableTrim::prepare(QString &arFileName)
{
    mBbsTableFileName = "";
    if (QFile::exists(arFileName) != true)
    {
        // t@C݂ȂꍇAG[
        return (false);
    }

    mBbsTableFileName = arFileName;

    QFile bbsTableFile(arFileName);
    if (!bbsTableFile.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        // t@C̃I[vsAAAI
        return (false);
    }

    // HOt@Cɂꍇ폜
    if (QFile::exists(arFileName + ".back") == true)
    {
        if (QFile::remove(arFileName + ".back") == false)
        {
            // HOt@Cs...I
            bbsTableFile.close();
            return (false);
        }
    }

    // HOt@C̃I[v
    QFile bbsTableBakFile(arFileName + ".back");
    if (!bbsTableBakFile.open(QIODevice::WriteOnly | QIODevice::Text))
    {
        bbsTableFile.close();
        return (false);
    }

    // a2BCHs𔲂sHOt@Cɏo͂
    QTextStream in(&bbsTableFile);
    QTextStream out(&bbsTableBakFile);
    while (!in.atEnd())
    {
        QString line = in.readLine();
        if (line.contains("<!--a2BC-->") != true)
        {
            // f[^o͂
            out << line << endl;
        }
    }
    bbsTableBakFile.close();
    bbsTableFile.close();

    return (true);
}

/*!
 *  bbstable.html̉HC
 * 
 */
bool a2BCbbsTableTrim::output(void)
{
    // HOt@C̃I[v
    QFile bbsTableBakFile(mBbsTableFileName + ".back");
    if (!bbsTableBakFile.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        return (false);
    }

    // o̓t@C̃I[v
    QFile bbsTableFile(mBbsTableFileName);
    if (!bbsTableFile.open(QIODevice::WriteOnly | QIODevice::Text))
    {
        bbsTableBakFile.close();
        return (false);
    }
 
    // eLXgXg[̏(eLXgR[fbN̐ݒs)
    QTextStream out(&bbsTableFile);
    QTextStream in(&bbsTableBakFile);
    QTextCodec *codec = setCodec(out);

    // a2BCJeSf[^̃t@Co
    outputA2BCcategory(out, codec);

    // HOf[^t@C̓eRs[
    out.setCodec(QTextCodec::codecForLocale());
    while (!in.atEnd())
    {
        QString line = in.readLine();
        if (line.contains("<!--a2BC-->") != true)
        {
            // ǂݍ񂾂̂̂܂܃f[^o͂
            out << line << endl;
        }
    }
    bbsTableBakFile.close();
    bbsTableFile.close();
    
    // HOt@C̍폜
    QFile::remove(mBbsTableFileName + ".back");
    return (true);
}

/*!
 *  f[^̒ǉ
 * 
 */
void a2BCbbsTableTrim::append(QByteArray &arData)
{
    mBbsTableAppend.append(arData);
    return;
}

/*!
 *   codec̏...
 * 
 */
QTextCodec *a2BCbbsTableTrim::setCodec(QTextStream &arOutputStream)
{
    // codecNX܂...
    QTextCodec  *codec = QTextCodec::codecForName("Shift_JIS");
    if (codec == 0)
    {
        codec = QTextCodec::codecForName("MS_Kanji");
    }
    if (codec == 0)
    {
        codec = QTextCodec::codecForName("sjis");
    }
    if (codec == 0)
    {
        codec = QTextCodec::codecForName("SJIS");
    }

    // ostreamɃR[fbNݒ肷B
    if (codec == 0)
    {
        arOutputStream.setCodec(QTextCodec::codecForLocale());
        return (0);
    }
    arOutputStream.setCodec(codec);
    return (codec);
}

/*!
 *   a2BCJeS̏o
 * 
 * 
 */
void a2BCbbsTableTrim::outputA2BCcategory(QTextStream &arOutputStream, QTextCodec *codec)
{
    // codec == 0̂Ƃɂ́Aa2BJeS͏o͂Ȃ悤ɂ
    if (codec == 0)
    {
        return;
    }

    // 1a2BCJeSɓ̍ől (̒l𒴂ƕ)
    int maxBbsDatasInCategory = 45;

    // O...
    arOutputStream << "<!--a2BC-->" << endl;

    // JeSf[^o͂̃C
    int count = 0;
    for (QVector<QByteArray>::ConstIterator it = mBbsTableAppend.begin(); it != mBbsTableAppend.end(); it++)
    {
        ///// ŃJeS (ya2B-xxz) o͂
        if ((count % maxBbsDatasInCategory) == 0)
        {
            arOutputStream << codec->toUnicode("y<B>a2B");

            // "-xx"̏o(Kvȏꍇɂ...
            if ((count / maxBbsDatasInCategory) != 0)
            {
                QString num;
                num.setNum(count / maxBbsDatasInCategory);
                arOutputStream << "-" << num;
            }
            arOutputStream << codec->toUnicode("</B>z") << "<!--a2BC-->" << endl;
        }

        // (URL)1o͂
        arOutputStream << "<A HREF=" << codec->toUnicode(*it) << "</A>" << "<!--a2BC-->" << endl;
        count++;
    }

    // ㏈...
    arOutputStream << codec->toUnicode("y<B>-----</B>z") << "<!--a2BC-->" << endl;
    arOutputStream << "<!--a2BC-->" << endl;
    
    return;
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
