/*============================================================================*
 *  FILE: 
 *     proto.h
 *
 *  Description: 
 *     Prototype definitions for NNsh.
 *
 *===========================================================================*/

/************************   MACROs   **************************************/
#define NUMCATI(buf,num)   StrIToA(&(buf)[StrLen((buf))], (num))
#define NUMCATH(buf,num)   StrIToH(&(buf)[StrLen((buf))], (num))

// ̈̃NA(|C^)
#define MEMFREE_PTR(ptr)        \
    if (ptr != NULL)            \
    {                           \
        MemPtrFree(ptr);        \
        ptr = NULL;             \
    }

// ̈̃NA(nh)
#define MEMFREE_HANDLE(handle)  \
    if (handle != 0)            \
    {                           \
        MemHandleFree(handle);  \
        handle = 0;             \
    }


/******************  FUNCTION PROTOTYPES  *********************************/

/*--------------------  Generic Functions  --------------------*/

/*** WINDOW MANAGE FUNCTIONS ***/
void NNsi_FrmDrawForm   (FormType *frm, Boolean redraw);
void NNsi_UpdateRectangle(RectangleType *dimF, UInt16 fontType, UInt16 *fontID, 
                          UInt16 *fontHeight, UInt16 *nlines);
void NNsi_HRSclUpdate   (ScrollBarType *barP);
void NNsi_HRFldDrawField(FieldType *fldP, UInt16 isBottom);

Boolean Handler_EditAction(EventType *event);
void NNshWinClearList(FormType *frm, UInt16 lstID);
void NNshWinSetListItems(FormType *frm, UInt16 lstID, Char *list, UInt16 cnt, UInt16 topItem, MemHandle *memH, Char **listP);
void NNshWinUpdateListItems(FormType *frm, UInt16 lstID, Char *ptr,
                            UInt16 cnt, UInt16 selItem);
void NNshWinSetPopItems(FormType *frm, UInt16 popId, UInt16 lstId, UInt16 item);
void NNshWinSetFieldText(FormType *frm, UInt16 fldID, Boolean redraw, Char *msg, UInt32 size);
void NNshWinGetFieldText(FormType *frm, UInt16 fldID, Char *area, UInt32 len);
void NNshWinViewUpdateScrollBar(UInt16 fldID, UInt16 sclID);
Boolean NNshWinViewPageScroll(UInt16 fldID, UInt16 sclID, 
                              UInt16 lines, WinDirectionType direction);
void NNsi_SetTitleColor(UInt16 status);
void NNsi_WinDrawList(UInt16 pointIndex, Char *titleIndex[], UInt16 listItems,
                      RectangleType *dimF, UInt16 height);
void NNsi_WinUpdateList(UInt16 pointIndex, UInt16 prevIndex,
                        Char *titleIndex[], UInt16 listItems,
                        RectangleType *dimF, UInt16 height);
void NNsi_RedrawThreadList(void);

/*** BUSY WINDOW MANAGE FUNCTIONS ***/
void SetMsg_BusyForm(Char *msg);
void Show_BusyForm  (Char *msg);
void Hide_BusyForm  (Boolean redraw);

/*** Common Menus ***/
Boolean NNsh_MenuEvt_Edit(EventType *event);

/*** JUMP SELECTION WINDOW ***/
UInt16 NNshWinSelectionWindow(Char *listItemP, UInt16 nofItems);

/*** MESSAGE DIALOGUE MANAGE FUNCTIONS ***/
void    NNsh_DebugMessage  (UInt16 altID, Char *mes1, Char *mes2, UInt32 num);
UInt16  NNsh_ErrorMessage  (UInt16 altID, Char *mes1, Char *mes2, UInt32 num);
UInt16  NNsh_ConfirmMessage(UInt16 altID, Char *mes1, Char *mes2, UInt32 num);
#define NNsh_InformMessage  NNsh_ConfirmMessage

/*** DATABASE ACCESSING FUNCTIONS ***/
void OpenDatabase_NNsh (Char *dbName, UInt16 chkVersion, DmOpenRef *dbRef);
void CloseDatabase_NNsh(DmOpenRef dbRef);
void QsortRecord_NNsh  (DmOpenRef dbRef, UInt16 keyType, UInt16 offset);
void IsortRecord_NNsh  (DmOpenRef dbRef, UInt16 keyType, UInt16 offset);
void GetDBCount_NNsh   (DmOpenRef dbRef, UInt16 *count);
Err  EntryRecord_NNsh  (DmOpenRef dbRef, UInt16 size,  void *recordData);
Err  GetRecord_NNsh    (DmOpenRef dbRef, UInt16 index, UInt16 size, void *matchedData);
Err GetRecordReadOnly_NNsh(DmOpenRef dbRef, UInt16 index,
                           MemHandle *dataH, void **record);
Err ReleaseRecordReadOnly_NNsh(DmOpenRef dbRef, MemHandle dataH);
Err  UpdateRecord_NNsh (DmOpenRef dbRef, UInt16 index, UInt16 size, void *updateData);
Err  IsExistRecord_NNsh(DmOpenRef dbRef, void *target, UInt16 keyType, UInt16 offset, UInt16 *index);
Err  SearchRecord_NNsh (DmOpenRef dbRef, void *target, UInt16 keyType, UInt16 offset, UInt16 size, void *matchedData, UInt16 *index);
Err  DeleteRecord_NNsh (DmOpenRef dbRef, void *target, UInt16 keyType, UInt16 offset);
Err  DeleteRecordIDX_NNsh(DmOpenRef dbRef, UInt16 index);
Boolean GetExistRecordList(DmOpenRef dbRef, Char *boardNick, MemHandle *listH, UInt16 *threadNum);

/*** FILE(FileStream/VFS) ACCESSING FUNCTIONS ***/
Err DeleteFile_NNsh (Char *fileName, UInt16 location);
Err CreateFile_NNsh (Char *fileName);
Err RenameFile_NNsh (Char *oldFileName, Char *newFileName);
Err CreateDir_NNsh  (Char *dirName);
Err CloseFile_NNsh  (NNshFileRef *fileRef);
Err CheckFileSpace_NNsh(UInt16 fileMode, UInt32 size);
Err CopyFile_NNsh   (Char *destFile, Char *sourceFile, UInt16 location);
Err OpenFile_NNsh   (Char *fileName, UInt16 fileMode, NNshFileRef *fileRef);
Err GetFileSize_NNsh(NNshFileRef *fileRef, UInt32 *fileSize);
Err ReadFile_NNsh   (NNshFileRef *fileRef, UInt32 offset, UInt32 size, void *ptr, UInt32 *readSize);
Err WriteFile_NNsh  (NNshFileRef *fileRef, UInt32 offset, UInt32 size, void *ptr, UInt32 *writeSize);
Err AppendFile_NNsh (NNshFileRef *fileRef, UInt32 size, void *ptr, UInt32 *writeSize);
Err AppendFileAsURLEncode_NNsh(NNshFileRef *fileRef, UInt32 size, void *ptr, UInt32 *writeSize);
Err BackupDatabaseToVFS_NNsh   (Char *dbName);
Err RestoreDatabaseFromVFS_NNsh(Char *dbName);

/*** NETWORK CONNECTION FUNCTIONS ***/
void NNshNet_LineHangup(void);
Err NNshNet_open (UInt16 *netRef);
Err NNshNet_close(UInt16 netRef);
Err NNshNet_connect(NetSocketRef *socketRef, UInt16 netRef, Char *hostName, UInt16 port);
Err NNshNet_disconnect(UInt16 netRef, NetSocketRef socketRef);
Err NNshNet_write(UInt16 netRef, NetSocketRef socketRef, UInt16 size, void *data);
Err NNshNet_read (UInt16 netRef, NetSocketRef socketRef, UInt16 size, void *data, UInt16 *readSize);

/*** HTTP COMMUNICATION FUNCTIONS ***/
Err NNshHttp_comm(UInt16 type, Char *url, Char *cookie, Char *appendData,
                  UInt32 range, UInt32 endRange, Char *message);
Err NNshHttp_commMain(UInt16 type, Char *url, Char *cookie, Char *appendData,
                      UInt32 range, UInt32 endRange, UInt16 port, Char *proxy,
                      Char *message);
Err WebBrowserCommand(UInt32 creator, UInt16 subLaunch, UInt16 flags,
                      UInt16 cmd, Char *parameterP, UInt32 *resultP);

/*--------------------  NNsh Related Functions  --------------------*/
Boolean GetBBSList(Char *url);
Err Get_BBS_Info(UInt16 selBBS, NNshBoardDatabase *bbsInfo);
Err Update_BBS_Info(UInt16 selBBS, NNshBoardDatabase *bbsInfo);
Err Update_BBS_Database(UInt16 index, NNshBoardDatabase *bbs);
Err Get_BBS_Database(Char *boardNick, NNshBoardDatabase *bbs, UInt16 *index);
Err Get_BBS_Database_NNsh(Char *nick, NNshBoardDatabase *bbs, UInt16 *index);

Err CreateMessageThreadIndex(NNshMessageIndex *index, UInt32 *nofMsg,
                             UInt32 *msgOffset, UInt16 bbsType);
Err Get_AllMessage (Char *url, Char *boardNick, Char *file, UInt16 idxMES,
                    UInt16 bbsType);
Err Get_PartMessage(Char *url, Char *boardNick, NNshSubjectDatabase *mesDB, 
                    UInt16 idxMES, Char *message);
Err MoveSubject_BBS(Char *dest, Char *src);
Err Get_Subject_Database(UInt16 index, NNshSubjectDatabase *subjDB);
Err Get_Subject_Database_NNsh(UInt16 index, NNshSubjectDatabase *subjDB);
Err create_offline_database(void);
Err Check_same_thread(UInt16 selMES, NNshSubjectDatabase *data,
                      NNshSubjectDatabase *matchedData, UInt16 *idx);
Err DeleteSubjectList(Char *boardNick, UInt16 delState, UInt16 *thrCnt);
void SortSubjectList(void);
Err NNsh_GetSubjectList(UInt16 index);

void MarkMessageIndex(UInt16 index, UInt16 favor);
Boolean Get_MessageFromMesNum(Boolean *updateBBS);

UInt16 convertListIndexToMsgIndex(UInt16 listIdx);
Err GetSubDirectoryName(UInt16 index, Char *dirName);
Boolean ConvertHanZen (UInt8 *dst, UInt8 *ptr);
Boolean ConvertJIStoSJ(UInt8 *dst, UInt8 *ptr);
Boolean ConvertSJtoJIS(UInt8 *dst, UInt8 *ptr);
Boolean ConvertEUCtoSJ(UInt8 *dst, UInt8 *ptr, UInt16 *copyByte);
Boolean ConvertSJtoEUC(UInt8 *dst, UInt8 *ptr, UInt16 *copyByte, UInt16 *parseByte);
void    StrCopyEUC(Char *dst, Char *src);

Err     SendToLocalMemopad(Char *title, Char *data);

Err OpenForm_NNshMessage(FormType *frm);

Err SetThreadInformation(Char *fileName,
                         UInt16 fileMode, NNshSubjectDatabase *subDB);

void SetControlValue(FormType *frm, UInt16 objID, UInt16 *value);
void UpdateParameter(FormType *frm, UInt16 objID, UInt16 *value);
Err  update_subject_database(UInt16 index, NNshSubjectDatabase *subjDB);

Err  NNshSilkMinimize(FormType *frm);
Err  NNshSilkMaximize(FormType *frm);
void HandEraMoveDialog(FormPtr frmP);
void HandEraResizeForm(FormPtr frmP);
void NNshRestoreNNsiSetting(Int16 version, UInt16 size, NNshSavedPref *prm);
void BackupDBtoVFS(UInt16 backupAllDB);
Err  RestoreDBtoVFS(Boolean forceRead);

Boolean Update_Thread_List(UInt16  bbsIdx, UInt16 selItem, UInt16 step);
void ClearMsgTitleInfo(void);

UInt16 KeyConvertFiveWayToJogChara(EventType *event);
Boolean DataInputDialog(Char *title, Char *area, UInt16 size, UInt16 usage, void *valueP);
void NNsi_EraseRectangle(RectangleType *dimF);
void UpdateFieldRegion(void);
