/*============================================================================*
 *  FILE: 
 *     msglist.c
 *
 *  Description: 
 *     Message(Thread) list drawings for NNsh. 
 *
 *===========================================================================*/
#define MSGLIST_C
#include "local.h"

/*-------------------------------------------------------------------------*/
/*   Function : checkDispList                                              */
/*                                         ʂɕ\/Ȃ𔻒肷 */
/*-------------------------------------------------------------------------*/
static Boolean checkDispList(UInt16 bbsIndex, NNshSubjectDatabase *subjP,
                             NNshBoardDatabase *bdP)
{
    // \/Ȃ̏(ɂďꍇ)
    switch (bbsIndex)
    { 
      case NNSH_SELBBS_GETALL:
        // 擾ςݑSĂ\
        if ((subjP->state == NNSH_SUBJSTATUS_NOT_YET)||
#ifdef USE_STRSTR
            (!(StrCompare(subjP->boardNick, OFFLINE_THREAD_NICK))))
#else
            ((NNshParam->notListReadOnly != 0)&&
             ((subjP->boardNick[0]  == '!')&&
              (subjP->boardNick[1]  == 'G'))))
#endif
        {
	    //  u擾v͎QƃOuQƃO͕\Ȃv
            // ꍇɂ͕\Ȃ
            return (false);
        }
        break;

      case NNSH_SELBBS_FAVORITE:
        // Cɓw\
        if ((subjP->msgAttribute & NNSH_MSGATTR_FAVOR) < NNshParam->displayFavorLevel)
        {
            // uCɓvł͂Ȃ̂ŕ\Ȃ
            return (false);
        }
        break;

      case NNSH_SELBBS_NOTREAD:
        // ǂ\
        if ((subjP->state != NNSH_SUBJSTATUS_NEW)&&
            (subjP->state != NNSH_SUBJSTATUS_UPDATE)&&
            (subjP->state != NNSH_SUBJSTATUS_REMAIN))
        {
	    // ǂXł͂Ȃ̂ŕ\Ȃ
	    return (false);
        }
        break;

      case NNSH_SELBBS_CUSTOM1:
        // [UݒP̏mF
        return (CheckIfCustomTabIsValid(bdP->boardNick, subjP, &(NNshParam->custom1))); 
        break;

      case NNSH_SELBBS_CUSTOM2:
        // [UݒQ̏mF
        return (CheckIfCustomTabIsValid(bdP->boardNick, subjP, &(NNshParam->custom2))); 
        break;

      default:
        // uCɓvłu擾ςݑSāvłuǂvłȂꍇ
        if (StrCompare(subjP->boardNick, bdP->boardNick) != 0)
        {
            // X̏Ⴄ̂ŕ\Ȃ
            return (false);
        }
        break;
    }

    // \XƔ
    return (true);
}                               

/*-------------------------------------------------------------------------*/
/*   Function : copyThreadTitleString                                      */
/*                                X^CgRs[(f[^ϊt) */
/*-------------------------------------------------------------------------*/
static void copyThreadTitleString(Char  *dest, Char *src, UInt16 length,
                                  UInt16 state, UInt16 msgNumber)
{
    UInt16 msgState;
    Char   *ptr, *dst;

    // G[ԂƂAbZ[W̐擪 '#'\
    dst = dest;
    if (((state >> 8)&(NNSH_MSGATTR_ERROR)) == NNSH_MSGATTR_ERROR)
    {
        *dst = '#';
        dst++;
    }

    // bZ[W̏ԂLŔf
    msgState = (state & 0xff);
    switch (msgState)
    {
      case NNSH_SUBJSTATUS_NEW:
        /** VK擾(Ď擾) **/
        *dst = '*';
        break;

      case NNSH_SUBJSTATUS_UPDATE:
        /** bZ[WXV **/
        *dst = '+';
        break;

      case NNSH_SUBJSTATUS_REMAIN:
        /** ǂ **/
        *dst = '-';
        break;

      case NNSH_SUBJSTATUS_ALREADY:
        /** bZ[WSǂ **/
        *dst = ':';
        break;

      case NNSH_SUBJSTATUS_NOT_YET:
      default:                
        /** bZ[W擾 **/
        *dst = ' ';
        break;
    }
    dst++;

    // bZ[W̃Rs[
    if (NNshParam->printNofMessage != 0)
    {
        if ((msgState != NNSH_SUBJSTATUS_NEW)&&
            (msgState != NNSH_SUBJSTATUS_UPDATE)&&
            (msgState != NNSH_SUBJSTATUS_UNKNOWN))
        {
            // 擾bZ[W\
            StrCat(dst, "[");
            (void) NUMCATI(dst, msgNumber);
            StrCat(dst, "]");
        }
        else
        {
            StrCat(dst, "[???]");
        }
    }
    dst = dest + StrLen(dest);

    // X^Cg̃Rs[
    ptr = src;
    while (dst < (dest + length))
    {
        if (*ptr == '\0')
        {
            break;
        }
        if (*ptr == '&')
	{
            // "&gt;"  '>' ɒu
            if ((*(ptr + 1) == 'g')&&(*(ptr + 2) == 't')&&
                (*(ptr + 3) == ';'))
            {
                *dst++ = '>';
                ptr = ptr + 4;   // StrLen(TAG_GT);
                continue;
            }
            // "&lt;"  '<' ɒu
            if ((*(ptr + 1) == 'l')&&(*(ptr + 2) == 't')&&
                (*(ptr + 3) == ';'))
            {
                *dst++ = '<';
                ptr = ptr + 4;   // StrLen(TAG_GT);
                continue;
            }
            // "&quot;"  '"' ɒu
            if ((*(ptr + 1) == 'q')&&(*(ptr + 2) == 'u')&&
                (*(ptr + 3) == 'o')&&(*(ptr + 4) == 't')&&
                (*(ptr + 5) == ';'))
            {
                *dst++ = '"';
                ptr = ptr + 6;    // StrLen(TAG_QUOT); 
                continue;
            }
            // "&nbsp;"  '    ' ɒu
            if ((*(ptr + 1) == 'n')&&(*(ptr + 2) == 'b')&&
                (*(ptr + 3) == 's')&&(*(ptr + 4) == 'p')&&
                (*(ptr + 5) == ';'))
            {
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                ptr = ptr + 6;    // StrLen(TAG_QUOT); 
                continue;
            }
            // "&amp;"  '&' ɒu
            if ((*(ptr + 1) == 'a')&&(*(ptr + 2) == 'm')&&
                (*(ptr + 3) == 'p')&&(*(ptr + 4) == ';'))
            {
                *dst++ = '&';
                ptr = ptr + 5;    // StrLen(TAG_AMP);
                continue;
            }
            // ͂肦Ȃ͂...ꉞB
            *dst++ = '&';
            ptr++;
            continue;
        }

        // pJiSpJiϊLȂƂ
        if (NNshParam->convertHanZen != 0)
        {
            if (((UInt8) *ptr >= 0x81)&&((UInt8) *ptr <= 0x9f))
            {
                // 2oCgƔ
                *dst++ = *ptr;
                ptr++;
                *dst++ = *ptr;
                ptr++;
                continue;
            }
            if (((UInt8) *ptr >= 0xe0)&&((UInt8) *ptr <= 0xef))
            {
                // 2oCgƔ
                *dst++ = *ptr;
                ptr++;
                *dst++ = *ptr;
                ptr++;
                continue;
            }
            if (ConvertHanZen((UInt8 *) dst, (UInt8 *) ptr) == true)
            {
                // pJiSpϊ
                dst = dst + 2;
                ptr++;
                continue;
            }
        }
        *dst = *ptr;
        ptr++;
        dst++;
    }
    *dst = '\0';
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : reverse_List_Order                                         */
/*                                            Xg\̏Ԃւ */
/*-------------------------------------------------------------------------*/
static void reverse_List_Order(UInt16 nofItems,     Char *buffer,
                               UInt16 *listIndex,   Char **titleIndex,
                               UInt16 *titleStatus, UInt16 *msgNumbers)
{
    UInt16 loop, tempIndex, tempTitleStatus, tempMsgNumbers;
    Char   *tempTitleIndex;

    //  Xg̕\CfbNXƃXg(R[hԍ)CfbNX
    // Ԃւ(])
    for (loop = 0; loop < (nofItems / 2) ; loop++)
    {
        tempIndex                         = listIndex [loop];
        tempTitleIndex                    = titleIndex[loop];
        tempTitleStatus                   = titleStatus[loop];
        tempMsgNumbers                    = msgNumbers[loop];

        listIndex  [loop]                 = listIndex [nofItems - (loop + 1)];
        titleIndex [loop]                 = titleIndex[nofItems - (loop + 1)];
        titleStatus[loop]                 = titleStatus[nofItems - (loop + 1)];
        msgNumbers [loop]                 = msgNumbers[nofItems - (loop + 1)];

        listIndex  [nofItems - (loop + 1)] = tempIndex;
        titleIndex [nofItems - (loop + 1)] = tempTitleIndex;
        titleStatus[nofItems - (loop + 1)] = tempTitleStatus;
        msgNumbers [nofItems - (loop + 1)] = tempMsgNumbers;
    }

    NNshGlobal->nofTitleItems = nofItems;
    return;
}

/*=========================================================================*/
/*   Function : ClearMsgTitleInfo                                          */
/*                                           X^Cꗗ̊֘ÄJ  */
/*=========================================================================*/
void ClearMsgTitleInfo(void)
{
    if (NNshGlobal->msgListIndex != NULL)
    {
        MemPtrFree(NNshGlobal->msgListIndex);
        NNshGlobal->msgListIndex = NULL;
    }

    if (NNshGlobal->msgListStrings != NULL)
    {
        MemPtrFree(NNshGlobal->msgListStrings);
        NNshGlobal->msgListStrings = NULL;
    }

    if (NNshGlobal->msgTitleIndex != NULL)
    {
        MemPtrFree(NNshGlobal->msgTitleIndex);
        NNshGlobal->msgTitleIndex = NULL;
    }

    if (NNshGlobal->msgTitleStatus != NULL)
    {
        MemPtrFree(NNshGlobal->msgTitleStatus);
        NNshGlobal->msgTitleStatus = NULL;
    }

    if (NNshGlobal->msgNumbers != NULL)
    {
        MemPtrFree(NNshGlobal->msgNumbers);
        NNshGlobal->msgNumbers = NULL;
    }

    NNshGlobal->nofTitleItems = 0;

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : AllocMsgTitleInfo                                          */
/*                                           X^Cꗗ̊֘Äm  */
/*-------------------------------------------------------------------------*/
static Err AllocMsgTitleInfo(UInt16 nofItems)
{
    UInt16 allocSize;

    // XꗗXR[hԍϊe[ü̏
    allocSize = sizeof(UInt16) * (nofItems + 1);
    NNshGlobal->msgListIndex = MemPtrNew(allocSize);
    if (NNshGlobal->msgListIndex == NULL)
    {
        return (~errNone + 10);
    }
    MemSet(NNshGlobal->msgListIndex, allocSize, 0x00);

    // X^Cg̐擪ʒui[̈̏
    allocSize = sizeof(Char *) * (nofItems + 1);
    NNshGlobal->msgTitleIndex = MemPtrNew(allocSize);
    if (NNshGlobal->msgTitleIndex == NULL)
    {
        MemPtrFree(NNshGlobal->msgListIndex);
        return (~errNone + 11);    
    }
    MemSet(NNshGlobal->msgTitleIndex, allocSize, 0x00);

    // X^Cgi[̈̏
    allocSize = (LIMIT_TITLENAME_DEFAULT + 10 + MARGIN) * (nofItems + 1);
    NNshGlobal->msgListStrings = MemPtrNew(allocSize);
    if (NNshGlobal->msgListStrings == NULL)
    {
        MemPtrFree(NNshGlobal->msgListIndex);
        MemPtrFree(NNshGlobal->msgTitleIndex);
        return (~errNone + 12);
    }
    MemSet(NNshGlobal->msgListStrings, allocSize, 0x00);

    // X^CgԊi[̈̏
    allocSize = sizeof(UInt16) * (nofItems + 1);
    NNshGlobal->msgTitleStatus = MemPtrNew(allocSize);
    if (NNshGlobal->msgTitleStatus == NULL)
    {
        MemPtrFree(NNshGlobal->msgListIndex);
        MemPtrFree(NNshGlobal->msgTitleIndex);
        MemPtrFree(NNshGlobal->msgListStrings);
        return (~errNone + 13);
    }
    MemSet(NNshGlobal->msgTitleStatus, allocSize, 0x00);

    // XbZ[Wi[̈̏
    allocSize = sizeof(UInt16) * (nofItems + 1);
    NNshGlobal->msgNumbers = MemPtrNew(allocSize);
    if (NNshGlobal->msgNumbers == NULL)
    {
        MemPtrFree(NNshGlobal->msgListIndex);
        MemPtrFree(NNshGlobal->msgTitleIndex);
        MemPtrFree(NNshGlobal->msgListStrings);
        MemPtrFree(NNshGlobal->msgTitleStatus);
        return (~errNone + 14);
    }
    MemSet(NNshGlobal->msgNumbers, allocSize, 0x00);

    NNshGlobal->nofTitleItems = 0;

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   function :   create_TitleList                                         */
/*                                            bZ[W^Cgꗗ쐬 */
/*-------------------------------------------------------------------------*/
static Err create_TitleList(UInt16 bbsIndex, UInt16 areaCount, Char *buffer,
                            UInt16 *startRec, UInt16 *endRec, Int16 step)
{
    Err                  ret = ~errNone;
    Char                *ptr;
    UInt16               dataIndexMax, loop;
    DmOpenRef            dbRef;
    NNshSubjectDatabase  tmpDb;
    NNshBoardDatabase    bbsData;

    // BBSȊÔƂ́ABBS擾
    if (bbsIndex >= NNSH_SELBBS_OFFLINE)
    {
        if (Get_BBS_Info(bbsIndex, &bbsData) != errNone)
        {
            ret  = ~errNone;
            goto NEXT_STEP;
        }
    }
    else if (bbsIndex == NNSH_SELBBS_CUSTOM1)
    {
        if (Get_BBS_Info(NNshParam->custom1.boardNick, &bbsData) != errNone)
        {
            ret  = ~errNone;
            goto NEXT_STEP;
        }
    }
    else if (bbsIndex == NNSH_SELBBS_CUSTOM2)
    {
        if (Get_BBS_Info(NNshParam->custom2.boardNick, &bbsData) != errNone)
        {
            ret  = ~errNone;
            goto NEXT_STEP;
        }
    }

    // XǗDBI[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    GetDBCount_NNsh(dbRef, &dataIndexMax);
    ptr = buffer;

    // Pf[^o^ĂȂꍇ
    if (dataIndexMax == 0)
    {
        // uꗗȂvݒ蕔փWv
        loop = 0;
        goto RECORD_NOTHING;
    }

    // R[h̍őԍdataIndexMaxɐݒ肷
    dataIndexMax = dataIndexMax - 1;

    // `FbN
    if (step == NNSH_STEP_PAGEDOWN)
    {
        if (NNshParam->startTitleRec == NNSH_ITEM_LASTITEM)
        {
            // XɃWvw肳ꂽꍇ
            *startRec = 0;
            NNshParam->selectedTitleItem = (areaCount - 1);
        }
        else if (NNshParam->startTitleRec >= dataIndexMax)
        {
            // X擪ꍇ
            *startRec = dataIndexMax;
            NNshParam->selectedTitleItem = 0;
            step = NNSH_STEP_PAGEUP;
        }
    }

    // `FbN
    if ((step == NNSH_STEP_PAGEUP)&&(NNshParam->endTitleRec == 0))
    {
        // 
        *startRec = 0;
        NNshParam->selectedTitleItem = (areaCount - 1);
        step = NNSH_STEP_PAGEDOWN;
    }

    // YɏX(f[^x[X珇Ԃ)oB
    *startRec = (*startRec > dataIndexMax) ? dataIndexMax: *startRec;

    // ^Cg̏
    NNshGlobal->nofTitleItems  = 0;

    if (*startRec == 0)
    {
        // [v̖()猟Jn
        NNshParam->titleDispState = NNSH_DISP_LOWERLIMIT;
    }
    else if (*startRec == dataIndexMax)
    {
        // [v̐擪()猟Jn
        NNshParam->titleDispState = NNSH_DISP_UPPERLIMIT;
    }
    else
    {
        // Ԃ
        NNshParam->titleDispState = NNSH_DISP_HALFWAY;
    }

    for (loop = *startRec;
         ((loop >= 0)&&(loop <= dataIndexMax));
         loop = loop + step)
    {
        // GetRecord_NNsh()Ń[NAĂ邽ߕsv
        // MemSet(&tmpDb, sizeof(NNshSubjectDatabase), 0x00);
        GetRecord_NNsh(dbRef, loop, sizeof(NNshSubjectDatabase), &tmpDb);

        // \/Ȃ̏
        if (checkDispList(bbsIndex, &tmpDb, &bbsData) == false)
        {
            // \ȂXƔ
            continue;
        }

        if (NNshGlobal->nofTitleItems >= areaCount)
        {
            // Xg\̕\\萔ÎŁAŔ
            break;
        }

        // X^CgAԂۑ
        NNshGlobal->msgTitleIndex [NNshGlobal->nofTitleItems] = ptr;
        NNshGlobal->msgListIndex  [NNshGlobal->nofTitleItems] = loop;

        // bZ[WKI[oĂA̐FɂĂ܂
        if ((tmpDb.maxLoc > NNSH_MESSAGE_LIMIT)&&
            (tmpDb.state == NNSH_SUBJSTATUS_ALREADY))
        {
            NNshGlobal->msgTitleStatus[NNshGlobal->nofTitleItems] = 
                        ((NNSH_SUBJSTATUS_OVER)|((tmpDb.msgAttribute << 8)));
        }
        else
        {
            NNshGlobal->msgTitleStatus[NNshGlobal->nofTitleItems] = 
                                 ((tmpDb.state)|((tmpDb.msgAttribute << 8)));
        }
        NNshGlobal->msgNumbers[NNshGlobal->nofTitleItems] = tmpDb.maxLoc;

        // ^Cg쐬
        copyThreadTitleString(ptr,tmpDb.threadTitle, LIMIT_TITLENAME_DEFAULT,
                        NNshGlobal->msgTitleStatus[NNshGlobal->nofTitleItems],
                            NNshGlobal->msgNumbers[NNshGlobal->nofTitleItems]);

        // ̊i[̈փ|C^ړ
        ptr = ptr + StrLen(ptr) + 1;
        (NNshGlobal->nofTitleItems)++;
    }

    if (loop == (dataIndexMax + 1))
    {
        // ̃`FbN
        if (NNshParam->titleDispState == NNSH_DISP_LOWERLIMIT)
        {
            // S̃X\Ă
            NNshParam->titleDispState = NNSH_DISP_ALL;
        }
        else
        {
            // [v̍Ō܂ŉ()
            NNshParam->titleDispState = NNSH_DISP_UPPERLIMIT;
        }
    }
    else if (loop == (0 - 1))
    {
        // ̃`FbN
        if (NNshParam->titleDispState == NNSH_DISP_UPPERLIMIT)
        {
            // S̃X\Ă
            NNshParam->titleDispState = NNSH_DISP_ALL;
        }
        else
        {
            // [v̍Ō܂ŉ()
            NNshParam->titleDispState = NNSH_DISP_LOWERLIMIT;
        }
    }
else {
    if(((*startRec) != dataIndexMax) && ((*startRec) != 0)) {
	/* t̕`FbN */
	for(loop = *startRec - step;
            ((loop >= 0) && (loop <= dataIndexMax));
	    loop = loop - step) {
            GetRecord_NNsh(dbRef, loop, sizeof(NNshSubjectDatabase), &tmpDb);
	    if(checkDispList(bbsIndex, &tmpDb, &bbsData)) {
		break;
	    }
	}
	if (loop == (dataIndexMax + 1)) {
	    if (NNshParam->titleDispState == NNSH_DISP_LOWERLIMIT) {
		// S̃X\Ă
		NNshParam->titleDispState = NNSH_DISP_ALL;
	    } else {
		// [v̍Ō܂ŉ()
		NNshParam->titleDispState = NNSH_DISP_UPPERLIMIT;
	    }
	} else if (loop == (0 - 1)) {
	    if ((NNshParam->titleDispState == NNSH_DISP_UPPERLIMIT)) {
		// S̃X\Ă
		NNshParam->titleDispState = NNSH_DISP_ALL;
	    } else {
		// [v̍Ō܂ŉ()
		NNshParam->titleDispState = NNSH_DISP_LOWERLIMIT;
	    }
	}
    }
}


RECORD_NOTHING:
    if (NNshGlobal->nofTitleItems == 0)
    {
        // uꗗȂvݒ肷
        StrCopy(buffer, MSG_SUBJECT_DEFAULT);
        NNshGlobal->msgListIndex [0]  = loop;
        NNshGlobal->msgTitleIndex[0]  = buffer;
        NNshParam->titleDispState    = NNSH_DISP_NOTHING;
        NNshGlobal->msgNumbers[0]     = 0;
        NNshGlobal->msgTitleStatus[0] = 0;
        ret = (~errNone - 10);
    }
    else
    {
        ret = errNone;
    }

NEXT_STEP:
    CloseDatabase_NNsh(dbRef);

    //  A"Py[W"ړwĂꍇAXgACȅԂ
    // ](bΏ̂AƂ܂l)
    if ((step == NNSH_STEP_PAGEDOWN)&&(NNshGlobal->nofTitleItems > 1))
    {
        reverse_List_Order(NNshGlobal->nofTitleItems,
                           buffer,
                           NNshGlobal->msgListIndex,
                           NNshGlobal->msgTitleIndex,
                           NNshGlobal->msgTitleStatus,
                           NNshGlobal->msgNumbers);
    }

    // ǂݏoR[h̐擪/ݒ肷
    *startRec = NNshGlobal->msgListIndex[0];
    if (NNshGlobal->nofTitleItems != 0)
    {
        *endRec = NNshGlobal->msgListIndex[(NNshGlobal->nofTitleItems - 1)];
    }
    else
    {
        *endRec = 0;
        NNshParam->titleDispState    = NNSH_DISP_NOTHING;
    }

    return (ret);
}

/*=========================================================================*/
/*   Function :   Update_Thread_List                                       */
/*                                                      Xꗗ\̍XV */
/*=========================================================================*/
Boolean Update_Thread_List(UInt16 bbsIdx, UInt16 selItem, UInt16 step)
{
    FormType         *frm;
    RectangleType     dimF;
    UInt16            fontID, nlines, fontHeight, startRec, endRec;

    // ANeBuȃtH[̃|C^擾
    frm = FrmGetActiveForm();
    FrmGetObjectBounds(frm, FrmGetObjectIndex(frm, GADID_MESSAGE_LIST), &dimF);

    // `̈ƃtHg̏A\\sXV
    if (NNshParam->useSonyTinyFontTitle == 0)
    {
        fontID = NNshParam->currentFont;
    }
    else
    {
        fontID = NNshParam->sonyHRFontTitle;
    }

    // ʂ̑傫擾(ݒ)
    NNsi_UpdateRectangle(&dimF, NNshParam->useSonyTinyFontTitle,
                         &fontID, &fontHeight, &nlines);

    // "Xꗗ쐬" ̕\
    Show_BusyForm(MSG_READ_THREAD_WAIT);

    // X^C֘ÄJ
    ClearMsgTitleInfo();

    // X^C֘Ämۂ
    if (AllocMsgTitleInfo(nlines) != errNone)
    {
        // X^Cg֘Ä̊mۂɎs
        return (false);
    }

    //X^Cg̃R[hԍLځAX^Cgꗗ̍쐬(XV)
    switch (step)
    {
      case NNSH_STEP_PAGEUP:
        // 1y[W""ֈړ
        startRec = NNshParam->endTitleRec;
        (void) create_TitleList(bbsIdx, nlines, NNshGlobal->msgListStrings, 
                                &startRec, &endRec, step);
        NNshParam->startTitleRec = startRec;
        NNshParam->endTitleRec   = endRec;
        break;

      case NNSH_STEP_PAGEDOWN:
        // 1y[W""ֈړ
        startRec = NNshParam->startTitleRec;
        (void) create_TitleList(bbsIdx, nlines, NNshGlobal->msgListStrings, 
                                &startRec, &endRec, step);
        NNshParam->endTitleRec   = startRec;
        NNshParam->startTitleRec = endRec;
        break;

      case NNSH_STEP_REDRAW:
        // ݕ\̃y[Wĕ`悷
        startRec = NNshParam->startTitleRec;
        (void) create_TitleList(bbsIdx, nlines, NNshGlobal->msgListStrings, 
                                &startRec, &endRec, NNSH_STEP_PAGEUP);
        NNshParam->startTitleRec = startRec;
        NNshParam->endTitleRec   = endRec;
        break;

      case NNSH_STEP_UPDATE:
      default:
        // ̐擪ĕ\
        startRec                 = NNSH_ITEM_LASTITEM;
        NNshParam->startTitleRec = NNSH_ITEM_LASTITEM;
        NNshParam->endTitleRec   = NNSH_ITEM_LASTITEM;
        (void) create_TitleList(bbsIdx, nlines, NNshGlobal->msgListStrings, 
                                &startRec, &endRec, NNSH_STEP_PAGEUP);
        NNshParam->startTitleRec = startRec;
        NNshParam->endTitleRec   = endRec;
        break;
    }

    // StartTitleRec > EndTitleRec ƂȂ悤
    if (NNshParam->endTitleRec > NNshParam->startTitleRec)
    {
        startRec                 = NNshParam->startTitleRec;
        NNshParam->startTitleRec = NNshParam->endTitleRec;
        NNshParam->endTitleRec   = startRec;
    }

    // IXw肵ACeԍɐݒ肷
    // (\\s𒴂ĂAԉ̃ACeԍɕύX)
    NNshParam->selectedTitleItem = (selItem >= NNshGlobal->nofTitleItems) ?
                                     (NNshGlobal->nofTitleItems - 1): selItem;

    // "Xꗗ쐬"̕\폜
    Hide_BusyForm(false);

#ifdef USE_CLIE
    if (NNshGlobal->updateHR == NNSH_UPDATE_DISPLAY)
    {
        // CLIEŃVÑTCYύXꂽƂɂ͈UtH[
        FrmEraseForm(frm);
    }
#endif
    FrmDrawForm(frm);    	

    // Xꗗ̕\(`)
    NNsi_WinDrawList(NNshParam->selectedTitleItem,
                     NNshGlobal->msgTitleIndex,
                     nlines, &dimF, fontHeight);
    return (true);
}

#ifdef USE_COLOR
/*=========================================================================*/
/*   Function :   NNsi_SetTitleColor                                       */
/*                                                    X^Cg̐Fݒ */
/*=========================================================================*/
void NNsi_SetTitleColor(UInt16 status)
{
    IndexedColorType color;

    if (((status >> 8)&(NNSH_MSGATTR_ERROR)) == NNSH_MSGATTR_ERROR)
    {
        // G[X    
        color = (IndexedColorType) NNshParam->colorError;
        goto SET_COLOR;
    }
    // bZ[W̏ԂŐFݒ
    switch (status & 0xff)
    {
      case NNSH_SUBJSTATUS_NEW:
        /** VK擾(Ď擾) **/
        color = (IndexedColorType) NNshParam->colorNew;
        break;

      case NNSH_SUBJSTATUS_UPDATE:
        /** bZ[WXV **/
        color = (IndexedColorType) NNshParam->colorUpdate;
        break;

      case NNSH_SUBJSTATUS_REMAIN:
        /** ǂ **/
        color = (IndexedColorType) NNshParam->colorRemain;
        break;

      case NNSH_SUBJSTATUS_ALREADY:
        /** bZ[WSǂ **/
        color = (IndexedColorType) NNshParam->colorAlready;
        break;

      case NNSH_SUBJSTATUS_NOT_YET:
        /** bZ[W擾 **/
        color = (IndexedColorType) NNshParam->colorNotYet;
        break;

      case NNSH_SUBJSTATUS_OVER:
        /** 1000 **/
        color = (IndexedColorType) NNshParam->colorOver;
        break;

      default:                
        /** ̑(肦ȂH) **/
        color = (IndexedColorType) NNshParam->colorUnknown;
        break;
    }

SET_COLOR:
    // Fݒ肷
    WinSetForeColor(color);
    WinSetTextColor(color);
    return;
}
#endif

/*=========================================================================*/
/*   Function :   NNsi_WinDrawList                                         */
/*                                                    Xꗗ̕\C */
/*=========================================================================*/
void NNsi_WinDrawList(UInt16 pointIndex, Char *titleIndex[], UInt16 listItems,
                      RectangleType *dimF, UInt16 height)
{
    FormType     *frm;
    UInt16        lp, len;
#ifdef USE_COLOR
    IndexedColorType savedIndex;
    RGBColorType     savedColor, drawColor;
#endif

    // Xꗗɕ\镶񂪂Ȃꍇɂ́A
    if (NNshGlobal->msgTitleIndex == NULL)
    {
        return;
    }

#ifdef USE_COLOR
    if (NNshParam->useColor != 0)
    {
        ///////////////////////////////////////////////////////////////
        //  ̐ݒɂAꗗXg̗̈悾wiFς...
        // (Ȃ񂩂ƊiDȂBBB)
        ///////////////////////////////////////////////////////////////

        // wiFݒ肷
        WinSetBackColor((IndexedColorType) NNshParam->colorBackGround);
    }
#endif

    // \̈NA
    NNsi_EraseRectangle(dimF);

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        // FntSetFont(NNshParam->sonyHRFontTitle);
        break;

      case kDensityLow:
      default:
        break;
    }
#endif   // #ifdef USE_HIGHDENSITY

    // X^Cg̕`
    for (lp = 0; lp < listItems; lp++)
    {
        if (NNshGlobal->msgTitleIndex[lp] == '\0')
        {
            // ^CgCfbNXȂAI
            break;
        }

#ifdef USE_COLOR
        // tHgJ[̐ݒ
        if (NNshParam->useColor != 0)
        {
            // ƎsA͔...Ă...(^^;
            NNsi_SetTitleColor(NNshGlobal->msgTitleStatus[lp]);
        }
#endif

#ifdef USE_CLIE
        if (NNshGlobal->hrRef != 0)
        {
            // CLIEnC]`
            HRWinDrawChars(NNshGlobal->hrRef, 
                           titleIndex[lp], StrLen(titleIndex[lp]),
                           dimF->topLeft.x, dimF->topLeft.y);
            if (pointIndex == lp)
            {
                // J[\ʒu𔽓]
                HRWinDrawInvertedChars(NNshGlobal->hrRef, 
                                       titleIndex[lp], StrLen(titleIndex[lp]),
                                       dimF->topLeft.x, dimF->topLeft.y);
            }
        }
        else
#endif
        {
            // ʏ탂[h`
            len = FntWordWrap(titleIndex[lp], dimF->extent.x);
            WinDrawChars(titleIndex[lp],len,dimF->topLeft.x,dimF->topLeft.y);
            if (pointIndex == lp)
            {
                // J[\ʒu𔽓]
                WinDrawInvertedChars(titleIndex[lp], len,
                                     dimF->topLeft.x, dimF->topLeft.y);
            }
        }

        // ̍sɕ`ʒuړ
        dimF->topLeft.y = dimF->topLeft.y + height;
    }

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),
                      NNshGlobal->os5HighDensity);
        WinSetCoordinateSystem(kCoordinatesStandard);
        // FntSetFont(NNshParam->sonyHRFont);
        break;

      case kDensityLow:
      default:
        break;
    }
#endif   // #ifdef USE_HIGHDENSITY

#ifdef USE_COLOR
    if (NNshParam->useColor != 0)
    {
        // ݂̐Fۑ
        savedIndex = UIColorGetTableEntryIndex(UIObjectForeground);
        WinIndexToRGB(savedIndex, &savedColor);

        // {^̐Fϊ
        WinIndexToRGB(NNshParam->colorButton,    &drawColor);
        UIColorSetTableEntry(UIObjectForeground, &drawColor);
    }
#endif

    // /̃{^\
    // (㉺{^\/\ɂ)
    frm = FrmGetActiveForm();
    switch (NNshParam->titleDispState)
    {
      case NNSH_DISP_NOTHING:
        // ꗗȂ
        FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_LISTPREV));
        FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_LISTNEXT));
        break;

      case NNSH_DISP_UPPERLIMIT:
        // 
        FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_LISTPREV));
        FrmShowObject(frm, FrmGetObjectIndex(frm, BTNID_LISTNEXT));
        break;

      case NNSH_DISP_LOWERLIMIT:
        // 
        FrmShowObject(frm, FrmGetObjectIndex(frm, BTNID_LISTPREV));
        FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_LISTNEXT));
        break;

      case NNSH_DISP_ALL:
        // S
        FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_LISTPREV));
        FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_LISTNEXT));
        break;

      case NNSH_DISP_HALFWAY:
      default:
        // r
        FrmShowObject(frm, FrmGetObjectIndex(frm, BTNID_LISTPREV));
        FrmShowObject(frm, FrmGetObjectIndex(frm, BTNID_LISTNEXT));
        break;
    }

#ifdef USE_COLOR
    if (NNshParam->useColor != 0)
    {
        // {^̐Fɖ߂
        UIColorSetTableEntry(UIObjectForeground, &savedColor);

        // ftHg̔wiFݒ肷
        WinSetBackColor(UIColorGetTableEntryIndex(UIFieldBackground));
    }   
#endif

    return;
}


/*=========================================================================*/
/*   Function :   NNsi_WinUpdateList                                       */
/*                                            Xgf[^̔]XV */
/*=========================================================================*/
void NNsi_WinUpdateList(UInt16 pointIndex, UInt16 prevIndex,
                        Char *titleIndex[], UInt16 listItems,
                        RectangleType *dimF, UInt16 height)
{
    UInt16         lp, len;
    FormType      *frm;
#ifdef USE_COLOR
    IndexedColorType savedIndex;
    RGBColorType     savedColor, drawColor;
#endif

#ifdef USE_COLOR
    if (NNshParam->useColor != 0)
    {
        ///////////////////////////////////////////////////////////////
        //  ̐ݒɂAꗗXg̗̈悾wiFς...
        // (Ȃ񂩂ƊiDȂBBB)
        ///////////////////////////////////////////////////////////////

        // wiFݒ肷
        WinSetBackColor((IndexedColorType) NNshParam->colorBackGround);
    }
#endif

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        // FntSetFont(NNshParam->sonyHRFont);
        break;

      case kDensityLow:
      default:
        break;
    }
#endif

    // X^Cg̕`
    for (lp = 0; lp < listItems; lp++)
    {
        if (NNshGlobal->msgTitleIndex[lp] == '\0')
        {
            // ^CgCfbNXȂAI
            break;
        }

        if (lp == prevIndex)
        {
#ifdef USE_COLOR
            // tHgJ[̐ݒ
            if (NNshParam->useColor != 0)
            {
                // ƎsA͔...Ă...(^^;
                NNsi_SetTitleColor(NNshGlobal->msgTitleStatus[lp]);
            }
#endif
#ifdef USE_CLIE
            if (NNshGlobal->hrRef != 0)
            {
                // J[\ʒuɖ߂(CLIEnC]`)
                HRWinDrawChars(NNshGlobal->hrRef, 
                               titleIndex[lp], StrLen(titleIndex[lp]),
                               dimF->topLeft.x, dimF->topLeft.y);
            }
            else
#endif
            {
                // J[\ʒuɖ߂(ʏ탂[h`)
                len = FntWordWrap(titleIndex[lp], dimF->extent.x);
                WinDrawChars(titleIndex[lp], len,
                             dimF->topLeft.x, dimF->topLeft.y);
            }
        }

        if (lp == pointIndex)
        {
            // tHgJ[̐ݒ
#ifdef USE_COLOR
            if (NNshParam->useColor != 0)
            {
                // ƎsA͔...Ă...(^^;
                NNsi_SetTitleColor(NNshGlobal->msgTitleStatus[lp]);
            }
#endif
#ifdef USE_CLIE
            if (NNshGlobal->hrRef != 0)
            {
                // J[\ʒu𔽓](CLIEnC]`)
                HRWinDrawInvertedChars(NNshGlobal->hrRef, 
                                       titleIndex[lp], StrLen(titleIndex[lp]),
                                       dimF->topLeft.x, dimF->topLeft.y);
            }
            else
#endif
            {
                // J[\ʒu𔽓](ʏ탂[h`)
                len = FntWordWrap(titleIndex[lp], dimF->extent.x);
                WinDrawInvertedChars(titleIndex[lp], len,
                                     dimF->topLeft.x, dimF->topLeft.y);
            }
        }
 
        // ̍sɕ`ʒuړ
        dimF->topLeft.y = dimF->topLeft.y + height;
    }

#ifdef USE_HIGHDENSITY
    // 𑜓x̐ݒ
    switch (NNshGlobal->os5HighDensity)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),
                      NNshGlobal->os5HighDensity);
        WinSetCoordinateSystem(kCoordinatesStandard);
        // FntSetFont(NNshParam->sonyHRFont);
        break;

      case kDensityLow:
      default:
        break;
    }
#endif // #ifdef USE_HIGHDENSITY

#ifdef USE_COLOR
    if (NNshParam->useColor != 0)
    {
        // ݂̐Fۑ
        savedIndex = UIColorGetTableEntryIndex(UIObjectForeground);
        WinIndexToRGB(savedIndex, &savedColor);

        // {^̐Fϊ
        WinIndexToRGB(NNshParam->colorButton,    &drawColor);
        UIColorSetTableEntry(UIObjectForeground, &drawColor);
    }
#endif

    // /̃{^\
    // (㉺{^\/\ɂ)
    frm = FrmGetActiveForm();
    switch (NNshParam->titleDispState)
    {
      case NNSH_DISP_NOTHING:
        // ꗗȂ
        FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_LISTPREV));
        FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_LISTNEXT));
        break;

      case NNSH_DISP_UPPERLIMIT:
        // 
        FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_LISTPREV));
        FrmShowObject(frm, FrmGetObjectIndex(frm, BTNID_LISTNEXT));
        break;

      case NNSH_DISP_LOWERLIMIT:
        // 
        FrmShowObject(frm, FrmGetObjectIndex(frm, BTNID_LISTPREV));
        FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_LISTNEXT));
        break;

      case NNSH_DISP_ALL:
        // S
        FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_LISTPREV));
        FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_LISTNEXT));
        break;

      case NNSH_DISP_HALFWAY:
      default:
        // r
        FrmShowObject(frm, FrmGetObjectIndex(frm, BTNID_LISTPREV));
        FrmShowObject(frm, FrmGetObjectIndex(frm, BTNID_LISTNEXT));
        break;
    }

#ifdef USE_COLOR
    if (NNshParam->useColor != 0)
    {
        // {^̐Fɖ߂
        UIColorSetTableEntry(UIObjectForeground, &savedColor);

        // ftHg̔wiFݒ肷
        WinSetBackColor(UIColorGetTableEntryIndex(UIFieldBackground));
    }   
#endif
    return;
}
