//////////////////////////////////////////////////////////////////////////////
//  $Id: nnda.c,v 1.4 2004/02/17 15:39:02 mrsa Exp $
//
// nnda.c   --- nnDA main
//
// (C) NNsi project, 2004, all rights reserved.
//
//////////////////////////////////////////////////////////////////////////////
#include <PalmOS.h>
#include "nnda-rsc-defines.h"
#include "nnda-defines.h"

static void setnnDA_DAData       (FormType *frm, nnDADataType *adtP);
static void setDisp_nnDA_DAData  (FormType *frm, nnDADataType *adtP);
static void resetDisp_nnDA_DAData(FormType *frm, nnDADataType *adtP);
static void endnnDA_DAData       (FormType *frm, nnDADataType *adtP);

#ifdef USE_CLIE
static void startClieDisp_DAData(FormType *frm, nnDADataType *adtP);
static void setClieDisp_DAData  (FormType *frm, nnDADataType *adtP);
static void resetClieDisp_DAData(FormType *frm, nnDADataType *adtP);
static void endClieDisp_DAData  (FormType *frm, nnDADataType *adtP);
#endif // #ifdef USE_CLIE


// \f[^̎擾֐Q
static Char *getFileStreamData(Char *infoName, Char *title, UInt16 titleSize);
static Char *getFileStreamBinData(Char *infoName, Char *title, UInt16 titleSize);
static Char *getStringListData(void);
static Char *getStringData    (UInt16 rscID);
static Char *outputHexString(Char *data, UInt16 len);

/*=========================================================================*/
/*   Function :  getInformation                                            */
/*                          ^ꂽ񂩂A\ׂ̐ݒs */
/*=========================================================================*/
Char *getInformation(Char *infoName, Char *title, UInt16 titleSize)
{
    // ^ꂽ񂪈ُH
    if (infoName == NULL)
    {
        // B
        return (NULL);
    }

    ////////////////////// \^Cgƕ\̐ //////////////////

    // t@Cf[^擾
    if (StrNCompare(infoName, nnDA_NNSIEXT_FILE, (sizeof(nnDA_NNSIEXT_FILE) - 1)) == 0)
    {
        return (getFileStreamData((infoName + sizeof(nnDA_NNSIEXT_FILE) - 1), title, titleSize));
    }

    // ꗗʂ̃wvf[^擾
    if (StrNCompare(infoName, nnDA_NNSIEXT_HELPLIST, (sizeof(nnDA_NNSIEXT_HELPLIST) - 1)) == 0)
    {
        StrNCopy(title, nnDA_TITLE_HELP_LIST, titleSize);
        return (getStringListData());
    }

    // QƉʂ̃wvf[^擾
    if (StrNCompare(infoName, nnDA_NNSIEXT_HELPVIEW, (sizeof(nnDA_NNSIEXT_HELPVIEW) - 1)) == 0)
    {
        StrNCopy(title, nnDA_TITLE_HELP_VIEW, titleSize);
        return (getStringData(HELPSTRING_VIEW));
    }

    // [Uݒ^uʂ̃wvf[^擾
    if (StrNCompare(infoName, nnDA_NNSIEXT_HELPUSERTAB, (sizeof(nnDA_NNSIEXT_HELPUSERTAB) - 1)) == 0)
    {
        StrNCopy(title, nnDA_TITLE_HELP_USERTAB, titleSize);
        return (getStringData(HELPSTRING_USERTAB));
    }

    // NNsiݒʂ̃wvf[^擾
    if (StrNCompare(infoName, nnDA_NNSIEXT_HELPNNSISET, (sizeof(nnDA_NNSIEXT_HELPNNSISET) - 1)) == 0)
    {
        StrNCopy(title, nnDA_TITLE_HELP_NNSISET, titleSize);
        return (getStringData(HELPSTRING_NNSISET));
    }

    // t@C̃f[^ǂݏo...
    if (StrNCompare(infoName, nnDA_NNSIEXT_FILE, (sizeof(nnDA_NNSIEXT_FILE) - 1)) == 0)
    {
        return (getFileStreamData(infoName + (sizeof(nnDA_NNSIEXT_FILE) - 1), title, titleSize));
    }

    // oCit@C̃f[^ǂݏo...
    if (StrNCompare(infoName, nnDA_NNSIEXT_BINFILE, (sizeof(nnDA_NNSIEXT_BINFILE) - 1)) == 0)
    {
        return (getFileStreamBinData(infoName + (sizeof(nnDA_NNSIEXT_BINFILE) - 1), title, titleSize));
    }

    // nnDAT|[gBBB
    return (NULL);
}

/*-------------------------------------------------------------------------*/
/*   Function :  getFileStreamBinData                                      */
/*                                  fileStreamoCif[^擾 */
/*-------------------------------------------------------------------------*/
static Char *getFileStreamBinData(Char *infoName, Char *title, UInt16 titleSize)
{
    UInt32     creator, dataSize;
    UInt16     len;
    Char      *fileName, *ptr, *ptr2;
    Err        err;
    FileHand   filRef;
    
    // creatorID̒o
    ptr = (Char *) &creator;
    *ptr       = infoName[0];
    *(ptr + 1) = infoName[1];
    *(ptr + 2) = infoName[2];
    *(ptr + 3) = infoName[3];

    // t@C̒o
    len      = 0;
    ptr      = infoName + 5;  // NG[^ID + ":" A|C^i߂
    while (*ptr != '<')
    {
        len++;
        ptr++;
    }
    fileName = MemPtrNew(len + 4);
    if (fileName == NULL)
    {
        StrNCopy(title, "MemPtrNew", titleSize);
        return (NULL);
    }
    MemSet  (fileName, (len + 4), 0x00);
    StrNCopy(fileName, (infoName + 5), len);

    // t@CI[vAf[^Rs[
    filRef = FileOpen(0, fileName, 0, creator, fileModeReadOnly, &err);
    if (filRef == 0)
    {
        // t@CI[vɎsAt@C\
        StrCopy(title, "ERR:0x");
        StrIToH(&title[StrLen(title)], err);
        return (fileName);
    }

    // t@CTCY擾
    if (FileTell(filRef, &dataSize, &err) != -1)
    {
        len = dataSize;
        if (dataSize > (DISP_LIMIT / 3))
        {
            len = (DISP_LIMIT / 3);
        }
        StrNCopy(title, fileName, titleSize);

        ptr = MemPtrNew(len + BUF_MARGIN);
        if (ptr == NULL)
        {
            StrNCopy(title, "MemPtrNew()", titleSize);
            FileClose(filRef);
            return (fileName);
        }
        MemSet (ptr, (len + BUF_MARGIN), 0x00);
        FileRead(filRef, ptr, 1, len, &err);
        ptr2 = outputHexString(ptr, len);
        if (ptr2 != NULL)
        {
            // oCi\f[^쐬łÄJ
            MemPtrFree(ptr);
            ptr = ptr2;
        }
        MemPtrFree(fileName);
    }
    else
    {
        // t@CTCY̎擾ɎsAt@C\
        StrNCopy(title, "FileTell", titleSize);
        ptr = fileName;
    }
    FileClose(filRef);
    return (ptr);
}

/*-------------------------------------------------------------------------*/
/*   Function :  getFileStreamData                                         */
/*                                          fileStreamf[^擾 */
/*-------------------------------------------------------------------------*/
static Char *getFileStreamData(Char *infoName, Char *title, UInt16 titleSize)
{
    UInt32     creator, dataSize;
    UInt16     len;
    Char      *fileName, *ptr;
    Err        err;
    FileHand   filRef;
    
    // creatorID̒o
    ptr = (Char *) &creator;
    *ptr       = infoName[0];
    *(ptr + 1) = infoName[1];
    *(ptr + 2) = infoName[2];
    *(ptr + 3) = infoName[3];

    // t@C̒o
    len      = 0;
    ptr      = infoName + 5;  // NG[^ID + ":" A|C^i߂
    while (*ptr != '<')
    {
        len++;
        ptr++;
    }
    fileName = MemPtrNew(len + 4);
    if (fileName == NULL)
    {
        StrNCopy(title, "MemPtrNew", titleSize);
        return (NULL);
    }
    MemSet  (fileName, (len + 4), 0x00);
    StrNCopy(fileName, (infoName + 5), len);

    // t@CI[vAf[^Rs[
    filRef = FileOpen(0, fileName, 0, creator, fileModeReadOnly, &err);
    if (filRef == 0)
    {
        // t@CI[vɎsAG[R[h\
        StrCopy(title, "ERR:0x");
        StrIToH(&title[StrLen(title)], err);
        return (fileName);
    }

    // t@CTCY擾
    if (FileTell(filRef, &dataSize, &err) != -1)
    {
        len = dataSize;
        if (dataSize > DISP_LIMIT)
        {
            len = DISP_LIMIT;
        }
        StrNCopy(title, fileName, titleSize);

        ptr = MemPtrNew(len + BUF_MARGIN);
        if (ptr == NULL)
        {
            StrNCopy(title, "MemPtrNew()", titleSize);
            FileClose(filRef);
            return (fileName);
        }
        MemSet (ptr, (len + BUF_MARGIN), 0x00);
        StrCopy(ptr, "size:");
        StrIToA(&ptr[StrLen(ptr)], len);
        StrCat (ptr, "/");
        StrIToA(&ptr[StrLen(ptr)], dataSize);
        StrCat (ptr, "\n=====\n");
        FileRead(filRef, &ptr[StrLen(ptr)], 1, len, &err);
        MemPtrFree(fileName);
    }
    else
    {
        // t@CTCY̎擾ɎsAt@C\
        StrNCopy(title, "FileTell", titleSize);
        ptr = fileName;
    }
    FileClose(filRef);
    return (ptr);
}

/*--------------------------------------------------------------------------*/
/*  Function : outputHexString                                              */
/*                                             fobOpɐlփf[^ϊ */
/*--------------------------------------------------------------------------*/
static Char *outputHexString(Char *data, UInt16 len)
{
    UInt16   loop;
    UInt8   *dat;
    Char     buff[12], *buffer;

    buffer = MemPtrNew(len * 3 + MARGIN);
    if (buffer == NULL)
    {
         // ̈mێsA\I
         return (NULL);
    }
    MemSet(buffer, (len * 3 + MARGIN), 0x00);

    // lf[^ʕ\
    dat = data;
    for (loop = 0; loop < len; loop++)
    {
        if ((loop % 8) == 0)
        {
            // f[^WÂ؂
            StrCat(buffer, "\n");            
        } 
        MemSet (buff, sizeof(buff), 0x00);
        StrIToH(buff, *dat);
        StrCat(buffer, &buff[6]);
        dat++;
    }
    return (buffer);
}


/*-------------------------------------------------------------------------*/
/*   Function :  getStringListData                                         */
/*                        ꗗʂ̑wvf[^(XgO)擾 */
/*-------------------------------------------------------------------------*/
static Char *getStringListData(void)
{
    MemHandle  memH, memH2;
    UInt16     len;
    Char      *ptr, *ptr2, *data;

    // XgO\[X擾
    memH = DmGetResource('tSTR', HELPSTRING_LIST);
    if (memH == 0)
    {
        // \[X̎擾sANULL
        return (NULL);
    }
    ptr = MemHandleLock(memH);
    if (ptr == NULL)
    {
        // \[X̎擾sANULL
        return (NULL);
    }
    len = StrLen(ptr);
    
    // XgO\[X擾
    ptr2  = NULL;
    memH2 = DmGetResource('tSTR', HELPSTRING_LIST2);
    if (memH2 != 0)
    {
        ptr2 = MemHandleLock(memH2);
        if (ptr2 != NULL)
        {
            len = len + StrLen(ptr2);
        }
    }

    // f[^̊i[̈mۂA\[Xf[^Rs[
    // iŊmۂ̈́AnnDAIɉj
    data = MemPtrNew(len + MARGIN);
    if (data == NULL)
    {
        return (NULL);
    }
    MemSet (data, (len + MARGIN), 0x00);
    StrCopy(data, ptr);
    if (ptr2 != NULL)
    {
        StrCat(data, ptr2);
    }
    MemHandleUnlock(memH2);
    MemHandleUnlock(memH);

    return (data);
}

/*-------------------------------------------------------------------------*/
/*   Function :  getStringData                                             */
/*                                  wvf[^(XgO)擾 */
/*-------------------------------------------------------------------------*/
static Char *getStringData(UInt16 rscID)
{
    MemHandle  memH;
    UInt16     len;
    Char      *ptr, *data;

    // XgO\[X擾
    memH = DmGetResource('tSTR', rscID);
    if (memH == 0)
    {
        // \[X̎擾sANULL
        return (NULL);
    }
    ptr = MemHandleLock(memH);
    if (ptr == NULL)
    {
        // \[X̎擾sANULL
        return (NULL);
    }
    len = StrLen(ptr);

    // f[^̊i[̈mۂA\[Xf[^Rs[
    // iŊmۂ̈́AnnDAIɉj
    data = MemPtrNew(len + 4);
    if (data == NULL)
    {
        return (NULL);
    }
    MemSet (data, (len + 4), 0x00);
    StrCopy(data, ptr);

    MemHandleUnlock(memH);

    return (data);
}

/*-------------------------------------------------------------------------*/
/*   Function :  checkDisplayMode                                          */
/*                           ʃ[h(PalmOS5𑜓xT|[g)̃`FbN */
/*-------------------------------------------------------------------------*/
static void checkDisplayMode(nnDADataType *adtP)
{
    UInt32 version;
#ifdef USE_CLIE
    Err     ret;
    Boolean isColor;
    UInt32  width, height, depth;
#endif

    adtP->os5density = (UInt32) kDensityLow;

    // 𑜓xtB[`[̎擾
    if (FtrGet(sysFtrCreator, sysFtrNumWinVersion, &(version)) != 0)
    {
        // 𑜓xtB[`[̃T|[gȂ
        return;
    }
    if (version < 4)
    {
        //@𑜓x̃T|[gȂꍇ̏
        //  (Ő񂾂낤...}jAɂ͂Ă...)
#ifdef USE_CLIE
        // CLIEp𑜓xT|[gĂ邩`FbN    
        // HRLIB̎QƔԍ擾
        ret = SysLibFind(sonySysLibNameHR, &(adtP->hrRef));
        if (ret == sysErrLibNotFound)
        {
            // HRLIB[h̏ꍇA[hł邩TryĂ݂B
            ret = SysLibLoad('libr', sonySysFileCHRLib, &(adtP->hrRef));
        }
        if (ret != errNone)
        {
            // HRLIB͎gpłȂAW𑜓xg
            adtP->hrRef = 0;
            return;
        }

        // HRLIB̎gp錾HRLIB̃o[Wԍ擾
        HROpen(adtP->hrRef);
        HRGetAPIVersion(adtP->hrRef, &(adtP->hrVer));
        if (adtP->hrVer < HR_VERSION_SUPPORT_FNTSIZE)
        {
            // o[W̃nC]...ʃ[hmF...
            ret = HRWinScreenMode(adtP->hrRef, winScreenModeGet, 
                                  &width, &height, &depth, &isColor);
            if ((ret != errNone)||(width != hrWidth))
            {
                // nC][hł͂Ȃ̂ŁAHRLIB͎gpȂ
                HRClose(adtP->hrRef);
                adtP->hrRef = 0;
                return;
            }
        }
#endif // #ifdef USE_CLIE
        return;
    }

    // Window̉𑜓x擾
    WinScreenGetAttribute(winScreenDensity, &(adtP->os5density));

    // Ƃ肠AW𑜓xɂĂ
    WinSetCoordinateSystem(kCoordinatesStandard);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :  nnDA_EventHandler                                         */
/*                                                   nnDA  event     */
/*-------------------------------------------------------------------------*/
static Boolean nnDA_EventHandler(EventPtr evP)
{
    UInt16        btnId = 0;
    Boolean       mov;
    nnDADataType *adtP = NULL;
    FormType     *frm;
    ControlType  *obj;

    // global pointer擾
    if (FtrGet(nnDA_Creator, ADT_FTRID, (UInt32 *) &adtP) != 0)
    {
        // O[o|C^擾s
        return (false);
    }

    // VtgCWP[^mF
    frm = FrmGetActiveForm();
    obj = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_SHIFT));
    mov = CtlEnabled(obj);

    switch (evP->eType)
    {
      case keyDownEvent:
        switch (evP->data.keyDown.chr)
        {
          // JOG PUSH/ZL[Ƃ̏
          case vchrJogRelease:
          case vchrThumbWheelPush:
          case chrCapital_Z:
          case chrSmall_Z:
            // ㉺ړ[hEEړ[h̐؂ւs
            btnId = BTNID_SHIFT;
            break;

          case vchrPageDown:
          case chrDownArrow:
          case vchrJogDown:
          case chrCapital_J:
          case chrSmall_J:
            // XN[
            if (mov == true)
            {
                // Eړ[h(EXN[)
                btnId = BTNID_NEXT;
            }
            else
            {
                // ㉺ړ[h(XN[)
                btnId = BTNID_DOWN;
            }
            break;

          case vchrPageUp:
          case chrUpArrow:
          case vchrJogUp:
          case chrCapital_K:
          case chrSmall_K:
            if (mov == true)
            {
                // Eړ[h(EXN[)
                btnId = BTNID_PREV;
            }
            else
            {
                // ㉺ړ[h(XN[)
                btnId = BTNID_UP;
            }
            break;

          case vchrJogLeft:
          case chrLeftArrow:
          case vchrJogPushedUp:
          case chrCapital_H:
          case chrSmall_H:
            // XN[
            btnId = BTNID_PREV;
            break;

          case vchrJogRight:
          case chrRightArrow:
          case vchrJogPushedDown:
          case chrCapital_L:
          case chrSmall_L:
            // EXN[
            btnId = BTNID_NEXT;
            break;

          case chrCapital_Q:
          case chrSmall_Q:
            // njƂɂ
            CtlHitControl(FrmGetObjectPtr(FrmGetActiveForm(),
                                          FrmGetObjectIndex(FrmGetActiveForm(),
                                          BTNID_DA_OK)));
            return (false);
            break;
            
          case chrBackspace:
          case chrEscape:
            // About\
            btnId = BTNID_DA_ABOUT;
            break;

          case vchrNavChange:
            // 5way navigatorΉ
            if ((evP->data.keyDown.keyCode) & navBitLeft)
            {
                // J[\L[Ɠ(XN[)
                btnId = BTNID_PREV;
                break;
            }
            if ((evP->data.keyDown.keyCode) & navBitRight)
            {
                // J[\L[EƓ(EXN[)
                btnId = BTNID_NEXT;
                break;
            }
            break;
           
          case chrSpace:
          case chrCarriageReturn:
          case chrLineFeed:
          default:
            // Ȃ
            return (false);
            break;
        }
        break;

      case ctlSelectEvent:
        // Ƃŏ
        btnId = evP->data.ctlSelect.controlID;
        break;
        
      case ctlRepeatEvent:
        // Ƃŏ
        btnId = evP->data.ctlRepeat.controlID;

      default:
        // Ȃ
        return (false);
        break;
    }

    // {^ꂽƂ̏
    switch (btnId)
    {
      case BTNID_DA_ABOUT:
        // About\
        FrmAlert(ALERTID_DA_ABOUT);
        break;

      case BTNID_UP:
        // ړ
        if (adtP->startY > 0)
        {
            adtP->startY = adtP->startY - (adtP->area.extent.y / 2);
        }
        break;      

      case BTNID_DOWN:
        // ړ
        if (adtP->startY < adtP->maxY)
        {
            adtP->startY = adtP->startY + (adtP->area.extent.y / 2);
        }
        break;

      case BTNID_PREV:
        // O(ړ)
        if (adtP->startX > 0)
        {
            adtP->startX = adtP->startX - (adtP->area.extent.x / 2);
        }
        break;

      case BTNID_NEXT:
        // (Eړ)
        if (adtP->startX < adtP->maxX)
        {
            adtP->startX = adtP->startX + (adtP->area.extent.x / 2);
        }
        break;

      case BTNID_SHIFT:
        // VtgԐ؂ւ
        // ON/OFF؂ւA"!"̕\؂ւ
        if (mov == true)
        {
            // Eړ[h㉺ړ[h(!)
            CtlSetEnabled(obj, false);
            CtlSetUsable (obj, false);
            FrmHideObject(frm, FrmGetObjectIndex(frm, BTNID_SHIFT));                
        }
        else
        {
            // ㉺ړ[hEړ[h(!\)
            CtlSetEnabled(obj, true);
            CtlSetUsable (obj, true);
            FrmShowObject(frm, FrmGetObjectIndex(frm, BTNID_SHIFT));   
        }
        break;

      default:
        // Ȃ
        return (false);
        break;
    }
    // ʂĕ`
#ifdef USE_CLIE
    if (adtP->hrRef != 0)
    {
        startClieDisp_DAData(FrmGetActiveForm(), adtP);
        setClieDisp_DAData  (FrmGetActiveForm(), adtP);
        resetClieDisp_DAData(FrmGetActiveForm(), adtP);
    }
    else
#endif
    {
        setDisp_nnDA_DAData  (FrmGetActiveForm(), adtP);
        setnnDA_DAData       (FrmGetActiveForm(), adtP);
        resetDisp_nnDA_DAData(FrmGetActiveForm(), adtP);
    }
    return (true);
}

#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :  startClieDisp_DAData                                      */
/*                                              `惂[hݒ菈(CLIEp) */
/*-------------------------------------------------------------------------*/
static void startClieDisp_DAData(FormType *frm, nnDADataType *adtP)
{

    // drawȂƁAWindowɗ̈悪\ȂAAA
    FrmDrawForm(frm);

    // KWFbg̗̈TCY擾
    FrmGetObjectBounds(frm,
                       FrmGetObjectIndex(frm, GADID_DA_VIEW),
                       &(adtP->dimF));

    // CLIE𑜓xpɕ`GAg傷
    adtP->area.topLeft.x  = adtP->dimF.topLeft.x * 2;
    adtP->area.extent.x   = adtP->dimF.extent.x  * 2;
    adtP->area.extent.y   = adtP->dimF.extent.y  * 2;
    adtP->area.topLeft.y  = adtP->dimF.topLeft.y * 2;

    // `̈̃NA
    HRWinEraseRectangle(adtP->hrRef, &(adtP->area), 0);

    return;
}
#endif  // #ifdef USE_CLIE


#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :  resetClieDisp_nnDA_DAData                                 */
/*                                            ʕ\̌㏈(CLIEp) */
/*-------------------------------------------------------------------------*/
static void resetClieDisp_DAData(FormType *frm, nnDADataType *adtP)
{

    return;
}
#endif // #ifdef USE_CLIE

#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :  endClieDisp_DAData                                        */
/*                                                  ʕ`㏈(CLIEp) */
/*-------------------------------------------------------------------------*/
static void endClieDisp_DAData(FormType *frm, nnDADataType *adtP)
{

    return;
}
#endif // #ifdef USE_CLIE


/*-------------------------------------------------------------------------*/
/*   Function :  setDisp_nnDA_DAData                                       */
/*                                            ʂɕ\t鏈 */
/*-------------------------------------------------------------------------*/
static void setDisp_nnDA_DAData(FormType *frm, nnDADataType *adtP)
{

    // drawȂƁAWindowɗ̈悪\ȂAAA
    FrmDrawForm(frm);

    // KWFbg̗̈TCY擾
    FrmGetObjectBounds(frm,FrmGetObjectIndex(frm, GADID_DA_VIEW),
                                                               &(adtP->dimF));

    // 𑜓x[hmFÄNA(areaɎ𑜓xi[)
    switch (adtP->os5density)
    {
      case kDensityDouble:
        // 320x320
        adtP->area.topLeft.x  = adtP->dimF.topLeft.x * 2;
        adtP->area.extent.x   = adtP->dimF.extent.x  * 2;
        adtP->area.extent.y   = adtP->dimF.extent.y  * 2;
        adtP->area.topLeft.y  = adtP->dimF.topLeft.y * 2;
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        break;

      case kDensityTriple:
        // 480x480
        adtP->area.topLeft.x  = adtP->dimF.topLeft.x * 3;
        adtP->area.extent.x   = adtP->dimF.extent.x  * 3;
        adtP->area.extent.y   = adtP->dimF.extent.y  * 3;
        adtP->area.topLeft.y  = adtP->dimF.topLeft.y * 3;
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        break;

      case kDensityQuadruple:
        // 640x640
        adtP->area.topLeft.x  = adtP->dimF.topLeft.x * 4;
        adtP->area.extent.x   = adtP->dimF.extent.x  * 4;
        adtP->area.extent.y   = adtP->dimF.extent.y  * 4;
        adtP->area.topLeft.y  = adtP->dimF.topLeft.y * 4;
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        break;

      case kDensityOneAndAHalf:
        // 240x240
        adtP->area.topLeft.x  = adtP->dimF.topLeft.x * 2 / 3;
        adtP->area.extent.x   = adtP->dimF.extent.x  * 2 / 3;
        adtP->area.extent.y   = adtP->dimF.extent.y  * 2 / 3;
        adtP->area.topLeft.y  = adtP->dimF.topLeft.y * 2 / 3;
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()),kDensityLow);
        WinSetCoordinateSystem(kCoordinatesNative);
        break;

      case kDensityLow:
      default:
        // 160x160
        adtP->area.topLeft.x  = adtP->dimF.topLeft.x;
        adtP->area.extent.x   = adtP->dimF.extent.x;
        adtP->area.extent.y   = adtP->dimF.extent.y;
        adtP->area.topLeft.y  = adtP->dimF.topLeft.y;
        break;
    }
    // `̈̃NA
    WinEraseRectangle(&(adtP->area), 0);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :  resetDisp_nnDA_DAData                                     */
/*                                    ʂɕ\t鏈̌㏈ */
/*-------------------------------------------------------------------------*/
static void resetDisp_nnDA_DAData(FormType *frm, nnDADataType *adtP)
{
    // 𑜓x̐ݒ
    switch (adtP->os5density)
    {
      case kDensityDouble:
      case kDensityQuadruple:
      case kDensityTriple:
      case kDensityOneAndAHalf:
        BmpSetDensity(WinGetBitmap(WinGetDisplayWindow()), adtP->os5density);
        WinSetCoordinateSystem(kCoordinatesStandard);
        break;

      case kDensityLow:
      default:
        break;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :  endnnDA_DAData                                            */
/*                                    ʂɕ\t鏈̌㏈ */
/*-------------------------------------------------------------------------*/
static void endnnDA_DAData(FormType *frm, nnDADataType *adtP)
{
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :  setnnDA_DAData                                            */
/*                                            ʂɕ\t鏈 */
/*-------------------------------------------------------------------------*/
static void setnnDA_DAData(FormType *frm, nnDADataType *adtP)
{
    UInt16  letter;
    UInt8  *ptr, upper, lower;
    Coord   x, y, topX;

    ptr  = adtP->areaP;
    topX = 0;
    x    = 0;
    y    = 0;
    while ((UInt8 *) ptr < adtP->areaP + adtP->length)
    {
        // w肳ꂽR[h\
        if ((*ptr == 0x0a)||(*ptr == 0x0d))
        {
            if ((*ptr == 0x0d)&&(*(ptr + 1) == 0x0a))
            {
                // sR[hbq{keꍇ
                ptr++;
            }

            // sR[ĥƂ
            y = y + FntCharHeight();
            adtP->maxY = y;
            x = topX;
            ptr++;
            if (y >= adtP->startY + adtP->area.extent.y)
            {
                // `̈敝𒴂AI
                break;
            }
            continue;
        }
        //  or ANK ?
        if ((*ptr <= 0x80)||((*ptr >= 0xa1)&&(*ptr <= 0xdf)))
        {            
            // VOoCg̏ꍇ
            letter = *ptr;
            ptr++;
            if ((letter >= 0x20)&&(x >= adtP->startX)&&(y >= adtP->startY)&&
                (x < adtP->startX + adtP->area.extent.x)&&
                (y < adtP->startY + adtP->area.extent.y))
            {
                WinDrawChar(letter, 
                            (x - adtP->startX + adtP->area.topLeft.x),
                            (y - adtP->startY + adtP->area.topLeft.y));
            }
            x = x + 6; // 6́AFntCharWidth() ̑
           adtP->maxX = x;
        }
        else
        {            
            // _uoCg̏ꍇAJISR[hɕϊĂ
            // 8rbg/8rbgϐɃRs[
            upper   = *ptr;
            letter  = *ptr << 8;
            ptr++;
            lower   = *ptr;
            letter  = letter + *ptr;
            ptr++;
            if (upper <= 0x9f)
            {
                if (lower < 0x9f)
                {
                    upper = (upper << 1) - 0xe1;
                }
                else
                {
                    upper = (upper << 1) - 0xe0;
                }
            }
            else
            {
                if (lower < 0x9f)
                {
                    upper = ((upper - 0xb0) << 1) - 1;
                }
                else
                {
                    upper = ((upper - 0xb0) << 1);
                }
            }
            if (lower < 0x7f)
            {
                lower = lower - 0x1f;
            }
            else
            {
                if (lower < 0x9f)
                {
                    lower = lower - 0x20;
                }
                else
                {
                    lower = lower - 0x7e;
                }
            }

            if ((x >= adtP->startX)&&(y >= adtP->startY)&&
                (x < adtP->startX + adtP->area.extent.x)&&
                (y < adtP->startY + adtP->area.extent.y))
            {
                WinDrawChar(letter, 
                             (x - adtP->startX + adtP->area.topLeft.x),
                             (y - adtP->startY + adtP->area.topLeft.y));
            }            

            letter = upper << 8;
            letter = lower + letter;
            x = x + 12; // 12́AFntWCharWidth() ̑ 
            adtP->maxX = x;
        }
    }

    return;
}
#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :  setClieDisp_DAData                                        */
/*                                    ʂɕ\t鏈(CLIEp) */
/*-------------------------------------------------------------------------*/
static void setClieDisp_DAData(FormType *frm, nnDADataType *adtP)
{
    UInt16  letter;
    UInt8  *ptr, upper, lower;
    Coord   x, y, topX;

    ptr  = adtP->areaP;
    topX = 0;
    x    = 0;
    y    = 0;
    while ((UInt8 *) ptr < adtP->areaP + adtP->length)
    {
        // w肳ꂽR[h\
        if ((*ptr == 0x0a)||(*ptr == 0x0d))
        {
            if ((*ptr == 0x0d)&&(*(ptr + 1) == 0x0a))
            {
                // sR[hbq{keꍇ
                ptr++;
            }

            // sR[ĥƂ
            y = y + FntCharHeight();
            adtP->maxY = y;
            x = topX;
            ptr++;
            if (y >= adtP->startY + adtP->area.extent.y)
            {
                // `̈敝𒴂AI
                break;
            }
            continue;
        }
        //  or ANK ?
        if ((*ptr <= 0x80)||((*ptr >= 0xa1)&&(*ptr <= 0xdf)))
        {            
            // VOoCg̏ꍇ
            letter = *ptr;
            ptr++;
            if ((letter >= 0x20)&&(x >= adtP->startX)&&(y >= adtP->startY)&&
                (x < adtP->startX + adtP->area.extent.x)&&
                (y < adtP->startY + adtP->area.extent.y))
            {
                HRWinDrawChar(adtP->hrRef,
                              letter, 
                              (x - adtP->startX + adtP->area.topLeft.x),
                              (y - adtP->startY + adtP->area.topLeft.y));
            }
            x = x + 6; // 6́AFntCharWidth() ̑
            adtP->maxX = x;
        }
        else
        {            
            // _uoCg̏ꍇAJISR[hɕϊĂ
            // 8rbg/8rbgϐɃRs[
            upper   = *ptr;
            letter  = *ptr << 8;
            ptr++;
            lower   = *ptr;
            letter  = letter + *ptr;
            ptr++;
            if (upper <= 0x9f)
            {
                if (lower < 0x9f)
                {
                    upper = (upper << 1) - 0xe1;
                }
                else
                {
                    upper = (upper << 1) - 0xe0;
                }
            }
            else
            {
                if (lower < 0x9f)
                {
                    upper = ((upper - 0xb0) << 1) - 1;
                }
                else
                {
                    upper = ((upper - 0xb0) << 1);
                }
            }
            if (lower < 0x7f)
            {
                lower = lower - 0x1f;
            }
            else
            {
                if (lower < 0x9f)
                {
                    lower = lower - 0x20;
                }
                else
                {
                    lower = lower - 0x7e;
                }
            }

            if ((x >= adtP->startX)&&(y >= adtP->startY)&&
                (x < adtP->startX + adtP->area.extent.x)&&
                (y < adtP->startY + adtP->area.extent.y))
            {
                HRWinDrawChar(adtP->hrRef,
                              letter, 
                              (x - adtP->startX + adtP->area.topLeft.x),
                              (y - adtP->startY + adtP->area.topLeft.y));
            }            

            letter = upper << 8;
            letter = lower + letter;
            x = x + 12; // 12́AFntWCharWidth() ̑ 
            adtP->maxX = x;
        }
    }
    return;
}
#endif // #ifdef USE_CLIE

/*=========================================================================*/
/*   Function :  nnDAMain                                                  */
/*                                                        DAf[^\ */
/*=========================================================================*/
void nnDAMain(void)
{
    FontID        fontId;
    UInt16        result, size, len;
    MemHandle     memH;
    Char         *areaP, *ptr, *infoName, *infoData;
    FormType     *diagFrm, *prevFrm;
    nnDADataType *adtP;

    UInt16        objIndex;
    Coord         x, y, diffX, diffY;
    RectangleType r;

    // ݂̃tH[擾
    prevFrm = FrmGetActiveForm();

    // Lf[^̊m
    size = sizeof(nnDADataType) + MARGIN;
    adtP = MemPtrNew(size);
    if (adtP == NULL)
    {
        // ̈mێsAI
        return;
    }
    MemSet(adtP, size, 0x00);
    StrNCopy(adtP->title, nnDA_DEFTITLE, nnDA_TITLESIZE);
    infoData  = NULL;
    areaP     = NULL;
    ptr       = NULL;

    // tHgTCYꎞIɕύX
    fontId = FntGetFont();
    FntSetFont(stdFont);

    // global pointerfeatureƂăZbg
    FtrSet(nnDA_Creator, ADT_FTRID, (UInt32) adtP);

    //  ʃ[h̃`FbN
    checkDisplayMode(adtP);

    // Viewer Form̏
    diagFrm = FrmInitForm(FRMID_DA_VIEWER);
    FrmSetActiveForm(diagFrm);

    /* ŜWindowTCY擾 */
    WinGetDisplayExtent(&x, &y);

    /* dialog̃TCY */
    FrmGetFormBounds(diagFrm, &r);

    /* dialog̊g */
    r.topLeft.x = 2;
    r.topLeft.y = 5;
    diffX = r.extent.x;
    diffY = r.extent.y;
    r.extent.y = y - 5;
    r.extent.x = x - 4;
    
    diffX = r.extent.x - diffX;
    diffY = r.extent.y - diffY;
    WinSetWindowBounds(FrmGetWindowHandle(diagFrm), &r);

    /* OK {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_DA_OK);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    /*  {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_UP);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    /*  {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_PREV);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    /* E {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_NEXT);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    /*  {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_DOWN);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    /* SHIFT {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_SHIFT);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    // ĺA㉺ړ[hɐݒ
    CtlSetEnabled(FrmGetObjectPtr(diagFrm, objIndex), false);
    CtlSetUsable (FrmGetObjectPtr(diagFrm, objIndex), false);
    FrmHideObject(diagFrm, objIndex);                

    /* About {^̈ړ */
    objIndex = FrmGetObjectIndex(diagFrm, BTNID_DA_ABOUT);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    // r.topLeft.x = r.topLeft.x + diffX;
    r.topLeft.y = r.topLeft.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    /* gadget̊g */
    objIndex = FrmGetObjectIndex(diagFrm, GADID_DA_VIEW);
    FrmGetObjectBounds(diagFrm, objIndex, &r);
    r.extent.x = r.extent.x + diffX;
    r.extent.y = r.extent.y + diffY;
    FrmSetObjectBounds(diagFrm, objIndex, &r);

    // Viewer Form̃Cxgnho^
    FrmSetEventHandler(diagFrm, nnDA_EventHandler);

    ////////////////////////////////////////////////////////////
    //  f[^̉ʐݒ菈
    //   (Nbv{[hɂf[^擾\)
    memH = ClipboardGetItem(clipboardText, &len);
    if ((len != 0)&&(memH != 0))
    {
        areaP = MemHandleLock(memH);
        if (areaP != NULL)
        {
            ///////////////////// NNsiƂ̘Ag 
            if (StrNCompare(areaP, nnDA_NNSIEXT_VIEWSTART, StrLen(nnDA_NNSIEXT_VIEWSTART)) == 0)
            {
                // f[^tH[𒊏o
                ptr = StrStr(areaP, nnDA_NNSIEXT_INFONAME);
                if (ptr != NULL)
                {
                    // f[^񖼂؂o
                    ptr = ptr + StrLen(nnDA_NNSIEXT_INFONAME);
                    infoName = MemPtrNew(BUFSIZE);
                    if (infoName != NULL)
                    {
                        MemSet(infoName, BUFSIZE, 0x00);
                        infoData = infoName;
                        while ((*ptr != '<')&&(ptr < areaP + len))
                        {
                            *infoData = *ptr;
                            ptr++;
                            infoData++;
                        }
                        // \ׂ̎擾
                        infoData = getInformation(infoName, adtP->title, nnDA_TITLESIZE);
                        if (infoData != NULL)
                        {
                            // \f[^̐ݒ
                            areaP = infoData;          // 
                            len   = StrLen(infoData);  // 
                        }
                        // 񖼗̈̉
                        MemPtrFree(infoName);
                        infoName = NULL;
                    }
                }
            }
            ///////////////////// NNsiƂ̘Ag ܂

            // `f[^̃|C^L
            adtP->areaP  = areaP;
            adtP->length = len;

#ifdef USE_CLIE
            if (adtP->hrRef != 0)
            {
                startClieDisp_DAData(diagFrm, adtP);  //  ʕ\
                setClieDisp_DAData  (diagFrm, adtP);  //  f[^\
                resetClieDisp_DAData(diagFrm, adtP);  //  ʕ\㏈
            }
            else
#endif  // #ifdef USE_CLIE
            {
                setDisp_nnDA_DAData  (diagFrm, adtP);  //  ʕ\
                setnnDA_DAData       (diagFrm, adtP);  //  f[^\
                resetDisp_nnDA_DAData(diagFrm, adtP);  //  ʕ\㏈
            }
        }
    }
    ////////////////////////////////////////////////////////////

    // tH[̃^CgRs[
    FrmCopyTitle(diagFrm, adtP->title);

    // Dialog\
    result = FrmDoDialog(diagFrm);
    if (result == BTNID_DA_OK)
    {
        // OK{^ꂽAAAǁA͕KOKŔ͂
    }
    
    ////////////////////////////////////////////////////////////
    //  f[^̉ʐݒ̌㏈
    //
#ifdef USE_CLIE
    if (adtP->hrRef != 0)
    {
        endClieDisp_DAData(diagFrm, adtP);
    }
    else
#endif  // #ifdef USE_CLIE
    {
        endnnDA_DAData(diagFrm, adtP);
    }
    //
    ////////////////////////////////////////////////////////////

    // tHgTCYɖ߂
    FntSetFont(fontId);            

    // Nbv{[ḧJ
    if (memH != 0)
    {
        MemHandleUnlock(memH);
    }

    // e|f[^obt@
    if (infoData != NULL)
    {
        MemPtrFree(infoData);
    }

    // tH[global pointeřn
    FrmSetActiveForm(prevFrm);
    FrmDeleteForm(diagFrm);

    FtrUnregister(nnDA_Creator, ADT_FTRID);
    MemPtrFree(adtP);
}
