

var _callTypes = ["メニューに設定","CELL に設定"];

function act_add(array){
    var sum = 0;
    for (num in array){
        sum += array[num] * 1;
    }
    return sum;
}

function callHelp(){
	// 別途ヘルプをパネル表示
	window.open("./callHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

/////////////////////////////////////////////////////////////////
///// 編集パネル /////////////////////////////////////////////////

function savedCalls(){
    closeFloatPanel();
}
function saveCalls(){
    // 編集された call をサーバへ保存
    var st = elmFor("typePop").value;
    var type = (st == _callTypes[0]) ? 0 : 1;
    var name = elmFor("nameF").value;
    var calls = elmFor("textF").value;
    
    if (name.length == 0){
        alert("名前が設定されていません");
        return;
    } else if (calls.length == 0){
        alert("call が空です");
        return;
    }
    
    setCalls(null); // サーバから再読み込みスタンバイ: dataCenter.js
    NRPutCalls(owner(), type, name, calls, savedCalls);
}

function removeCalls(){
    // 現在表示されている一括処理を削除
    var name = elmFor("nameF").value;
    if (name.length == 0){
        alert("名前が空なので削除できません");
        return;
    }
    
    // calls が null の場合は削除になる
    setCalls(null); // サーバから再読み込みスタンバイ: dataCenter.js
    NRPutCalls(owner(), null, name, null, savedCalls);
}

function selectedCallsMenu(elm){
    // 編集パネルのポップアップが選択された
    var menu = elm.value;
    var obj = calls()[menu]; // obj={"type":[0,1],"value":"script"}
    var type = (obj) ? obj.type : 0; 
    
    var sp = elmFor("typePopArea");
    sp.innerHTML = "";
    var pu = newPopupMenu(sp, "typePop", _callTypes, _callTypes[type]);
    
    elmFor("nameF").value = menu;
    elmFor("textF").value = (obj) ? obj.value : "";
}
function openCallEditor(){
    // call のシナリオを作成するパネルを開く
    var x = 20;
    var y = 20;
    var w = 310;
    var title = "動作一括処理 編集パネル";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, "callHelp()", null);
    if (!elm) return;
    
    var div = newDIV(elm, "");
    var obj = calls(); // dataCenter.js
    var menus = allKeys(obj);
    menus.splice(0, 0, "");
    var pu = newPopupMenu(div, "", menus, "");
    pu.setAttribute("onchange", "selectedCallsMenu(this)");
    
    var div = newDIV(elm, "");
    div.style.fontSize = "10pt";
    var sp = newSPAN(div, "typePopArea");
    var pu = newPopupMenu(sp, "typePop", _callTypes, "");
    var value = "";
    var name = "";
    var fd = newFIELD(div, "nameF", "", 30, name);
    fd.setAttribute("placeholder", "この一括処理につける名前"); // 入力ヒントを表示
    fd.focus();
    
    var div = newDIV(elm, "");
    var value = "";
    var ta = newTEXTAREA(div, "textF", 40, 5, value);
    
    var div = newDIV(elm, "");
    div.style.textAlign = "right";
    div.style.padding = "5px";
    var bt = newDIV(div, "/whiteButton");
    bt.innerHTML = "この一括処理を削除";
    bt.setAttribute("onclick", "removeCalls()");
    var bt = newDIV(div, "/fixButton");
    bt.innerHTML = "保存";
    bt.setAttribute("onclick", "saveCalls()");
}

///// 編集パネル /////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////
///// 動作一括処理パネル ///////////////////////////////////////////

function selectCallsMenu(elm){
    // メニューが選択された
    var menu = elm.innerText;
    var buff = calls()[menu].value; // dataCenter.js
    var array = buff.split("\n");
    for (num in array){
        var st = array[num];
        // call 一括動作は "actor|parameter|receiver" 型式で記述
        var ary = st.split('|');
        var actor = trim(ary[0]);
        var parameter = (ary[1]) ? trim(ary[1]) : null;
        var receiver = (ary[2]) ? trim(ary[2]) : null;
        
        call(actor, parameter, receiver);
    }
    closeFloatPanel();
}

function showCalls(){
    // calls のポップアップを表示
    var elm = elmFor("callsPop");
    elm.innerHTML = "";

    var recs = calls();
    for (menu in recs){
        var rec = recs[menu];
        if (rec.type > 0) continue; // CELL タイプはスキップし メニュー・タイプのみ表示
        
        var div = newDIV(elm, "");
        var bt = newDIV(div, "/blueButton");
        bt.innerHTML = menu;
        bt.setAttribute("onclick", "selectCallsMenu(this)");
    }
    
    var div = newDIV(elm, "");
    div.style.marginTop = "5px";
    div.style.fontSize = "9pt";
    var bt = newDIV(div, "/flatButton");
    bt.innerHTML = "メニューを編集";
    bt.setAttribute("onclick", "openCallEditor()");
}
function gotCalls(answer){
    // calls のポップアップを表示
    var obj = JSON.parse(answer);
    setCalls(obj); // dataCenter.js
    showCalls();
}
function openCalls(){
    // call 一括処理のメニューを表示
    //_initDebug(true); //##
    _debug("openCalls"); //##

    var x = 20;
    var y = 80;
    var w = 200;

    // アクティブなページ位置に合わせパネルを開く
    var elm = elmFor(currentDate() + ".page");
    if (elm){
        var pos = getPosition(elm);
        y += pos.y;
    }

    var title = "動作一括処理";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, "callHelp()", null);
    if (!elm) return;
    
    var div = newDIV(elm, "callsPop");
    div.style.padding = "5px";
    div.style.fontSize = "10pt";
    
    if (calls()) // dataCenter.js
        showCalls();
    else
        NRGetCalls(owner(), null, gotCalls);
}

///// 動作一括処理パネル ///////////////////////////////////////////
/////////////////////////////////////////////////////////////////
