
/////////////////////////////////////////////////////////////
///// Ajax //////////////////////////////////////////////////

var _patientId;
function gotConditionalInsFiles(answer){
    var obj = JSON.parse(answer);
    
    showResults(obj);
}
function getConditionalInsFiles(from, to){
    // from to の期間にコピーした保険証画像を検索
    document.getElementById("dataArea").innerHTML = "検索中：しばらくお待ちください";

    NRGetImagFileBetween(from, to, gotConditionalInsFiles);
}

function gotImage(answer){
    //alert("gotImage->"+answer); //##
    
    window.open(answer,"Image","width=900,height=630");
}
function getImage(elm, patientId, filename){
    // filename のイメージをリクエスト
    NRGetImageFile(patientId, filename, gotImage);
}

function closeMessage(){
    document.getElementById("_debug").innerHTML = "";
}
function removedImage(answer){
    //alert(answer); //##
    var elm = document.getElementById("_debug");
    elm.innerHTML = "";
    
    var div = newDIV(elm, "");
    div.style.color = "#00f";
    div.style.fontSize = "10pt";
    div.style.padding = "10pt 10pt";

    var dv = newDIV(div, "");
    dv.style.padding = "5px 5px";
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "5px";
    var img = newIMAGE(sp, "icon", "./close.png", "close");
    img.setAttribute("onclick", "closeMessage()");
    img.style.width = "12px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = "画像は以下のように処理されました（安全のため本格削除ではなく他へ移動）";

    var dv = newDIV(div, "");
    dv.style.paddingLeft = "20px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = answer; // for debug

    // コメントが見えるようにスクロール
    var pos = getPosition(dv);
    window.scroll(0, pos.y);
}
function removeImage(){
    // チェックした画像を削除
    var recs = new Array();
    for (var i=0; i < _rows; i++){ // for (i in _rows) は駄目
        var cb = document.getElementById(i + ".cb");
        if (cb.checked){
            var filename = document.getElementById(i + ".fname").innerHTML;
            
            recs.push(filename);
        }
    }
    var files = recs.join(",");
    
    NRRemoveFiles(files, removedImage);
}

///// Ajax //////////////////////////////////////////////////
/////////////////////////////////////////////////////////////

function changeAllChecks(elm){
    // 全てのチェックボックスのステータスをトグル式に変更
    var status = elm.checked;
    for (var i=0; i < _rows; i++){
        var sp = document.getElementById(i + ".cbArea");
        sp.innerHTML = "";
        var cb = newCHECKBOX(sp, "", "", status);
    }
}

var _rows;
function showResults(obj){
    // 検索結果を表示
    var elm = document.getElementById("dataArea");
    elm.innerHTML = "";
    
    _initDebug(true); //##
    //_debug("== showResults->"+encodeObject(obj)); //##
    
    if (obj.length == 0){
        var sp = newSPAN(elm, "");
        sp.innerHTML = "該当するものはありません";
        sp.style.color = "#f00";
        sp.style.padding = "5px 10px";
    } else {
        var tbl = newTABLE(elm, "/base-table");
        tbl.style.fontSize = "10pt";
        
        // タイトル
        var tr = newTR(tbl, "/yellow-bar", "");
        var td = newTD(tr, "label-left", "カルテID");
        td.style.width = "180px";
        var td = newTD(tr, "label-left", "最終受診日");
        var td = newTD(tr, "", "");
        var sp = newSPAN(td, "");
        sp.style.paddingRight = "5px";
        var cb = newCHECKBOX(sp, "", "", 0);
        cb.setAttribute("onchange", "changeAllChecks(this)");
        var sp = newSPAN(td, "");
        sp.innerHTML = "保険証画像ファイル名";
        
        // レコード
        _rows = 0;
        var count = 0;
        for (pid in obj){
            var rec = obj[pid];
            
            var tr = newTR(tbl, "", "");
            // カルテ ID
            tr.style.borderTop = "thin solid #ccc";
            var td = newTD(tr, "label-left", rec.pid + " " + rec.name);
            td.style.verticalAlign = "top";
            td.style.fontSize = "9pt";
            // 最終受診日
            var td = newTD(tr, "label-left", rec.lvd);
            td.style.verticalAlign = "top";
            td.style.fontSize = "9pt";
            
            // 保険証画像ファイル：複数表示
            var td = newTD(tr, "", "");
            var tbl2 = newTABLE(td, "/base-table");
            tbl2.style.fontSize = "9pt";
            for (num in rec.files){
                var filename = rec.files[num];
                var tr2 = newTR(tbl2, "/record", "");
                var td2 = newTD(tr2, "", "");
                var sp = newSPAN(td2, _rows + ".cbArea");
                sp.style.paddingRight = "5px";
                var cb = newCHECKBOX(sp, _rows + ".cb", "", 0);
                var sp = newSPAN(td2, _rows + ".fname");
                sp.innerHTML = filename;
                var action = "getImage(this,'"+rec.pid+"','"+filename+"')";
                sp.setAttribute("onclick", action);
                _rows++;
            }
            count++;
        }
        
        var tr = newTR(tbl, "yellow-bar", "");
        var td = newTD(tr, "label-left", count + " 名");
        var td = newTD(tr, "", "");
        var td = newTD(tr, "", "");
        var bt = newDIV(td, "/fixButton");
        bt.innerHTML = "チェックした画像を削除";
        bt.setAttribute("onclick", "removeImage()");
        bt.style.padding = "3px 10px";
    }
}

function search(){
    // 指定された期間にコピーした保険証画像を検索
    var from = "";
    var val = document.getElementById("fromPop").value;
    var array = val.split("-");
    if (array.length == 3){
        from = val + " 00:00:00";
    }
    
    var to = "";
    var val = document.getElementById("toPop").value;
    var array = val.split("-");
    if (array.length == 3){
        to = val + " 23:59:59";
    }
    
    if (!from && !to){
        alert("年月日が指定されていません");
    } else {
        if (from == "")
            from = "0000-00-00 00:00:00";
        if (to == "")
            to = todayAndTime();
        getConditionalInsFiles(from, to);
    }
}

function help(){
	window.open("./fileCleanerHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initFileCleaner(){
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
	// === HEADER ======================================
    var div = newDIV(elm, "/yellow-header");
    var dv = newDIV(div, "/left-side");
    dv.style.width = "90%";
    
    // from popup
    var array = today().split("-");
    var yyyy = array[0] - 3;
    var mm = 1;
    var dd = 1;
    var pm = newDatePopUp(dv, "fromPop", "", yyyy, mm, dd, false, null);
    //
    var sp = newSPAN(dv, "");
    sp.style.padding = "0px 5px";
    sp.innerHTML = "から";
    // to popup
    var yyyy = array[0];
    var mm = array[1];
    var dd = array[2];
    var pm = newDatePopUp(dv, "toPop", "", yyyy, mm, dd, false, null);
    //
    var sp = newSPAN(dv, "");
    sp.style.padding = "0px 5px";
    sp.innerHTML = "までの保険証画像を";
    // button
    var bt = newBUTTON(dv, "", "リストアップ");
    bt.setAttribute("onclick", "search()");

    // HELP
	var dv = newTD(div, "/right-side", "");
	var im = newIMAGE(dv, "", "./Help.png", "?");
	im.setAttribute("onclick", "help()");
	im.style.height = "18px";

	// === データ表示エリア ===============================
    var div = newDIV(elm, "dataArea");
    div.style.padding = "5px 5px";
    div.style.fontSize = "10pt";
    var sp = newSPAN(div, "");
    sp.innerHTML = "一定期間にコピーした保険証をリストアップし確認後「削除」します";
	
	// === FOOTER ======================================
    var div = newDIV(elm, "/yellow-footer");
    var sp = newSPAN(div, "/left-side");
    sp.innerHTML = version();
}

function version(){
	return "Ver.130914";
}
