
/////
///// noa.js は NOA 外郭を司るカルテ・ホルダーのようなもの
///// 個々のカルテ記述は chart.js クラスが司る
/////

//////////////////////////////////////////////////////////////
///// URL で受け取るパラメータ //////////////////////////////////

function suppliedPatientId(){
    // URL で与えられた patientId
    return document.getElementById("_pid").value;
}

function addPageFlag(){
    // URL で与えられた「新規ページ追加ステータス」
    return (document.getElementById("_addPage").value)
        ? true : false;
}


//////////////////////////////////////////////////////////////
///// POLLING ////////////////////////////////////////////////

function pollingWORK(){
    // 受付の患者登録を Worker を使い裏プロセスの polling でチェック
    // DB とのやりとりや polling は polling.js で設定
    var obj = new Object();
    obj["dateTime"] = today();
    var noaString = encodeObject(obj);

    var worker = new Worker('./polling.js');
    worker.postMessage(noaString); // ### worker に命令書 noaString を送る ###

    //_initDebug(true); //##

    worker.onmessage = function (event) {
        // ### worker の処理したデータを受け取る ###
        var answer = event.data; // ### worker からの返答 ###
        var array = answer.split("<SEPARATOR>");
        if (array.length > 1){
            var obj = JSON.parse(array[1]);
            var records = obj.records; // 本日の日計表レコード
            var messageArray = obj.message; // メッセージ・オブジェクト
            
            // 他アプリからのメッセージを表示
            if (messageArray && (messageArray.length > 0)){
                //var found = false;
                for (num in messageArray){
                    var rec = messageArray[num];
                    //alert(encodeObject(rec)); //##
                    
                    var ary = rec.receiver.split("@");
                    var receiver = ary[0];
                    var app = ary[1];
                    if ((receiver == owner()) && (app == "NOA")){
                        showMessenger(rec); // neuron.js
                    }
                }
            }
            
            // 本日の「受診者ポップアップ・タグ」を表示
            if (noCheckWaiting() == 0){
                var elm = document.getElementById("pollingArea");
                elm.innerHTML = "";
                var div = newDIV(elm, "");
                var now = today();
                
                for (num in records){
                    var rec = records[num];
                    var etime = rec.endTime; // 診察終了時刻
                    
                    // 本日のものだけをポップアップ表示
                    if (! isSameDate(rec.entryDate, now)) continue;
                    
                    // 日時でなく年月日で比較
                 //   if (rec.entryDate > rec.updateTime){
                    if (shortDate(rec.entryDate) > shortDate(rec.updateTime)){
                        var sp = newSPAN(div, "/reserved-patient-tab");
                        sp.innerHTML = rec.patientId + " " + rec.kanjiName;
                        // 予約日時で新規ページ追加するかどうか尋ねる
                        if (isAddReservedPage() * 1 > 0){ // localStorage.js
                            // ページ追加
                            var action = open_action(rec.patientId, rec.reservedDate);
                        } else {
                            // ページ追加せず参照のみ
                            var action = open_action(rec.patientId);
                        }
                        sp.setAttribute("onclick", action);
                    } else if (etime && (etime.toString().length > 0)) {
                        // 診療終了したものは表示しない
                    } else {
                        // 診療終了していないものだけを拾い出す：新規ページを追加
                        var sp = newSPAN(div, "/waiting-patient-tab");
                        sp.innerHTML = rec.patientId + " " + rec.kanjiName;
                        var action = open_action(rec.patientId, 'addPage');
                        sp.setAttribute("onclick", action);
                    }
                }
            }
            
            // 待受リストを更新
            refleshWaitingList(records);
        }
        
        function open_action(pid, addPage){
            // カルテを開くアクションを返す
            if (openEachNOA() > 0){ // localStorage.js
                var url = "window.open('top.php";
                url += "?patientId=" + pid;
                if (addPage) 
                    url += "&addPageFlag=" + addPage;
                url += "')";
                
                return url;
            } else {
                if (addPage)
                    return "openChart('" + pid + "','" + addPage + "')";
                else
                    return "openChart('" + pid + "')";
            }
        }
    }
}

//////////////////////////////////////////////////////////////
///// TEXT SEARCH ////////////////////////////////////////////

function search(){
    // カルテ本文中の検索を実行
    var key = document.getElementById("searchF").value;
    if (!key) return;
    
    if (isDigit(key) && (key.length == 8)){
        // 検索キーが８文字の数値だった場合は「カルテ検索」
        if (confirm(key + " のカルテを検索しますか")){
            getPatients(key);
            return;
        }
    }
    
    var count = searchRecord(key);
    
    // キーが最初にみつかったページを画面上端に表示
    jumpToKey(-1);
    
    if (count >0)
        alert(key + " が ( " + count + " 件 ) みつかりました。黄色い該当部分をクリックすると次の該当部分へジャンプします");
    else
        alert(key + " に該当する文言は、このカルテ中にありません");
}

//////////////////////////////////////////////////////////////
///// 検索結果をヘッダー上部に表示 ////////////////////////////////

function closeWorkArea(){
    // 患者リストを閉じる：search 関連から呼ばれる
    var elm = elmFor("workArea");
    elm.innerHTML = "";
}

function gotPatientList(answer){
    // searchKey に相当するカルテのリストを表示
	var records = JSON.parse(answer);
    //console.log("== gotPatientList", encodeObject(records)); //##
    
    // TOOL AREA の workArea に結果を表示
    var elm = elmFor("workArea");
    elm.innerHTML = "";
    
	var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "10pt";
    tbl.style.margin = "2px";
    
	var tr = newTR(tbl, "", "");
    tr.style.backgroundColor = "#eee";
	var td = newTD(tr, "", "");
    td.style.width = "150px";
	var im = newIMAGE(td, "icon", "./close.png", "?");
    im.style.height = "12px";
	im.setAttribute("onclick", "closeWorkArea()");
    im.setAttribute("class", "expandIcon");
    var sp = newSPAN(td, "");
    sp.innerHTML = "最終受診日";
    sp.style.paddingLeft = "5px";
    td.style.paddingLeft = "5px";
	var td = newTD(tr, "", "カルテID");
    td.style.width = "100px";
	var td = newTD(tr, "", "氏名");
	
    var srcObj = new Object();
	var patientId, name;
	var count = records.length;
    for (r in records){
		var rec = records[r];
		var kanji = (rec.patientKanjiName) ? rec.patientKanjiName : "";
		patientId = rec.patientId;
        name = kanji;
		var romaji = (rec.patientRomajiName) ? rec.patientRomajiName : "";
		var lvd = (rec.lastVisitDate) ? rec.lastVisitDate : "";
        
        srcObj[rec.patientId] = lvd;
        
		var tr = newTR(tbl, "/record", "");
		tr.setAttribute("onclick", "parent().openChart('" + rec.patientId + "')");
		var td = newTD(tr, "", lvd);
        var td = newTD(tr, "", rec.patientId);
        td.style.paddingLeft = "5px";
		var td = newTD(tr, "", kanji);
	}
    // listMaker へ渡す情報を localStorage に記憶
    setListMakerSrc(srcObj); 
    
	var tr = newTR(tbl, "", "");
    tr.style.backgroundColor = "#ddd";
	var td = newTD(tr, "", "");
    td.style.paddingLeft = "5px";
	td.setAttribute("colspan", "3");
    // listMaker を立ち上げるボタンを生成
    var img = newIMAGE(td, "outArrow", "./outArrow.png", "?");
    img.style.height = "14px";
    img.setAttribute("onclick", "openListMaker()");
    img.setAttribute("class", "expandIcon");
    setInfoTip("outArrow", "検索結果を別パネルで詳細表示"); // INFO
    var sp = newSPAN(td, "");
    sp.innerHTML = records.length + " 件 みつかりました";
    sp.style.paddingLeft = "5px";
    
	if (count == 1){
		// 検索結果が１件のみなら直ちにそのカルテを開く
		parent().openChart(patientId);
	}
}

//////////////////////////////////////////////////////////////
///// ヘッダーにアイコン・ギャラリーを表示 //////////////////////////

function showHeaderIcons(toolMenus){
    //function showIconBar(){
    // ヘッダーにアイコン・ギャラリーを表示
    var div = document.getElementById("toolIconArea");
    div.innerHTML = "";
    
    // ### 工場出荷状態だと toolMenus が 空配列 ###
    if (!toolMenus || (toolMenus.length == 0)) toolMenus = menuTemplate();
    
    //alert("showHeaderIcons->"+encodeObject(toolMenus)); //continue; //##
    
    var ul = newUL(div, "/listMembers");
    for (num in toolMenus){
        var cell = toolMenus[num];
        
        if (cell.menuType * 1 != _main) continue;
        if (cell.disabled * 1) continue;
        if (cell.subTitle * 1) continue;
        //alert("cell->"+encodeObject(cell)); //continue; //##
        
        // メニュー項目を生成
        var li = newLI(ul, "", cell.id + "/listMemberIcon");
        
        if (cell.url == "search()"){
            // cell.editor に infoTip に表示する内容が入っている
            setInfoTip(cell.id, cell.editor); // HELP
            
            // これだけは特別扱い
            var dv = newDIV(li, "/searchFrame");
            var fd = newFIELD(dv, "searchF", "", 15, "");
            setInfoTip(cell.id, "このカルテ内の文言検索<br> または<br>カルテIDによるカルテ検索"); // HELP
            fd.setAttribute("class", "searchField");
            fd.setAttribute("onchange", "search()");
            var bt = newSPAN(dv, "/searchButton");
            bt.innerHTML = "検索";
            bt.setAttribute("onclick", "search()");
        } else if (cell.icon){
            // ICON があれば ICON を表示
            // cell.editor に infoTip に表示する内容が入っている
            setInfoTip(cell.id, cell.editor); // HELP
            var img = newIMAGE(li, "", cell.icon, "icon");
            img.style.margin = "0 5px"; // ボタン間隔
            img.style.height = "15px";
            var action = "kickMenuCell('"+cell.url+"','"+cell.window+"',this)";
            img.setAttribute("onclick", action);
            img.setAttribute("class", "expandIcon");
        } else {
            // アンカー表示
            // cell.editor に infoTip に表示する内容が入っている
            setInfoTip(cell.id, cell.editor); // HELP
            var bt = newDIV(li, "/greenButton");
            bt.innerHTML = cell.label;
            bt.style.position = "relative";
            bt.style.bottom = "1px"; // ボタン位置調整
            if (cell.url){
                var action = "kickMenuCell('"+cell.url+"','"+cell.window+"',this)";
                bt.setAttribute("onclick", action);
            }
        }
    }
    
    // HELP
    var li = newLI(ul, "", "noaHelp/listMemberIcon");
    setInfoTip("noaHelp", "HELP"); // HELP
    var img = newIMAGE(li, "", "help.png", "icon");
    img.style.height = "17px";
    img.setAttribute("onclick", "openHelp('./noaHelp.html')");
    img.setAttribute("class", "expandIcon");
    
    // TOOL MENU
    var li = newLI(ul, "", "gearIcon/listMemberIcon");
    setInfoTip("gearIcon", "Tool Menu"); // HELP
    var img = newIMAGE(li, "", "gear.png", "icon");
    img.style.height = "17px";
    img.setAttribute("onclick", "openToolPane()");
    img.setAttribute("class", "expandIcon");
}

// ###########################################
// ### FireFox 系ブラウザのイベント操作に必要 ######
var _Event = null;
document.onkeyup = function(e){
    　_Event = null;
}
document.onkeydown = function(e){
    　_Event = e;
}
function isShiftDown(){
    // shift が押されていれば true を返す
    var shift;
    
    if (_Event != null){
        shift = _Event.shiftKey;
    } else {
        if (navigator.userAgent.indexOf('Firefox', 0) == -1)
            shift = event.shiftKey;
        else
            shift = false;
    }
    return shift;
}
function eventKeyCode(){
    // keyCode 返す
    if (_Event != null){
        return _Event.keyCode;
    }
    return null;
}
// ### FireFox 系ブラウザのイベント操作に必要 ######
// ###########################################


//////////////////////////////////////////////////////////////
///// login した後の NOA を初期化 ///////////////////////////////

function startupedNOA(answer){
    // NOA が起動された
    var obj = JSON.parse(answer);
    // レイアウトを設定：ページが開かれた時に使われる
    setLayoutObj(obj.layout); 
    // 施設情報を記憶
    setHospitalInfo(obj.hospitalInfo);
    // ツール・メニュー構造を記憶
    setToolMenus(obj.toolMenus);
    // 一括処理設定があれば取得
    setCalls(obj.calls);
    // 基準値を取得
    setStandardList(obj.standard); // standardCenter.js
    
    // ヘッダーにアイコン・ギャラリーを表示
    showHeaderIcons(obj.toolMenus); 
    
    // 初心者用に NOA ヘルプを表示
    if (showHelp() == 0) openHelp('./noaHelp.html'); 
    
    // DB をチェック：戻値は無し
    NRCall("CHECK_DB"); // dbName, tableName, fieldName の有無をチェック
    
    // FRONT での新規受付患者をチェック
    pollingWORK(); 
    
    // URL に patientId が指定されていればカルテを開く：waitingList などから使われる
    setCurrentDate(null); // addPage で比較のため使用
    openChart(suppliedPatientId(), (addPageFlag()) ? 'addPage' : null);
}
function initNOA() {
    //_initDebug(true); //##
    var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // === HEADER =============================
    var div = newDIV(elm, "/title-bar");
    // --- LEFT SIDE ---------------
    var dv = newDIV(div, "patientIdArea/left-side"); // PatientId AREA
    dv.style.width = "110px"; //##
    // --- RIGHT SIDE ---------------
    var dv = newDIV(div, "toolIconArea/right-side"); // 周辺ツール・アイコン表示エリア
    dv.style.paddingRight = "10px";
    
    // === BODY ==============================
    var div = newDIV(elm, "");
    var tbl = newTABLE(div, "/base-table");
    var tr = newTR(tbl, "", "");
    // CALENDAR AREA -------------------
    var td = newTD(tr, "calendarArea", ""); // width は openCalendar() で設定
    // CHART AREA ----------------------
    var td = newTD(tr, "contents", "");
    td.style.clear = "both";
    td.setAttribute("class", "pastColor");
    // 設定された高さを画面スクロール範囲とする
    var val = overFlowHeight();
    if (val >= 100){
        div.style.height = val + "px";
        div.style.overflow = "auto";
    }
    
    // === FOOTER ============================
    var div = newDIV(elm, "/title-bar");
    // LEFT-SIDE
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = hospitalName() + " ( 取扱者 " + userName() + " )";
    dv.style.width = "500px";
    // RIGHT-SIDE
    var dv = newDIV(div, "version/right-side");
    dv.innerHTML = version();
    
    // NOA のレイアウト・ツールメニュー・ヘッダーアイコン・HospitalInfo をリクエスト
    var args = new Object();
    args["owner"] = owner();
    args["hospitalId"] = hospitalId();
    NRCall("STARTUP_NOA", args, startupedNOA);
}

function version(){
	return "Ver.140819";
}
