<?php

function wareki($currentDate){
	if (strlen(trim($currentDate)) == 0) return "";
	
	$ary = explode(" ", $currentDate);
	$array = explode("-", $ary[0]);
	$yy = $array[0] * 1;
	$mm = $array[1] * 1;
	$dd = $array[2] * 1;
	if ($yy == 0) return "";
	
	if ($yy > 1988){
		$yy -= 1988;
		$nengou = "平成".$yy;
	}
	else if ($yy > 1925) {
		$yy -= 1925;
		$nengou = "昭和".$yy;
	}
	else if ($yy > 1911) {
		$yy -= 1911;
		$nengou = "大正".$yy;
	}
	else {
		$yy -= 1867;
		$nengou = "明治".$yy;
	}
	return "$nengou年 $mm月 $dd日";
//	$st = $nengou."年".$mm."月".$dd."日";
//	return mb_convert_encoding($st, "SJIS", "UTF-8");
}

function age($bdate, $currentDate){
    $yyyy = substr($bdate, 0, 4);
	$mm = substr($bdate, 5, 2);
	$dd = substr($bdate, 8, 2);
	$bday = "$yyyy$mm$dd" - 0;
    
	$yyyy1 = substr($currentDate, 0, 4);
	$mm1 = substr($currentDate, 5, 2);
	$dd1 = substr($currentDate, 8, 2);
	$now = "$yyyy1$mm1$dd1" - 0;

	return floor(($now - $bday) / 10000);
}

function ageOf($pid, $dateTime){
    // $patientId の $dateTime における年令を返す
    $query = "SELECT * FROM `PatientTable` WHERE `patientId`='$pid'";
    $result=mysql_query($query);
    if ($row=mysql_fetch_array($result)){
        $birthDate = $row['birthDate'];
        return age($birthDate, $dateTime);
    }
    return "";
}
    
function showDayTitle($date){
	$yy1 = substr($date, 0, 4);
	$mm1 = substr($date, 5, 2);
	$dd1 = substr($date, 8, 2);
	$hour = substr($date, 11, 2);
	$min = substr($date, 14, 2);
	$sec = substr($date, 17, 2);
	$time = mktime($hour, $min, $sec, $mm1, $dd1, $yy1);
	$w = date("w", $time);
	$weeks = array("日","月","火","水","木","金","土");
	$week = $weeks[$w];
//	$week = mb_convert_encoding($weeks[$w], "SJIS", "UTF-8");
	return date("Y-m-d", $time)." ($week) ".date("H:i:s", $time);
}
	
function foldCount($buff){
	// 改行された行数を返す
	$array = explode("\n", $buff);
	return count($array);
}
	
/////////////////////////////
// DB アクセス ///////////////

// DB を開いて該当レコードを読み込む
function openDB(){
	$db=mysql_connect("localhost","root","root") or error_func();
	$db_select=mysql_select_db("NOA");
	mysql_query("set names utf8");
}
    
    function isFirstVisit($patientId, $entryDate){
        // 今月初めての受診なら TRUE を返す
        $yearAndMonth = substr($entryDate, 0, 7);
		$query = "SELECT * FROM `ProgressSection` WHERE `patientId`='$patientId' AND `entryDate`<='$entryDate' AND (`freq` IS NULL OR `freq`<1) ORDER BY `entryDate` DESC";
        $result=mysql_query($query);
        $count = 0;
        $buff = ""; //######
        while ($row=mysql_fetch_array($result)){
            $date = $row['entryDate'];
            $yymm = substr($date, 0, 7);
            if (strcmp($yymm, $yearAndMonth) != 0) break;
            // $entryDate と同じ年月ならカウントをインクリメント
            $count++;
        }
        return ($count == 1) ? TRUE : FALSE;
    }

function getValue($patientId, $entryDate, $tag, $isFirst){
    // $patientId, $entryDate, $tag に該当するレコードを DB から探し、$tag 対応値を返す
	$array = explode(".", $tag);
	$table = $array[0];
	$field = $array[1];
	$dateCondition 
	= "`entryDate`<='$entryDate' AND (`freq` IS NULL OR `freq`<1)"; // 過去履歴も印刷
	
	// 該当する診療行為（薬剤、処置名、など）を DB から取り出して返す
	if (strcmp($table, "UniversalSection") == 0){
		$query = "SELECT * FROM `UniversalSection` WHERE `patientId`='$patientId' AND $dateCondition AND `field`='$field' ORDER BY `entryDate` DESC";
		$field = "dataString"; // field を UniversalSection 用に置換
	} else if (strcmp($table, "PatientTable") == 0){
		$query = "SELECT * FROM `PatientTable` WHERE `patientId`='$patientId'";
	} else {
		$query = "SELECT * FROM `$table` WHERE `patientId`='$patientId' AND $dateCondition ORDER BY `entryDate` DESC";
	}
    
	$result=mysql_query($query);
	while ($row=mysql_fetch_array($result)){
		if (strlen($row[$field]) > 0){
            if ($isFirst){
                // 今月初めての受診なら無条件に表示
                return $row[$field];
//                return mb_convert_encoding($row[$field], "SJIS", "UTF-8");
            } else if (strcmp($table, 'NameSection') == 0){
                // NameSection は無条件に表示
                return $row[$field];
//                return mb_convert_encoding($row[$field], "SJIS", "UTF-8");
            } else if (strcmp($table, 'ProgressSection') == 0){
                // ProgressSection は無条件に表示
                return $row[$field];
//                return mb_convert_encoding($row[$field], "SJIS", "UTF-8");
            } else if (strcmp($entryDate, $row['entryDate']) == 0){
                // 本日更新されたデータのみ表示
                return $row[$field];
//                return mb_convert_encoding($row[$field], "SJIS", "UTF-8");
            }
        }
	}
	return "";
}

function getUserInfo($loginName, $tag){
	$array = explode(".", $tag);
	$table = $array[0];
	$field = $array[1];
	
	// 該当する診療行為（薬剤、処置名、など）を DB から取り出して返す
	$query = "SELECT * FROM `$table` WHERE `loginName`='$loginName'";
	$result=mysql_query($query);
	if (mysql_num_rows ($result) > 0){
		while ($row=mysql_fetch_array($result)){
			if ($row[$field])
                return $row[$field];
//				return mb_convert_encoding($row[$field], "SJIS", "UTF-8");
		}
	}
	return "*** $tag ***";
}

function codeName($code){
	$key = "/$code";
	$query = "SELECT `name` FROM `PriceList` WHERE `alias`='$key'";
	$result=mysql_query($query);
	if (mysql_num_rows ($result) > 0){
		$row=mysql_fetch_array($result);
		$codeAndName = $row['name'];
		if ($codeAndName){ // "11 初診" 形式から "初診" のみ取り出す
			$array = explode(" ", $codeAndName);
            return $array[1];
//			return mb_convert_encoding($array[1], "SJIS", "UTF-8");
		}
	}
	return $code;
}

function shohouFormat($value){
	// code^alias^name^point^unitName^min^standard^max^width^effect^memo|...
	// のような形式を処方フィールド形式にして返す
	$records = explode('|', $value);
	$count = count($records);
	$results = array();
	for ($i=0; $i < $count; $i++){
		$ln = trim($records[$i]);
		if (strlen($ln) == 0) continue;
		
		$array = explode('^', $ln);
		if (count($array) > 6){
			$code = $array[0];
			$name = $array[2];
			if ($code < 120){
				$unit = $array[6];
				$unitName = $array[4];
				$results[$i] = "$name ( $unit $unitName )";
			}
			else {
				$freq = $array[5];
				$unitName = $array[3];
				$results[$i] = "---------- $name ( $freq $unitName )";
			}
		}
		else
			return $value; // 処方フォーマットではないので、そのまま表示
	}
	return join("\n", $results);
}

function treatmentFormat($value){
	// 1_|_12_|_shosin_|_初診_|__|__|_273
	// isOenFee_|_code_|_alias_|_name_|_dose_|_unitName_|_point
	// のような形式を診療フィールド形式にして返す

	$records = explode("\n", $value);
	$count = count($records);
	for ($i=0; $i < $count; $i++){
		$ln = $records[$i];
		$array = explode("_|_", $ln);
		if (count($array) > 6){
			$isOwnFee = ($array[0]) ? " 自費" : "";
			$code = $array[1] * 1;
			$name = $array[3];
			$dose = $array[4];
			$unitName = trim($array[5]);
			$point = $array[6];
			$unit = ($unitName) ? "($dose $unitName)" : "";
			if ($code == 99){
				// "_|_99_|__|_合計[健保(686 x 3 = 2050)自費(5400)] 7450_|__|__|_"
				$records[$i] = $array[3];
			}
			else {
				$cd = codeName($code);
				$records[$i] = "$cd [".$name." ".$unit."] ".$point." ".$isOwnFee;
			}
		}
		else
			return $value; // 診療フォーマットではないので、そのまま表示
	}
	return join("\n", $records);
}

function get($patientId, $entryDate, $label, $tag, $option, $isFirst){
	$value = getValue($patientId, $entryDate, $tag, $isFirst);
	
	if (strcmp($tag, "ProgressSection.treatment") == 0)
		$value = treatmentFormat($value);
	else if (strcmp($tag, "ProgressSection.prescription") == 0)
		$value = shohouFormat($value);
	
	if (strcmp($option, "wareki") == 0) $value = wareki($value);
	
	return (strlen($label)) ? $label."($value) " : $value;
}

function noaCell($w, $pdf, $label, $tag, $option){
	$contents = trim(get("", $tag, $option, TRUE));
	if (strlen($contents) == 0) return;

	// "<BR/>" を改行に変換（処方欄などで必要）
	$contents = str_replace("<BR/>", "\n", $contents);
	$contents = str_replace("<br>", "\n", $contents);
    
    // 画像が埋め込まれている場合は画像変換
    // <IMG:../NOA_ARCHIVE/tmp/20110627072522.png> 形式
    // ##### IMAGE ##### //

	$pdf->SetFont(KOZMIN,'B', 7);
	
	// separator
	$x = $pdf->GetX(); $y = $pdf->GetY();
	$pdf->Line($x, $y, $x + $w, $y);
	
	// label
	$labelWidth = 12;
	$fieldHeight = 3.5;
	$pdf->SetXY($x, $y);
	$pdf->Cell($labelWidth, $fieldHeight, $label, 0, 0, 'L');
	
	// pregress note
	$pdf->MultiCell($w - $labelWidth, $fieldHeight, $contents, 0, 'L');
}

function hasUpdate($patientId, $entryDate, $table){
	// テーブルの中に当日更新されたものがあれば その数、なければ 0 を返す
	// 当月初めての受診なら 1 を返す
	$from = substr($entryDate, 0, 8)."01 00:00:00";
	$query = "SELECT * FROM `ProgressSection`
		WHERE `patientId`='$patientId'
		AND `entryDate`>'$from' AND `entryDate`<='$entryDate'";
	$result=mysql_query($query);
	$count = 0;
	while ($row=mysql_fetch_array($result)){ // entryDate の数をカウント
		if (strcmp($row['entryDate'], $edate) != 0)
			$count++;
		$edate = $row['entryDate'];
	}
	if ($count == 1) return 1;
	
	// テーブルの中に当日更新されたものがあれば、その数を返す
	$query = "SELECT * FROM `$table`
		WHERE `patientId`='$patientId' AND `entryDate`='$entryDate'";
	$result=mysql_query($query);
	
	return mysql_num_rows($result);
}
	
	
// DB アクセス 　　　　　　　　//
/////////////////////////////
	
	
	/////////////////////////
	//Print all pages ///////
	
	function modifiedString($st){
		// 文字列の事前処理
		$st = str_replace("<br/>", "\n", $st); // "<br>" を改行に変換
		return str_replace("<br>", "\n", $st); // "<br/>" を改行に変換
	}

	function entryDates($patientId){
		// entryDate,削除マーク,num を有するオブジェクトの入った array を返す
		// ## 表示は新しい日付順だが古い日付から event をピックアップする必要の
		// ## ある場合があるので、古い日付からサーチ。updateTime については
		// ## 最新のもののみをピックアップするので DESC で逆順に検索
		// # freq が 1 のレコードは削除されたレコード
		
		$sql = "SELECT * FROM `ProgressSection` WHERE `patientId`='$patientId' AND (`freq` IS NULL OR `freq`<1) ORDER BY `entryDate`,`updateTime` DESC";
		$result=mysql_query($sql);
		//echo "====== entryDates:<br/> $sql <br/><br/>";//###
		
		$array = array();
		$obj = array();
		if (mysql_num_rows ($result) > 0){
			$entryDate = ""; // これがないと１ページだけのカルテで誤動作
			for ($i=0; $row=mysql_fetch_array($result); $i++){
				// freq が 1 のレコードは削除か変更前のものなのでスキップ
				if ($row['freq'] * 1 > 0) continue; 
				
				$entryDate = $row['entryDate'];

				// 値が NULL だった場合、値は更新されず前回のままとする
				if (strlen($row['subject']) > 0)
					$obj['subject'] = modifiedString($row['subject']);
				if (strlen($row['object']) > 0)
					$obj['object'] = modifiedString($row['object']);
				if (strlen($row['examination']) > 0)
					$obj['examination'] = modifiedString($row['examination']);
				if (strlen($row['prescription']) > 0)
					$obj['prescription'] = modifiedString($row['prescription']);
				if (strlen($row['disease']) > 0)
					$obj['disease'] = modifiedString($row['disease']);
				if (strlen($row['assessment']) > 0)
					$obj['assessment'] = modifiedString($row['assessment']);
				if (strlen($row['plan']) > 0)
					$obj['plan'] = modifiedString($row['plan']);
				if (strlen($row['treatment']) > 0)
					$obj['treatment'] = modifiedString($row['treatment']);

			 $array[$entryDate] = $obj;
			}
		}
		return $array;
	}
	
	// Print all pages //////
	/////////////////////////


?>