
var drawFlag = false;
var hasInfomation;
var oldX = 0;
var oldY = 0;
var beginX;
var beginY;
var cursorh = 120; // = 80; // カーソルの初期値
var cursorw = 10; // カーソルの初期値

/*
var toolTypes = ["Pen","ToothPaste","Line","Text"];
var _toolType = toolTypes[0]; // default 値
function setToolType(type){
    _toolType = type;
    
    // 道具選択ボタンを再描画
    showToolSelector();
    
    if (_toolType == "Text"){
        var st = prompt("文字を入力");
        setText(st);
    }

    // インジケータに文字を表示
//    showIndicator();
}
function toolType(){
    // 道具の種類を返す
    return _toolType;
}
*/

var _text;
function setText(st){
    _text = st;
}
function text(){
    return _text;
}
/*
var colorList = {
	"black"   : {"r":0,"g":0,"b":0},
	"blue"    : {"r":0,"g":0,"b":255},
	"red"     : {"r":255,"g":0,"b":0},
	"orange"  : {"r":255,"g":165,"b":81},
	"magenta" : {"r":255,"g":0,"b":255},
	"green"   : {"r":0,"g":255,"b":0},
	"cyan"    : {"r":0,"g":255,"b":255},
	"yellow"  : {"r":255,"g":255,"b":0},
	"white"   : {"r":255,"g":255,"b":255}
}
function color(name){
    // 色を返す
    var obj = colorList[name];
    return "rgba(" + obj.r + "," + obj.g + "," + obj.b + "," + alpha() + ")";
}
*/
var _sketchCanvas;
function setSketchCanvas(can){
    _sketchCanvas = can; 
}
function sketchCanvas(){
    return _sketchCanvas;
}

var _sketchImage;
function setSketchImage(img){
    _sketchImage = img;
}
function sketchImage(){
    return _sketchImage;
}

var _sketchImageName;
function setSketchImageName(name){
    _sketchImageName = name;
}
function sketchImageName(){
    return _sketchImageName;
}

var _penSize = 1.9;
function changePenSize(){
    _penSize = penSizeBar.value * 1;
    showIndicator();
}
function penSize(){
    return _penSize;
}

var _penColor = "black";
function setPenColor(name){
    // カラーパレットから選択された色を penColor に設定
    _penColor = name;
    showIndicator();
    showColorPallete();
}
function penColor(flag){
    if (flag){
        // 透明度を反映しない
        var obj = colorList[_penColor];
        return "rgb(" + obj.r + "," + obj.g + "," + obj.b + ")";
    } else {
        // 透明度を反映
        return color(_penColor);
    }
}
function colorName(){
    // "white" などの色名を返す
    return _penColor;
}

var _alpha = 1;
function changeAlpha(){
    // 透明度を変える
    _alpha = alphaBar.value * 1;
    
    showIndicator();
}
function alpha(){
    // 透明度
    return _alpha;
}



///////////////////////////////////////////////////////////
///// localStorage ////////////////////////////////////////

function getSketchWindowSize(){
	// Picture tool のウインドー位置とサイズをサーバへリクエスト
    var size = window.localStorage["sketchPadWindowSize"];
    
	// サーバから得られたサイズにウインドーを調整する
	if (size){
		var args = size.split(",");
		var x = args[0] * 1;
		var y = args[1];
		var w = args[2];
		var h = args[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
        
        //alert("getSketchWindowSize->"+size); //##
	}
}
function putSketchWindowSize(){
	// Picture tool のウインドー位置とサイズをサーバへ記憶
    if (window.name != "tools"){
        // tool area で開いた場合はサイズを記憶しない
        var x = window.screenLeft;
        var y = window.screenTop - 22;
        var w = window.outerWidth;
        var h = window.outerHeight;
        var array = [x, y, w, h];
        window.localStorage["sketchPadWindowSize"] = array.join(",");
        
        showFadeoutInfo("messageArea", "ウィンドー・サイズを記憶しました", 800);
    }
}

///// localStorage ////////////////////////////////////////
///////////////////////////////////////////////////////////

function saveSketchImage(){
    // 画像をサーバへ保存
    
    // ウインドウ・サイズを記憶
    putSketchWindowSize();
    
    // 保存ボタンを消す
    hideSaveButton();

    // 画像をサーバへ保存
    var pictureTool = window.opener;
    
    //_initDebug(true); //##
    _debug("pictureTool->"+pictureTool); //##
    _debug("patientId->"+pictureTool.patientId()); //##
    
    var can = sketchCanvas();
    
    //pictureTool.setPaneType(2); // テスト用にスケッチの保存先を変更
    pictureTool.setImageSrc(can.toDataURL());
    
    pictureTool.saveImage();
}

///////////////////////
///// dragAndDrop /////

function sketchDrop(e, can){
    // el にドロップされた画像を描画
    var file = e.dataTransfer.files[0];
    if (!file) {
        alert('画像ファイルの実体がないのでドロップできません');
        return; // file の実体がないとドロップできない
    }
    
    if(!file.type.match(/image\/\w+/)){
        alert('画像ファイルしか受けつけられません');
        return;
    }
    
    setSketchImageName(file.name);
    
    var img = document.createElement("img");
    var reader = new FileReader(); 
    reader.onload = function(e) {
        img.src = e.target.result;
        if (img.src.indexOf('data:image/tiff;') >= 0)
            alert("TIFF 型式の画像はサポートされていません");
    }
    setSketchImage(img);
    
    // canvas へ描画
    img.onload = function() {
        var ctx = can.getContext("2d");
        
        // 再描画前に今までのイメージを消去
        ctx.clearRect(0, 0, can.width, can.height);
        
        // 画像を表示するクリッピング領域を設定
        var width = can.width;
        var height = can.height;
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(width, 0);
        ctx.lineTo(width, height);
        ctx.lineTo(0, height);
        ctx.clip();
        
        // 画像の高さが can.height に収まるよう縮尺して表示
        var w = sketchImage().width * can.height / sketchImage().height;
        ctx.drawImage(sketchImage(), 0, 0, w, height);  
    }
    reader.readAsDataURL(file);
    
    // 保存ボタンを表示
    if (img.src)
        showSaveButton();
}

///// dragAndDrop /////
///////////////////////

function clearDraw(){
    // 画面をクリアー
    var can = sketchCanvas();
    var context = can.getContext("2d");
    var w = can.width;
    var h = can.height;
    context.clearRect(0, 0, w, h);
    
    // 保存ボタンを消す
    hideSaveButton();
}

function showColorPallete(){
    // カラーパレットを表示
    var elm = elmFor("colorPalleteArea");
    elm.innerHTML = "";
    
    for (name in colorList){
        var dv = newDIV(elm, "/colorChip");
        dv.innerHTML = "　　"; // 倍角スペース：これがないとカラーチップの幅がでない
        dv.style.backgroundColor = color(name);
        dv.style.display = "inline";
        dv.setAttribute("onclick", "setPenColor('" + name + "')");
        if (name == colorName()){
            dv.setAttribute("class", "selectedColorChip");
        }
    }
}

function circle(context, x, y, diameter, color){
    // 円を描く
    var startAngle = 0;
    var endAngle = 360 * Math.PI / 180;
    context.fillStyle = color;
    context.beginPath();
    context.arc(x, y, diameter, startAngle, endAngle, false);
    context.fill();
}

function rectangle(context, x, y, w, h, fillColor){
    // 矩形を描く
    context.strokeStyle = color("black");
    context.beginPath();
    // context.lineWidth = lineWidth;
    context.rect(x, y, w, h);
    context.closePath();
    context.stroke();
    if (fillColor){
        context.fillStyle = fillColor;
        context.fill();
    }
}

function drawLine(x, y){
    // beginX,beginY から x,y へ線を引く
    var can = sketchCanvas();
    var context = can.getContext("2d");
    
    circle(context, beginX, beginY, 3, penColor()); // ドット・サイズ固定
    
    context.strokeStyle = penColor();
    context.lineWidth = 0.5;
    context.beginPath();
    context.moveTo(beginX, beginY);
    context.lineTo(x, y);
    context.closePath();
    context.stroke();
}

function drawText(text, x, y){
    // 文字を描く
    var can = sketchCanvas();
    var context = can.getContext("2d");
    context.font = fontSize() + "px 'Times New Roman'";
    context.fillStyle = penColor();
    context.fillText(text, x, y);
    
    function fontSize(){
        // 太さスライダーのサイズを元にフォント・サイズを返す
        // スライダー default 値 1.9 が 14pt になるように計算
        return Math.round(penSize() * 7.5);
    }
}

function complement(newX, newY){
    // x, y, oldX, oldY の距離が一定以上開いたら間を補完
    var range = penSize() / 5;
    var can = sketchCanvas();
    var context = can.getContext("2d");
    
    var xforward = (newX > oldX) ? true : false; // x 座標が前進するか否か
    var yforward = (newY > oldY) ? true : false;
    var xdistance = Math.abs(oldX - newX); // x 座標の移動距離
    var ydistance = Math.abs(oldY - newY);
    var len = Math.sqrt(Math.pow(xdistance,2) + Math.pow(ydistance,2));
    len = Math.round(len); // ２点間の距離
    var count = Math.round(len / range); // ２点間を補完する回数
    var sizex = xdistance / count; // １補完における x 座標の移動距離
    var sizey = ydistance / count;
    
    if (count > 1){
        var x = oldX;
        var y = oldY;
        circle(context, x, y, penSize(), penColor()); // begin
       
        for (var i=0; i < count; i++){
            x = (xforward) ? x + sizex : x - sizex;
            y = (yforward) ? y + sizey : y - sizey;
            circle(context, x, y, penSize(), penColor());
        }
       
        circle(context, x, y, penSize(), penColor()); // end
    }
}

function draw(e){
    if (!drawFlag) return;
    if (isTouchDevice()) e = e.touches[0];
    
    var x = e.clientX - cursorw;
    var y = e.clientY - cursorh;
    var can = sketchCanvas();
    var context = can.getContext("2d");
    context.strokeStyle = penColor();
    
    if (toolType() == "Pen"){
        circle(context, x, y, penSize(), penColor());
        //  complement(x, y);
    } else if (toolType() == "ToothPaste"){
        // ドットをカーソルで移動させる：ドットの軌跡は以前描かれたものを削除しつつ移動
        circle(context, oldX, oldY, penSize() - 1.2, color("white"));
        circle(context, x, y, penSize(), penColor());
    }
    
    oldX = x;
    oldY = y;
}

function showSaveButton(){
    // 保存ボタンを表示
    var elm = elmFor("saveSketchButtonArea");
    elm.innerHTML = "";
    var bt = newDIV(elm, "/redButton");
    bt.innerHTML = "保存";
    bt.setAttribute("onclick", "saveSketchImage()");
}
function hideSaveButton(){
    // 保存ボタンを消す
    var elm = elmFor("saveSketchButtonArea");
    elm.innerHTML = "";
}

/*function showToolSelector(){
    // 道具選択ボタンを表示
    var elm = elmFor("toolSelectorArea");
    elm.innerHTML = "";
    
    _debug("showToolSelector->"+toolType()); //##
    
    for (num in toolTypes){
        var type = toolTypes[num];
        var dv = newSPAN(elm, "");
        dv.innerHTML = type;
        dv.style.display = "inline";
        dv.style.padding = "0 10px";
        if (type == toolType())
            dv.setAttribute("class", "blueActiveButton");
        else
            dv.setAttribute("class", "blueButton");
        dv.setAttribute("onclick", "setToolType('" + type + "')");
    }
    
    var dv = newSPAN(elm, "/clearButton");
    dv.innerHTML = "白紙";
    dv.style.display = "inline";
    dv.style.padding = "0 10px";
    dv.setAttribute("onclick", "clearDraw()");
}*/

function sketchHelp(){
    // ヘルプを開く
	window.open("./sketchHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initDraw(){
    // Draw を初期化
    // スケッチ・パッドを表示
    var elm = elmFor("base");
    elm.innerHTML = "";   

    // HEADER ===============================
    var div = newDIV(elm, "/tool-header");
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    var sp = newSPAN(dv, "");
    sp.innerHTML = parent().patientId();
    sp.style.paddingLeft = "10px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = parent().patientKanjiName();
    sp.style.paddingLeft = "5px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = parent().currentDate();
    sp.style.paddingLeft = "15px";
    // --- ヘルプ・アイコン
    var dv = newDIV(div, "/right-side");
    var im = newIMAGE(dv, "", "./help.png", "?");
    im.setAttribute("onclick", "sketchHelp()");
    im.style.height = "18px";
    im.setAttribute("class", "expandIcon");
    
    // CONTROLLER ===========================
    var canvasWidth = 600;
    var canvasHeight = 600;
    var penAreaHeight = 80;
    var div = newDIV(elm, "controllerArea/clearfix");
    // PEN SIZE INDICATOR --------------
    var dv = newDIV(div, "/left-side");
    dv.style.padding = "0";
    dv.style.width = penAreaHeight + "px";
    dv.style.height = penAreaHeight + "px";
        
    var cvs = newCANVAS(dv, "indCanvas", penAreaHeight, penAreaHeight, draw);
    showIndicator(); // ペン・サイズ初期値を表示
    // CONTROLLER ----------------------
    var cdiv = newDIV(div, "");
    cdiv.style.width = canvasWidth + "px";
    cdiv.style.height = penAreaHeight;
    cdiv.style.border = "thin solid #ccc";
    cdiv.style.fontSize = "9pt";
    // UPPER CONTROLLER -------------
    var div = newDIV(cdiv, "");
    div.style.padding = "5px";
    // ペンのサイズ
    var sp = newSPAN(div, "");
    sp.innerHTML = "太さ";
    sp.style.paddingLeft = "10px";
    newSlider(div, "penSizeBar", 0.1, penSize(), 30, 0.1, "changePenSize()");
    // 透明度 
    var sp = newSPAN(div, "");
    sp.innerHTML = "透明度";
    sp.style.paddingLeft = "5px";
    newSlider(div, "alphaBar", 0.01, alpha(), 1, 0.01, "changeAlpha()");
    // MIDDLE CONTROLLER -----------
    var div = newDIV(cdiv, "");
    div.style.display = "inline";
    var sp = newSPAN(div, "");
    sp.innerHTML = "色　";
    sp.style.padding = "0 10px";
    // COLOR PALLETE
    var sp = newSPAN(div, "colorPalleteArea");
    showColorPallete();
    // LOWER CONTROLLER -------------
    //_initDebug(true); //##
    _debug("initDraw"); //##
    
    var div = newDIV(cdiv, "/clearfix");
    div.style.padding = "5px";
    var sp = newSPAN(div, "");
    sp.innerHTML = "道具";
    sp.style.padding = "0 10px";
    var sp = newSPAN(div, "toolSelectorArea");
    showToolSelector();

    // CANVAS ===============================
    var div = newDIV(elm, "controllerArea");
    div.innerHTML = "";
    // ### dragAndDrop ################
    var can = newCANVAS(div, "sketchCanvas", canvasWidth, canvasHeight, null);
    can.style.border = "thin solid #ccc";
    setSketchCanvas(can);
    
    /*// CANVAS に文字を表示しておく
    var context = can.getContext("2d");
    context.font = "12px 'Times New Roman'";
    context.fillStyle = "gray";
    context.textAlign = "center"; // width / 2 を中心にする
    context.fillText("ここに画像をドロップ", canvasWidth / 2, canvasHeight / 2 + 6); 
    hasInfomation = true; // コメント表示あり
     */
  
    can.ondrop=function(e){
        sketchDrop(e, can);
        e.preventDefault();
    };
    
    can.ondragover=function(e){
        e.preventDefault();
    };
    
    // FOOTER ===============================
    var div = newDIV(elm, "/tool-footer");
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = version();
    // 保存ボタン・エリア
    var dv = newDIV(div, "/right-side");
    var sp = newSPAN(dv, "saveSketchButtonArea");
    
    
    getSketchWindowSize();
}

window.addEventListener("load", function(){
                        // イベント・リスナーを初期化
                        // window.onload と window.addEventListener はどちらが
                        // 先に起動されるかわからないので夫々に initDraw() を設定
                        initDraw(); // 画面初期化はここで実行
                        
                        var can = sketchCanvas();
                        can.addEventListener("mousemove", draw, true);
                        can.addEventListener("mousedown", function(e){
                                             drawFlag = true;
                                             beginX = e.clientX - cursorw;   
                                             beginY = e.clientY - cursorh;
                                             oldX = beginX;
                                             oldY = beginY;
                                             }, false);
                        can.addEventListener("mouseup", function(e){
                                             drawFlag = false;
                                             var x = e.clientX - cursorw;   
                                             var y = e.clientY - cursorh; 
                                             if (toolType() == "Line"){
                                             drawLine(x, y);
                                             } else if (toolType() == "Text"){
                                             drawText(text(), x, y);
                                             }
                                             
                                             // 保存ボタンを表示
                                             showSaveButton();
                                             }, false);
                        }, true);


function version(){
    return "Ver.140308";
}